/* Generated by Pyrex 0.9.5.1a on Tue Oct 16 21:22:46 2007 */

#include "Python.h"
#include "structmember.h"
#ifndef PY_LONG_LONG
  #define PY_LONG_LONG LONG_LONG
#endif
#ifdef __cplusplus
#define __PYX_EXTERN_C extern "C"
#else
#define __PYX_EXTERN_C extern
#endif
__PYX_EXTERN_C double pow(double, double);
#include "stdlib.h"


typedef struct {PyObject **p; char *s;} __Pyx_InternTabEntry; /*proto*/
typedef struct {PyObject **p; char *s; long n;} __Pyx_StringTabEntry; /*proto*/

static PyObject *__pyx_m;
static PyObject *__pyx_b;
static int __pyx_lineno;
static char *__pyx_filename;
static char **__pyx_f;

static char __pyx_mdoc[] = "\nThis module provides some functions for collision detection.\n";

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name); /*proto*/

static int __Pyx_InternStrings(__Pyx_InternTabEntry *t); /*proto*/

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t); /*proto*/

static void __Pyx_AddTraceback(char *funcname); /*proto*/

/* Declarations from rabbyt.collisions */

enum __pyx_t_6rabbyt_10collisions__Side {
  __pyx_e_6rabbyt_10collisions_LEFT = 1,
  __pyx_e_6rabbyt_10collisions_RIGHT = 2
};

enum __pyx_t_6rabbyt_10collisions__Axis {
  __pyx_e_6rabbyt_10collisions_X = 1,
  __pyx_e_6rabbyt_10collisions_Y = 2
};

struct __pyx_t_6rabbyt_10collisions_side_s {
  float x;
  float y;
  enum __pyx_t_6rabbyt_10collisions__Side side;
  int index;
};

struct __pyx_t_6rabbyt_10collisions_collision_object_s {
  float x;
  float y;
  float brs;
};

static int __pyx_k3;
static int __pyx_k4;
static int (__pyx_f_6rabbyt_10collisions__compar_sides_x(void (*),void (*))); /*proto*/
static int (__pyx_f_6rabbyt_10collisions__compar_sides_y(void (*),void (*))); /*proto*/
static void (__pyx_f_6rabbyt_10collisions__rdc(struct __pyx_t_6rabbyt_10collisions_side_s (*(*)),int ,enum __pyx_t_6rabbyt_10collisions__Axis ,int ,int ,int )); /*proto*/
static PyObject *(__pyx_f_6rabbyt_10collisions__brute_force(struct __pyx_t_6rabbyt_10collisions_collision_object_s (*),int ,PyObject *)); /*proto*/


/* Implementation of rabbyt.collisions */

static char (__pyx_k1[]) = "\nCopyright (C) 2007  Matthew Marshall\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the \"Software\"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in\nall copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\nTHE SOFTWARE.\n";
static char (__pyx_k2[]) = "Matthew Marshall <matthew@matthewmarshall.org>";
static char (__pyx_k5[]) = "collide rdc brute_force";

static PyObject *__pyx_n___credits__;
static PyObject *__pyx_n___author__;
static PyObject *__pyx_n_collide;
static PyObject *__pyx_n_rdc;
static PyObject *__pyx_n_brute_force;
static PyObject *__pyx_n___docs_all__;
static PyObject *__pyx_n_split;

static PyObject *__pyx_k1p;
static PyObject *__pyx_k2p;
static PyObject *__pyx_k5p;

static PyObject *__pyx_n_min_split;
static PyObject *__pyx_n_len;
static PyObject *__pyx_n_extend;


static PyObject *__pyx_f_6rabbyt_10collisions_collide(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_6rabbyt_10collisions_collide[] = "\n    ``collide(objects) -> list of collisions``\n\n    Collides ``objects``, first using ``rdc()`` and then using\n    ``brute_force()``.\n\n    Each object should have the attributes ``x``, ``y``, ``bounding_radius``,\n    and ``bounding_radius_squared``.\n    ";
static PyObject *__pyx_f_6rabbyt_10collisions_collide(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_objects = 0;
  PyObject *__pyx_v_collisions;
  PyObject *__pyx_v_group;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  int __pyx_5;
  PyObject *__pyx_6 = 0;
  static char *__pyx_argnames[] = {"objects",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_objects)) return 0;
  Py_INCREF(__pyx_v_objects);
  __pyx_v_collisions = Py_None; Py_INCREF(Py_None);
  __pyx_v_group = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":50 */
  __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 50; goto __pyx_L1;}
  Py_DECREF(__pyx_v_collisions);
  __pyx_v_collisions = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":51 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_rdc); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 51; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 51; goto __pyx_L1;}
  Py_INCREF(__pyx_v_objects);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_objects);
  __pyx_3 = PyDict_New(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 51; goto __pyx_L1;}
  __pyx_4 = PyInt_FromLong(10); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 51; goto __pyx_L1;}
  if (PyDict_SetItem(__pyx_3, __pyx_n_min_split, __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 51; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  __pyx_4 = PyEval_CallObjectWithKeywords(__pyx_1, __pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 51; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_1 = PyObject_GetIter(__pyx_4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 51; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  for (;;) {
    __pyx_2 = PyIter_Next(__pyx_1);
    if (!__pyx_2) {
      if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 51; goto __pyx_L1;}
      break;
    }
    Py_DECREF(__pyx_v_group);
    __pyx_v_group = __pyx_2;
    __pyx_2 = 0;

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":52 */
    __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_len); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 52; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 52; goto __pyx_L1;}
    Py_INCREF(__pyx_v_group);
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_group);
    __pyx_2 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 52; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_3 = PyInt_FromLong(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 52; goto __pyx_L1;}
    if (PyObject_Cmp(__pyx_2, __pyx_3, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 52; goto __pyx_L1;}
    __pyx_5 = __pyx_5 > 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    if (__pyx_5) {

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":53 */
      __pyx_4 = PyObject_GetAttr(__pyx_v_collisions, __pyx_n_extend); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 53; goto __pyx_L1;}
      __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_n_brute_force); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 53; goto __pyx_L1;}
      __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 53; goto __pyx_L1;}
      Py_INCREF(__pyx_v_group);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_group);
      __pyx_6 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 53; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 53; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_2, 0, __pyx_6);
      __pyx_6 = 0;
      __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 53; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      goto __pyx_L4;
    }
    __pyx_L4:;
  }
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":54 */
  Py_INCREF(__pyx_v_collisions);
  __pyx_r = __pyx_v_collisions;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_6);
  __Pyx_AddTraceback("rabbyt.collisions.collide");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_collisions);
  Py_DECREF(__pyx_v_group);
  Py_DECREF(__pyx_v_objects);
  return __pyx_r;
}

static int __pyx_f_6rabbyt_10collisions__compar_sides_x(void (*__pyx_v_p1),void (*__pyx_v_p2)) {
  float __pyx_v_x1;
  float __pyx_v_x2;
  int __pyx_r;
  int __pyx_1;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":72 */
  __pyx_v_x1 = ((((struct __pyx_t_6rabbyt_10collisions_side_s (*(*)))__pyx_v_p1)[0])[0]).x;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":73 */
  __pyx_v_x2 = ((((struct __pyx_t_6rabbyt_10collisions_side_s (*(*)))__pyx_v_p2)[0])[0]).x;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":74 */
  __pyx_1 = (__pyx_v_x1 < __pyx_v_x2);
  if (__pyx_1) {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":75 */
    __pyx_r = (-1);
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_x1 > __pyx_v_x2);
  if (__pyx_1) {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":77 */
    __pyx_r = 1;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":79 */
    __pyx_r = 0;
    goto __pyx_L0;
  }
  __pyx_L2:;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static int __pyx_f_6rabbyt_10collisions__compar_sides_y(void (*__pyx_v_p1),void (*__pyx_v_p2)) {
  float __pyx_v_y1;
  float __pyx_v_y2;
  int __pyx_r;
  int __pyx_1;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":83 */
  __pyx_v_y1 = ((((struct __pyx_t_6rabbyt_10collisions_side_s (*(*)))__pyx_v_p1)[0])[0]).y;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":84 */
  __pyx_v_y2 = ((((struct __pyx_t_6rabbyt_10collisions_side_s (*(*)))__pyx_v_p2)[0])[0]).y;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":85 */
  __pyx_1 = (__pyx_v_y1 < __pyx_v_y2);
  if (__pyx_1) {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":86 */
    __pyx_r = (-1);
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_y1 > __pyx_v_y2);
  if (__pyx_1) {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":88 */
    __pyx_r = 1;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":90 */
    __pyx_r = 0;
    goto __pyx_L0;
  }
  __pyx_L2:;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static PyObject *__pyx_n_bounding_radius;
static PyObject *__pyx_n_x;
static PyObject *__pyx_n_y;
static PyObject *__pyx_n_append;

static PyObject *__pyx_f_6rabbyt_10collisions_rdc(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_6rabbyt_10collisions_rdc[] = "\n    ``rdc(objects, [max_depth,] [min_split]) -> list of collision groups``\n\n    Uses the Recursive Dimensional Clustering algorithm to find groups of\n    colliding objects.\n\n    ``objects`` should be a list of objects.  Each object should have the\n    attributes ``x``, ``y``, and ``bounding_radius``.\n\n    If the number of objects in a collision group is less than ``min_split``,\n    recursion will stop.  This defaults to ``1``, but in practice, it is\n    usually faster to just use a brute force method once a group gets down\n    to ``10`` objects.\n\n    ``max_depth`` is the maximum number of recursions to make.  It defaults to\n    ``0``, which is infinite.\n\n    Instead of returning individual collisions, ``rdc()`` returns groups\n    (lists) of colliding objects.  For example, if ``A`` collides with ``B``\n    and ``B`` collides with ``C``, one of the groups will be ``[A, B, C]``,\n    even though ``A`` and ``C`` don\'t directly collide.\n\n    Also, each object is returned at most once.  If it is in one group, it won\'t\n    be in any other.  An object without any collisions isn\'t returned at all.\n    ";
static PyObject *__pyx_f_6rabbyt_10collisions_rdc(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_objects = 0;
  int __pyx_v_min_split;
  int __pyx_v_max_depth;
  struct __pyx_t_6rabbyt_10collisions_side_s (*__pyx_v_side_list);
  struct __pyx_t_6rabbyt_10collisions_side_s (*(*__pyx_v_side_p_list));
  int __pyx_v_length;
  int __pyx_v_i;
  int __pyx_v_d;
  float __pyx_v_r;
  float __pyx_v_x;
  float __pyx_v_y;
  PyObject *__pyx_v_o;
  PyObject *__pyx_v_groups;
  PyObject *__pyx_v_current_group;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  long __pyx_5;
  float __pyx_6;
  static char *__pyx_argnames[] = {"objects","min_split","max_depth",0};
  __pyx_v_min_split = __pyx_k3;
  __pyx_v_max_depth = __pyx_k4;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O|ii", __pyx_argnames, &__pyx_v_objects, &__pyx_v_min_split, &__pyx_v_max_depth)) return 0;
  Py_INCREF(__pyx_v_objects);
  __pyx_v_o = Py_None; Py_INCREF(Py_None);
  __pyx_v_groups = Py_None; Py_INCREF(Py_None);
  __pyx_v_current_group = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":123 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_len); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 123; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 123; goto __pyx_L1;}
  Py_INCREF(__pyx_v_objects);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_objects);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 123; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_1 = PyInt_FromLong(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 123; goto __pyx_L1;}
  __pyx_2 = PyNumber_Multiply(__pyx_3, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 123; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_4 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 123; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_v_length = __pyx_4;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":125 */
  __pyx_v_side_list = ((struct __pyx_t_6rabbyt_10collisions_side_s (*))malloc(((sizeof(struct __pyx_t_6rabbyt_10collisions_side_s )) * __pyx_v_length)));

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":126 */
  __pyx_v_side_p_list = ((struct __pyx_t_6rabbyt_10collisions_side_s (*(*)))malloc(((sizeof(struct __pyx_t_6rabbyt_10collisions_side_s (*))) * __pyx_v_length)));

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":127 */
  /*try:*/ {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":128 */
    __pyx_5 = (__pyx_v_length / 2);
    for (__pyx_v_i = 0; __pyx_v_i < __pyx_5; ++__pyx_v_i) {

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":129 */
      __pyx_3 = PyInt_FromLong(__pyx_v_i); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 129; goto __pyx_L3;}
      __pyx_1 = PyObject_GetItem(__pyx_v_objects, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 129; goto __pyx_L3;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_v_o);
      __pyx_v_o = __pyx_1;
      __pyx_1 = 0;

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":130 */
      __pyx_2 = PyObject_GetAttr(__pyx_v_o, __pyx_n_bounding_radius); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 130; goto __pyx_L3;}
      __pyx_6 = PyFloat_AsDouble(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 130; goto __pyx_L3;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_v_r = __pyx_6;

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":131 */
      __pyx_3 = PyObject_GetAttr(__pyx_v_o, __pyx_n_x); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 131; goto __pyx_L3;}
      __pyx_6 = PyFloat_AsDouble(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 131; goto __pyx_L3;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_v_x = __pyx_6;

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":132 */
      __pyx_1 = PyObject_GetAttr(__pyx_v_o, __pyx_n_y); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 132; goto __pyx_L3;}
      __pyx_6 = PyFloat_AsDouble(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 132; goto __pyx_L3;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_v_y = __pyx_6;

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":133 */
      (__pyx_v_side_list[(__pyx_v_i * 2)]).x = (__pyx_v_x - __pyx_v_r);

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":134 */
      (__pyx_v_side_list[(__pyx_v_i * 2)]).y = (__pyx_v_y - __pyx_v_r);

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":135 */
      (__pyx_v_side_list[(__pyx_v_i * 2)]).side = __pyx_e_6rabbyt_10collisions_LEFT;

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":136 */
      (__pyx_v_side_list[(__pyx_v_i * 2)]).index = __pyx_v_i;

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":137 */
      (__pyx_v_side_list[((__pyx_v_i * 2) + 1)]).x = (__pyx_v_x + __pyx_v_r);

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":138 */
      (__pyx_v_side_list[((__pyx_v_i * 2) + 1)]).y = (__pyx_v_y + __pyx_v_r);

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":139 */
      (__pyx_v_side_list[((__pyx_v_i * 2) + 1)]).side = __pyx_e_6rabbyt_10collisions_RIGHT;

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":140 */
      (__pyx_v_side_list[((__pyx_v_i * 2) + 1)]).index = __pyx_v_i;

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":142 */
      (__pyx_v_side_p_list[(__pyx_v_i * 2)]) = (&(__pyx_v_side_list[(__pyx_v_i * 2)]));

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":143 */
      (__pyx_v_side_p_list[((__pyx_v_i * 2) + 1)]) = (&(__pyx_v_side_list[((__pyx_v_i * 2) + 1)]));
    }

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":145 */
    __pyx_f_6rabbyt_10collisions__rdc(__pyx_v_side_p_list,__pyx_v_length,__pyx_e_6rabbyt_10collisions_X,0,__pyx_v_min_split,__pyx_v_max_depth);

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":147 */
    __pyx_2 = PyList_New(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 147; goto __pyx_L3;}
    Py_DECREF(__pyx_v_groups);
    __pyx_v_groups = __pyx_2;
    __pyx_2 = 0;

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":148 */
    __pyx_3 = PyList_New(0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 148; goto __pyx_L3;}
    Py_DECREF(__pyx_v_current_group);
    __pyx_v_current_group = __pyx_3;
    __pyx_3 = 0;

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":149 */
    __pyx_v_d = 0;

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":150 */
    for (__pyx_v_i = 0; __pyx_v_i < __pyx_v_length; ++__pyx_v_i) {

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":151 */
      __pyx_4 = (((__pyx_v_side_p_list[__pyx_v_i])[0]).side == __pyx_e_6rabbyt_10collisions_LEFT);
      if (__pyx_4) {

        /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":152 */
        __pyx_4 = (__pyx_v_d == 0);
        if (__pyx_4) {

          /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":156 */
          __pyx_4 = (((__pyx_v_side_p_list[__pyx_v_i])[0]).index == ((__pyx_v_side_p_list[(__pyx_v_i + 1)])[0]).index);
          if (__pyx_4) {

            /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":159 */
            __pyx_v_i = (__pyx_v_i + 1);

            /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":160 */
            goto __pyx_L7;
            goto __pyx_L11;
          }
          __pyx_L11:;
          goto __pyx_L10;
        }
        __pyx_L10:;

        /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":161 */
        __pyx_v_d = (__pyx_v_d + 1);

        /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":162 */
        __pyx_1 = PyObject_GetAttr(__pyx_v_current_group, __pyx_n_append); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L3;}
        __pyx_2 = PyInt_FromLong(((__pyx_v_side_p_list[__pyx_v_i])[0]).index); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L3;}
        __pyx_3 = PyObject_GetItem(__pyx_v_objects, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L3;}
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L3;}
        PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
        __pyx_3 = 0;
        __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L3;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        goto __pyx_L9;
      }
      /*else*/ {

        /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":164 */
        __pyx_v_d = (__pyx_v_d - 1);

        /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":165 */
        __pyx_4 = (__pyx_v_d == 0);
        if (__pyx_4) {

          /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":166 */
          __pyx_1 = PyObject_GetAttr(__pyx_v_groups, __pyx_n_append); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 166; goto __pyx_L3;}
          __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 166; goto __pyx_L3;}
          Py_INCREF(__pyx_v_current_group);
          PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_current_group);
          __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 166; goto __pyx_L3;}
          Py_DECREF(__pyx_1); __pyx_1 = 0;
          Py_DECREF(__pyx_2); __pyx_2 = 0;
          Py_DECREF(__pyx_3); __pyx_3 = 0;

          /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":167 */
          __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 167; goto __pyx_L3;}
          Py_DECREF(__pyx_v_current_group);
          __pyx_v_current_group = __pyx_1;
          __pyx_1 = 0;
          goto __pyx_L12;
        }
        __pyx_L12:;
      }
      __pyx_L9:;
      __pyx_L7:;
    }

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":168 */
    Py_INCREF(__pyx_v_groups);
    __pyx_r = __pyx_v_groups;
    goto __pyx_L2;
  }
  /*finally:*/ {
    int __pyx_why;
    __pyx_why = 0; goto __pyx_L4;
    __pyx_L2: __pyx_why = 3; goto __pyx_L4;
    __pyx_L3: {
      __pyx_why = 4;
      Py_XDECREF(__pyx_2); __pyx_2 = 0;
      Py_XDECREF(__pyx_3); __pyx_3 = 0;
      Py_XDECREF(__pyx_1); __pyx_1 = 0;
      PyErr_Fetch(&__pyx_2, &__pyx_3, &__pyx_1);
      __pyx_4 = __pyx_lineno;
      goto __pyx_L4;
    }
    __pyx_L4:;

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":170 */
    free(__pyx_v_side_list);

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":171 */
    free(__pyx_v_side_p_list);
    switch (__pyx_why) {
      case 3: goto __pyx_L0;
      case 4: {
        PyErr_Restore(__pyx_2, __pyx_3, __pyx_1);
        __pyx_lineno = __pyx_4;
        __pyx_2 = 0;
        __pyx_3 = 0;
        __pyx_1 = 0;
        goto __pyx_L1;
      }
    }
  }

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("rabbyt.collisions.rdc");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_o);
  Py_DECREF(__pyx_v_groups);
  Py_DECREF(__pyx_v_current_group);
  Py_DECREF(__pyx_v_objects);
  return __pyx_r;
}

static void __pyx_f_6rabbyt_10collisions__rdc(struct __pyx_t_6rabbyt_10collisions_side_s (*(*__pyx_v_side_p_list)),int __pyx_v_length,enum __pyx_t_6rabbyt_10collisions__Axis __pyx_v_axis,int __pyx_v_depth,int __pyx_v_min_split,int __pyx_v_max_depth) {
  int __pyx_v_i;
  enum __pyx_t_6rabbyt_10collisions__Axis __pyx_v_next_axis;
  int __pyx_v_group_start;
  int __pyx_v_d;
  int __pyx_1;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":176 */
  __pyx_1 = (__pyx_v_length <= (__pyx_v_min_split * 2));
  if (__pyx_1) {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":177 */
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":178 */
  __pyx_1 = (__pyx_v_max_depth > 0);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_depth >= __pyx_v_max_depth);
  }
  if (__pyx_1) {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":179 */
    goto __pyx_L0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":183 */
  __pyx_1 = (__pyx_v_axis == __pyx_e_6rabbyt_10collisions_X);
  if (__pyx_1) {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":184 */
    qsort(__pyx_v_side_p_list,__pyx_v_length,(sizeof(struct __pyx_t_6rabbyt_10collisions_side_s (*))),__pyx_f_6rabbyt_10collisions__compar_sides_x);

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":185 */
    __pyx_v_next_axis = __pyx_e_6rabbyt_10collisions_Y;
    goto __pyx_L4;
  }
  /*else*/ {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":187 */
    qsort(__pyx_v_side_p_list,__pyx_v_length,(sizeof(struct __pyx_t_6rabbyt_10collisions_side_s (*))),__pyx_f_6rabbyt_10collisions__compar_sides_y);

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":188 */
    __pyx_v_next_axis = __pyx_e_6rabbyt_10collisions_X;
  }
  __pyx_L4:;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":192 */
  __pyx_v_group_start = 0;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":193 */
  __pyx_v_d = 0;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":194 */
  for (__pyx_v_i = 0; __pyx_v_i < __pyx_v_length; ++__pyx_v_i) {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":195 */
    __pyx_1 = (__pyx_v_group_start == 0);
    if (__pyx_1) {
      __pyx_1 = (__pyx_v_i == (__pyx_v_length - 1));
    }
    if (__pyx_1) {

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":198 */
      __pyx_1 = (__pyx_v_depth == 0);
      if (__pyx_1) {

        /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":199 */
        __pyx_f_6rabbyt_10collisions__rdc(__pyx_v_side_p_list,__pyx_v_length,__pyx_e_6rabbyt_10collisions_Y,1,__pyx_v_min_split,__pyx_v_max_depth);
        goto __pyx_L8;
      }
      __pyx_L8:;

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":200 */
      goto __pyx_L0;
      goto __pyx_L7;
    }
    __pyx_L7:;

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":202 */
    __pyx_1 = (((__pyx_v_side_p_list[__pyx_v_i])[0]).side == __pyx_e_6rabbyt_10collisions_LEFT);
    if (__pyx_1) {

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":203 */
      __pyx_v_d = (__pyx_v_d + 1);
      goto __pyx_L9;
    }
    /*else*/ {

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":205 */
      __pyx_v_d = (__pyx_v_d - 1);

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":206 */
      __pyx_1 = (__pyx_v_d == 0);
      if (__pyx_1) {

        /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":207 */
        __pyx_f_6rabbyt_10collisions__rdc((&(__pyx_v_side_p_list[__pyx_v_group_start])),((__pyx_v_i - __pyx_v_group_start) + 1),__pyx_v_next_axis,(__pyx_v_depth + 1),__pyx_v_min_split,__pyx_v_max_depth);

        /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":209 */
        __pyx_v_group_start = (__pyx_v_i + 1);
        goto __pyx_L10;
      }
      __pyx_L10:;
    }
    __pyx_L9:;
  }

  __pyx_L0:;
}

static PyObject *__pyx_f_6rabbyt_10collisions__brute_force(struct __pyx_t_6rabbyt_10collisions_collision_object_s (*__pyx_v_objs),int __pyx_v_length,PyObject *__pyx_v_objects) {
  float __pyx_v_dx;
  float __pyx_v_dy;
  int __pyx_v_i;
  int __pyx_v_j;
  PyObject *__pyx_v_collisions;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  long __pyx_2;
  int __pyx_3;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  Py_INCREF(__pyx_v_objects);
  __pyx_v_collisions = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":219 */
  __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 219; goto __pyx_L1;}
  Py_DECREF(__pyx_v_collisions);
  __pyx_v_collisions = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":220 */
  __pyx_2 = (__pyx_v_length - 1);
  for (__pyx_v_i = 0; __pyx_v_i < __pyx_2; ++__pyx_v_i) {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":221 */
    for (__pyx_v_j = __pyx_v_i+1; __pyx_v_j < __pyx_v_length; ++__pyx_v_j) {

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":222 */
      __pyx_v_dx = ((__pyx_v_objs[__pyx_v_i]).x - (__pyx_v_objs[__pyx_v_j]).x);

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":223 */
      __pyx_v_dy = ((__pyx_v_objs[__pyx_v_i]).y - (__pyx_v_objs[__pyx_v_j]).y);

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":224 */
      __pyx_3 = (((__pyx_v_dx * __pyx_v_dx) + (__pyx_v_dy * __pyx_v_dy)) < ((__pyx_v_objs[__pyx_v_i]).brs + (__pyx_v_objs[__pyx_v_j]).brs));
      if (__pyx_3) {

        /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":225 */
        __pyx_1 = PyObject_GetAttr(__pyx_v_collisions, __pyx_n_append); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; goto __pyx_L1;}
        __pyx_4 = PyInt_FromLong(__pyx_v_i); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; goto __pyx_L1;}
        __pyx_5 = PyObject_GetItem(__pyx_v_objects, __pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        __pyx_4 = PyInt_FromLong(__pyx_v_j); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 226; goto __pyx_L1;}
        __pyx_6 = PyObject_GetItem(__pyx_v_objects, __pyx_4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 226; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_4, 0, __pyx_5);
        PyTuple_SET_ITEM(__pyx_4, 1, __pyx_6);
        __pyx_5 = 0;
        __pyx_6 = 0;
        __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_5, 0, __pyx_4);
        __pyx_4 = 0;
        __pyx_6 = PyObject_CallObject(__pyx_1, __pyx_5); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        Py_DECREF(__pyx_6); __pyx_6 = 0;
        goto __pyx_L6;
      }
      __pyx_L6:;
    }
  }

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":227 */
  Py_INCREF(__pyx_v_collisions);
  __pyx_r = __pyx_v_collisions;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  __Pyx_AddTraceback("rabbyt.collisions._brute_force");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_collisions);
  Py_DECREF(__pyx_v_objects);
  return __pyx_r;
}

static PyObject *__pyx_n_bounding_radius_squared;

static PyObject *__pyx_f_6rabbyt_10collisions_brute_force(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_6rabbyt_10collisions_brute_force[] = "\n    ``brute_force(objects) -> list of collisions``\n\n    Finds collisions between ``objects`` using a brute force algorithm.\n\n    ``objects`` should be a list of objects, each of which have the attributes\n    ``x``, ``y``, and ``bounding_radius_squared``.  Each object is checked\n    against every other object.\n\n    For example, if ``A`` collides with ``B``, ``B`` collides with ``C``, and\n    ``D`` doesn\'t collide with anything, the result will be:\n    ``[(A, B), (B, C)]``.\n    ";
static PyObject *__pyx_f_6rabbyt_10collisions_brute_force(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_objects = 0;
  struct __pyx_t_6rabbyt_10collisions_collision_object_s (*__pyx_v_objs);
  int __pyx_v_i;
  int __pyx_v_length;
  PyObject *__pyx_v_o;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  float __pyx_5;
  static char *__pyx_argnames[] = {"objects",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_objects)) return 0;
  Py_INCREF(__pyx_v_objects);
  __pyx_v_o = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":246 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_len); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 246; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 246; goto __pyx_L1;}
  Py_INCREF(__pyx_v_objects);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_objects);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 246; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_4 = PyInt_AsLong(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 246; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_v_length = __pyx_4;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":247 */
  __pyx_v_objs = ((struct __pyx_t_6rabbyt_10collisions_collision_object_s (*))malloc(((sizeof(struct __pyx_t_6rabbyt_10collisions_collision_object_s )) * __pyx_v_length)));

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":248 */
  /*try:*/ {

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":253 */
    for (__pyx_v_i = 0; __pyx_v_i < __pyx_v_length; ++__pyx_v_i) {

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":254 */
      __pyx_1 = PyInt_FromLong(__pyx_v_i); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 254; goto __pyx_L3;}
      __pyx_2 = PyObject_GetItem(__pyx_v_objects, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 254; goto __pyx_L3;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_v_o);
      __pyx_v_o = __pyx_2;
      __pyx_2 = 0;

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":255 */
      __pyx_3 = PyObject_GetAttr(__pyx_v_o, __pyx_n_x); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 255; goto __pyx_L3;}
      __pyx_5 = PyFloat_AsDouble(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 255; goto __pyx_L3;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      (__pyx_v_objs[__pyx_v_i]).x = __pyx_5;

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":256 */
      __pyx_1 = PyObject_GetAttr(__pyx_v_o, __pyx_n_y); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 256; goto __pyx_L3;}
      __pyx_5 = PyFloat_AsDouble(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 256; goto __pyx_L3;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      (__pyx_v_objs[__pyx_v_i]).y = __pyx_5;

      /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":257 */
      __pyx_2 = PyObject_GetAttr(__pyx_v_o, __pyx_n_bounding_radius_squared); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 257; goto __pyx_L3;}
      __pyx_5 = PyFloat_AsDouble(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 257; goto __pyx_L3;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      (__pyx_v_objs[__pyx_v_i]).brs = __pyx_5;
    }

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":259 */
    __pyx_3 = __pyx_f_6rabbyt_10collisions__brute_force(__pyx_v_objs,__pyx_v_length,__pyx_v_objects); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 259; goto __pyx_L3;}
    __pyx_r = __pyx_3;
    __pyx_3 = 0;
    goto __pyx_L2;
  }
  /*finally:*/ {
    int __pyx_why;
    __pyx_why = 0; goto __pyx_L4;
    __pyx_L2: __pyx_why = 3; goto __pyx_L4;
    __pyx_L3: {
      __pyx_why = 4;
      Py_XDECREF(__pyx_1); __pyx_1 = 0;
      Py_XDECREF(__pyx_2); __pyx_2 = 0;
      Py_XDECREF(__pyx_3); __pyx_3 = 0;
      PyErr_Fetch(&__pyx_1, &__pyx_2, &__pyx_3);
      __pyx_4 = __pyx_lineno;
      goto __pyx_L4;
    }
    __pyx_L4:;

    /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":261 */
    free(__pyx_v_objs);
    switch (__pyx_why) {
      case 3: goto __pyx_L0;
      case 4: {
        PyErr_Restore(__pyx_1, __pyx_2, __pyx_3);
        __pyx_lineno = __pyx_4;
        __pyx_1 = 0;
        __pyx_2 = 0;
        __pyx_3 = 0;
        goto __pyx_L1;
      }
    }
  }

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("rabbyt.collisions.brute_force");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_o);
  Py_DECREF(__pyx_v_objects);
  return __pyx_r;
}

static __Pyx_InternTabEntry __pyx_intern_tab[] = {
  {&__pyx_n___author__, "__author__"},
  {&__pyx_n___credits__, "__credits__"},
  {&__pyx_n___docs_all__, "__docs_all__"},
  {&__pyx_n_append, "append"},
  {&__pyx_n_bounding_radius, "bounding_radius"},
  {&__pyx_n_bounding_radius_squared, "bounding_radius_squared"},
  {&__pyx_n_brute_force, "brute_force"},
  {&__pyx_n_collide, "collide"},
  {&__pyx_n_extend, "extend"},
  {&__pyx_n_len, "len"},
  {&__pyx_n_min_split, "min_split"},
  {&__pyx_n_rdc, "rdc"},
  {&__pyx_n_split, "split"},
  {&__pyx_n_x, "x"},
  {&__pyx_n_y, "y"},
  {0, 0}
};

static __Pyx_StringTabEntry __pyx_string_tab[] = {
  {&__pyx_k1p, __pyx_k1, sizeof(__pyx_k1)},
  {&__pyx_k2p, __pyx_k2, sizeof(__pyx_k2)},
  {&__pyx_k5p, __pyx_k5, sizeof(__pyx_k5)},
  {0, 0, 0}
};

static struct PyMethodDef __pyx_methods[] = {
  {"collide", (PyCFunction)__pyx_f_6rabbyt_10collisions_collide, METH_VARARGS|METH_KEYWORDS, __pyx_doc_6rabbyt_10collisions_collide},
  {"rdc", (PyCFunction)__pyx_f_6rabbyt_10collisions_rdc, METH_VARARGS|METH_KEYWORDS, __pyx_doc_6rabbyt_10collisions_rdc},
  {"brute_force", (PyCFunction)__pyx_f_6rabbyt_10collisions_brute_force, METH_VARARGS|METH_KEYWORDS, __pyx_doc_6rabbyt_10collisions_brute_force},
  {0, 0, 0, 0}
};

static void __pyx_init_filenames(void); /*proto*/

PyMODINIT_FUNC initcollisions(void); /*proto*/
PyMODINIT_FUNC initcollisions(void) {
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  __pyx_init_filenames();
  __pyx_m = Py_InitModule4("collisions", __pyx_methods, __pyx_mdoc, 0, PYTHON_API_VERSION);
  if (!__pyx_m) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; goto __pyx_L1;};
  __pyx_b = PyImport_AddModule("__builtin__");
  if (!__pyx_b) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; goto __pyx_L1;};
  if (PyObject_SetAttrString(__pyx_m, "__builtins__", __pyx_b) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; goto __pyx_L1;};
  if (__Pyx_InternStrings(__pyx_intern_tab) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; goto __pyx_L1;};
  if (__Pyx_InitStrings(__pyx_string_tab) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; goto __pyx_L1;};

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":6 */
  if (PyObject_SetAttr(__pyx_m, __pyx_n___credits__, __pyx_k1p) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 5; goto __pyx_L1;}

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":28 */
  if (PyObject_SetAttr(__pyx_m, __pyx_n___author__, __pyx_k2p) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 28; goto __pyx_L1;}

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":92 */
  __pyx_k3 = 1;
  __pyx_k4 = 0;

  /* "/home/mmarshall/projects/rabbyt/rabbyt/rabbyt.collisions.pyx":263 */
  __pyx_1 = PyObject_GetAttr(__pyx_k5p, __pyx_n_split); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 263; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(__pyx_1, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 263; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (PyObject_SetAttr(__pyx_m, __pyx_n___docs_all__, __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 263; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  return;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("rabbyt.collisions");
}

static char *__pyx_filenames[] = {
  "rabbyt.collisions.pyx",
};

/* Runtime support code */

static void __pyx_init_filenames(void) {
  __pyx_f = __pyx_filenames;
}

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name) {
    PyObject *result;
    result = PyObject_GetAttr(dict, name);
    if (!result)
        PyErr_SetObject(PyExc_NameError, name);
    return result;
}

static int __Pyx_InternStrings(__Pyx_InternTabEntry *t) {
    while (t->p) {
        *t->p = PyString_InternFromString(t->s);
        if (!*t->p)
            return -1;
        ++t;
    }
    return 0;
}

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t) {
    while (t->p) {
        *t->p = PyString_FromStringAndSize(t->s, t->n - 1);
        if (!*t->p)
            return -1;
        ++t;
    }
    return 0;
}

#include "compile.h"
#include "frameobject.h"
#include "traceback.h"

static void __Pyx_AddTraceback(char *funcname) {
    PyObject *py_srcfile = 0;
    PyObject *py_funcname = 0;
    PyObject *py_globals = 0;
    PyObject *empty_tuple = 0;
    PyObject *empty_string = 0;
    PyCodeObject *py_code = 0;
    PyFrameObject *py_frame = 0;
    
    py_srcfile = PyString_FromString(__pyx_filename);
    if (!py_srcfile) goto bad;
    py_funcname = PyString_FromString(funcname);
    if (!py_funcname) goto bad;
    py_globals = PyModule_GetDict(__pyx_m);
    if (!py_globals) goto bad;
    empty_tuple = PyTuple_New(0);
    if (!empty_tuple) goto bad;
    empty_string = PyString_FromString("");
    if (!empty_string) goto bad;
    py_code = PyCode_New(
        0,            /*int argcount,*/
        0,            /*int nlocals,*/
        0,            /*int stacksize,*/
        0,            /*int flags,*/
        empty_string, /*PyObject *code,*/
        empty_tuple,  /*PyObject *consts,*/
        empty_tuple,  /*PyObject *names,*/
        empty_tuple,  /*PyObject *varnames,*/
        empty_tuple,  /*PyObject *freevars,*/
        empty_tuple,  /*PyObject *cellvars,*/
        py_srcfile,   /*PyObject *filename,*/
        py_funcname,  /*PyObject *name,*/
        __pyx_lineno,   /*int firstlineno,*/
        empty_string  /*PyObject *lnotab*/
    );
    if (!py_code) goto bad;
    py_frame = PyFrame_New(
        PyThreadState_Get(), /*PyThreadState *tstate,*/
        py_code,             /*PyCodeObject *code,*/
        py_globals,          /*PyObject *globals,*/
        0                    /*PyObject *locals*/
    );
    if (!py_frame) goto bad;
    py_frame->f_lineno = __pyx_lineno;
    PyTraceBack_Here(py_frame);
bad:
    Py_XDECREF(py_srcfile);
    Py_XDECREF(py_funcname);
    Py_XDECREF(empty_tuple);
    Py_XDECREF(empty_string);
    Py_XDECREF(py_code);
    Py_XDECREF(py_frame);
}
