% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{trie}
\alias{trie}
\title{Create a Trie}
\usage{
trie(keys, values)
}
\arguments{
\item{keys}{a character vector containing the keys for the trie.}

\item{values}{an atomic vector of any type, containing the values to pair with
\code{keys}. Must be the same length as \code{keys}.}
}
\value{
a `trie` object.
}
\description{
\code{create_trie} creates a trie (a key-value store optimised
for matching) out of a provided character vector of keys, and a numeric,
character, logical or integer vector of values (both the same length).
}
\examples{
# An integer trie
int_trie <- trie(keys = "foo", values = 1)

# A string trie
str_trie <- trie(keys = "foo", values = "bar")

}
\seealso{
\code{\link{trie_add}} and \code{\link{trie_remove}} for adding to and removing
from tries after their creation, and \code{\link{longest_match}} and other match functions
for matching values against the keys of a created trie.
}

