% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tween_path.R
\name{tween_path}
\alias{tween_path}
\title{Transition between path data frames}
\usage{
tween_path(.data, to, ease, nframes, id = NULL, enter = NULL,
  exit = NULL, match = TRUE)
}
\arguments{
\item{.data}{A data.frame to start from. If \code{.data} is the result of a prior
tween, only the last frame will be used for the tween. The new tween will
then be added to the prior tween}

\item{to}{A data.frame to end at. It must contain the same columns as .data
(exluding \code{.frame})}

\item{ease}{The easing function to use. Either a single string or one for
each column in the data set.}

\item{nframes}{The number of frames to calculate for the tween}

\item{id}{The column to match observations on. If \code{NULL} observations will be
matched by position. See the \emph{Match, Enter, and Exit} section for more
information.}

\item{enter}{functions that calculate a start state for new observations
that appear in \code{to} or an end state for observations that are not present in
\code{to}. If \code{NULL} the new/old observations will not be part of the tween. The
function gets a data.frame with either the start state of the exiting
observations, or the end state of the entering observations and must return
a modified version of that data.frame. See the \emph{Match, Enter, and Exit}
section for more information.}

\item{exit}{functions that calculate a start state for new observations
that appear in \code{to} or an end state for observations that are not present in
\code{to}. If \code{NULL} the new/old observations will not be part of the tween. The
function gets a data.frame with either the start state of the exiting
observations, or the end state of the entering observations and must return
a modified version of that data.frame. See the \emph{Match, Enter, and Exit}
section for more information.}

\item{match}{Should polygons be matched by id? If \code{FALSE} then polygons will
be matched by shortest distance and if any state has more polygons than the
other, the other states polygons will be chopped up so the numbers match.}
}
\value{
A data.frame containing intermediary states
}
\description{
This function is equivalent to \code{\link[tweenr:tween_state]{tweenr::tween_state()}} but expects the data
to have an \code{x} and \code{y} column and encode paths.
}
\section{Aligning paths}{

There is less work required to align paths than there is to align polygons,
simply because no rotation is possible/required, and the notion of clockwise
winding order is not meaningful in the scope of paths. Still, paths need to
be matched and the number of points in each pair of matched paths must be
equal. Paths are matched based on relative length rather than on position and
seek to minimize the change in length during transition. This is chosen from
the point of view that huge elongation or contraction are much more
distracting than longer travel distances.
}

\section{Cutting paths}{

If the number of paths to transition between is not even, some of the paths
need to be cut in order to succesfully match the paths. The cuts are
distributed based on the same algorithm that distributes cuts in polygons and
seek to cut the lines into as even-length pieces as possible.
}

\section{Multipaths}{

It is possible to encode multiple paths with the same id be separating them
with a \code{NA} row, much in the same way as holes are encoded in polygons. If
paths are not matched based on id (\code{match = FALSE}) then multipaths will
simply be split into separate paths. On the other hand, if paths are matched
by id all paths within a multipath will transition into the (multi)path that
has the same id in the other state.
}

