% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QueryResults.R
\docType{class}
\name{QueryResults-class}
\alias{QueryResults-class}
\alias{QueryResults}
\title{A Redland QueryResults object is used to inspect query results from a Query object.}
\description{
The QueryResults object contains the RDF statements that were returned from
a query on an RDF model.
}
\section{Slots}{

\describe{
\item{\code{librdf_query_results}}{A redland query object}
}}

\section{Methods}{

\itemize{
\item{\code{\link{QueryResults-initialize}}}{: Initialize a QueryResults object.}
\item{\code{\link{getNextResult}}}{: Get the next query result.}
\item{\code{\link{freeQueryResults}}}{: Free memory used by a librdf query result.}
}
}

\examples{
world <- new("World")
storage <- new("Storage", world, "hashes", name="", options="hash-type='memory'")
model <- new("Model", world, storage, options="")
stmt <- new("Statement", world=world, 
  subject="https://cn.dataone.org/cn/v1/resolve/urn:uuid:274a0c5c-3082-4562-bbd3-2b1288768cac",
  predicate="http://www.w3.org/ns/prov#hadPlan",
  object="https://cn.dataone.org/cn/v1/resolve/urn:uuid:01305f45-f22b-40c8-8d27-00357d01e4a5")
status <- addStatement(model, stmt)
stmt <- new("Statement", world=world, 
  subject="https://orcid.org/0000-0002-2192-403X",
  predicate="http://www.w3.org/ns/prov#Agent",
  object="slaughter", 
  objectType="literal", datatype_uri="http://www.w3.org/2001/XMLSchema#string")
status <- addStatement(model, stmt)
queryString <- paste("PREFIX orcid: <https://orcid.org/>",
                     "PREFIX dataone: <https://cn.dataone.org/cn/v1/resolve/>",
                     "PREFIX prov: <http://www.w3.org/ns/prov#>",
                     "SELECT ?a ?c WHERE { ?a prov:Agent ?c . }", sep=" ")
query <- new("Query", world, queryString, base_uri=NULL, 
  query_language="sparql", query_uri=NULL)
queryResult <- executeQuery(query, model)
result <- getNextResult(queryResult)
}
\seealso{
\code{\link{redland}}{: redland package}
}
\keyword{classes}
