% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_parameters.R
\name{pool_parameters}
\alias{pool_parameters}
\title{Pool Model Parameters}
\usage{
pool_parameters(
  x,
  exponentiate = FALSE,
  effects = "fixed",
  component = "conditional",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A list of \code{parameters_model} objects, as returned by
\code{\link[=model_parameters]{model_parameters()}}, or a list of model-objects that is
supported by \code{model_parameters()}.}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the
coefficients (and related confidence intervals). This is typical for
logistic regression, or more generally speaking, for models with log or
logit links. It is also recommended to use \code{exponentiate = TRUE} for models
with log-transformed response values. \strong{Note:} Delta-method standard
errors are also computed (by multiplying the standard errors by the
transformed coefficients). This is to mimic behaviour of other software
packages, such as Stata, but these standard errors poorly estimate
uncertainty for the transformed coefficient. The transformed confidence
interval more clearly captures this uncertainty. For \code{compare_parameters()},
\code{exponentiate = "nongaussian"} will only exponentiate coefficients from
non-Gaussian families.}

\item{effects}{Should parameters for fixed effects (\code{"fixed"}), random
effects (\code{"random"}), or both (\code{"all"}) be returned? Only applies
to mixed models. May be abbreviated. If the calculation of random effects
parameters takes too long, you may use \code{effects = "fixed"}.}

\item{component}{Should all parameters, parameters for the conditional model,
for the zero-inflated part of the model, or the dispersion model be returned?
Applies to models with zero-inflated and/or dispersion component. \code{component}
may be one of \code{"conditional"}, \code{"zi"}, \code{"zero-inflated"}, \code{"dispersion"} or
\code{"all"} (default). May be abbreviated.}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Currently not used.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
This function "pools" (i.e. combines) model parameters in a similar fashion
as \code{mice::pool()}. However, this function pools parameters from
\code{parameters_model} objects, as returned by
\code{\link[=model_parameters]{model_parameters()}}.
}
\details{
Averaging of parameters follows Rubin's rules (\cite{Rubin, 1987, p. 76}).
The pooled degrees of freedom is based on the Barnard-Rubin adjustment for
small samples (\cite{Barnard and Rubin, 1999}).
}
\note{
Models with multiple components, (for instance, models with zero-inflation,
where predictors appear in the count and zero-inflated part) may fail in
case of identical names for coefficients in the different model components,
since the coefficient table is grouped by coefficient names for pooling. In
such cases, coefficients of count and zero-inflated model parts would be
combined. Therefore, the \code{component} argument defaults to
\code{"conditional"} to avoid this.
}
\examples{
# example for multiple imputed datasets
if (require("mice")) {
  data("nhanes2")
  imp <- mice(nhanes2, printFlag = FALSE)
  models <- lapply(1:5, function(i) {
    lm(bmi ~ age + hyp + chl, data = complete(imp, action = i))
  })
  pool_parameters(models)

  # should be identical to:
  m <- with(data = imp, exp = lm(bmi ~ age + hyp + chl))
  summary(pool(m))
}
}
\references{
Barnard, J. and Rubin, D.B. (1999). Small sample degrees of freedom with
multiple imputation. Biometrika, 86, 948-955. Rubin, D.B. (1987). Multiple
Imputation for Nonresponse in Surveys. New York: John Wiley and Sons.
}
