% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnecessary_nested_if_linter.R
\name{unnecessary_nested_if_linter}
\alias{unnecessary_nested_if_linter}
\title{Avoid unnecessary nested \code{if} conditional statements}
\usage{
unnecessary_nested_if_linter()
}
\description{
Avoid unnecessary nested \code{if} conditional statements
}
\examples{
# will produce lints
writeLines("if (x) { \n  if (y) { \n   return(1L) \n  } \n}")
lint(
  text = "if (x) { \n  if (y) { \n   return(1L) \n  } \n}",
  linters = unnecessary_nested_if_linter()
)

# okay
writeLines("if (x && y) { \n  return(1L) \n}")
lint(
  text = "if (x && y) { \n  return(1L) \n}",
  linters = unnecessary_nested_if_linter()
)

writeLines("if (x) { \n  y <- x + 1L\n  if (y) { \n   return(1L) \n  } \n}")
lint(
  text = "if (x) { \n  y <- x + 1L\n  if (y) { \n   return(1L) \n  } \n}",
  linters = unnecessary_nested_if_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=readability_linters]{readability}
}
