% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-bins.R
\name{guide_bins}
\alias{guide_bins}
\title{A binned version of guide_legend}
\usage{
guide_bins(
  title = waiver(),
  title.position = NULL,
  title.theme = NULL,
  title.hjust = NULL,
  title.vjust = NULL,
  label = TRUE,
  label.position = NULL,
  label.theme = NULL,
  label.hjust = NULL,
  label.vjust = NULL,
  keywidth = NULL,
  keyheight = NULL,
  axis = TRUE,
  axis.colour = "black",
  axis.linewidth = 0.5,
  axis.arrow = NULL,
  direction = NULL,
  default.unit = "line",
  override.aes = list(),
  reverse = FALSE,
  order = 0,
  show.limits = NULL,
  ...
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[=waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[=labs]{labs()}} is used for the title.}

\item{title.position}{A character string indicating the position of a
title. One of "top" (default for a vertical guide), "bottom", "left"
(default for a horizontal guide), or "right."}

\item{title.theme}{A theme object for rendering the title text. Usually the
object of \code{\link[=element_text]{element_text()}} is expected. By default, the theme is
specified by \code{legend.title} in \code{\link[=theme]{theme()}} or theme.}

\item{title.hjust}{A number specifying horizontal justification of the
title text.}

\item{title.vjust}{A number specifying vertical justification of the title
text.}

\item{label}{logical. If \code{TRUE} then the labels are drawn. If
\code{FALSE} then the labels are invisible.}

\item{label.position}{A character string indicating the position of a
label. One of "top", "bottom" (default for horizontal guide), "left", or
"right" (default for vertical guide).}

\item{label.theme}{A theme object for rendering the label text. Usually the
object of \code{\link[=element_text]{element_text()}} is expected. By default, the theme is
specified by \code{legend.text} in \code{\link[=theme]{theme()}}.}

\item{label.hjust}{A numeric specifying horizontal justification of the
label text.}

\item{label.vjust}{A numeric specifying vertical justification of the label
text.}

\item{keywidth}{A numeric or a \code{\link[grid:unit]{grid::unit()}} object specifying
the width of the legend key. Default value is \code{legend.key.width} or
\code{legend.key.size} in \code{\link[=theme]{theme()}}.}

\item{keyheight}{A numeric or a \code{\link[grid:unit]{grid::unit()}} object specifying
the height of the legend key. Default value is \code{legend.key.height} or
\code{legend.key.size} in \code{\link[=theme]{theme()}}.}

\item{axis}{Logical. Should a small axis be drawn along the guide}

\item{axis.colour, axis.linewidth}{Graphic specifications for the look of the
axis.}

\item{axis.arrow}{A call to \code{arrow()} to specify arrows at the end of the
axis line, thus showing an open interval.}

\item{direction}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical."}

\item{default.unit}{A character string indicating \code{\link[grid:unit]{grid::unit()}}
for \code{keywidth} and \code{keyheight}.}

\item{override.aes}{A list specifying aesthetic parameters of legend key.
See details and examples.}

\item{reverse}{logical. If \code{TRUE} the order of legends is reversed.}

\item{order}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}

\item{show.limits}{Logical. Should the limits of the scale be shown with
labels and ticks.}

\item{...}{ignored.}
}
\value{
A guide object
}
\description{
This guide is a version of the \code{\link[=guide_legend]{guide_legend()}} guide for binned scales. It
differs in that it places ticks correctly between the keys, and sports a
small axis to better show the binning. Like \code{\link[=guide_legend]{guide_legend()}} it can be used
for all non-position aesthetics though colour and fill defaults to
\code{\link[=guide_coloursteps]{guide_coloursteps()}}, and it will merge aesthetics together into the same
guide if they are mapped in the same way.
}
\section{Use with discrete scale}{

This guide is intended to show binned data and work together with ggplot2's
binning scales. However, it is sometimes desirable to perform the binning in
a separate step, either as part of a stat (e.g. \code{\link[=stat_contour_filled]{stat_contour_filled()}}) or
prior to the visualisation. If you want to use this guide for discrete data
the levels must follow the naming scheme implemented by \code{\link[base:cut]{base::cut()}}. This
means that a bin must be encoded as \code{"(<lower>, <upper>]"} with \verb{<lower>}
giving the lower bound of the bin and \verb{<upper>} giving the upper bound
(\code{"[<lower>, <upper>)"} is also accepted). If you use \code{\link[base:cut]{base::cut()}} to
perform the binning everything should work as expected, if not, some recoding
may be needed.
}

\examples{
p <- ggplot(mtcars) +
  geom_point(aes(disp, mpg, size = hp)) +
  scale_size_binned()

# Standard look
p

# Remove the axis or style it
p + guides(size = guide_bins(axis = FALSE))

p + guides(size = guide_bins(show.limits = TRUE))

p + guides(size = guide_bins(
  axis.arrow = arrow(length = unit(1.5, 'mm'), ends = 'both')
))

# Guides are merged together if possible
ggplot(mtcars) +
  geom_point(aes(disp, mpg, size = hp, colour = hp)) +
  scale_size_binned() +
  scale_colour_binned(guide = "bins")

}
\seealso{
Other guides: 
\code{\link{guide_colourbar}()},
\code{\link{guide_coloursteps}()},
\code{\link{guide_legend}()},
\code{\link{guides}()}
}
\concept{guides}
