% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-copy-to.R
\name{copy_inline}
\alias{copy_inline}
\title{Use a local data frame in a dbplyr query}
\usage{
copy_inline(con, df)
}
\arguments{
\item{con}{A database connection.}

\item{df}{A local data frame. The data is written directly in the SQL query
so it should be small.}
}
\value{
A \code{tbl_lazy}.
}
\description{
This is an alternative to \code{\link[=copy_to]{copy_to()}} that does not need write access and
is faster for small data.
}
\details{
It writes the data directly in the SQL query via the \code{VALUES} clause.
}
\examples{
df <- data.frame(x = 1:3, y = c("a", "b", "c"))
con <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

copy_inline(con, df)

copy_inline(con, df) \%>\% dplyr::show_query()
}
\seealso{
\code{\link[=copy_to]{copy_to()}} to copy the data into a new database table.
}
