% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muhaz-tidiers.R
\name{tidy.muhaz}
\alias{tidy.muhaz}
\alias{muhaz_tidiers}
\title{Tidy a(n) muhaz object}
\usage{
\method{tidy}{muhaz}(x, ...)
}
\arguments{
\item{x}{A \code{muhaz} object returned by \code{\link[muhaz:muhaz]{muhaz::muhaz()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with two columns:

\item{time}{The time at which the hazard rate was estimated.}
\item{estimate}{The estimated hazard rate.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{
if (require("muhaz", quietly = TRUE)) {
  data(ovarian, package="survival")
  x <- muhaz::muhaz(ovarian$futime, ovarian$fustat)
  tidy(x)
  glance(x)
}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[muhaz:muhaz]{muhaz::muhaz()}}

Other muhaz tidiers: 
\code{\link{glance.muhaz}()}
}
\concept{muhaz tidiers}
