context("processMultipleSamples")

test_that("example output correct", {
	skip_if_not(requireNamespace("copynumber"), "copynumber required")

	normal1.coverage.file <- system.file("extdata", "example_normal.txt.gz",
		package = "PureCN")
	normal2.coverage.file <- system.file("extdata", "example_normal2.txt.gz",
		package = "PureCN")
	tumor1.coverage.file <- system.file("extdata", "example_tumor.txt.gz",
		package = "PureCN")
	tumor2.coverage.file <- system.file("extdata", "example_tumor2.txt.gz",
		package = "PureCN")

	normal.coverage.files <- c(normal1.coverage.file, normal2.coverage.file)
	tumor.coverage.files <- c(tumor1.coverage.file, tumor2.coverage.file)
	normalDB <- createNormalDatabase(normal.coverage.files)
    pool <- calculateTangentNormal(tumor1.coverage.file, normalDB)

	seg <- processMultipleSamples(tumor.coverage.files,
			 sampleids = c("Sample1", "Sample2"),
			 normalDB = normalDB,
			 genome = "hg19")
    expect_equal(c("Sample1", "Sample2"), levels(seg[,1]))
	seg2 <- processMultipleSamples(
             list(tumor.coverage.files[1],readCoverageFile(tumor.coverage.files[2])),
			 sampleids = c("Sample1", "Sample2"),
			 normalDB = normalDB,
			 genome = "hg38", plot.cnv = FALSE)
    expect_equal(c("Sample1", "Sample2"), levels(seg2[,1]))
    seg.file <- tempfile(fileext = ".seg")
    write.table(seg, seg.file, row.names = FALSE, sep = "\t")
    vcf.file <- system.file("extdata", "example.vcf.gz", package = "PureCN")
    ret <- runAbsoluteCN(tumor.coverage.file = tumor1.coverage.file, 
        normal.coverage.file = pool, 
        seg.file = seg.file, vcf.file = vcf.file, max.candidate.solutions = 1, 
        fun.segmentation = segmentationHclust, post.optimize = TRUE,
        genome = "hg19", min.ploidy = 1.5, max.ploidy = 2.1, 
        test.purity = seq(0.4, 0.7, by = 0.05), sampleid = "Sample1")
    expect_equal(0.65, ret$results[[1]]$purity)
	expect_error(processMultipleSamples(tumor.coverage.files,
			 sampleids = c("Sample1", "Sample2"),
			 normalDB = normalDB,
			 genome = "hg20"), "centromere")
})
