% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rainfall.R
\name{plot_rainfall}
\alias{plot_rainfall}
\title{Plot genomic rainfall}
\usage{
plot_rainfall(vcf, chromosomes, title = "", colors, cex = 2.5,
  cex_text = 3, ylim = 1e+08)
}
\arguments{
\item{vcf}{CollapsedVCF object}

\item{chromosomes}{Vector of chromosome/contig names of the reference
genome to be plotted}

\item{title}{Optional plot title}

\item{colors}{Vector of 6 colors used for plotting}

\item{cex}{Point size}

\item{cex_text}{Text size}

\item{ylim}{Maximum y value (genomic distance)}
}
\value{
Rainfall plot
}
\description{
Rainfall plot visualizes the types of mutations and intermutation distance
}
\details{
Rainfall plots can be used to visualize the distribution of mutations
along the genome or a subset of chromosomes. The distance of a mutation
with the mutation prior to it (the intermutation distance) is plotted on
the y-axis on a log scale.

The colour of the points indicates the base substitution type.
Clusters of mutations with lower intermutation distance represent mutation
hotspots.
}
\examples{
## See the 'read_vcfs_as_granges()' example for how we obtained the
## following data:
vcfs <- readRDS(system.file("states/read_vcfs_as_granges_output.rds",
                package="MutationalPatterns"))

# Specify chromosomes of interest.
chromosomes = names(genome(vcfs[[1]])[1:22])

## Do a rainfall plot for all chromosomes:
plot_rainfall(vcfs[[1]],
                title = names(vcfs[1]),
                chromosomes = chromosomes,
                cex = 1)

## Or for a single chromosome (chromosome 1):
plot_rainfall(vcfs[[1]],
                title = names(vcfs[1]),
                chromosomes = chromosomes[1],
                cex = 2)

}
\seealso{
\code{\link{read_vcfs_as_granges}}
}
