% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_enrichment_depletion.R
\name{plot_enrichment_depletion}
\alias{plot_enrichment_depletion}
\title{Plot enrichment/depletion of mutations in genomic regions}
\usage{
plot_enrichment_depletion(df)
}
\arguments{
\item{df}{Dataframe result from enrichment_depletion_test()}
}
\value{
Plot with two parts. 1: Barplot with no. mutations expected and
observed per region. 2: Effect size of enrichment/depletion
(log2ratio) with results significance test.
}
\description{
Plot enrichment/depletion of mutations in genomic regions
}
\examples{
## See the 'genomic_distribution()' example for how we obtained the
## following data:
distr <- readRDS(system.file("states/distr_data.rds",
                    package="MutationalPatterns"))

tissue = c( "colon", "colon", "colon",
            "intestine", "intestine", "intestine",
            "liver", "liver", "liver" )

## Perform the enrichment/depletion test.
distr_test = enrichment_depletion_test(distr, by = tissue)
distr_test2 = enrichment_depletion_test(distr)

## Plot the enrichment/depletion
plot_enrichment_depletion(distr_test)
plot_enrichment_depletion(distr_test2)

}
\seealso{
\code{\link{enrichment_depletion_test}},
\code{\link{genomic_distribution}}
}
