% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_signatures.R
\name{extract_signatures}
\alias{extract_signatures}
\title{Extract mutational signatures from 96 mutation matrix using NMF}
\usage{
extract_signatures(mut_matrix, rank, nrun = 200)
}
\arguments{
\item{mut_matrix}{96 mutation count matrix}

\item{rank}{Number of signatures to extract}

\item{nrun}{Number of iterations, default = 200}
}
\value{
Named list of mutation matrix, signatures and signature contribution
}
\description{
Decomposes trinucleotide count matrix into signatures and contribution of
those signatures to the spectra of the samples/vcf files.
}
\examples{
## See the 'mut_matrix()' example for how we obtained the mutation matrix:
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
                    package="MutationalPatterns"))

## This function is computational intensive.
# nmf_res <- extract_signatures(mut_mat, rank = 2)

}
\seealso{
\code{\link{mut_matrix}}
}
