% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTSFilter-methods.R
\docType{methods}
\name{HTSFilter-deprecated}
\alias{HTSFilter-deprecated}
\alias{HTSFilter,CountDataSet-method}
\alias{HTSBasicFilter,CountDataSet-method}
\title{Deprecated functions in package \sQuote{HTSFilter}}
\usage{
\S4method{HTSFilter}{CountDataSet}(x, conds = NA, s.min = 1,
  s.max = 200, s.len = 100, loess.span = 0.3,
  normalization = c("DESeq", "TMM", "none"), plot = TRUE,
  plot.name = NA, parallel = FALSE, BPPARAM = bpparam())

\S4method{HTSBasicFilter}{CountDataSet}(x, method, cutoff.type = "value",
  cutoff = 10, length = NA, normalization = c("DESeq", "TMM",
  "none"))
}
\arguments{
\item{x}{A numeric matrix or data.frame representing the counts of dimension (\emph{g} x \emph{n}), 
for \emph{g} genes in \emph{n} samples, a \code{DGEList} object, a 
\code{DGEExact} object, a \code{DGEGLM} object, a \code{DGELRT} object, or a \code{DESeqDataSet} object.}

\item{conds}{Vector of length \emph{n} identifying the experimental condition of each of the \emph{n} samples; required when sQuote(x)
is a numeric matrix.}

\item{s.min}{Minimum value of filtering threshold to be considered, with default value equal to 1}

\item{s.max}{Maximum value of filtering threshold to be considered, with default value equal to 200}

\item{s.len}{Length of sequence of filtering thresholds to be considered (from \code{s.min} to \code{s.max}) 
for the calculation of the global similarity index}

\item{loess.span}{Span of the loess curve to be fitted to the filtering thresholds and corresponding global similarity
indices, with default value equal to 0.3}

\item{normalization}{Normalization method to be used to correct for differences in library sizes, with 
choices  \dQuote{TMM} (Trimmed Mean of M-values), \dQuote{DESeq} (normalization method proposed in the
DESeq package), \dQuote{pseudo.counts} (pseudo-counts obtained via quantile-quantile normalization in 
the edgeR package, only available for objects of class \code{DGEList} and \code{DGEExact}), and 
\dQuote{none} (to be used only if user is certain no normalization is required, or if data have already 
been pre-normalized by an alternative method)}

\item{plot}{If \dQuote{TRUE}, produce a plot of the calculated global similarity indices against the
filtering threshold with superimposed loess curve}

\item{plot.name}{If \code{plot} = \dQuote{TRUE}, the name of the PDF file to be saved to the current working directory.
If \code{plot.name} = NA, the plot is drawn in the current window}

\item{parallel}{If \code{FALSE}, no parallelization. If \code{TRUE}, parallel 
execution using BiocParallel (see next argument \code{BPPARAM}). A note on running 
in parallel using BiocParallel: it may be advantageous to remove large, unneeded objects 
from the current R environment before calling the function, as it is possible that R's 
internal garbage collection will copy these files while running on worker nodes.}

\item{BPPARAM}{Optional parameter object passed internally to \code{bplapply} when 
\code{parallel=TRUE}. If not specified, the parameters last registered with \code{register} 
will be used.}

\item{method}{Basic filtering method to be used: \dQuote{mean}, \dQuote{sum}, \dQuote{rpkm}, 
\dQuote{variance}, \dQuote{cpm}, \dQuote{max}, \dQuote{cpm.mean}, \dQuote{cpm.sum}, \dQuote{cpm.variance}, 
\dQuote{cpm.max}, \dQuote{rpkm.mean}, \dQuote{rpkm.sum}, \dQuote{rpkm.variance}, or \dQuote{rpkm.max}}

\item{cutoff.type}{Type of cutoff to be used: a numeric value indicating the number of samples to be 
used for filtering (when \code{method} = \dQuote{cpm} or \dQuote{rpkm}), or one of \dQuote{value}, 
\dQuote{number}, or \dQuote{quantile}}

\item{cutoff}{Cutoff to be used for chosen filter}

\item{length}{Optional vector of length \emph{n} containing the lengths of each gene in \code{x}; 
optional except in the case of \code{method} = \dQuote{rpkm}}
}
\value{
\itemize{
 \item{filteredData }{An object of the same class as \code{x} containing the data that passed the filter}

 \item{on }{A binary vector of length \emph{g}, where 1 indicates a gene with normalized expression
  greater than the optimal filtering threshold \code{s.optimal} in at least one sample (irrespective of 
  condition labels), and 0 indicates a gene with normalized expression less than or equal to the optimal 
  filtering threshold in all samples}

 \item{s }{The optimal filtering threshold as identified by the global similarity index}
 
 \item{indexValues }{A matrix of dimension (\code{s.len} x 2) giving the tested filtering thersholds and the
 corresponding global similarity indices. Note that the threshold values are equally spaced on the \emph{log}
 scale, and thus unequally spaced on the count scale (i.e., we test more threshold values at very low levels
 of expression, and fewer at very high levels of expression).}
 
 \item{normFactor }{A vector of length \emph{n} giving the estimated library sizes estimated by the
  normalization method specified in \code{normalization}}

 \item{removedData }{A matrix containing the filtered data}
}
}
\description{
These functions are provided for compatibility with older versions of \sQuote{HTSFilter} only,
and will be defunct at the next release.
}
\details{
The following functions are deprecated and will be made defunct. Objects of type
\sQuote{CountDataSet} from the original \sQuote{DESeq} package will no longer be supported;
users should make use of \sQuote{DESeqDataSet} objects from the \sQuote{DESeq2} package:
\itemize{
  \item{HTSFilter.CountDataSet: \code{\link{HTSFilter}}}
  \item{HTSBasicFilter.CountDataSet: \code{\link{HTSBasicFilter}}} 
}
}
\references{
R. Bourgon, R. Gentleman, and W. Huber. (2010) Independent filtering increases detection power for high-
throughput experiments. \emph{PNAS} \bold{107}(21):9546-9551.

P. Jaccard (1901). Etude comparative de la distribution 
orale dans une portion des Alpes et des Jura.
\emph{Bulletin de la Societe Vaudoise des Sciences Naturelles}, \bold{37}:547-549.

A. Rau, M. Gallopin, G. Celeux, F. Jaffrezic (2013). Data-based filtering 
for replicated high-throughput transcriptome sequencing experiments. \emph{Bioinformatics},
doi: 10.1093/bioinformatics/btt350.
}
\author{
Andrea Rau, Melina Gallopin, Gilles Celeux, and Florence Jaffrezic
}
\keyword{methods}
