% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcriptToX.R
\name{transcriptToCds}
\alias{transcriptToCds}
\title{Map transcript-relative coordinates to positions within the CDS}
\usage{
transcriptToCds(x, db, id = "name")
}
\arguments{
\item{x}{\code{IRanges} with the coordinates within the transcript. Coordinates
are expected to be relative to the transcription start (the first
nucleotide of the transcript). The Ensembl IDs of the corresponding
transcripts have to be provided either as \code{names} of the \code{IRanges}, or
in one of its metadata columns.}

\item{db}{\code{EnsDb} object.}

\item{id}{\code{character(1)} specifying where the transcript identifier can be
found. Has to be either \code{"name"} or one of \code{colnames(mcols(prng))}.}
}
\value{
\code{IRanges} with the same length (and order) than the input \code{IRanges}
\code{x}. Each element in \code{IRanges} provides the coordinates within the
transcripts CDS. The transcript-relative coordinates are provided
as metadata columns.
\code{IRanges} with a start coordinate of \code{-1} is returned for transcripts
that are not known in the database, non-coding transcripts or if the
provided start and/or end coordinates are not within the coding region.
}
\description{
Converts transcript-relative coordinates to positions within the CDS (if the
transcript encodes a protein).
}
\examples{

library(EnsDb.Hsapiens.v86)
## Defining transcript-relative coordinates for 4 transcripts of the gene
## BCL2
txcoords <- IRanges(start = c(1463, 3, 143, 147), width = 1,
    names = c("ENST00000398117", "ENST00000333681",
    "ENST00000590515", "ENST00000589955"))

## Map the coordinates.
transcriptToCds(txcoords, EnsDb.Hsapiens.v86)

## ENST00000590515 does not encode a protein and thus -1 is returned
## The coordinates within ENST00000333681 are outside the CDS and thus also
## -1 is reported.
}
\seealso{
Other coordinate mapping functions: \code{\link{cdsToTranscript}},
  \code{\link{genomeToProtein}},
  \code{\link{genomeToTranscript}},
  \code{\link{proteinToGenome}},
  \code{\link{proteinToTranscript}},
  \code{\link{transcriptToGenome}},
  \code{\link{transcriptToProtein}}
}
\author{
Johannes Rainer
}
