## NOTE: On Windows, MulticoreParam() throws a warning and instantiates
##       a single FORK worker using scripts from parallel. No logging or 
##       error catching is implemented.

library(doParallel)

checkExceptionText <- function(expr, txt, negate=FALSE, msg="")
{
    x <- try(eval(expr), silent=TRUE)
    checkTrue(inherits(x, "condition"), msg=msg)
    checkTrue(xor(negate, grepl(txt, as.character(x), fixed=TRUE)), msg=msg)
}

test_catching_errors <- function()
{
    x <- 1:10
    y <- rev(x)
    f <- function(x, y) if (x > y) stop("whooops") else x + y

    registerDoParallel(2)
    params <- list(
        serial=SerialParam(),
        snow=SnowParam(2),
        dopar=DoparParam(),
        batchjobs=BatchJobsParam(progressbar=FALSE))
    if (.Platform$OS.type != "windows")
        params$mc <- MulticoreParam(2)

    for (param in params) {
        res <- bplapply(list(1, "2", 3), sqrt, BPPARAM=param)
        checkTrue(length(res) == 3L)
        msg <- "non-numeric argument to mathematical function"
        checkIdentical(conditionMessage(res[[2]]), msg)
    }

    closeAllConnections()
    TRUE
}

test_BPREDO <- function()
{
    f = sqrt
    x = list(1, "2", 3) 
    x.fix = list(1, 2, 3) 

    registerDoParallel(2)
    params <- list(
        serial=SerialParam(),
        snow=SnowParam(2),
        dopar=DoparParam(),
        batchjobs=BatchJobsParam(progressbar=FALSE))
    if (.Platform$OS.type != "windows")
        params$mc <- MulticoreParam(2)

    for (param in params) {
        res <- bpmapply(f, x, BPPARAM=param, SIMPLIFY=TRUE)
        checkTrue(inherits(res[[2]], "condition"))
        Sys.sleep(0.25)

        ## data not fixed
        res2 <- bpmapply(f, x, BPPARAM=param, BPREDO=res, SIMPLIFY=TRUE)
        checkTrue(inherits(res2[[2]], "condition"))
        Sys.sleep(0.25)

        ## data fixed
        res3 <- bpmapply(f, x.fix, BPPARAM=param, BPREDO=res, SIMPLIFY=TRUE)
        checkIdentical(res3, sqrt(1:3))
        Sys.sleep(0.25)
    }

    closeAllConnections()
    TRUE
}
