/***************************************************************************
 *   Copyright (C) 2008-2009 by fra74   *
 *   francesco.b74@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef SCHEDAVIAGGIATRENO_H
#define SCHEDAVIAGGIATRENO_H
//
#include <QtGui>
#include <QtNetwork>
#include <QtXml>

enum StatoTreno {DatiSconosciuti, TrenoNonPrevisto, TrenoNonPartito, TrenoInViaggio, TrenoArrivato};

class QViaggiaTreno;

//Questa è la classe base da cui derivano tutte le classi per le schede di monitoraggio
class SchedaViaggiaTreno : public QStackedWidget
{
Q_OBJECT
public:
	enum TipoScheda {tsStazione, tsTreno, tsListaTreni};

	SchedaViaggiaTreno(QViaggiaTreno *parent, TipoScheda ts, const unsigned int intervalloStandard);
	
	virtual void avvia();
	virtual void ferma();
	
	int intervallo() const;
	void impostaIntervallo(int nuovoInt);
	
	bool fermata() const {return !m_timer->isActive();}
	
	TipoScheda tipoScheda() const {	return m_tipo; }
	quint32 idScheda() const { return m_id;	}
	
	QString statoScheda() const { return m_stato; }
	
	virtual QString titolo(bool = false) const { return QString();}
	
	QDateTime ultimoAggiornamento() const { return m_ultimoAgg; }

	virtual void salvaScheda(QSettings & /*settings*/) {}
	
public slots:
	virtual void aggiorna();
	
protected:
	QTimer *m_timer;
	QString m_stato;
	QDateTime m_ultimoAgg;
	
	//alcune costanti che rappresentano lo stato della scheda
	static QString statoNuovaScheda;
	static QString statoInAggiornamento;
	static QString statoMonitoraggioAttivo;
	static QString statoMonitoraggioFermato;
	static QString statoErrore;
	
	void cambiaStato(QString nuovoStato);
	QNetworkAccessManager* networkAM() { return m_nam; }

	QString correggiOutputVT(QString testoVT);

	//utilizzata per il debug
	QString dumpNodo(QDomNode nodo);
	void debugNodo(QDomNode nodo);
	void debugStringa(QString stringa);

protected slots:	
	virtual void downloadFinito( QNetworkReply* ) {}

private:
	QNetworkAccessManager *m_nam;
	quint32 m_id;
	TipoScheda m_tipo;
	static unsigned long s_id;

private:

signals:
	void GuiNonSincronizzata(quint32 id);
	void statoCambiato(quint32 id);
	void nomeSchedaCambiato(quint32 id);
	void apriSchedaStazione(const QString& stazione);
	void apriSchedaTreno(const QString& treno);
	void messaggioStatus(const QString& msg);
};

int larghezzaItem(const QTableWidgetItem* item);
void itemSottolineato(QTableWidgetItem* item, bool sottolineato = true);

#endif
