/***************************************************************************
 *   Copyright (C) 2008-2009 by fra74                                           *
 *   francesco.b74@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "schedaviaggiatreno.h"
#include "qviaggiatreno.h"

unsigned long SchedaViaggiaTreno::s_id = 0;
QString SchedaViaggiaTreno::statoNuovaScheda = QString::fromUtf8("Nuova scheda");
QString SchedaViaggiaTreno::statoInAggiornamento = QString::fromUtf8("In aggiornamento");
QString SchedaViaggiaTreno::statoMonitoraggioAttivo = QString::fromUtf8("Attivo");
QString SchedaViaggiaTreno::statoMonitoraggioFermato = QString::fromUtf8("Fermo");
QString SchedaViaggiaTreno::statoErrore = QString::fromUtf8("Errore");

//
SchedaViaggiaTreno::SchedaViaggiaTreno(QViaggiaTreno* parent, TipoScheda ts, const unsigned int intervalloStandard)
	: QStackedWidget(parent), m_tipo(ts)
{
	m_id = s_id++;
	
	m_timer = new QTimer(this);
	connect(m_timer, SIGNAL(timeout()), this, SLOT(aggiorna()));
	m_timer->setInterval(intervalloStandard*60000);
	
	
	m_nam = new QNetworkAccessManager(this);
	connect(m_nam, SIGNAL(finished(QNetworkReply*)), this, SLOT(downloadFinito(QNetworkReply*)));

}

void SchedaViaggiaTreno::avvia()
{
	if (m_timer)
		m_timer->start();
		
	cambiaStato(statoMonitoraggioAttivo);
	
}

void SchedaViaggiaTreno::ferma()
{
	if (m_timer)
		m_timer->stop();
		
	cambiaStato(statoMonitoraggioFermato);	
}

int SchedaViaggiaTreno::intervallo() const
{
	if (!m_timer)
		return 0;
	else
		return m_timer->interval()/60000;
}

void SchedaViaggiaTreno::impostaIntervallo(int nuovoInt)
{
	if (m_timer)
		m_timer->setInterval(nuovoInt*60000);
}

void SchedaViaggiaTreno::aggiorna()
{
	
}

void SchedaViaggiaTreno::cambiaStato(QString nuovoStato)
{
	m_stato = nuovoStato;
	
	emit statoCambiato(m_id);
}


//corregge alcuni errori nel codice XHTML generato da viaggiatreno che ne impediscono
//il corretto parsing da parte della classe QDom
QString SchedaViaggiaTreno::correggiOutputVT(QString testoVT)
{
	//effettua alcune sostituzione nel codice XHTML generato da ViaggiaTreno, che NON è valido
	//sostituisci <br> con <br/>
	QString temp = testoVT.simplified();
	//sostutuisce l'entità per gli accenti....
	temp.replace("&#039;", "'");
	//sostituisce gli ampersend negli URL con &amp;
	temp.replace("&", "&amp;");
	// sostituisce <br> con <br/>
	temp.replace("<br>", "<br/>");
	temp.replace("</strong> <br/> <br/>", "</strong> </p> <br/>");

	return temp;
}

//funzioni varie per il debug dei nodi DOM
QString SchedaViaggiaTreno::dumpNodo(QDomNode nodo)
{
	QString temp;
	QTextStream stream(&temp, QIODevice::WriteOnly);
	nodo.save(stream, 3);
	return temp;
}

void SchedaViaggiaTreno::debugNodo(QDomNode nodo)
{
	QMessageBox msg;
	msg.setTextFormat(Qt::PlainText);
	msg.setText(dumpNodo(nodo));
	msg.exec();
}

void SchedaViaggiaTreno::debugStringa(QString stringa)
{
	QMessageBox msg;
	msg.setTextFormat(Qt::PlainText);
	msg.setText(stringa);
	msg.exec();
}


//la funzione restituisce la larghezza in punti di un item
int larghezzaItem(const QTableWidgetItem* item)
{
	if (!item)
		return -1;

	QFontMetrics fm(item->font());
	int larghezza = fm.width(item->text());
	return larghezza;
}

//la funzione cambia il font di un item in modo che sia sottolineato
// se sottolinato = true, altrimenti rimuove la sottolineatura
void itemSottolineato(QTableWidgetItem* item, bool sottolineato)
{
	QFont font = item->font();
	font.setUnderline(sottolineato);
	item->setFont(font);
	item->setForeground(QApplication::palette().link());
}
