# This file is part of qVamps.
#
# qVamps is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# qVamps is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with qVamps; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


use strict;
use warnings;


package InstSplash;
use Qt;
use Qt::isa qw (Qt::SplashScreen);


sub NEW
{
  my $this = shift;

  $this -> SUPER::NEW (@_);
}


sub DESTROY
{
  SUPER -> DESTROY ();
}


# overload function of Qt::drawContents
sub drawContents
{
  my $painter = shift;

  $painter -> setPen (Qt::Color (0));
  my $r = rect ();
  $r -> setRect ($r -> x () + 15, $r -> y () + 15,
		 $r -> width () - 30, $r -> height () - 30);
  $painter -> drawText ($r,
			&Qt::AlignHCenter|&Qt::AlignBottom, "Please wait...");
}


1;
