# This file is part of qVamps.
#
# qVamps is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# qVamps is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with qVamps; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


use strict;
use warnings;

package InstCfg;


# compile time configuration
our @items =
(
# default
  {
    "type"  => "d",
    "dst"   => "bin",
    "perm"  => 0755
  },
  {
    "type"  => "d",
    "dst"   => "lib",
    "perm"  => 0755
  },
  {
    "type"  => "d",
    "dst"   => "share/qvamps/etc",
    "perm"  => 0755
  },
  {
    "type"  => "f",
    "src"   => "instfiles/qvamps",
    "dst"   => "bin/qvamps",
    "perm"  => 0755
  },
  {
    "type"  => "f",
    "src"   => "instfiles/README",
    "dst"   => "share/qvamps/README",
    "perm"  => 0644
  },
  {
    "type"  => "s",
    "src"   => "bin/qvamps-bin",
    "dst"   => "Uninstall"
  },
# Vamps
  {
    "group" => "vamps",
    "type"  => "f",
    "src"   => "instfiles/vamps",
    "dst"   => "bin/vamps",
    "perm"  => 0755
  },
  {
    "group" => "vamps",
    "type"  => "f",
    "src"   => "instfiles/play_cell",
    "dst"   => "bin/play_cell",
    "perm"  => 0755
  },
# Dvdauthor
  {
    "group" => "dvdauthor",
    "type"  => "f",
    "src"   => "instfiles/dvdauthor",
    "dst"   => "bin/dvdauthor",
    "perm"  => 0755
  },
  {
    "group" => "dvdauthor",
    "type"  => "f",
    "src"   => "instfiles/spumux",
    "dst"   => "bin/spumux",
    "perm"  => 0755
  },
  {
    "group" => "dvdauthor",
    "type"  => "f",
    "src"   => "instfiles/libxml2.so.2",
    "dst"   => "lib/libxml2.so.2",
    "perm"  => 0755
  },
# MJPEG Tools
  {
    "group" => "mjpeg_tools",
    "type"  => "f",
    "src"   => "instfiles/mpeg2enc",
    "dst"   => "bin/mpeg2enc",
    "perm"  => 0755
  },
  {
    "group" => "mjpeg_tools",
    "type"  => "f",
    "src"   => "instfiles/ppmtoy4m",
    "dst"   => "bin/ppmtoy4m",
    "perm"  => 0755
  },
  {
    "group" => "mjpeg_tools",
    "type"  => "f",
    "src"   => "instfiles/mplex",
    "dst"   => "bin/mplex",
    "perm"  => 0755
  },
  {
    "group" => "mjpeg_tools",
    "type"  => "f",
    "src"   => "instfiles/libmjpegutils-1.8.so.0",
    "dst"   => "lib/libmjpegutils-1.8.so.0",
    "perm"  => 0755
  },
  {
    "group" => "mjpeg_tools",
    "type"  => "f",
    "src"   => "instfiles/libmpeg2encpp-1.8.so.0",
    "dst"   => "lib/libmpeg2encpp-1.8.so.0",
    "perm"  => 0755
  },
  {
    "group" => "mjpeg_tools",
    "type"  => "f",
    "src"   => "instfiles/libmplex2-1.8.so.0",
    "dst"   => "lib/libmplex2-1.8.so.0",
    "perm"  => 0755
  },
# menu backgrounds
  {
    "group" => "menu_backgrounds",
    "type"  => "f",
    "src"   => "instfiles/penguin.jpg",
    "dst"   => "share/qvamps/penguin.jpg",
    "perm"  => 0644
  },
  {
    "group" => "menu_backgrounds",
    "type"  => "f",
    "src"   => "instfiles/silence.mpa",
    "dst"   => "share/qvamps/silence.mpa",
    "perm"  => 0644
  },
  {
    "group" => "menu_backgrounds",
    "type"  => "f",
    "src"   => "instfiles/penguin_ntsc.mpg",
    "dst"   => "share/qvamps/penguin_ntsc.mpg",
    "perm"  => 0644
  },
  {
    "group" => "menu_backgrounds",
    "type"  => "f",
    "src"   => "instfiles/penguin_pal.mpg",
    "dst"   => "share/qvamps/penguin_pal.mpg",
    "perm"  => 0644
  },
# symbolic link
  {
    "group" => "symbolic_link",
    "type"  => "s",
    "src"   => "bin/qvamps",
    "dst"   => "qvamps",
    "abs"   => 1
  },
# installation time
  {
    "group" => "install_time",
    "type"  => "f",
    "src"   => "script/install.pl"
  },
  {
    "group" => "install_time",
    "type"  => "f",
    "src"   => "lib/InstCfg.pm"
  },
  {
    "group" => "install_time",
    "type"  => "f",
    "src"   => "lib/Installer.pm"
  },
  {
    "group" => "install_time",
    "type"  => "f",
    "src"   => "images/inst_splash.png"
  }
);

our $script    = "run/qvamps";
our $binpar    = "bin/qvamps-bin";
our $inst_perm = 0755;


1;
