# Translations for tag names

# Note that although tag names are translated in the main list view,
# they are *not* when editing tags.

# date the song was added to the library
_("added")
_("album")
_("album artist")
_("arranger")
_("artist")
_("author")
_("composer")
_("conductor")
_("contact")
_("copyright")
_("date")
_("description")
# just path, /.../...
_("directory")
_("disc")
# this tag contains a list of errors from playing the song
_("errors")
# just file name, foo.ogg
_("filename")
# as in "file format"
_("format")
# file name plus path, /.../.../foo.ogg
_("full name")
_("genre")
_("grouping")
# alternately, "catalog number", "catalog ID", "label number"
_("label ID")
_("language")
# date the song was last heard on
_("last played")
# date the song was last started on
_("last started")
_("length")
_("license")
_("location")
_("lyricist")
# date song was last modified/edited
_("modified")
_("mount point")
# alternately, "record label"
_("organization")
_("original release date")
_("original artist")
_("original album")
# alternately, "movement", "section"
_("part")
_("people")
_("performer")
_("plays")
_("rating")
_("recording date")
_("skips")
_("title")
_("track")
_("version")
_("website")
_("year")
# beats per minute
_("BPM")

_("performers")
_("lyricists")
_("arrangers")
_("composers")
_("conductors")
_("authors")
_("artists")
_("albums")
_("tracks")
_("discs")

# Not really tag names, but this is the best place for them so far.

ngettext("%d second", "%d seconds", 1)
ngettext("%d minute", "%d minutes", 1)
ngettext("%d hour", "%d hours", 1)
ngettext("%d day", "%d days", 1)
ngettext("%d year", "%d years", 1)
