import gtk, sys
from quickly.widgets.dictionary_grid import DictionaryGrid
from quickly.widgets.grid_filter import GridFilter, BlankFilterBox
from quickly.widgets.grid_column import DateColumn

if len(sys.argv) < 2:
	print 'Please provide a bug number'
	sys.exit(1)

win = gtk.Dialog()

if sys.argv[1] == '638148':
	l = gtk.Label('Choose blarg from the bottom combo, and type something into the entry')
	win.vbox.add(l)

	dicts = [{"status": "val1_1"},
		 {"status": "val2_1"},
		 {"status": "val3_1"},
		 {"status": "val4_1"},
		 {"status": "val5_1"}]

	grid = DictionaryGrid(dictionaries=dicts)
	win.vbox.add(grid)

	def filterfunc(val1, val2):
		print 'filtering on', val1, val2
		return True
	bfilt = BlankFilterBox()
	bfilt.append("blarg", filterfunc)

	filter_hints = {"status": bfilt}
	filt = GridFilter(grid, filter_hints)
	win.vbox.add(filt)
elif sys.argv[1] == '636034':
	l = gtk.Label('Click add, notice remove button')
	win.vbox.add(l)

	dicts = [{"status": "2010/10/10"}]

	hints = {"status": DateColumn}
	grid = DictionaryGrid(dictionaries=dicts, type_hints=hints)
	win.vbox.add(grid)

	filt = GridFilter(grid)
	win.vbox.add(filt)
elif sys.argv[1] == '678239':
	l = gtk.Label('Click count column, note sorting')
	win.vbox.add(l)

	dicts = [{"count": "5"},
		 {"count": "10"},
		 {"count": "91"},
		 {"count": "9"},
		 {"count": "1"}]

	grid = DictionaryGrid(dictionaries=dicts)
	win.vbox.add(grid)
elif sys.argv[1] == '638149':
	l = gtk.Label('Enter something in entry, then click on another widget')
	win.vbox.add(l)

	dicts = [{"id": "5"},
		 {"id": "10"},
		 {"id": "91"},
		 {"id": "9"},
		 {"id": "1"}]

	grid = DictionaryGrid(dictionaries=dicts)
	win.vbox.add(grid)

	filt = GridFilter(grid)
	win.vbox.add(filt)

 
win.show_all()
win.connect("destroy", gtk.main_quit)
gtk.main()
