/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.27
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif



#include <stdlib.h>
#include <string.h>
#include <stdio.h>


/* Support for throwing C# exceptions from C/C++. There are two types: 
 * Exceptions that take a message and ArgumentExceptions that take a message and a parameter name. */
typedef enum {
  SWIG_CSharpApplicationException,
  SWIG_CSharpArithmeticException,
  SWIG_CSharpDivideByZeroException,
  SWIG_CSharpIndexOutOfRangeException,
  SWIG_CSharpInvalidOperationException,
  SWIG_CSharpIOException,
  SWIG_CSharpNullReferenceException,
  SWIG_CSharpOutOfMemoryException,
  SWIG_CSharpOverflowException,
  SWIG_CSharpSystemException
} SWIG_CSharpExceptionCodes;

typedef enum {
  SWIG_CSharpArgumentException,
  SWIG_CSharpArgumentNullException,
  SWIG_CSharpArgumentOutOfRangeException
} SWIG_CSharpExceptionArgumentCodes;

typedef void (SWIGSTDCALL* SWIG_CSharpExceptionCallback_t)(const char *);
typedef void (SWIGSTDCALL* SWIG_CSharpExceptionArgumentCallback_t)(const char *, const char *);

typedef struct {
  SWIG_CSharpExceptionCodes code;
  SWIG_CSharpExceptionCallback_t callback;
} SWIG_CSharpException_t;

typedef struct {
  SWIG_CSharpExceptionArgumentCodes code;
  SWIG_CSharpExceptionArgumentCallback_t callback;
} SWIG_CSharpExceptionArgument_t;

static SWIG_CSharpException_t SWIG_csharp_exceptions[] = {
  { SWIG_CSharpApplicationException, NULL },
  { SWIG_CSharpArithmeticException, NULL },
  { SWIG_CSharpDivideByZeroException, NULL },
  { SWIG_CSharpIndexOutOfRangeException, NULL },
  { SWIG_CSharpInvalidOperationException, NULL },
  { SWIG_CSharpIOException, NULL },
  { SWIG_CSharpNullReferenceException, NULL },
  { SWIG_CSharpOutOfMemoryException, NULL },
  { SWIG_CSharpOverflowException, NULL },
  { SWIG_CSharpSystemException, NULL }
};

static SWIG_CSharpExceptionArgument_t SWIG_csharp_exceptions_argument[] = {
  { SWIG_CSharpArgumentException, NULL },
  { SWIG_CSharpArgumentNullException, NULL },
  { SWIG_CSharpArgumentOutOfRangeException, NULL },
};

static void SWIG_CSharpSetPendingException(SWIG_CSharpExceptionCodes code, const char *msg) {
  SWIG_CSharpExceptionCallback_t callback = SWIG_csharp_exceptions[SWIG_CSharpApplicationException].callback;
  if (code >=0 && (size_t)code < sizeof(SWIG_csharp_exceptions)/sizeof(SWIG_CSharpException_t)) {
    callback = SWIG_csharp_exceptions[code].callback;
  }
  callback(msg);
}

static void SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpExceptionArgumentCodes code, const char *msg, const char *param_name) {
  SWIG_CSharpExceptionArgumentCallback_t callback = SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentException].callback;
  if (code >=0 && (size_t)code < sizeof(SWIG_csharp_exceptions_argument)/sizeof(SWIG_CSharpExceptionArgument_t)) {
    callback = SWIG_csharp_exceptions_argument[code].callback;
  }
  callback(msg, param_name);
}


#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterExceptionCallbacks_NQuantLibc(
                                                SWIG_CSharpExceptionCallback_t applicationCallback,
                                                SWIG_CSharpExceptionCallback_t arithmeticCallback,
                                                SWIG_CSharpExceptionCallback_t divideByZeroCallback, 
                                                SWIG_CSharpExceptionCallback_t indexOutOfRangeCallback, 
                                                SWIG_CSharpExceptionCallback_t invalidOperationCallback,
                                                SWIG_CSharpExceptionCallback_t ioCallback,
                                                SWIG_CSharpExceptionCallback_t nullReferenceCallback,
                                                SWIG_CSharpExceptionCallback_t outOfMemoryCallback, 
                                                SWIG_CSharpExceptionCallback_t overflowCallback, 
                                                SWIG_CSharpExceptionCallback_t systemCallback) {
  SWIG_csharp_exceptions[SWIG_CSharpApplicationException].callback = applicationCallback;
  SWIG_csharp_exceptions[SWIG_CSharpArithmeticException].callback = arithmeticCallback;
  SWIG_csharp_exceptions[SWIG_CSharpDivideByZeroException].callback = divideByZeroCallback;
  SWIG_csharp_exceptions[SWIG_CSharpIndexOutOfRangeException].callback = indexOutOfRangeCallback;
  SWIG_csharp_exceptions[SWIG_CSharpInvalidOperationException].callback = invalidOperationCallback;
  SWIG_csharp_exceptions[SWIG_CSharpIOException].callback = ioCallback;
  SWIG_csharp_exceptions[SWIG_CSharpNullReferenceException].callback = nullReferenceCallback;
  SWIG_csharp_exceptions[SWIG_CSharpOutOfMemoryException].callback = outOfMemoryCallback;
  SWIG_csharp_exceptions[SWIG_CSharpOverflowException].callback = overflowCallback;
  SWIG_csharp_exceptions[SWIG_CSharpSystemException].callback = systemCallback;
}

#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterExceptionArgumentCallbacks_NQuantLibc(
                                                SWIG_CSharpExceptionArgumentCallback_t argumentCallback,
                                                SWIG_CSharpExceptionArgumentCallback_t argumentNullCallback,
                                                SWIG_CSharpExceptionArgumentCallback_t argumentOutOfRangeCallback) {
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentException].callback = argumentCallback;
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentNullException].callback = argumentNullCallback;
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentOutOfRangeException].callback = argumentOutOfRangeCallback;
}


/* Callback for returning strings to C# without leaking memory */
typedef char * (SWIGSTDCALL* SWIG_CSharpStringHelperCallback)(const char *);
static SWIG_CSharpStringHelperCallback SWIG_csharp_string_callback = NULL;


#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterStringCallback_NQuantLibc(SWIG_CSharpStringHelperCallback callback) {
  SWIG_csharp_string_callback = callback;
}

/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, msg, ""); return nullreturn; } else


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


SWIGINTERN void SWIG_CSharpException(int code, const char *msg) {
  if (code == SWIG_ValueError) {
    SWIG_CSharpExceptionArgumentCodes exception_code = SWIG_CSharpArgumentOutOfRangeException;
    SWIG_CSharpSetPendingExceptionArgument(exception_code, msg, 0);
  } else {
    SWIG_CSharpExceptionCodes exception_code = SWIG_CSharpApplicationException;
    switch(code) {
    case SWIG_MemoryError:
      exception_code = SWIG_CSharpOutOfMemoryException;
      break;
    case SWIG_IndexError:
      exception_code = SWIG_CSharpIndexOutOfRangeException;
      break;
    case SWIG_DivisionByZero:
      exception_code = SWIG_CSharpDivideByZeroException;
      break;
    case SWIG_IOError:
      exception_code = SWIG_CSharpIOException;
      break;
    case SWIG_OverflowError:
      exception_code = SWIG_CSharpOverflowException;
      break;
    case SWIG_RuntimeError:
    case SWIG_TypeError:
    case SWIG_SyntaxError:
    case SWIG_SystemError:
    case SWIG_UnknownError:
    default:
      exception_code = SWIG_CSharpApplicationException;
      break;
    }
    SWIG_CSharpSetPendingException(exception_code, msg);
  }
}


#include <stdexcept>


#define SWIGSTDCALL


#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x000311f0
    #error using an old version of QuantLib, please update
#endif

// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig-dependent warnings

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

// debug info too long etc etc
#pragma warning(disable: 4786)
#endif


#include <string>


#include <vector>
#include <algorithm>
#include <stdexcept>


#include <map>
#include <algorithm>
#include <stdexcept>


#include <utility>


// generally useful classes
using QuantLib::Error;
using QuantLib::Handle;


using QuantLib::Observer;
using QuantLib::Observable;

static bool boost_shared_ptr_Sl_Observable_Sg__isNull(boost::shared_ptr<Observable > *self){
                return !(*self);
            }

using QuantLib::Integer;
using QuantLib::BigInteger;
using QuantLib::Natural;
using QuantLib::BigNatural;
using QuantLib::Real;
using QuantLib::Decimal;
using QuantLib::Time;
using QuantLib::Rate;
using QuantLib::Spread;
using QuantLib::DiscountFactor;
using QuantLib::Volatility;
using QuantLib::Size;


using QuantLib::Array;
using QuantLib::Matrix;

static std::string Array___str__(Array *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

typedef QuantLib::LexicographicalView<Array::iterator>
    LexicographicalView;
typedef QuantLib::LexicographicalView<Array::iterator>::y_iterator
    LexicographicalViewColumn;

static LexicographicalView *new_LexicographicalView(Array &a,Size xSize){
            return new LexicographicalView(a.begin(),a.end(),xSize);
        }
static std::string LexicographicalView___str__(LexicographicalView *self){
            std::ostringstream s;
            for (Size j=0; j<self->ySize(); j++) {
                s << "\n";
                for (Size i=0; i<self->xSize(); i++) {
                    if (i != 0)
                        s << ",";
                    s << (*self)[i][j];
                }
            }
            s << "\n";
            return s.str();
        }

typedef QuantLib::Matrix::row_iterator MatrixRow;
using QuantLib::outerProduct;
using QuantLib::transpose;
using QuantLib::SVD;

static std::string Matrix___str__(Matrix *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

using QuantLib::pseudoSqrt;
using QuantLib::SalvagingAlgorithm;


using QuantLib::CostFunction;


using QuantLib::Quote;

static bool boost_shared_ptr_Sl_Quote_Sg__isNull(boost::shared_ptr<Quote > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_Quote_Sg__asObservable(boost::shared_ptr<Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static boost::shared_ptr<Observable > Handle_Sl_Quote_Sg__asObservable(Handle<Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SimpleQuote;
typedef boost::shared_ptr<Quote> SimpleQuotePtr;

static SimpleQuotePtr *new_SimpleQuotePtr(Real value){
            return new SimpleQuotePtr(new SimpleQuote(value));
        }
static void SimpleQuotePtr_setValue(SimpleQuotePtr *self,Real value){
            boost::dynamic_pointer_cast<SimpleQuote>(*self)->setValue(value);
        }
static std::vector<boost::shared_ptr<Quote > > *new_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg___SWIG_1(int capacity){
        std::vector<boost::shared_ptr<Quote> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<boost::shared_ptr<Quote> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
static boost::shared_ptr<Quote > std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__getitemcopy(std::vector<boost::shared_ptr<Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static boost::shared_ptr<Quote > const &std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__getitem(std::vector<boost::shared_ptr<Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__setitem(std::vector<boost::shared_ptr<Quote > > *self,int index,boost::shared_ptr<Quote > const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__AddRange(std::vector<boost::shared_ptr<Quote > > *self,std::vector<boost::shared_ptr<Quote > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
static std::vector<boost::shared_ptr<Quote > > *std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__GetRange(std::vector<boost::shared_ptr<Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<boost::shared_ptr<Quote> >(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Insert(std::vector<boost::shared_ptr<Quote > > *self,int index,boost::shared_ptr<Quote > const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__InsertRange(std::vector<boost::shared_ptr<Quote > > *self,int index,std::vector<boost::shared_ptr<Quote > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__RemoveAt(std::vector<boost::shared_ptr<Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__RemoveRange(std::vector<boost::shared_ptr<Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
static std::vector<boost::shared_ptr<Quote > > *std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Repeat(boost::shared_ptr<Quote > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<boost::shared_ptr<Quote> >(count, value);
      }
static void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Reverse__SWIG_0(std::vector<boost::shared_ptr<Quote > > *self){
        std::reverse(self->begin(), self->end());
      }
static void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Reverse__SWIG_1(std::vector<boost::shared_ptr<Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__SetRange(std::vector<boost::shared_ptr<Quote > > *self,int index,std::vector<boost::shared_ptr<Quote > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
static bool std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Contains(std::vector<boost::shared_ptr<Quote > > *self,boost::shared_ptr<Quote > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
static int std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__IndexOf(std::vector<boost::shared_ptr<Quote > > *self,boost::shared_ptr<Quote > const &value){
        int index = -1;
        std::vector<boost::shared_ptr<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
static int std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__LastIndexOf(std::vector<boost::shared_ptr<Quote > > *self,boost::shared_ptr<Quote > const &value){
        int index = -1;
        std::vector<boost::shared_ptr<Quote> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
static void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Remove(std::vector<boost::shared_ptr<Quote > > *self,boost::shared_ptr<Quote > const &value){
        std::vector<boost::shared_ptr<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }
static std::vector<Handle<Quote > > *new_std_vector_Sl_Handle_Sl_Quote_Sg__Sg___SWIG_1(int capacity){
        std::vector<Handle<Quote> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<Handle<Quote> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
static Handle<Quote > std_vector_Sl_Handle_Sl_Quote_Sg__Sg__getitemcopy(std::vector<Handle<Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static Handle<Quote > const &std_vector_Sl_Handle_Sl_Quote_Sg__Sg__getitem(std::vector<Handle<Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__setitem(std::vector<Handle<Quote > > *self,int index,Handle<Quote > const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__AddRange(std::vector<Handle<Quote > > *self,std::vector<Handle<Quote > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
static std::vector<Handle<Quote > > *std_vector_Sl_Handle_Sl_Quote_Sg__Sg__GetRange(std::vector<Handle<Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<Handle<Quote> >(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Insert(std::vector<Handle<Quote > > *self,int index,Handle<Quote > const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__InsertRange(std::vector<Handle<Quote > > *self,int index,std::vector<Handle<Quote > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__RemoveAt(std::vector<Handle<Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__RemoveRange(std::vector<Handle<Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
static std::vector<Handle<Quote > > *std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Repeat(Handle<Quote > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<Handle<Quote> >(count, value);
      }
static void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Reverse__SWIG_0(std::vector<Handle<Quote > > *self){
        std::reverse(self->begin(), self->end());
      }
static void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Reverse__SWIG_1(std::vector<Handle<Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__SetRange(std::vector<Handle<Quote > > *self,int index,std::vector<Handle<Quote > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
static bool std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Contains(std::vector<Handle<Quote > > *self,Handle<Quote > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
static int std_vector_Sl_Handle_Sl_Quote_Sg__Sg__IndexOf(std::vector<Handle<Quote > > *self,Handle<Quote > const &value){
        int index = -1;
        std::vector<Handle<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
static int std_vector_Sl_Handle_Sl_Quote_Sg__Sg__LastIndexOf(std::vector<Handle<Quote > > *self,Handle<Quote > const &value){
        int index = -1;
        std::vector<Handle<Quote> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
static void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Remove(std::vector<Handle<Quote > > *self,Handle<Quote > const &value){
        std::vector<Handle<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::Day;
using QuantLib::Year;


using QuantLib::Weekday;
using QuantLib::Sunday;
using QuantLib::Monday;
using QuantLib::Tuesday;
using QuantLib::Wednesday;
using QuantLib::Thursday;
using QuantLib::Friday;
using QuantLib::Saturday;


using QuantLib::Month;
using QuantLib::January;
using QuantLib::February;
using QuantLib::March;
using QuantLib::April;
using QuantLib::May;
using QuantLib::June;
using QuantLib::July;
using QuantLib::August;
using QuantLib::September;
using QuantLib::October;
using QuantLib::November;
using QuantLib::December;


using QuantLib::TimeUnit;
using QuantLib::Days;
using QuantLib::Weeks;
using QuantLib::Months;
using QuantLib::Years;


using QuantLib::Frequency;
using QuantLib::NoFrequency;
using QuantLib::Once;
using QuantLib::Annual;
using QuantLib::Semiannual;
using QuantLib::EveryFourthMonth;
using QuantLib::Quarterly;
using QuantLib::Bimonthly;
using QuantLib::Monthly;


using QuantLib::Period;
using QuantLib::PeriodParser;

static Period *new_Period__SWIG_1(std::string const &str){
            return new Period(PeriodParser::parse(str));
        }
static std::string Period___str__(Period *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
static std::string Period___repr__(Period *self){
            std::ostringstream out;
            out << "Period(\"" << QuantLib::io::short_period(*self) << "\")";
            return out.str();
        }
static int Period___cmp__(Period *self,Period const &other){
            if (*self < other)
                return -1;
            if (*self == other)
                return 0;
            return 1;
        }
static std::vector<Period > *new_std_vector_Sl_Period_Sg___SWIG_1(int capacity){
        std::vector<Period >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<Period >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
static Period std_vector_Sl_Period_Sg__getitemcopy(std::vector<Period > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static Period const &std_vector_Sl_Period_Sg__getitem(std::vector<Period > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Period_Sg__setitem(std::vector<Period > *self,int index,Period const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Period_Sg__AddRange(std::vector<Period > *self,std::vector<Period > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
static std::vector<Period > *std_vector_Sl_Period_Sg__GetRange(std::vector<Period > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<Period >(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_Period_Sg__Insert(std::vector<Period > *self,int index,Period const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Period_Sg__InsertRange(std::vector<Period > *self,int index,std::vector<Period > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Period_Sg__RemoveAt(std::vector<Period > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Period_Sg__RemoveRange(std::vector<Period > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
static std::vector<Period > *std_vector_Sl_Period_Sg__Repeat(Period const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<Period >(count, value);
      }
static void std_vector_Sl_Period_Sg__Reverse__SWIG_0(std::vector<Period > *self){
        std::reverse(self->begin(), self->end());
      }
static void std_vector_Sl_Period_Sg__Reverse__SWIG_1(std::vector<Period > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_Period_Sg__SetRange(std::vector<Period > *self,int index,std::vector<Period > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }

using QuantLib::Date;
using QuantLib::DateParser;

static Date *new_Date__SWIG_3(std::string const &str,std::string const &fmt){
            return new Date(DateParser::parse(str,fmt));
        }
static Integer Date_weekdayNumber(Date *self){
            return int(self->weekday());
        }
static std::string Date___str__(Date *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
static std::string Date___repr__(Date *self){
            std::ostringstream out;
            out << "Date(" << self->dayOfMonth() << ","
                << int(self->month()) << "," << self->year() << ")";
            return out.str();
        }
static std::string Date_ISO(Date *self){
            std::ostringstream out;
            out << QuantLib::io::iso_date(*self);
            return out.str();
        }
static std::vector<Date > *new_std_vector_Sl_Date_Sg___SWIG_1(int capacity){
        std::vector<Date >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<Date >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
static Date std_vector_Sl_Date_Sg__getitemcopy(std::vector<Date > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static Date const &std_vector_Sl_Date_Sg__getitem(std::vector<Date > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Date_Sg__setitem(std::vector<Date > *self,int index,Date const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Date_Sg__AddRange(std::vector<Date > *self,std::vector<Date > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
static std::vector<Date > *std_vector_Sl_Date_Sg__GetRange(std::vector<Date > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<Date >(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_Date_Sg__Insert(std::vector<Date > *self,int index,Date const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Date_Sg__InsertRange(std::vector<Date > *self,int index,std::vector<Date > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Date_Sg__RemoveAt(std::vector<Date > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_Date_Sg__RemoveRange(std::vector<Date > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
static std::vector<Date > *std_vector_Sl_Date_Sg__Repeat(Date const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<Date >(count, value);
      }
static void std_vector_Sl_Date_Sg__Reverse__SWIG_0(std::vector<Date > *self){
        std::reverse(self->begin(), self->end());
      }
static void std_vector_Sl_Date_Sg__Reverse__SWIG_1(std::vector<Date > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_Date_Sg__SetRange(std::vector<Date > *self,int index,std::vector<Date > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }

using QuantLib::Null;
typedef int intOrNull;
typedef double doubleOrNull;


int nullInt() { return Null<int>(); }
double nullDouble() { return Null<double>(); }


using QuantLib::DayCounter;

static std::string DayCounter___str__(DayCounter *self){
            return self->name()+" day counter";
        }

using QuantLib::Compounding;
using QuantLib::Simple;
using QuantLib::Compounded;
using QuantLib::Continuous;
using QuantLib::SimpleThenCompounded;


using QuantLib::InterestRate;

static std::string InterestRate___str__(InterestRate *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

using QuantLib::Calendar;


using QuantLib::BusinessDayConvention;
using QuantLib::Unadjusted;
using QuantLib::Preceding;
using QuantLib::ModifiedPreceding;
using QuantLib::Following;
using QuantLib::ModifiedFollowing;
using QuantLib::MonthEndReference;


using QuantLib::JointCalendarRule;
using QuantLib::JoinHolidays;
using QuantLib::JoinBusinessDays;

static std::string Calendar___str__(Calendar *self){
            return self->name()+" calendar";
        }

using QuantLib::Rounding;
using QuantLib::UpRounding;
using QuantLib::DownRounding;
using QuantLib::ClosestRounding;
using QuantLib::CeilingTruncation;
using QuantLib::FloorTruncation;


using QuantLib::Currency;

static std::string Currency___str__(Currency *self){
            return self->name();
        }

using QuantLib::Extrapolator;


// safe versions which copy their arguments
template <class I>
class SafeInterpolation {
  public:
    SafeInterpolation(const Array& x, const Array& y)
    : x_(x), y_(y), f_(x_.begin(),x_.end(),y_.begin()) {}
    Real operator()(Real x, bool allowExtrapolation=false) {
        return f_(x, allowExtrapolation);
    }
    Array x_, y_;
    I f_;
};


typedef SafeInterpolation<QuantLib::LinearInterpolation> SafeLinearInterpolation;


typedef SafeInterpolation<QuantLib::LogLinearInterpolation> SafeLogLinearInterpolation;


typedef SafeInterpolation<QuantLib::BackwardFlatInterpolation> SafeBackwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::ForwardFlatInterpolation> SafeForwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::NaturalCubicSpline> SafeNaturalCubicSpline;

static Real SafeNaturalCubicSpline_derivative__SWIG_0(SafeNaturalCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
static Real SafeNaturalCubicSpline_secondDerivative__SWIG_0(SafeNaturalCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::NaturalMonotonicCubicSpline> SafeNaturalMonotonicCubicSpline;

static Real SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
static Real SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }

// safe versions which copy their arguments
template <class I>
class SafeInterpolation2D {
  public:
    SafeInterpolation2D(const Array& x, const Array& y, const Matrix& m)
    : x_(x), y_(y), m_(m), f_(x_.begin(),x_.end(),y_.begin(),y_.end(),m_) {}
    Real operator()(Real x, Real y, bool allowExtrapolation=false) {
        return f_(x,y, allowExtrapolation);
    }
  protected:
    Array x_, y_;
    Matrix m_;
    I f_;
};


typedef SafeInterpolation2D<QuantLib::BilinearInterpolation> SafeBilinearInterpolation;


typedef SafeInterpolation2D<QuantLib::BicubicSpline> SafeBicubicSpline;


using QuantLib::YieldTermStructure;

static bool boost_shared_ptr_Sl_YieldTermStructure_Sg__isNull(boost::shared_ptr<YieldTermStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_YieldTermStructure_Sg__asObservable(boost::shared_ptr<YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static boost::shared_ptr<Observable > Handle_Sl_YieldTermStructure_Sg__asObservable(Handle<YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::ImpliedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ImpliedTermStructurePtr;

static ImpliedTermStructurePtr *new_ImpliedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Date const &referenceDate){
            return new ImpliedTermStructurePtr(
                new ImpliedTermStructure(curveHandle, referenceDate));
        }

using QuantLib::ZeroSpreadedTermStructure;
using QuantLib::ForwardSpreadedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ZeroSpreadedTermStructurePtr;
typedef boost::shared_ptr<YieldTermStructure> ForwardSpreadedTermStructurePtr;

static ZeroSpreadedTermStructurePtr *new_ZeroSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
	        return new ZeroSpreadedTermStructurePtr(
	            new ZeroSpreadedTermStructure(curveHandle,spreadHandle));
        }
static ForwardSpreadedTermStructurePtr *new_ForwardSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
	        return new ForwardSpreadedTermStructurePtr(
	            new ForwardSpreadedTermStructure(curveHandle,spreadHandle));
        }

using QuantLib::FlatForward;
typedef boost::shared_ptr<YieldTermStructure> FlatForwardPtr;

static FlatForwardPtr *new_FlatForwardPtr__SWIG_0(Date const &referenceDate,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
static FlatForwardPtr *new_FlatForwardPtr__SWIG_3(Date const &referenceDate,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
static FlatForwardPtr *new_FlatForwardPtr__SWIG_6(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }
static FlatForwardPtr *new_FlatForwardPtr__SWIG_9(Integer settlementDays,Calendar const &calendar,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }

using QuantLib::BlackModel;

static bool boost_shared_ptr_Sl_BlackModel_Sg__isNull(boost::shared_ptr<BlackModel > *self){
                return !(*self);
            }
static boost::shared_ptr<BlackModel > *new_boost_shared_ptr_Sl_BlackModel_Sg_(Handle<Quote > const &volatility,Handle<YieldTermStructure > const &termStructure){
        return new boost::shared_ptr<BlackModel>(
            new BlackModel(volatility,termStructure));
    }

using QuantLib::PricingEngine;

static bool boost_shared_ptr_Sl_PricingEngine_Sg__isNull(boost::shared_ptr<PricingEngine > *self){
                return !(*self);
            }

using QuantLib::Instrument;

static bool boost_shared_ptr_Sl_Instrument_Sg__isNull(boost::shared_ptr<Instrument > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_Instrument_Sg__asObservable(boost::shared_ptr<Instrument > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::Stock;
typedef boost::shared_ptr<Instrument> StockPtr;

static StockPtr *new_StockPtr(Handle<Quote > const &quote){
            return new StockPtr(new Stock(quote));
        }
static std::vector<int > *new_std_vector_Sl_int_Sg___SWIG_1(int capacity){
        std::vector<int >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<int >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
static int std_vector_Sl_int_Sg__getitemcopy(std::vector<int > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static int const &std_vector_Sl_int_Sg__getitem(std::vector<int > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_int_Sg__setitem(std::vector<int > *self,int index,int const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_int_Sg__AddRange(std::vector<int > *self,std::vector<int > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
static std::vector<int > *std_vector_Sl_int_Sg__GetRange(std::vector<int > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<int >(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_int_Sg__Insert(std::vector<int > *self,int index,int const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_int_Sg__InsertRange(std::vector<int > *self,int index,std::vector<int > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_int_Sg__RemoveAt(std::vector<int > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_int_Sg__RemoveRange(std::vector<int > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
static std::vector<int > *std_vector_Sl_int_Sg__Repeat(int const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<int >(count, value);
      }
static void std_vector_Sl_int_Sg__Reverse__SWIG_0(std::vector<int > *self){
        std::reverse(self->begin(), self->end());
      }
static void std_vector_Sl_int_Sg__Reverse__SWIG_1(std::vector<int > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_int_Sg__SetRange(std::vector<int > *self,int index,std::vector<int > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
static bool std_vector_Sl_int_Sg__Contains(std::vector<int > *self,int const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
static int std_vector_Sl_int_Sg__IndexOf(std::vector<int > *self,int const &value){
        int index = -1;
        std::vector<int >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
static int std_vector_Sl_int_Sg__LastIndexOf(std::vector<int > *self,int const &value){
        int index = -1;
        std::vector<int >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
static void std_vector_Sl_int_Sg__Remove(std::vector<int > *self,int const &value){
        std::vector<int >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }
static std::vector<double > *new_std_vector_Sl_double_Sg___SWIG_1(int capacity){
        std::vector<double >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<double >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
static double std_vector_Sl_double_Sg__getitemcopy(std::vector<double > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static double const &std_vector_Sl_double_Sg__getitem(std::vector<double > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_double_Sg__setitem(std::vector<double > *self,int index,double const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_double_Sg__AddRange(std::vector<double > *self,std::vector<double > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
static std::vector<double > *std_vector_Sl_double_Sg__GetRange(std::vector<double > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<double >(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_double_Sg__Insert(std::vector<double > *self,int index,double const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_double_Sg__InsertRange(std::vector<double > *self,int index,std::vector<double > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_double_Sg__RemoveAt(std::vector<double > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_double_Sg__RemoveRange(std::vector<double > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
static std::vector<double > *std_vector_Sl_double_Sg__Repeat(double const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<double >(count, value);
      }
static void std_vector_Sl_double_Sg__Reverse__SWIG_0(std::vector<double > *self){
        std::reverse(self->begin(), self->end());
      }
static void std_vector_Sl_double_Sg__Reverse__SWIG_1(std::vector<double > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_double_Sg__SetRange(std::vector<double > *self,int index,std::vector<double > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
static bool std_vector_Sl_double_Sg__Contains(std::vector<double > *self,double const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
static int std_vector_Sl_double_Sg__IndexOf(std::vector<double > *self,double const &value){
        int index = -1;
        std::vector<double >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
static int std_vector_Sl_double_Sg__LastIndexOf(std::vector<double > *self,double const &value){
        int index = -1;
        std::vector<double >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
static void std_vector_Sl_double_Sg__Remove(std::vector<double > *self,double const &value){
        std::vector<double >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }
static std::vector<std::string > *new_std_vector_Sl_std_string_Sg___SWIG_1(int capacity){
        std::vector<std::string >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<std::string >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
static std::string std_vector_Sl_std_string_Sg__getitemcopy(std::vector<std::string > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static std::string const &std_vector_Sl_std_string_Sg__getitem(std::vector<std::string > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_std_string_Sg__setitem(std::vector<std::string > *self,int index,std::string const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_std_string_Sg__AddRange(std::vector<std::string > *self,std::vector<std::string > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
static std::vector<std::string > *std_vector_Sl_std_string_Sg__GetRange(std::vector<std::string > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<std::string >(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_std_string_Sg__Insert(std::vector<std::string > *self,int index,std::string const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_std_string_Sg__InsertRange(std::vector<std::string > *self,int index,std::vector<std::string > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_std_string_Sg__RemoveAt(std::vector<std::string > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_std_string_Sg__RemoveRange(std::vector<std::string > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
static std::vector<std::string > *std_vector_Sl_std_string_Sg__Repeat(std::string const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<std::string >(count, value);
      }
static void std_vector_Sl_std_string_Sg__Reverse__SWIG_0(std::vector<std::string > *self){
        std::reverse(self->begin(), self->end());
      }
static void std_vector_Sl_std_string_Sg__Reverse__SWIG_1(std::vector<std::string > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_std_string_Sg__SetRange(std::vector<std::string > *self,int index,std::vector<std::string > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
static bool std_vector_Sl_std_string_Sg__Contains(std::vector<std::string > *self,std::string const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
static int std_vector_Sl_std_string_Sg__IndexOf(std::vector<std::string > *self,std::string const &value){
        int index = -1;
        std::vector<std::string >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
static int std_vector_Sl_std_string_Sg__LastIndexOf(std::vector<std::string > *self,std::string const &value){
        int index = -1;
        std::vector<std::string >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
static void std_vector_Sl_std_string_Sg__Remove(std::vector<std::string > *self,std::string const &value){
        std::vector<std::string >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::History;
typedef History::Entry HistoryEntry;

static Size History___len__(History *self){
            return self->size();
        }

using QuantLib::IndexManager;


using QuantLib::Index;

static bool boost_shared_ptr_Sl_Index_Sg__isNull(boost::shared_ptr<Index > *self){
                return !(*self);
            }
static std::string boost_shared_ptr_Sl_Index_Sg____str__(boost::shared_ptr<Index > *self){
        if (*self)
            return (*self)->name()+" index";
        else
            return "Null index";
    }

using QuantLib::Xibor;
typedef boost::shared_ptr<Index> XiborPtr;

static XiborPtr *new_XiborPtr(std::string const &familyName,Integer n,TimeUnit units,Integer settlementDays,Currency const &currency,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Handle<YieldTermStructure > const &h){
            return new XiborPtr(new Xibor(familyName, n, units, settlementDays,
                                          currency, calendar, convention,
                                          dayCounter, h));
        }
static Period XiborPtr_tenor(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->tenor();
        }
static Frequency XiborPtr_frequency(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->frequency();
        }
static Currency XiborPtr_currency(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->currency();
        }
static Calendar XiborPtr_calendar(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->calendar();
        }
static bool XiborPtr_isAdjusted(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->isAdjusted();
        }
static BusinessDayConvention XiborPtr_businessDayConvention(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)
                 ->businessDayConvention();
        }
static DayCounter XiborPtr_dayCounter(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->dayCounter();
        }

using QuantLib::AUDLibor;
typedef boost::shared_ptr<Index> AUDLiborPtr;

static AUDLiborPtr *new_AUDLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new AUDLiborPtr(new AUDLibor(n,units,h,dayCount));
      }

using QuantLib::CADLibor;
typedef boost::shared_ptr<Index> CADLiborPtr;

static CADLiborPtr *new_CADLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new CADLiborPtr(new CADLibor(n,units,h,dayCount));
      }

using QuantLib::Cdor;
typedef boost::shared_ptr<Index> CdorPtr;

static CdorPtr *new_CdorPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new CdorPtr(new Cdor(n,units,h,dayCount));
      }

using QuantLib::CHFLibor;
typedef boost::shared_ptr<Index> CHFLiborPtr;

static CHFLiborPtr *new_CHFLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new CHFLiborPtr(new CHFLibor(n,units,h,dayCount));
      }

using QuantLib::Euribor;
typedef boost::shared_ptr<Index> EuriborPtr;

static EuriborPtr *new_EuriborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new EuriborPtr(new Euribor(n,units,h,dayCount));
      }

using QuantLib::GBPLibor;
typedef boost::shared_ptr<Index> GBPLiborPtr;

static GBPLiborPtr *new_GBPLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual365Fixed()){
          return new GBPLiborPtr(new GBPLibor(n,units,h,dayCount));
      }

using QuantLib::Jibar;
typedef boost::shared_ptr<Index> JibarPtr;

static JibarPtr *new_JibarPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual365Fixed()){
          return new JibarPtr(new Jibar(n,units,h,dayCount));
      }

using QuantLib::JPYLibor;
typedef boost::shared_ptr<Index> JPYLiborPtr;

static JPYLiborPtr *new_JPYLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new JPYLiborPtr(new JPYLibor(n,units,h,dayCount));
      }

using QuantLib::Tibor;
typedef boost::shared_ptr<Index> TiborPtr;

static TiborPtr *new_TiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual365Fixed()){
          return new TiborPtr(new Tibor(n,units,h,dayCount));
      }

using QuantLib::TRLibor;
typedef boost::shared_ptr<Index> TRLiborPtr;

static TRLiborPtr *new_TRLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new TRLiborPtr(new TRLibor(n,units,h,dayCount));
      }

using QuantLib::USDLibor;
typedef boost::shared_ptr<Index> USDLiborPtr;

static USDLiborPtr *new_USDLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new USDLiborPtr(new USDLibor(n,units,h,dayCount));
      }

using QuantLib::Zibor;
typedef boost::shared_ptr<Index> ZiborPtr;

static ZiborPtr *new_ZiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new ZiborPtr(new Zibor(n,units,h,dayCount));
      }

using QuantLib::Schedule;


using QuantLib::CashFlow;

static bool boost_shared_ptr_Sl_CashFlow_Sg__isNull(boost::shared_ptr<CashFlow > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_CashFlow_Sg__asObservable(boost::shared_ptr<CashFlow > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SimpleCashFlow;
using QuantLib::FixedRateCoupon;
using QuantLib::ParCoupon;
typedef boost::shared_ptr<CashFlow> SimpleCashFlowPtr;
typedef boost::shared_ptr<CashFlow> FixedRateCouponPtr;
typedef boost::shared_ptr<CashFlow> ParCouponPtr;

static SimpleCashFlowPtr *new_SimpleCashFlowPtr(Real amount,Date const &date){
            return new SimpleCashFlowPtr(new SimpleCashFlow(amount,date));
        }
static FixedRateCouponPtr *new_FixedRateCouponPtr__SWIG_0(Real nominal,Date const &paymentDate,Rate rate,DayCounter const &dayCounter,Date const &startDate,Date const &endDate,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date()){
            return new FixedRateCouponPtr(
                new FixedRateCoupon(nominal, paymentDate, rate,
                                    dayCounter, startDate, endDate,
                                    refPeriodStart, refPeriodEnd));
        }
static ParCouponPtr *new_ParCouponPtr__SWIG_0(Real nominal,Date const &paymentDate,XiborPtr const &index,Date const &startDate,Date const &endDate,Integer fixingDays,Spread spread=0.0,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date()){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new ParCouponPtr(
                new ParCoupon(nominal, paymentDate, libor,
                              startDate, endDate, fixingDays, spread,
                              refPeriodStart, refPeriodEnd));
        }
static Date ParCouponPtr_accrualStartDate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                 ->accrualStartDate();
        }
static Date ParCouponPtr_accrualEndDate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                 ->accrualEndDate();
        }
static Rate ParCouponPtr_rate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->rate();
        }
static Rate ParCouponPtr_indexFixing(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                ->indexFixing();
        }
static Real ParCouponPtr_nominal(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->nominal();
        }
static std::vector<boost::shared_ptr<CashFlow > > *new_std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg___SWIG_1(int capacity){
        std::vector<boost::shared_ptr<CashFlow> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<boost::shared_ptr<CashFlow> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
static boost::shared_ptr<CashFlow > std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__getitemcopy(std::vector<boost::shared_ptr<CashFlow > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static boost::shared_ptr<CashFlow > const &std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__getitem(std::vector<boost::shared_ptr<CashFlow > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__setitem(std::vector<boost::shared_ptr<CashFlow > > *self,int index,boost::shared_ptr<CashFlow > const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__AddRange(std::vector<boost::shared_ptr<CashFlow > > *self,std::vector<boost::shared_ptr<CashFlow > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
static std::vector<boost::shared_ptr<CashFlow > > *std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__GetRange(std::vector<boost::shared_ptr<CashFlow > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<boost::shared_ptr<CashFlow> >(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Insert(std::vector<boost::shared_ptr<CashFlow > > *self,int index,boost::shared_ptr<CashFlow > const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__InsertRange(std::vector<boost::shared_ptr<CashFlow > > *self,int index,std::vector<boost::shared_ptr<CashFlow > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__RemoveAt(std::vector<boost::shared_ptr<CashFlow > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__RemoveRange(std::vector<boost::shared_ptr<CashFlow > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
static std::vector<boost::shared_ptr<CashFlow > > *std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Repeat(boost::shared_ptr<CashFlow > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<boost::shared_ptr<CashFlow> >(count, value);
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Reverse__SWIG_0(std::vector<boost::shared_ptr<CashFlow > > *self){
        std::reverse(self->begin(), self->end());
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Reverse__SWIG_1(std::vector<boost::shared_ptr<CashFlow > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__SetRange(std::vector<boost::shared_ptr<CashFlow > > *self,int index,std::vector<boost::shared_ptr<CashFlow > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
static bool std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Contains(std::vector<boost::shared_ptr<CashFlow > > *self,boost::shared_ptr<CashFlow > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
static int std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__IndexOf(std::vector<boost::shared_ptr<CashFlow > > *self,boost::shared_ptr<CashFlow > const &value){
        int index = -1;
        std::vector<boost::shared_ptr<CashFlow> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
static int std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__LastIndexOf(std::vector<boost::shared_ptr<CashFlow > > *self,boost::shared_ptr<CashFlow > const &value){
        int index = -1;
        std::vector<boost::shared_ptr<CashFlow> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Remove(std::vector<boost::shared_ptr<CashFlow > > *self,boost::shared_ptr<CashFlow > const &value){
        std::vector<boost::shared_ptr<CashFlow> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::FixedRateCouponVector;


std::vector<boost::shared_ptr<CashFlow> >
FloatingRateCouponVector(const Schedule& schedule,
                         BusinessDayConvention paymentAdjustment,
                         const std::vector<Real>& nominals,
                         const XiborPtr& index, Integer fixingDays,
                         const std::vector<Spread>& spreads =
                             std::vector<Spread>()) {
    boost::shared_ptr<Xibor> libor =
        boost::dynamic_pointer_cast<Xibor>(index);
    return QuantLib::FloatingRateCouponVector(schedule,paymentAdjustment,
                                              nominals,libor,
                                              fixingDays,spreads);
}


using QuantLib::Cashflows;
using QuantLib::Duration;


using QuantLib::Bond;
using QuantLib::ZeroCouponBond;
using QuantLib::FixedCouponBond;
using QuantLib::FloatingRateBond;
typedef boost::shared_ptr<Instrument> BondPtr;
typedef boost::shared_ptr<Instrument> ZeroCouponBondPtr;
typedef boost::shared_ptr<Instrument> FixedCouponBondPtr;
typedef boost::shared_ptr<Instrument> FloatingRateBondPtr;

static Date BondPtr_settlementDate(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->settlementDate();
        }
static std::vector<boost::shared_ptr<CashFlow > > BondPtr_cashflows(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cashflows();
        }
static boost::shared_ptr<CashFlow > BondPtr_redemption(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->redemption();
        }
static Calendar BondPtr_calendar(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->calendar();
        }
static BusinessDayConvention BondPtr_businessDayConvention(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->businessDayConvention();
        }
static DayCounter BondPtr_dayCounter(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->dayCounter();
        }
static Frequency BondPtr_frequency(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->frequency();
        }
static Real BondPtr_cleanPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cleanPrice();
        }
static Real BondPtr_cleanPrice__SWIG_1(BondPtr *self,Rate yield,Compounding compounding,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->cleanPrice(yield,compounding,settlement);
        }
static Real BondPtr_dirtyPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->dirtyPrice();
        }
static Real BondPtr_dirtyPrice__SWIG_1(BondPtr *self,Rate yield,Compounding compounding,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->dirtyPrice(yield,compounding,settlement);
        }
static Real BondPtr_yield__SWIG_0(BondPtr *self,Compounding compounding,Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(compounding,accuracy,maxEvaluations);
        }
static Real BondPtr_yield__SWIG_3(BondPtr *self,Real cleanPrice,Compounding compounding,Date const &settlement=Date(),Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(cleanPrice,compounding,settlement,
                        accuracy,maxEvaluations);
        }
static Real BondPtr_accruedAmount__SWIG_0(BondPtr *self,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->accruedAmount(settlement);
        }
static ZeroCouponBondPtr *new_ZeroCouponBondPtr__SWIG_0(Date const &issueDate,Date const &maturityDate,Integer settlementDays,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention=QuantLib::Following,Real redemption=100.0,Handle<YieldTermStructure > const &discountCurve=Handle<YieldTermStructure >()){
            return new ZeroCouponBondPtr(
                new ZeroCouponBond(issueDate, maturityDate, settlementDays,
                                   dayCounter, calendar, convention,
                                   redemption, discountCurve));
        }
static FixedCouponBondPtr *new_FixedCouponBondPtr__SWIG_0(Date const &issueDate,Date const &datedDate,Date const &maturityDate,Integer settlementDays,std::vector<Rate > const &coupons,Frequency couponFrequency,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention=QuantLib::Following,Real redemption=100.0,Handle<YieldTermStructure > const &discountCurve=Handle<YieldTermStructure >(),Date const &stub=Date(),bool fromEnd=true){
            return new FixedCouponBondPtr(
                new FixedCouponBond(issueDate, datedDate, maturityDate,
                                    settlementDays, coupons, couponFrequency,
                                    dayCounter, calendar, convention,
                                    redemption, discountCurve, stub, fromEnd));
        }
static FloatingRateBondPtr *new_FloatingRateBondPtr__SWIG_0(Date const &issueDate,Date const &datedDate,Date const &maturityDate,Integer settlementDays,XiborPtr const &index,Integer fixingDays,std::vector<Spread > const &spreads,Frequency couponFrequency,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention=QuantLib::Following,Real redemption=100.0,Handle<YieldTermStructure > const &discountCurve=Handle<YieldTermStructure >(),Date const &stub=Date(),bool fromEnd=true){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new FloatingRateBondPtr(
                new FloatingRateBond(issueDate, datedDate, maturityDate,
                                     settlementDays, libor, fixingDays,
                                     spreads, couponFrequency,
                                     dayCounter, calendar, convention,
                                     redemption, discountCurve,
                                     stub, fromEnd));
        }

using QuantLib::Exercise;
typedef Exercise::Type ExerciseType;

Exercise::Type exerciseTypeFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "e" || s == "european")
        return Exercise::European;
    else if (s == "a" || s == "american")
        return Exercise::American;
    else if (s == "b" || s == "bermudan")
        return Exercise::Bermudan;
    else
        QL_FAIL("unknown exercise type: "+s);
}

std::string exerciseTypeToString(Exercise::Type t) {
    switch (t) {
      case Exercise::European:
        return "European";
      case Exercise::American:
        return "American";
      case Exercise::Bermudan:
        return "Bermudan";
      default:
        QL_FAIL("unknown exercise type");
    }
}

static bool boost_shared_ptr_Sl_Exercise_Sg__isNull(boost::shared_ptr<Exercise > *self){
                return !(*self);
            }

using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;
typedef boost::shared_ptr<Exercise> EuropeanExercisePtr;
typedef boost::shared_ptr<Exercise> AmericanExercisePtr;
typedef boost::shared_ptr<Exercise> BermudanExercisePtr;

static EuropeanExercisePtr *new_EuropeanExercisePtr(Date const &date){
            return new EuropeanExercisePtr(new EuropeanExercise(date));
        }
static AmericanExercisePtr *new_AmericanExercisePtr__SWIG_0(Date const &earliestDate,Date const &latestDate,bool payoffAtExpiry=false){
            return new AmericanExercisePtr(
                                        new AmericanExercise(earliestDate,
                                                             latestDate,
                                                             payoffAtExpiry));
        }
static BermudanExercisePtr *new_BermudanExercisePtr__SWIG_0(std::vector<Date > const &dates,bool payoffAtExpiry=false){
            return new BermudanExercisePtr(
                                        new BermudanExercise(dates,
                                                             payoffAtExpiry));
        }

using QuantLib::BlackVolTermStructure;
using QuantLib::LocalVolTermStructure;

static bool boost_shared_ptr_Sl_BlackVolTermStructure_Sg__isNull(boost::shared_ptr<BlackVolTermStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_BlackVolTermStructure_Sg__asObservable(boost::shared_ptr<BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static boost::shared_ptr<Observable > Handle_Sl_BlackVolTermStructure_Sg__asObservable(Handle<BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static bool boost_shared_ptr_Sl_LocalVolTermStructure_Sg__isNull(boost::shared_ptr<LocalVolTermStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_LocalVolTermStructure_Sg__asObservable(boost::shared_ptr<LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static boost::shared_ptr<Observable > Handle_Sl_LocalVolTermStructure_Sg__asObservable(Handle<LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::BlackConstantVol;
typedef boost::shared_ptr<BlackVolTermStructure> BlackConstantVolPtr;

static BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, volatility, dayCounter));
        }
static BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, volatility, dayCounter));
        }
static BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
static BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::BlackVarianceSurface;
typedef BlackVarianceSurface::Extrapolation VolExtrapolationType;
typedef boost::shared_ptr<BlackVolTermStructure> BlackVarianceSurfacePtr;

VolExtrapolationType volExTypeFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "const" || s == "constant")
        return BlackVarianceSurface::ConstantExtrapolation;
    else if (s == "" || s == "default")
        return BlackVarianceSurface::InterpolatorDefaultExtrapolation;
    else
        QL_FAIL("unknown extrapolation type: "+s);
}

std::string volExTypeToString(VolExtrapolationType t) {
    switch (t) {
      case BlackVarianceSurface::ConstantExtrapolation:
        return "constant";
      case BlackVarianceSurface::InterpolatorDefaultExtrapolation:
        return "default";
      default:
        QL_FAIL("unknown extrapolation type");
    }
}

static BlackVarianceSurfacePtr *new_BlackVarianceSurfacePtr__SWIG_0(Date const &referenceDate,std::vector<Date > const &dates,std::vector<Real > const &strikes,Matrix const &blackVols,DayCounter const &dayCounter,VolExtrapolationType lower=BlackVarianceSurface::InterpolatorDefaultExtrapolation,VolExtrapolationType upper=BlackVarianceSurface::InterpolatorDefaultExtrapolation){
            return new BlackVarianceSurfacePtr(
                new BlackVarianceSurface(referenceDate,dates,strikes,
                                         blackVols,dayCounter,lower,upper));
        }

using QuantLib::LocalConstantVol;
typedef boost::shared_ptr<LocalVolTermStructure> LocalConstantVolPtr;

static LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
static LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
static LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
static LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::GenericStochasticProcess;

static bool boost_shared_ptr_Sl_GenericStochasticProcess_Sg__isNull(boost::shared_ptr<GenericStochasticProcess > *self){
                return !(*self);
            }

using QuantLib::StochasticProcess1D;
typedef boost::shared_ptr<GenericStochasticProcess> StochasticProcess1DPtr;


using QuantLib::BlackScholesProcess;
typedef boost::shared_ptr<GenericStochasticProcess> BlackScholesProcessPtr;

static BlackScholesProcessPtr *new_BlackScholesProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new BlackScholesProcessPtr(
                              new BlackScholesProcess(s0, dividendTS,
                                                      riskFreeTS, volTS));
      }

using QuantLib::Merton76Process;
typedef boost::shared_ptr<GenericStochasticProcess> Merton76ProcessPtr;

static Merton76ProcessPtr *new_Merton76ProcessPtr(Handle<Quote > const &stateVariable,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS,Handle<Quote > const &jumpIntensity,Handle<Quote > const &meanLogJump,Handle<Quote > const &jumpVolatility){
            return new Merton76ProcessPtr(
                              new Merton76Process(stateVariable, dividendTS,
                                                  riskFreeTS, volTS,
                                                  jumpIntensity, meanLogJump,
                                                  jumpVolatility));
      }
static std::vector<StochasticProcess1DPtr > *new_std_vector_Sl_StochasticProcess1DPtr_Sg___SWIG_1(int capacity){
        std::vector<StochasticProcess1DPtr >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<StochasticProcess1DPtr >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
static StochasticProcess1DPtr std_vector_Sl_StochasticProcess1DPtr_Sg__getitemcopy(std::vector<StochasticProcess1DPtr > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static StochasticProcess1DPtr const &std_vector_Sl_StochasticProcess1DPtr_Sg__getitem(std::vector<StochasticProcess1DPtr > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_StochasticProcess1DPtr_Sg__setitem(std::vector<StochasticProcess1DPtr > *self,int index,StochasticProcess1DPtr const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_StochasticProcess1DPtr_Sg__AddRange(std::vector<StochasticProcess1DPtr > *self,std::vector<StochasticProcess1DPtr > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
static std::vector<StochasticProcess1DPtr > *std_vector_Sl_StochasticProcess1DPtr_Sg__GetRange(std::vector<StochasticProcess1DPtr > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<StochasticProcess1DPtr >(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_StochasticProcess1DPtr_Sg__Insert(std::vector<StochasticProcess1DPtr > *self,int index,StochasticProcess1DPtr const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_StochasticProcess1DPtr_Sg__InsertRange(std::vector<StochasticProcess1DPtr > *self,int index,std::vector<StochasticProcess1DPtr > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_StochasticProcess1DPtr_Sg__RemoveAt(std::vector<StochasticProcess1DPtr > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_StochasticProcess1DPtr_Sg__RemoveRange(std::vector<StochasticProcess1DPtr > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
static std::vector<StochasticProcess1DPtr > *std_vector_Sl_StochasticProcess1DPtr_Sg__Repeat(StochasticProcess1DPtr const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<StochasticProcess1DPtr >(count, value);
      }
static void std_vector_Sl_StochasticProcess1DPtr_Sg__Reverse__SWIG_0(std::vector<StochasticProcess1DPtr > *self){
        std::reverse(self->begin(), self->end());
      }
static void std_vector_Sl_StochasticProcess1DPtr_Sg__Reverse__SWIG_1(std::vector<StochasticProcess1DPtr > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_StochasticProcess1DPtr_Sg__SetRange(std::vector<StochasticProcess1DPtr > *self,int index,std::vector<StochasticProcess1DPtr > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
static bool std_vector_Sl_StochasticProcess1DPtr_Sg__Contains(std::vector<StochasticProcess1DPtr > *self,StochasticProcess1DPtr const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
static int std_vector_Sl_StochasticProcess1DPtr_Sg__IndexOf(std::vector<StochasticProcess1DPtr > *self,StochasticProcess1DPtr const &value){
        int index = -1;
        std::vector<StochasticProcess1DPtr >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
static int std_vector_Sl_StochasticProcess1DPtr_Sg__LastIndexOf(std::vector<StochasticProcess1DPtr > *self,StochasticProcess1DPtr const &value){
        int index = -1;
        std::vector<StochasticProcess1DPtr >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
static void std_vector_Sl_StochasticProcess1DPtr_Sg__Remove(std::vector<StochasticProcess1DPtr > *self,StochasticProcess1DPtr const &value){
        std::vector<StochasticProcess1DPtr >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::Option;
using QuantLib::Barrier;


using QuantLib::Payoff;
using QuantLib::StrikedTypePayoff;

static bool boost_shared_ptr_Sl_Payoff_Sg__isNull(boost::shared_ptr<Payoff > *self){
                return !(*self);
            }

using QuantLib::VanillaOption;
typedef boost::shared_ptr<Instrument> VanillaOptionPtr;

static VanillaOptionPtr *new_VanillaOptionPtr__SWIG_0(boost::shared_ptr<GenericStochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new VanillaOptionPtr(
                         new VanillaOption(process,stPayoff,exercise,engine));
        }
static Real VanillaOptionPtr_delta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->delta();
        }
static Real VanillaOptionPtr_gamma(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->gamma();
        }
static Real VanillaOptionPtr_theta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->theta();
        }
static Real VanillaOptionPtr_vega(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->vega();
        }
static Real VanillaOptionPtr_rho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->rho();
        }
static Real VanillaOptionPtr_dividendRho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->dividendRho();
        }
static Real VanillaOptionPtr_strikeSensitivity(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->strikeSensitivity();
        }
static Volatility VanillaOptionPtr_impliedVolatility__SWIG_0(VanillaOptionPtr *self,Real targetValue,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }

using QuantLib::EuropeanOption;
typedef boost::shared_ptr<Instrument> EuropeanOptionPtr;

static EuropeanOptionPtr *new_EuropeanOptionPtr__SWIG_0(boost::shared_ptr<GenericStochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new EuropeanOptionPtr(
                        new EuropeanOption(process,stPayoff,exercise,engine));
        }

using QuantLib::AnalyticEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticEuropeanEnginePtr;

static AnalyticEuropeanEnginePtr *new_AnalyticEuropeanEnginePtr(){
            return new AnalyticEuropeanEnginePtr(new AnalyticEuropeanEngine);
        }

using QuantLib::IntegralEngine;
typedef boost::shared_ptr<PricingEngine> IntegralEnginePtr;

static IntegralEnginePtr *new_IntegralEnginePtr(){
            return new IntegralEnginePtr(new IntegralEngine);
        }

using QuantLib::FDEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> FDEuropeanEnginePtr;

static FDEuropeanEnginePtr *new_FDEuropeanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDEuropeanEnginePtr(
                    new FDEuropeanEngine(timeSteps,gridPoints,timeDependent));
        }

using QuantLib::BinomialVanillaEngine;
using QuantLib::CoxRossRubinstein;
using QuantLib::JarrowRudd;
using QuantLib::AdditiveEQPBinomialTree;
using QuantLib::Trigeorgis;
using QuantLib::Tian;
using QuantLib::LeisenReimer;
typedef boost::shared_ptr<PricingEngine> BinomialVanillaEnginePtr;

static BinomialVanillaEnginePtr *new_BinomialVanillaEnginePtr(std::string const &type,Size steps){
            std::string s = QuantLib::lowercase(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<CoxRossRubinstein>(steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<JarrowRudd>(steps));
            else if (s == "eqp")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<AdditiveEQPBinomialTree>(steps));
            else if (s == "trigeorgis")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Trigeorgis>(steps));
            else if (s == "tian")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Tian>(steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<LeisenReimer>(steps));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }

using QuantLib::MCEuropeanEngine;
using QuantLib::PseudoRandom;
using QuantLib::LowDiscrepancy;
typedef boost::shared_ptr<PricingEngine> MCEuropeanEnginePtr;

static MCEuropeanEnginePtr *new_MCEuropeanEnginePtr(std::string const &traits,intOrNull timeSteps=Null<Size >(),intOrNull timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),BigInteger seed=0){
            std::string s = QuantLib::lowercase(traits);
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            if (s == "pseudorandom" || s == "pr")
                return new MCEuropeanEnginePtr(
                         new MCEuropeanEngine<PseudoRandom>(timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCEuropeanEnginePtr(
                       new MCEuropeanEngine<LowDiscrepancy>(timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::FDAmericanEngine;
using QuantLib::FDShoutEngine;
typedef boost::shared_ptr<PricingEngine> FDAmericanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDShoutEnginePtr;

static FDAmericanEnginePtr *new_FDAmericanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDAmericanEnginePtr(
                    new FDAmericanEngine(timeSteps,gridPoints,timeDependent));
        }
static FDShoutEnginePtr *new_FDShoutEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDShoutEnginePtr(
                       new FDShoutEngine(timeSteps,gridPoints,timeDependent));
        }

using QuantLib::BaroneAdesiWhaleyApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BaroneAdesiWhaleyApproximationEnginePtr;

static BaroneAdesiWhaleyApproximationEnginePtr *new_BaroneAdesiWhaleyApproximationEnginePtr(){
            return new BaroneAdesiWhaleyApproximationEnginePtr(
                new BaroneAdesiWhaleyApproximationEngine);
        }

using QuantLib::BjerksundStenslandApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BjerksundStenslandApproximationEnginePtr;

static BjerksundStenslandApproximationEnginePtr *new_BjerksundStenslandApproximationEnginePtr(){
            return new BjerksundStenslandApproximationEnginePtr(
                new BjerksundStenslandApproximationEngine);
        }

using QuantLib::AnalyticDigitalAmericanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDigitalAmericanEnginePtr;

static AnalyticDigitalAmericanEnginePtr *new_AnalyticDigitalAmericanEnginePtr(){
            return new AnalyticDigitalAmericanEnginePtr(
                new AnalyticDigitalAmericanEngine);
        }

using QuantLib::DividendVanillaOption;
typedef boost::shared_ptr<Instrument> DividendVanillaOptionPtr;

static DividendVanillaOptionPtr *new_DividendVanillaOptionPtr__SWIG_0(boost::shared_ptr<GenericStochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,std::vector<Date > const &dividendDates,std::vector<Real > const &dividends,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new DividendVanillaOptionPtr(
                   new DividendVanillaOption(process,stPayoff,exercise,
                                             dividendDates,dividends,engine));
        }
static Real DividendVanillaOptionPtr_delta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->delta();
        }
static Real DividendVanillaOptionPtr_gamma(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->gamma();
        }
static Real DividendVanillaOptionPtr_theta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->theta();
        }
static Real DividendVanillaOptionPtr_vega(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->vega();
        }
static Real DividendVanillaOptionPtr_rho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->rho();
        }
static Real DividendVanillaOptionPtr_dividendRho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->dividendRho();
        }
static Real DividendVanillaOptionPtr_strikeSensitivity(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->strikeSensitivity();
        }
static Volatility DividendVanillaOptionPtr_impliedVolatility__SWIG_0(DividendVanillaOptionPtr *self,Real targetValue,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }

using QuantLib::AnalyticDividendEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDividendEuropeanEnginePtr;

static AnalyticDividendEuropeanEnginePtr *new_AnalyticDividendEuropeanEnginePtr(){
            return new AnalyticDividendEuropeanEnginePtr(
                new AnalyticDividendEuropeanEngine);
        }

using QuantLib::FDDividendEuropeanEngine;
using QuantLib::FDDividendAmericanEngine;
typedef boost::shared_ptr<PricingEngine> FDDividendEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDDividendAmericanEnginePtr;

static FDDividendEuropeanEnginePtr *new_FDDividendEuropeanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDDividendEuropeanEnginePtr(
                new FDDividendEuropeanEngine(timeSteps,gridPoints,
                                             timeDependent));
        }
static FDDividendAmericanEnginePtr *new_FDDividendAmericanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDDividendAmericanEnginePtr(
                new FDDividendAmericanEngine(timeSteps,gridPoints,
                                             timeDependent));
        }

using QuantLib::BarrierOption;
typedef boost::shared_ptr<Instrument> BarrierOptionPtr;

static BarrierOptionPtr *new_BarrierOptionPtr__SWIG_0(Barrier::Type barrierType,Real barrier,Real rebate,boost::shared_ptr<GenericStochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new BarrierOptionPtr(
                         new BarrierOption(barrierType, barrier, rebate,
                                           process,stPayoff,exercise,engine));
        }
static Real BarrierOptionPtr_errorEstimate(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->errorEstimate();
        }
static Real BarrierOptionPtr_delta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->delta();
        }
static Real BarrierOptionPtr_gamma(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->gamma();
        }
static Real BarrierOptionPtr_theta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->theta();
        }
static Real BarrierOptionPtr_vega(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->vega();
        }
static Real BarrierOptionPtr_rho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->rho();
        }
static Real BarrierOptionPtr_dividendRho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->dividendRho();
        }
static Real BarrierOptionPtr_strikeSensitivity(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->strikeSensitivity();
        }
static Volatility BarrierOptionPtr_impliedVolatility__SWIG_0(BarrierOptionPtr *self,Real targetValue,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }

using QuantLib::AnalyticBarrierEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticBarrierEnginePtr;

static AnalyticBarrierEnginePtr *new_AnalyticBarrierEnginePtr(){
            return new AnalyticBarrierEnginePtr(new AnalyticBarrierEngine);
        }

using QuantLib::Cap;
using QuantLib::Floor;
using QuantLib::Collar;
typedef boost::shared_ptr<Instrument> CapPtr;
typedef boost::shared_ptr<Instrument> FloorPtr;
typedef boost::shared_ptr<Instrument> CollarPtr;

static CapPtr *new_CapPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new CapPtr(new Cap(leg,capRates,h,engine));
        }
static FloorPtr *new_FloorPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &floorRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new FloorPtr(new Floor(leg,floorRates,h,engine));
        }
static CollarPtr *new_CollarPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates,std::vector<Rate > const &floorRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new CollarPtr(new Collar(leg,capRates,floorRates,h,engine));
        }

using QuantLib::BlackCapFloorEngine;
typedef boost::shared_ptr<PricingEngine> BlackCapFloorEnginePtr;

static BlackCapFloorEnginePtr *new_BlackCapFloorEnginePtr(boost::shared_ptr<BlackModel > const &model){
            return new BlackCapFloorEnginePtr(new BlackCapFloorEngine(model));
        }

using QuantLib::CompoundForward;
typedef boost::shared_ptr<YieldTermStructure> CompoundForwardPtr;

static CompoundForwardPtr *new_CompoundForwardPtr(Date const &settlementDate,std::vector<Date > const &dates,std::vector<Rate > const &rates,Calendar calendar,BusinessDayConvention roll,Integer compounding,DayCounter const &dayCounter){
	        return new CompoundForwardPtr(
                new CompoundForward(settlementDate,
                                    dates, rates, calendar, roll,
                                    compounding, dayCounter));
        }
static std::vector<Date > const &CompoundForwardPtr_dates(CompoundForwardPtr *self){
            return boost::dynamic_pointer_cast<CompoundForward>(*self)
                 ->dates();
        }

using QuantLib::DiscountCurve;
using QuantLib::ExtendedDiscountCurve;
typedef boost::shared_ptr<YieldTermStructure> DiscountCurvePtr;
typedef boost::shared_ptr<YieldTermStructure> ExtendedDiscountCurvePtr;

static DiscountCurvePtr *new_DiscountCurvePtr(std::vector<Date > const &dates,std::vector<DiscountFactor > const &discounts,DayCounter const &dayCounter){
            return new DiscountCurvePtr(
                             new DiscountCurve(dates, discounts, dayCounter));
        }
static std::vector<Date > const &DiscountCurvePtr_dates(DiscountCurvePtr *self){
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->dates();
        }
static ExtendedDiscountCurvePtr *new_ExtendedDiscountCurvePtr(std::vector<Date > const &dates,std::vector<DiscountFactor > const &discounts,Calendar const &calendar,BusinessDayConvention roll,DayCounter const &dayCounter){
            return new ExtendedDiscountCurvePtr(
                new ExtendedDiscountCurve(dates, discounts,
                                          calendar, roll, dayCounter));
        }

using QuantLib::NormalDistribution;
using QuantLib::CumulativeNormalDistribution;
using QuantLib::MoroInverseCumulativeNormal;
using QuantLib::InverseCumulativeNormal;


using QuantLib::Money;

static void Money_setConversionType(Money::ConversionType type){
            Money::conversionType = type;
        }
static void Money_setBaseCurrency(Currency const &c){
            Money::baseCurrency = c;
        }

using QuantLib::ExchangeRate;
using QuantLib::ExchangeRateManager;


using QuantLib::TimeGrid;

static TimeGrid *new_TimeGrid__SWIG_2(std::vector<Time > const &times){
            return new TimeGrid(times.begin(), times.end());
        }
static TimeGrid *new_TimeGrid__SWIG_3(std::vector<Time > const &times,Size steps){
            return new TimeGrid(times.begin(), times.end(), steps);
        }

using QuantLib::SegmentIntegral;
using QuantLib::TrapezoidIntegral;
using QuantLib::SimpsonIntegral;
using QuantLib::KronrodIntegral;


using QuantLib::Sample;

using QuantLib::LecuyerUniformRng;
using QuantLib::KnuthUniformRng;
using QuantLib::MersenneTwisterUniformRng;

typedef QuantLib::PseudoRandom::urng_type UniformRandomGenerator;

using QuantLib::CLGaussianRng;
using QuantLib::BoxMullerGaussianRng;
using QuantLib::InverseCumulativeRng;

typedef QuantLib::PseudoRandom::rng_type GaussianRandomGenerator;

using QuantLib::RandomSequenceGenerator;

typedef QuantLib::PseudoRandom::ursg_type UniformRandomSequenceGenerator;

using QuantLib::HaltonRsg;
using QuantLib::SobolRsg;

typedef QuantLib::LowDiscrepancy::ursg_type
    UniformLowDiscrepancySequenceGenerator;

using QuantLib::InverseCumulativeRsg;

typedef QuantLib::PseudoRandom::rsg_type GaussianRandomSequenceGenerator;
typedef QuantLib::LowDiscrepancy::rsg_type
    GaussianLowDiscrepancySequenceGenerator;

static Real Sample_Sl_Real_Sg__value(Sample<Real > *self){ return self->value; }
static Real Sample_Sl_Real_Sg__weight(Sample<Real > *self){ return self->weight; }
static Array Sample_Sl_Array_Sg__value(Sample<Array > *self){ return self->value; }
static Real Sample_Sl_Array_Sg__weight(Sample<Array > *self){ return self->weight; }

Matrix getCovariance(const Array& volatilities, const Matrix& correlations) {
    return QuantLib::getCovariance(volatilities.begin(),
                                   volatilities.end(),
                                   correlations);
}


using QuantLib::Path;


typedef QuantLib::SingleAsset<PseudoRandom>::path_generator_type
    GaussianPathGenerator;

static Path Sample_Sl_Path_Sg__value(Sample<Path > *self){ return self->value; }
static Real Sample_Sl_Path_Sg__weight(Sample<Path > *self){ return self->weight; }
static GaussianPathGenerator *new_GaussianPathGenerator(StochasticProcess1DPtr const &process,Time length,Size steps,GaussianRandomSequenceGenerator const &rsg,bool brownianBridge){
            boost::shared_ptr<StochasticProcess1D> process1d =
                boost::dynamic_pointer_cast<StochasticProcess1D>(process);
            return new GaussianPathGenerator(process1d,length,steps,
                                             rsg,brownianBridge);
        }

using QuantLib::MultiPath;


typedef QuantLib::MultiAsset<PseudoRandom>::path_generator_type
    GaussianMultiPathGenerator;

static MultiPath Sample_Sl_MultiPath_Sg__value(Sample<MultiPath > *self){ return self->value; }
static Real Sample_Sl_MultiPath_Sg__weight(Sample<MultiPath > *self){ return self->weight; }
static GaussianMultiPathGenerator *new_GaussianMultiPathGenerator__SWIG_0(boost::shared_ptr<GenericStochasticProcess > const &process,std::vector<Time > const &times,GaussianRandomSequenceGenerator const &generator,bool brownianBridge=false){
          return new GaussianMultiPathGenerator(process,
                                                QuantLib::TimeGrid(
                                                    times.begin(),
                                                    times.end()),
                                                generator,
                                                brownianBridge);
      }

typedef QuantLib::BoundaryCondition<QuantLib::TridiagonalOperator>
		BoundaryCondition;
typedef BoundaryCondition::Side BoundaryConditionSide;

BoundaryCondition::Side BCSideFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "" || s == "none")
        return BoundaryCondition::None;
    else if (s == "upper")
        return BoundaryCondition::Upper;
    else if (s == "lower")
        return BoundaryCondition::Lower;
    else
        QL_FAIL("unknown boundary condition side: "+s);
}

std::string BCSideToString(BoundaryCondition::Side type) {
    switch (type) {
      case BoundaryCondition::None:
        return "None";
      case BoundaryCondition::Upper:
        return "upper";
      case BoundaryCondition::Lower:
        return "lower";
      default:
        QL_FAIL("unknown boundary condition side");
    }
}

static bool boost_shared_ptr_Sl_BoundaryCondition_Sg__isNull(boost::shared_ptr<BoundaryCondition > *self){
                return !(*self);
            }

using QuantLib::NeumannBC;
using QuantLib::DirichletBC;
typedef boost::shared_ptr<BoundaryCondition> NeumannBCPtr;
typedef boost::shared_ptr<BoundaryCondition> DirichletBCPtr;

static NeumannBCPtr *new_NeumannBCPtr(Real value,BoundaryConditionSide side){
            return new NeumannBCPtr(new NeumannBC(value, side));
        }
static DirichletBCPtr *new_DirichletBCPtr(Real value,BoundaryConditionSide side){
            return new DirichletBCPtr(new DirichletBC(value, side));
        }

using QuantLib::TridiagonalOperator;


using QuantLib::DPlus;
using QuantLib::DMinus;
using QuantLib::DZero;
using QuantLib::DPlusDMinus;


using QuantLib::valueAtCenter;
using QuantLib::firstDerivativeAtCenter;
using QuantLib::secondDerivativeAtCenter;


using QuantLib::SymmetricEigenvalues;
using QuantLib::SymmetricEigenvectors;


using QuantLib::Bisection;
using QuantLib::Brent;
using QuantLib::FalsePosition;
using QuantLib::Newton;
using QuantLib::NewtonSafe;
using QuantLib::Ridder;
using QuantLib::Secant;


using QuantLib::Constraint;
using QuantLib::BoundaryConstraint;
using QuantLib::NoConstraint;
using QuantLib::PositiveConstraint;


using QuantLib::EndCriteria;


using QuantLib::OptimizationMethod;
using QuantLib::ConjugateGradient;
using QuantLib::Simplex;
using QuantLib::SteepestDescent;


using QuantLib::Problem;


    class Optimizer {};


using QuantLib::PlainVanillaPayoff;
using QuantLib::PercentageStrikePayoff;
using QuantLib::CashOrNothingPayoff;
using QuantLib::AssetOrNothingPayoff;
using QuantLib::SuperSharePayoff;
typedef boost::shared_ptr<Payoff> PlainVanillaPayoffPtr;
typedef boost::shared_ptr<Payoff> PercentageStrikePayoffPtr;
typedef boost::shared_ptr<Payoff> CashOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> AssetOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> SuperSharePayoffPtr;

static PlainVanillaPayoffPtr *new_PlainVanillaPayoffPtr(Option::Type type,Real strike){
            return new PlainVanillaPayoffPtr(
                                        new PlainVanillaPayoff(type, strike));
        }
static PercentageStrikePayoffPtr *new_PercentageStrikePayoffPtr(Option::Type type,Real moneyness){
            return new PercentageStrikePayoffPtr(
                                 new PercentageStrikePayoff(type, moneyness));
        }
static CashOrNothingPayoffPtr *new_CashOrNothingPayoffPtr(Option::Type type,Real strike,Real payoff){
            return new CashOrNothingPayoffPtr(
                               new CashOrNothingPayoff(type, strike, payoff));
        }
static AssetOrNothingPayoffPtr *new_AssetOrNothingPayoffPtr(Option::Type type,Real strike){
            return new AssetOrNothingPayoffPtr(
                                      new AssetOrNothingPayoff(type, strike));
        }
static SuperSharePayoffPtr *new_SuperSharePayoffPtr(Option::Type type,Real strike,Real increment){
            return new SuperSharePayoffPtr(
                               new SuperSharePayoff(type, strike, increment));
        }

using QuantLib::RateHelper;
using QuantLib::DepositRateHelper;
using QuantLib::FraRateHelper;
using QuantLib::FuturesRateHelper;
using QuantLib::SwapRateHelper;
typedef boost::shared_ptr<RateHelper> DepositRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FraRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FuturesRateHelperPtr;
typedef boost::shared_ptr<RateHelper> SwapRateHelperPtr;

static bool boost_shared_ptr_Sl_RateHelper_Sg__isNull(boost::shared_ptr<RateHelper > *self){
                return !(*self);
            }
static DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,n,units,settlementDays,
                                      calendar, convention,dayCounter));
        }
static DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_1(Rate rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,n,units,settlementDays,
                                      calendar, convention,dayCounter));
        }
static FraRateHelperPtr *new_FraRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer monthsToStart,Integer monthsToEnd,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  dayCounter));
        }
static FraRateHelperPtr *new_FraRateHelperPtr__SWIG_1(Rate rate,Integer monthsToStart,Integer monthsToEnd,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  dayCounter));
        }
static FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_0(Handle<Quote > const &price,Date const &immDate,Integer nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter));
        }
static FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_1(Real price,Date const &immDate,Integer nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter));
        }
static FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_2(Handle<Quote > const &price,Date const &immDate,Date const &matDate,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,matDate,
                                      calendar,convention,dayCounter));
        }
static SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,Frequency floatingFrequency,BusinessDayConvention floatingConvention){
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, n, units, settlementDays,
                                   calendar, fixedFrequency, fixedConvention,
                                   fixedDayCount, floatingFrequency,
                                   floatingConvention));
        }
static SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_1(Rate rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,Frequency floatingFrequency,BusinessDayConvention floatingConvention){
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, n, units, settlementDays,
                                   calendar, fixedFrequency, fixedConvention,
                                   fixedDayCount, floatingFrequency,
                                   floatingConvention));
        }
static std::vector<boost::shared_ptr<RateHelper > > *new_std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg___SWIG_1(int capacity){
        std::vector<boost::shared_ptr<RateHelper> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<boost::shared_ptr<RateHelper> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
static boost::shared_ptr<RateHelper > std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__getitemcopy(std::vector<boost::shared_ptr<RateHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static boost::shared_ptr<RateHelper > const &std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__getitem(std::vector<boost::shared_ptr<RateHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__setitem(std::vector<boost::shared_ptr<RateHelper > > *self,int index,boost::shared_ptr<RateHelper > const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__AddRange(std::vector<boost::shared_ptr<RateHelper > > *self,std::vector<boost::shared_ptr<RateHelper > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
static std::vector<boost::shared_ptr<RateHelper > > *std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__GetRange(std::vector<boost::shared_ptr<RateHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<boost::shared_ptr<RateHelper> >(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Insert(std::vector<boost::shared_ptr<RateHelper > > *self,int index,boost::shared_ptr<RateHelper > const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__InsertRange(std::vector<boost::shared_ptr<RateHelper > > *self,int index,std::vector<boost::shared_ptr<RateHelper > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__RemoveAt(std::vector<boost::shared_ptr<RateHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__RemoveRange(std::vector<boost::shared_ptr<RateHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
static std::vector<boost::shared_ptr<RateHelper > > *std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Repeat(boost::shared_ptr<RateHelper > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<boost::shared_ptr<RateHelper> >(count, value);
      }
static void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Reverse__SWIG_0(std::vector<boost::shared_ptr<RateHelper > > *self){
        std::reverse(self->begin(), self->end());
      }
static void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Reverse__SWIG_1(std::vector<boost::shared_ptr<RateHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__SetRange(std::vector<boost::shared_ptr<RateHelper > > *self,int index,std::vector<boost::shared_ptr<RateHelper > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
static bool std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Contains(std::vector<boost::shared_ptr<RateHelper > > *self,boost::shared_ptr<RateHelper > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
static int std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__IndexOf(std::vector<boost::shared_ptr<RateHelper > > *self,boost::shared_ptr<RateHelper > const &value){
        int index = -1;
        std::vector<boost::shared_ptr<RateHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
static int std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__LastIndexOf(std::vector<boost::shared_ptr<RateHelper > > *self,boost::shared_ptr<RateHelper > const &value){
        int index = -1;
        std::vector<boost::shared_ptr<RateHelper> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
static void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Remove(std::vector<boost::shared_ptr<RateHelper > > *self,boost::shared_ptr<RateHelper > const &value){
        std::vector<boost::shared_ptr<RateHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::PiecewiseFlatForward;
typedef boost::shared_ptr<YieldTermStructure> PiecewiseFlatForwardPtr;

static PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_0(Date const &referenceDate,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12){
	        return new PiecewiseFlatForwardPtr(
	            new PiecewiseFlatForward(referenceDate,instruments,
                                         dayCounter,accuracy));
        }
static PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12){
	        return new PiecewiseFlatForwardPtr(
	            new PiecewiseFlatForward(settlementDays, calendar,
                                         instruments, dayCounter, accuracy));
        }
static std::vector<Date > const &PiecewiseFlatForwardPtr_dates(PiecewiseFlatForwardPtr *self){
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)
                 ->dates();
        }
static std::vector<Time > const &PiecewiseFlatForwardPtr_times(PiecewiseFlatForwardPtr *self){
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)
                 ->times();
        }

using QuantLib::Settings;

static Date Settings_getEvaluationDate(Settings *self){
            return self->evaluationDate();
        }
static void Settings_setEvaluationDate(Settings *self,Date const &d){
            self->evaluationDate() = d;
        }

using QuantLib::CalibrationHelper;
using QuantLib::SwaptionHelper;
using QuantLib::CapHelper;
typedef boost::shared_ptr<CalibrationHelper> SwaptionHelperPtr;
typedef boost::shared_ptr<CalibrationHelper> CapHelperPtr;

static bool boost_shared_ptr_Sl_CalibrationHelper_Sg__isNull(boost::shared_ptr<CalibrationHelper > *self){
                return !(*self);
            }
static SwaptionHelperPtr *new_SwaptionHelperPtr(Period const &maturity,Period const &length,Handle<Quote > const &volatility,XiborPtr const &index,Frequency fixedLegFrequency,DayCounter const &fixedLegDayCounter,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new SwaptionHelperPtr(
                new SwaptionHelper(maturity,length,volatility,
                                   libor,fixedLegFrequency,
                                   fixedLegDayCounter,termStructure));
        }
static std::vector<Time > SwaptionHelperPtr_times(SwaptionHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
static CapHelperPtr *new_CapHelperPtr(Period const &length,Handle<Quote > const &volatility,XiborPtr const &index,Frequency fixedLegFrequency,DayCounter const &fixedLegDayCounter,bool includeFirstSwaplet,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new CapHelperPtr(
                new CapHelper(length,volatility,libor,fixedLegFrequency,
                              fixedLegDayCounter,includeFirstSwaplet,
                              termStructure));
        }
static std::vector<Time > CapHelperPtr_times(CapHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
static std::vector<boost::shared_ptr<CalibrationHelper > > *new_std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg___SWIG_1(int capacity){
        std::vector<boost::shared_ptr<CalibrationHelper> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<boost::shared_ptr<CalibrationHelper> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
static boost::shared_ptr<CalibrationHelper > std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__getitemcopy(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static boost::shared_ptr<CalibrationHelper > const &std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__getitem(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__setitem(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,boost::shared_ptr<CalibrationHelper > const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__AddRange(std::vector<boost::shared_ptr<CalibrationHelper > > *self,std::vector<boost::shared_ptr<CalibrationHelper > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
static std::vector<boost::shared_ptr<CalibrationHelper > > *std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__GetRange(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<boost::shared_ptr<CalibrationHelper> >(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__Insert(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,boost::shared_ptr<CalibrationHelper > const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__InsertRange(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,std::vector<boost::shared_ptr<CalibrationHelper > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__RemoveAt(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__RemoveRange(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
static std::vector<boost::shared_ptr<CalibrationHelper > > *std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__Repeat(boost::shared_ptr<CalibrationHelper > const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<boost::shared_ptr<CalibrationHelper> >(count, value);
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__Reverse__SWIG_0(std::vector<boost::shared_ptr<CalibrationHelper > > *self){
        std::reverse(self->begin(), self->end());
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__Reverse__SWIG_1(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__SetRange(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,std::vector<boost::shared_ptr<CalibrationHelper > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
static bool std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__Contains(std::vector<boost::shared_ptr<CalibrationHelper > > *self,boost::shared_ptr<CalibrationHelper > const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
static int std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__IndexOf(std::vector<boost::shared_ptr<CalibrationHelper > > *self,boost::shared_ptr<CalibrationHelper > const &value){
        int index = -1;
        std::vector<boost::shared_ptr<CalibrationHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
static int std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__LastIndexOf(std::vector<boost::shared_ptr<CalibrationHelper > > *self,boost::shared_ptr<CalibrationHelper > const &value){
        int index = -1;
        std::vector<boost::shared_ptr<CalibrationHelper> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
static void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__Remove(std::vector<boost::shared_ptr<CalibrationHelper > > *self,boost::shared_ptr<CalibrationHelper > const &value){
        std::vector<boost::shared_ptr<CalibrationHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::ShortRateModel;

static bool boost_shared_ptr_Sl_ShortRateModel_Sg__isNull(boost::shared_ptr<ShortRateModel > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_ShortRateModel_Sg__asObservable(boost::shared_ptr<ShortRateModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::HullWhite;
using QuantLib::BlackKarasinski;
using QuantLib::G2;
typedef boost::shared_ptr<ShortRateModel> HullWhitePtr;
typedef boost::shared_ptr<ShortRateModel> BlackKarasinskiPtr;
typedef boost::shared_ptr<ShortRateModel> G2Ptr;

static HullWhitePtr *new_HullWhitePtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01){
	        return new HullWhitePtr(
	            new HullWhite(termStructure, a, sigma));
        }
static BlackKarasinskiPtr *new_BlackKarasinskiPtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.1){
	        return new BlackKarasinskiPtr(
	            new BlackKarasinski(termStructure, a, sigma));
        }
static G2Ptr *new_G2Ptr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01,Real b=0.1,Real eta=0.01,Real rho=-0.75){
	        return new G2Ptr(new G2(termStructure, a, sigma, b, eta, rho));
        }

using QuantLib::JamshidianSwaptionEngine;
using QuantLib::TreeSwaptionEngine;
using QuantLib::AnalyticCapFloorEngine;
using QuantLib::TreeCapFloorEngine;
using QuantLib::G2SwaptionEngine;
typedef boost::shared_ptr<PricingEngine> JamshidianSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> AnalyticCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> G2SwaptionEnginePtr;

static JamshidianSwaptionEnginePtr *new_JamshidianSwaptionEnginePtr(boost::shared_ptr<ShortRateModel > const &model){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new JamshidianSwaptionEnginePtr(
                                             new JamshidianSwaptionEngine(m));
        }
static TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps){
            return new TreeSwaptionEnginePtr(
                                     new TreeSwaptionEngine(model,timeSteps));
        }
static TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_1(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid){
            return new TreeSwaptionEnginePtr(
                                     new TreeSwaptionEngine(model,grid));
        }
static AnalyticCapFloorEnginePtr *new_AnalyticCapFloorEnginePtr(boost::shared_ptr<ShortRateModel > const &model){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new AnalyticCapFloorEnginePtr(
                                           new AnalyticCapFloorEngine(m));
        }
static TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps){
            return new TreeCapFloorEnginePtr(
                                     new TreeCapFloorEngine(model,timeSteps));
        }
static TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_1(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid){
            return new TreeCapFloorEnginePtr(
                                     new TreeCapFloorEngine(model,grid));
        }
static G2SwaptionEnginePtr *new_G2SwaptionEnginePtr(boost::shared_ptr<ShortRateModel > const &model,Real range,Size intervals){
            boost::shared_ptr<G2> g2 =
                boost::dynamic_pointer_cast<G2>(model);
            return new G2SwaptionEnginePtr(
                                    new G2SwaptionEngine(g2,range,intervals));
        }

using QuantLib::Statistics;
using QuantLib::RiskStatistics;
using QuantLib::SequenceStatistics;

static void Statistics_add__SWIG_2(Statistics *self,std::vector<Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
static void Statistics_add__SWIG_3(Statistics *self,std::vector<Real > const &values,std::vector<Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }

using QuantLib::TimeBasket;


using QuantLib::Swap;
using QuantLib::SimpleSwap;
typedef boost::shared_ptr<Instrument> SwapPtr;
typedef boost::shared_ptr<Instrument> SimpleSwapPtr;

static SwapPtr *new_SwapPtr(std::vector<boost::shared_ptr<CashFlow > > const &firstLeg,std::vector<boost::shared_ptr<CashFlow > > const &secondLeg,Handle<YieldTermStructure > const &termStructure){
            return new SwapPtr(new Swap(firstLeg, secondLeg,
                                        termStructure));
        }
static Date SwapPtr_startDate(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->startDate();
        }
static Date SwapPtr_maturity(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->maturity();
        }
static Real SwapPtr_firstLegBPS(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->firstLegBPS();
        }
static Real SwapPtr_secondLegBPS(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->secondLegBPS();
        }
static TimeBasket SwapPtr_sensitivity(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->sensitivity();
        }
static SimpleSwapPtr *new_SimpleSwapPtr(bool payFixedRate,Real nominal,Schedule const &fixedSchedule,Rate fixedRate,DayCounter const &fixedDayCount,Schedule const &floatSchedule,XiborPtr const &index,Integer indexFixingDays,Spread spread,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new SimpleSwapPtr(
                new SimpleSwap(payFixedRate,nominal,fixedSchedule,fixedRate,
                               fixedDayCount,floatSchedule,libor,
                               indexFixingDays,spread,termStructure));
        }
static Rate SimpleSwapPtr_fairRate(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)->fairRate();
        }
static Spread SimpleSwapPtr_fairSpread(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->fairSpread();
        }
static Real SimpleSwapPtr_fixedLegBPS(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->fixedLegBPS();
        }
static Real SimpleSwapPtr_floatingLegBPS(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->floatingLegBPS();
        }

using QuantLib::Swaption;
typedef boost::shared_ptr<Instrument> SwaptionPtr;

static SwaptionPtr *new_SwaptionPtr(boost::shared_ptr<Instrument > const &simpleSwap,boost::shared_ptr<Exercise > const &exercise,Handle<YieldTermStructure > const &termStructure,boost::shared_ptr<PricingEngine > const &engine){
            boost::shared_ptr<SimpleSwap> swap =
                 boost::dynamic_pointer_cast<SimpleSwap>(simpleSwap);
            QL_REQUIRE(swap, "simple swap required");
            return new SwaptionPtr(new Swaption(swap,exercise,
                                                termStructure,engine));
        }

using QuantLib::BlackSwaptionEngine;
typedef boost::shared_ptr<PricingEngine> BlackSwaptionEnginePtr;

static BlackSwaptionEnginePtr *new_BlackSwaptionEnginePtr(boost::shared_ptr<BlackModel > const &model){
            return new BlackSwaptionEnginePtr(new BlackSwaptionEngine(model));
        }

using QuantLib::DiscreteGeometricASO;


// single asset
using QuantLib::McDiscreteArithmeticASO;

// multi asset
using QuantLib::McMaxBasket;
using QuantLib::McEverest;
using QuantLib::McHimalaya;
using QuantLib::McPagoda;


using QuantLib::SwaptionVolatilityStructure;

static bool boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__isNull(boost::shared_ptr<SwaptionVolatilityStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__asObservable(boost::shared_ptr<SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static boost::shared_ptr<Observable > Handle_Sl_SwaptionVolatilityStructure_Sg__asObservable(Handle<SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SwaptionVolatilityMatrix;
typedef boost::shared_ptr<SwaptionVolatilityStructure>
    SwaptionVolatilityMatrixPtr;

static SwaptionVolatilityMatrixPtr *new_SwaptionVolatilityMatrixPtr(Date const &referenceDate,std::vector<Date > const &dates,std::vector<Period > const &lengths,Matrix const &vols,DayCounter const &dayCounter){
            return new SwaptionVolatilityMatrixPtr(
                new SwaptionVolatilityMatrix(referenceDate,dates,lengths,
                                             vols,dayCounter));
        }

using QuantLib::CapVolatilityStructure;

static bool boost_shared_ptr_Sl_CapVolatilityStructure_Sg__isNull(boost::shared_ptr<CapVolatilityStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_CapVolatilityStructure_Sg__asObservable(boost::shared_ptr<CapVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static boost::shared_ptr<Observable > Handle_Sl_CapVolatilityStructure_Sg__asObservable(Handle<CapVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::CapVolatilityVector;
typedef boost::shared_ptr<CapVolatilityStructure> CapVolatilityVectorPtr;

static CapVolatilityVectorPtr *new_CapVolatilityVectorPtr__SWIG_0(Date const &referenceDate,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,DayCounter const &dayCounter){
            return new CapVolatilityVectorPtr(
                new CapVolatilityVector(referenceDate,lengths,
                                        vols,dayCounter));
        }
static CapVolatilityVectorPtr *new_CapVolatilityVectorPtr__SWIG_1(Integer settlementDays,Calendar const &calendar,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,DayCounter const &dayCounter){
            return new CapVolatilityVectorPtr(
                new CapVolatilityVector(settlementDays,calendar,
                                        lengths,vols,dayCounter));
        }

#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT void * SWIGSTDCALL CSharp_Observable___deref__(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
    Observable *result;
    
    arg1 = (boost::shared_ptr<Observable > *)jarg1; 
    {
        try {
            result = (Observable *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Observable_isNull(void * jarg1) {
    unsigned int jresult ;
    boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
    bool result;
    
    arg1 = (boost::shared_ptr<Observable > *)jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_Observable_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Observable() {
    void * jresult ;
    boost::shared_ptr<Observable > *result;
    
    {
        try {
            result = (boost::shared_ptr<Observable > *)new boost::shared_ptr<Observable >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Observable(void * jarg1) {
    boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
    
    arg1 = (boost::shared_ptr<Observable > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QlArray__SWIG_0() {
    void * jresult ;
    Array *result;
    
    {
        try {
            result = (Array *)new Array();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QlArray__SWIG_1(unsigned long jarg1, double jarg2) {
    void * jresult ;
    Size arg1 ;
    Real arg2 ;
    Array *result;
    
    arg1 = (Size)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Array *)new Array(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QlArray__SWIG_2(unsigned long jarg1) {
    void * jresult ;
    Size arg1 ;
    Array *result;
    
    arg1 = (Size)jarg1; 
    {
        try {
            result = (Array *)new Array(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QlArray__SWIG_3(void * jarg1) {
    void * jresult ;
    Array *arg1 = 0 ;
    Array *result;
    
    arg1 = (Array *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (Array *)new Array((Array const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QlArray_size(void * jarg1) {
    unsigned long jresult ;
    Array *arg1 = (Array *) 0 ;
    Size result;
    
    arg1 = (Array *)jarg1; 
    {
        try {
            result = ((Array const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QlArray___str__(void * jarg1) {
    char * jresult ;
    Array *arg1 = (Array *) 0 ;
    std::string result;
    
    arg1 = (Array *)jarg1; 
    {
        try {
            result = Array___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_QlArray(void * jarg1) {
    Array *arg1 = (Array *) 0 ;
    
    arg1 = (Array *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_LexicographicalView_xSize(void * jarg1) {
    unsigned long jresult ;
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size result;
    
    arg1 = (LexicographicalView *)jarg1; 
    {
        try {
            result = ((LexicographicalView const *)arg1)->xSize();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_LexicographicalView_ySize(void * jarg1) {
    unsigned long jresult ;
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size result;
    
    arg1 = (LexicographicalView *)jarg1; 
    {
        try {
            result = ((LexicographicalView const *)arg1)->ySize();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LexicographicalView(void * jarg1, unsigned long jarg2) {
    void * jresult ;
    Array *arg1 = 0 ;
    Size arg2 ;
    LexicographicalView *result;
    
    arg1 = (Array *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array & type is null", 0);
        return 0;
    } 
    arg2 = (Size)jarg2; 
    {
        try {
            result = (LexicographicalView *)new_LexicographicalView(*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_LexicographicalView___str__(void * jarg1) {
    char * jresult ;
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    std::string result;
    
    arg1 = (LexicographicalView *)jarg1; 
    {
        try {
            result = LexicographicalView___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LexicographicalView(void * jarg1) {
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    
    arg1 = (LexicographicalView *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Matrix__SWIG_0() {
    void * jresult ;
    Matrix *result;
    
    {
        try {
            result = (Matrix *)new Matrix();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Matrix__SWIG_1(unsigned long jarg1, unsigned long jarg2, double jarg3) {
    void * jresult ;
    Size arg1 ;
    Size arg2 ;
    Real arg3 ;
    Matrix *result;
    
    arg1 = (Size)jarg1; 
    arg2 = (Size)jarg2; 
    arg3 = (Real)jarg3; 
    {
        try {
            result = (Matrix *)new Matrix(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Matrix__SWIG_2(unsigned long jarg1, unsigned long jarg2) {
    void * jresult ;
    Size arg1 ;
    Size arg2 ;
    Matrix *result;
    
    arg1 = (Size)jarg1; 
    arg2 = (Size)jarg2; 
    {
        try {
            result = (Matrix *)new Matrix(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Matrix__SWIG_3(void * jarg1) {
    void * jresult ;
    Matrix *arg1 = 0 ;
    Matrix *result;
    
    arg1 = (Matrix *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (Matrix *)new Matrix((Matrix const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_Matrix_rows(void * jarg1) {
    unsigned long jresult ;
    Matrix *arg1 = (Matrix *) 0 ;
    Size result;
    
    arg1 = (Matrix *)jarg1; 
    {
        try {
            result = ((Matrix const *)arg1)->rows();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_Matrix_columns(void * jarg1) {
    unsigned long jresult ;
    Matrix *arg1 = (Matrix *) 0 ;
    Size result;
    
    arg1 = (Matrix *)jarg1; 
    {
        try {
            result = ((Matrix const *)arg1)->columns();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Matrix___str__(void * jarg1) {
    char * jresult ;
    Matrix *arg1 = (Matrix *) 0 ;
    std::string result;
    
    arg1 = (Matrix *)jarg1; 
    {
        try {
            result = Matrix___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Matrix(void * jarg1) {
    Matrix *arg1 = (Matrix *) 0 ;
    
    arg1 = (Matrix *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SalvagingAlgorithm() {
    void * jresult ;
    SalvagingAlgorithm *result;
    
    {
        try {
            result = (SalvagingAlgorithm *)new SalvagingAlgorithm();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SalvagingAlgorithm(void * jarg1) {
    SalvagingAlgorithm *arg1 = (SalvagingAlgorithm *) 0 ;
    
    arg1 = (SalvagingAlgorithm *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_transpose(void * jarg1) {
    void * jresult ;
    Matrix *arg1 = 0 ;
    Matrix result;
    
    arg1 = (Matrix *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = transpose((Matrix const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Matrix((Matrix &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_outerProduct(void * jarg1, void * jarg2) {
    void * jresult ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix result;
    
    arg1 = (Array *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    arg2 = (Array *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = outerProduct((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Matrix((Matrix &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_pseudoSqrt(void * jarg1, int jarg2) {
    void * jresult ;
    Matrix *arg1 = 0 ;
    SalvagingAlgorithm::Type arg2 ;
    Matrix result;
    
    arg1 = (Matrix *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
        return 0;
    } 
    arg2 = (SalvagingAlgorithm::Type)jarg2; 
    {
        try {
            result = pseudoSqrt((Matrix const &)*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Matrix((Matrix &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SVD(void * jarg1) {
    void * jresult ;
    Matrix *arg1 = 0 ;
    SVD *result;
    
    arg1 = (Matrix *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (SVD *)new SVD((Matrix const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_SVD_U(void * jarg1) {
    void * jresult ;
    SVD *arg1 = (SVD *) 0 ;
    Matrix *result;
    
    arg1 = (SVD *)jarg1; 
    {
        try {
            {
                Matrix const &_result_ref = ((SVD const *)arg1)->U();
                result = (Matrix *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_SVD_V(void * jarg1) {
    void * jresult ;
    SVD *arg1 = (SVD *) 0 ;
    Matrix *result;
    
    arg1 = (SVD *)jarg1; 
    {
        try {
            {
                Matrix const &_result_ref = ((SVD const *)arg1)->V();
                result = (Matrix *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_SVD_S(void * jarg1) {
    void * jresult ;
    SVD *arg1 = (SVD *) 0 ;
    Matrix result;
    
    arg1 = (SVD *)jarg1; 
    {
        try {
            result = ((SVD const *)arg1)->S();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Matrix((Matrix &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_SVD_singularValues(void * jarg1) {
    void * jresult ;
    SVD *arg1 = (SVD *) 0 ;
    Array *result;
    
    arg1 = (SVD *)jarg1; 
    {
        try {
            {
                Array const &_result_ref = ((SVD const *)arg1)->singularValues();
                result = (Array *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SVD(void * jarg1) {
    SVD *arg1 = (SVD *) 0 ;
    
    arg1 = (SVD *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Quote___deref__(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    Quote *result;
    
    arg1 = (boost::shared_ptr<Quote > *)jarg1; 
    {
        try {
            result = (Quote *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Quote_isNull(void * jarg1) {
    unsigned int jresult ;
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    bool result;
    
    arg1 = (boost::shared_ptr<Quote > *)jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_Quote_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Quote_asObservable(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    boost::shared_ptr<Observable > result;
    
    arg1 = (boost::shared_ptr<Quote > *)jarg1; 
    {
        try {
            result = boost_shared_ptr_Sl_Quote_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_Quote_value(void * jarg1) {
    double jresult ;
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    Real result;
    
    arg1 = (boost::shared_ptr<Quote > *)jarg1; 
    {
        try {
            result = (Real)(*arg1)->value();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Quote() {
    void * jresult ;
    boost::shared_ptr<Quote > *result;
    
    {
        try {
            result = (boost::shared_ptr<Quote > *)new boost::shared_ptr<Quote >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Quote(void * jarg1) {
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    
    arg1 = (boost::shared_ptr<Quote > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QuoteHandle__SWIG_0(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<Quote > *arg1 = 0 ;
    Handle<Quote > *result;
    
    arg1 = (boost::shared_ptr<Quote > *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<Quote > const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (Handle<Quote > *)new Handle<Quote >((boost::shared_ptr<Quote > const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QuoteHandle__SWIG_1() {
    void * jresult ;
    Handle<Quote > *result;
    
    {
        try {
            result = (Handle<Quote > *)new Handle<Quote >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteHandle___deref__(void * jarg1) {
    void * jresult ;
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    boost::shared_ptr<Quote > result;
    
    arg1 = (Handle<Quote > *)jarg1; 
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new boost::shared_ptr<Quote >((boost::shared_ptr<Quote > &)result); 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandle_linkTo(void * jarg1, void * jarg2) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    
    arg1 = (Handle<Quote > *)jarg1; 
    arg2 = (boost::shared_ptr<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<Quote > const & type is null", 0);
        return ;
    } 
    {
        try {
            (arg1)->linkTo((boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuoteHandle_empty(void * jarg1) {
    unsigned int jresult ;
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    bool result;
    
    arg1 = (Handle<Quote > *)jarg1; 
    {
        try {
            result = (bool)(arg1)->empty();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteHandle_asObservable(void * jarg1) {
    void * jresult ;
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    boost::shared_ptr<Observable > result;
    
    arg1 = (Handle<Quote > *)jarg1; 
    {
        try {
            result = Handle_Sl_Quote_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuoteHandle_value(void * jarg1) {
    double jresult ;
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    Real result;
    
    arg1 = (Handle<Quote > *)jarg1; 
    {
        try {
            result = (Real)(*arg1)->value();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_QuoteHandle(void * jarg1) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    
    arg1 = (Handle<Quote > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SimpleQuote(double jarg1) {
    void * jresult ;
    Real arg1 ;
    SimpleQuotePtr *result;
    
    arg1 = (Real)jarg1; 
    {
        try {
            result = (SimpleQuotePtr *)new_SimpleQuotePtr(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_SimpleQuote_setValue(void * jarg1, double jarg2) {
    SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
    Real arg2 ;
    
    arg1 = (SimpleQuotePtr *)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            SimpleQuotePtr_setValue(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SimpleQuote(void * jarg1) {
    SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
    
    arg1 = (SimpleQuotePtr *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_Clear(void * jarg1) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_Add(void * jarg1, void * jarg2) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (boost::shared_ptr<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<Quote > const & type is null", 0);
        return ;
    } 
    {
        try {
            (arg1)->push_back((boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuoteVector_size(void * jarg1) {
    unsigned long jresult ;
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    std::vector<boost::shared_ptr<Quote > >::size_type result;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    {
        try {
            result = ((std::vector<boost::shared_ptr<Quote > > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuoteVector_capacity(void * jarg1) {
    unsigned long jresult ;
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    std::vector<boost::shared_ptr<Quote > >::size_type result;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    {
        try {
            result = ((std::vector<boost::shared_ptr<Quote > > const *)arg1)->capacity();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_reserve(void * jarg1, unsigned long jarg2) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    std::vector<boost::shared_ptr<Quote > >::size_type arg2 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (std::vector<boost::shared_ptr<Quote > >::size_type)jarg2; 
    {
        try {
            (arg1)->reserve(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QuoteVector__SWIG_0() {
    void * jresult ;
    std::vector<boost::shared_ptr<Quote > > *result;
    
    {
        try {
            result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QuoteVector__SWIG_1(int jarg1) {
    void * jresult ;
    int arg1 ;
    std::vector<boost::shared_ptr<Quote > > *result;
    
    arg1 = (int)jarg1; 
    {
        try {
            try {
                result = (std::vector<boost::shared_ptr<Quote > > *)new_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg___SWIG_1(arg1);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteVector_getitemcopy(void * jarg1, int jarg2) {
    void * jresult ;
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    boost::shared_ptr<Quote > result;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__getitemcopy(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new boost::shared_ptr<Quote >((boost::shared_ptr<Quote > &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteVector_getitem(void * jarg1, int jarg2) {
    void * jresult ;
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    boost::shared_ptr<Quote > *result;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                {
                    boost::shared_ptr<Quote > const &_result_ref = std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__getitem(arg1,arg2);
                    result = (boost::shared_ptr<Quote > *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_setitem(void * jarg1, int jarg2, void * jarg3) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    boost::shared_ptr<Quote > *arg3 = 0 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (boost::shared_ptr<Quote > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<Quote > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__setitem(arg1,arg2,(boost::shared_ptr<Quote > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_AddRange(void * jarg1, void * jarg2) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    std::vector<boost::shared_ptr<Quote > > *arg2 = 0 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (std::vector<boost::shared_ptr<Quote > > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > > const & type is null", 0);
        return ;
    } 
    {
        try {
            std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__AddRange(arg1,(std::vector<boost::shared_ptr<Quote > > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteVector_GetRange(void * jarg1, int jarg2, int jarg3) {
    void * jresult ;
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    int arg3 ;
    std::vector<boost::shared_ptr<Quote > > *result;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                result = (std::vector<boost::shared_ptr<Quote > > *)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__GetRange(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_Insert(void * jarg1, int jarg2, void * jarg3) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    boost::shared_ptr<Quote > *arg3 = 0 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (boost::shared_ptr<Quote > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<Quote > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Insert(arg1,arg2,(boost::shared_ptr<Quote > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    std::vector<boost::shared_ptr<Quote > > *arg3 = 0 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (std::vector<boost::shared_ptr<Quote > > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__InsertRange(arg1,arg2,(std::vector<boost::shared_ptr<Quote > > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_RemoveAt(void * jarg1, int jarg2) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__RemoveAt(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__RemoveRange(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteVector_Repeat(void * jarg1, int jarg2) {
    void * jresult ;
    boost::shared_ptr<Quote > *arg1 = 0 ;
    int arg2 ;
    std::vector<boost::shared_ptr<Quote > > *result;
    
    arg1 = (boost::shared_ptr<Quote > *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<Quote > const & type is null", 0);
        return 0;
    } 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = (std::vector<boost::shared_ptr<Quote > > *)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Repeat((boost::shared_ptr<Quote > const &)*arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_Reverse__SWIG_0(void * jarg1) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    {
        try {
            std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Reverse__SWIG_0(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    std::vector<boost::shared_ptr<Quote > > *arg3 = 0 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (std::vector<boost::shared_ptr<Quote > > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__SetRange(arg1,arg2,(std::vector<boost::shared_ptr<Quote > > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuoteVector_Contains(void * jarg1, void * jarg2) {
    unsigned int jresult ;
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    bool result;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (boost::shared_ptr<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<Quote > const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (bool)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Contains(arg1,(boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuoteVector_IndexOf(void * jarg1, void * jarg2) {
    int jresult ;
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    int result;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (boost::shared_ptr<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<Quote > const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (int)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__IndexOf(arg1,(boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuoteVector_LastIndexOf(void * jarg1, void * jarg2) {
    int jresult ;
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    int result;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (boost::shared_ptr<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<Quote > const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (int)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__LastIndexOf(arg1,(boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_Remove(void * jarg1, void * jarg2) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    arg2 = (boost::shared_ptr<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<Quote > const & type is null", 0);
        return ;
    } 
    {
        try {
            std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Remove(arg1,(boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_QuoteVector(void * jarg1) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_Clear(void * jarg1) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_Add(void * jarg1, void * jarg2) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    Handle<Quote > *arg2 = 0 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (Handle<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return ;
    } 
    {
        try {
            (arg1)->push_back((Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuoteHandleVector_size(void * jarg1) {
    unsigned long jresult ;
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    std::vector<Handle<Quote > >::size_type result;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    {
        try {
            result = ((std::vector<Handle<Quote > > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuoteHandleVector_capacity(void * jarg1) {
    unsigned long jresult ;
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    std::vector<Handle<Quote > >::size_type result;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    {
        try {
            result = ((std::vector<Handle<Quote > > const *)arg1)->capacity();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_reserve(void * jarg1, unsigned long jarg2) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    std::vector<Handle<Quote > >::size_type arg2 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (std::vector<Handle<Quote > >::size_type)jarg2; 
    {
        try {
            (arg1)->reserve(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QuoteHandleVector__SWIG_0() {
    void * jresult ;
    std::vector<Handle<Quote > > *result;
    
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QuoteHandleVector__SWIG_1(int jarg1) {
    void * jresult ;
    int arg1 ;
    std::vector<Handle<Quote > > *result;
    
    arg1 = (int)jarg1; 
    {
        try {
            try {
                result = (std::vector<Handle<Quote > > *)new_std_vector_Sl_Handle_Sl_Quote_Sg__Sg___SWIG_1(arg1);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteHandleVector_getitemcopy(void * jarg1, int jarg2) {
    void * jresult ;
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    Handle<Quote > result;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = std_vector_Sl_Handle_Sl_Quote_Sg__Sg__getitemcopy(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Handle<Quote >((Handle<Quote > &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteHandleVector_getitem(void * jarg1, int jarg2) {
    void * jresult ;
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    Handle<Quote > *result;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                {
                    Handle<Quote > const &_result_ref = std_vector_Sl_Handle_Sl_Quote_Sg__Sg__getitem(arg1,arg2);
                    result = (Handle<Quote > *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_setitem(void * jarg1, int jarg2, void * jarg3) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    Handle<Quote > *arg3 = 0 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (Handle<Quote > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Handle_Sl_Quote_Sg__Sg__setitem(arg1,arg2,(Handle<Quote > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_AddRange(void * jarg1, void * jarg2) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    std::vector<Handle<Quote > > *arg2 = 0 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (std::vector<Handle<Quote > > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > > const & type is null", 0);
        return ;
    } 
    {
        try {
            std_vector_Sl_Handle_Sl_Quote_Sg__Sg__AddRange(arg1,(std::vector<Handle<Quote > > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteHandleVector_GetRange(void * jarg1, int jarg2, int jarg3) {
    void * jresult ;
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    int arg3 ;
    std::vector<Handle<Quote > > *result;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                result = (std::vector<Handle<Quote > > *)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__GetRange(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_Insert(void * jarg1, int jarg2, void * jarg3) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    Handle<Quote > *arg3 = 0 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (Handle<Quote > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Insert(arg1,arg2,(Handle<Quote > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    std::vector<Handle<Quote > > *arg3 = 0 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (std::vector<Handle<Quote > > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Handle_Sl_Quote_Sg__Sg__InsertRange(arg1,arg2,(std::vector<Handle<Quote > > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_RemoveAt(void * jarg1, int jarg2) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                std_vector_Sl_Handle_Sl_Quote_Sg__Sg__RemoveAt(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_Handle_Sl_Quote_Sg__Sg__RemoveRange(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteHandleVector_Repeat(void * jarg1, int jarg2) {
    void * jresult ;
    Handle<Quote > *arg1 = 0 ;
    int arg2 ;
    std::vector<Handle<Quote > > *result;
    
    arg1 = (Handle<Quote > *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = (std::vector<Handle<Quote > > *)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Repeat((Handle<Quote > const &)*arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_Reverse__SWIG_0(void * jarg1) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    {
        try {
            std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Reverse__SWIG_0(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    std::vector<Handle<Quote > > *arg3 = 0 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (std::vector<Handle<Quote > > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Handle_Sl_Quote_Sg__Sg__SetRange(arg1,arg2,(std::vector<Handle<Quote > > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuoteHandleVector_Contains(void * jarg1, void * jarg2) {
    unsigned int jresult ;
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    Handle<Quote > *arg2 = 0 ;
    bool result;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (Handle<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (bool)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Contains(arg1,(Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuoteHandleVector_IndexOf(void * jarg1, void * jarg2) {
    int jresult ;
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    Handle<Quote > *arg2 = 0 ;
    int result;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (Handle<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (int)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__IndexOf(arg1,(Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuoteHandleVector_LastIndexOf(void * jarg1, void * jarg2) {
    int jresult ;
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    Handle<Quote > *arg2 = 0 ;
    int result;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (Handle<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (int)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__LastIndexOf(arg1,(Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_Remove(void * jarg1, void * jarg2) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    Handle<Quote > *arg2 = 0 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    arg2 = (Handle<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return ;
    } 
    {
        try {
            std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Remove(arg1,(Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_QuoteHandleVector(void * jarg1) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    
    arg1 = (std::vector<Handle<Quote > > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Period__SWIG_0(int jarg1, int jarg2) {
    void * jresult ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Period *result;
    
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    {
        try {
            result = (Period *)new Period(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Period_length(void * jarg1) {
    int jresult ;
    Period *arg1 = (Period *) 0 ;
    Integer result;
    
    arg1 = (Period *)jarg1; 
    {
        try {
            result = (Integer)((Period const *)arg1)->length();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Period_units(void * jarg1) {
    int jresult ;
    Period *arg1 = (Period *) 0 ;
    TimeUnit result;
    
    arg1 = (Period *)jarg1; 
    {
        try {
            result = (TimeUnit)((Period const *)arg1)->units();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Period__SWIG_1(char * jarg1) {
    void * jresult ;
    std::string *arg1 = 0 ;
    Period *result;
    
    if (!jarg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
        return 0;
    }
    std::string arg1_str(jarg1);
    arg1 = &arg1_str; 
    {
        try {
            result = (Period *)new_Period__SWIG_1((std::string const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Period___str__(void * jarg1) {
    char * jresult ;
    Period *arg1 = (Period *) 0 ;
    std::string result;
    
    arg1 = (Period *)jarg1; 
    {
        try {
            result = Period___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Period___repr__(void * jarg1) {
    char * jresult ;
    Period *arg1 = (Period *) 0 ;
    std::string result;
    
    arg1 = (Period *)jarg1; 
    {
        try {
            result = Period___repr__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Period___cmp__(void * jarg1, void * jarg2) {
    int jresult ;
    Period *arg1 = (Period *) 0 ;
    Period *arg2 = 0 ;
    int result;
    
    arg1 = (Period *)jarg1; 
    arg2 = (Period *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (int)Period___cmp__(arg1,(Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Period(void * jarg1) {
    Period *arg1 = (Period *) 0 ;
    
    arg1 = (Period *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_Clear(void * jarg1) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_Add(void * jarg1, void * jarg2) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    Period *arg2 = 0 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (Period *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
        return ;
    } 
    {
        try {
            (arg1)->push_back((Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_PeriodVector_size(void * jarg1) {
    unsigned long jresult ;
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    std::vector<Period >::size_type result;
    
    arg1 = (std::vector<Period > *)jarg1; 
    {
        try {
            result = ((std::vector<Period > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_PeriodVector_capacity(void * jarg1) {
    unsigned long jresult ;
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    std::vector<Period >::size_type result;
    
    arg1 = (std::vector<Period > *)jarg1; 
    {
        try {
            result = ((std::vector<Period > const *)arg1)->capacity();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_reserve(void * jarg1, unsigned long jarg2) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    std::vector<Period >::size_type arg2 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (std::vector<Period >::size_type)jarg2; 
    {
        try {
            (arg1)->reserve(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PeriodVector__SWIG_0() {
    void * jresult ;
    std::vector<Period > *result;
    
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PeriodVector__SWIG_1(int jarg1) {
    void * jresult ;
    int arg1 ;
    std::vector<Period > *result;
    
    arg1 = (int)jarg1; 
    {
        try {
            try {
                result = (std::vector<Period > *)new_std_vector_Sl_Period_Sg___SWIG_1(arg1);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_PeriodVector_getitemcopy(void * jarg1, int jarg2) {
    void * jresult ;
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    SwigValueWrapper<Period > result;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = std_vector_Sl_Period_Sg__getitemcopy(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Period((Period &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_PeriodVector_getitem(void * jarg1, int jarg2) {
    void * jresult ;
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    Period *result;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                {
                    Period const &_result_ref = std_vector_Sl_Period_Sg__getitem(arg1,arg2);
                    result = (Period *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_setitem(void * jarg1, int jarg2, void * jarg3) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    Period *arg3 = 0 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (Period *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Period_Sg__setitem(arg1,arg2,(Period const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_AddRange(void * jarg1, void * jarg2) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    std::vector<Period > *arg2 = 0 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (std::vector<Period > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Period > const & type is null", 0);
        return ;
    } 
    {
        try {
            std_vector_Sl_Period_Sg__AddRange(arg1,(std::vector<Period > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_PeriodVector_GetRange(void * jarg1, int jarg2, int jarg3) {
    void * jresult ;
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    int arg3 ;
    std::vector<Period > *result;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                result = (std::vector<Period > *)std_vector_Sl_Period_Sg__GetRange(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_Insert(void * jarg1, int jarg2, void * jarg3) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    Period *arg3 = 0 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (Period *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Period_Sg__Insert(arg1,arg2,(Period const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    std::vector<Period > *arg3 = 0 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (std::vector<Period > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Period > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Period_Sg__InsertRange(arg1,arg2,(std::vector<Period > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_RemoveAt(void * jarg1, int jarg2) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                std_vector_Sl_Period_Sg__RemoveAt(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_Period_Sg__RemoveRange(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_PeriodVector_Repeat(void * jarg1, int jarg2) {
    void * jresult ;
    Period *arg1 = 0 ;
    int arg2 ;
    std::vector<Period > *result;
    
    arg1 = (Period *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
        return 0;
    } 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = (std::vector<Period > *)std_vector_Sl_Period_Sg__Repeat((Period const &)*arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_Reverse__SWIG_0(void * jarg1) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    {
        try {
            std_vector_Sl_Period_Sg__Reverse__SWIG_0(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_Period_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    std::vector<Period > *arg3 = 0 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (std::vector<Period > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Period > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Period_Sg__SetRange(arg1,arg2,(std::vector<Period > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_PeriodVector(void * jarg1) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    
    arg1 = (std::vector<Period > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Date__SWIG_0() {
    void * jresult ;
    Date *result;
    
    {
        try {
            result = (Date *)new Date();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Date__SWIG_1(int jarg1, int jarg2, int jarg3) {
    void * jresult ;
    Day arg1 ;
    Month arg2 ;
    Year arg3 ;
    Date *result;
    
    arg1 = (Day)jarg1; 
    arg2 = (Month)jarg2; 
    arg3 = (Year)jarg3; 
    {
        try {
            result = (Date *)new Date(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Date__SWIG_2(long jarg1) {
    void * jresult ;
    BigInteger arg1 ;
    Date *result;
    
    arg1 = (BigInteger)jarg1; 
    {
        try {
            result = (Date *)new Date(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Date_weekday(void * jarg1) {
    int jresult ;
    Date *arg1 = (Date *) 0 ;
    Weekday result;
    
    arg1 = (Date *)jarg1; 
    {
        try {
            result = (Weekday)((Date const *)arg1)->weekday();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Date_dayOfMonth(void * jarg1) {
    int jresult ;
    Date *arg1 = (Date *) 0 ;
    Day result;
    
    arg1 = (Date *)jarg1; 
    {
        try {
            result = (Day)((Date const *)arg1)->dayOfMonth();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Date_dayOfYear(void * jarg1) {
    int jresult ;
    Date *arg1 = (Date *) 0 ;
    Day result;
    
    arg1 = (Date *)jarg1; 
    {
        try {
            result = (Day)((Date const *)arg1)->dayOfYear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Date_month(void * jarg1) {
    int jresult ;
    Date *arg1 = (Date *) 0 ;
    Month result;
    
    arg1 = (Date *)jarg1; 
    {
        try {
            result = (Month)((Date const *)arg1)->month();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Date_year(void * jarg1) {
    int jresult ;
    Date *arg1 = (Date *) 0 ;
    Year result;
    
    arg1 = (Date *)jarg1; 
    {
        try {
            result = (Year)((Date const *)arg1)->year();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT long SWIGSTDCALL CSharp_Date_serialNumber(void * jarg1) {
    long jresult ;
    Date *arg1 = (Date *) 0 ;
    BigInteger result;
    
    arg1 = (Date *)jarg1; 
    {
        try {
            result = (BigInteger)((Date const *)arg1)->serialNumber();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Date_isLeap(int jarg1) {
    unsigned int jresult ;
    Year arg1 ;
    bool result;
    
    arg1 = (Year)jarg1; 
    {
        try {
            result = (bool)Date::isLeap(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_minDate() {
    void * jresult ;
    Date result;
    
    {
        try {
            result = Date::minDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_maxDate() {
    void * jresult ;
    Date result;
    
    {
        try {
            result = Date::maxDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_todaysDate() {
    void * jresult ;
    Date result;
    
    {
        try {
            result = Date::todaysDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_endOfMonth(void * jarg1) {
    void * jresult ;
    Date *arg1 = 0 ;
    Date result;
    
    arg1 = (Date *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = Date::endOfMonth((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Date_isEOM(void * jarg1) {
    unsigned int jresult ;
    Date *arg1 = 0 ;
    bool result;
    
    arg1 = (Date *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (bool)Date::isEOM((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_nextWeekday(void * jarg1, int jarg2) {
    void * jresult ;
    Date *arg1 = 0 ;
    Weekday arg2 ;
    Date result;
    
    arg1 = (Date *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg2 = (Weekday)jarg2; 
    {
        try {
            result = Date::nextWeekday((Date const &)*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_nthWeekday(unsigned long jarg1, int jarg2, int jarg3, int jarg4) {
    void * jresult ;
    Size arg1 ;
    Weekday arg2 ;
    Month arg3 ;
    Year arg4 ;
    Date result;
    
    arg1 = (Size)jarg1; 
    arg2 = (Weekday)jarg2; 
    arg3 = (Month)jarg3; 
    arg4 = (Year)jarg4; 
    {
        try {
            result = Date::nthWeekday(arg1,arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Date_isIMMdate(void * jarg1) {
    unsigned int jresult ;
    Date *arg1 = 0 ;
    bool result;
    
    arg1 = (Date *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (bool)Date::isIMMdate((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_nextIMMdate(void * jarg1) {
    void * jresult ;
    Date *arg1 = 0 ;
    Date result;
    
    arg1 = (Date *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = Date::nextIMMdate((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Date__SWIG_3(char * jarg1, char * jarg2) {
    void * jresult ;
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    Date *result;
    
    if (!jarg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
        return 0;
    }
    std::string arg1_str(jarg1);
    arg1 = &arg1_str; 
    if (!jarg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
        return 0;
    }
    std::string arg2_str(jarg2);
    arg2 = &arg2_str; 
    {
        try {
            result = (Date *)new_Date__SWIG_3((std::string const &)*arg1,(std::string const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Date_weekdayNumber(void * jarg1) {
    int jresult ;
    Date *arg1 = (Date *) 0 ;
    Integer result;
    
    arg1 = (Date *)jarg1; 
    {
        try {
            result = (Integer)Date_weekdayNumber(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Date___str__(void * jarg1) {
    char * jresult ;
    Date *arg1 = (Date *) 0 ;
    std::string result;
    
    arg1 = (Date *)jarg1; 
    {
        try {
            result = Date___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Date___repr__(void * jarg1) {
    char * jresult ;
    Date *arg1 = (Date *) 0 ;
    std::string result;
    
    arg1 = (Date *)jarg1; 
    {
        try {
            result = Date___repr__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Date_ISO(void * jarg1) {
    char * jresult ;
    Date *arg1 = (Date *) 0 ;
    std::string result;
    
    arg1 = (Date *)jarg1; 
    {
        try {
            result = Date_ISO(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Date(void * jarg1) {
    Date *arg1 = (Date *) 0 ;
    
    arg1 = (Date *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_Clear(void * jarg1) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_Add(void * jarg1, void * jarg2) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    Date *arg2 = 0 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return ;
    } 
    {
        try {
            (arg1)->push_back((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_DateVector_size(void * jarg1) {
    unsigned long jresult ;
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    std::vector<Date >::size_type result;
    
    arg1 = (std::vector<Date > *)jarg1; 
    {
        try {
            result = ((std::vector<Date > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_DateVector_capacity(void * jarg1) {
    unsigned long jresult ;
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    std::vector<Date >::size_type result;
    
    arg1 = (std::vector<Date > *)jarg1; 
    {
        try {
            result = ((std::vector<Date > const *)arg1)->capacity();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_reserve(void * jarg1, unsigned long jarg2) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    std::vector<Date >::size_type arg2 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (std::vector<Date >::size_type)jarg2; 
    {
        try {
            (arg1)->reserve(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DateVector__SWIG_0() {
    void * jresult ;
    std::vector<Date > *result;
    
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DateVector__SWIG_1(int jarg1) {
    void * jresult ;
    int arg1 ;
    std::vector<Date > *result;
    
    arg1 = (int)jarg1; 
    {
        try {
            try {
                result = (std::vector<Date > *)new_std_vector_Sl_Date_Sg___SWIG_1(arg1);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DateVector_getitemcopy(void * jarg1, int jarg2) {
    void * jresult ;
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    Date result;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = std_vector_Sl_Date_Sg__getitemcopy(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DateVector_getitem(void * jarg1, int jarg2) {
    void * jresult ;
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    Date *result;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                {
                    Date const &_result_ref = std_vector_Sl_Date_Sg__getitem(arg1,arg2);
                    result = (Date *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_setitem(void * jarg1, int jarg2, void * jarg3) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    Date *arg3 = 0 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Date_Sg__setitem(arg1,arg2,(Date const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_AddRange(void * jarg1, void * jarg2) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    std::vector<Date > *arg2 = 0 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (std::vector<Date > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date > const & type is null", 0);
        return ;
    } 
    {
        try {
            std_vector_Sl_Date_Sg__AddRange(arg1,(std::vector<Date > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DateVector_GetRange(void * jarg1, int jarg2, int jarg3) {
    void * jresult ;
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    int arg3 ;
    std::vector<Date > *result;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                result = (std::vector<Date > *)std_vector_Sl_Date_Sg__GetRange(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_Insert(void * jarg1, int jarg2, void * jarg3) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    Date *arg3 = 0 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Date_Sg__Insert(arg1,arg2,(Date const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    std::vector<Date > *arg3 = 0 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (std::vector<Date > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Date_Sg__InsertRange(arg1,arg2,(std::vector<Date > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_RemoveAt(void * jarg1, int jarg2) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                std_vector_Sl_Date_Sg__RemoveAt(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_Date_Sg__RemoveRange(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DateVector_Repeat(void * jarg1, int jarg2) {
    void * jresult ;
    Date *arg1 = 0 ;
    int arg2 ;
    std::vector<Date > *result;
    
    arg1 = (Date *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = (std::vector<Date > *)std_vector_Sl_Date_Sg__Repeat((Date const &)*arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_Reverse__SWIG_0(void * jarg1) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    {
        try {
            std_vector_Sl_Date_Sg__Reverse__SWIG_0(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_Date_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    std::vector<Date > *arg3 = 0 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (std::vector<Date > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Date_Sg__SetRange(arg1,arg2,(std::vector<Date > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DateVector(void * jarg1) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    
    arg1 = (std::vector<Date > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT int SWIGSTDCALL CSharp_nullInt() {
    int jresult ;
    int result;
    
    {
        try {
            result = (int)nullInt();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_nullDouble() {
    double jresult ;
    double result;
    
    {
        try {
            result = (double)nullDouble();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT long SWIGSTDCALL CSharp_DayCounter_dayCount(void * jarg1, void * jarg2, void * jarg3) {
    long jresult ;
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    BigInteger result;
    
    arg1 = (DayCounter *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (BigInteger)(arg1)->dayCount((Date const &)*arg2,(Date const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_DayCounter_yearFraction__SWIG_0(void * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
    double jresult ;
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Date *arg4 = 0 ;
    Date *arg5 = 0 ;
    Time result;
    
    arg1 = (DayCounter *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg4 = (Date *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg5 = (Date *)jarg5;
    if(!arg5) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4,(Date const &)*arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_DayCounter_yearFraction__SWIG_1(void * jarg1, void * jarg2, void * jarg3, void * jarg4) {
    double jresult ;
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Date *arg4 = 0 ;
    Time result;
    
    arg1 = (DayCounter *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg4 = (Date *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_DayCounter_yearFraction__SWIG_2(void * jarg1, void * jarg2, void * jarg3) {
    double jresult ;
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Time result;
    
    arg1 = (DayCounter *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_DayCounter___str__(void * jarg1) {
    char * jresult ;
    DayCounter *arg1 = (DayCounter *) 0 ;
    std::string result;
    
    arg1 = (DayCounter *)jarg1; 
    {
        try {
            result = DayCounter___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DayCounter(void * jarg1) {
    DayCounter *arg1 = (DayCounter *) 0 ;
    
    arg1 = (DayCounter *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Actual360() {
    void * jresult ;
    QuantLib::Actual360 *result;
    
    {
        try {
            result = (QuantLib::Actual360 *)new QuantLib::Actual360();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Actual360(void * jarg1) {
    QuantLib::Actual360 *arg1 = (QuantLib::Actual360 *) 0 ;
    
    arg1 = (QuantLib::Actual360 *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Actual365Fixed() {
    void * jresult ;
    QuantLib::Actual365Fixed *result;
    
    {
        try {
            result = (QuantLib::Actual365Fixed *)new QuantLib::Actual365Fixed();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Actual365Fixed(void * jarg1) {
    QuantLib::Actual365Fixed *arg1 = (QuantLib::Actual365Fixed *) 0 ;
    
    arg1 = (QuantLib::Actual365Fixed *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Thirty360__SWIG_0(int jarg1) {
    void * jresult ;
    QuantLib::Thirty360::Convention arg1 ;
    QuantLib::Thirty360 *result;
    
    arg1 = (QuantLib::Thirty360::Convention)jarg1; 
    {
        try {
            result = (QuantLib::Thirty360 *)new QuantLib::Thirty360(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Thirty360__SWIG_1() {
    void * jresult ;
    QuantLib::Thirty360 *result;
    
    {
        try {
            result = (QuantLib::Thirty360 *)new QuantLib::Thirty360();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Thirty360(void * jarg1) {
    QuantLib::Thirty360 *arg1 = (QuantLib::Thirty360 *) 0 ;
    
    arg1 = (QuantLib::Thirty360 *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ActualActual__SWIG_0(int jarg1) {
    void * jresult ;
    QuantLib::ActualActual::Convention arg1 ;
    QuantLib::ActualActual *result;
    
    arg1 = (QuantLib::ActualActual::Convention)jarg1; 
    {
        try {
            result = (QuantLib::ActualActual *)new QuantLib::ActualActual(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ActualActual__SWIG_1() {
    void * jresult ;
    QuantLib::ActualActual *result;
    
    {
        try {
            result = (QuantLib::ActualActual *)new QuantLib::ActualActual();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ActualActual(void * jarg1) {
    QuantLib::ActualActual *arg1 = (QuantLib::ActualActual *) 0 ;
    
    arg1 = (QuantLib::ActualActual *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_OneDayCounter() {
    void * jresult ;
    QuantLib::OneDayCounter *result;
    
    {
        try {
            result = (QuantLib::OneDayCounter *)new QuantLib::OneDayCounter();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_OneDayCounter(void * jarg1) {
    QuantLib::OneDayCounter *arg1 = (QuantLib::OneDayCounter *) 0 ;
    
    arg1 = (QuantLib::OneDayCounter *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SimpleDayCounter() {
    void * jresult ;
    QuantLib::SimpleDayCounter *result;
    
    {
        try {
            result = (QuantLib::SimpleDayCounter *)new QuantLib::SimpleDayCounter();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SimpleDayCounter(void * jarg1) {
    QuantLib::SimpleDayCounter *arg1 = (QuantLib::SimpleDayCounter *) 0 ;
    
    arg1 = (QuantLib::SimpleDayCounter *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_InterestRate__SWIG_0() {
    void * jresult ;
    InterestRate *result;
    
    {
        try {
            result = (InterestRate *)new InterestRate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_InterestRate__SWIG_1(double jarg1, void * jarg2, int jarg3, int jarg4) {
    void * jresult ;
    Rate arg1 ;
    DayCounter *arg2 = 0 ;
    Compounding arg3 ;
    Frequency arg4 ;
    InterestRate *result;
    
    arg1 = (Rate)jarg1; 
    arg2 = (DayCounter *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg3 = (Compounding)jarg3; 
    arg4 = (Frequency)jarg4; 
    {
        try {
            result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_InterestRate__SWIG_2(double jarg1, void * jarg2, int jarg3) {
    void * jresult ;
    Rate arg1 ;
    DayCounter *arg2 = 0 ;
    Compounding arg3 ;
    InterestRate *result;
    
    arg1 = (Rate)jarg1; 
    arg2 = (DayCounter *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg3 = (Compounding)jarg3; 
    {
        try {
            result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_InterestRate_rate(void * jarg1) {
    double jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Rate result;
    
    arg1 = (InterestRate *)jarg1; 
    {
        try {
            result = (Rate)((InterestRate const *)arg1)->rate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_dayCounter(void * jarg1) {
    void * jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    SwigValueWrapper<DayCounter > result;
    
    arg1 = (InterestRate *)jarg1; 
    {
        try {
            result = ((InterestRate const *)arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new DayCounter((DayCounter &)result); 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_InterestRate_compounding(void * jarg1) {
    int jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Compounding result;
    
    arg1 = (InterestRate *)jarg1; 
    {
        try {
            result = (Compounding)((InterestRate const *)arg1)->compounding();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_InterestRate_frequency(void * jarg1) {
    int jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Frequency result;
    
    arg1 = (InterestRate *)jarg1; 
    {
        try {
            result = (Frequency)((InterestRate const *)arg1)->frequency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_InterestRate_discountFactor__SWIG_0(void * jarg1, double jarg2) {
    double jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    DiscountFactor result;
    
    arg1 = (InterestRate *)jarg1; 
    arg2 = (Time)jarg2; 
    {
        try {
            result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_InterestRate_discountFactor__SWIG_1(void * jarg1, void * jarg2, void * jarg3) {
    double jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date arg2 ;
    Date arg3 ;
    DiscountFactor result;
    Date *argp2 ;
    Date *argp3 ;
    
    arg1 = (InterestRate *)jarg1; 
    argp2 = (Date *)jarg2; 
    if (!argp2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null Date", 0);
        return 0;
    }
    arg2 = *argp2; 
    argp3 = (Date *)jarg3; 
    if (!argp3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null Date", 0);
        return 0;
    }
    arg3 = *argp3; 
    {
        try {
            result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_InterestRate_compoundFactor__SWIG_0(void * jarg1, double jarg2) {
    double jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    Real result;
    
    arg1 = (InterestRate *)jarg1; 
    arg2 = (Time)jarg2; 
    {
        try {
            result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_InterestRate_compoundFactor__SWIG_1(void * jarg1, void * jarg2, void * jarg3) {
    double jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date arg2 ;
    Date arg3 ;
    Real result;
    Date *argp2 ;
    Date *argp3 ;
    
    arg1 = (InterestRate *)jarg1; 
    argp2 = (Date *)jarg2; 
    if (!argp2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null Date", 0);
        return 0;
    }
    arg2 = *argp2; 
    argp3 = (Date *)jarg3; 
    if (!argp3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null Date", 0);
        return 0;
    }
    arg3 = *argp3; 
    {
        try {
            result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_impliedRate__SWIG_0(double jarg1, double jarg2, void * jarg3, int jarg4, int jarg5) {
    void * jresult ;
    Real arg1 ;
    Time arg2 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    InterestRate result;
    
    arg1 = (Real)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_impliedRate__SWIG_1(double jarg1, double jarg2, void * jarg3, int jarg4) {
    void * jresult ;
    Real arg1 ;
    Time arg2 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    InterestRate result;
    
    arg1 = (Real)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_impliedRate__SWIG_2(double jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6) {
    void * jresult ;
    Real arg1 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    InterestRate result;
    
    arg1 = (Real)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    {
        try {
            result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_impliedRate__SWIG_3(double jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
    void * jresult ;
    Real arg1 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    InterestRate result;
    
    arg1 = (Real)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    {
        try {
            result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_equivalentRate__SWIG_0(void * jarg1, double jarg2, int jarg3, int jarg4) {
    void * jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    InterestRate result;
    
    arg1 = (InterestRate *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    arg4 = (Frequency)jarg4; 
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_equivalentRate__SWIG_1(void * jarg1, double jarg2, int jarg3) {
    void * jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    InterestRate result;
    
    arg1 = (InterestRate *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_equivalentRate__SWIG_2(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6) {
    void * jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    InterestRate result;
    
    arg1 = (InterestRate *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_equivalentRate__SWIG_3(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
    void * jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    InterestRate result;
    
    arg1 = (InterestRate *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_InterestRate___str__(void * jarg1) {
    char * jresult ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    std::string result;
    
    arg1 = (InterestRate *)jarg1; 
    {
        try {
            result = InterestRate___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_InterestRate(void * jarg1) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    
    arg1 = (InterestRate *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Calendar_isBusinessDay(void * jarg1, void * jarg2) {
    unsigned int jresult ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    
    arg1 = (Calendar *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (bool)(arg1)->isBusinessDay((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Calendar_isHoliday(void * jarg1, void * jarg2) {
    unsigned int jresult ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    
    arg1 = (Calendar *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (bool)(arg1)->isHoliday((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Calendar_isEndOfMonth(void * jarg1, void * jarg2) {
    unsigned int jresult ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    
    arg1 = (Calendar *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (bool)(arg1)->isEndOfMonth((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Calendar_addHoliday(void * jarg1, void * jarg2) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    
    arg1 = (Calendar *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return ;
    } 
    {
        try {
            (arg1)->addHoliday((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Calendar_removeHoliday(void * jarg1, void * jarg2) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    
    arg1 = (Calendar *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return ;
    } 
    {
        try {
            (arg1)->removeHoliday((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_adjust__SWIG_0(void * jarg1, void * jarg2, int jarg3, void * jarg4) {
    void * jresult ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    BusinessDayConvention arg3 ;
    Date *arg4 = 0 ;
    Date result;
    
    arg1 = (Calendar *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (BusinessDayConvention)jarg3; 
    arg4 = (Date *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (arg1)->adjust((Date const &)*arg2,arg3,(Date const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_adjust__SWIG_1(void * jarg1, void * jarg2, int jarg3) {
    void * jresult ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    BusinessDayConvention arg3 ;
    Date result;
    
    arg1 = (Calendar *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (BusinessDayConvention)jarg3; 
    {
        try {
            result = (arg1)->adjust((Date const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_adjust__SWIG_2(void * jarg1, void * jarg2) {
    void * jresult ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Date result;
    
    arg1 = (Calendar *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (arg1)->adjust((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_advance__SWIG_0(void * jarg1, void * jarg2, int jarg3, int jarg4, int jarg5) {
    void * jresult ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Integer arg3 ;
    TimeUnit arg4 ;
    BusinessDayConvention arg5 ;
    Date result;
    
    arg1 = (Calendar *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Integer)jarg3; 
    arg4 = (TimeUnit)jarg4; 
    arg5 = (BusinessDayConvention)jarg5; 
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_advance__SWIG_1(void * jarg1, void * jarg2, int jarg3, int jarg4) {
    void * jresult ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Integer arg3 ;
    TimeUnit arg4 ;
    Date result;
    
    arg1 = (Calendar *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Integer)jarg3; 
    arg4 = (TimeUnit)jarg4; 
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_advance__SWIG_2(void * jarg1, void * jarg2, void * jarg3, int jarg4) {
    void * jresult ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Period *arg3 = 0 ;
    BusinessDayConvention arg4 ;
    Date result;
    
    arg1 = (Calendar *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Period *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
        return 0;
    } 
    arg4 = (BusinessDayConvention)jarg4; 
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_advance__SWIG_3(void * jarg1, void * jarg2, void * jarg3) {
    void * jresult ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Period *arg3 = 0 ;
    Date result;
    
    arg1 = (Calendar *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Period *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Calendar___str__(void * jarg1) {
    char * jresult ;
    Calendar *arg1 = (Calendar *) 0 ;
    std::string result;
    
    arg1 = (Calendar *)jarg1; 
    {
        try {
            result = Calendar___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Calendar(void * jarg1) {
    Calendar *arg1 = (Calendar *) 0 ;
    
    arg1 = (Calendar *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Beijing() {
    void * jresult ;
    QuantLib::Beijing *result;
    
    {
        try {
            result = (QuantLib::Beijing *)new QuantLib::Beijing();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Beijing(void * jarg1) {
    QuantLib::Beijing *arg1 = (QuantLib::Beijing *) 0 ;
    
    arg1 = (QuantLib::Beijing *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Bombay() {
    void * jresult ;
    QuantLib::Bombay *result;
    
    {
        try {
            result = (QuantLib::Bombay *)new QuantLib::Bombay();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Bombay(void * jarg1) {
    QuantLib::Bombay *arg1 = (QuantLib::Bombay *) 0 ;
    
    arg1 = (QuantLib::Bombay *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Bratislava() {
    void * jresult ;
    QuantLib::Bratislava *result;
    
    {
        try {
            result = (QuantLib::Bratislava *)new QuantLib::Bratislava();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Bratislava(void * jarg1) {
    QuantLib::Bratislava *arg1 = (QuantLib::Bratislava *) 0 ;
    
    arg1 = (QuantLib::Bratislava *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Budapest() {
    void * jresult ;
    QuantLib::Budapest *result;
    
    {
        try {
            result = (QuantLib::Budapest *)new QuantLib::Budapest();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Budapest(void * jarg1) {
    QuantLib::Budapest *arg1 = (QuantLib::Budapest *) 0 ;
    
    arg1 = (QuantLib::Budapest *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Copenhagen() {
    void * jresult ;
    QuantLib::Copenhagen *result;
    
    {
        try {
            result = (QuantLib::Copenhagen *)new QuantLib::Copenhagen();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Copenhagen(void * jarg1) {
    QuantLib::Copenhagen *arg1 = (QuantLib::Copenhagen *) 0 ;
    
    arg1 = (QuantLib::Copenhagen *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Germany__SWIG_0(int jarg1) {
    void * jresult ;
    QuantLib::Germany::Market arg1 ;
    QuantLib::Germany *result;
    
    arg1 = (QuantLib::Germany::Market)jarg1; 
    {
        try {
            result = (QuantLib::Germany *)new QuantLib::Germany(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Germany__SWIG_1() {
    void * jresult ;
    QuantLib::Germany *result;
    
    {
        try {
            result = (QuantLib::Germany *)new QuantLib::Germany();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Germany(void * jarg1) {
    QuantLib::Germany *arg1 = (QuantLib::Germany *) 0 ;
    
    arg1 = (QuantLib::Germany *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Helsinki() {
    void * jresult ;
    QuantLib::Helsinki *result;
    
    {
        try {
            result = (QuantLib::Helsinki *)new QuantLib::Helsinki();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Helsinki(void * jarg1) {
    QuantLib::Helsinki *arg1 = (QuantLib::Helsinki *) 0 ;
    
    arg1 = (QuantLib::Helsinki *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_HongKong() {
    void * jresult ;
    QuantLib::HongKong *result;
    
    {
        try {
            result = (QuantLib::HongKong *)new QuantLib::HongKong();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_HongKong(void * jarg1) {
    QuantLib::HongKong *arg1 = (QuantLib::HongKong *) 0 ;
    
    arg1 = (QuantLib::HongKong *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Italy__SWIG_0(int jarg1) {
    void * jresult ;
    QuantLib::Italy::Market arg1 ;
    QuantLib::Italy *result;
    
    arg1 = (QuantLib::Italy::Market)jarg1; 
    {
        try {
            result = (QuantLib::Italy *)new QuantLib::Italy(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Italy__SWIG_1() {
    void * jresult ;
    QuantLib::Italy *result;
    
    {
        try {
            result = (QuantLib::Italy *)new QuantLib::Italy();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Italy(void * jarg1) {
    QuantLib::Italy *arg1 = (QuantLib::Italy *) 0 ;
    
    arg1 = (QuantLib::Italy *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Istanbul() {
    void * jresult ;
    QuantLib::Istanbul *result;
    
    {
        try {
            result = (QuantLib::Istanbul *)new QuantLib::Istanbul();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Istanbul(void * jarg1) {
    QuantLib::Istanbul *arg1 = (QuantLib::Istanbul *) 0 ;
    
    arg1 = (QuantLib::Istanbul *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Johannesburg() {
    void * jresult ;
    QuantLib::Johannesburg *result;
    
    {
        try {
            result = (QuantLib::Johannesburg *)new QuantLib::Johannesburg();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Johannesburg(void * jarg1) {
    QuantLib::Johannesburg *arg1 = (QuantLib::Johannesburg *) 0 ;
    
    arg1 = (QuantLib::Johannesburg *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NullCalendar() {
    void * jresult ;
    QuantLib::NullCalendar *result;
    
    {
        try {
            result = (QuantLib::NullCalendar *)new QuantLib::NullCalendar();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NullCalendar(void * jarg1) {
    QuantLib::NullCalendar *arg1 = (QuantLib::NullCalendar *) 0 ;
    
    arg1 = (QuantLib::NullCalendar *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Oslo() {
    void * jresult ;
    QuantLib::Oslo *result;
    
    {
        try {
            result = (QuantLib::Oslo *)new QuantLib::Oslo();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Oslo(void * jarg1) {
    QuantLib::Oslo *arg1 = (QuantLib::Oslo *) 0 ;
    
    arg1 = (QuantLib::Oslo *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Prague() {
    void * jresult ;
    QuantLib::Prague *result;
    
    {
        try {
            result = (QuantLib::Prague *)new QuantLib::Prague();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Prague(void * jarg1) {
    QuantLib::Prague *arg1 = (QuantLib::Prague *) 0 ;
    
    arg1 = (QuantLib::Prague *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Riyadh() {
    void * jresult ;
    QuantLib::Riyadh *result;
    
    {
        try {
            result = (QuantLib::Riyadh *)new QuantLib::Riyadh();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Riyadh(void * jarg1) {
    QuantLib::Riyadh *arg1 = (QuantLib::Riyadh *) 0 ;
    
    arg1 = (QuantLib::Riyadh *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Seoul() {
    void * jresult ;
    QuantLib::Seoul *result;
    
    {
        try {
            result = (QuantLib::Seoul *)new QuantLib::Seoul();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Seoul(void * jarg1) {
    QuantLib::Seoul *arg1 = (QuantLib::Seoul *) 0 ;
    
    arg1 = (QuantLib::Seoul *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Singapore() {
    void * jresult ;
    QuantLib::Singapore *result;
    
    {
        try {
            result = (QuantLib::Singapore *)new QuantLib::Singapore();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Singapore(void * jarg1) {
    QuantLib::Singapore *arg1 = (QuantLib::Singapore *) 0 ;
    
    arg1 = (QuantLib::Singapore *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Stockholm() {
    void * jresult ;
    QuantLib::Stockholm *result;
    
    {
        try {
            result = (QuantLib::Stockholm *)new QuantLib::Stockholm();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Stockholm(void * jarg1) {
    QuantLib::Stockholm *arg1 = (QuantLib::Stockholm *) 0 ;
    
    arg1 = (QuantLib::Stockholm *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Sydney() {
    void * jresult ;
    QuantLib::Sydney *result;
    
    {
        try {
            result = (QuantLib::Sydney *)new QuantLib::Sydney();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Sydney(void * jarg1) {
    QuantLib::Sydney *arg1 = (QuantLib::Sydney *) 0 ;
    
    arg1 = (QuantLib::Sydney *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_TARGET() {
    void * jresult ;
    QuantLib::TARGET *result;
    
    {
        try {
            result = (QuantLib::TARGET *)new QuantLib::TARGET();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_TARGET(void * jarg1) {
    QuantLib::TARGET *arg1 = (QuantLib::TARGET *) 0 ;
    
    arg1 = (QuantLib::TARGET *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Taipei() {
    void * jresult ;
    QuantLib::Taipei *result;
    
    {
        try {
            result = (QuantLib::Taipei *)new QuantLib::Taipei();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Taipei(void * jarg1) {
    QuantLib::Taipei *arg1 = (QuantLib::Taipei *) 0 ;
    
    arg1 = (QuantLib::Taipei *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Taiwan() {
    void * jresult ;
    QuantLib::Taiwan *result;
    
    {
        try {
            result = (QuantLib::Taiwan *)new QuantLib::Taiwan();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Taiwan(void * jarg1) {
    QuantLib::Taiwan *arg1 = (QuantLib::Taiwan *) 0 ;
    
    arg1 = (QuantLib::Taiwan *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Tokyo() {
    void * jresult ;
    QuantLib::Tokyo *result;
    
    {
        try {
            result = (QuantLib::Tokyo *)new QuantLib::Tokyo();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Tokyo(void * jarg1) {
    QuantLib::Tokyo *arg1 = (QuantLib::Tokyo *) 0 ;
    
    arg1 = (QuantLib::Tokyo *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Toronto() {
    void * jresult ;
    QuantLib::Toronto *result;
    
    {
        try {
            result = (QuantLib::Toronto *)new QuantLib::Toronto();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Toronto(void * jarg1) {
    QuantLib::Toronto *arg1 = (QuantLib::Toronto *) 0 ;
    
    arg1 = (QuantLib::Toronto *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_UnitedKingdom__SWIG_0(int jarg1) {
    void * jresult ;
    QuantLib::UnitedKingdom::Market arg1 ;
    QuantLib::UnitedKingdom *result;
    
    arg1 = (QuantLib::UnitedKingdom::Market)jarg1; 
    {
        try {
            result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_UnitedKingdom__SWIG_1() {
    void * jresult ;
    QuantLib::UnitedKingdom *result;
    
    {
        try {
            result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_UnitedKingdom(void * jarg1) {
    QuantLib::UnitedKingdom *arg1 = (QuantLib::UnitedKingdom *) 0 ;
    
    arg1 = (QuantLib::UnitedKingdom *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_UnitedStates__SWIG_0(int jarg1) {
    void * jresult ;
    QuantLib::UnitedStates::Market arg1 ;
    QuantLib::UnitedStates *result;
    
    arg1 = (QuantLib::UnitedStates::Market)jarg1; 
    {
        try {
            result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_UnitedStates__SWIG_1() {
    void * jresult ;
    QuantLib::UnitedStates *result;
    
    {
        try {
            result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_UnitedStates(void * jarg1) {
    QuantLib::UnitedStates *arg1 = (QuantLib::UnitedStates *) 0 ;
    
    arg1 = (QuantLib::UnitedStates *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Warsaw() {
    void * jresult ;
    QuantLib::Warsaw *result;
    
    {
        try {
            result = (QuantLib::Warsaw *)new QuantLib::Warsaw();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Warsaw(void * jarg1) {
    QuantLib::Warsaw *arg1 = (QuantLib::Warsaw *) 0 ;
    
    arg1 = (QuantLib::Warsaw *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Wellington() {
    void * jresult ;
    QuantLib::Wellington *result;
    
    {
        try {
            result = (QuantLib::Wellington *)new QuantLib::Wellington();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Wellington(void * jarg1) {
    QuantLib::Wellington *arg1 = (QuantLib::Wellington *) 0 ;
    
    arg1 = (QuantLib::Wellington *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Zurich() {
    void * jresult ;
    QuantLib::Zurich *result;
    
    {
        try {
            result = (QuantLib::Zurich *)new QuantLib::Zurich();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Zurich(void * jarg1) {
    QuantLib::Zurich *arg1 = (QuantLib::Zurich *) 0 ;
    
    arg1 = (QuantLib::Zurich *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JointCalendar__SWIG_0(void * jarg1, void * jarg2, int jarg3) {
    void * jresult ;
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    JointCalendarRule arg3 ;
    QuantLib::JointCalendar *result;
    
    arg1 = (Calendar *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg2 = (Calendar *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg3 = (JointCalendarRule)jarg3; 
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JointCalendar__SWIG_1(void * jarg1, void * jarg2) {
    void * jresult ;
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    QuantLib::JointCalendar *result;
    
    arg1 = (Calendar *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg2 = (Calendar *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JointCalendar__SWIG_2(void * jarg1, void * jarg2, void * jarg3, int jarg4) {
    void * jresult ;
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    JointCalendarRule arg4 ;
    QuantLib::JointCalendar *result;
    
    arg1 = (Calendar *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg2 = (Calendar *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg3 = (Calendar *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg4 = (JointCalendarRule)jarg4; 
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JointCalendar__SWIG_3(void * jarg1, void * jarg2, void * jarg3) {
    void * jresult ;
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    QuantLib::JointCalendar *result;
    
    arg1 = (Calendar *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg2 = (Calendar *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg3 = (Calendar *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JointCalendar__SWIG_4(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
    void * jresult ;
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    Calendar *arg4 = 0 ;
    JointCalendarRule arg5 ;
    QuantLib::JointCalendar *result;
    
    arg1 = (Calendar *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg2 = (Calendar *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg3 = (Calendar *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg4 = (Calendar *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg5 = (JointCalendarRule)jarg5; 
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JointCalendar__SWIG_5(void * jarg1, void * jarg2, void * jarg3, void * jarg4) {
    void * jresult ;
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    Calendar *arg4 = 0 ;
    QuantLib::JointCalendar *result;
    
    arg1 = (Calendar *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg2 = (Calendar *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg3 = (Calendar *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg4 = (Calendar *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_JointCalendar(void * jarg1) {
    QuantLib::JointCalendar *arg1 = (QuantLib::JointCalendar *) 0 ;
    
    arg1 = (QuantLib::JointCalendar *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Rounding() {
    void * jresult ;
    Rounding *result;
    
    {
        try {
            result = (Rounding *)new Rounding();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_Rounding_apply(void * jarg1, double jarg2) {
    double jresult ;
    Rounding *arg1 = (Rounding *) 0 ;
    Decimal arg2 ;
    Decimal result;
    
    arg1 = (Rounding *)jarg1; 
    arg2 = (Decimal)jarg2; 
    {
        try {
            result = (Decimal)((Rounding const *)arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Rounding(void * jarg1) {
    Rounding *arg1 = (Rounding *) 0 ;
    
    arg1 = (Rounding *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_UpRounding__SWIG_0(int jarg1, int jarg2) {
    void * jresult ;
    Integer arg1 ;
    Integer arg2 ;
    UpRounding *result;
    
    arg1 = (Integer)jarg1; 
    arg2 = (Integer)jarg2; 
    {
        try {
            result = (UpRounding *)new UpRounding(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_UpRounding__SWIG_1(int jarg1) {
    void * jresult ;
    Integer arg1 ;
    UpRounding *result;
    
    arg1 = (Integer)jarg1; 
    {
        try {
            result = (UpRounding *)new UpRounding(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_UpRounding(void * jarg1) {
    UpRounding *arg1 = (UpRounding *) 0 ;
    
    arg1 = (UpRounding *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DownRounding__SWIG_0(int jarg1, int jarg2) {
    void * jresult ;
    Integer arg1 ;
    Integer arg2 ;
    DownRounding *result;
    
    arg1 = (Integer)jarg1; 
    arg2 = (Integer)jarg2; 
    {
        try {
            result = (DownRounding *)new DownRounding(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DownRounding__SWIG_1(int jarg1) {
    void * jresult ;
    Integer arg1 ;
    DownRounding *result;
    
    arg1 = (Integer)jarg1; 
    {
        try {
            result = (DownRounding *)new DownRounding(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DownRounding(void * jarg1) {
    DownRounding *arg1 = (DownRounding *) 0 ;
    
    arg1 = (DownRounding *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ClosestRounding__SWIG_0(int jarg1, int jarg2) {
    void * jresult ;
    Integer arg1 ;
    Integer arg2 ;
    ClosestRounding *result;
    
    arg1 = (Integer)jarg1; 
    arg2 = (Integer)jarg2; 
    {
        try {
            result = (ClosestRounding *)new ClosestRounding(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ClosestRounding__SWIG_1(int jarg1) {
    void * jresult ;
    Integer arg1 ;
    ClosestRounding *result;
    
    arg1 = (Integer)jarg1; 
    {
        try {
            result = (ClosestRounding *)new ClosestRounding(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ClosestRounding(void * jarg1) {
    ClosestRounding *arg1 = (ClosestRounding *) 0 ;
    
    arg1 = (ClosestRounding *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CeilingTruncation__SWIG_0(int jarg1, int jarg2) {
    void * jresult ;
    Integer arg1 ;
    Integer arg2 ;
    CeilingTruncation *result;
    
    arg1 = (Integer)jarg1; 
    arg2 = (Integer)jarg2; 
    {
        try {
            result = (CeilingTruncation *)new CeilingTruncation(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CeilingTruncation__SWIG_1(int jarg1) {
    void * jresult ;
    Integer arg1 ;
    CeilingTruncation *result;
    
    arg1 = (Integer)jarg1; 
    {
        try {
            result = (CeilingTruncation *)new CeilingTruncation(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CeilingTruncation(void * jarg1) {
    CeilingTruncation *arg1 = (CeilingTruncation *) 0 ;
    
    arg1 = (CeilingTruncation *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FloorTruncation__SWIG_0(int jarg1, int jarg2) {
    void * jresult ;
    Integer arg1 ;
    Integer arg2 ;
    FloorTruncation *result;
    
    arg1 = (Integer)jarg1; 
    arg2 = (Integer)jarg2; 
    {
        try {
            result = (FloorTruncation *)new FloorTruncation(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FloorTruncation__SWIG_1(int jarg1) {
    void * jresult ;
    Integer arg1 ;
    FloorTruncation *result;
    
    arg1 = (Integer)jarg1; 
    {
        try {
            result = (FloorTruncation *)new FloorTruncation(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_FloorTruncation(void * jarg1) {
    FloorTruncation *arg1 = (FloorTruncation *) 0 ;
    
    arg1 = (FloorTruncation *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Currency_name(void * jarg1) {
    char * jresult ;
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    
    arg1 = (Currency *)jarg1; 
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->name();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback(result->c_str()); 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Currency_code(void * jarg1) {
    char * jresult ;
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    
    arg1 = (Currency *)jarg1; 
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->code();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback(result->c_str()); 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Currency_numericCode(void * jarg1) {
    int jresult ;
    Currency *arg1 = (Currency *) 0 ;
    Integer result;
    
    arg1 = (Currency *)jarg1; 
    {
        try {
            result = (Integer)((Currency const *)arg1)->numericCode();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Currency_symbol(void * jarg1) {
    char * jresult ;
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    
    arg1 = (Currency *)jarg1; 
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->symbol();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback(result->c_str()); 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Currency_fractionSymbol(void * jarg1) {
    char * jresult ;
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    
    arg1 = (Currency *)jarg1; 
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->fractionSymbol();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback(result->c_str()); 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Currency_fractionsPerUnit(void * jarg1) {
    int jresult ;
    Currency *arg1 = (Currency *) 0 ;
    Integer result;
    
    arg1 = (Currency *)jarg1; 
    {
        try {
            result = (Integer)((Currency const *)arg1)->fractionsPerUnit();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Currency_rounding(void * jarg1) {
    void * jresult ;
    Currency *arg1 = (Currency *) 0 ;
    Rounding *result;
    
    arg1 = (Currency *)jarg1; 
    {
        try {
            {
                Rounding const &_result_ref = ((Currency const *)arg1)->rounding();
                result = (Rounding *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Currency_isValid(void * jarg1) {
    unsigned int jresult ;
    Currency *arg1 = (Currency *) 0 ;
    bool result;
    
    arg1 = (Currency *)jarg1; 
    {
        try {
            result = (bool)((Currency const *)arg1)->isValid();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Currency_triangulationCurrency(void * jarg1) {
    void * jresult ;
    Currency *arg1 = (Currency *) 0 ;
    Currency *result;
    
    arg1 = (Currency *)jarg1; 
    {
        try {
            {
                Currency const &_result_ref = ((Currency const *)arg1)->triangulationCurrency();
                result = (Currency *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Currency___str__(void * jarg1) {
    char * jresult ;
    Currency *arg1 = (Currency *) 0 ;
    std::string result;
    
    arg1 = (Currency *)jarg1; 
    {
        try {
            result = Currency___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Currency() {
    void * jresult ;
    Currency *result;
    
    {
        try {
            result = (Currency *)new Currency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Currency(void * jarg1) {
    Currency *arg1 = (Currency *) 0 ;
    
    arg1 = (Currency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ARSCurrency() {
    void * jresult ;
    QuantLib::ARSCurrency *result;
    
    {
        try {
            result = (QuantLib::ARSCurrency *)new QuantLib::ARSCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ARSCurrency(void * jarg1) {
    QuantLib::ARSCurrency *arg1 = (QuantLib::ARSCurrency *) 0 ;
    
    arg1 = (QuantLib::ARSCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ATSCurrency() {
    void * jresult ;
    QuantLib::ATSCurrency *result;
    
    {
        try {
            result = (QuantLib::ATSCurrency *)new QuantLib::ATSCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ATSCurrency(void * jarg1) {
    QuantLib::ATSCurrency *arg1 = (QuantLib::ATSCurrency *) 0 ;
    
    arg1 = (QuantLib::ATSCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_AUDCurrency() {
    void * jresult ;
    QuantLib::AUDCurrency *result;
    
    {
        try {
            result = (QuantLib::AUDCurrency *)new QuantLib::AUDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_AUDCurrency(void * jarg1) {
    QuantLib::AUDCurrency *arg1 = (QuantLib::AUDCurrency *) 0 ;
    
    arg1 = (QuantLib::AUDCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BDTCurrency() {
    void * jresult ;
    QuantLib::BDTCurrency *result;
    
    {
        try {
            result = (QuantLib::BDTCurrency *)new QuantLib::BDTCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BDTCurrency(void * jarg1) {
    QuantLib::BDTCurrency *arg1 = (QuantLib::BDTCurrency *) 0 ;
    
    arg1 = (QuantLib::BDTCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BEFCurrency() {
    void * jresult ;
    QuantLib::BEFCurrency *result;
    
    {
        try {
            result = (QuantLib::BEFCurrency *)new QuantLib::BEFCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BEFCurrency(void * jarg1) {
    QuantLib::BEFCurrency *arg1 = (QuantLib::BEFCurrency *) 0 ;
    
    arg1 = (QuantLib::BEFCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BGLCurrency() {
    void * jresult ;
    QuantLib::BGLCurrency *result;
    
    {
        try {
            result = (QuantLib::BGLCurrency *)new QuantLib::BGLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BGLCurrency(void * jarg1) {
    QuantLib::BGLCurrency *arg1 = (QuantLib::BGLCurrency *) 0 ;
    
    arg1 = (QuantLib::BGLCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BRLCurrency() {
    void * jresult ;
    QuantLib::BRLCurrency *result;
    
    {
        try {
            result = (QuantLib::BRLCurrency *)new QuantLib::BRLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BRLCurrency(void * jarg1) {
    QuantLib::BRLCurrency *arg1 = (QuantLib::BRLCurrency *) 0 ;
    
    arg1 = (QuantLib::BRLCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BYRCurrency() {
    void * jresult ;
    QuantLib::BYRCurrency *result;
    
    {
        try {
            result = (QuantLib::BYRCurrency *)new QuantLib::BYRCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BYRCurrency(void * jarg1) {
    QuantLib::BYRCurrency *arg1 = (QuantLib::BYRCurrency *) 0 ;
    
    arg1 = (QuantLib::BYRCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CADCurrency() {
    void * jresult ;
    QuantLib::CADCurrency *result;
    
    {
        try {
            result = (QuantLib::CADCurrency *)new QuantLib::CADCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CADCurrency(void * jarg1) {
    QuantLib::CADCurrency *arg1 = (QuantLib::CADCurrency *) 0 ;
    
    arg1 = (QuantLib::CADCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CHFCurrency() {
    void * jresult ;
    QuantLib::CHFCurrency *result;
    
    {
        try {
            result = (QuantLib::CHFCurrency *)new QuantLib::CHFCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CHFCurrency(void * jarg1) {
    QuantLib::CHFCurrency *arg1 = (QuantLib::CHFCurrency *) 0 ;
    
    arg1 = (QuantLib::CHFCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CLPCurrency() {
    void * jresult ;
    QuantLib::CLPCurrency *result;
    
    {
        try {
            result = (QuantLib::CLPCurrency *)new QuantLib::CLPCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CLPCurrency(void * jarg1) {
    QuantLib::CLPCurrency *arg1 = (QuantLib::CLPCurrency *) 0 ;
    
    arg1 = (QuantLib::CLPCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CNYCurrency() {
    void * jresult ;
    QuantLib::CNYCurrency *result;
    
    {
        try {
            result = (QuantLib::CNYCurrency *)new QuantLib::CNYCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CNYCurrency(void * jarg1) {
    QuantLib::CNYCurrency *arg1 = (QuantLib::CNYCurrency *) 0 ;
    
    arg1 = (QuantLib::CNYCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_COPCurrency() {
    void * jresult ;
    QuantLib::COPCurrency *result;
    
    {
        try {
            result = (QuantLib::COPCurrency *)new QuantLib::COPCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_COPCurrency(void * jarg1) {
    QuantLib::COPCurrency *arg1 = (QuantLib::COPCurrency *) 0 ;
    
    arg1 = (QuantLib::COPCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CYPCurrency() {
    void * jresult ;
    QuantLib::CYPCurrency *result;
    
    {
        try {
            result = (QuantLib::CYPCurrency *)new QuantLib::CYPCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CYPCurrency(void * jarg1) {
    QuantLib::CYPCurrency *arg1 = (QuantLib::CYPCurrency *) 0 ;
    
    arg1 = (QuantLib::CYPCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CZKCurrency() {
    void * jresult ;
    QuantLib::CZKCurrency *result;
    
    {
        try {
            result = (QuantLib::CZKCurrency *)new QuantLib::CZKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CZKCurrency(void * jarg1) {
    QuantLib::CZKCurrency *arg1 = (QuantLib::CZKCurrency *) 0 ;
    
    arg1 = (QuantLib::CZKCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DEMCurrency() {
    void * jresult ;
    QuantLib::DEMCurrency *result;
    
    {
        try {
            result = (QuantLib::DEMCurrency *)new QuantLib::DEMCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DEMCurrency(void * jarg1) {
    QuantLib::DEMCurrency *arg1 = (QuantLib::DEMCurrency *) 0 ;
    
    arg1 = (QuantLib::DEMCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DKKCurrency() {
    void * jresult ;
    QuantLib::DKKCurrency *result;
    
    {
        try {
            result = (QuantLib::DKKCurrency *)new QuantLib::DKKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DKKCurrency(void * jarg1) {
    QuantLib::DKKCurrency *arg1 = (QuantLib::DKKCurrency *) 0 ;
    
    arg1 = (QuantLib::DKKCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_EEKCurrency() {
    void * jresult ;
    QuantLib::EEKCurrency *result;
    
    {
        try {
            result = (QuantLib::EEKCurrency *)new QuantLib::EEKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_EEKCurrency(void * jarg1) {
    QuantLib::EEKCurrency *arg1 = (QuantLib::EEKCurrency *) 0 ;
    
    arg1 = (QuantLib::EEKCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ESPCurrency() {
    void * jresult ;
    QuantLib::ESPCurrency *result;
    
    {
        try {
            result = (QuantLib::ESPCurrency *)new QuantLib::ESPCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ESPCurrency(void * jarg1) {
    QuantLib::ESPCurrency *arg1 = (QuantLib::ESPCurrency *) 0 ;
    
    arg1 = (QuantLib::ESPCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_EURCurrency() {
    void * jresult ;
    QuantLib::EURCurrency *result;
    
    {
        try {
            result = (QuantLib::EURCurrency *)new QuantLib::EURCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_EURCurrency(void * jarg1) {
    QuantLib::EURCurrency *arg1 = (QuantLib::EURCurrency *) 0 ;
    
    arg1 = (QuantLib::EURCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FIMCurrency() {
    void * jresult ;
    QuantLib::FIMCurrency *result;
    
    {
        try {
            result = (QuantLib::FIMCurrency *)new QuantLib::FIMCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_FIMCurrency(void * jarg1) {
    QuantLib::FIMCurrency *arg1 = (QuantLib::FIMCurrency *) 0 ;
    
    arg1 = (QuantLib::FIMCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FRFCurrency() {
    void * jresult ;
    QuantLib::FRFCurrency *result;
    
    {
        try {
            result = (QuantLib::FRFCurrency *)new QuantLib::FRFCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_FRFCurrency(void * jarg1) {
    QuantLib::FRFCurrency *arg1 = (QuantLib::FRFCurrency *) 0 ;
    
    arg1 = (QuantLib::FRFCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GBPCurrency() {
    void * jresult ;
    QuantLib::GBPCurrency *result;
    
    {
        try {
            result = (QuantLib::GBPCurrency *)new QuantLib::GBPCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GBPCurrency(void * jarg1) {
    QuantLib::GBPCurrency *arg1 = (QuantLib::GBPCurrency *) 0 ;
    
    arg1 = (QuantLib::GBPCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GRDCurrency() {
    void * jresult ;
    QuantLib::GRDCurrency *result;
    
    {
        try {
            result = (QuantLib::GRDCurrency *)new QuantLib::GRDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GRDCurrency(void * jarg1) {
    QuantLib::GRDCurrency *arg1 = (QuantLib::GRDCurrency *) 0 ;
    
    arg1 = (QuantLib::GRDCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_HKDCurrency() {
    void * jresult ;
    QuantLib::HKDCurrency *result;
    
    {
        try {
            result = (QuantLib::HKDCurrency *)new QuantLib::HKDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_HKDCurrency(void * jarg1) {
    QuantLib::HKDCurrency *arg1 = (QuantLib::HKDCurrency *) 0 ;
    
    arg1 = (QuantLib::HKDCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_HUFCurrency() {
    void * jresult ;
    QuantLib::HUFCurrency *result;
    
    {
        try {
            result = (QuantLib::HUFCurrency *)new QuantLib::HUFCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_HUFCurrency(void * jarg1) {
    QuantLib::HUFCurrency *arg1 = (QuantLib::HUFCurrency *) 0 ;
    
    arg1 = (QuantLib::HUFCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_IEPCurrency() {
    void * jresult ;
    QuantLib::IEPCurrency *result;
    
    {
        try {
            result = (QuantLib::IEPCurrency *)new QuantLib::IEPCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_IEPCurrency(void * jarg1) {
    QuantLib::IEPCurrency *arg1 = (QuantLib::IEPCurrency *) 0 ;
    
    arg1 = (QuantLib::IEPCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ILSCurrency() {
    void * jresult ;
    QuantLib::ILSCurrency *result;
    
    {
        try {
            result = (QuantLib::ILSCurrency *)new QuantLib::ILSCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ILSCurrency(void * jarg1) {
    QuantLib::ILSCurrency *arg1 = (QuantLib::ILSCurrency *) 0 ;
    
    arg1 = (QuantLib::ILSCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_INRCurrency() {
    void * jresult ;
    QuantLib::INRCurrency *result;
    
    {
        try {
            result = (QuantLib::INRCurrency *)new QuantLib::INRCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_INRCurrency(void * jarg1) {
    QuantLib::INRCurrency *arg1 = (QuantLib::INRCurrency *) 0 ;
    
    arg1 = (QuantLib::INRCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_IQDCurrency() {
    void * jresult ;
    QuantLib::IQDCurrency *result;
    
    {
        try {
            result = (QuantLib::IQDCurrency *)new QuantLib::IQDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_IQDCurrency(void * jarg1) {
    QuantLib::IQDCurrency *arg1 = (QuantLib::IQDCurrency *) 0 ;
    
    arg1 = (QuantLib::IQDCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_IRRCurrency() {
    void * jresult ;
    QuantLib::IRRCurrency *result;
    
    {
        try {
            result = (QuantLib::IRRCurrency *)new QuantLib::IRRCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_IRRCurrency(void * jarg1) {
    QuantLib::IRRCurrency *arg1 = (QuantLib::IRRCurrency *) 0 ;
    
    arg1 = (QuantLib::IRRCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ISKCurrency() {
    void * jresult ;
    QuantLib::ISKCurrency *result;
    
    {
        try {
            result = (QuantLib::ISKCurrency *)new QuantLib::ISKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ISKCurrency(void * jarg1) {
    QuantLib::ISKCurrency *arg1 = (QuantLib::ISKCurrency *) 0 ;
    
    arg1 = (QuantLib::ISKCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ITLCurrency() {
    void * jresult ;
    QuantLib::ITLCurrency *result;
    
    {
        try {
            result = (QuantLib::ITLCurrency *)new QuantLib::ITLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ITLCurrency(void * jarg1) {
    QuantLib::ITLCurrency *arg1 = (QuantLib::ITLCurrency *) 0 ;
    
    arg1 = (QuantLib::ITLCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JPYCurrency() {
    void * jresult ;
    QuantLib::JPYCurrency *result;
    
    {
        try {
            result = (QuantLib::JPYCurrency *)new QuantLib::JPYCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_JPYCurrency(void * jarg1) {
    QuantLib::JPYCurrency *arg1 = (QuantLib::JPYCurrency *) 0 ;
    
    arg1 = (QuantLib::JPYCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_KRWCurrency() {
    void * jresult ;
    QuantLib::KRWCurrency *result;
    
    {
        try {
            result = (QuantLib::KRWCurrency *)new QuantLib::KRWCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_KRWCurrency(void * jarg1) {
    QuantLib::KRWCurrency *arg1 = (QuantLib::KRWCurrency *) 0 ;
    
    arg1 = (QuantLib::KRWCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_KWDCurrency() {
    void * jresult ;
    QuantLib::KWDCurrency *result;
    
    {
        try {
            result = (QuantLib::KWDCurrency *)new QuantLib::KWDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_KWDCurrency(void * jarg1) {
    QuantLib::KWDCurrency *arg1 = (QuantLib::KWDCurrency *) 0 ;
    
    arg1 = (QuantLib::KWDCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LTLCurrency() {
    void * jresult ;
    QuantLib::LTLCurrency *result;
    
    {
        try {
            result = (QuantLib::LTLCurrency *)new QuantLib::LTLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LTLCurrency(void * jarg1) {
    QuantLib::LTLCurrency *arg1 = (QuantLib::LTLCurrency *) 0 ;
    
    arg1 = (QuantLib::LTLCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LUFCurrency() {
    void * jresult ;
    QuantLib::LUFCurrency *result;
    
    {
        try {
            result = (QuantLib::LUFCurrency *)new QuantLib::LUFCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LUFCurrency(void * jarg1) {
    QuantLib::LUFCurrency *arg1 = (QuantLib::LUFCurrency *) 0 ;
    
    arg1 = (QuantLib::LUFCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LVLCurrency() {
    void * jresult ;
    QuantLib::LVLCurrency *result;
    
    {
        try {
            result = (QuantLib::LVLCurrency *)new QuantLib::LVLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LVLCurrency(void * jarg1) {
    QuantLib::LVLCurrency *arg1 = (QuantLib::LVLCurrency *) 0 ;
    
    arg1 = (QuantLib::LVLCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_MTLCurrency() {
    void * jresult ;
    QuantLib::MTLCurrency *result;
    
    {
        try {
            result = (QuantLib::MTLCurrency *)new QuantLib::MTLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_MTLCurrency(void * jarg1) {
    QuantLib::MTLCurrency *arg1 = (QuantLib::MTLCurrency *) 0 ;
    
    arg1 = (QuantLib::MTLCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_MXNCurrency() {
    void * jresult ;
    QuantLib::MXNCurrency *result;
    
    {
        try {
            result = (QuantLib::MXNCurrency *)new QuantLib::MXNCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_MXNCurrency(void * jarg1) {
    QuantLib::MXNCurrency *arg1 = (QuantLib::MXNCurrency *) 0 ;
    
    arg1 = (QuantLib::MXNCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NLGCurrency() {
    void * jresult ;
    QuantLib::NLGCurrency *result;
    
    {
        try {
            result = (QuantLib::NLGCurrency *)new QuantLib::NLGCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NLGCurrency(void * jarg1) {
    QuantLib::NLGCurrency *arg1 = (QuantLib::NLGCurrency *) 0 ;
    
    arg1 = (QuantLib::NLGCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NOKCurrency() {
    void * jresult ;
    QuantLib::NOKCurrency *result;
    
    {
        try {
            result = (QuantLib::NOKCurrency *)new QuantLib::NOKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NOKCurrency(void * jarg1) {
    QuantLib::NOKCurrency *arg1 = (QuantLib::NOKCurrency *) 0 ;
    
    arg1 = (QuantLib::NOKCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NPRCurrency() {
    void * jresult ;
    QuantLib::NPRCurrency *result;
    
    {
        try {
            result = (QuantLib::NPRCurrency *)new QuantLib::NPRCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NPRCurrency(void * jarg1) {
    QuantLib::NPRCurrency *arg1 = (QuantLib::NPRCurrency *) 0 ;
    
    arg1 = (QuantLib::NPRCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NZDCurrency() {
    void * jresult ;
    QuantLib::NZDCurrency *result;
    
    {
        try {
            result = (QuantLib::NZDCurrency *)new QuantLib::NZDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NZDCurrency(void * jarg1) {
    QuantLib::NZDCurrency *arg1 = (QuantLib::NZDCurrency *) 0 ;
    
    arg1 = (QuantLib::NZDCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PKRCurrency() {
    void * jresult ;
    QuantLib::PKRCurrency *result;
    
    {
        try {
            result = (QuantLib::PKRCurrency *)new QuantLib::PKRCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_PKRCurrency(void * jarg1) {
    QuantLib::PKRCurrency *arg1 = (QuantLib::PKRCurrency *) 0 ;
    
    arg1 = (QuantLib::PKRCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PLNCurrency() {
    void * jresult ;
    QuantLib::PLNCurrency *result;
    
    {
        try {
            result = (QuantLib::PLNCurrency *)new QuantLib::PLNCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_PLNCurrency(void * jarg1) {
    QuantLib::PLNCurrency *arg1 = (QuantLib::PLNCurrency *) 0 ;
    
    arg1 = (QuantLib::PLNCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PTECurrency() {
    void * jresult ;
    QuantLib::PTECurrency *result;
    
    {
        try {
            result = (QuantLib::PTECurrency *)new QuantLib::PTECurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_PTECurrency(void * jarg1) {
    QuantLib::PTECurrency *arg1 = (QuantLib::PTECurrency *) 0 ;
    
    arg1 = (QuantLib::PTECurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ROLCurrency() {
    void * jresult ;
    QuantLib::ROLCurrency *result;
    
    {
        try {
            result = (QuantLib::ROLCurrency *)new QuantLib::ROLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ROLCurrency(void * jarg1) {
    QuantLib::ROLCurrency *arg1 = (QuantLib::ROLCurrency *) 0 ;
    
    arg1 = (QuantLib::ROLCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SARCurrency() {
    void * jresult ;
    QuantLib::SARCurrency *result;
    
    {
        try {
            result = (QuantLib::SARCurrency *)new QuantLib::SARCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SARCurrency(void * jarg1) {
    QuantLib::SARCurrency *arg1 = (QuantLib::SARCurrency *) 0 ;
    
    arg1 = (QuantLib::SARCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SEKCurrency() {
    void * jresult ;
    QuantLib::SEKCurrency *result;
    
    {
        try {
            result = (QuantLib::SEKCurrency *)new QuantLib::SEKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SEKCurrency(void * jarg1) {
    QuantLib::SEKCurrency *arg1 = (QuantLib::SEKCurrency *) 0 ;
    
    arg1 = (QuantLib::SEKCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SGDCurrency() {
    void * jresult ;
    QuantLib::SGDCurrency *result;
    
    {
        try {
            result = (QuantLib::SGDCurrency *)new QuantLib::SGDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SGDCurrency(void * jarg1) {
    QuantLib::SGDCurrency *arg1 = (QuantLib::SGDCurrency *) 0 ;
    
    arg1 = (QuantLib::SGDCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SITCurrency() {
    void * jresult ;
    QuantLib::SITCurrency *result;
    
    {
        try {
            result = (QuantLib::SITCurrency *)new QuantLib::SITCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SITCurrency(void * jarg1) {
    QuantLib::SITCurrency *arg1 = (QuantLib::SITCurrency *) 0 ;
    
    arg1 = (QuantLib::SITCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SKKCurrency() {
    void * jresult ;
    QuantLib::SKKCurrency *result;
    
    {
        try {
            result = (QuantLib::SKKCurrency *)new QuantLib::SKKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SKKCurrency(void * jarg1) {
    QuantLib::SKKCurrency *arg1 = (QuantLib::SKKCurrency *) 0 ;
    
    arg1 = (QuantLib::SKKCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_THBCurrency() {
    void * jresult ;
    QuantLib::THBCurrency *result;
    
    {
        try {
            result = (QuantLib::THBCurrency *)new QuantLib::THBCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_THBCurrency(void * jarg1) {
    QuantLib::THBCurrency *arg1 = (QuantLib::THBCurrency *) 0 ;
    
    arg1 = (QuantLib::THBCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_TRLCurrency() {
    void * jresult ;
    QuantLib::TRLCurrency *result;
    
    {
        try {
            result = (QuantLib::TRLCurrency *)new QuantLib::TRLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_TRLCurrency(void * jarg1) {
    QuantLib::TRLCurrency *arg1 = (QuantLib::TRLCurrency *) 0 ;
    
    arg1 = (QuantLib::TRLCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_TRYCurrency() {
    void * jresult ;
    QuantLib::TRYCurrency *result;
    
    {
        try {
            result = (QuantLib::TRYCurrency *)new QuantLib::TRYCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_TRYCurrency(void * jarg1) {
    QuantLib::TRYCurrency *arg1 = (QuantLib::TRYCurrency *) 0 ;
    
    arg1 = (QuantLib::TRYCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_TTDCurrency() {
    void * jresult ;
    QuantLib::TTDCurrency *result;
    
    {
        try {
            result = (QuantLib::TTDCurrency *)new QuantLib::TTDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_TTDCurrency(void * jarg1) {
    QuantLib::TTDCurrency *arg1 = (QuantLib::TTDCurrency *) 0 ;
    
    arg1 = (QuantLib::TTDCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_TWDCurrency() {
    void * jresult ;
    QuantLib::TWDCurrency *result;
    
    {
        try {
            result = (QuantLib::TWDCurrency *)new QuantLib::TWDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_TWDCurrency(void * jarg1) {
    QuantLib::TWDCurrency *arg1 = (QuantLib::TWDCurrency *) 0 ;
    
    arg1 = (QuantLib::TWDCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_USDCurrency() {
    void * jresult ;
    QuantLib::USDCurrency *result;
    
    {
        try {
            result = (QuantLib::USDCurrency *)new QuantLib::USDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_USDCurrency(void * jarg1) {
    QuantLib::USDCurrency *arg1 = (QuantLib::USDCurrency *) 0 ;
    
    arg1 = (QuantLib::USDCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_VEBCurrency() {
    void * jresult ;
    QuantLib::VEBCurrency *result;
    
    {
        try {
            result = (QuantLib::VEBCurrency *)new QuantLib::VEBCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_VEBCurrency(void * jarg1) {
    QuantLib::VEBCurrency *arg1 = (QuantLib::VEBCurrency *) 0 ;
    
    arg1 = (QuantLib::VEBCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ZARCurrency() {
    void * jresult ;
    QuantLib::ZARCurrency *result;
    
    {
        try {
            result = (QuantLib::ZARCurrency *)new QuantLib::ZARCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ZARCurrency(void * jarg1) {
    QuantLib::ZARCurrency *arg1 = (QuantLib::ZARCurrency *) 0 ;
    
    arg1 = (QuantLib::ZARCurrency *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LinearInterpolation(void * jarg1, void * jarg2) {
    void * jresult ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeLinearInterpolation *result;
    
    arg1 = (Array *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    arg2 = (Array *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (SafeLinearInterpolation *)new SafeLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LinearInterpolation_call__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
    double jresult ;
    SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    arg1 = (SafeLinearInterpolation *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LinearInterpolation_call__SWIG_1(void * jarg1, double jarg2) {
    double jresult ;
    SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
    Real arg2 ;
    Real result;
    
    arg1 = (SafeLinearInterpolation *)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LinearInterpolation(void * jarg1) {
    SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
    
    arg1 = (SafeLinearInterpolation *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LogLinearInterpolation(void * jarg1, void * jarg2) {
    void * jresult ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeLogLinearInterpolation *result;
    
    arg1 = (Array *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    arg2 = (Array *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (SafeLogLinearInterpolation *)new SafeLogLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LogLinearInterpolation_call__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
    double jresult ;
    SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    arg1 = (SafeLogLinearInterpolation *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LogLinearInterpolation_call__SWIG_1(void * jarg1, double jarg2) {
    double jresult ;
    SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
    Real arg2 ;
    Real result;
    
    arg1 = (SafeLogLinearInterpolation *)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LogLinearInterpolation(void * jarg1) {
    SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
    
    arg1 = (SafeLogLinearInterpolation *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BackwardFlatInterpolation(void * jarg1, void * jarg2) {
    void * jresult ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeBackwardFlatInterpolation *result;
    
    arg1 = (Array *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    arg2 = (Array *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (SafeBackwardFlatInterpolation *)new SafeBackwardFlatInterpolation((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BackwardFlatInterpolation_call__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
    double jresult ;
    SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    arg1 = (SafeBackwardFlatInterpolation *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BackwardFlatInterpolation_call__SWIG_1(void * jarg1, double jarg2) {
    double jresult ;
    SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
    Real arg2 ;
    Real result;
    
    arg1 = (SafeBackwardFlatInterpolation *)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BackwardFlatInterpolation(void * jarg1) {
    SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
    
    arg1 = (SafeBackwardFlatInterpolation *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ForwardFlatInterpolation(void * jarg1, void * jarg2) {
    void * jresult ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeForwardFlatInterpolation *result;
    
    arg1 = (Array *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    arg2 = (Array *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (SafeForwardFlatInterpolation *)new SafeForwardFlatInterpolation((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_ForwardFlatInterpolation_call__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
    double jresult ;
    SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    arg1 = (SafeForwardFlatInterpolation *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_ForwardFlatInterpolation_call__SWIG_1(void * jarg1, double jarg2) {
    double jresult ;
    SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
    Real arg2 ;
    Real result;
    
    arg1 = (SafeForwardFlatInterpolation *)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ForwardFlatInterpolation(void * jarg1) {
    SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
    
    arg1 = (SafeForwardFlatInterpolation *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CubicSpline(void * jarg1, void * jarg2) {
    void * jresult ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeNaturalCubicSpline *result;
    
    arg1 = (Array *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    arg2 = (Array *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (SafeNaturalCubicSpline *)new SafeNaturalCubicSpline((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_CubicSpline_call__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
    double jresult ;
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    arg1 = (SafeNaturalCubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_CubicSpline_call__SWIG_1(void * jarg1, double jarg2) {
    double jresult ;
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    
    arg1 = (SafeNaturalCubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_CubicSpline_derivative__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
    double jresult ;
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    arg1 = (SafeNaturalCubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)SafeNaturalCubicSpline_derivative__SWIG_0(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_CubicSpline_derivative__SWIG_1(void * jarg1, double jarg2) {
    double jresult ;
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    
    arg1 = (SafeNaturalCubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)SafeNaturalCubicSpline_derivative__SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_CubicSpline_secondDerivative__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
    double jresult ;
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    arg1 = (SafeNaturalCubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)SafeNaturalCubicSpline_secondDerivative__SWIG_0(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_CubicSpline_secondDerivative__SWIG_1(void * jarg1, double jarg2) {
    double jresult ;
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    
    arg1 = (SafeNaturalCubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)SafeNaturalCubicSpline_secondDerivative__SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CubicSpline(void * jarg1) {
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    
    arg1 = (SafeNaturalCubicSpline *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_MonotonicCubicSpline(void * jarg1, void * jarg2) {
    void * jresult ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeNaturalMonotonicCubicSpline *result;
    
    arg1 = (Array *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    arg2 = (Array *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (SafeNaturalMonotonicCubicSpline *)new SafeNaturalMonotonicCubicSpline((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_MonotonicCubicSpline_call__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
    double jresult ;
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_MonotonicCubicSpline_call__SWIG_1(void * jarg1, double jarg2) {
    double jresult ;
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    
    arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_MonotonicCubicSpline_derivative__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
    double jresult ;
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_MonotonicCubicSpline_derivative__SWIG_1(void * jarg1, double jarg2) {
    double jresult ;
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    
    arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_MonotonicCubicSpline_secondDerivative__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
    double jresult ;
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_MonotonicCubicSpline_secondDerivative__SWIG_1(void * jarg1, double jarg2) {
    double jresult ;
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    
    arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_MonotonicCubicSpline(void * jarg1) {
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    
    arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BilinearInterpolation(void * jarg1, void * jarg2, void * jarg3) {
    void * jresult ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix *arg3 = 0 ;
    SafeBilinearInterpolation *result;
    
    arg1 = (Array *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    arg2 = (Array *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    arg3 = (Matrix *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (SafeBilinearInterpolation *)new SafeBilinearInterpolation((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BilinearInterpolation_call__SWIG_0(void * jarg1, double jarg2, double jarg3, unsigned int jarg4) {
    double jresult ;
    SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
    Real arg2 ;
    Real arg3 ;
    bool arg4 ;
    Real result;
    
    arg1 = (SafeBilinearInterpolation *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = (Real)jarg3; 
    arg4 = jarg4 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BilinearInterpolation_call__SWIG_1(void * jarg1, double jarg2, double jarg3) {
    double jresult ;
    SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
    Real arg2 ;
    Real arg3 ;
    Real result;
    
    arg1 = (SafeBilinearInterpolation *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = (Real)jarg3; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BilinearInterpolation(void * jarg1) {
    SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
    
    arg1 = (SafeBilinearInterpolation *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BicubicSpline(void * jarg1, void * jarg2, void * jarg3) {
    void * jresult ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix *arg3 = 0 ;
    SafeBicubicSpline *result;
    
    arg1 = (Array *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    arg2 = (Array *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
        return 0;
    } 
    arg3 = (Matrix *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (SafeBicubicSpline *)new SafeBicubicSpline((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BicubicSpline_call__SWIG_0(void * jarg1, double jarg2, double jarg3, unsigned int jarg4) {
    double jresult ;
    SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
    Real arg2 ;
    Real arg3 ;
    bool arg4 ;
    Real result;
    
    arg1 = (SafeBicubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = (Real)jarg3; 
    arg4 = jarg4 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BicubicSpline_call__SWIG_1(void * jarg1, double jarg2, double jarg3) {
    double jresult ;
    SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
    Real arg2 ;
    Real arg3 ;
    Real result;
    
    arg1 = (SafeBicubicSpline *)jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = (Real)jarg3; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BicubicSpline(void * jarg1) {
    SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
    
    arg1 = (SafeBicubicSpline *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure___deref__(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    YieldTermStructure *result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (YieldTermStructure *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_YieldTermStructure_isNull(void * jarg1) {
    unsigned int jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    bool result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_YieldTermStructure_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_asObservable(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    boost::shared_ptr<Observable > result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    {
        try {
            result = boost_shared_ptr_Sl_YieldTermStructure_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_dayCounter(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    SwigValueWrapper<DayCounter > result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new DayCounter((DayCounter &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_calendar(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    SwigValueWrapper<Calendar > result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (*arg1)->calendar();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Calendar((Calendar &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_referenceDate(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_maxDate(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructure_maxTime(void * jarg1) {
    double jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructure_discount__SWIG_0(void * jarg1, void * jarg2, unsigned int jarg3) {
    double jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 ;
    DiscountFactor result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructure_discount__SWIG_1(void * jarg1, void * jarg2) {
    double jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DiscountFactor result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructure_discount__SWIG_2(void * jarg1, double jarg2, unsigned int jarg3) {
    double jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 ;
    DiscountFactor result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructure_discount__SWIG_3(void * jarg1, double jarg2) {
    double jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    DiscountFactor result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_zeroRate__SWIG_0(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5, unsigned int jarg6) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    bool arg6 ;
    InterestRate result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    arg6 = jarg6 ? true : false; 
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_zeroRate__SWIG_1(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    InterestRate result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_zeroRate__SWIG_2(void * jarg1, void * jarg2, void * jarg3, int jarg4) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    InterestRate result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_zeroRate__SWIG_3(void * jarg1, double jarg2, int jarg3, int jarg4, unsigned int jarg5) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    bool arg5 ;
    InterestRate result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    arg4 = (Frequency)jarg4; 
    arg5 = jarg5 ? true : false; 
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_zeroRate__SWIG_4(void * jarg1, double jarg2, int jarg3, int jarg4) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    InterestRate result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    arg4 = (Frequency)jarg4; 
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_zeroRate__SWIG_5(void * jarg1, double jarg2, int jarg3) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    InterestRate result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_forwardRate__SWIG_0(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6, unsigned int jarg7) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    bool arg7 ;
    InterestRate result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    arg7 = jarg7 ? true : false; 
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6,arg7);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_forwardRate__SWIG_1(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    InterestRate result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_forwardRate__SWIG_2(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    InterestRate result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_forwardRate__SWIG_3(void * jarg1, double jarg2, double jarg3, int jarg4, int jarg5, unsigned int jarg6) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    Frequency arg5 ;
    bool arg6 ;
    InterestRate result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Time)jarg3; 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    arg6 = jarg6 ? true : false; 
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_forwardRate__SWIG_4(void * jarg1, double jarg2, double jarg3, int jarg4, int jarg5) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    Frequency arg5 ;
    InterestRate result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Time)jarg3; 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_forwardRate__SWIG_5(void * jarg1, double jarg2, double jarg3, int jarg4) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    InterestRate result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Time)jarg3; 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_YieldTermStructure_enableExtrapolation(void * jarg1) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    {
        try {
            (*arg1)->enableExtrapolation();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_YieldTermStructure_disableExtrapolation(void * jarg1) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    {
        try {
            (*arg1)->disableExtrapolation();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_YieldTermStructure_allowsExtrapolation(void * jarg1) {
    unsigned int jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    bool result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (bool)(*arg1)->allowsExtrapolation();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_YieldTermStructure() {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *result;
    
    {
        try {
            result = (boost::shared_ptr<YieldTermStructure > *)new boost::shared_ptr<YieldTermStructure >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_YieldTermStructure(void * jarg1) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_YieldTermStructureHandle__SWIG_0(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<YieldTermStructure > *arg1 = 0 ;
    Handle<YieldTermStructure > *result;
    
    arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<YieldTermStructure > const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (Handle<YieldTermStructure > *)new Handle<YieldTermStructure >((boost::shared_ptr<YieldTermStructure > const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_YieldTermStructureHandle__SWIG_1() {
    void * jresult ;
    Handle<YieldTermStructure > *result;
    
    {
        try {
            result = (Handle<YieldTermStructure > *)new Handle<YieldTermStructure >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle___deref__(void * jarg1) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    boost::shared_ptr<YieldTermStructure > result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new boost::shared_ptr<YieldTermStructure >((boost::shared_ptr<YieldTermStructure > &)result); 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_YieldTermStructureHandle_linkTo(void * jarg1, void * jarg2) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    boost::shared_ptr<YieldTermStructure > *arg2 = 0 ;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (boost::shared_ptr<YieldTermStructure > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<YieldTermStructure > const & type is null", 0);
        return ;
    } 
    {
        try {
            (arg1)->linkTo((boost::shared_ptr<YieldTermStructure > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_YieldTermStructureHandle_empty(void * jarg1) {
    unsigned int jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    bool result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (bool)(arg1)->empty();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_asObservable(void * jarg1) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    boost::shared_ptr<Observable > result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    {
        try {
            result = Handle_Sl_YieldTermStructure_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_dayCounter(void * jarg1) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    SwigValueWrapper<DayCounter > result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new DayCounter((DayCounter &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_calendar(void * jarg1) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    SwigValueWrapper<Calendar > result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (*arg1)->calendar();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Calendar((Calendar &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_referenceDate(void * jarg1) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_maxDate(void * jarg1) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new Date((Date &)result); 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructureHandle_maxTime(void * jarg1) {
    double jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructureHandle_discount__SWIG_0(void * jarg1, void * jarg2, unsigned int jarg3) {
    double jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 ;
    DiscountFactor result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructureHandle_discount__SWIG_1(void * jarg1, void * jarg2) {
    double jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DiscountFactor result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructureHandle_discount__SWIG_2(void * jarg1, double jarg2, unsigned int jarg3) {
    double jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 ;
    DiscountFactor result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructureHandle_discount__SWIG_3(void * jarg1, double jarg2) {
    double jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    DiscountFactor result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_zeroRate__SWIG_0(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5, unsigned int jarg6) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    bool arg6 ;
    InterestRate result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    arg6 = jarg6 ? true : false; 
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_zeroRate__SWIG_1(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    InterestRate result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_zeroRate__SWIG_2(void * jarg1, void * jarg2, void * jarg3, int jarg4) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    InterestRate result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_zeroRate__SWIG_3(void * jarg1, double jarg2, int jarg3, int jarg4, unsigned int jarg5) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    bool arg5 ;
    InterestRate result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    arg4 = (Frequency)jarg4; 
    arg5 = jarg5 ? true : false; 
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_zeroRate__SWIG_4(void * jarg1, double jarg2, int jarg3, int jarg4) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    InterestRate result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    arg4 = (Frequency)jarg4; 
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_zeroRate__SWIG_5(void * jarg1, double jarg2, int jarg3) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    InterestRate result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_forwardRate__SWIG_0(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6, unsigned int jarg7) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    bool arg7 ;
    InterestRate result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    arg7 = jarg7 ? true : false; 
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6,arg7);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_forwardRate__SWIG_1(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    InterestRate result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_forwardRate__SWIG_2(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    InterestRate result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg3 = (Date *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_forwardRate__SWIG_3(void * jarg1, double jarg2, double jarg3, int jarg4, int jarg5, unsigned int jarg6) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    Frequency arg5 ;
    bool arg6 ;
    InterestRate result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Time)jarg3; 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    arg6 = jarg6 ? true : false; 
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_forwardRate__SWIG_4(void * jarg1, double jarg2, double jarg3, int jarg4, int jarg5) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    Frequency arg5 ;
    InterestRate result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Time)jarg3; 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_forwardRate__SWIG_5(void * jarg1, double jarg2, double jarg3, int jarg4) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    InterestRate result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Time)jarg3; 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_YieldTermStructureHandle_enableExtrapolation(void * jarg1) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    {
        try {
            (*arg1)->enableExtrapolation();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_YieldTermStructureHandle_disableExtrapolation(void * jarg1) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    {
        try {
            (*arg1)->disableExtrapolation();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_YieldTermStructureHandle_allowsExtrapolation(void * jarg1) {
    unsigned int jresult ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    bool result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    {
        try {
            result = (bool)(*arg1)->allowsExtrapolation();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_YieldTermStructureHandle(void * jarg1) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ImpliedTermStructure(void * jarg1, void * jarg2) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = 0 ;
    Date *arg2 = 0 ;
    ImpliedTermStructurePtr *result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
        return 0;
    } 
    arg2 = (Date *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (ImpliedTermStructurePtr *)new_ImpliedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ImpliedTermStructure(void * jarg1) {
    ImpliedTermStructurePtr *arg1 = (ImpliedTermStructurePtr *) 0 ;
    
    arg1 = (ImpliedTermStructurePtr *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ZeroSpreadedTermStructure(void * jarg1, void * jarg2) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    ZeroSpreadedTermStructurePtr *result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
        return 0;
    } 
    arg2 = (Handle<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (ZeroSpreadedTermStructurePtr *)new_ZeroSpreadedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ZeroSpreadedTermStructure(void * jarg1) {
    ZeroSpreadedTermStructurePtr *arg1 = (ZeroSpreadedTermStructurePtr *) 0 ;
    
    arg1 = (ZeroSpreadedTermStructurePtr *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ForwardSpreadedTermStructure(void * jarg1, void * jarg2) {
    void * jresult ;
    Handle<YieldTermStructure > *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    ForwardSpreadedTermStructurePtr *result;
    
    arg1 = (Handle<YieldTermStructure > *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
        return 0;
    } 
    arg2 = (Handle<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (ForwardSpreadedTermStructurePtr *)new_ForwardSpreadedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ForwardSpreadedTermStructure(void * jarg1) {
    ForwardSpreadedTermStructurePtr *arg1 = (ForwardSpreadedTermStructurePtr *) 0 ;
    
    arg1 = (ForwardSpreadedTermStructurePtr *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_0(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5) {
    void * jresult ;
    Date *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    FlatForwardPtr *result;
    
    arg1 = (Date *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg2 = (Handle<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_1(void * jarg1, void * jarg2, void * jarg3, int jarg4) {
    void * jresult ;
    Date *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    FlatForwardPtr *result;
    
    arg1 = (Date *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg2 = (Handle<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_2(void * jarg1, void * jarg2, void * jarg3) {
    void * jresult ;
    Date *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    FlatForwardPtr *result;
    
    arg1 = (Date *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg2 = (Handle<Quote > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_3(void * jarg1, double jarg2, void * jarg3, int jarg4, int jarg5) {
    void * jresult ;
    Date *arg1 = 0 ;
    Rate arg2 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    FlatForwardPtr *result;
    
    arg1 = (Date *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg2 = (Rate)jarg2; 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3((Date const &)*arg1,arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_4(void * jarg1, double jarg2, void * jarg3, int jarg4) {
    void * jresult ;
    Date *arg1 = 0 ;
    Rate arg2 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    FlatForwardPtr *result;
    
    arg1 = (Date *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg2 = (Rate)jarg2; 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3((Date const &)*arg1,arg2,(DayCounter const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_5(void * jarg1, double jarg2, void * jarg3) {
    void * jresult ;
    Date *arg1 = 0 ;
    Rate arg2 ;
    DayCounter *arg3 = 0 ;
    FlatForwardPtr *result;
    
    arg1 = (Date *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
        return 0;
    } 
    arg2 = (Rate)jarg2; 
    arg3 = (DayCounter *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3((Date const &)*arg1,arg2,(DayCounter const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_6(int jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6) {
    void * jresult ;
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Handle<Quote > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    FlatForwardPtr *result;
    
    arg1 = (Integer)jarg1; 
    arg2 = (Calendar *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg3 = (Handle<Quote > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_6(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_7(int jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
    void * jresult ;
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Handle<Quote > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    FlatForwardPtr *result;
    
    arg1 = (Integer)jarg1; 
    arg2 = (Calendar *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg3 = (Handle<Quote > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_6(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_8(int jarg1, void * jarg2, void * jarg3, void * jarg4) {
    void * jresult ;
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Handle<Quote > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    FlatForwardPtr *result;
    
    arg1 = (Integer)jarg1; 
    arg2 = (Calendar *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg3 = (Handle<Quote > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_6(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_9(int jarg1, void * jarg2, double jarg3, void * jarg4, int jarg5, int jarg6) {
    void * jresult ;
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Rate arg3 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    FlatForwardPtr *result;
    
    arg1 = (Integer)jarg1; 
    arg2 = (Calendar *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg3 = (Rate)jarg3; 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_9(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_10(int jarg1, void * jarg2, double jarg3, void * jarg4, int jarg5) {
    void * jresult ;
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Rate arg3 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    FlatForwardPtr *result;
    
    arg1 = (Integer)jarg1; 
    arg2 = (Calendar *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg3 = (Rate)jarg3; 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_9(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_11(int jarg1, void * jarg2, double jarg3, void * jarg4) {
    void * jresult ;
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Rate arg3 ;
    DayCounter *arg4 = 0 ;
    FlatForwardPtr *result;
    
    arg1 = (Integer)jarg1; 
    arg2 = (Calendar *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
        return 0;
    } 
    arg3 = (Rate)jarg3; 
    arg4 = (DayCounter *)jarg4;
    if(!arg4) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_9(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_FlatForward(void * jarg1) {
    FlatForwardPtr *arg1 = (FlatForwardPtr *) 0 ;
    
    arg1 = (FlatForwardPtr *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackModel___deref__(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<BlackModel > *arg1 = (boost::shared_ptr<BlackModel > *) 0 ;
    BlackModel *result;
    
    arg1 = (boost::shared_ptr<BlackModel > *)jarg1; 
    {
        try {
            result = (BlackModel *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_BlackModel_isNull(void * jarg1) {
    unsigned int jresult ;
    boost::shared_ptr<BlackModel > *arg1 = (boost::shared_ptr<BlackModel > *) 0 ;
    bool result;
    
    arg1 = (boost::shared_ptr<BlackModel > *)jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_BlackModel_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BlackModel(void * jarg1, void * jarg2) {
    void * jresult ;
    Handle<Quote > *arg1 = 0 ;
    Handle<YieldTermStructure > *arg2 = 0 ;
    boost::shared_ptr<BlackModel > *result;
    
    arg1 = (Handle<Quote > *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    arg2 = (Handle<YieldTermStructure > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (boost::shared_ptr<BlackModel > *)new_boost_shared_ptr_Sl_BlackModel_Sg_((Handle<Quote > const &)*arg1,(Handle<YieldTermStructure > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BlackModel(void * jarg1) {
    boost::shared_ptr<BlackModel > *arg1 = (boost::shared_ptr<BlackModel > *) 0 ;
    
    arg1 = (boost::shared_ptr<BlackModel > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_PricingEngine___deref__(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<PricingEngine > *arg1 = (boost::shared_ptr<PricingEngine > *) 0 ;
    PricingEngine *result;
    
    arg1 = (boost::shared_ptr<PricingEngine > *)jarg1; 
    {
        try {
            result = (PricingEngine *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_PricingEngine_isNull(void * jarg1) {
    unsigned int jresult ;
    boost::shared_ptr<PricingEngine > *arg1 = (boost::shared_ptr<PricingEngine > *) 0 ;
    bool result;
    
    arg1 = (boost::shared_ptr<PricingEngine > *)jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_PricingEngine_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PricingEngine() {
    void * jresult ;
    boost::shared_ptr<PricingEngine > *result;
    
    {
        try {
            result = (boost::shared_ptr<PricingEngine > *)new boost::shared_ptr<PricingEngine >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_PricingEngine(void * jarg1) {
    boost::shared_ptr<PricingEngine > *arg1 = (boost::shared_ptr<PricingEngine > *) 0 ;
    
    arg1 = (boost::shared_ptr<PricingEngine > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Instrument___deref__(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    Instrument *result;
    
    arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
    {
        try {
            result = (Instrument *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Instrument_isNull(void * jarg1) {
    unsigned int jresult ;
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    bool result;
    
    arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_Instrument_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Instrument_asObservable(void * jarg1) {
    void * jresult ;
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    boost::shared_ptr<Observable > result;
    
    arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
    {
        try {
            result = boost_shared_ptr_Sl_Instrument_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_Instrument_NPV(void * jarg1) {
    double jresult ;
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    Real result;
    
    arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
    {
        try {
            result = (Real)(*arg1)->NPV();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_Instrument_errorEstimate(void * jarg1) {
    double jresult ;
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    Real result;
    
    arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
    {
        try {
            result = (Real)(*arg1)->errorEstimate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Instrument_isExpired(void * jarg1) {
    unsigned int jresult ;
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    bool result;
    
    arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
    {
        try {
            result = (bool)(*arg1)->isExpired();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Instrument_setPricingEngine(void * jarg1, void * jarg2) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    boost::shared_ptr<PricingEngine > *arg2 = 0 ;
    
    arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
    arg2 = (boost::shared_ptr<PricingEngine > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<PricingEngine > const & type is null", 0);
        return ;
    } 
    {
        try {
            (*arg1)->setPricingEngine((boost::shared_ptr<PricingEngine > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Instrument_recalculate(void * jarg1) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    
    arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
    {
        try {
            (*arg1)->recalculate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Instrument_freeze(void * jarg1) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    
    arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
    {
        try {
            (*arg1)->freeze();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Instrument_unfreeze(void * jarg1) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    
    arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
    {
        try {
            (*arg1)->unfreeze();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Instrument() {
    void * jresult ;
    boost::shared_ptr<Instrument > *result;
    
    {
        try {
            result = (boost::shared_ptr<Instrument > *)new boost::shared_ptr<Instrument >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Instrument(void * jarg1) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    
    arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Stock(void * jarg1) {
    void * jresult ;
    Handle<Quote > *arg1 = 0 ;
    StockPtr *result;
    
    arg1 = (Handle<Quote > *)jarg1;
    if(!arg1) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
        return 0;
    } 
    {
        try {
            result = (StockPtr *)new_StockPtr((Handle<Quote > const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Stock(void * jarg1) {
    StockPtr *arg1 = (StockPtr *) 0 ;
    
    arg1 = (StockPtr *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_Clear(void * jarg1) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_Add(void * jarg1, int jarg2) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int *arg2 = 0 ;
    int temp2 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    temp2 = (int)jarg2; 
    arg2 = &temp2; 
    {
        try {
            (arg1)->push_back((int const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_IntVector_size(void * jarg1) {
    unsigned long jresult ;
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    std::vector<int >::size_type result;
    
    arg1 = (std::vector<int > *)jarg1; 
    {
        try {
            result = ((std::vector<int > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_IntVector_capacity(void * jarg1) {
    unsigned long jresult ;
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    std::vector<int >::size_type result;
    
    arg1 = (std::vector<int > *)jarg1; 
    {
        try {
            result = ((std::vector<int > const *)arg1)->capacity();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_reserve(void * jarg1, unsigned long jarg2) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    std::vector<int >::size_type arg2 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    arg2 = (std::vector<int >::size_type)jarg2; 
    {
        try {
            (arg1)->reserve(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_IntVector__SWIG_0() {
    void * jresult ;
    std::vector<int > *result;
    
    {
        try {
            result = (std::vector<int > *)new std::vector<int >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_IntVector__SWIG_1(int jarg1) {
    void * jresult ;
    int arg1 ;
    std::vector<int > *result;
    
    arg1 = (int)jarg1; 
    {
        try {
            try {
                result = (std::vector<int > *)new_std_vector_Sl_int_Sg___SWIG_1(arg1);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_IntVector_getitemcopy(void * jarg1, int jarg2) {
    int jresult ;
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int result;
    
    arg1 = (std::vector<int > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = (int)std_vector_Sl_int_Sg__getitemcopy(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_IntVector_getitem(void * jarg1, int jarg2) {
    int jresult ;
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int *result;
    
    arg1 = (std::vector<int > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                {
                    int const &_result_ref = std_vector_Sl_int_Sg__getitem(arg1,arg2);
                    result = (int *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = *result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_setitem(void * jarg1, int jarg2, int jarg3) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int *arg3 = 0 ;
    int temp3 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    arg2 = (int)jarg2; 
    temp3 = (int)jarg3; 
    arg3 = &temp3; 
    {
        try {
            try {
                std_vector_Sl_int_Sg__setitem(arg1,arg2,(int const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_AddRange(void * jarg1, void * jarg2) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    std::vector<int > *arg2 = 0 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    arg2 = (std::vector<int > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<int > const & type is null", 0);
        return ;
    } 
    {
        try {
            std_vector_Sl_int_Sg__AddRange(arg1,(std::vector<int > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_IntVector_GetRange(void * jarg1, int jarg2, int jarg3) {
    void * jresult ;
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int arg3 ;
    std::vector<int > *result;
    
    arg1 = (std::vector<int > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                result = (std::vector<int > *)std_vector_Sl_int_Sg__GetRange(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_Insert(void * jarg1, int jarg2, int jarg3) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int *arg3 = 0 ;
    int temp3 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    arg2 = (int)jarg2; 
    temp3 = (int)jarg3; 
    arg3 = &temp3; 
    {
        try {
            try {
                std_vector_Sl_int_Sg__Insert(arg1,arg2,(int const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    std::vector<int > *arg3 = 0 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (std::vector<int > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<int > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_int_Sg__InsertRange(arg1,arg2,(std::vector<int > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_RemoveAt(void * jarg1, int jarg2) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                std_vector_Sl_int_Sg__RemoveAt(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_int_Sg__RemoveRange(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_IntVector_Repeat(int jarg1, int jarg2) {
    void * jresult ;
    int *arg1 = 0 ;
    int arg2 ;
    std::vector<int > *result;
    int temp1 ;
    
    temp1 = (int)jarg1; 
    arg1 = &temp1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = (std::vector<int > *)std_vector_Sl_int_Sg__Repeat((int const &)*arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_Reverse__SWIG_0(void * jarg1) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    {
        try {
            std_vector_Sl_int_Sg__Reverse__SWIG_0(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_int_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    std::vector<int > *arg3 = 0 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (std::vector<int > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<int > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_int_Sg__SetRange(arg1,arg2,(std::vector<int > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_IntVector_Contains(void * jarg1, int jarg2) {
    unsigned int jresult ;
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int *arg2 = 0 ;
    bool result;
    int temp2 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    temp2 = (int)jarg2; 
    arg2 = &temp2; 
    {
        try {
            result = (bool)std_vector_Sl_int_Sg__Contains(arg1,(int const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_IntVector_IndexOf(void * jarg1, int jarg2) {
    int jresult ;
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int *arg2 = 0 ;
    int result;
    int temp2 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    temp2 = (int)jarg2; 
    arg2 = &temp2; 
    {
        try {
            result = (int)std_vector_Sl_int_Sg__IndexOf(arg1,(int const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_IntVector_LastIndexOf(void * jarg1, int jarg2) {
    int jresult ;
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int *arg2 = 0 ;
    int result;
    int temp2 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    temp2 = (int)jarg2; 
    arg2 = &temp2; 
    {
        try {
            result = (int)std_vector_Sl_int_Sg__LastIndexOf(arg1,(int const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_Remove(void * jarg1, int jarg2) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int *arg2 = 0 ;
    int temp2 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    temp2 = (int)jarg2; 
    arg2 = &temp2; 
    {
        try {
            std_vector_Sl_int_Sg__Remove(arg1,(int const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_IntVector(void * jarg1) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    
    arg1 = (std::vector<int > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_Clear(void * jarg1) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_Add(void * jarg1, double jarg2) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    double *arg2 = 0 ;
    double temp2 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    temp2 = (double)jarg2; 
    arg2 = &temp2; 
    {
        try {
            (arg1)->push_back((double const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_DoubleVector_size(void * jarg1) {
    unsigned long jresult ;
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    std::vector<double >::size_type result;
    
    arg1 = (std::vector<double > *)jarg1; 
    {
        try {
            result = ((std::vector<double > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_DoubleVector_capacity(void * jarg1) {
    unsigned long jresult ;
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    std::vector<double >::size_type result;
    
    arg1 = (std::vector<double > *)jarg1; 
    {
        try {
            result = ((std::vector<double > const *)arg1)->capacity();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_reserve(void * jarg1, unsigned long jarg2) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    std::vector<double >::size_type arg2 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    arg2 = (std::vector<double >::size_type)jarg2; 
    {
        try {
            (arg1)->reserve(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DoubleVector__SWIG_0() {
    void * jresult ;
    std::vector<double > *result;
    
    {
        try {
            result = (std::vector<double > *)new std::vector<double >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DoubleVector__SWIG_1(int jarg1) {
    void * jresult ;
    int arg1 ;
    std::vector<double > *result;
    
    arg1 = (int)jarg1; 
    {
        try {
            try {
                result = (std::vector<double > *)new_std_vector_Sl_double_Sg___SWIG_1(arg1);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_DoubleVector_getitemcopy(void * jarg1, int jarg2) {
    double jresult ;
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    double result;
    
    arg1 = (std::vector<double > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = (double)std_vector_Sl_double_Sg__getitemcopy(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_DoubleVector_getitem(void * jarg1, int jarg2) {
    double jresult ;
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    double *result;
    
    arg1 = (std::vector<double > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                {
                    double const &_result_ref = std_vector_Sl_double_Sg__getitem(arg1,arg2);
                    result = (double *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = *result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_setitem(void * jarg1, int jarg2, double jarg3) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    double *arg3 = 0 ;
    double temp3 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    arg2 = (int)jarg2; 
    temp3 = (double)jarg3; 
    arg3 = &temp3; 
    {
        try {
            try {
                std_vector_Sl_double_Sg__setitem(arg1,arg2,(double const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_AddRange(void * jarg1, void * jarg2) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    std::vector<double > *arg2 = 0 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    arg2 = (std::vector<double > *)jarg2;
    if(!arg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<double > const & type is null", 0);
        return ;
    } 
    {
        try {
            std_vector_Sl_double_Sg__AddRange(arg1,(std::vector<double > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DoubleVector_GetRange(void * jarg1, int jarg2, int jarg3) {
    void * jresult ;
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    int arg3 ;
    std::vector<double > *result;
    
    arg1 = (std::vector<double > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                result = (std::vector<double > *)std_vector_Sl_double_Sg__GetRange(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_Insert(void * jarg1, int jarg2, double jarg3) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    double *arg3 = 0 ;
    double temp3 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    arg2 = (int)jarg2; 
    temp3 = (double)jarg3; 
    arg3 = &temp3; 
    {
        try {
            try {
                std_vector_Sl_double_Sg__Insert(arg1,arg2,(double const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    std::vector<double > *arg3 = 0 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (std::vector<double > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<double > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_double_Sg__InsertRange(arg1,arg2,(std::vector<double > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_RemoveAt(void * jarg1, int jarg2) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                std_vector_Sl_double_Sg__RemoveAt(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_double_Sg__RemoveRange(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DoubleVector_Repeat(double jarg1, int jarg2) {
    void * jresult ;
    double *arg1 = 0 ;
    int arg2 ;
    std::vector<double > *result;
    double temp1 ;
    
    temp1 = (double)jarg1; 
    arg1 = &temp1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = (std::vector<double > *)std_vector_Sl_double_Sg__Repeat((double const &)*arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_Reverse__SWIG_0(void * jarg1) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    {
        try {
            std_vector_Sl_double_Sg__Reverse__SWIG_0(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_double_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            catch(std::invalid_argument &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    std::vector<double > *arg3 = 0 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (std::vector<double > *)jarg3;
    if(!arg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<double > const & type is null", 0);
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_double_Sg__SetRange(arg1,arg2,(std::vector<double > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_DoubleVector_Contains(void * jarg1, double jarg2) {
    unsigned int jresult ;
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    double *arg2 = 0 ;
    bool result;
    double temp2 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    temp2 = (double)jarg2; 
    arg2 = &temp2; 
    {
        try {
            result = (bool)std_vector_Sl_double_Sg__Contains(arg1,(double const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_DoubleVector_IndexOf(void * jarg1, double jarg2) {
    int jresult ;
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    double *arg2 = 0 ;
    int result;
    double temp2 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    temp2 = (double)jarg2; 
    arg2 = &temp2; 
    {
        try {
            result = (int)std_vector_Sl_double_Sg__IndexOf(arg1,(double const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_DoubleVector_LastIndexOf(void * jarg1, double jarg2) {
    int jresult ;
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    double *arg2 = 0 ;
    int result;
    double temp2 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    temp2 = (double)jarg2; 
    arg2 = &temp2; 
    {
        try {
            result = (int)std_vector_Sl_double_Sg__LastIndexOf(arg1,(double const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_Remove(void * jarg1, double jarg2) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    double *arg2 = 0 ;
    double temp2 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    temp2 = (double)jarg2; 
    arg2 = &temp2; 
    {
        try {
            std_vector_Sl_double_Sg__Remove(arg1,(double const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DoubleVector(void * jarg1) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    
    arg1 = (std::vector<double > *)jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_Clear(void * jarg1) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    
    arg1 = (std::vector<std::string > *)jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_Add(void * jarg1, char * jarg2) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    std::string *arg2 = 0 ;
    
    arg1 = (std::vector<std::string > *)jarg1; 
    if (!jarg2) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
        return ;
    }
    std::string arg2_str(jarg2);
    arg2 = &arg2_str; 
    {
        try {
            (arg1)->push_back((std::string const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_StrVector_size(void * jarg1) {
    unsigned long jresult ;
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    std::vector<std::string >::size_type result;
    
    arg1 = (std::vector<std::string > *)jarg1; 
    {
        try {
            result = ((std::vector<std::string > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_StrVector_capacity(void * jarg1) {
    unsigned long jresult ;
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    std::vector<std::string >::size_type result;
    
    arg1 = (std::vector<std::string > *)jarg1; 
    {
        try {
            result = ((std::vector<std::string > const *)arg1)->capacity();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = result; 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_reserve(void * jarg1, unsigned long jarg2) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    std::vector<std::string >::size_type arg2 ;
    
    arg1 = (std::vector<std::string > *)jarg1; 
    arg2 = (std::vector<std::string >::size_type)jarg2; 
    {
        try {
            (arg1)->reserve(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_StrVector__SWIG_0() {
    void * jresult ;
    std::vector<std::string > *result;
    
    {
        try {
            result = (std::vector<std::string > *)new std::vector<std::string >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_StrVector__SWIG_1(int jarg1) {
    void * jresult ;
    int arg1 ;
    std::vector<std::string > *result;
    
    arg1 = (int)jarg1; 
    {
        try {
            try {
                result = (std::vector<std::string > *)new_std_vector_Sl_std_string_Sg___SWIG_1(arg1);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (void *)result; 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_StrVector_getitemcopy(void * jarg1, int jarg2) {
    char * jresult ;
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    int arg2 ;
    std::string result;
    
    arg1 = (std::vector<std::string > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = std_vector_Sl_std_string_Sg__getitemcopy(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback((&result)->c_str()); 
    return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_StrVector_getitem(void * jarg1, int jarg2) {
    char * jresult ;
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    int arg2 ;
    std::string *result;
    
    arg1 = (std::vector<std::string > *)jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                {
                    std::string const &_result_ref = std_vector_Sl_std_string_Sg__getitem(arg1,arg2);
                    result = (std::string *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,313,SWIG_exception@*/
            {
                SWIG_CSharpException(SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = SWIG_csharp_string_callback(result->c_str()); 
    return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_setitem(void * jarg1, int jarg2, char * jarg3) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    int arg2 ;
    std::string *arg3 = 0 ;
    
    arg1 = (std::vector<std::string > *)jarg1; 
    arg2 = (int)jarg2; 
    if (!jarg3) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
        return ;
    }
    std::str