import pwd, os, socket, select
from threading import Event
from thread import start_new_thread

CONTROLSOCK = "/tmp/qtorrent3." + pwd.getpwuid(os.getuid())[0]

class ControlSocket:
	def __init__(self, qtorrent):
		self.qtorrent = qtorrent
		self.command = None
		self.mRunFlag = Event()
		
		try:
			os.remove(CONTROLSOCK)
		except:
			pass
		
		self.socket = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
		self.socket.setblocking(1)
		self.socket.bind(CONTROLSOCK)
		self.socket.listen(1)
	
	def start(self):
		self.mRunFlag.set()
		start_new_thread(self.run, ())
	
	def stop(self):
		self.mRunFlag.clear()
	
	def join(self):
		self.stop()
		self.mRunFlag.wait()
		try:
			os.remove(CONTROLSOCK)
		except:
			pass
	
	def run(self):
		while self.mRunFlag.isSet():
			(infd, outfd, exfd) = select.select([self.socket], [], [], 0.5)
			if infd:
				sock = self.socket.accept()[0]
				command = ""
				while command[-1:] != '\n':
					data = sock.recv(8192)
					if not data:
						command = None
						break
					command = command + data
				sock.close()
				
				if command:
					self.qtorrent.add(command[:-1])
		self.mRunFlag.set()
