/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#include "mainwindow.h"

MainWindow::MainWindow(OctaveConnection *oc, QWidget *parent):QMainWindow(parent)
{
	setWindowTitle("QtOctave");
	resize(QSize(503, 418).expandedTo(minimumSizeHint()));
	this->octave_connection=oc;
	setAttribute(Qt::WA_DeleteOnClose);
	
	//Se inicializan las acciones
	
	actionOpen = new QAction(this);
	actionOpen->setIcon(QIcon(QString( ICON_PATH )+"/konsole.png"));
	actionOpen->setText(QApplication::tr("Open new QtOctave window"));
	
	actionOctave_help = new QAction(this);
	actionOctave_help->setIcon(QIcon(QString( ICON_PATH )+"/help.png"));
	actionOctave_help->setText(QApplication::tr("Octave help"));
	
	actionTable = new QAction(this);
	actionTable->setIcon(QIcon(QString( ICON_PATH )+"/table.png"));
	actionTable->setText(QApplication::tr("Table"));
	
	actionEditor= new QAction(this);
	actionEditor->setIcon(QIcon(QString( ICON_PATH )+"/xedit.png"));
	actionEditor->setText(QApplication::tr("Open editor"));
	
	actionCompletionMatches= new QAction(this);
	actionCompletionMatches->setIcon(QIcon(QString( ICON_PATH )+"/search.png"));
	actionCompletionMatches->setText(QApplication::tr("<b>Completion matches:</b><br> Generates possible completions given in comand line."));
	
	actionDynamicHelp= new QAction(this);
	actionDynamicHelp->setIcon(QIcon(QString( ICON_PATH )+"/help_index.png"));
	actionDynamicHelp->setText(QApplication::tr("<b>Dynamic Help:</b><br> Shows help of completions matches."));
	
	actionStopProcess= new QAction(this);
	actionStopProcess->setIcon(QIcon(QString( ICON_PATH )+"/button_cancel.png"));
	actionStopProcess->setText(QApplication::tr("<b>Stops process:</b><br>Stops uncontroled process, infinite loops,..."));
	
	actionClearTerminal= new QAction(this);
	actionClearTerminal->setIcon(QIcon(QString( ICON_PATH )+ "/eraser.png"));
	actionClearTerminal->setText(QApplication::tr("<b>Clear terminal:</b><br>Erase terminal screen."));
	
	actionVariableList= new QAction(this);
	actionVariableList->setIcon(QIcon(QString( ICON_PATH )+ "/taskbar.png"));
	actionVariableList->setText(QApplication::tr("<b>Variable List:</b><br>List currently defined symbols."));
	
	//Matrix actions
	
	actionInverse = new QAction(this);
	actionInverse->setText(QApplication::tr("Inverse"));
	
	actionDeterminant = new QAction(this);
	actionDeterminant->setText(QApplication::tr("Determinant"));
	
	actionEigenvalues = new QAction(this);
	actionEigenvalues->setText(QApplication::tr("Eigenvalues and eigenvectors"));
	
	actionTranspose = new QAction(this);
	actionTranspose->setText(QApplication::tr("Transpose"));
	
	actionSubmatrix = new QAction(this);
	actionSubmatrix->setText(QApplication::tr("Submatrix"));
	
	actionMean = new QAction(this);
	actionMean->setText(QApplication::tr("Mean"));
	
	actionMedian = new QAction(this);
	actionMedian->setText(QApplication::tr("Median"));
	
	actionStd = new QAction(this);
	actionStd->setText(QApplication::tr("Standard Deviation"));
	
	actionCov = new QAction(this);
	actionCov->setText(QApplication::tr("Covariance"));
	
	actionCorrcoef = new QAction(this);
	actionCorrcoef->setText(QApplication::tr("Correlation Coefficient"));
	
	//Plot actions
	
	actionPlot = new QAction(this);
	actionPlot->setText(QApplication::tr("Plot"));
	
	actionPolar = new QAction(this);
	actionPolar->setText(QApplication::tr("Polar"));
	
	actionSemilogy = new QAction(this);
	actionSemilogy->setText(QApplication::tr("Log scale for the y axis"));
	
	actionSemilogx = new QAction(this);
	actionSemilogx->setText(QApplication::tr("Log scale for the x axis"));
	
	actionLogLog = new QAction(this);
	actionLogLog->setText(QApplication::tr("Log scale for the x and y axis"));
	
	actionAxis = new QAction(this);
	actionAxis->setText(QApplication::tr("Axis scale"));
	
	actionTitleLabel = new QAction(this);
	actionTitleLabel->setText(QApplication::tr("Title and labels"));
	
	actionToEPS  = new QAction(this);
	actionToEPS->setText(QApplication::tr("EPS"));
	
	actionToPDF  = new QAction(this);
	actionToPDF->setText(QApplication::tr("PDF"));
	
	actionToPNG  = new QAction(this);
	actionToPNG->setText(QApplication::tr("PNG"));
	
	//Config actions
	actionGeneralConfig  = new QAction(this);
	actionGeneralConfig->setText(QApplication::tr("General configuration"));
	
	//Se crea el QWorkspace o �ea de trabajo
	
	work_space=new QWorkspace(this);
	work_space->setScrollBarsEnabled (true);
	work_space->show();
	setCentralWidget(work_space);
	
	//Se crean los mens
	
	menubar = new QMenuBar(this);
	//menubar->setGeometry(QRect(0, 0, 503, 29));
	
	menuFile = createMenu(QString("/File"),QApplication::tr("File")); 
	
	//menuEdit = createMenu("/Edit", QApplication::tr("Edit"));
	
	menuHelp = createMenu("/Help", QApplication::tr("Help"));
	
	menuData = createMenu("/Data", QApplication::tr("Data"));
	
	menuMatrix = createMenu("/Matrix", QApplication::tr("Matrix"));
	
	menuStatistics= createMenu("/Statistics", QApplication::tr("Statistics"));
	
	menuPlot= createMenu("/Plot", QApplication::tr("Plot"));
	
	menuExport= createMenu("/Plot/Export to...", QApplication::tr("Export to..."));
	
	menu2DPlot= createMenu("/Plot/2D...", QApplication::tr("2D..."));
	
	menuConfig= createMenu("/Config", QApplication::tr("Config"));
	
	setMenuBar(menubar);
	
	//Se crea la barra de estado
	
	statusbar = new QStatusBar(this);
	//statusbar->setGeometry(QRect(0, 396, 503, 22));
	setStatusBar(statusbar);
	
	//Se crea la barra de herramientas
	
	toolBar = new QToolBar(this);
	toolBar->setOrientation(Qt::Horizontal);
	addToolBar(static_cast<Qt::ToolBarArea>(4), toolBar);
	
	//Se construyen los mens
	
	show_menu_base();
	
	//Se a�den los elementos a la barra de herramientas
	
	toolBar->addAction(actionOpen);
	toolBar->addAction(actionEditor);
	toolBar->addAction(actionTable);
	toolBar->addAction(actionOctave_help);
	toolBar->addAction(actionDynamicHelp);
	toolBar->addAction(actionCompletionMatches);
	toolBar->addAction(actionStopProcess);
	toolBar->addAction(actionVariableList);
	toolBar->addAction(actionClearTerminal);
	
}

QAction *MainWindow::createAction(QString action_name, QString name, QString icon)
{
	return createAction(action_name, name.toLocal8Bit().data(), icon);
}

QAction *MainWindow::createAction(QString action_name, const char *name, QString icon)
{
	if( actions.contains(action_name) ) return actions[action_name];
	QAction *a = new QAction(this);
	if( !icon.isEmpty() ) a->setIcon(QIcon(icon));
	a->setText(QApplication::tr(name));
	actions[action_name]=a;
	return a;
}

QMenu *MainWindow::createMenu(QString menu_name, QString name, QString icon)
{
	return createMenu(menu_name, name.toLocal8Bit().data(), icon);
}

QMenu *MainWindow::createMenu(QString menu_name, const char *name, QString icon)
{
	if( menus.contains(menu_name) ) return menus[menu_name];
	QMenu *a = new QMenu(menubar);
	if( !icon.isEmpty() ) a->setIcon(QIcon(icon));
	a->setTitle(QApplication::tr(name));
	menus[menu_name]=a;
	return a;
}

void MainWindow::clear_menu()
{
	menubar->clear();
}

void MainWindow::show_menu_base()
{
	menubar->addAction(menuFile->menuAction());
	
	menubar->addAction(menuData->menuAction());
	
	menubar->addAction(menuMatrix->menuAction());
	menubar->addAction(menuStatistics->menuAction());
	menubar->addAction(menuPlot->menuAction());
	
	menuFile->addAction(actionOpen);
	menuFile->addAction(actionEditor);
	menuFile->addAction(createAction("cd","Change dir"));
	menuFile->addAction(createAction("exit","Exit", QString( ICON_PATH )+"/button_cancel.png"));
	
	menuData->addAction(actionTable);
	menuMatrix->addAction(createAction("+","A+B"));
	menuMatrix->addAction(createAction("*","A*B"));
	menuMatrix->addAction(createAction("**","A**n Exponential"));
	menuMatrix->addAction(actionDeterminant);
	menuMatrix->addAction(actionEigenvalues);
	menuMatrix->addAction(actionInverse);
	menuMatrix->addAction(actionTranspose);
	menuMatrix->addAction(actionSubmatrix);
	menuStatistics->addAction(actionMean);
	menuStatistics->addAction(actionMedian);
	menuStatistics->addAction(actionStd);
	menuStatistics->addAction(actionCov);
	menuStatistics->addAction(actionCorrcoef);
	menuStatistics->addAction(createAction("hist", "Histogram"));
	menuPlot->addAction(menuExport->menuAction());
	menuPlot->addAction(menu2DPlot->menuAction());
	menuPlot->addAction(createMenu("menu3DPlot","3D...")->menuAction());
	menu2DPlot->addAction(actionPlot);
	menu2DPlot->addAction(actionPolar);
	menu2DPlot->addAction(actionLogLog);
	menu2DPlot->addAction(actionSemilogy);
	menu2DPlot->addAction(actionSemilogx);
	menu2DPlot->addAction(createAction("errorbar", "Error Bars"));
	menu2DPlot->addAction(createAction("hist", "Histogram"));
	menu2DPlot->addAction(createAction("bar", "Bar graph"));
	menus.value("menu3DPlot")->addAction(createAction("mesh","Plot of three-dimensional surface"));
	menus.value("menu3DPlot")->addAction(createAction("contour","Contour plot of three-dimensional surface"));
	menuPlot->addAction(actionAxis);
	menuPlot->addAction(actionTitleLabel);
	menuExport->addAction(actionToEPS);
	menuExport->addAction(actionToPDF);
	menuExport->addAction(actionToPNG);
}

void MainWindow::show_config_help_menus()
{
	menubar->addAction(menuConfig->menuAction());
	menubar->addAction(menuHelp->menuAction());
	
	menuConfig->addAction(actionGeneralConfig);
	menuHelp->addAction(actionOctave_help);
	menuHelp->addAction(actionOctave_help);
	menuHelp->addAction(createAction("qtoctave_help","QtOctave help"));
}

