/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */


#include "main.h"
#include "window_list.h"
#include "help.h"
#include "table.h"
#include <QInputDialog>
#include <QDir>
#include "generate_menu.h"



Main::Main(QObject * parent ):QObject (parent)
{
	OctaveConnection *oc=new OctaveConnection();
	main_window=new MainWindow(oc);
	main_window->show();
	
	work_space=main_window->work_space;
	
	window_list=new WindowList(work_space,main_window->toolBar);
	main_window->toolBar->addWidget(window_list);
	window_list->setSizePolicy(QSizePolicy(QSizePolicy::Preferred,QSizePolicy::Preferred)); 
	window_list->show();
	
	terminal=new Terminal(work_space);
	terminal->work_space=work_space;
	connect(terminal, SIGNAL(widget_activated(BaseWidget *)), this, SLOT(widget_activated(BaseWidget *)));
	work_space->addWindow(terminal);
	terminal->show();
	
	connect(main_window->actionCompletionMatches, SIGNAL(triggered()), terminal, SLOT(completion_matches_callback()));
	connect(main_window->actionDynamicHelp, SIGNAL(triggered()), terminal, SLOT(dynamic_help_callback()));
	connect(main_window->actionStopProcess, SIGNAL(triggered()), terminal, SLOT(stop_process_callback()));
	connect(main_window->actionClearTerminal, SIGNAL(triggered()), terminal, SLOT(clear_callback()));
	
	connect(oc, SIGNAL(widget_activated(BaseWidget *)), this, SLOT(widget_activated(BaseWidget *)));
	//oc->setOctavePath("/usr/bin/");
	oc->setOctavePath("");
	terminal->setOctaveConnection(oc);
	oc->startOctave();
	
	operations=new Operations(this,&active_widget,main_window);
	operations->setOctaveConnection(oc);
	
	//Se construyen los mens de los ficheros
	
	GenerateMenu generate_menu(main_window, operations);
	generate_menu.setPath( CONFIG_PATH "/menus");
	generate_menu.load_menu();
	
	QString home=QDir::home().path()+"/.qtoctave/";
	
	generate_menu.setPath( QString(home+"menus") );
	generate_menu.load_menu();
	
	//generate_menu.setPath("./menus");
	//generate_menu.load_menu();
	
	main_window->show_config_help_menus();
	
	connect(main_window->actionOctave_help, SIGNAL(triggered()), this, SLOT(help_octave()));
	connect(main_window->actions.value("qtoctave_help"),  SIGNAL(triggered()), this, SLOT(help_qtoctave()));
	connect(main_window->actionTable, SIGNAL(triggered()), this, SLOT(table()));
	connect(main_window->actionOpen, SIGNAL(triggered()), this, SLOT(open()));
	connect(main_window->actionVariableList, SIGNAL(triggered()), this, SLOT(variable_list()));
}

void Main::open()
{
	Main *m;
	m=new Main;
}

void Main::widget_activated(BaseWidget *w)
{
	active_widget=w;
}

void Main::help_octave()
{
	Help *help=new Help(work_space);
	connect(help, SIGNAL(widget_activated(BaseWidget *)), this, SLOT(widget_activated(BaseWidget *)));
	work_space->addWindow(help);
	if(get_config("help_path").isEmpty()) help->setSource( HELP_PATH );
	else help->setSource(get_config("help_path"));
	help->show();
}

void Main::help_qtoctave()
{
	Help *help=new Help(work_space);
	connect(help, SIGNAL(widget_activated(BaseWidget *)), this, SLOT(widget_activated(BaseWidget *)));
	work_space->addWindow(help);
	if(get_config("qtoctave_help_path").isEmpty()) help->setSource( QTOCTAVE_HELP_PATH );
	else help->setSource(get_config("qtoctave_help_path"));
	help->setWindowTitle("QtOctave Help");
	help->show();
}

void Main::table(QString text)
{
	bool ok=true;
	if(text.isEmpty())
	{
		text = QInputDialog::getText(main_window, tr("Select table"),
			tr("Matrix name:"), QLineEdit::Normal, "", &ok);
	}
	if (ok && !text.isEmpty())
	{
		Table *table=new Table(work_space);
		connect(table, SIGNAL(widget_activated(BaseWidget *)), this, SLOT(widget_activated(BaseWidget *)));
		OctaveConnection *oc=terminal->getOctaveConnection();
		connect(work_space, SIGNAL(windowActivated(QWidget *)), table, SLOT(windowActivated(QWidget *)));
		table->setOctaveConnection(oc);
		table->setMatrix(text);
		table->setWindowTitle("Table: "+text);
		work_space->addWindow(table);
		table->show();
	}
}

void Main::variable_list()
{
	VariableList *variable_list=new VariableList(work_space);
	OctaveConnection *oc=terminal->getOctaveConnection();
	variable_list->setOctaveConnection(oc);
	work_space->addWindow(variable_list);
	connect(variable_list, SIGNAL(open_table(QString)), this, SLOT(table(QString)) );
	variable_list->show();
}


int main(int argn, char *argv[])
{
	QApplication a(argn,argv);
	//Se inicializa la configuraci�
	get_config("");
	Main m;
	return a.exec();
}
