/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#include "help.h"
#include <qaction.h>
#include <qlabel.h>
#include <qdir.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <QFile>
#include "config.h"

Help::Help( QWidget * parent):BaseWidget(parent)
{
	setWindowIcon( QIcon( QString( ICON_PATH )+"/help.png" ) );
	setWindowTitle("Help");
	vlayout=new QVBoxLayout();
	vlayout->setSpacing(0);
	vlayout->setMargin(0);
	setLayout(vlayout);
	create_buttons();
	browser=new QTextBrowser(this);
	vlayout->addWidget(browser);
	browser->show();
}


void Help::setSource(const QString source)
{
	browser->setSource(source);
	this->source=source;
}


void Help::create_buttons()
{
	toolbar = new QToolBar(this);
	toolbar->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::Minimum);
	
	QAction *_back = new QAction( QIcon( QString( ICON_PATH )+"/back.png" ), tr("&Back"), this );
	connect( _back, SIGNAL( activated() ) , this, SLOT( back() ) );
	
	toolbar->addAction(_back);
	
	QAction *_forward = new QAction(QPixmap( QString( ICON_PATH )+"/forward.png"),tr("&Forward"),this);
	connect( _forward, SIGNAL( activated() ) , this, SLOT( forward() ) );
	
	toolbar->addAction(_forward);
	
	QAction *_go_home = new QAction(QPixmap( QString( ICON_PATH )+"/gohome.png"),tr("&Go home"),this);
	connect( _go_home, SIGNAL( activated() ) , this, SLOT( go_home() ) );
	
	toolbar->addAction(_go_home);
	
	QLabel *label=new QLabel("Search: ",toolbar);
	toolbar->addWidget(label);
	label->show();
	
	lineedit=new QLineEdit(toolbar);
	toolbar->addWidget(lineedit);
	lineedit->show();
	connect(lineedit,SIGNAL(returnPressed()),this,SLOT(find()));
	
	check_box=new QCheckBox("Search in this page.", toolbar);
	toolbar->addWidget(check_box);
	check_box->show();
	
	vlayout->addWidget(toolbar);
}

void Help::back()
{
	browser->backward();
}

void Help::forward()
{
	browser->forward();
}

void Help::go_home()
{
	browser->home();
}


/**Simula un grep para el directorio dado.*/
static void grep(QString & out, QDir & path, const QString text)
{
	QStringList list=path.entryList(QStringList("*.html"));
	QByteArray target_word=text.toLocal8Bit();
	QByteArray line;
	
	for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it ) 
	{
		QString filename=path.path()+"/"+(*it);
		
		QFile in(filename);
		if(!in.open(QFile::ReadOnly)) continue;
		
		while (!in.atEnd())
		{
			line=in.readLine();
			if(line.count()>0 && line.contains(target_word))
			{
				out+="<a href=\""+filename+"\">"+filename+"</a><br>\n";
				out+=QString(line).trimmed()+QString("<br><br>\n");
				break;
			}
		}
		
		in.close();
	}
}


void Help::find()
{
	if(check_box->isChecked())
	{
		bool found = browser->find(lineedit->text());
		if(found)
		{
			browser->ensureCursorVisible();
		}
		return;
	}
	QFileInfo fileinfo(source);
	QDir path(fileinfo.absoluteDir());
	QString out("<html>Results for <b>"+QString(lineedit->text())+"</b><br><br>\n");
	grep(out,path,QString(lineedit->text()));
	out+="</html>";
	browser->setHtml(out);
}

Help::~Help ( )
{
}






