#ifndef __GENERATE_MENU_H__
#define __GENERATE_MENU_H__
#include "mainwindow.h"
#include "octave_connection.h"
#include "operations.h"
#include <QProcess>

/**This class generates new menus from dirs.
 */
class GenerateMenu:public QObject
{
	Q_OBJECT
	public:
	GenerateMenu(MainWindow *mainwindow, Operations *operations);
	/** Set path to read menus entries.
	 * @param path path to menus.
	 */
	void setPath(QString path);
	/** Load menus. Menus are read from path.
	 */
	void load_menu();
	private:
	void load_menu(QString dir_name, QMenu *parent_menu);
		
	//Directorio en el que se encuentran los mens
	QString path;
	Operations *operations;
	MainWindow *mainwindow;
	/**Parse files with .menu extension.*/
	bool process_menu_file(QString _file,  QStringList &  input_labels,  QStringList &  input_parameters, QStringList & output_labels, QStringList & output_parameters, QString & command, QString & menu_name, QString & help, bool & accept_blank_parameters);
	/**Removes path from file_path.*/
	QString menu_path(QString file_path);
	/**Finds icon for given menu.*/
	QString find_icon(QString file_path, QString menu);
};

/**Simple Callback for menus genetates using GenerateMenu. This callback is used when menu file is executable. When menu item is selected, menu file is executed and result is sent to OctaveConnection.*/
class MenuCallBack:public QObject
{
	Q_OBJECT
	public:
	MenuCallBack(QString menu_name, OctaveConnection *oc);
	private:
	QProcess process;
	QString menu_name;
	QString output;
	OctaveConnection *octave_connection;
	public slots:
	void actions_callback();
	void readyReadStandardOutput();
	void finished( int exitCode, QProcess::ExitStatus exitStatus );
};

/**Callback for ".menu" files. See QtOctave doc for ".menu" files.*/
class MenuFileCallBack: public QObject
{
	Q_OBJECT
	public:
		MenuFileCallBack(QString menu_name, OctaveConnection *oc, Operations *operations, QStringList &  input_labels,  QStringList &  input_parameters, QStringList & output_labels, QStringList & output_parameters, QString & command, QString & help, bool & accept_blank_parameters);
	private:
		Operations *operations;
		QString menu_name;
		OctaveConnection *oc;
		QStringList input_parameters, output_parameters, output_labels, input_labels;
		QString command, help;
		bool accept_blank_parameters;
	public slots:
		void actions_callback();
	
};

#endif
