#include "install.h"
#include <QFileDialog>
#include <stdio.h>
#include <QMessageBox>
#include <QTextStream>
#include <QProcess>

Install::Install(QWidget * parent):QWidget(parent)
{
	it=new InstallTool;
	it->setupUi(this);
	connect(it->install_path_pushButton,SIGNAL(released () ), this, SLOT(install_path_pushButton_cb()) );
	connect(it->bin_path_pushButton,SIGNAL(released () ), this, SLOT(bin_path_pushButton_cb()) );
	connect(it->help_path_pushButton,SIGNAL(released () ), this, SLOT(help_path_pushButton_cb()) );
	connect(it->qmake_pushButton,SIGNAL(released () ), this, SLOT(qmake_pushButton_cb()) );
	connect(it->cancel_pushButton,SIGNAL(released () ), this, SLOT(cancel_pushButton_cb()) );
	connect(it->scripts_pushButton,SIGNAL(released () ), this, SLOT(scripts_pushButton_cb()) );
	connect(it->compile_pushButton, SIGNAL(released () ), this, SLOT(compile_pushButton_cb()) );
	connect(it->compile_install_pushButton, SIGNAL(released () ), this, SLOT(compile_install_pushButton_cb()) );
}

void Install::install_path_pushButton_cb()
{

	QString s = QFileDialog::getExistingDirectory(
			this,
			"Choose a directory",
			"/home",
			QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
	
	if(s.isEmpty()) return;
	
	it->install_path_lineEdit->setText(s);
}

void Install::bin_path_pushButton_cb()
{

	QString s = QFileDialog::getExistingDirectory(
			this,
	"Choose a directory",
	"/home",
	QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
	
	if(s.isEmpty()) return;
	
	it->bin_path_lineEdit->setText(s);
}

void Install::qmake_pushButton_cb()
{

	QString s = QFileDialog::getOpenFileName(
			this,
	"Choose a file to open",
	"/home",
	"qmake (*)");
	
	if(s.isEmpty()) return;
	
	it->qmake_lineEdit->setText(s);
}

void Install::cancel_pushButton_cb()
{
	exit(0);
}


void Install::help_path_pushButton_cb()
{

	QString s = QFileDialog::getOpenFileName(
			this,
		"Choose a file to open",
		"/home",
		"Html File (*.html)");
	
	if(s.isEmpty()) return;
	
	it->help_path_lineEdit->setText(s);
}

void Install::scripts_pushButton_cb()
{
	build_scripts();
	QString make=getenv("MAKETOOL");
	QMessageBox::information (this, "Scripts builded", "Makefile has been done.\n Execute "+make+" for install.");
}

QString Install::getenv(QString var)
{
	QStringList environment = QProcess::systemEnvironment();
	for(int i=0;i<environment.size();i++)
	{
		if( environment[i].startsWith(var+"=") )
		{
			QString str(environment[i]);
			str.remove(0,var.length()+1);
			return str;
		}
	}
	return QString();
}

void Install::build_scripts()
{
	if( it->default_help_checkBox->isChecked() )
		build_scripts(it->install_path_lineEdit->text(), it->bin_path_lineEdit->text(), it->help_path_lineEdit->text());
	else
		build_scripts(it->install_path_lineEdit->text(), it->bin_path_lineEdit->text(), QString() );
}

void Install::build_scripts(QString install_path, QString bin_path, QString help_path)
{
	FILE *out=fopen("Makefile","w");
	if(out==NULL)
	{
		printf("Error: Makefile couldn't be written in disk.\n");
		if( isVisible() )
			QMessageBox::critical(this, "Error", "Error: Makefile couldn't be written in disk.\n");
		return;
	}
	
	QString qmake=it->qmake_lineEdit->text();
	QString make=getenv("MAKETOOL");
			
	QString makefile;
	
	QTextStream sout(&makefile);
	
	sout << "all:\n";
	sout << "\tcd qtoctave; " << qmake << "\n";
	sout << "\tcd qtoctave; " << make << "\n";
	sout << "\tcd widgetserver; " << qmake << "\n";
	sout << "\tcd widgetserver; " << make << "\n";
	
	sout << "install:\n";
	sout << "\tcd qtoctave; " << make << " install\n";
	sout << "\tcd widgetserver; " << make << " install\n";
	
	sout << "uninstall:\n";
	sout << "\tcd qtoctave; " << make << " uninstall\n";
	sout << "\tcd widgetserver; " << make << " uninstall\n";
	
	sout << "clean:\n";
	sout << "\tcd qtoctave; " << make << " clean\n";
	sout << "\tcd widgetserver; " << make << " clean\n";
	sout << "\tcd install-tool; " << make << " clean\n";
	
	fprintf(out,makefile.toLocal8Bit().data());
	
	fclose(out);
	
	system( ("cd qtoctave; " + qmake + " -project; cd ..").toLocal8Bit().data() );
	system( ("cd widgetserver; " + qmake + " -project; cd ..").toLocal8Bit().data() );
	
	out=fopen("qtoctave/qtoctave.pro","a");
	if(out==NULL)
	{
		printf("Error: qtoctave.pro couldn't be written in disk.\n");
		if( isVisible() )
			QMessageBox::critical(this, "Error", "Error: qtoctave.pro couldn't be written in disk.\n");
		return;
	}
	
	QString qmakefile;
	QTextStream qout(&qmakefile);
	
	
	if( it->help_path_lineEdit->text().isEmpty() )
	{
		//qout << "DEFINES+=HELP_PATH=" << install_path << "/octave_doc/octave.html" << "\n";
		qout << "octave_help.path = " << install_path << "/octave_doc/\n";
		qout << "octave_help.files = ./octave_doc/*\n";
		qout << "INSTALLS+=octave_help\n";
	}
	
	qout << "DEFINES+=USER_CONFIG\n";
	qout << "QT+=xml\n";
	
	qout << "qtoctave_help.path = " << install_path << "/qtoctave_doc/\n";
	qout << "qtoctave_help.files = ./qtoctave_doc/*\n";
	qout << "INSTALLS+=qtoctave_help\n";
	
	qout << "octave_help.path = " << install_path << "/octave_doc/\n";
	qout << "octave_help.files = ./octave_doc/*\n";
	qout << "INSTALLS+=octave_help\n";
	
	qout << "images.path = " << install_path << "/images/\n";
	qout << "images.files = ./images/*\n";
	qout << "INSTALLS+=images\n";
	
	qout << "menus.path = " << install_path << "/menus/\n";
	qout << "menus.files = ./menus/*\n";
	qout << "INSTALLS+=menus\n";
	
	qout << "configrc.path = " << install_path << "\n";
	qout << "configrc.files = config.rc\n";
	qout << "INSTALLS+=configrc\n";

	qout << "editor.path = " << install_path << "\n";
	qout << "editor.files = octave.xml autocomplete.lst\n";
	qout << "INSTALLS+=editor\n";
	
	qout << "target.path = " << bin_path << "\n";
	qout << "INSTALLS+=target\n";
	
	
	fprintf(out,qmakefile.toLocal8Bit().data());
	
	fclose(out);
	
	
	out=fopen("widgetserver/widgetserver.pro","a");
	if(out==NULL)
	{
		printf("Error: widgetserver.pro couldn't be written in disk.\n");
		if( isVisible() )
			QMessageBox::critical(this, "Error", "Error: widgetserver.pro couldn't be written in disk.\n");
		return;
	}
	
	QString wmakefile;
	QTextStream wout(&wmakefile);
	
	wout << "target.path = " << bin_path << "\n";
	wout << "INSTALLS+=target\n";
	
	fprintf(out,wmakefile.toLocal8Bit().data());
	
	fclose(out);
	
	out=fopen("qtoctave/configure.h","w");
	if(out==NULL)
	{
		printf("Error: qtoctave/configure.h couldn't be written in disk.\n");
		if( isVisible() )
			QMessageBox::critical(this, "Error", "Error: qtoctave.pro couldn't be written in disk.\n");
		return;
	}
	
	QString configureh;
	QTextStream coout(&configureh);
	
	if( ! it->install_path_lineEdit->text().isEmpty() )
	{
		coout << "#define CONFIG_PATH \"" << install_path << "\"\n";
		coout << "#define ICON_PATH \"" << install_path << "/images\"\n";
		coout << "#define QTOCTAVE_HELP_PATH \"" << install_path << "/qtoctave_doc/index.html\"\n";
	}
	if( it->default_help_checkBox->isChecked () && ! it->help_path_lineEdit->text().isEmpty() )
	{
		coout << "#define HELP_PATH \"" << help_path << "\"\n";
	}
	else
	{
		coout << "#define HELP_PATH \"" << install_path << "/octave_doc/octave.html\"" << "\n";
	}
	
	coout << "\n";
	
	fprintf(out,configureh.toLocal8Bit().data());
	
	fclose(out);
}

void Install::compile_pushButton_cb()
{
	build_scripts();
	this->hide();
	QString make=getenv("MAKETOOL");
	system( make.toLocal8Bit().data() );
	this->show();
	printf("\nCompilation ended\n");
	//QMessageBox::information (this, "Compilation finished", "Execute install.sh for install.");
}

void Install::compile_install_pushButton_cb()
{
	build_scripts();
	this->hide();
	QString make=getenv("MAKETOOL");
	system( make.toLocal8Bit().data() );
	system( (make+" install").toLocal8Bit().data() );
	this->show();
	printf("\nInstall ended\n");
	//QMessageBox::information (this, "Compilation finished", "Execute install.sh for install.");
}

