/****************************************************************************
**
** Copyright (C) 2019 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QLOCALE_DATA_P_H
#define QLOCALE_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of qapplication_*.cpp, qwidget*.cpp and qfiledialog.cpp.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/private/qglobal_p.h>

QT_BEGIN_NAMESPACE

/* This part of the file isn't generated, but written by hand since
 * Unicode CLDR doesn't contain measurement system information.
 */
struct CountryLanguage
{
    quint16 languageId;
    quint16 countryId;
    QLocale::MeasurementSystem system;
};
static const CountryLanguage ImperialMeasurementSystems[] = {
    { QLocale::English, QLocale::UnitedStates, QLocale::ImperialUSSystem },
    { QLocale::English, QLocale::UnitedStatesMinorOutlyingIslands, QLocale::ImperialUSSystem },
    { QLocale::Spanish, QLocale::UnitedStates, QLocale::ImperialUSSystem },
    { QLocale::Hawaiian, QLocale::UnitedStates, QLocale::ImperialUSSystem },
    { QLocale::English, QLocale::UnitedKingdom, QLocale::ImperialUKSystem }
};
static const int ImperialMeasurementSystemsCount =
    sizeof(ImperialMeasurementSystems)/sizeof(ImperialMeasurementSystems[0]);

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2019-10-24 from the
    Common Locale Data Repository v36

    http://www.unicode.org/cldr/

    Do not edit this section: instead regenerate it using
    cldr2qlocalexml.py and qlocalexml2cpp.py on updated (or
    edited) CLDR data; see qtbase/util/locale_database/.
*/

static const QLocaleId likely_subtags[] = {
    {   4,   0,   0 }, {   4,   7,  69 }, // aa -> aa_Latn_ET
    {   2,   0,   0 }, {   2,   2,  81 }, // ab -> ab_Cyrl_GE
    { 255,   0,   0 }, { 255,  36, 102 }, // ae -> ae_Avst_IR
    {   5,   0,   0 }, {   5,   7, 195 }, // af -> af_Latn_ZA
    { 237,   0,   0 }, { 237,   7,  37 }, // agq -> agq_Latn_CM
    { 340,   0,   0 }, { 340, 128, 100 }, // aho -> aho_Ahom_IN
    { 146,   0,   0 }, { 146,   7,  83 }, // ak -> ak_Latn_GH
    { 262,   0,   0 }, { 262,  94, 103 }, // akk -> akk_Xsux_IQ
    {   7,   0,   0 }, {   7,  14,  69 }, // am -> am_Ethi_ET
    { 261,   0,   0 }, { 261,   7, 197 }, // an -> an_Latn_ES
    {   8,   0,   0 }, {   8,   1,  64 }, // ar -> ar_Arab_EG
    { 265,   0,   0 }, { 265,  57, 102 }, // arc -> arc_Armi_IR
    { 265, 119,   0 }, { 265, 119, 109 }, // arc_Nbat -> arc_Nbat_JO
    { 265, 120,   0 }, { 265, 120, 207 }, // arc_Palm -> arc_Palm_SY
    { 315,   0,   0 }, { 315,   7,  43 }, // arn -> arn_Latn_CL
    {  10,   0,   0 }, {  10,  11, 100 }, // as -> as_Beng_IN
    { 205,   0,   0 }, { 205,   7, 210 }, // asa -> asa_Latn_TZ
    { 341,   0,   0 }, { 341, 133, 225 }, // ase -> ase_Sgnw_US
    { 256,   0,   0 }, { 256,   7, 197 }, // ast -> ast_Latn_ES
    { 216,   0,   0 }, { 216,   2, 178 }, // av -> av_Cyrl_RU
    {  11,   0,   0 }, {  11,   7,  26 }, // ay -> ay_Latn_BO
    {  12,   0,   0 }, {  12,   7,  15 }, // az -> az_Latn_AZ
    {  12,   0, 103 }, {  12,   1, 103 }, // az_IQ -> az_Arab_IQ
    {  12,   0, 102 }, {  12,   1, 102 }, // az_IR -> az_Arab_IR
    {  12,   0, 178 }, {  12,   2, 178 }, // az_RU -> az_Cyrl_RU
    {  12,   1,   0 }, {  12,   1, 102 }, // az_Arab -> az_Arab_IR
    {  13,   0,   0 }, {  13,   2, 178 }, // ba -> ba_Cyrl_RU
    { 266,   0,   0 }, { 266,   7, 101 }, // ban -> ban_Latn_ID
    { 238,   0,   0 }, { 238,   7,  37 }, // bas -> bas_Latn_CM
    { 267,   0,   0 }, { 267,  38,  37 }, // bax -> bax_Bamu_CM
    { 268,   0,   0 }, { 268,   7, 101 }, // bbc -> bbc_Latn_ID
    {  22,   0,   0 }, {  22,   2,  20 }, // be -> be_Cyrl_BY
    { 195,   0,   0 }, { 195,   7, 239 }, // bem -> bem_Latn_ZM
    { 186,   0,   0 }, { 186,   7, 210 }, // bez -> bez_Latn_TZ
    {  20,   0,   0 }, {  20,   2,  33 }, // bg -> bg_Cyrl_BG
    { 364,   0,   0 }, { 364,   1, 163 }, // bgn -> bgn_Arab_PK
    { 343,   0,   0 }, { 343,  13, 100 }, // bho -> bho_Deva_IN
    {  18,   0,   0 }, {  18,   7, 229 }, // bi -> bi_Latn_VU
    { 270,   0,   0 }, { 270,   7, 170 }, // bku -> bku_Latn_PH
    { 309,   0,   0 }, { 309, 100, 232 }, // blt -> blt_Tavt_VN
    { 188,   0,   0 }, { 188,   7, 132 }, // bm -> bm_Latn_ML
    {  15,   0,   0 }, {  15,  11,  18 }, // bn -> bn_Beng_BD
    { 121,   0,   0 }, { 121,  31,  44 }, // bo -> bo_Tibt_CN
    {  19,   0,   0 }, {  19,   7,  74 }, // br -> br_Latn_FR
    { 215,   0,   0 }, { 215,  13, 100 }, // brx -> brx_Deva_IN
    { 142,   0,   0 }, { 142,   7,  27 }, // bs -> bs_Latn_BA
    { 336,   0,   0 }, { 336, 106, 121 }, // bsq -> bsq_Bass_LR
    { 312,   0,   0 }, { 312,   7,  37 }, // bss -> bss_Latn_CM
    { 269,   0,   0 }, { 269,   7, 101 }, // bug -> bug_Latn_ID
    { 152,   0,   0 }, { 152,  14,  67 }, // byn -> byn_Ethi_ER
    {  24,   0,   0 }, {  24,   7, 197 }, // ca -> ca_Latn_ES
    { 156,   0,   0 }, { 156,   7, 157 }, // cch -> cch_Latn_NG
    { 272,   0,   0 }, { 272,  46,  18 }, // ccp -> ccp_Cakm_BD
    { 218,   0,   0 }, { 218,   2, 178 }, // ce -> ce_Cyrl_RU
    { 365,   0,   0 }, { 365,   7, 170 }, // ceb -> ceb_Latn_PH
    { 211,   0,   0 }, { 211,   7, 221 }, // cgg -> cgg_Latn_UG
    { 217,   0,   0 }, { 217,   7,  89 }, // ch -> ch_Latn_GU
    { 190,   0,   0 }, { 190,  12, 225 }, // chr -> chr_Cher_US
    { 367,   0,   0 }, { 367,   7, 225 }, // cic -> cic_Latn_US
    { 276,   0,   0 }, { 276,  47, 232 }, // cjm -> cjm_Cham_VN
    { 316,   0,   0 }, { 316,   1, 103 }, // ckb -> ckb_Arab_IQ
    {  26,   0,   0 }, {  26,   7,  74 }, // co -> co_Latn_FR
    { 274,   0,   0 }, { 274,  48,  64 }, // cop -> cop_Copt_EG
    { 221,   0,   0 }, { 221,  44,  38 }, // cr -> cr_Cans_CA
    {  28,   0,   0 }, {  28,   7,  57 }, // cs -> cs_Latn_CZ
    { 338,   0,   0 }, { 338, 121, 147 }, // ctd -> ctd_Pauc_MM
    { 219,   0,   0 }, { 219,   2, 178 }, // cu -> cu_Cyrl_RU
    { 219,  52,   0 }, { 219,  52,  33 }, // cu_Glag -> cu_Glag_BG
    { 220,   0,   0 }, { 220,   2, 178 }, // cv -> cv_Cyrl_RU
    { 134,   0,   0 }, { 134,   7, 224 }, // cy -> cy_Latn_GB
    {  29,   0,   0 }, {  29,   7,  58 }, // da -> da_Latn_DK
    { 176,   0,   0 }, { 176,   7, 111 }, // dav -> dav_Latn_KE
    {  42,   0,   0 }, {  42,   7,  82 }, // de -> de_Latn_DE
    { 239,   0,   0 }, { 239,   7, 156 }, // dje -> dje_Latn_NE
    { 275,   0,   0 }, { 275,   1, 100 }, // doi -> doi_Arab_IN
    { 317,   0,   0 }, { 317,   7,  82 }, // dsb -> dsb_Latn_DE
    { 240,   0,   0 }, { 240,   7,  37 }, // dua -> dua_Latn_CM
    { 143,   0,   0 }, { 143,  29, 131 }, // dv -> dv_Thaa_MV
    { 241,   0,   0 }, { 241,   7, 187 }, // dyo -> dyo_Latn_SN
    {  16,   0,   0 }, {  16,  31,  25 }, // dz -> dz_Tibt_BT
    { 189,   0,   0 }, { 189,   7, 111 }, // ebu -> ebu_Latn_KE
    { 161,   0,   0 }, { 161,   7,  83 }, // ee -> ee_Latn_GH
    { 263,   0,   0 }, { 263,  50,  64 }, // egy -> egy_Egyp_EG
    { 277,   0,   0 }, { 277,  63, 147 }, // eky -> eky_Kali_MM
    {  43,   0,   0 }, {  43,  16,  85 }, // el -> el_Grek_GR
    {  31,   0,   0 }, {  31,   7, 225 }, // en -> en_Latn_US
    {  31,  92,   0 }, {  31,  92, 224 }, // en_Shaw -> en_Shaw_GB
    {  32,   0,   0 }, {  32,   7, 260 }, // eo -> eo_Latn_001
    { 111,   0,   0 }, { 111,   7, 197 }, // es -> es_Latn_ES
    {  33,   0,   0 }, {  33,   7,  68 }, // et -> et_Latn_EE
    { 278,   0,   0 }, { 278,  79, 106 }, // ett -> ett_Ital_IT
    {  14,   0,   0 }, {  14,   7, 197 }, // eu -> eu_Latn_ES
    { 242,   0,   0 }, { 242,   7,  37 }, // ewo -> ewo_Latn_CM
    {  89,   0,   0 }, {  89,   1, 102 }, // fa -> fa_Arab_IR
    { 177,   0,   0 }, { 177,   7, 187 }, // ff -> ff_Latn_SN
    { 177, 134,   0 }, { 177, 134,  91 }, // ff_Adlm -> ff_Adlm_GN
    {  36,   0,   0 }, {  36,   7,  73 }, // fi -> fi_Latn_FI
    { 166,   0,   0 }, { 166,   7, 170 }, // fil -> fil_Latn_PH
    {  35,   0,   0 }, {  35,   7,  72 }, // fj -> fj_Latn_FJ
    {  34,   0,   0 }, {  34,   7,  71 }, // fo -> fo_Latn_FO
    {  37,   0,   0 }, {  37,   7,  74 }, // fr -> fr_Latn_FR
    { 159,   0,   0 }, { 159,   7, 106 }, // fur -> fur_Latn_IT
    {  38,   0,   0 }, {  38,   7, 151 }, // fy -> fy_Latn_NL
    {  57,   0,   0 }, {  57,   7, 104 }, // ga -> ga_Latn_IE
    { 148,   0,   0 }, { 148,   7,  83 }, // gaa -> gaa_Latn_GH
    {  39,   0,   0 }, {  39,   7, 224 }, // gd -> gd_Latn_GB
    { 153,   0,   0 }, { 153,  14,  69 }, // gez -> gez_Ethi_ET
    {  40,   0,   0 }, {  40,   7, 197 }, // gl -> gl_Latn_ES
    {  45,   0,   0 }, {  45,   7, 168 }, // gn -> gn_Latn_PY
    { 279,   0,   0 }, { 279,  53, 222 }, // got -> got_Goth_UA
    { 264,   0,   0 }, { 264,  49,  56 }, // grc -> grc_Cprt_CY
    { 264,  68,   0 }, { 264,  68,  85 }, // grc_Linb -> grc_Linb_GR
    { 167,   0,   0 }, { 167,   7, 206 }, // gsw -> gsw_Latn_CH
    {  46,   0,   0 }, {  46,  17, 100 }, // gu -> gu_Gujr_IN
    { 175,   0,   0 }, { 175,   7, 111 }, // guz -> guz_Latn_KE
    { 144,   0,   0 }, { 144,   7, 251 }, // gv -> gv_Latn_IM
    {  47,   0,   0 }, {  47,   7, 157 }, // ha -> ha_Latn_NG
    {  47,   0,  37 }, {  47,   1,  37 }, // ha_CM -> ha_Arab_CM
    {  47,   0, 201 }, {  47,   1, 201 }, // ha_SD -> ha_Arab_SD
    { 163,   0,   0 }, { 163,   7, 225 }, // haw -> haw_Latn_US
    {  48,   0,   0 }, {  48,  18, 105 }, // he -> he_Hebr_IL
    {  49,   0,   0 }, {  49,  13, 100 }, // hi -> hi_Deva_IN
    { 344,   0,   0 }, { 344, 129, 217 }, // hlu -> hlu_Hluw_TR
    { 282,   0,   0 }, { 282,  86,  44 }, // hmd -> hmd_Plrd_CN
    { 333,   0,   0 }, { 333, 110, 117 }, // hnj -> hnj_Hmng_LA
    { 280,   0,   0 }, { 280,   7, 170 }, // hnn -> hnn_Latn_PH
    { 224,   0,   0 }, { 224,   7, 167 }, // ho -> ho_Latn_PG
    { 334,   0,   0 }, { 334,  13, 100 }, // hoc -> hoc_Deva_IN
    {  27,   0,   0 }, {  27,   7,  54 }, // hr -> hr_Latn_HR
    { 318,   0,   0 }, { 318,   7,  82 }, // hsb -> hsb_Latn_DE
    { 222,   0,   0 }, { 222,   7,  94 }, // ht -> ht_Latn_HT
    {  50,   0,   0 }, {  50,   7,  98 }, // hu -> hu_Latn_HU
    {   9,   0,   0 }, {   9,  10,  11 }, // hy -> hy_Armn_AM
    { 223,   0,   0 }, { 223,   7, 148 }, // hz -> hz_Latn_NA
    {  53,   0,   0 }, {  53,   7, 260 }, // ia -> ia_Latn_001
    {  52,   0,   0 }, {  52,   7, 101 }, // id -> id_Latn_ID
    { 149,   0,   0 }, { 149,   7, 157 }, // ig -> ig_Latn_NG
    { 168,   0,   0 }, { 168,  34,  44 }, // ii -> ii_Yiii_CN
    {  56,   0,   0 }, {  56,   7, 225 }, // ik -> ik_Latn_US
    { 281,   0,   0 }, { 281,   2, 178 }, // inh -> inh_Cyrl_RU
    { 360,   0,   0 }, { 360,   7, 260 }, // io -> io_Latn_001
    {  51,   0,   0 }, {  51,   7,  99 }, // is -> is_Latn_IS
    {  58,   0,   0 }, {  58,   7, 106 }, // it -> it_Latn_IT
    {  55,   0,   0 }, {  55,  44,  38 }, // iu -> iu_Cans_CA
    {  59,   0,   0 }, {  59,  19, 108 }, // ja -> ja_Jpan_JP
    { 361,   0,   0 }, { 361,   7, 260 }, // jbo -> jbo_Latn_001
    { 257,   0,   0 }, { 257,   7,  37 }, // jgo -> jgo_Latn_CM
    { 200,   0,   0 }, { 200,   7, 210 }, // jmc -> jmc_Latn_TZ
    {  60,   0,   0 }, {  60,   7, 101 }, // jv -> jv_Latn_ID
    {  41,   0,   0 }, {  41,  15,  81 }, // ka -> ka_Geor_GE
    { 184,   0,   0 }, { 184,   7,   3 }, // kab -> kab_Latn_DZ
    { 158,   0,   0 }, { 158,   7, 157 }, // kaj -> kaj_Latn_NG
    { 150,   0,   0 }, { 150,   7, 111 }, // kam -> kam_Latn_KE
    { 164,   0,   0 }, { 164,   7, 157 }, // kcg -> kcg_Latn_NG
    { 192,   0,   0 }, { 192,   7, 210 }, // kde -> kde_Latn_TZ
    { 196,   0,   0 }, { 196,   7,  39 }, // kea -> kea_Latn_CV
    { 319,   0,   0 }, { 319,   7,  37 }, // ken -> ken_Latn_CM
    { 154,   0,   0 }, { 154,   7,  53 }, // kfo -> kfo_Latn_CI
    { 227,   0,   0 }, { 227,   7,  49 }, // kg -> kg_Latn_CD
    { 286,   0,   0 }, { 286,  76,  44 }, // khb -> khb_Talu_CN
    { 208,   0,   0 }, { 208,   7, 132 }, // khq -> khq_Latn_ML
    { 178,   0,   0 }, { 178,   7, 111 }, // ki -> ki_Latn_KE
    { 228,   0,   0 }, { 228,   7, 148 }, // kj -> kj_Latn_NA
    {  63,   0,   0 }, {  63,   2, 110 }, // kk -> kk_Cyrl_KZ
    {  63,   0,   1 }, {  63,   1,   1 }, // kk_AF -> kk_Arab_AF
    {  63,   0,  44 }, {  63,   1,  44 }, // kk_CN -> kk_Arab_CN
    {  63,   0, 102 }, {  63,   1, 102 }, // kk_IR -> kk_Arab_IR
    {  63,   0, 143 }, {  63,   1, 143 }, // kk_MN -> kk_Arab_MN
    {  63,   1,   0 }, {  63,   1,  44 }, // kk_Arab -> kk_Arab_CN
    { 258,   0,   0 }, { 258,   7,  37 }, // kkj -> kkj_Latn_CM
    {  44,   0,   0 }, {  44,   7,  86 }, // kl -> kl_Latn_GL
    { 198,   0,   0 }, { 198,   7, 111 }, // kln -> kln_Latn_KE
    {  23,   0,   0 }, {  23,  20,  36 }, // km -> km_Khmr_KH
    {  61,   0,   0 }, {  61,  21, 100 }, // kn -> kn_Knda_IN
    {  66,   0,   0 }, {  66,  22, 114 }, // ko -> ko_Kore_KR
    { 147,   0,   0 }, { 147,  13, 100 }, // kok -> kok_Deva_IN
    { 169,   0,   0 }, { 169,   7, 121 }, // kpe -> kpe_Latn_LR
    { 225,   0,   0 }, { 225,   7,   0 }, // kr -> kr_Latn
    {  62,   0,   0 }, {  62,   1, 100 }, // ks -> ks_Arab_IN
    { 214,   0,   0 }, { 214,   7, 210 }, // ksb -> ksb_Latn_TZ
    { 243,   0,   0 }, { 243,   7,  37 }, // ksf -> ksf_Latn_CM
    { 201,   0,   0 }, { 201,   7,  82 }, // ksh -> ksh_Latn_DE
    {  67,   0,   0 }, {  67,   7, 217 }, // ku -> ku_Latn_TR
    {  67,   0, 119 }, {  67,   1, 119 }, // ku_LB -> ku_Arab_LB
    {  67,   1,   0 }, {  67,   1, 103 }, // ku_Arab -> ku_Arab_IQ
    { 226,   0,   0 }, { 226,   2, 178 }, // kv -> kv_Cyrl_RU
    { 145,   0,   0 }, { 145,   7, 224 }, // kw -> kw_Latn_GB
    {  65,   0,   0 }, {  65,   2, 116 }, // ky -> ky_Cyrl_KG
    {  65,   0,  44 }, {  65,   1,  44 }, // ky_CN -> ky_Arab_CN
    {  65,   0, 217 }, {  65,   7, 217 }, // ky_TR -> ky_Latn_TR
    {  65,   1,   0 }, {  65,   1,  44 }, // ky_Arab -> ky_Arab_CN
    {  65,   7,   0 }, {  65,   7, 217 }, // ky_Latn -> ky_Latn_TR
    {  70,   0,   0 }, {  70,   7, 230 }, // la -> la_Latn_VA
    { 332,   0,   0 }, { 332, 112,  85 }, // lab -> lab_Lina_GR
    { 193,   0,   0 }, { 193,   7, 210 }, // lag -> lag_Latn_TZ
    { 231,   0,   0 }, { 231,   7, 125 }, // lb -> lb_Latn_LU
    { 283,   0,   0 }, { 283,  66, 100 }, // lep -> lep_Lepc_IN
    { 335,   0,   0 }, { 335,   2, 178 }, // lez -> lez_Cyrl_RU
    { 194,   0,   0 }, { 194,   7, 221 }, // lg -> lg_Latn_UG
    { 229,   0,   0 }, { 229,   7, 151 }, // li -> li_Latn_NL
    { 284,   0,   0 }, { 284,  13, 150 }, // lif -> lif_Deva_NP
    { 284,  67,   0 }, { 284,  67, 100 }, // lif_Limb -> lif_Limb_IN
    { 285,   0,   0 }, { 285,  51,  44 }, // lis -> lis_Lisu_CN
    { 313,   0,   0 }, { 313,   7, 225 }, // lkt -> lkt_Latn_US
    {  72,   0,   0 }, {  72,   7,  49 }, // ln -> ln_Latn_CD
    {  69,   0,   0 }, {  69,  23, 117 }, // lo -> lo_Laoo_LA
    { 349,   0,   0 }, { 349,   1, 102 }, // lrc -> lrc_Arab_IR
    {  73,   0,   0 }, {  73,   7, 124 }, // lt -> lt_Latn_LT
    { 230,   0,   0 }, { 230,   7,  49 }, // lu -> lu_Latn_CD
    { 210,   0,   0 }, { 210,   7, 111 }, // luo -> luo_Latn_KE
    { 204,   0,   0 }, { 204,   7, 111 }, // luy -> luy_Latn_KE
    {  71,   0,   0 }, {  71,   7, 118 }, // lv -> lv_Latn_LV
    { 345,   0,   0 }, { 345,   5,  44 }, // lzh -> lzh_Hans_CN
    { 339,   0,   0 }, { 339,  13, 100 }, // mai -> mai_Deva_IN
    { 289,   0,   0 }, { 289,   7,  80 }, // man -> man_Latn_GM
    { 289,   0,  91 }, { 289,  75,  91 }, // man_GN -> man_Nkoo_GN
    { 289,  75,   0 }, { 289,  75,  91 }, // man_Nkoo -> man_Nkoo_GN
    { 202,   0,   0 }, { 202,   7, 111 }, // mas -> mas_Latn_KE
    { 330,   0,   0 }, { 330,   7, 189 }, // men -> men_Latn_SL
    { 197,   0,   0 }, { 197,   7, 111 }, // mer -> mer_Latn_KE
    { 191,   0,   0 }, { 191,   7, 137 }, // mfe -> mfe_Latn_MU
    {  75,   0,   0 }, {  75,   7, 128 }, // mg -> mg_Latn_MG
    { 244,   0,   0 }, { 244,   7, 146 }, // mgh -> mgh_Latn_MZ
    { 259,   0,   0 }, { 259,   7,  37 }, // mgo -> mgo_Latn_CM
    {  81,   0,   0 }, {  81,   7, 134 }, // mh -> mh_Latn_MH
    {  79,   0,   0 }, {  79,   7, 154 }, // mi -> mi_Latn_NZ
    { 356,   0,   0 }, { 356, 130, 103 }, // mis -> mis_Hatr_IQ
    {  74,   0,   0 }, {  74,   2, 127 }, // mk -> mk_Cyrl_MK
    {  77,   0,   0 }, {  77,  24, 100 }, // ml -> ml_Mlym_IN
    {  82,   0,   0 }, {  82,   2, 143 }, // mn -> mn_Cyrl_MN
    {  82,   0,  44 }, {  82,   8,  44 }, // mn_CN -> mn_Mong_CN
    {  82,   8,   0 }, {  82,   8,  44 }, // mn_Mong -> mn_Mong_CN
    { 290,   0,   0 }, { 290,  11, 100 }, // mni -> mni_Beng_IN
    { 320,   0,   0 }, { 320,   7,  38 }, // moh -> moh_Latn_CA
    {  80,   0,   0 }, {  80,  13, 100 }, // mr -> mr_Deva_IN
    { 347,   0,   0 }, { 347, 117,  18 }, // mro -> mro_Mroo_BD
    {  76,   0,   0 }, {  76,   7, 130 }, // ms -> ms_Latn_MY
    {  76,   0,  46 }, {  76,   1,  46 }, // ms_CC -> ms_Arab_CC
    {  76,   0, 101 }, {  76,   1, 101 }, // ms_ID -> ms_Arab_ID
    {  78,   0,   0 }, {  78,   7, 133 }, // mt -> mt_Latn_MT
    { 245,   0,   0 }, { 245,   7,  37 }, // mua -> mua_Latn_CM
    { 368,   0,   0 }, { 368,   7, 225 }, // mus -> mus_Latn_US
    {  21,   0,   0 }, {  21,  25, 147 }, // my -> my_Mymr_MM
    { 366,   0,   0 }, { 366,   2, 178 }, // myv -> myv_Cyrl_RU
    { 273,   0,   0 }, { 273,  71, 102 }, // myz -> myz_Mand_IR
    { 346,   0,   0 }, { 346,   1, 102 }, // mzn -> mzn_Arab_IR
    {  83,   0,   0 }, {  83,   7, 149 }, // na -> na_Latn_NR
    { 199,   0,   0 }, { 199,   7, 148 }, // naq -> naq_Latn_NA
    {  85,   0,   0 }, {  85,   7, 161 }, // nb -> nb_Latn_NO
    { 181,   0,   0 }, { 181,   7, 240 }, // nd -> nd_Latn_ZW
    { 170,   0,   0 }, { 170,   7,  82 }, // nds -> nds_Latn_DE
    {  84,   0,   0 }, {  84,  13, 150 }, // ne -> ne_Deva_NP
    { 348,   0,   0 }, { 348,  13, 150 }, // new -> new_Deva_NP
    { 233,   0,   0 }, { 233,   7, 148 }, // ng -> ng_Latn_NA
    {  30,   0,   0 }, {  30,   7, 151 }, // nl -> nl_Latn_NL
    { 246,   0,   0 }, { 246,   7,  37 }, // nmg -> nmg_Latn_CM
    { 141,   0,   0 }, { 141,   7, 161 }, // nn -> nn_Latn_NO
    { 260,   0,   0 }, { 260,   7,  37 }, // nnh -> nnh_Latn_CM
    { 292,   0,   0 }, { 292,  65, 211 }, // nod -> nod_Lana_TH
    { 294,   0,   0 }, { 294,  88, 205 }, // non -> non_Runr_SE
    { 321,   0,   0 }, { 321,  75,  91 }, // nqo -> nqo_Nkoo_GN
    { 171,   0,   0 }, { 171,   7, 195 }, // nr -> nr_Latn_ZA
    { 172,   0,   0 }, { 172,   7, 195 }, // nso -> nso_Latn_ZA
    { 247,   0,   0 }, { 247,   7, 254 }, // nus -> nus_Latn_SS
    { 232,   0,   0 }, { 232,   7, 225 }, // nv -> nv_Latn_US
    { 165,   0,   0 }, { 165,   7, 129 }, // ny -> ny_Latn_MW
    { 185,   0,   0 }, { 185,   7, 221 }, // nyn -> nyn_Latn_UG
    {  86,   0,   0 }, {  86,   7,  74 }, // oc -> oc_Latn_FR
    {   3,   0,   0 }, {   3,   7,  69 }, // om -> om_Latn_ET
    {  87,   0,   0 }, {  87,  26, 100 }, // or -> or_Orya_IN
    { 101,   0,   0 }, { 101,   2,  81 }, // os -> os_Cyrl_GE
    { 358,   0,   0 }, { 358, 138, 225 }, // osa -> osa_Osge_US
    { 296,   0,   0 }, { 296,  82, 143 }, // otk -> otk_Orkh_MN
    {  92,   0,   0 }, {  92,   4, 100 }, // pa -> pa_Guru_IN
    {  92,   0, 163 }, {  92,   1, 163 }, // pa_PK -> pa_Arab_PK
    {  92,   1,   0 }, {  92,   1, 163 }, // pa_Arab -> pa_Arab_PK
    { 297,   0,   0 }, { 297,  58, 102 }, // pal -> pal_Phli_IR
    { 297, 123,   0 }, { 297, 123,  44 }, // pal_Phlp -> pal_Phlp_CN
    { 351,   0,   0 }, { 351,   7,  12 }, // pap -> pap_Latn_AW
    { 350,   0,   0 }, { 350,   7, 164 }, // pau -> pau_Latn_PW
    { 295,   0,   0 }, { 295,  80, 102 }, // peo -> peo_Xpeo_IR
    { 299,   0,   0 }, { 299,  85, 119 }, // phn -> phn_Phnx_LB
    { 342,   0,   0 }, { 342,  41, 100 }, // pka -> pka_Brah_IN
    {  90,   0,   0 }, {  90,   7, 172 }, // pl -> pl_Latn_PL
    { 300,   0,   0 }, { 300,  64, 163 }, // pra -> pra_Khar_PK
    { 322,   0,   0 }, { 322,   7, 260 }, // prg -> prg_Latn_001
    {  88,   0,   0 }, {  88,   1,   1 }, // ps -> ps_Arab_AF
    {  91,   0,   0 }, {  91,   7,  30 }, // pt -> pt_Latn_BR
    {  93,   0,   0 }, {  93,   7, 169 }, // qu -> qu_Latn_PE
    { 323,   0,   0 }, { 323,   7,  90 }, // quc -> quc_Latn_GT
    { 301,   0,   0 }, { 301,   7, 101 }, // rej -> rej_Latn_ID
    {  94,   0,   0 }, {  94,   7, 206 }, // rm -> rm_Latn_CH
    {  68,   0,   0 }, {  68,   7,  35 }, // rn -> rn_Latn_BI
    {  95,   0,   0 }, {  95,   7, 177 }, // ro -> ro_Latn_RO
    { 182,   0,   0 }, { 182,   7, 210 }, // rof -> rof_Latn_TZ
    {  96,   0,   0 }, {  96,   2, 178 }, // ru -> ru_Cyrl_RU
    {  64,   0,   0 }, {  64,   7, 179 }, // rw -> rw_Latn_RW
    { 209,   0,   0 }, { 209,   7, 210 }, // rwk -> rwk_Latn_TZ
    {  99,   0,   0 }, {  99,  13, 100 }, // sa -> sa_Deva_IN
    { 248,   0,   0 }, { 248,   2, 178 }, // sah -> sah_Cyrl_RU
    { 179,   0,   0 }, { 179,   7, 111 }, // saq -> saq_Latn_KE
    { 304,   0,   0 }, { 304,   7, 100 }, // sat -> sat_Latn_IN
    { 305,   0,   0 }, { 305,  90, 100 }, // saz -> saz_Saur_IN
    { 249,   0,   0 }, { 249,   7, 210 }, // sbp -> sbp_Latn_TZ
    { 115,   0,   0 }, { 115,   7, 106 }, // sc -> sc_Latn_IT
    { 362,   0,   0 }, { 362,   7, 106 }, // scn -> scn_Latn_IT
    { 105,   0,   0 }, { 105,   1, 163 }, // sd -> sd_Arab_PK
    { 105,  13,   0 }, { 105,  13, 100 }, // sd_Deva -> sd_Deva_IN
    { 105, 111,   0 }, { 105, 111, 100 }, // sd_Khoj -> sd_Khoj_IN
    { 105, 125,   0 }, { 105, 125, 100 }, // sd_Sind -> sd_Sind_IN
    { 363,   0,   0 }, { 363,   1, 102 }, // sdh -> sdh_Arab_IR
    { 173,   0,   0 }, { 173,   7, 161 }, // se -> se_Latn_NO
    { 180,   0,   0 }, { 180,   7, 146 }, // seh -> seh_Latn_MZ
    { 213,   0,   0 }, { 213,   7, 132 }, // ses -> ses_Latn_ML
    {  98,   0,   0 }, {  98,   7,  41 }, // sg -> sg_Latn_CF
    { 293,   0,   0 }, { 293,  77, 104 }, // sga -> sga_Ogam_IE
    { 183,   0,   0 }, { 183,   9, 145 }, // shi -> shi_Tfng_MA
    { 106,   0,   0 }, { 106,  32, 198 }, // si -> si_Sinh_LK
    { 155,   0,   0 }, { 155,   7,  69 }, // sid -> sid_Latn_ET
    { 108,   0,   0 }, { 108,   7, 191 }, // sk -> sk_Latn_SK
    { 352,   0,   0 }, { 352,   1, 163 }, // skr -> skr_Arab_PK
    { 109,   0,   0 }, { 109,   7, 192 }, // sl -> sl_Latn_SI
    {  97,   0,   0 }, {  97,   7, 183 }, // sm -> sm_Latn_WS
    { 324,   0,   0 }, { 324,   7, 205 }, // sma -> sma_Latn_SE
    { 325,   0,   0 }, { 325,   7, 205 }, // smj -> smj_Latn_SE
    { 326,   0,   0 }, { 326,   7,  73 }, // smn -> smn_Latn_FI
    { 303,   0,   0 }, { 303,  89, 105 }, // smp -> smp_Samr_IL
    { 327,   0,   0 }, { 327,   7,  73 }, // sms -> sms_Latn_FI
    { 104,   0,   0 }, { 104,   7, 240 }, // sn -> sn_Latn_ZW
    { 110,   0,   0 }, { 110,   7, 194 }, // so -> so_Latn_SO
    {   6,   0,   0 }, {   6,   7,   2 }, // sq -> sq_Latn_AL
    { 100,   0,   0 }, { 100,   2, 243 }, // sr -> sr_Cyrl_RS
    { 100,   0, 242 }, { 100,   7, 242 }, // sr_ME -> sr_Latn_ME
    { 100,   0, 177 }, { 100,   7, 177 }, // sr_RO -> sr_Latn_RO
    { 100,   0, 178 }, { 100,   7, 178 }, // sr_RU -> sr_Latn_RU
    { 100,   0, 217 }, { 100,   7, 217 }, // sr_TR -> sr_Latn_TR
    { 306,   0,   0 }, { 306,  93, 100 }, // srb -> srb_Sora_IN
    { 107,   0,   0 }, { 107,   7, 195 }, // ss -> ss_Latn_ZA
    { 207,   0,   0 }, { 207,   7,  67 }, // ssy -> ssy_Latn_ER
    { 102,   0,   0 }, { 102,   7, 195 }, // st -> st_Latn_ZA
    { 112,   0,   0 }, { 112,   7, 101 }, // su -> su_Latn_ID
    { 114,   0,   0 }, { 114,   7, 205 }, // sv -> sv_Latn_SE
    { 113,   0,   0 }, { 113,   7, 210 }, // sw -> sw_Latn_TZ
    { 250,   0,   0 }, { 250,   7,  49 }, // swc -> swc_Latn_CD
    { 307,   0,   0 }, { 307,  11,  18 }, // syl -> syl_Beng_BD
    { 151,   0,   0 }, { 151,  33, 103 }, // syr -> syr_Syrc_IQ
    { 369,   0,   0 }, { 369,   7, 172 }, // szl -> szl_Latn_PL
    { 117,   0,   0 }, { 117,  27, 100 }, // ta -> ta_Taml_IN
    { 308,   0,   0 }, { 308,   7, 170 }, // tbw -> tbw_Latn_PH
    { 310,   0,   0 }, { 310,  99,  44 }, // tdd -> tdd_Tale_CN
    { 119,   0,   0 }, { 119,  28, 100 }, // te -> te_Telu_IN
    { 206,   0,   0 }, { 206,   7, 221 }, // teo -> teo_Latn_UG
    { 116,   0,   0 }, { 116,   2, 209 }, // tg -> tg_Cyrl_TJ
    { 116,   0, 163 }, { 116,   1, 163 }, // tg_PK -> tg_Arab_PK
    { 116,   1,   0 }, { 116,   1, 163 }, // tg_Arab -> tg_Arab_PK
    { 120,   0,   0 }, { 120,  30, 211 }, // th -> th_Thai_TH
    { 122,   0,   0 }, { 122,  14,  69 }, // ti -> ti_Ethi_ET
    { 157,   0,   0 }, { 157,  14,  67 }, // tig -> tig_Ethi_ER
    { 126,   0,   0 }, { 126,   7, 218 }, // tk -> tk_Latn_TM
    { 353,   0,   0 }, { 353,   7, 213 }, // tkl -> tkl_Latn_TK
    { 103,   0,   0 }, { 103,   7, 195 }, // tn -> tn_Latn_ZA
    { 123,   0,   0 }, { 123,   7, 214 }, // to -> to_Latn_TO
    { 354,   0,   0 }, { 354,   7, 167 }, // tpi -> tpi_Latn_PG
    { 125,   0,   0 }, { 125,   7, 217 }, // tr -> tr_Latn_TR
    { 174,   0,   0 }, { 174,   7, 208 }, // trv -> trv_Latn_TW
    { 124,   0,   0 }, { 124,   7, 195 }, // ts -> ts_Latn_ZA
    { 118,   0,   0 }, { 118,   2, 178 }, // tt -> tt_Cyrl_RU
    { 355,   0,   0 }, { 355,   7, 220 }, // tvl -> tvl_Latn_TV
    { 251,   0,   0 }, { 251,   7, 156 }, // twq -> twq_Latn_NE
    { 359,   0,   0 }, { 359, 139,  44 }, // txg -> txg_Tang_CN
    { 127,   0,   0 }, { 127,   7,  77 }, // ty -> ty_Latn_PF
    { 212,   0,   0 }, { 212,   7, 145 }, // tzm -> tzm_Latn_MA
    { 128,   0,   0 }, { 128,   1,  44 }, // ug -> ug_Arab_CN
    { 128,   0, 110 }, { 128,   2, 110 }, // ug_KZ -> ug_Cyrl_KZ
    { 128,   0, 143 }, { 128,   2, 143 }, // ug_MN -> ug_Cyrl_MN
    { 128,   2,   0 }, { 128,   2, 110 }, // ug_Cyrl -> ug_Cyrl_KZ
    { 311,   0,   0 }, { 311, 102, 207 }, // uga -> uga_Ugar_SY
    { 129,   0,   0 }, { 129,   2, 222 }, // uk -> uk_Cyrl_UA
    { 130,   0,   0 }, { 130,   1, 163 }, // ur -> ur_Arab_PK
    { 131,   0,   0 }, { 131,   7, 228 }, // uz -> uz_Latn_UZ
    { 131,   0,   1 }, { 131,   1,   1 }, // uz_AF -> uz_Arab_AF
    { 131,   0,  44 }, { 131,   2,  44 }, // uz_CN -> uz_Cyrl_CN
    { 131,   1,   0 }, { 131,   1,   1 }, // uz_Arab -> uz_Arab_AF
    { 252,   0,   0 }, { 252,  35, 121 }, // vai -> vai_Vaii_LR
    { 160,   0,   0 }, { 160,   7, 195 }, // ve -> ve_Latn_ZA
    { 132,   0,   0 }, { 132,   7, 232 }, // vi -> vi_Latn_VN
    { 133,   0,   0 }, { 133,   7, 260 }, // vo -> vo_Latn_001
    { 187,   0,   0 }, { 187,   7, 210 }, // vun -> vun_Latn_TZ
    { 236,   0,   0 }, { 236,   7,  21 }, // wa -> wa_Latn_BE
    { 253,   0,   0 }, { 253,   7, 206 }, // wae -> wae_Latn_CH
    { 162,   0,   0 }, { 162,  14,  69 }, // wal -> wal_Ethi_ET
    { 328,   0,   0 }, { 328,   7,  13 }, // wbp -> wbp_Latn_AU
    { 135,   0,   0 }, { 135,   7, 187 }, // wo -> wo_Latn_SN
    { 271,   0,   0 }, { 271,  45, 217 }, // xcr -> xcr_Cari_TR
    { 136,   0,   0 }, { 136,   7, 195 }, // xh -> xh_Latn_ZA
    { 287,   0,   0 }, { 287,  69, 217 }, // xlc -> xlc_Lyci_TR
    { 288,   0,   0 }, { 288,  70, 217 }, // xld -> xld_Lydi_TR
    { 329,   0,   0 }, { 329, 114,  44 }, // xmn -> xmn_Mani_CN
    { 291,   0,   0 }, { 291,  74, 201 }, // xmr -> xmr_Merc_SD
    { 331,   0,   0 }, { 331, 118, 186 }, // xna -> xna_Narb_SA
    { 203,   0,   0 }, { 203,   7, 221 }, // xog -> xog_Latn_UG
    { 298,   0,   0 }, { 298,  59, 102 }, // xpr -> xpr_Prti_IR
    { 302,   0,   0 }, { 302,  81, 237 }, // xsa -> xsa_Sarb_YE
    { 254,   0,   0 }, { 254,   7,  37 }, // yav -> yav_Latn_CM
    { 137,   0,   0 }, { 137,  18, 260 }, // yi -> yi_Hebr_001
    { 138,   0,   0 }, { 138,   7, 157 }, // yo -> yo_Latn_NG
    { 357,   0,   0 }, { 357,   6,  97 }, // yue -> yue_Hant_HK
    { 357,   0,  44 }, { 357,   5,  44 }, // yue_CN -> yue_Hans_CN
    { 357,   5,   0 }, { 357,   5,  44 }, // yue_Hans -> yue_Hans_CN
    { 139,   0,   0 }, { 139,   7,  44 }, // za -> za_Latn_CN
    { 314,   0,   0 }, { 314,   9, 145 }, // zgh -> zgh_Tfng_MA
    {  25,   0,   0 }, {  25,   5,  44 }, // zh -> zh_Hans_CN
    {  25,   0,  13 }, {  25,   6,  13 }, // zh_AU -> zh_Hant_AU
    {  25,   0,  32 }, {  25,   6,  32 }, // zh_BN -> zh_Hant_BN
    {  25,   0, 224 }, {  25,   6, 224 }, // zh_GB -> zh_Hant_GB
    {  25,   0,  76 }, {  25,   6,  76 }, // zh_GF -> zh_Hant_GF
    {  25,   0,  97 }, {  25,   6,  97 }, // zh_HK -> zh_Hant_HK
    {  25,   0, 101 }, {  25,   6, 101 }, // zh_ID -> zh_Hant_ID
    {  25,   0, 126 }, {  25,   6, 126 }, // zh_MO -> zh_Hant_MO
    {  25,   0, 130 }, {  25,   6, 130 }, // zh_MY -> zh_Hant_MY
    {  25,   0, 166 }, {  25,   6, 166 }, // zh_PA -> zh_Hant_PA
    {  25,   0,  77 }, {  25,   6,  77 }, // zh_PF -> zh_Hant_PF
    {  25,   0, 170 }, {  25,   6, 170 }, // zh_PH -> zh_Hant_PH
    {  25,   0, 202 }, {  25,   6, 202 }, // zh_SR -> zh_Hant_SR
    {  25,   0, 211 }, {  25,   6, 211 }, // zh_TH -> zh_Hant_TH
    {  25,   0, 208 }, {  25,   6, 208 }, // zh_TW -> zh_Hant_TW
    {  25,   0, 225 }, {  25,   6, 225 }, // zh_US -> zh_Hant_US
    {  25,   0, 232 }, {  25,   6, 232 }, // zh_VN -> zh_Hant_VN
    {  25,  40,   0 }, {  25,  40, 208 }, // zh_Bopo -> zh_Bopo_TW
    {  25, 140,   0 }, {  25, 140, 208 }, // zh_Hanb -> zh_Hanb_TW
    {  25,   6,   0 }, {  25,   6, 208 }, // zh_Hant -> zh_Hant_TW
    { 140,   0,   0 }, { 140,   7, 195 }, // zu -> zu_Latn_ZA
    {   0,   0, 261 }, {  96,   2, 178 }, // und_150 -> ru_Cyrl_RU
    {   0,   0, 246 }, { 111,   7, 246 }, // und_419 -> es_Latn_419
    {   0,   0,   5 }, {  24,   7,   5 }, // und_AD -> ca_Latn_AD
    {   0,   0, 223 }, {   8,   1, 223 }, // und_AE -> ar_Arab_AE
    {   0,   0,   1 }, {  89,   1,   1 }, // und_AF -> fa_Arab_AF
    {   0,   0,   2 }, {   6,   7,   2 }, // und_AL -> sq_Latn_AL
    {   0,   0,  11 }, {   9,  10,  11 }, // und_AM -> hy_Armn_AM
    {   0,   0,   6 }, {  91,   7,   6 }, // und_AO -> pt_Latn_AO
    {   0,   0,   8 }, {   0,   7,   8 }, // und_AQ -> und_Latn_AQ
    {   0,   0,  10 }, { 111,   7,  10 }, // und_AR -> es_Latn_AR
    {   0,   0,   4 }, {  97,   7,   4 }, // und_AS -> sm_Latn_AS
    {   0,   0,  14 }, {  42,   7,  14 }, // und_AT -> de_Latn_AT
    {   0,   0,  12 }, {  30,   7,  12 }, // und_AW -> nl_Latn_AW
    {   0,   0, 248 }, { 114,   7, 248 }, // und_AX -> sv_Latn_AX
    {   0,   0,  15 }, {  12,   7,  15 }, // und_AZ -> az_Latn_AZ
    {   0,   0,  27 }, { 142,   7,  27 }, // und_BA -> bs_Latn_BA
    {   0,   0,  18 }, {  15,  11,  18 }, // und_BD -> bn_Beng_BD
    {   0,   0,  21 }, {  30,   7,  21 }, // und_BE -> nl_Latn_BE
    {   0,   0,  34 }, {  37,   7,  34 }, // und_BF -> fr_Latn_BF
    {   0,   0,  33 }, {  20,   2,  33 }, // und_BG -> bg_Cyrl_BG
    {   0,   0,  17 }, {   8,   1,  17 }, // und_BH -> ar_Arab_BH
    {   0,   0,  35 }, {  68,   7,  35 }, // und_BI -> rn_Latn_BI
    {   0,   0,  23 }, {  37,   7,  23 }, // und_BJ -> fr_Latn_BJ
    {   0,   0, 244 }, {  37,   7, 244 }, // und_BL -> fr_Latn_BL
    {   0,   0,  32 }, {  76,   7,  32 }, // und_BN -> ms_Latn_BN
    {   0,   0,  26 }, { 111,   7,  26 }, // und_BO -> es_Latn_BO
    {   0,   0, 255 }, { 351,   7, 255 }, // und_BQ -> pap_Latn_BQ
    {   0,   0,  30 }, {  91,   7,  30 }, // und_BR -> pt_Latn_BR
    {   0,   0,  25 }, {  16,  31,  25 }, // und_BT -> dz_Tibt_BT
    {   0,   0,  29 }, {   0,   7,  29 }, // und_BV -> und_Latn_BV
    {   0,   0,  20 }, {  22,   2,  20 }, // und_BY -> be_Cyrl_BY
    {   0,   0,  49 }, { 113,   7,  49 }, // und_CD -> sw_Latn_CD
    {   0,   0,  41 }, {  37,   7,  41 }, // und_CF -> fr_Latn_CF
    {   0,   0,  50 }, {  37,   7,  50 }, // und_CG -> fr_Latn_CG
    {   0,   0, 206 }, {  42,   7, 206 }, // und_CH -> de_Latn_CH
    {   0,   0,  53 }, {  37,   7,  53 }, // und_CI -> fr_Latn_CI
    {   0,   0,  43 }, { 111,   7,  43 }, // und_CL -> es_Latn_CL
    {   0,   0,  37 }, {  37,   7,  37 }, // und_CM -> fr_Latn_CM
    {   0,   0,  44 }, {  25,   5,  44 }, // und_CN -> zh_Hans_CN
    {   0,   0,  47 }, { 111,   7,  47 }, // und_CO -> es_Latn_CO
    {   0,   0, 241 }, {   0,   7, 241 }, // und_CP -> und_Latn_CP
    {   0,   0,  52 }, { 111,   7,  52 }, // und_CR -> es_Latn_CR
    {   0,   0,  55 }, { 111,   7,  55 }, // und_CU -> es_Latn_CU
    {   0,   0,  39 }, {  91,   7,  39 }, // und_CV -> pt_Latn_CV
    {   0,   0, 152 }, { 351,   7, 152 }, // und_CW -> pap_Latn_CW
    {   0,   0,  56 }, {  43,  16,  56 }, // und_CY -> el_Grek_CY
    {   0,   0,  57 }, {  28,   7,  57 }, // und_CZ -> cs_Latn_CZ
    {   0,   0,  82 }, {  42,   7,  82 }, // und_DE -> de_Latn_DE
    {   0,   0,  59 }, {   4,   7,  59 }, // und_DJ -> aa_Latn_DJ
    {   0,   0,  58 }, {  29,   7,  58 }, // und_DK -> da_Latn_DK
    {   0,   0,  61 }, { 111,   7,  61 }, // und_DO -> es_Latn_DO
    {   0,   0,   3 }, {   8,   1,   3 }, // und_DZ -> ar_Arab_DZ
    {   0,   0, 250 }, { 111,   7, 250 }, // und_EA -> es_Latn_EA
    {   0,   0,  63 }, { 111,   7,  63 }, // und_EC -> es_Latn_EC
    {   0,   0,  68 }, {  33,   7,  68 }, // und_EE -> et_Latn_EE
    {   0,   0,  64 }, {   8,   1,  64 }, // und_EG -> ar_Arab_EG
    {   0,   0, 236 }, {   8,   1, 236 }, // und_EH -> ar_Arab_EH
    {   0,   0,  67 }, { 122,  14,  67 }, // und_ER -> ti_Ethi_ER
    {   0,   0, 197 }, { 111,   7, 197 }, // und_ES -> es_Latn_ES
    {   0,   0,  69 }, {   7,  14,  69 }, // und_ET -> am_Ethi_ET
    {   0,   0, 258 }, {  31,   7, 224 }, // und_EU -> en_Latn_GB
    {   0,   0,  73 }, {  36,   7,  73 }, // und_FI -> fi_Latn_FI
    {   0,   0,  71 }, {  34,   7,  71 }, // und_FO -> fo_Latn_FO
    {   0,   0,  74 }, {  37,   7,  74 }, // und_FR -> fr_Latn_FR
    {   0,   0,  79 }, {  37,   7,  79 }, // und_GA -> fr_Latn_GA
    {   0,   0,  81 }, {  41,  15,  81 }, // und_GE -> ka_Geor_GE
    {   0,   0,  76 }, {  37,   7,  76 }, // und_GF -> fr_Latn_GF
    {   0,   0,  83 }, { 146,   7,  83 }, // und_GH -> ak_Latn_GH
    {   0,   0,  86 }, {  44,   7,  86 }, // und_GL -> kl_Latn_GL
    {   0,   0,  91 }, {  37,   7,  91 }, // und_GN -> fr_Latn_GN
    {   0,   0,  88 }, {  37,   7,  88 }, // und_GP -> fr_Latn_GP
    {   0,   0,  66 }, { 111,   7,  66 }, // und_GQ -> es_Latn_GQ
    {   0,   0,  85 }, {  43,  16,  85 }, // und_GR -> el_Grek_GR
    {   0,   0, 196 }, {   0,   7, 196 }, // und_GS -> und_Latn_GS
    {   0,   0,  90 }, { 111,   7,  90 }, // und_GT -> es_Latn_GT
    {   0,   0,  92 }, {  91,   7,  92 }, // und_GW -> pt_Latn_GW
    {   0,   0,  97 }, {  25,   6,  97 }, // und_HK -> zh_Hant_HK
    {   0,   0,  95 }, {   0,   7,  95 }, // und_HM -> und_Latn_HM
    {   0,   0,  96 }, { 111,   7,  96 }, // und_HN -> es_Latn_HN
    {   0,   0,  54 }, {  27,   7,  54 }, // und_HR -> hr_Latn_HR
    {   0,   0,  94 }, { 222,   7,  94 }, // und_HT -> ht_Latn_HT
    {   0,   0,  98 }, {  50,   7,  98 }, // und_HU -> hu_Latn_HU
    {   0,   0, 238 }, { 111,   7, 238 }, // und_IC -> es_Latn_IC
    {   0,   0, 101 }, {  52,   7, 101 }, // und_ID -> id_Latn_ID
    {   0,   0, 105 }, {  48,  18, 105 }, // und_IL -> he_Hebr_IL
    {   0,   0, 100 }, {  49,  13, 100 }, // und_IN -> hi_Deva_IN
    {   0,   0, 103 }, {   8,   1, 103 }, // und_IQ -> ar_Arab_IQ
    {   0,   0, 102 }, {  89,   1, 102 }, // und_IR -> fa_Arab_IR
    {   0,   0,  99 }, {  51,   7,  99 }, // und_IS -> is_Latn_IS
    {   0,   0, 106 }, {  58,   7, 106 }, // und_IT -> it_Latn_IT
    {   0,   0, 109 }, {   8,   1, 109 }, // und_JO -> ar_Arab_JO
    {   0,   0, 108 }, {  59,  19, 108 }, // und_JP -> ja_Jpan_JP
    {   0,   0, 111 }, { 113,   7, 111 }, // und_KE -> sw_Latn_KE
    {   0,   0, 116 }, {  65,   2, 116 }, // und_KG -> ky_Cyrl_KG
    {   0,   0,  36 }, {  23,  20,  36 }, // und_KH -> km_Khmr_KH
    {   0,   0,  48 }, {   8,   1,  48 }, // und_KM -> ar_Arab_KM
    {   0,   0, 113 }, {  66,  22, 113 }, // und_KP -> ko_Kore_KP
    {   0,   0, 114 }, {  66,  22, 114 }, // und_KR -> ko_Kore_KR
    {   0,   0, 115 }, {   8,   1, 115 }, // und_KW -> ar_Arab_KW
    {   0,   0, 110 }, {  96,   2, 110 }, // und_KZ -> ru_Cyrl_KZ
    {   0,   0, 117 }, {  69,  23, 117 }, // und_LA -> lo_Laoo_LA
    {   0,   0, 119 }, {   8,   1, 119 }, // und_LB -> ar_Arab_LB
    {   0,   0, 123 }, {  42,   7, 123 }, // und_LI -> de_Latn_LI
    {   0,   0, 198 }, { 106,  32, 198 }, // und_LK -> si_Sinh_LK
    {   0,   0, 120 }, { 102,   7, 120 }, // und_LS -> st_Latn_LS
    {   0,   0, 124 }, {  73,   7, 124 }, // und_LT -> lt_Latn_LT
    {   0,   0, 125 }, {  37,   7, 125 }, // und_LU -> fr_Latn_LU
    {   0,   0, 118 }, {  71,   7, 118 }, // und_LV -> lv_Latn_LV
    {   0,   0, 122 }, {   8,   1, 122 }, // und_LY -> ar_Arab_LY
    {   0,   0, 145 }, {   8,   1, 145 }, // und_MA -> ar_Arab_MA
    {   0,   0, 142 }, {  37,   7, 142 }, // und_MC -> fr_Latn_MC
    {   0,   0, 141 }, {  95,   7, 141 }, // und_MD -> ro_Latn_MD
    {   0,   0, 242 }, { 100,   7, 242 }, // und_ME -> sr_Latn_ME
    {   0,   0, 245 }, {  37,   7, 245 }, // und_MF -> fr_Latn_MF
    {   0,   0, 128 }, {  75,   7, 128 }, // und_MG -> mg_Latn_MG
    {   0,   0, 127 }, {  74,   2, 127 }, // und_MK -> mk_Cyrl_MK
    {   0,   0, 132 }, { 188,   7, 132 }, // und_ML -> bm_Latn_ML
    {   0,   0, 147 }, {  21,  25, 147 }, // und_MM -> my_Mymr_MM
    {   0,   0, 143 }, {  82,   2, 143 }, // und_MN -> mn_Cyrl_MN
    {   0,   0, 126 }, {  25,   6, 126 }, // und_MO -> zh_Hant_MO
    {   0,   0, 135 }, {  37,   7, 135 }, // und_MQ -> fr_Latn_MQ
    {   0,   0, 136 }, {   8,   1, 136 }, // und_MR -> ar_Arab_MR
    {   0,   0, 133 }, {  78,   7, 133 }, // und_MT -> mt_Latn_MT
    {   0,   0, 137 }, { 191,   7, 137 }, // und_MU -> mfe_Latn_MU
    {   0,   0, 131 }, { 143,  29, 131 }, // und_MV -> dv_Thaa_MV
    {   0,   0, 139 }, { 111,   7, 139 }, // und_MX -> es_Latn_MX
    {   0,   0, 130 }, {  76,   7, 130 }, // und_MY -> ms_Latn_MY
    {   0,   0, 146 }, {  91,   7, 146 }, // und_MZ -> pt_Latn_MZ
    {   0,   0, 148 }, {   5,   7, 148 }, // und_NA -> af_Latn_NA
    {   0,   0, 153 }, {  37,   7, 153 }, // und_NC -> fr_Latn_NC
    {   0,   0, 156 }, {  47,   7, 156 }, // und_NE -> ha_Latn_NE
    {   0,   0, 155 }, { 111,   7, 155 }, // und_NI -> es_Latn_NI
    {   0,   0, 151 }, {  30,   7, 151 }, // und_NL -> nl_Latn_NL
    {   0,   0, 161 }, {  85,   7, 161 }, // und_NO -> nb_Latn_NO
    {   0,   0, 150 }, {  84,  13, 150 }, // und_NP -> ne_Deva_NP
    {   0,   0, 162 }, {   8,   1, 162 }, // und_OM -> ar_Arab_OM
    {   0,   0, 166 }, { 111,   7, 166 }, // und_PA -> es_Latn_PA
    {   0,   0, 169 }, { 111,   7, 169 }, // und_PE -> es_Latn_PE
    {   0,   0,  77 }, {  37,   7,  77 }, // und_PF -> fr_Latn_PF
    {   0,   0, 167 }, { 354,   7, 167 }, // und_PG -> tpi_Latn_PG
    {   0,   0, 170 }, { 166,   7, 170 }, // und_PH -> fil_Latn_PH
    {   0,   0, 163 }, { 130,   1, 163 }, // und_PK -> ur_Arab_PK
    {   0,   0, 172 }, {  90,   7, 172 }, // und_PL -> pl_Latn_PL
    {   0,   0, 200 }, {  37,   7, 200 }, // und_PM -> fr_Latn_PM
    {   0,   0, 174 }, { 111,   7, 174 }, // und_PR -> es_Latn_PR
    {   0,   0, 165 }, {   8,   1, 165 }, // und_PS -> ar_Arab_PS
    {   0,   0, 173 }, {  91,   7, 173 }, // und_PT -> pt_Latn_PT
    {   0,   0, 164 }, { 350,   7, 164 }, // und_PW -> pau_Latn_PW
    {   0,   0, 168 }, {  45,   7, 168 }, // und_PY -> gn_Latn_PY
    {   0,   0, 175 }, {   8,   1, 175 }, // und_QA -> ar_Arab_QA
    {   0,   0, 259 }, {  31,   7, 249 }, // und_QO -> en_Latn_DG
    {   0,   0, 176 }, {  37,   7, 176 }, // und_RE -> fr_Latn_RE
    {   0,   0, 177 }, {  95,   7, 177 }, // und_RO -> ro_Latn_RO
    {   0,   0, 243 }, { 100,   2, 243 }, // und_RS -> sr_Cyrl_RS
    {   0,   0, 178 }, {  96,   2, 178 }, // und_RU -> ru_Cyrl_RU
    {   0,   0, 179 }, {  64,   7, 179 }, // und_RW -> rw_Latn_RW
    {   0,   0, 186 }, {   8,   1, 186 }, // und_SA -> ar_Arab_SA
    {   0,   0, 188 }, {  37,   7, 188 }, // und_SC -> fr_Latn_SC
    {   0,   0, 201 }, {   8,   1, 201 }, // und_SD -> ar_Arab_SD
    {   0,   0, 205 }, { 114,   7, 205 }, // und_SE -> sv_Latn_SE
    {   0,   0, 192 }, { 109,   7, 192 }, // und_SI -> sl_Latn_SI
    {   0,   0, 203 }, {  85,   7, 203 }, // und_SJ -> nb_Latn_SJ
    {   0,   0, 191 }, { 108,   7, 191 }, // und_SK -> sk_Latn_SK
    {   0,   0, 184 }, {  58,   7, 184 }, // und_SM -> it_Latn_SM
    {   0,   0, 187 }, {  37,   7, 187 }, // und_SN -> fr_Latn_SN
    {   0,   0, 194 }, { 110,   7, 194 }, // und_SO -> so_Latn_SO
    {   0,   0, 202 }, {  30,   7, 202 }, // und_SR -> nl_Latn_SR
    {   0,   0, 185 }, {  91,   7, 185 }, // und_ST -> pt_Latn_ST
    {   0,   0,  65 }, { 111,   7,  65 }, // und_SV -> es_Latn_SV
    {   0,   0, 207 }, {   8,   1, 207 }, // und_SY -> ar_Arab_SY
    {   0,   0,  42 }, {  37,   7,  42 }, // und_TD -> fr_Latn_TD
    {   0,   0,  78 }, {  37,   7,  78 }, // und_TF -> fr_Latn_TF
    {   0,   0, 212 }, {  37,   7, 212 }, // und_TG -> fr_Latn_TG
    {   0,   0, 211 }, { 120,  30, 211 }, // und_TH -> th_Thai_TH
    {   0,   0, 209 }, { 116,   2, 209 }, // und_TJ -> tg_Cyrl_TJ
    {   0,   0, 213 }, { 353,   7, 213 }, // und_TK -> tkl_Latn_TK
    {   0,   0,  62 }, {  91,   7,  62 }, // und_TL -> pt_Latn_TL
    {   0,   0, 218 }, { 126,   7, 218 }, // und_TM -> tk_Latn_TM
    {   0,   0, 216 }, {   8,   1, 216 }, // und_TN -> ar_Arab_TN
    {   0,   0, 214 }, { 123,   7, 214 }, // und_TO -> to_Latn_TO
    {   0,   0, 217 }, { 125,   7, 217 }, // und_TR -> tr_Latn_TR
    {   0,   0, 220 }, { 355,   7, 220 }, // und_TV -> tvl_Latn_TV
    {   0,   0, 208 }, {  25,   6, 208 }, // und_TW -> zh_Hant_TW
    {   0,   0, 210 }, { 113,   7, 210 }, // und_TZ -> sw_Latn_TZ
    {   0,   0, 222 }, { 129,   2, 222 }, // und_UA -> uk_Cyrl_UA
    {   0,   0, 221 }, { 113,   7, 221 }, // und_UG -> sw_Latn_UG
    {   0,   0, 227 }, { 111,   7, 227 }, // und_UY -> es_Latn_UY
    {   0,   0, 228 }, { 131,   7, 228 }, // und_UZ -> uz_Latn_UZ
    {   0,   0, 230 }, {  58,   7, 230 }, // und_VA -> it_Latn_VA
    {   0,   0, 231 }, { 111,   7, 231 }, // und_VE -> es_Latn_VE
    {   0,   0, 232 }, { 132,   7, 232 }, // und_VN -> vi_Latn_VN
    {   0,   0, 229 }, {  18,   7, 229 }, // und_VU -> bi_Latn_VU
    {   0,   0, 235 }, {  37,   7, 235 }, // und_WF -> fr_Latn_WF
    {   0,   0, 183 }, {  97,   7, 183 }, // und_WS -> sm_Latn_WS
    {   0,   0, 257 }, {   6,   7, 257 }, // und_XK -> sq_Latn_XK
    {   0,   0, 237 }, {   8,   1, 237 }, // und_YE -> ar_Arab_YE
    {   0,   0, 138 }, {  37,   7, 138 }, // und_YT -> fr_Latn_YT
    {   0,   0, 240 }, { 104,   7, 240 }, // und_ZW -> sn_Latn_ZW
    {   0, 134,   0 }, { 177, 134,  91 }, // und_Adlm -> ff_Adlm_GN
    {   0, 105,   0 }, { 335, 105, 178 }, // und_Aghb -> lez_Aghb_RU
    {   0, 128,   0 }, { 340, 128, 100 }, // und_Ahom -> aho_Ahom_IN
    {   0,   1,   0 }, {   8,   1,  64 }, // und_Arab -> ar_Arab_EG
    {   0,   1,  46 }, {  76,   1,  46 }, // und_Arab_CC -> ms_Arab_CC
    {   0,   1,  44 }, { 128,   1,  44 }, // und_Arab_CN -> ug_Arab_CN
    {   0,   1, 224 }, {  62,   1, 224 }, // und_Arab_GB -> ks_Arab_GB
    {   0,   1, 101 }, {  76,   1, 101 }, // und_Arab_ID -> ms_Arab_ID
    {   0,   1, 100 }, { 130,   1, 100 }, // und_Arab_IN -> ur_Arab_IN
    {   0,   1, 143 }, {  63,   1, 143 }, // und_Arab_MN -> kk_Arab_MN
    {   0,   1, 137 }, { 130,   1, 137 }, // und_Arab_MU -> ur_Arab_MU
    {   0,   1, 157 }, {  47,   1, 157 }, // und_Arab_NG -> ha_Arab_NG
    {   0,   1, 163 }, { 130,   1, 163 }, // und_Arab_PK -> ur_Arab_PK
    {   0,   1, 209 }, {  89,   1, 209 }, // und_Arab_TJ -> fa_Arab_TJ
    {   0,   1, 217 }, {  12,   1, 217 }, // und_Arab_TR -> az_Arab_TR
    {   0,  57,   0 }, { 265,  57, 102 }, // und_Armi -> arc_Armi_IR
    {   0,  10,   0 }, {   9,  10,  11 }, // und_Armn -> hy_Armn_AM
    {   0,  36,   0 }, { 255,  36, 102 }, // und_Avst -> ae_Avst_IR
    {   0,  37,   0 }, { 266,  37, 101 }, // und_Bali -> ban_Bali_ID
    {   0,  38,   0 }, { 267,  38,  37 }, // und_Bamu -> bax_Bamu_CM
    {   0, 106,   0 }, { 336, 106, 121 }, // und_Bass -> bsq_Bass_LR
    {   0,  39,   0 }, { 268,  39, 101 }, // und_Batk -> bbc_Batk_ID
    {   0,  11,   0 }, {  15,  11,  18 }, // und_Beng -> bn_Beng_BD
    {   0, 135,   0 }, {  99, 135, 100 }, // und_Bhks -> sa_Bhks_IN
    {   0,  40,   0 }, {  25,  40, 208 }, // und_Bopo -> zh_Bopo_TW
    {   0,  41,   0 }, { 342,  41, 100 }, // und_Brah -> pka_Brah_IN
    {   0, 103,   0 }, {  37, 103,  74 }, // und_Brai -> fr_Brai_FR
    {   0,  42,   0 }, { 269,  42, 101 }, // und_Bugi -> bug_Bugi_ID
    {   0,  43,   0 }, { 270,  43, 170 }, // und_Buhd -> bku_Buhd_PH
    {   0,  46,   0 }, { 272,  46,  18 }, // und_Cakm -> ccp_Cakm_BD
    {   0,  44,   0 }, { 221,  44,  38 }, // und_Cans -> cr_Cans_CA
    {   0,  45,   0 }, { 271,  45, 217 }, // und_Cari -> xcr_Cari_TR
    {   0,  47,   0 }, { 276,  47, 232 }, // und_Cham -> cjm_Cham_VN
    {   0,  12,   0 }, { 190,  12, 225 }, // und_Cher -> chr_Cher_US
    {   0,  48,   0 }, { 274,  48,  64 }, // und_Copt -> cop_Copt_EG
    {   0,  49,   0 }, { 264,  49,  56 }, // und_Cprt -> grc_Cprt_CY
    {   0,   2,   0 }, {  96,   2, 178 }, // und_Cyrl -> ru_Cyrl_RU
    {   0,   2,   2 }, {  74,   2,   2 }, // und_Cyrl_AL -> mk_Cyrl_AL
    {   0,   2,  27 }, { 100,   2,  27 }, // und_Cyrl_BA -> sr_Cyrl_BA
    {   0,   2,  81 }, {   2,   2,  81 }, // und_Cyrl_GE -> ab_Cyrl_GE
    {   0,   2,  85 }, {  74,   2,  85 }, // und_Cyrl_GR -> mk_Cyrl_GR
    {   0,   2, 141 }, { 129,   2, 141 }, // und_Cyrl_MD -> uk_Cyrl_MD
    {   0,   2, 177 }, {  20,   2, 177 }, // und_Cyrl_RO -> bg_Cyrl_RO
    {   0,   2, 191 }, { 129,   2, 191 }, // und_Cyrl_SK -> uk_Cyrl_SK
    {   0,   2, 257 }, { 100,   2, 257 }, // und_Cyrl_XK -> sr_Cyrl_XK
    {   0,  13,   0 }, {  49,  13, 100 }, // und_Deva -> hi_Deva_IN
    {   0,  13,  25 }, {  84,  13,  25 }, // und_Deva_BT -> ne_Deva_BT
    {   0,  13, 137 }, { 343,  13, 137 }, // und_Deva_MU -> bho_Deva_MU
    {   0, 107,   0 }, {  37, 107,  74 }, // und_Dupl -> fr_Dupl_FR
    {   0,  50,   0 }, { 263,  50,  64 }, // und_Egyp -> egy_Egyp_EG
    {   0, 108,   0 }, {   6, 108,   2 }, // und_Elba -> sq_Elba_AL
    {   0,  14,   0 }, {   7,  14,  69 }, // und_Ethi -> am_Ethi_ET
    {   0,  15,   0 }, {  41,  15,  81 }, // und_Geor -> ka_Geor_GE
    {   0,  52,   0 }, { 219,  52,  33 }, // und_Glag -> cu_Glag_BG
    {   0,  53,   0 }, { 279,  53, 222 }, // und_Goth -> got_Goth_UA
    {   0, 109,   0 }, {  99, 109, 100 }, // und_Gran -> sa_Gran_IN
    {   0,  16,   0 }, {  43,  16,  85 }, // und_Grek -> el_Grek_GR
    {   0,  17,   0 }, {  46,  17, 100 }, // und_Gujr -> gu_Gujr_IN
    {   0,   4,   0 }, {  92,   4, 100 }, // und_Guru -> pa_Guru_IN
    {   0, 140,   0 }, {  25, 140, 208 }, // und_Hanb -> zh_Hanb_TW
    {   0,  55,   0 }, {  66,  55, 114 }, // und_Hang -> ko_Hang_KR
    {   0,  54,   0 }, {  25,  54,  44 }, // und_Hani -> zh_Hani_CN
    {   0,  56,   0 }, { 280,  56, 170 }, // und_Hano -> hnn_Hano_PH
    {   0,   5,   0 }, {  25,   5,  44 }, // und_Hans -> zh_Hans_CN
    {   0,   6,   0 }, {  25,   6, 208 }, // und_Hant -> zh_Hant_TW
    {   0, 130,   0 }, { 356, 130, 103 }, // und_Hatr -> mis_Hatr_IQ
    {   0,  18,   0 }, {  48,  18, 105 }, // und_Hebr -> he_Hebr_IL
    {   0,  18,  38 }, { 137,  18,  38 }, // und_Hebr_CA -> yi_Hebr_CA
    {   0,  18, 224 }, { 137,  18, 224 }, // und_Hebr_GB -> yi_Hebr_GB
    {   0,  18, 205 }, { 137,  18, 205 }, // und_Hebr_SE -> yi_Hebr_SE
    {   0,  18, 222 }, { 137,  18, 222 }, // und_Hebr_UA -> yi_Hebr_UA
    {   0,  18, 225 }, { 137,  18, 225 }, // und_Hebr_US -> yi_Hebr_US
    {   0, 104,   0 }, {  59, 104, 108 }, // und_Hira -> ja_Hira_JP
    {   0, 129,   0 }, { 344, 129, 217 }, // und_Hluw -> hlu_Hluw_TR
    {   0, 110,   0 }, { 333, 110, 117 }, // und_Hmng -> hnj_Hmng_LA
    {   0, 132,   0 }, {  50, 132,  98 }, // und_Hung -> hu_Hung_HU
    {   0,  79,   0 }, { 278,  79, 106 }, // und_Ital -> ett_Ital_IT
    {   0, 141,   0 }, {  66, 141, 114 }, // und_Jamo -> ko_Jamo_KR
    {   0,  60,   0 }, {  60,  60, 101 }, // und_Java -> jv_Java_ID
    {   0,  19,   0 }, {  59,  19, 108 }, // und_Jpan -> ja_Jpan_JP
    {   0,  63,   0 }, { 277,  63, 147 }, // und_Kali -> eky_Kali_MM
    {   0,  62,   0 }, {  59,  62, 108 }, // und_Kana -> ja_Kana_JP
    {   0,  64,   0 }, { 300,  64, 163 }, // und_Khar -> pra_Khar_PK
    {   0,  20,   0 }, {  23,  20,  36 }, // und_Khmr -> km_Khmr_KH
    {   0, 111,   0 }, { 105, 111, 100 }, // und_Khoj -> sd_Khoj_IN
    {   0,  21,   0 }, {  61,  21, 100 }, // und_Knda -> kn_Knda_IN
    {   0,  22,   0 }, {  66,  22, 114 }, // und_Kore -> ko_Kore_KR
    {   0,  61,   0 }, { 343,  61, 100 }, // und_Kthi -> bho_Kthi_IN
    {   0,  65,   0 }, { 292,  65, 211 }, // und_Lana -> nod_Lana_TH
    {   0,  23,   0 }, {  69,  23, 117 }, // und_Laoo -> lo_Laoo_LA
    {   0,   7,   1 }, { 126,   7,   1 }, // und_Latn_AF -> tk_Latn_AF
    {   0,   7,  11 }, {  67,   7,  11 }, // und_Latn_AM -> ku_Latn_AM
    {   0,   7,  44 }, { 139,   7,  44 }, // und_Latn_CN -> za_Latn_CN
    {   0,   7,  56 }, { 125,   7,  56 }, // und_Latn_CY -> tr_Latn_CY
    {   0,   7,   3 }, {  37,   7,   3 }, // und_Latn_DZ -> fr_Latn_DZ
    {   0,   7,  69 }, {  31,   7,  69 }, // und_Latn_ET -> en_Latn_ET
    {   0,   7,  81 }, {  67,   7,  81 }, // und_Latn_GE -> ku_Latn_GE
    {   0,   7, 102 }, { 126,   7, 102 }, // und_Latn_IR -> tk_Latn_IR
    {   0,   7,  48 }, {  37,   7,  48 }, // und_Latn_KM -> fr_Latn_KM
    {   0,   7, 145 }, {  37,   7, 145 }, // und_Latn_MA -> fr_Latn_MA
    {   0,   7, 127 }, {   6,   7, 127 }, // und_Latn_MK -> sq_Latn_MK
    {   0,   7, 126 }, {  91,   7, 126 }, // und_Latn_MO -> pt_Latn_MO
    {   0,   7, 136 }, {  37,   7, 136 }, // und_Latn_MR -> fr_Latn_MR
    {   0,   7, 207 }, {  37,   7, 207 }, // und_Latn_SY -> fr_Latn_SY
    {   0,   7, 216 }, {  37,   7, 216 }, // und_Latn_TN -> fr_Latn_TN
    {   0,   7, 208 }, { 174,   7, 208 }, // und_Latn_TW -> trv_Latn_TW
    {   0,   7, 222 }, {  90,   7, 222 }, // und_Latn_UA -> pl_Latn_UA
    {   0,  66,   0 }, { 283,  66, 100 }, // und_Lepc -> lep_Lepc_IN
    {   0,  67,   0 }, { 284,  67, 100 }, // und_Limb -> lif_Limb_IN
    {   0, 112,   0 }, { 332, 112,  85 }, // und_Lina -> lab_Lina_GR
    {   0,  68,   0 }, { 264,  68,  85 }, // und_Linb -> grc_Linb_GR
    {   0,  51,   0 }, { 285,  51,  44 }, // und_Lisu -> lis_Lisu_CN
    {   0,  69,   0 }, { 287,  69, 217 }, // und_Lyci -> xlc_Lyci_TR
    {   0,  70,   0 }, { 288,  70, 217 }, // und_Lydi -> xld_Lydi_TR
    {   0, 113,   0 }, {  49, 113, 100 }, // und_Mahj -> hi_Mahj_IN
    {   0,  71,   0 }, { 273,  71, 102 }, // und_Mand -> myz_Mand_IR
    {   0, 114,   0 }, { 329, 114,  44 }, // und_Mani -> xmn_Mani_CN
    {   0, 136,   0 }, { 121, 136,  44 }, // und_Marc -> bo_Marc_CN
    {   0, 115,   0 }, { 330, 115, 189 }, // und_Mend -> men_Mend_SL
    {   0,  74,   0 }, { 291,  74, 201 }, // und_Merc -> xmr_Merc_SD
    {   0,  73,   0 }, { 291,  73, 201 }, // und_Mero -> xmr_Mero_SD
    {   0,  24,   0 }, {  77,  24, 100 }, // und_Mlym -> ml_Mlym_IN
    {   0, 116,   0 }, {  80, 116, 100 }, // und_Modi -> mr_Modi_IN
    {   0,   8,   0 }, {  82,   8,  44 }, // und_Mong -> mn_Mong_CN
    {   0, 117,   0 }, { 347, 117,  18 }, // und_Mroo -> mro_Mroo_BD
    {   0,  72,   0 }, { 290,  72, 100 }, // und_Mtei -> mni_Mtei_IN
    {   0, 131,   0 }, { 352, 131, 163 }, // und_Mult -> skr_Mult_PK
    {   0,  25,   0 }, {  21,  25, 147 }, // und_Mymr -> my_Mymr_MM
    {   0, 118,   0 }, { 331, 118, 186 }, // und_Narb -> xna_Narb_SA
    {   0, 119,   0 }, { 265, 119, 109 }, // und_Nbat -> arc_Nbat_JO
    {   0, 137,   0 }, { 348, 137, 150 }, // und_Newa -> new_Newa_NP
    {   0,  75,   0 }, { 289,  75,  91 }, // und_Nkoo -> man_Nkoo_GN
    {   0,  77,   0 }, { 293,  77, 104 }, // und_Ogam -> sga_Ogam_IE
    {   0,  78,   0 }, { 304,  78, 100 }, // und_Olck -> sat_Olck_IN
    {   0,  82,   0 }, { 296,  82, 143 }, // und_Orkh -> otk_Orkh_MN
    {   0,  26,   0 }, {  87,  26, 100 }, // und_Orya -> or_Orya_IN
    {   0, 138,   0 }, { 358, 138, 225 }, // und_Osge -> osa_Osge_US
    {   0,  83,   0 }, { 110,  83, 194 }, // und_Osma -> so_Osma_SO
    {   0, 120,   0 }, { 265, 120, 207 }, // und_Palm -> arc_Palm_SY
    {   0, 121,   0 }, { 338, 121, 147 }, // und_Pauc -> ctd_Pauc_MM
    {   0, 122,   0 }, { 226, 122, 178 }, // und_Perm -> kv_Perm_RU
    {   0,  84,   0 }, { 345,  84,  44 }, // und_Phag -> lzh_Phag_CN
    {   0,  58,   0 }, { 297,  58, 102 }, // und_Phli -> pal_Phli_IR
    {   0, 123,   0 }, { 297, 123,  44 }, // und_Phlp -> pal_Phlp_CN
    {   0,  85,   0 }, { 299,  85, 119 }, // und_Phnx -> phn_Phnx_LB
    {   0,  86,   0 }, { 282,  86,  44 }, // und_Plrd -> hmd_Plrd_CN
    {   0,  59,   0 }, { 298,  59, 102 }, // und_Prti -> xpr_Prti_IR
    {   0,  87,   0 }, { 301,  87, 101 }, // und_Rjng -> rej_Rjng_ID
    {   0,  88,   0 }, { 294,  88, 205 }, // und_Runr -> non_Runr_SE
    {   0,  89,   0 }, { 303,  89, 105 }, // und_Samr -> smp_Samr_IL
    {   0,  81,   0 }, { 302,  81, 237 }, // und_Sarb -> xsa_Sarb_YE
    {   0,  90,   0 }, { 305,  90, 100 }, // und_Saur -> saz_Saur_IN
    {   0, 133,   0 }, { 341, 133, 225 }, // und_Sgnw -> ase_Sgnw_US
    {   0,  92,   0 }, {  31,  92, 224 }, // und_Shaw -> en_Shaw_GB
    {   0,  91,   0 }, {  99,  91, 100 }, // und_Shrd -> sa_Shrd_IN
    {   0, 124,   0 }, {  99, 124, 100 }, // und_Sidd -> sa_Sidd_IN
    {   0, 125,   0 }, { 105, 125, 100 }, // und_Sind -> sd_Sind_IN
    {   0,  32,   0 }, { 106,  32, 198 }, // und_Sinh -> si_Sinh_LK
    {   0,  93,   0 }, { 306,  93, 100 }, // und_Sora -> srb_Sora_IN
    {   0,  95,   0 }, { 112,  95, 101 }, // und_Sund -> su_Sund_ID
    {   0,  96,   0 }, { 307,  96,  18 }, // und_Sylo -> syl_Sylo_BD
    {   0,  33,   0 }, { 151,  33, 103 }, // und_Syrc -> syr_Syrc_IQ
    {   0,  98,   0 }, { 308,  98, 170 }, // und_Tagb -> tbw_Tagb_PH
    {   0, 101,   0 }, { 275, 101, 100 }, // und_Takr -> doi_Takr_IN
    {   0,  99,   0 }, { 310,  99,  44 }, // und_Tale -> tdd_Tale_CN
    {   0,  76,   0 }, { 286,  76,  44 }, // und_Talu -> khb_Talu_CN
    {   0,  27,   0 }, { 117,  27, 100 }, // und_Taml -> ta_Taml_IN
    {   0, 139,   0 }, { 359, 139,  44 }, // und_Tang -> txg_Tang_CN
    {   0, 100,   0 }, { 309, 100, 232 }, // und_Tavt -> blt_Tavt_VN
    {   0,  28,   0 }, { 119,  28, 100 }, // und_Telu -> te_Telu_IN
    {   0,   9,   0 }, { 314,   9, 145 }, // und_Tfng -> zgh_Tfng_MA
    {   0,  97,   0 }, { 166,  97, 170 }, // und_Tglg -> fil_Tglg_PH
    {   0,  29,   0 }, { 143,  29, 131 }, // und_Thaa -> dv_Thaa_MV
    {   0,  30,   0 }, { 120,  30, 211 }, // und_Thai -> th_Thai_TH
    {   0,  31,   0 }, { 121,  31,  44 }, // und_Tibt -> bo_Tibt_CN
    {   0, 126,   0 }, { 339, 126, 100 }, // und_Tirh -> mai_Tirh_IN
    {   0, 102,   0 }, { 311, 102, 207 }, // und_Ugar -> uga_Ugar_SY
    {   0,  35,   0 }, { 252,  35, 121 }, // und_Vaii -> vai_Vaii_LR
    {   0, 127,   0 }, { 334, 127, 100 }, // und_Wara -> hoc_Wara_IN
    {   0,  80,   0 }, { 295,  80, 102 }, // und_Xpeo -> peo_Xpeo_IR
    {   0,  94,   0 }, { 262,  94, 103 }, // und_Xsux -> akk_Xsux_IQ
    {   0,  34,   0 }, { 168,  34,  44 }  // und_Yiii -> ii_Yiii_CN
};

static const quint16 locale_index[] = {
     0, // AnyLanguage
     0, // C
     0, // Abkhazian
     1, // Oromo
     3, // Afar
     4, // Afrikaans
     6, // Albanian
     9, // Amharic
    10, // Arabic
    38, // Armenian
    39, // Assamese
     0, // Aymara
    40, // Azerbaijani
    43, // Bashkir
    44, // Basque
    45, // Bengali
    47, // Dzongkha
     0, // Bihari
     0, // Bislama
    48, // Breton
    49, // Bulgarian
    50, // Burmese
    51, // Belarusian
    52, // Khmer
    53, // Catalan
    57, // Chinese
    64, // Corsican
    65, // Croatian
    67, // Czech
    68, // Danish
    70, // Dutch
    77, // English
   183, // Esperanto
   184, // Estonian
   185, // Faroese
     0, // Fijian
   187, // Finnish
   188, // French
   234, // Western Frisian
   235, // Gaelic
   236, // Galician
   237, // Georgian
   238, // German
   245, // Greek
   247, // Greenlandic
   248, // Guarani
   249, // Gujarati
   250, // Hausa
   254, // Hebrew
   255, // Hindi
   256, // Hungarian
   257, // Icelandic
   258, // Indonesian
   259, // Interlingua
     0, // Interlingue
   260, // Inuktitut
     0, // Inupiak
   262, // Irish
   264, // Italian
   268, // Japanese
   269, // Javanese
   270, // Kannada
   271, // Kashmiri
   272, // Kazakh
   273, // Kinyarwanda
   274, // Kirghiz
   275, // Korean
   277, // Kurdish
   278, // Rundi
   279, // Lao
     0, // Latin
   280, // Latvian
   281, // Lingala
   285, // Lithuanian
   286, // Macedonian
   287, // Malagasy
   288, // Malay
   292, // Malayalam
   293, // Maltese
   294, // Maori
   295, // Marathi
     0, // Marshallese
   296, // Mongolian
     0, // Nauru
   298, // Nepali
   300, // Norwegian Bokmal
   302, // Occitan
   303, // Oriya
   304, // Pashto
   306, // Persian
   308, // Polish
   309, // Portuguese
   321, // Punjabi
   323, // Quechua
   326, // Romansh
   327, // Romanian
   329, // Russian
     0, // Samoan
   335, // Sango
   336, // Sanskrit
   337, // Serbian
   345, // Ossetic
   347, // Southern Sotho
   348, // Tswana
   349, // Shona
   350, // Sindhi
   351, // Sinhala
   352, // Swati
   353, // Slovak
   354, // Slovenian
   355, // Somali
   359, // Spanish
   387, // Sundanese
   388, // Swahili
   392, // Swedish
   395, // Sardinian
   396, // Tajik
   397, // Tamil
   401, // Tatar
   402, // Telugu
   403, // Thai
   404, // Tibetan
   406, // Tigrinya
   408, // Tongan
   409, // Tsonga
   410, // Turkish
   412, // Turkmen
     0, // Tahitian
   413, // Uighur
   414, // Ukrainian
   415, // Urdu
   417, // Uzbek
   420, // Vietnamese
   421, // Volapuk
   422, // Welsh
   423, // Wolof
   424, // Xhosa
   425, // Yiddish
   426, // Yoruba
     0, // Zhuang
   428, // Zulu
   429, // Norwegian Nynorsk
   430, // Bosnian
   432, // Divehi
   433, // Manx
   434, // Cornish
   435, // Akan
   436, // Konkani
   437, // Ga
   438, // Igbo
   439, // Kamba
   440, // Syriac
   441, // Blin
   442, // Geez
     0, // Koro
   443, // Sidamo
   444, // Atsam
   445, // Tigre
   446, // Jju
   447, // Friulian
   448, // Venda
   449, // Ewe
   451, // Walamo
   452, // Hawaiian
   453, // Tyap
   454, // Nyanja
   455, // Filipino
   456, // Swiss German
   459, // Sichuan Yi
   460, // Kpelle
   461, // Low German
   463, // South Ndebele
   464, // Northern Sotho
   465, // Northern Sami
   468, // Taroko
   469, // Gusii
   470, // Taita
   471, // Fulah
   484, // Kikuyu
   485, // Samburu
   486, // Sena
   487, // North Ndebele
   488, // Rombo
   489, // Tachelhit
   491, // Kabyle
   492, // Nyankole
   493, // Bena
   494, // Vunjo
   495, // Bambara
   497, // Embu
   498, // Cherokee
   499, // Morisyen
   500, // Makonde
   501, // Langi
   502, // Ganda
   503, // Bemba
   504, // Kabuverdianu
   505, // Meru
   506, // Kalenjin
   507, // Nama
   508, // Machame
   509, // Colognian
   510, // Masai
   512, // Soga
   513, // Luyia
   514, // Asu
   515, // Teso
   517, // Saho
   518, // Koyra Chiini
   519, // Rwa
   520, // Luo
   521, // Chiga
   522, // Central Morocco Tamazight
   523, // Koyraboro Senni
   524, // Shambala
   525, // Bodo
     0, // Avaric
     0, // Chamorro
   526, // Chechen
   527, // Church
   528, // Chuvash
     0, // Cree
     0, // Haitian
     0, // Herero
     0, // Hiri Motu
     0, // Kanuri
     0, // Komi
     0, // Kongo
     0, // Kwanyama
     0, // Limburgish
   529, // Luba Katanga
   530, // Luxembourgish
     0, // Navaho
     0, // Ndonga
     0, // Ojibwa
     0, // Pali
   531, // Walloon
   532, // Aghem
   533, // Basaa
   534, // Zarma
   535, // Duala
   536, // Jola Fonyi
   537, // Ewondo
   538, // Bafia
   539, // Makhuwa Meetto
   540, // Mundang
   541, // Kwasio
   542, // Nuer
   543, // Sakha
   544, // Sangu
     0, // Congo Swahili
   545, // Tasawaq
   546, // Vai
   548, // Walser
   549, // Yangben
     0, // Avestan
   550, // Asturian
   551, // Ngomba
   552, // Kako
   553, // Meta
   554, // Ngiemboon
   555, // Aragonese
     0, // Akkadian
     0, // Ancient Egyptian
     0, // Ancient Greek
     0, // Aramaic
     0, // Balinese
     0, // Bamun
     0, // Batak Toba
     0, // Buginese
     0, // Buhid
     0, // Carian
     0, // Chakma
     0, // Classical Mandaic
     0, // Coptic
     0, // Dogri
     0, // Eastern Cham
     0, // Eastern Kayah
     0, // Etruscan
     0, // Gothic
     0, // Hanunoo
     0, // Ingush
     0, // Large Flowery Miao
     0, // Lepcha
     0, // Limbu
     0, // Lisu
     0, // Lu
     0, // Lycian
     0, // Lydian
     0, // Mandingo
   556, // Manipuri
     0, // Meroitic
     0, // Northern Thai
     0, // Old Irish
     0, // Old Norse
     0, // Old Persian
     0, // Old Turkish
     0, // Pahlavi
     0, // Parthian
     0, // Phoenician
     0, // Prakrit Language
     0, // Rejang
     0, // Sabaean
     0, // Samaritan
     0, // Santali
     0, // Saurashtra
     0, // Sora
     0, // Sylheti
     0, // Tagbanwa
   557, // Tai Dam
     0, // Tai Nua
     0, // Ugaritic
   558, // Akoose
   559, // Lakota
   560, // Standard Moroccan Tamazight
   561, // Mapuche
   562, // Central Kurdish
   564, // Lower Sorbian
   565, // Upper Sorbian
   566, // Kenyang
   567, // Mohawk
   568, // Nko
   569, // Prussian
   570, // Kiche
   571, // Southern Sami
   572, // Lule Sami
   573, // Inari Sami
   574, // Skolt Sami
   575, // Warlpiri
     0, // Manichaean Middle Persian
     0, // Mende
     0, // Ancient North Arabian
     0, // Linear A
     0, // Hmong Njua
     0, // Ho
     0, // Lezghian
     0, // Bassa
     0, // Mono
     0, // Tedim Chin
     0, // Maithili
     0, // Ahom
     0, // American Sign Language
     0, // Ardhamagadhi Prakrit
     0, // Bhojpuri
     0, // Hieroglyphic Luwian
     0, // Literary Chinese
   576, // Mazanderani
     0, // Mru
     0, // Newari
   577, // Northern Luri
     0, // Palauan
     0, // Papiamento
     0, // Saraiki
     0, // Tokelau
     0, // Tok Pisin
     0, // Tuvalu
     0, // Uncoded Languages
   579, // Cantonese
   581, // Osage
     0, // Tangut
   582, // Ido
   583, // Lojban
   584, // Sicilian
   585, // Southern Kurdish
   586, // Western Balochi
   587, // Cebuano
   588, // Erzya
   589, // Chickasaw
   590, // Muscogee
   591, // Silesian
     0 // trailing 0
};

static const QLocaleData locale_data[] = {
   //  lang  script   terr   dec   group  list   prcnt   zero  minus  plus    exp   quotOpn  quotEnd altQtOpn altQtEnd   lpStart      lpMid       lpEnd       lpTwo       sDtFmt      lDtFmt      sTmFmt      lTmFmt      ssDays      slDays      snDays       sDays       lDays       nDays        am          pm       byte    siQuant iecQuant    currISO     currSym    currDsply    currFmt    currFmtNeg   endoLang    endoCntry curDgt curRnd dow1st  wknd+  wknd-
    {      1,     0,     0,    46,    44,    59,    37,    48,    45,    43,   101,      34,      34,      39,      39,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      0,10 ,     10,17 ,       0,8 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     99,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,       0,7 ,       0,4 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // C/AnyScript/AnyCountry
    {      3,     7,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,     35,18 ,      18,7 ,     25,12 ,    113,28 ,    141,55 ,     85,14 ,    113,28 ,    141,55 ,     85,14 ,       2,2 ,       2,2 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,2 ,      7,24 ,       4,4 ,       4,0 ,       0,6 ,      6,10 ,     2,     1,     7,     6,     7 }, // Oromo/Latin/Ethiopia
    {      3,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,     35,18 ,      37,5 ,      8,10 ,    113,28 ,    141,55 ,    196,14 ,    113,28 ,    141,55 ,    196,14 ,       2,2 ,       2,2 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,       0,7 ,       4,4 ,       4,0 ,       0,6 ,      16,8 ,     2,     1,     7,     6,     7 }, // Oromo/Latin/Kenya
    {      4,     7,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Afar/Latin/Ethiopia
    {      5,     7,   195,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     53,10 ,     80,17 ,      37,5 ,      8,10 ,    210,28 ,    238,58 ,    296,14 ,    210,28 ,    238,58 ,    296,14 ,       4,3 ,       4,3 ,   49,5 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,     31,67 ,       4,4 ,       4,0 ,      24,9 ,     33,11 ,     2,     1,     7,     6,     7 }, // Afrikaans/Latin/South Africa
    {      5,     7,   148,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     53,10 ,     97,16 ,      18,7 ,     25,12 ,    210,28 ,    238,58 ,    296,14 ,    210,28 ,    238,58 ,    296,14 ,       4,3 ,       4,3 ,   49,5 ,   5,17 ,  22,23 , {78,65,68},        6,1 ,     98,55 ,       4,4 ,       4,0 ,      24,9 ,      44,7 ,     2,     1,     1,     6,     7 }, // Afrikaans/Latin/Namibia
    {      6,     7,     2,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,      14,9 ,      14,9 ,     113,6 ,     10,17 ,      18,7 ,     42,13 ,    310,28 ,    338,58 ,    396,15 ,    411,28 ,    338,58 ,    396,15 ,      7,11 ,      7,10 ,   54,4 ,   5,17 ,  22,23 , {65,76,76},        7,4 ,    153,45 ,      13,5 ,       4,0 ,      51,5 ,      56,8 ,     0,     0,     1,     6,     7 }, // Albanian/Latin/Albania
    {      6,     7,   127,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,      14,9 ,      14,9 ,     113,6 ,     10,17 ,      37,5 ,      8,10 ,    310,28 ,    338,58 ,    396,15 ,    411,28 ,    338,58 ,    396,15 ,      7,11 ,      7,10 ,   54,4 ,   5,17 ,  22,23 , {77,75,68},       11,3 ,    198,54 ,      13,5 ,       4,0 ,      51,5 ,     64,18 ,     2,     1,     1,     6,     7 }, // Albanian/Latin/Macedonia
    {      6,     7,   257,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,      14,9 ,      14,9 ,     113,6 ,     10,17 ,      37,5 ,      8,10 ,    310,28 ,    338,58 ,    396,15 ,    411,28 ,    338,58 ,    396,15 ,      7,11 ,      7,10 ,   54,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,    252,21 ,      13,5 ,       4,0 ,      51,5 ,      82,6 ,     2,     1,     1,     6,     7 }, // Albanian/Latin/Kosovo
    {      7,    14,    69,    46,    44,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,      23,6 ,      23,6 ,      29,9 ,      38,8 ,    119,10 ,     63,17 ,      18,7 ,     25,12 ,    439,27 ,    466,28 ,    494,14 ,    439,27 ,    466,28 ,    494,14 ,      18,3 ,      17,4 ,   58,3 ,  61,23 ,  22,23 , {69,84,66},       15,2 ,    273,34 ,       4,4 ,       4,0 ,      88,4 ,      92,5 ,     2,     1,     7,     6,     7 }, // Amharic/Ethiopic/Ethiopia
    {      8,     1,    64,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {69,71,80},       17,5 ,    307,81 ,      13,5 ,       4,0 ,      97,7 ,     104,3 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Egypt
    {      8,     1,     3,    44,    46,    59,    37,    48,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {68,90,68},       22,5 ,   388,102 ,      13,5 ,       4,0 ,      97,7 ,     107,7 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Algeria
    {      8,     1,    17,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {66,72,68},       27,5 ,    490,91 ,      13,5 ,       4,0 ,      97,7 ,     114,7 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Bahrain
    {      8,     1,    42,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {88,65,70},       32,4 ,   581,112 ,      13,5 ,       4,0 ,      97,7 ,     121,4 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Chad
    {      8,     1,    48,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      37,5 ,      8,10 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {75,77,70},       36,2 ,   693,105 ,      13,5 ,       4,0 ,      97,7 ,     125,9 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Comoros
    {      8,     1,    59,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {68,74,70},       38,3 ,    798,84 ,      13,5 ,       4,0 ,      97,7 ,     134,6 ,     0,     0,     6,     6,     7 }, // Arabic/Arabic/Djibouti
    {      8,     1,    67,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {69,82,78},       41,3 ,    882,91 ,      13,5 ,       4,0 ,      97,7 ,     140,7 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Eritrea
    {      8,     1,   103,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {73,81,68},       44,5 ,    973,84 ,      13,5 ,       4,0 ,      97,7 ,     147,6 ,     0,     0,     6,     5,     6 }, // Arabic/Arabic/Iraq
    {      8,     1,   105,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      55,4 ,      59,9 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {73,76,83},       49,1 ,  1057,133 ,      13,5 ,       4,0 ,      97,7 ,     153,7 ,     2,     1,     7,     5,     6 }, // Arabic/Arabic/Israel
    {      8,     1,   109,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {74,79,68},       50,5 ,   1190,84 ,      13,5 ,       4,0 ,      97,7 ,     160,6 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Jordan
    {      8,     1,   115,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {75,87,68},       55,5 ,   1274,84 ,      13,5 ,       4,0 ,      97,7 ,     166,6 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Kuwait
    {      8,     1,   119,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {76,66,80},       60,5 ,   1358,84 ,      13,5 ,       4,0 ,      97,7 ,     172,5 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Lebanon
    {      8,     1,   122,    44,    46,    59,    37,    48,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {76,89,68},       65,5 ,   1442,88 ,      13,5 ,       4,0 ,      97,7 ,     177,5 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Libya
    {      8,     1,   136,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {77,82,85},       70,4 ,  1530,112 ,      13,5 ,       4,0 ,      97,7 ,     182,9 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Mauritania
    {      8,     1,   145,    44,    46,    59,    37,    48,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      37,5 ,      8,10 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {77,65,68},       74,5 ,   1642,87 ,      13,5 ,       4,0 ,      97,7 ,     191,6 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Morocco
    {      8,     1,   162,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {79,77,82},       79,5 ,   1729,77 ,      13,5 ,       4,0 ,      97,7 ,     197,5 ,     3,     0,     6,     5,     6 }, // Arabic/Arabic/Oman
    {      8,     1,   165,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {73,76,83},       49,1 ,  1057,133 ,      13,5 ,       4,0 ,      97,7 ,    202,18 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Palestinian Territories
    {      8,     1,   175,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {81,65,82},       84,5 ,   1806,70 ,      13,5 ,       4,0 ,      97,7 ,     220,3 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Qatar
    {      8,     1,   186,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {83,65,82},       89,5 ,   1876,77 ,      13,5 ,       4,0 ,      97,7 ,    223,24 ,     2,     1,     7,     5,     6 }, // Arabic/Arabic/Saudi Arabia
    {      8,     1,   194,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {83,79,83},       94,1 ,   1953,77 ,      13,5 ,       4,0 ,      97,7 ,     247,7 ,     0,     0,     1,     6,     7 }, // Arabic/Arabic/Somalia
    {      8,     1,   201,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {83,68,71},       95,4 ,   2030,91 ,      13,5 ,       4,0 ,      97,7 ,     254,7 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/Sudan
    {      8,     1,   207,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {83,89,80},       99,5 ,   2121,77 ,      13,5 ,       4,0 ,      97,7 ,     261,5 ,     0,     0,     6,     5,     6 }, // Arabic/Arabic/Syria
    {      8,     1,   216,    44,    46,    59,    37,    48,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {84,78,68},      104,5 ,   2198,95 ,      13,5 ,       4,0 ,      97,7 ,     266,4 ,     3,     0,     1,     6,     7 }, // Arabic/Arabic/Tunisia
    {      8,     1,   223,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {65,69,68},      109,5 ,   2293,91 ,      13,5 ,       4,0 ,      97,7 ,    270,24 ,     2,     1,     6,     5,     6 }, // Arabic/Arabic/United Arab Emirates
    {      8,     1,   236,    46,    44,    59,    37,    48,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {77,65,68},       74,5 ,   1642,87 ,      13,5 ,       4,0 ,      97,7 ,    294,15 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/Western Sahara
    {      8,     1,   237,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {89,69,82},      114,5 ,   2384,70 ,      13,5 ,       4,0 ,      97,7 ,     309,5 ,     0,     0,     7,     5,     6 }, // Arabic/Arabic/Yemen
    {      8,     1,   254,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 , {83,83,80},      119,1 ,  2454,132 ,      13,5 ,       4,0 ,      97,7 ,    314,12 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/South Sudan
    {      8,     1,   260,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8221,    8220,    8217,    8216,      46,6 ,      46,6 ,      46,6 ,      46,6 ,    129,10 ,    139,17 ,      18,7 ,     25,12 ,    508,52 ,    508,52 ,    560,14 ,    508,52 ,    508,52 ,    560,14 ,      21,1 ,      21,1 ,   84,4 ,  88,47 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,      13,5 ,       4,0 ,    326,22 ,     348,6 ,     2,     1,     1,     6,     7 }, // Arabic/Arabic/World
    {      9,    10,    11,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,      52,7 ,      52,7 ,     156,8 ,    164,20 ,      37,5 ,      8,10 ,    574,28 ,    602,62 ,    664,14 ,    574,28 ,    602,62 ,    664,14 ,       0,2 ,       0,2 ,  135,6 , 141,17 ,  22,23 , {65,77,68},      120,1 ,   2586,46 ,      13,5 ,       4,0 ,     354,7 ,     361,8 ,     2,     0,     1,     6,     7 }, // Armenian/Armenian/Armenia
    {     10,    11,   100,    46,    44,    59,    37,  2534,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,      59,9 ,      59,9 ,     184,8 ,    192,18 ,      68,7 ,     75,12 ,    678,32 ,    710,58 ,    768,14 ,    678,32 ,    710,58 ,    768,14 ,      22,9 ,      22,7 ,  158,4 , 162,37 ,  22,23 , {73,78,82},      121,1 ,   2632,43 ,       8,5 ,       4,0 ,     369,7 ,     376,4 ,     2,     1,     7,     7,     7 }, // Assamese/Bengali/India
    {     12,     7,    15,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,      68,8 ,      68,8 ,     156,8 ,    210,17 ,      37,5 ,      8,10 ,    782,27 ,    809,67 ,     99,14 ,    876,27 ,    809,67 ,     99,14 ,       0,2 ,       0,2 ,  199,4 ,   5,17 ,  22,23 , {65,90,78},      122,1 ,   2675,58 ,      13,5 ,       4,0 ,    380,10 ,    390,10 ,     2,     1,     1,     6,     7 }, // Azerbaijani/Latin/Azerbaijan
    {     12,     1,   102,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,82,82},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     6,     5,     5 }, // Azerbaijani/Arabic/Iran
    {     12,     2,    15,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     156,8 ,    210,17 ,      37,5 ,      8,10 ,    903,27 ,    930,67 ,     99,14 ,    903,27 ,    930,67 ,     99,14 ,      31,2 ,      29,2 ,   45,4 ,   5,17 ,  22,23 , {65,90,78},      122,1 ,   2733,12 ,      13,5 ,       4,0 ,    400,10 ,    410,10 ,     2,     1,     1,     6,     7 }, // Azerbaijani/Cyrillic/Azerbaijan
    {     13,     2,   178,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      123,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Bashkir/Cyrillic/Russia
    {     14,     7,   197,    44,    46,    59,    37,    48,  8722,    43,   101,    8220,    8221,    8220,    8221,       0,6 ,       0,6 ,      76,9 ,      76,9 ,     227,6 ,    233,36 ,      37,5 ,     87,12 ,    997,28 ,   1025,68 ,   1093,14 ,    997,28 ,   1025,68 ,   1093,14 ,       0,2 ,       0,2 ,  203,7 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   2745,20 ,      13,5 ,       4,0 ,     420,7 ,     427,8 ,     2,     1,     1,     6,     7 }, // Basque/Latin/Spain
    {     15,    11,    18,    46,    44,    59,    37,  2534,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,      85,9 ,      85,9 ,     269,6 ,    192,18 ,      18,7 ,     25,12 ,   1107,37 ,   1144,58 ,   1202,18 ,   1107,37 ,   1144,58 ,   1202,18 ,       0,2 ,       0,2 ,  158,4 ,   5,17 ,  22,23 , {66,68,84},      124,1 ,   2765,49 ,       0,4 ,       4,0 ,     435,5 ,     440,8 ,     2,     1,     7,     6,     7 }, // Bengali/Bengali/Bangladesh
    {     15,    11,   100,    46,    44,    59,    37,  2534,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,      85,9 ,      85,9 ,     269,6 ,    192,18 ,      18,7 ,     25,12 ,   1107,37 ,   1144,58 ,   1202,18 ,   1107,37 ,   1144,58 ,   1202,18 ,       0,2 ,       0,2 ,  158,4 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,   2814,43 ,       0,4 ,       4,0 ,     435,5 ,     448,4 ,     2,     1,     7,     7,     7 }, // Bengali/Bengali/India
    {     16,    31,    25,    46,    44,    59,    37,  3872,    45,    43,   101,    8220,    8221,    8216,    8217,      94,9 ,      94,9 ,      94,9 ,      94,9 ,     53,10 ,    275,30 ,     99,22 ,    121,27 ,   1220,34 ,   1254,79 ,   1333,27 ,   1220,34 ,   1254,79 ,   1333,27 ,      33,5 ,      31,6 ,   45,4 ,   5,17 ,  22,23 , {66,84,78},      125,3 ,   2857,15 ,       4,4 ,       4,0 ,     452,6 ,     458,5 ,     2,     1,     7,     6,     7 }, // Dzongkha/Tibetan/Bhutan
    {     19,     7,    74,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     103,8 ,     103,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   1360,33 ,   1393,43 ,   1436,18 ,   1360,33 ,   1393,43 ,   1436,18 ,      38,4 ,      37,4 ,  210,7 , 217,17 , 234,23 , {69,85,82},       14,1 ,   2872,36 ,      13,5 ,       4,0 ,     463,9 ,     472,5 ,     2,     1,     1,     6,     7 }, // Breton/Latin/France
    {     20,     2,    33,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8220,    8222,    8220,       0,6 ,       0,6 ,     111,7 ,     111,7 ,    305,12 ,    317,22 ,      55,4 ,      59,9 ,   1454,21 ,   1475,55 ,   1530,14 ,   1454,21 ,   1475,55 ,   1530,14 ,      42,6 ,      41,6 ,  257,7 ,   5,17 ,  22,23 , {66,71,78},      128,3 ,   2908,47 ,      13,5 ,       4,0 ,     477,9 ,     486,8 ,     2,     1,     1,     6,     7 }, // Bulgarian/Cyrillic/Bulgaria
    {     21,    25,   147,    46,    44,  4170,    37,  4160,    45,    43,   101,    8220,    8221,    8216,    8217,     118,5 ,     118,5 ,    123,10 ,    123,10 ,     339,8 ,    347,18 ,     148,6 ,    154,10 ,   1544,54 ,   1544,54 ,   1598,14 ,   1544,54 ,   1544,54 ,   1598,14 ,      48,5 ,      47,3 ,  264,5 ,   5,17 ,  22,23 , {77,77,75},      131,1 ,   2955,29 ,      13,5 ,       4,0 ,     494,6 ,     494,6 ,     0,     0,     7,     6,     7 }, // Burmese/Myanmar/Myanmar
    {     22,     2,    20,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     133,7 ,     133,7 ,     365,7 ,    317,22 ,      37,5 ,    164,11 ,   1612,21 ,   1633,56 ,   1689,14 ,   1612,21 ,   1633,56 ,   1689,14 ,       0,2 ,       0,2 ,  269,5 , 274,17 ,  22,23 , {66,89,78},        0,2 ,   2984,89 ,      13,5 ,       4,0 ,    500,10 ,     510,8 ,     2,     0,     1,     6,     7 }, // Belarusian/Cyrillic/Belarus
    {     23,    20,    36,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     140,9 ,     149,9 ,     269,6 ,     97,16 ,      18,7 ,     25,12 ,   1703,40 ,   1743,46 ,   1789,14 ,   1703,40 ,   1803,47 ,   1789,14 ,       0,2 ,       0,2 ,  291,2 ,   5,17 ,  22,23 , {75,72,82},      132,1 ,   3073,29 ,       0,4 ,       4,0 ,     518,5 ,     523,7 ,     2,     1,     7,     6,     7 }, // Khmer/Khmer/Cambodia
    {     24,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     158,7 ,     158,7 ,     269,6 ,    372,22 ,      55,4 ,      59,9 ,   1850,28 ,   1878,60 ,   1938,21 ,   1850,28 ,   1878,60 ,   1938,21 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,     530,6 ,     536,7 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/Spain
    {     24,     7,     5,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     158,7 ,     158,7 ,     269,6 ,    372,22 ,      55,4 ,      59,9 ,   1850,28 ,   1878,60 ,   1938,21 ,   1850,28 ,   1878,60 ,   1938,21 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,     530,6 ,     543,7 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/Andorra
    {     24,     7,    74,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     158,7 ,     158,7 ,     269,6 ,    372,22 ,      55,4 ,      59,9 ,   1850,28 ,   1878,60 ,   1938,21 ,   1850,28 ,   1878,60 ,   1938,21 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,     530,6 ,     550,6 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/France
    {     24,     7,   106,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     158,7 ,     158,7 ,     269,6 ,    372,22 ,      55,4 ,      59,9 ,   1850,28 ,   1878,60 ,   1938,21 ,   1850,28 ,   1878,60 ,   1938,21 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,     530,6 ,     556,6 ,     2,     1,     1,     6,     7 }, // Catalan/Latin/Italy
    {     25,     5,    44,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     165,5 ,     165,5 ,     170,5 ,     170,5 ,     394,8 ,    402,13 ,     175,6 ,    181,11 ,   1959,21 ,   1980,28 ,   2008,14 ,   1959,21 ,   1980,28 ,   2008,14 ,      58,2 ,      55,2 ,  293,2 , 295,21 ,  22,23 , {67,78,89},      133,1 ,   3122,13 ,       4,4 ,       4,0 ,     562,4 ,     566,2 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/China
    {     25,     5,    97,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     165,5 ,     165,5 ,     170,5 ,     170,5 ,     269,6 ,    402,13 ,     175,6 ,    181,11 ,   1959,21 ,   1980,28 ,   2008,14 ,   1959,21 ,   1980,28 ,   2008,14 ,      58,2 ,      55,2 ,  293,2 , 295,21 ,  22,23 , {72,75,68},      134,3 ,   3135,11 ,       4,4 ,       4,0 ,     562,4 ,     568,9 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/Hong Kong
    {     25,     5,   126,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     165,5 ,     165,5 ,     170,5 ,     170,5 ,     269,6 ,    402,13 ,     175,6 ,    181,11 ,   1959,21 ,   1980,28 ,   2008,14 ,   1959,21 ,   1980,28 ,   2008,14 ,      58,2 ,      55,2 ,  293,2 , 295,21 ,  22,23 , {77,79,80},      137,4 ,   3146,13 ,       4,4 ,       4,0 ,     562,4 ,     577,9 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/Macau
    {     25,     5,   190,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     165,5 ,     165,5 ,     170,5 ,     170,5 ,      27,8 ,    402,13 ,     175,6 ,    181,11 ,   1959,21 ,   1980,28 ,   2008,14 ,   1959,21 ,   1980,28 ,   2008,14 ,      58,2 ,      55,2 ,  293,2 , 295,21 ,  22,23 , {83,71,68},        6,1 ,   3159,15 ,       4,4 ,       4,0 ,     562,4 ,     586,3 ,     2,     1,     7,     6,     7 }, // Chinese/Simplified Han/Singapore
    {     25,     6,    97,    46,    44,    59,    37,    48,    45,    43,   101,   12300,   12301,   12302,   12303,     165,5 ,     165,5 ,     175,5 ,     175,5 ,     415,8 ,    402,13 ,     175,6 ,    192,13 ,   2022,21 ,   1980,28 ,   2008,14 ,   2022,21 ,   1980,28 ,   2008,14 ,      58,2 ,      55,2 ,  316,3 ,   5,17 ,  22,23 , {72,75,68},      134,3 ,   3135,11 ,      18,5 ,       4,0 ,     589,4 ,     593,9 ,     2,     1,     7,     6,     7 }, // Chinese/Traditional Han/Hong Kong
    {     25,     6,   126,    46,    44,    59,    37,    48,    45,    43,   101,   12300,   12301,   12302,   12303,     165,5 ,     165,5 ,     175,5 ,     175,5 ,     415,8 ,    402,13 ,     175,6 ,    192,13 ,   2022,21 ,   1980,28 ,   2008,14 ,   2022,21 ,   1980,28 ,   2008,14 ,      58,2 ,      55,2 ,  316,3 ,   5,17 ,  22,23 , {77,79,80},      137,4 ,   3174,13 ,      18,5 ,       4,0 ,     589,4 ,     602,9 ,     2,     1,     7,     6,     7 }, // Chinese/Traditional Han/Macau
    {     25,     6,   208,    46,    44,    59,    37,    48,    45,    43,   101,   12300,   12301,   12302,   12303,     165,5 ,     165,5 ,     170,5 ,     170,5 ,     394,8 ,    423,14 ,     175,6 ,    192,13 ,   2022,21 ,   1980,28 ,   2008,14 ,   2022,21 ,   1980,28 ,   2008,14 ,      58,2 ,      55,2 ,   45,4 ,   5,17 ,  22,23 , {84,87,68},        6,1 ,   3187,13 ,       4,4 ,       4,0 ,     589,4 ,     611,2 ,     2,     0,     7,     6,     7 }, // Chinese/Traditional Han/Taiwan
    {     26,     7,    74,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Corsican/Latin/France
    {     27,     7,    54,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     158,7 ,     158,7 ,    437,13 ,    450,19 ,      37,5 ,     87,12 ,   2043,28 ,   2071,58 ,   2129,14 ,   2043,28 ,   2071,58 ,   2143,14 ,       0,2 ,       0,2 ,  319,7 ,   5,17 ,  22,23 , {72,82,75},      141,3 ,   3200,60 ,      13,5 ,       4,0 ,     613,8 ,     621,8 ,     2,     1,     1,     6,     7 }, // Croatian/Latin/Croatia
    {     27,     7,    27,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     158,7 ,     158,7 ,     469,9 ,    450,19 ,      37,5 ,     87,12 ,   2043,28 ,   2071,58 ,   2143,14 ,   2043,28 ,   2071,58 ,   2143,14 ,       0,2 ,       0,2 ,  319,7 ,   5,17 ,  22,23 , {66,65,77},      144,2 ,   3260,85 ,      13,5 ,       4,0 ,     613,8 ,    629,19 ,     2,     1,     1,     6,     7 }, // Croatian/Latin/Bosnia And Herzegowina
    {     28,     7,    57,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     180,7 ,     180,7 ,     156,8 ,    478,17 ,      55,4 ,      59,9 ,   2157,21 ,   2178,49 ,   2227,14 ,   2157,21 ,   2178,49 ,   2227,14 ,      60,4 ,      57,4 ,  326,5 ,   5,17 ,  22,23 , {67,90,75},      146,2 ,   3345,68 ,      13,5 ,       4,0 ,     648,7 ,     655,5 ,     2,     0,     1,     6,     7 }, // Czech/Latin/Czech Republic
    {     29,     7,    58,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     187,8 ,     187,8 ,    495,10 ,    505,23 ,     205,5 ,    210,10 ,   2241,28 ,   2269,51 ,   2320,14 ,   2334,35 ,   2269,51 ,   2320,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {68,75,75},      148,3 ,   3413,42 ,      13,5 ,       4,0 ,     660,5 ,     665,7 ,     2,     0,     1,     6,     7 }, // Danish/Latin/Denmark
    {     29,     7,    86,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     187,8 ,     187,8 ,    495,10 ,    505,23 ,     205,5 ,    210,10 ,   2241,28 ,   2269,51 ,   2320,14 ,   2334,35 ,   2269,51 ,   2320,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {68,75,75},      148,3 ,   3413,42 ,      13,5 ,       4,0 ,     660,5 ,     672,8 ,     2,     0,     1,     6,     7 }, // Danish/Latin/Greenland
    {     30,     7,   151,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,    528,10 ,     97,16 ,      37,5 ,      8,10 ,   2369,21 ,   2390,59 ,   2449,14 ,   2369,21 ,   2390,59 ,   2449,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3455,19 ,      13,5 ,       4,0 ,    680,10 ,     690,9 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Netherlands
    {     30,     7,    12,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,    528,10 ,     97,16 ,      37,5 ,      8,10 ,   2369,21 ,   2390,59 ,   2449,14 ,   2369,21 ,   2390,59 ,   2449,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {65,87,71},      151,4 ,   3474,55 ,      13,5 ,       4,0 ,    680,10 ,     699,5 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Aruba
    {     30,     7,    21,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     538,9 ,     97,16 ,      37,5 ,      8,10 ,   2369,21 ,   2390,59 ,   2449,14 ,   2369,21 ,   2390,59 ,   2449,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3455,19 ,      13,5 ,       4,0 ,    680,10 ,     704,6 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Belgium
    {     30,     7,   152,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,    528,10 ,     97,16 ,      37,5 ,      8,10 ,   2369,21 ,   2390,59 ,   2449,14 ,   2369,21 ,   2390,59 ,   2449,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {65,78,71},      155,4 ,   3529,97 ,      13,5 ,       4,0 ,    680,10 ,     710,7 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Cura Sao
    {     30,     7,   202,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,    528,10 ,     97,16 ,      37,5 ,      8,10 ,   2369,21 ,   2390,59 ,   2449,14 ,   2369,21 ,   2390,59 ,   2449,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {83,82,68},        6,1 ,   3626,58 ,      13,5 ,       4,0 ,    680,10 ,     717,8 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Suriname
    {     30,     7,   255,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,    528,10 ,     97,16 ,      37,5 ,      8,10 ,   2369,21 ,   2390,59 ,   2449,14 ,   2369,21 ,   2390,59 ,   2449,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3684,61 ,      13,5 ,       4,0 ,    680,10 ,    725,19 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Bonaire
    {     30,     7,   256,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       6,8 ,       6,8 ,    528,10 ,     97,16 ,      37,5 ,      8,10 ,   2369,21 ,   2390,59 ,   2449,14 ,   2369,21 ,   2390,59 ,   2449,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {65,78,71},      155,4 ,   3529,97 ,      13,5 ,       4,0 ,    680,10 ,    744,12 ,     2,     1,     1,     6,     7 }, // Dutch/Latin/Sint Maarten
    {     31,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    195,10 ,     205,9 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,    756,16 ,    772,13 ,     2,     1,     7,     6,     7 }, // English/Latin/United States
    {     31,     3,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // English/Deseret/United States
    {     31,     7,     4,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    195,10 ,     205,9 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,    792,14 ,     2,     1,     7,     6,     7 }, // English/Latin/American Samoa
    {     31,     7,     7,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     785,7 ,     806,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Anguilla
    {     31,     7,     9,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     785,7 ,    814,17 ,     2,     1,     7,     6,     7 }, // English/Latin/Antigua And Barbuda
    {     31,     7,    13,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,     269,6 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,   2463,25 ,      0,28 ,     28,57 ,   2463,25 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,    831,18 ,     849,9 ,     2,     1,     7,     6,     7 }, // English/Latin/Australia
    {     31,     7,    14,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,       8,5 ,       4,0 ,     785,7 ,     858,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Austria
    {     31,     7,    16,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {66,83,68},        6,1 ,   3930,53 ,       4,4 ,       4,0 ,     785,7 ,     865,7 ,     2,     1,     7,     6,     7 }, // English/Latin/Bahamas
    {     31,     7,    19,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {66,66,68},        6,1 ,   3983,56 ,       4,4 ,       4,0 ,     785,7 ,     872,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Barbados
    {     31,     7,    21,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,      27,8 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,      13,5 ,       4,0 ,     785,7 ,     880,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Belgium
    {     31,     7,    22,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,      27,8 ,    553,18 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {66,90,68},        6,1 ,   4039,47 ,       4,4 ,       4,0 ,     785,7 ,     887,6 ,     2,     1,     7,     6,     7 }, // English/Latin/Belize
    {     31,     7,    24,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {66,77,68},        6,1 ,   4086,53 ,       4,4 ,       4,0 ,     785,7 ,     893,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Bermuda
    {     31,     7,    28,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,      27,8 ,    553,18 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {66,87,80},      162,1 ,   4139,50 ,       4,4 ,       4,0 ,     785,7 ,     900,8 ,     2,     1,     7,     6,     7 }, // English/Latin/Botswana
    {     31,     7,    31,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,    908,30 ,     2,     1,     1,     6,     7 }, // English/Latin/British Indian Ocean Territory
    {     31,     7,    35,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    195,10 ,     205,9 ,     547,6 ,     35,18 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {66,73,70},      163,3 ,   4189,53 ,       4,4 ,       4,0 ,     785,7 ,     938,7 ,     0,     0,     1,     6,     7 }, // English/Latin/Burundi
    {     31,     7,    37,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,   4242,83 ,       4,4 ,       4,0 ,     785,7 ,     945,8 ,     0,     0,     1,     6,     7 }, // English/Latin/Cameroon
    {     31,     7,    38,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    195,10 ,     205,9 ,     53,10 ,     35,18 ,      18,7 ,     25,12 ,   2488,35 ,     28,57 ,     85,14 ,   2488,35 ,     28,57 ,     85,14 ,      64,4 ,      61,4 ,    0,5 ,   5,17 ,  22,23 , {67,65,68},        6,1 ,   4325,53 ,       4,4 ,       4,0 ,    953,16 ,     969,6 ,     2,     0,     7,     6,     7 }, // English/Latin/Canada
    {     31,     7,    40,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {75,89,68},        6,1 ,   4378,71 ,       4,4 ,       4,0 ,     785,7 ,    975,14 ,     2,     1,     1,     6,     7 }, // English/Latin/Cayman Islands
    {     31,     7,    45,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,     785,7 ,    989,16 ,     2,     1,     1,     6,     7 }, // English/Latin/Christmas Island
    {     31,     7,    46,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,     785,7 ,   1005,23 ,     2,     1,     1,     6,     7 }, // English/Latin/Cocos Islands
    {     31,     7,    51,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {78,90,68},        6,1 ,   4449,62 ,       4,4 ,       4,0 ,     785,7 ,   1028,12 ,     2,     1,     1,     6,     7 }, // English/Latin/Cook Islands
    {     31,     7,    56,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,       4,4 ,       4,0 ,     785,7 ,    1040,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Cyprus
    {     31,     7,    58,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,     205,5 ,    210,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {68,75,75},      148,3 ,   4511,44 ,      13,5 ,       4,0 ,     785,7 ,    1046,7 ,     2,     0,     1,     6,     7 }, // English/Latin/Denmark
    {     31,     7,    60,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     785,7 ,    1053,8 ,     2,     1,     7,     6,     7 }, // English/Latin/Dominica
    {     31,     7,    67,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {69,82,78},       41,3 ,   4555,50 ,       4,4 ,       4,0 ,     785,7 ,    1061,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Eritrea
    {     31,     7,    70,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {70,75,80},      119,1 ,   4605,74 ,       4,4 ,       4,0 ,     785,7 ,   1068,16 ,     2,     1,     1,     6,     7 }, // English/Latin/Falkland Islands
    {     31,     7,    72,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {70,74,68},        6,1 ,   4679,47 ,       4,4 ,       4,0 ,     785,7 ,    1084,4 ,     2,     1,     1,     6,     7 }, // English/Latin/Fiji
    {     31,     7,    73,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,     220,4 ,     224,9 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,      13,5 ,       4,0 ,     785,7 ,    1088,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Finland
    {     31,     7,    75,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {71,66,80},      119,1 ,   4726,32 ,       4,4 ,       4,0 ,     785,7 ,    1095,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Guernsey
    {     31,     7,    80,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {71,77,68},      166,1 ,   4758,50 ,       4,4 ,       4,0 ,     785,7 ,    1103,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Gambia
    {     31,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,      13,5 ,       4,0 ,     785,7 ,    1109,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Germany
    {     31,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {71,72,83},      167,3 ,   4808,47 ,       4,4 ,       4,0 ,     785,7 ,    1116,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Ghana
    {     31,     7,    84,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {71,73,80},      119,1 ,   4855,53 ,       4,4 ,       4,0 ,     785,7 ,    1121,9 ,     2,     1,     1,     6,     7 }, // English/Latin/Gibraltar
    {     31,     7,    87,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     785,7 ,    1130,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Grenada
    {     31,     7,    89,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    195,10 ,     205,9 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,    1137,4 ,     2,     1,     7,     6,     7 }, // English/Latin/Guam
    {     31,     7,    93,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {71,89,68},        6,1 ,   4908,56 ,       4,4 ,       4,0 ,     785,7 ,    1141,6 ,     2,     0,     1,     6,     7 }, // English/Latin/Guyana
    {     31,     7,    97,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,     415,8 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {72,75,68},      134,3 ,   4964,56 ,       4,4 ,       4,0 ,     785,7 ,   1147,19 ,     2,     1,     7,     6,     7 }, // English/Latin/Hong Kong
    {     31,     7,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    195,10 ,     205,9 ,      27,8 ,    192,18 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,   5020,44 ,       4,4 ,       4,0 ,     785,7 ,    1166,5 ,     2,     1,     7,     7,     7 }, // English/Latin/India
    {     31,     7,   104,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      64,4 ,      61,4 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,       4,4 ,       4,0 ,     785,7 ,    1171,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Ireland
    {     31,     7,   105,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      55,4 ,      59,9 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {73,76,83},       49,1 ,   5064,62 ,       4,4 ,       4,0 ,     785,7 ,    1178,6 ,     2,     1,     7,     5,     6 }, // English/Latin/Israel
    {     31,     7,   107,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,     269,6 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {74,77,68},        6,1 ,   5126,53 ,       4,4 ,       4,0 ,     785,7 ,    1184,7 ,     2,     1,     7,     6,     7 }, // English/Latin/Jamaica
    {     31,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,   5179,53 ,       4,4 ,       4,0 ,     785,7 ,    1191,5 ,     2,     1,     7,     6,     7 }, // English/Latin/Kenya
    {     31,     7,   112,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,     785,7 ,    1196,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Kiribati
    {     31,     7,   120,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,   5232,61 ,       4,4 ,       4,0 ,     785,7 ,    1204,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Lesotho
    {     31,     7,   121,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {76,82,68},        6,1 ,   5293,53 ,       4,4 ,       4,0 ,     785,7 ,    1211,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Liberia
    {     31,     7,   126,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {77,79,80},      137,4 ,   5346,53 ,       4,4 ,       4,0 ,     785,7 ,   1218,15 ,     2,     1,     7,     6,     7 }, // English/Latin/Macau
    {     31,     7,   128,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {77,71,65},      170,2 ,   5399,54 ,       4,4 ,       4,0 ,     785,7 ,   1233,10 ,     0,     0,     1,     6,     7 }, // English/Latin/Madagascar
    {     31,     7,   129,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {77,87,75},      172,2 ,   5453,53 ,       4,4 ,       4,0 ,     785,7 ,    1243,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Malawi
    {     31,     7,   130,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {77,89,82},      174,2 ,   5506,59 ,       4,4 ,       4,0 ,     785,7 ,    1249,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Malaysia
    {     31,     7,   133,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,       4,4 ,       4,0 ,     785,7 ,    1257,5 ,     2,     1,     7,     6,     7 }, // English/Latin/Malta
    {     31,     7,   134,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    195,10 ,     205,9 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,   1262,16 ,     2,     1,     7,     6,     7 }, // English/Latin/Marshall Islands
    {     31,     7,   137,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {77,85,82},      176,2 ,   5565,53 ,       4,4 ,       4,0 ,     785,7 ,    1278,9 ,     2,     0,     1,     6,     7 }, // English/Latin/Mauritius
    {     31,     7,   140,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,   1287,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Micronesia
    {     31,     7,   144,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     785,7 ,   1297,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Montserrat
    {     31,     7,   148,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {78,65,68},        6,1 ,   5618,53 ,       4,4 ,       4,0 ,     785,7 ,    1307,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Namibia
    {     31,     7,   149,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,     785,7 ,    1314,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Nauru
    {     31,     7,   151,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,       8,5 ,      23,6 ,     785,7 ,   1319,11 ,     2,     1,     1,     6,     7 }, // English/Latin/Netherlands
    {     31,     7,   154,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,     571,7 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {78,90,68},        6,1 ,   4449,62 ,       4,4 ,       4,0 ,     785,7 ,   1330,11 ,     2,     1,     1,     6,     7 }, // English/Latin/New Zealand
    {     31,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {78,71,78},      178,1 ,   5671,50 ,       4,4 ,       4,0 ,     785,7 ,    1341,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Nigeria
    {     31,     7,   158,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {78,90,68},        6,1 ,   4449,62 ,       4,4 ,       4,0 ,     785,7 ,    1348,4 ,     2,     1,     1,     6,     7 }, // English/Latin/Niue
    {     31,     7,   159,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,     785,7 ,   1352,14 ,     2,     1,     1,     6,     7 }, // English/Latin/Norfolk Island
    {     31,     7,   160,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    195,10 ,     205,9 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,   1366,24 ,     2,     1,     1,     6,     7 }, // English/Latin/Northern Mariana Islands
    {     31,     7,   163,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {80,75,82},      176,2 ,   5721,53 ,       4,4 ,       4,0 ,     785,7 ,    1390,8 ,     2,     0,     7,     6,     7 }, // English/Latin/Pakistan
    {     31,     7,   164,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,    1398,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Palau
    {     31,     7,   167,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {80,71,75},      131,1 ,   5774,73 ,       4,4 ,       4,0 ,     785,7 ,   1403,16 ,     2,     1,     1,     6,     7 }, // English/Latin/Papua New Guinea
    {     31,     7,   170,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {80,72,80},      179,1 ,   5847,53 ,       4,4 ,       4,0 ,     785,7 ,   1419,11 ,     2,     1,     7,     6,     7 }, // English/Latin/Philippines
    {     31,     7,   171,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {78,90,68},        6,1 ,   4449,62 ,       4,4 ,       4,0 ,     785,7 ,   1430,16 ,     2,     1,     1,     6,     7 }, // English/Latin/Pitcairn
    {     31,     7,   174,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    195,10 ,     205,9 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,   1446,11 ,     2,     1,     7,     6,     7 }, // English/Latin/Puerto Rico
    {     31,     7,   179,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {82,87,70},      180,2 ,   5900,47 ,       4,4 ,       4,0 ,     785,7 ,    1457,6 ,     0,     0,     1,     6,     7 }, // English/Latin/Rwanda
    {     31,     7,   180,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     785,7 ,   1463,16 ,     2,     1,     1,     6,     7 }, // English/Latin/Saint Kitts And Nevis
    {     31,     7,   181,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     785,7 ,    1479,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Saint Lucia
    {     31,     7,   182,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {88,67,68},        6,1 ,   3780,71 ,       4,4 ,       4,0 ,     785,7 ,   1487,23 ,     2,     1,     1,     6,     7 }, // English/Latin/Saint Vincent And The Grenadines
    {     31,     7,   183,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {87,83,84},      182,3 ,   5947,40 ,       4,4 ,       4,0 ,     785,7 ,    1510,5 ,     2,     1,     7,     6,     7 }, // English/Latin/Samoa
    {     31,     7,   188,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {83,67,82},      185,2 ,   5987,59 ,       4,4 ,       4,0 ,     785,7 ,   1515,10 ,     2,     1,     1,     6,     7 }, // English/Latin/Seychelles
    {     31,     7,   189,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {83,76,76},      187,2 ,   6046,68 ,       4,4 ,       4,0 ,     785,7 ,   1525,12 ,     0,     0,     1,     6,     7 }, // English/Latin/Sierra Leone
    {     31,     7,   190,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,     269,6 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {83,71,68},        6,1 ,   6114,56 ,       4,4 ,       4,0 ,     785,7 ,    1537,9 ,     2,     1,     7,     6,     7 }, // English/Latin/Singapore
    {     31,     7,   192,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3910,20 ,      13,5 ,      29,7 ,     785,7 ,    1546,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Slovenia
    {     31,     7,   193,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {83,66,68},        6,1 ,   6170,74 ,       4,4 ,       4,0 ,     785,7 ,   1554,15 ,     2,     1,     1,     6,     7 }, // English/Latin/Solomon Islands
    {     31,     7,   195,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    578,10 ,    553,18 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,   5232,61 ,       4,4 ,       4,0 ,     785,7 ,   1569,12 ,     2,     1,     7,     6,     7 }, // English/Latin/South Africa
    {     31,     7,   199,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {83,72,80},      119,1 ,   6244,53 ,       4,4 ,       4,0 ,     785,7 ,    1581,9 ,     2,     1,     1,     6,     7 }, // English/Latin/Saint Helena
    {     31,     7,   201,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {83,68,71},        0,0 ,   6297,50 ,       4,4 ,       4,0 ,     785,7 ,    1590,5 ,     2,     1,     6,     5,     6 }, // English/Latin/Sudan
    {     31,     7,   204,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {83,90,76},      189,1 ,   6347,53 ,       4,4 ,       4,0 ,     785,7 ,    1595,8 ,     2,     1,     1,     6,     7 }, // English/Latin/Swaziland
    {     31,     7,   205,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,     53,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {83,69,75},      190,2 ,   6400,47 ,      13,5 ,       4,0 ,     785,7 ,    1603,6 ,     2,     0,     1,     6,     7 }, // English/Latin/Sweden
    {     31,     7,   206,    46,  8217,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {67,72,70},        0,0 ,   6447,41 ,       8,5 ,      36,5 ,     785,7 ,   1609,11 ,     2,     0,     1,     6,     7 }, // English/Latin/Switzerland
    {     31,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {84,90,83},      192,3 ,   6488,62 ,       4,4 ,       4,0 ,     785,7 ,    1620,8 ,     2,     0,     1,     6,     7 }, // English/Latin/Tanzania
    {     31,     7,   213,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {78,90,68},        6,1 ,   4449,62 ,       4,4 ,       4,0 ,     785,7 ,    1628,7 ,     2,     1,     1,     6,     7 }, // English/Latin/Tokelau
    {     31,     7,   214,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {84,79,80},      195,2 ,   6550,49 ,       4,4 ,       4,0 ,     785,7 ,    1635,5 ,     2,     1,     1,     6,     7 }, // English/Latin/Tonga
    {     31,     7,   215,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {84,84,68},        6,1 ,   6599,80 ,       4,4 ,       4,0 ,     785,7 ,   1640,17 ,     2,     1,     7,     6,     7 }, // English/Latin/Trinidad And Tobago
    {     31,     7,   219,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,   1657,22 ,     2,     1,     1,     6,     7 }, // English/Latin/Turks And Caicos Islands
    {     31,     7,   220,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {65,85,68},        6,1 ,   3851,59 ,       4,4 ,       4,0 ,     785,7 ,    1679,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Tuvalu
    {     31,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {85,71,88},      197,3 ,   6679,56 ,       4,4 ,       4,0 ,     785,7 ,    1685,6 ,     0,     0,     1,     7,     7 }, // English/Latin/Uganda
    {     31,     7,   223,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    195,10 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {65,69,68},      200,3 ,   6735,55 ,       4,4 ,       4,0 ,     785,7 ,   1691,20 ,     2,     1,     6,     5,     6 }, // English/Latin/United Arab Emirates
    {     31,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {71,66,80},      119,1 ,   6790,47 ,       4,4 ,       4,0 ,   1711,15 ,   1726,14 ,     2,     1,     1,     6,     7 }, // English/Latin/United Kingdom
    {     31,     7,   226,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    195,10 ,     205,9 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,   1740,21 ,     2,     1,     7,     6,     7 }, // English/Latin/United States Minor Outlying Islands
    {     31,     7,   229,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {86,85,86},      203,2 ,   6837,44 ,       4,4 ,       4,0 ,     785,7 ,    1761,7 ,     0,     0,     1,     6,     7 }, // English/Latin/Vanuatu
    {     31,     7,   233,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,   1768,22 ,     2,     1,     1,     6,     7 }, // English/Latin/British Virgin Islands
    {     31,     7,   234,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    195,10 ,     205,9 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,   1790,19 ,     2,     1,     7,     6,     7 }, // English/Latin/United States Virgin Islands
    {     31,     7,   239,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {90,77,87},      131,1 ,   6881,50 ,       4,4 ,       4,0 ,     785,7 ,    1809,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Zambia
    {     31,     7,   240,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,     415,8 ,    553,18 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,    1815,8 ,     2,     1,     7,     6,     7 }, // English/Latin/Zimbabwe
    {     31,     7,   249,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,   3745,35 ,       4,4 ,       4,0 ,     785,7 ,   1823,12 ,     2,     1,     1,     6,     7 }, // English/Latin/Diego Garcia
    {     31,     7,   251,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {71,66,80},      119,1 ,   4726,32 ,       4,4 ,       4,0 ,     785,7 ,   1835,11 ,     2,     1,     1,     6,     7 }, // English/Latin/Isle Of Man
    {     31,     7,   252,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {71,66,80},      119,1 ,   4726,32 ,       4,4 ,       4,0 ,     785,7 ,    1846,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Jersey
    {     31,     7,   254,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {83,83,80},      119,1 ,   6931,68 ,       4,4 ,       4,0 ,     785,7 ,   1852,11 ,     2,     1,     1,     6,     7 }, // English/Latin/South Sudan
    {     31,     7,   256,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 , {65,78,71},      155,4 ,   6999,95 ,       4,4 ,       4,0 ,     785,7 ,   1863,12 ,     2,     1,     1,     6,     7 }, // English/Latin/Sint Maarten
    {     31,     7,   260,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,       4,4 ,       4,0 ,     785,7 ,    1875,5 ,     2,     1,     1,     6,     7 }, // English/Latin/World
    {     31,     7,   261,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     205,9 ,     205,9 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,      0,28 ,     28,57 ,     85,14 ,      0,28 ,     28,57 ,     85,14 ,      68,2 ,      65,2 ,    0,5 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,      13,5 ,       4,0 ,     785,7 ,    1880,6 ,     2,     1,     1,     6,     7 }, // English/Latin/Europe
    {     32,     7,   260,    44,   160,    59,    37,    48,  8722,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     214,9 ,     214,9 ,     588,8 ,    596,26 ,      37,5 ,    233,25 ,   2523,21 ,   2544,51 ,   2595,14 ,   2523,21 ,   2544,51 ,   2595,14 ,      70,3 ,      67,3 ,  331,6 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,      41,6 ,       4,0 ,    1886,9 ,    1895,5 ,     2,     1,     1,     6,     7 }, // Esperanto/Latin/World
    {     33,     7,    68,    44,   160,    59,    37,    48,  8722,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     223,8 ,     223,8 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,   2609,14 ,   2623,63 ,   2609,14 ,   2609,14 ,   2623,63 ,   2609,14 ,       0,2 ,       0,2 ,  337,6 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   7094,20 ,      13,5 ,       4,0 ,    1900,5 ,    1905,5 ,     2,     1,     1,     6,     7 }, // Estonian/Latin/Estonia
    {     34,     7,    71,    44,    46,    59,    37,    48,  8722,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     187,8 ,     187,8 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,   2686,28 ,   2714,74 ,   2788,14 ,   2802,35 ,   2714,74 ,   2788,14 ,       0,2 ,       0,2 ,  343,3 ,   5,17 ,  22,23 , {68,75,75},      190,2 ,   7114,43 ,      13,5 ,       4,0 ,    1910,8 ,    1918,7 ,     2,     0,     1,     6,     7 }, // Faroese/Latin/Faroe Islands
    {     34,     7,    58,    44,    46,    59,    37,    48,  8722,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     187,8 ,     187,8 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,   2686,28 ,   2714,74 ,   2788,14 ,   2802,35 ,   2714,74 ,   2788,14 ,       0,2 ,       0,2 ,  343,3 ,   5,17 ,  22,23 , {68,75,75},      148,3 ,   7114,43 ,      13,5 ,       4,0 ,    1910,8 ,     665,7 ,     2,     0,     1,     6,     7 }, // Faroese/Latin/Denmark
    {     36,     7,    73,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     223,8 ,     223,8 ,     640,8 ,    478,17 ,     220,4 ,     224,9 ,   2837,21 ,   2858,67 ,   2925,14 ,   2837,21 ,   2939,81 ,   2925,14 ,      73,3 ,      70,3 ,  346,5 , 351,17 , 368,23 , {69,85,82},       14,1 ,   7157,20 ,      13,5 ,       4,0 ,    1925,5 ,    1930,5 ,     2,     1,     1,     6,     7 }, // Finnish/Latin/Finland
    {     37,     7,    74,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1935,8 ,    1943,6 ,     2,     1,     1,     6,     7 }, // French/Latin/France
    {     37,     7,     3,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      18,7 ,     25,12 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {68,90,68},      205,2 ,   7177,51 ,      13,5 ,       4,0 ,    1935,8 ,    1949,7 ,     2,     1,     6,     5,     6 }, // French/Latin/Algeria
    {     37,     7,    21,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,     571,7 ,     97,16 ,      37,5 ,    258,23 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1935,8 ,    1956,8 ,     2,     1,     1,     6,     7 }, // French/Latin/Belgium
    {     37,     7,    23,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,79,70},      207,3 ,   7228,59 ,      13,5 ,       4,0 ,    1935,8 ,    1964,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Benin
    {     37,     7,    34,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,79,70},      207,3 ,   7228,59 ,      13,5 ,       4,0 ,    1935,8 ,   1969,12 ,     0,     0,     1,     6,     7 }, // French/Latin/Burkina Faso
    {     37,     7,    35,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {66,73,70},      163,3 ,   7287,53 ,      13,5 ,       4,0 ,    1935,8 ,     938,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Burundi
    {     37,     7,    37,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,      76,5 ,      73,4 ,  391,6 , 217,17 , 234,23 , {88,65,70},       32,4 ,   7340,56 ,      13,5 ,       4,0 ,    1935,8 ,    1981,8 ,     0,     0,     1,     6,     7 }, // French/Latin/Cameroon
    {     37,     7,    38,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8221,    8220,       0,6 ,       0,6 ,     231,8 ,     231,8 ,     53,10 ,     97,16 ,     281,9 ,    290,24 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,      64,4 ,      61,4 ,  391,6 , 217,17 , 234,23 , {67,65,68},        6,1 ,   7396,54 ,      47,6 ,       4,0 ,   1989,17 ,     969,6 ,     2,     0,     7,     6,     7 }, // French/Latin/Canada
    {     37,     7,    41,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,65,70},       32,4 ,   7340,56 ,      13,5 ,       4,0 ,    1935,8 ,   2006,25 ,     0,     0,     1,     6,     7 }, // French/Latin/Central African Republic
    {     37,     7,    42,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      18,7 ,     25,12 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,65,70},       32,4 ,   7340,56 ,      13,5 ,       4,0 ,    1935,8 ,    2031,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Chad
    {     37,     7,    48,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {75,77,70},       36,2 ,   7450,51 ,      13,5 ,       4,0 ,    1935,8 ,    2036,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Comoros
    {     37,     7,    49,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {67,68,70},      210,2 ,   7501,53 ,      13,5 ,       4,0 ,    1935,8 ,   2043,14 ,     2,     1,     1,     6,     7 }, // French/Latin/Congo Kinshasa
    {     37,     7,    50,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,65,70},       32,4 ,   7340,56 ,      13,5 ,       4,0 ,    1935,8 ,   2057,17 ,     0,     0,     1,     6,     7 }, // French/Latin/Congo Brazzaville
    {     37,     7,    53,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,79,70},      207,3 ,   7228,59 ,      13,5 ,       4,0 ,    1935,8 ,   2074,13 ,     0,     0,     1,     6,     7 }, // French/Latin/Ivory Coast
    {     37,     7,    59,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      18,7 ,     25,12 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {68,74,70},       38,3 ,   7554,57 ,      13,5 ,       4,0 ,    1935,8 ,    2087,8 ,     0,     0,     6,     6,     7 }, // French/Latin/Djibouti
    {     37,     7,    66,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,65,70},       32,4 ,   7340,56 ,      13,5 ,       4,0 ,    1935,8 ,   2095,18 ,     0,     0,     1,     6,     7 }, // French/Latin/Equatorial Guinea
    {     37,     7,    76,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1935,8 ,   2113,16 ,     2,     1,     1,     6,     7 }, // French/Latin/French Guiana
    {     37,     7,    77,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,80,70},      212,4 ,   7611,35 ,      13,5 ,       4,0 ,    1935,8 ,   2129,19 ,     0,     0,     1,     6,     7 }, // French/Latin/French Polynesia
    {     37,     7,    79,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,65,70},       32,4 ,   7340,56 ,      13,5 ,       4,0 ,    1935,8 ,    2148,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Gabon
    {     37,     7,    88,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1935,8 ,   2153,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Guadeloupe
    {     37,     7,    91,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {71,78,70},      216,2 ,   7646,48 ,      13,5 ,       4,0 ,    1935,8 ,    2163,6 ,     0,     0,     1,     6,     7 }, // French/Latin/Guinea
    {     37,     7,    94,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {72,84,71},      218,1 ,   7694,57 ,      13,5 ,       4,0 ,    1935,8 ,    2169,5 ,     2,     1,     1,     6,     7 }, // French/Latin/Haiti
    {     37,     7,   125,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1935,8 ,   2174,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Luxembourg
    {     37,     7,   128,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {77,71,65},      170,2 ,   7751,54 ,      13,5 ,       4,0 ,    1935,8 ,   1233,10 ,     0,     0,     1,     6,     7 }, // French/Latin/Madagascar
    {     37,     7,   132,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,79,70},      207,3 ,   7228,59 ,      13,5 ,       4,0 ,    1935,8 ,    2184,4 ,     0,     0,     1,     6,     7 }, // French/Latin/Mali
    {     37,     7,   135,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1935,8 ,   2188,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Martinique
    {     37,     7,   136,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      18,7 ,     25,12 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {77,82,85},      219,2 ,   7805,66 ,      13,5 ,       4,0 ,    1935,8 ,   2198,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Mauritania
    {     37,     7,   137,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {77,85,82},      176,2 ,   7871,63 ,      13,5 ,       4,0 ,    1935,8 ,    2208,7 ,     2,     0,     1,     6,     7 }, // French/Latin/Mauritius
    {     37,     7,   138,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1935,8 ,    2215,7 ,     2,     1,     1,     6,     7 }, // French/Latin/Mayotte
    {     37,     7,   142,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1935,8 ,    2222,6 ,     2,     1,     1,     6,     7 }, // French/Latin/Monaco
    {     37,     7,   145,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,      64,4 ,      61,4 ,  391,6 , 217,17 , 234,23 , {77,65,68},      221,3 ,   7934,54 ,      13,5 ,       4,0 ,    1935,8 ,    2228,5 ,     2,     1,     1,     6,     7 }, // French/Latin/Morocco
    {     37,     7,   153,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,80,70},      212,4 ,   7611,35 ,      13,5 ,       4,0 ,    1935,8 ,   2233,18 ,     0,     0,     1,     6,     7 }, // French/Latin/New Caledonia
    {     37,     7,   156,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,79,70},      207,3 ,   7228,59 ,      13,5 ,       4,0 ,    1935,8 ,    2251,5 ,     0,     0,     1,     6,     7 }, // French/Latin/Niger
    {     37,     7,   176,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1935,8 ,   2256,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Reunion
    {     37,     7,   179,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {82,87,70},      180,2 ,   7988,50 ,      13,5 ,       4,0 ,    1935,8 ,    1457,6 ,     0,     0,     1,     6,     7 }, // French/Latin/Rwanda
    {     37,     7,   187,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,79,70},      207,3 ,   7228,59 ,      13,5 ,       4,0 ,    1935,8 ,    2266,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Senegal
    {     37,     7,   188,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {83,67,82},      185,2 ,   8038,71 ,      13,5 ,       4,0 ,    1935,8 ,   1515,10 ,     2,     1,     1,     6,     7 }, // French/Latin/Seychelles
    {     37,     7,   200,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1935,8 ,   2273,24 ,     2,     1,     1,     6,     7 }, // French/Latin/Saint Pierre And Miquelon
    {     37,     7,   206,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,     231,8 ,     231,8 ,     156,8 ,     10,17 ,      37,5 ,    314,14 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {67,72,70},      224,3 ,   8109,45 ,      13,5 ,       4,0 ,   2297,15 ,    2312,6 ,     2,     0,     1,     6,     7 }, // French/Latin/Switzerland
    {     37,     7,   207,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      18,7 ,     25,12 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {83,89,80},      227,2 ,   8154,51 ,      13,5 ,       4,0 ,    1935,8 ,    2318,5 ,     0,     0,     6,     5,     6 }, // French/Latin/Syria
    {     37,     7,   212,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,79,70},      207,3 ,   7228,59 ,      13,5 ,       4,0 ,    1935,8 ,    2323,4 ,     0,     0,     1,     6,     7 }, // French/Latin/Togo
    {     37,     7,   216,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      18,7 ,     25,12 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {84,78,68},      229,2 ,   8205,51 ,      13,5 ,       4,0 ,    1935,8 ,    2327,7 ,     3,     0,     1,     6,     7 }, // French/Latin/Tunisia
    {     37,     7,   229,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      18,7 ,     25,12 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {86,85,86},      203,2 ,   8256,51 ,      13,5 ,       4,0 ,    1935,8 ,    1761,7 ,     0,     0,     1,     6,     7 }, // French/Latin/Vanuatu
    {     37,     7,   235,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {88,80,70},      212,4 ,   7611,35 ,      13,5 ,       4,0 ,    1935,8 ,   2334,16 ,     0,     0,     1,     6,     7 }, // French/Latin/Wallis And Futuna Islands
    {     37,     7,   244,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1935,8 ,   2350,16 ,     2,     1,     1,     6,     7 }, // French/Latin/Saint Barthelemy
    {     37,     7,   245,    44,  8239,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,     231,8 ,     231,8 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   3020,35 ,   3055,52 ,   3107,14 ,   3020,35 ,   3055,52 ,   3107,14 ,       0,2 ,       0,2 ,  391,6 , 217,17 , 234,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    1935,8 ,   2366,12 ,     2,     1,     1,     6,     7 }, // French/Latin/Saint Martin
    {     38,     7,   151,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       6,8 ,       6,8 ,     339,8 ,     97,16 ,      37,5 ,      8,10 ,   3121,21 ,   3142,54 ,     85,14 ,   3121,21 ,   3142,54 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3455,19 ,       8,5 ,      53,6 ,    2378,5 ,    2383,8 ,     2,     1,     1,     6,     7 }, // Western Frisian/Latin/Netherlands
    {     39,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    239,10 ,    239,10 ,    119,10 ,    648,21 ,      37,5 ,      8,10 ,   3196,28 ,   3224,69 ,   3293,14 ,   3196,28 ,   3224,69 ,   3293,14 ,      81,1 ,      77,1 ,  397,6 ,   5,17 ,  22,23 , {71,66,80},      119,1 ,   8307,86 ,       4,4 ,       4,0 ,    2391,8 ,   2399,22 ,     2,     1,     1,     6,     7 }, // Gaelic/Latin/United Kingdom
    {     40,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,    669,27 ,      37,5 ,      8,10 ,   3307,35 ,   3342,49 ,   3391,14 ,   3405,35 ,   3440,49 ,   3489,21 ,      64,4 ,      61,4 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    2421,6 ,    2427,6 ,     2,     1,     1,     6,     7 }, // Galician/Latin/Spain
    {     41,    15,    81,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8220,     171,     187,       0,6 ,       0,6 ,     256,8 ,     256,8 ,     156,8 ,    696,19 ,      37,5 ,      8,10 ,   3510,28 ,   3538,62 ,   3600,14 ,   3510,28 ,   3538,62 ,   3600,14 ,       0,2 ,       0,2 ,  403,5 , 408,37 ,  22,23 , {71,69,76},      231,1 ,   8393,43 ,      13,5 ,       4,0 ,    2433,7 ,   2440,10 ,     2,     1,     1,     6,     7 }, // Georgian/Georgian/Georgia
    {     42,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     264,9 ,     264,9 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,   3614,21 ,   3635,60 ,   3695,14 ,   3709,28 ,   3635,60 ,   3695,14 ,       0,2 ,       0,2 ,  445,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8436,19 ,      13,5 ,       4,0 ,    2450,7 ,   2457,11 ,     2,     1,     1,     6,     7 }, // German/Latin/Germany
    {     42,     7,    14,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     264,9 ,     264,9 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,   3614,21 ,   3635,60 ,   3695,14 ,   3709,28 ,   3635,60 ,   3695,14 ,       0,2 ,       0,2 ,  445,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8436,19 ,       8,5 ,       4,0 ,   2468,24 ,   2492,10 ,     2,     1,     1,     6,     7 }, // German/Latin/Austria
    {     42,     7,    21,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     264,9 ,     264,9 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,   3614,21 ,   3635,60 ,   3695,14 ,   3709,28 ,   3635,60 ,   3695,14 ,       0,2 ,       0,2 ,  445,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8436,19 ,      13,5 ,       4,0 ,    2450,7 ,    2502,7 ,     2,     1,     1,     6,     7 }, // German/Latin/Belgium
    {     42,     7,   106,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     264,9 ,     264,9 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,   3614,21 ,   3635,60 ,   3695,14 ,   3709,28 ,   3635,60 ,   3695,14 ,       0,2 ,       0,2 ,  445,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8436,19 ,      13,5 ,       4,0 ,    2450,7 ,    2509,7 ,     2,     1,     1,     6,     7 }, // German/Latin/Italy
    {     42,     7,   123,    46,  8217,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     264,9 ,     264,9 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,   3614,21 ,   3635,60 ,   3695,14 ,   3709,28 ,   3635,60 ,   3695,14 ,       0,2 ,       0,2 ,  445,5 ,   5,17 ,  22,23 , {67,72,70},      224,3 ,   8455,58 ,       8,5 ,       4,0 ,    2450,7 ,   2516,13 ,     2,     0,     1,     6,     7 }, // German/Latin/Liechtenstein
    {     42,     7,   125,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     264,9 ,     264,9 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,   3614,21 ,   3635,60 ,   3695,14 ,   3709,28 ,   3635,60 ,   3695,14 ,       0,2 ,       0,2 ,  445,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8436,19 ,      13,5 ,       4,0 ,    2450,7 ,    2529,9 ,     2,     1,     1,     6,     7 }, // German/Latin/Luxembourg
    {     42,     7,   206,    46,  8217,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     264,9 ,     264,9 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,   3614,21 ,   3635,60 ,   3695,14 ,   3709,28 ,   3635,60 ,   3695,14 ,       0,2 ,       0,2 ,  445,5 ,   5,17 ,  22,23 , {67,72,70},      224,3 ,   8455,58 ,       8,5 ,      36,5 ,   2538,21 ,    2559,7 ,     2,     0,     1,     6,     7 }, // German/Latin/Switzerland
    {     43,    16,    85,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     273,9 ,     273,9 ,     269,6 ,     10,17 ,      18,7 ,     25,12 ,   3737,28 ,   3765,55 ,   3820,14 ,   3737,28 ,   3765,55 ,   3820,14 ,      82,4 ,      78,4 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8513,19 ,      13,5 ,       4,0 ,    2566,8 ,    2574,6 ,     2,     1,     1,     6,     7 }, // Greek/Greek/Greece
    {     43,    16,    56,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     273,9 ,     273,9 ,     269,6 ,     10,17 ,      18,7 ,     25,12 ,   3737,28 ,   3765,55 ,   3820,14 ,   3737,28 ,   3765,55 ,   3820,14 ,      82,4 ,      78,4 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8513,19 ,      13,5 ,       4,0 ,    2566,8 ,    2580,6 ,     2,     1,     1,     6,     7 }, // Greek/Greek/Cyprus
    {     44,     7,    86,    44,    46,    59,    37,    48,  8722,    43,   101,     187,     171,    8250,    8249,       0,6 ,       0,6 ,    282,11 ,    282,11 ,     53,10 ,     80,17 ,     205,5 ,    210,10 ,   3834,28 ,   3862,98 ,   3960,14 ,   3834,28 ,   3862,98 ,   3960,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {68,75,75},      148,3 ,   8532,62 ,       4,4 ,      59,5 ,   2586,11 ,   2597,16 ,     2,     0,     1,     6,     7 }, // Greenlandic/Latin/Greenland
    {     45,     7,   168,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {80,89,71},      232,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     7,     6,     7 }, // Guarani/Latin/Paraguay
    {     46,    17,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     293,9 ,     293,9 ,     269,6 ,    192,18 ,     328,8 ,    336,13 ,   3974,32 ,   4006,53 ,   4059,19 ,   3974,32 ,   4006,53 ,   4059,19 ,       0,2 ,       0,2 ,  450,4 , 454,19 ,  22,23 , {73,78,82},      121,1 ,   8594,46 ,       4,4 ,       4,0 ,    2613,7 ,    2620,4 ,     2,     1,     7,     7,     7 }, // Gujarati/Gujarati/India
    {     47,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     302,8 ,     302,8 ,     269,6 ,    715,17 ,      37,5 ,      8,10 ,   4078,28 ,   4106,52 ,   4158,14 ,   4078,28 ,   4106,52 ,   4158,14 ,      86,6 ,      82,5 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      178,1 ,   8640,54 ,      64,6 ,       4,0 ,    2624,5 ,    2629,8 ,     2,     1,     1,     6,     7 }, // Hausa/Latin/Nigeria
    {     47,     1,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      178,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Hausa/Arabic/Nigeria
    {     47,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     302,8 ,     302,8 ,     269,6 ,    715,17 ,      18,7 ,     25,12 ,   4078,28 ,   4106,52 ,   4158,14 ,   4078,28 ,   4106,52 ,   4158,14 ,      86,6 ,      82,5 ,   45,4 ,   5,17 ,  22,23 , {71,72,83},      167,3 ,       0,7 ,      64,6 ,       4,0 ,    2624,5 ,    2637,4 ,     2,     1,     1,     6,     7 }, // Hausa/Latin/Ghana
    {     47,     7,   156,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     302,8 ,     302,8 ,     269,6 ,    715,17 ,      37,5 ,      8,10 ,   4078,28 ,   4106,52 ,   4158,14 ,   4078,28 ,   4106,52 ,   4158,14 ,      86,6 ,      82,5 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,   8694,36 ,      64,6 ,       4,0 ,    2624,5 ,    2641,5 ,     0,     0,     1,     6,     7 }, // Hausa/Latin/Niger
    {     48,    18,   105,    46,    44,    59,    37,    48,    45,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     310,6 ,     310,6 ,     640,8 ,    732,18 ,      55,4 ,      59,9 ,   4172,46 ,   4218,65 ,   4283,21 ,   4172,46 ,   4218,65 ,   4283,21 ,      92,6 ,      87,5 ,  473,4 ,   5,17 ,  22,23 , {73,76,83},       49,1 ,   8730,54 ,      70,6 ,      76,8 ,    2646,5 ,    2651,5 ,     2,     1,     7,     5,     6 }, // Hebrew/Hebrew/Israel
    {     49,    13,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     316,9 ,     325,8 ,     269,6 ,     10,17 ,      18,7 ,     25,12 ,   4304,32 ,   4336,53 ,   4389,19 ,   4304,32 ,   4336,53 ,   4389,19 ,      68,2 ,      65,2 ,  477,4 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,   8784,42 ,       4,4 ,       4,0 ,    2656,6 ,    2662,4 ,     2,     1,     7,     7,     7 }, // Hindi/Devanagari/India
    {     50,     7,    98,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,     187,     171,       0,6 ,       0,6 ,     333,8 ,     333,8 ,    750,13 ,    763,19 ,      55,4 ,      59,9 ,   4408,19 ,   4427,52 ,   4479,17 ,   4408,19 ,   4427,52 ,   4479,17 ,      98,3 ,      92,3 ,  481,4 ,   5,17 ,  22,23 , {72,85,70},      233,2 ,   8826,46 ,      13,5 ,       4,0 ,    2666,6 ,   2672,12 ,     2,     0,     1,     6,     7 }, // Hungarian/Latin/Hungary
    {     51,     7,    99,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     187,8 ,     187,8 ,     640,8 ,    622,18 ,      37,5 ,      8,10 ,   4496,35 ,   4531,81 ,   4612,14 ,   4496,35 ,   4531,81 ,   4612,14 ,     101,4 ,      95,4 ,  485,4 ,   5,17 ,  22,23 , {73,83,75},      235,3 ,   8872,49 ,      13,5 ,       4,0 ,    2684,8 ,    2692,6 ,     0,     0,     1,     6,     7 }, // Icelandic/Latin/Iceland
    {     52,     7,   101,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    341,10 ,     351,9 ,      27,8 ,    553,18 ,     205,5 ,    210,10 ,   4626,28 ,   4654,43 ,   4697,14 ,   4626,28 ,   4654,43 ,   4697,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,68,82},      238,2 ,   8921,39 ,       4,4 ,       4,0 ,    2698,9 ,    2698,9 ,     2,     0,     7,     6,     7 }, // Indonesian/Latin/Indonesia
    {     53,     7,   260,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,    528,10 ,    782,26 ,      37,5 ,      8,10 ,   4711,28 ,   4739,57 ,   4796,14 ,   4711,28 ,   4739,57 ,   4796,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,       8,5 ,       4,0 ,   2707,11 ,    2718,5 ,     2,     1,     1,     6,     7 }, // Interlingua/Latin/World
    {     55,    44,    38,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,65,68},      240,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     7,     6,     7 }, // Inuktitut/Canadian Aboriginal/Canada
    {     55,     7,    38,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,65,68},      240,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     7,     6,     7 }, // Inuktitut/Latin/Canada
    {     57,     7,   104,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    360,11 ,    239,10 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   4810,37 ,   4847,75 ,   4922,14 ,   4810,37 ,   4847,75 ,   4922,14 ,     105,4 ,      99,4 ,  489,6 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8960,31 ,       4,4 ,       4,0 ,    2723,7 ,    2730,4 ,     2,     1,     1,     6,     7 }, // Irish/Latin/Ireland
    {     57,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    360,11 ,    239,10 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,   4810,37 ,   4847,75 ,   4922,14 ,   4810,37 ,   4847,75 ,   4922,14 ,     105,4 ,      99,4 ,  489,6 ,   5,17 ,  22,23 , {71,66,80},      119,1 ,   8991,95 ,       4,4 ,       4,0 ,    2723,7 ,   2734,19 ,     2,     1,     1,     6,     7 }, // Irish/Latin/United Kingdom
    {     58,     7,   106,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,     97,16 ,      37,5 ,      8,10 ,   4936,28 ,   4964,57 ,   5021,14 ,   4936,28 ,   4964,57 ,   5021,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   9086,19 ,      13,5 ,       4,0 ,    2753,8 ,    2761,6 ,     2,     1,     1,     6,     7 }, // Italian/Latin/Italy
    {     58,     7,   184,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,     97,16 ,      37,5 ,      8,10 ,   4936,28 ,   4964,57 ,   5021,14 ,   4936,28 ,   4964,57 ,   5021,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   9086,19 ,      13,5 ,       4,0 ,    2753,8 ,   2767,10 ,     2,     1,     1,     6,     7 }, // Italian/Latin/San Marino
    {     58,     7,   206,    46,  8217,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,     249,7 ,     249,7 ,     156,8 ,     10,17 ,      37,5 ,      8,10 ,   4936,28 ,   4964,57 ,   5021,14 ,   4936,28 ,   4964,57 ,   5021,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,72,70},        0,0 ,   9105,53 ,       8,5 ,      36,5 ,    2753,8 ,    2777,8 ,     2,     0,     1,     6,     7 }, // Italian/Latin/Switzerland
    {     58,     7,   230,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,     97,16 ,      37,5 ,      8,10 ,   4936,28 ,   4964,57 ,   5021,14 ,   4936,28 ,   4964,57 ,   5021,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   9086,19 ,      13,5 ,       4,0 ,    2753,8 ,   2785,18 ,     2,     1,     1,     6,     7 }, // Italian/Latin/Vatican City State
    {     59,    19,   108,    46,    44,    59,    37,    48,    45,    43,   101,   12300,   12301,   12302,   12303,     165,5 ,     165,5 ,     165,5 ,     165,5 ,    578,10 ,    402,13 ,      55,4 ,    349,10 ,   5035,14 ,   5049,28 ,   5035,14 ,   5035,14 ,   5049,28 ,   5035,14 ,     109,2 ,     103,2 ,  495,3 , 498,17 ,  22,23 , {74,80,89},      243,1 ,   9158,11 ,       4,4 ,       4,0 ,    2803,3 ,    2806,2 ,     0,     0,     7,     6,     7 }, // Japanese/Japanese/Japan
    {     60,     7,   101,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    371,10 ,     381,9 ,    528,10 ,     10,17 ,      37,5 ,      8,10 ,   5077,29 ,   5106,41 ,   5147,14 ,   5077,29 ,   5106,41 ,   5147,14 ,     111,4 ,     105,5 ,  515,4 ,   5,17 ,  22,23 , {73,68,82},      238,2 ,   8921,39 ,       8,5 ,       4,0 ,    2808,4 ,    2812,9 ,     2,     0,     7,     6,     7 }, // Javanese/Latin/Indonesia
    {     61,    21,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    390,12 ,    402,11 ,     269,6 ,     35,18 ,     328,8 ,    336,13 ,   5161,33 ,   5194,54 ,   5248,20 ,   5161,33 ,   5194,54 ,   5248,20 ,     115,9 ,     110,7 ,  519,8 , 527,35 ,  22,23 , {73,78,82},      121,1 ,   9169,49 ,       4,4 ,       4,0 ,    2821,5 ,    2826,4 ,     2,     1,     7,     7,     7 }, // Kannada/Kannada/India
    {     62,     1,   100,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,   5268,50 ,   5318,52 ,   5370,14 ,   5268,50 ,   5318,52 ,   5370,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,   9218,23 ,       8,5 ,       4,0 ,    2830,5 ,    2835,9 ,     2,     1,     7,     7,     7 }, // Kashmiri/Arabic/India
    {     63,     2,   110,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,    413,10 ,     156,8 ,    808,22 ,      37,5 ,      8,10 ,   5384,21 ,   5405,56 ,   5461,14 ,   5384,21 ,   5405,56 ,   5461,14 ,       0,2 ,       0,2 ,  562,4 , 566,17 , 583,23 , {75,90,84},      244,1 ,   9241,58 ,      13,5 ,       4,0 ,   2844,10 ,    2854,9 ,     2,     1,     1,     6,     7 }, // Kazakh/Cyrillic/Kazakhstan
    {     64,     7,   179,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,   5475,35 ,   5510,84 ,     85,14 ,   5475,35 ,   5510,84 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,87,70},      180,2 ,       0,7 ,       8,5 ,       4,0 ,   2863,11 ,    2874,8 ,     0,     0,     1,     6,     7 }, // Kinyarwanda/Latin/Rwanda
    {     65,     2,   116,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,    423,10 ,    423,10 ,     269,6 ,    830,23 ,      37,5 ,      8,10 ,   5594,38 ,   5632,57 ,   5689,14 ,   5594,38 ,   5632,57 ,   5689,14 ,     124,5 ,    117,14 ,  562,4 , 606,18 ,  22,23 , {75,71,83},      245,3 ,   9299,52 ,      13,5 ,       4,0 ,    2882,8 ,   2890,10 ,     2,     1,     1,     6,     7 }, // Kirghiz/Cyrillic/Kyrgyzstan
    {     66,    22,   114,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     433,7 ,     433,7 ,     853,9 ,    862,16 ,     359,7 ,    366,13 ,   5703,14 ,   5717,28 ,   5703,14 ,   5703,14 ,   5717,28 ,   5703,14 ,     129,2 ,     131,2 ,  624,3 ,   5,17 ,  22,23 , {75,82,87},      248,1 ,   9351,19 ,       4,4 ,       4,0 ,    2900,3 ,    2903,4 ,     0,     0,     7,     6,     7 }, // Korean/Korean/South Korea
    {     66,    22,   113,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     433,7 ,     433,7 ,     853,9 ,    862,16 ,     359,7 ,    366,13 ,   5703,14 ,   5717,28 ,   5703,14 ,   5703,14 ,   5717,28 ,   5703,14 ,     129,2 ,     131,2 ,  624,3 ,   5,17 ,  22,23 , {75,80,87},      249,3 ,   9370,39 ,       4,4 ,       4,0 ,    2900,3 ,   2907,11 ,     0,     0,     1,     6,     7 }, // Korean/Korean/North Korea
    {     67,     7,   217,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     440,7 ,     440,7 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,   5745,20 ,   5765,42 ,   5807,14 ,   5745,20 ,   5765,42 ,   5807,14 ,     131,2 ,     133,2 ,   45,4 ,   5,17 ,  22,23 , {84,82,89},      252,1 ,       0,7 ,      13,5 ,       4,0 ,    2918,5 ,    2923,7 ,     2,     1,     1,     6,     7 }, // Kurdish/Latin/Turkey
    {     68,     7,    35,    44,    46,    59,    37,    48,    45,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,   5821,34 ,   5855,89 ,     85,14 ,   5821,34 ,   5855,89 ,     85,14 ,     133,5 ,     135,5 ,   45,4 ,   5,17 ,  22,23 , {66,73,70},      163,3 ,   9409,27 ,       0,4 ,       4,0 ,    2930,8 ,    2938,8 ,     0,     0,     1,     6,     7 }, // Rundi/Latin/Burundi
    {     69,    23,   117,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,     447,9 ,     415,8 ,    878,19 ,      55,4 ,    379,24 ,   5944,36 ,   5980,57 ,   6037,17 ,   5944,36 ,   5980,57 ,   6037,17 ,     138,8 ,     140,8 ,   45,4 ,   5,17 ,  22,23 , {76,65,75},      253,1 ,   9436,21 ,       4,4 ,      36,5 ,    2946,3 ,    2946,3 ,     0,     0,     7,     6,     7 }, // Lao/Lao/Laos
    {     71,     7,   118,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     456,8 ,     456,8 ,     156,8 ,    897,26 ,      37,5 ,      8,10 ,   6054,51 ,   6105,72 ,   6177,14 ,   6191,51 ,   6242,72 ,   6177,14 ,    146,14 ,    148,11 ,  627,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   9457,23 ,      13,5 ,       4,0 ,    2949,8 ,    2957,7 ,     2,     1,     1,     6,     7 }, // Latvian/Latin/Latvia
    {     72,     7,    49,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     464,9 ,     464,9 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,   6314,28 ,  6342,100 ,   6442,14 ,   6314,28 ,  6342,100 ,   6442,14 ,     160,8 ,     159,6 ,   45,4 ,   5,17 ,  22,23 , {67,68,70},      210,2 ,   9480,23 ,      13,5 ,       4,0 ,    2964,7 ,   2971,30 ,     2,     1,     1,     6,     7 }, // Lingala/Latin/Congo Kinshasa
    {     72,     7,     6,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     464,9 ,     464,9 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,   6314,28 ,  6342,100 ,   6442,14 ,   6314,28 ,  6342,100 ,   6442,14 ,     160,8 ,     159,6 ,   45,4 ,   5,17 ,  22,23 , {65,79,65},      254,2 ,   9503,23 ,      13,5 ,       4,0 ,    2964,7 ,    3001,6 ,     2,     1,     1,     6,     7 }, // Lingala/Latin/Angola
    {     72,     7,    41,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     464,9 ,     464,9 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,   6314,28 ,  6342,100 ,   6442,14 ,   6314,28 ,  6342,100 ,   6442,14 ,     160,8 ,     159,6 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,   9526,23 ,      13,5 ,       4,0 ,    2964,7 ,   3007,26 ,     0,     0,     1,     6,     7 }, // Lingala/Latin/Central African Republic
    {     72,     7,    50,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     464,9 ,     464,9 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,   6314,28 ,  6342,100 ,   6442,14 ,   6314,28 ,  6342,100 ,   6442,14 ,     160,8 ,     159,6 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,   9526,23 ,      13,5 ,       4,0 ,    2964,7 ,    3033,5 ,     0,     0,     1,     6,     7 }, // Lingala/Latin/Congo Brazzaville
    {     73,     7,   124,    44,   160,    59,    37,    48,  8722,    43,   101,    8222,    8220,    8222,    8220,       0,6 ,       0,6 ,     473,8 ,     473,8 ,     53,10 ,    923,27 ,      37,5 ,      8,10 ,   6456,21 ,   6477,89 ,   6566,14 ,   6456,21 ,   6477,89 ,   6566,14 ,     168,9 ,     165,6 ,  632,6 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   9549,30 ,      13,5 ,       4,0 ,    3038,8 ,    3046,7 ,     2,     1,     1,     6,     7 }, // Lithuanian/Latin/Lithuania
    {     74,     2,   127,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     111,7 ,     111,7 ,     113,6 ,     10,17 ,      37,5 ,      8,10 ,   6580,35 ,   6615,54 ,   1530,14 ,   6669,34 ,   6615,54 ,   1530,14 ,    177,10 ,     171,8 ,  638,5 ,   5,17 ,  22,23 , {77,75,68},      256,4 ,   9579,56 ,      13,5 ,       4,0 ,   3053,10 ,   3063,18 ,     2,     1,     1,     6,     7 }, // Macedonian/Cyrillic/Macedonia
    {     75,     7,   128,    46,    44,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     97,16 ,      37,5 ,      8,10 ,   6703,34 ,   6737,60 ,   6797,14 ,   6703,34 ,   6737,60 ,   6797,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {77,71,65},      170,2 ,   9635,13 ,       8,5 ,       4,0 ,    3081,8 ,   3089,12 ,     0,     0,     1,     6,     7 }, // Malagasy/Latin/Madagascar
    {     76,     7,   130,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     351,9 ,     351,9 ,     571,7 ,     10,17 ,      18,7 ,     25,12 ,   6811,28 ,   6839,43 ,   6882,14 ,   6811,28 ,   6839,43 ,   6882,14 ,     187,2 ,     179,3 ,  643,4 ,   5,17 ,  22,23 , {77,89,82},      174,2 ,   9648,39 ,       4,4 ,       4,0 ,    3101,6 ,    1249,8 ,     2,     1,     1,     6,     7 }, // Malay/Latin/Malaysia
    {     76,     1,   130,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {77,89,82},      174,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Malay/Arabic/Malaysia
    {     76,     7,    32,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     351,9 ,     351,9 ,     571,7 ,    950,12 ,      18,7 ,     25,12 ,   6811,28 ,   6839,43 ,   6882,14 ,   6811,28 ,   6839,43 ,   6882,14 ,     187,2 ,     179,3 ,  643,4 ,   5,17 ,  22,23 , {66,78,68},        6,1 ,   9687,31 ,       8,5 ,       4,0 ,    3101,6 ,    3107,6 ,     2,     1,     1,     6,     7 }, // Malay/Latin/Brunei
    {     76,     7,   190,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     351,9 ,     351,9 ,     571,7 ,     10,17 ,      18,7 ,     25,12 ,   6811,28 ,   6839,43 ,   6882,14 ,   6811,28 ,   6839,43 ,   6882,14 ,     187,2 ,     179,3 ,  643,4 ,   5,17 ,  22,23 , {83,71,68},        6,1 ,   9718,37 ,       4,4 ,       4,0 ,    3101,6 ,    3113,9 ,     2,     1,     7,     6,     7 }, // Malay/Latin/Singapore
    {     77,    24,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    481,13 ,    494,12 ,     269,6 ,    962,18 ,      18,7 ,     25,12 ,   6896,41 ,   6937,77 ,   7014,22 ,   6896,41 ,   7036,76 ,   7112,21 ,       0,2 ,       0,2 ,  647,6 , 653,27 ,  22,23 , {73,78,82},      121,1 ,   9755,40 ,       4,4 ,       4,0 ,    3122,6 ,    3128,6 ,     2,     1,     7,     7,     7 }, // Malayalam/Malayalam/India
    {     78,     7,   133,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     506,8 ,     514,7 ,    119,10 ,    980,23 ,      37,5 ,      8,10 ,   7133,28 ,   7161,63 ,   7224,21 ,   7133,28 ,   7161,63 ,   7245,20 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   9795,27 ,       4,4 ,       4,0 ,    3134,5 ,    1257,5 ,     2,     1,     7,     6,     7 }, // Maltese/Latin/Malta
    {     79,     7,   154,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    528,10 ,     10,17 ,      18,7 ,     25,12 ,   7265,27 ,   7292,47 ,   7339,14 ,   7265,27 ,   7292,47 ,   7339,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {78,90,68},        6,1 ,   9822,37 ,       8,5 ,       4,0 ,    3139,5 ,    3144,8 ,     2,     1,     1,     6,     7 }, // Maori/Latin/New Zealand
    {     80,    13,   100,    46,    44,    59,    37,  2406,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     521,9 ,     521,9 ,     269,6 ,    192,18 ,      18,7 ,     25,12 ,   7353,32 ,   7385,53 ,   4389,19 ,   7353,32 ,   7385,53 ,   4389,19 ,     189,5 ,     182,4 ,  477,4 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,   9859,43 ,       4,4 ,       4,0 ,    3152,5 ,    2662,4 ,     2,     1,     7,     7,     7 }, // Marathi/Devanagari/India
    {     82,     2,   143,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,   1003,10 ,   1013,35 ,      37,5 ,     87,12 ,   7438,21 ,   7459,43 ,   7438,21 ,   7438,21 ,   7502,43 ,   7438,21 ,     194,4 ,     186,4 ,  562,4 , 680,17 ,  22,23 , {77,78,84},      260,1 ,   9902,46 ,       8,5 ,       4,0 ,    3157,6 ,    3163,6 ,     2,     0,     1,     6,     7 }, // Mongolian/Cyrillic/Mongolia
    {     82,     8,    44,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,78,89},      261,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Mongolian/Mongolian/China
    {     84,    13,   150,    46,    44,    59,    37,  2406,    45,    43,   101,    8220,    8221,    8216,    8217,     530,5 ,       0,6 ,     535,7 ,     535,7 ,     227,6 ,     63,17 ,      37,5 ,      8,10 ,   7545,33 ,   7578,54 ,   7632,18 ,   7545,33 ,   7578,54 ,   7632,18 ,     198,9 ,     190,7 ,  477,4 , 697,19 ,  22,23 , {78,80,82},      264,4 ,   9948,49 ,       8,5 ,       4,0 ,    3169,6 ,    3175,5 ,     2,     1,     7,     6,     7 }, // Nepali/Devanagari/Nepal
    {     84,    13,   100,    46,    44,    59,    37,  2406,    45,    43,   101,    8220,    8221,    8216,    8217,     530,5 ,       0,6 ,     535,7 ,     535,7 ,     227,6 ,     63,17 ,      18,7 ,     25,12 ,   7545,33 ,   7578,54 ,   7632,18 ,   7545,33 ,   7578,54 ,   7632,18 ,     198,9 ,     190,7 ,  477,4 , 697,19 ,  22,23 , {73,78,82},      121,1 ,   9997,49 ,       8,5 ,       4,0 ,    3169,6 ,    2662,4 ,     2,     1,     7,     7,     7 }, // Nepali/Devanagari/India
    {     85,     7,   161,    44,   160,    59,    37,    48,  8722,    43,   101,     171,     187,    8216,    8217,       0,6 ,       0,6 ,     187,8 ,     187,8 ,    495,10 ,    478,17 ,      37,5 ,      8,10 ,   2334,35 ,   2269,51 ,   2320,14 ,   2334,35 ,   2269,51 ,   2320,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {78,79,75},      190,2 ,  10046,44 ,       8,5 ,       4,0 ,   3180,12 ,    3192,5 ,     2,     0,     1,     6,     7 }, // Norwegian Bokmal/Latin/Norway
    {     85,     7,   203,    44,   160,    59,    37,    48,  8722,    43,   101,     171,     187,    8216,    8217,       0,6 ,       0,6 ,     187,8 ,     187,8 ,    495,10 ,    478,17 ,      37,5 ,      8,10 ,   2334,35 ,   2269,51 ,   2320,14 ,   2334,35 ,   2269,51 ,   2320,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {78,79,75},      190,2 ,  10046,44 ,       8,5 ,       4,0 ,   3180,12 ,   3197,21 ,     2,     0,     1,     6,     7 }, // Norwegian Bokmal/Latin/Svalbard And Jan Mayen Islands
    {     86,     7,    74,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Occitan/Latin/France
    {     87,    26,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     542,8 ,     550,7 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,   7650,33 ,   7683,54 ,   7737,18 ,   7650,33 ,   7683,54 ,   7737,18 ,       0,2 ,       0,2 ,  716,5 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,  10090,43 ,       4,4 ,       4,0 ,    3218,5 ,    3223,4 ,     2,     1,     7,     7,     7 }, // Oriya/Oriya/India
    {     88,     1,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,     557,6 ,     557,6 ,     563,9 ,     572,8 ,     394,8 ,   1048,20 ,      55,4 ,    403,11 ,   7755,39 ,   7755,39 ,     85,14 ,   7755,39 ,   7755,39 ,     85,14 ,     207,4 ,     197,4 ,  721,5 ,   5,17 ,  22,23 , {65,70,78},      268,1 ,  10133,25 ,      13,5 ,       4,0 ,    3227,4 ,    3231,9 ,     0,     0,     6,     4,     5 }, // Pashto/Arabic/Afghanistan
    {     88,     1,   163,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,     557,6 ,     557,6 ,     563,9 ,     572,8 ,     394,8 ,   1048,20 ,      18,7 ,     25,12 ,   7755,39 ,   7755,39 ,     85,14 ,   7755,39 ,   7755,39 ,     85,14 ,     207,4 ,     197,4 ,  721,5 ,   5,17 ,  22,23 , {80,75,82},      176,2 ,  10158,52 ,      13,5 ,       4,0 ,    3227,4 ,    3240,7 ,     2,     0,     7,     6,     7 }, // Pashto/Arabic/Pakistan
    {     89,     1,   102,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,     171,     187,    8249,    8250,     580,7 ,     580,7 ,     587,8 ,     595,7 ,     394,8 ,     97,16 ,      55,4 ,    403,11 ,   7794,49 ,   7794,49 ,   7843,14 ,   7794,49 ,   7794,49 ,   7843,14 ,     211,9 ,     201,8 ,  726,4 , 730,44 ,  22,23 , {73,82,82},      269,4 ,  10210,37 ,      84,5 ,       4,0 ,    3247,5 ,    3252,5 ,     0,     0,     6,     5,     5 }, // Persian/Arabic/Iran
    {     89,     1,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,     171,     187,    8249,    8250,     580,7 ,     580,7 ,     587,8 ,     595,7 ,     394,8 ,     97,16 ,      55,4 ,    403,11 ,   7794,49 ,   7794,49 ,   7843,14 ,   7794,49 ,   7794,49 ,   7843,14 ,     211,9 ,     201,8 ,  726,4 , 730,44 ,  22,23 , {65,70,78},      268,1 ,  10247,55 ,       8,5 ,       4,0 ,    3257,3 ,    3231,9 ,     0,     0,     6,     4,     5 }, // Persian/Arabic/Afghanistan
    {     90,     7,   172,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,     171,     187,       0,6 ,       0,6 ,     158,7 ,     158,7 ,    495,10 ,     10,17 ,      37,5 ,      8,10 ,   7857,34 ,   7891,59 ,   7950,14 ,   7857,34 ,   7891,59 ,   7964,14 ,       0,2 ,       0,2 ,  326,5 ,   5,17 ,  22,23 , {80,76,78},      273,2 ,  10302,77 ,      13,5 ,       4,0 ,    3260,6 ,    3266,6 ,     2,     1,     1,     6,     7 }, // Polish/Latin/Poland
    {     91,     7,    30,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     249,7 ,     249,7 ,    119,10 ,    669,27 ,      37,5 ,      8,10 ,   7978,35 ,   8013,79 ,   8092,14 ,   7978,35 ,   8013,79 ,   8092,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {66,82,76},      275,2 ,  10379,54 ,       8,5 ,       4,0 ,    3272,9 ,    3281,6 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Brazil
    {     91,     7,     6,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,    669,27 ,      37,5 ,      8,10 ,   8106,49 ,   8013,79 ,   8092,14 ,   8106,49 ,   8013,79 ,   8092,14 ,     220,8 ,     209,8 ,    0,5 ,   5,17 ,  22,23 , {65,79,65},      254,2 ,  10433,54 ,      13,5 ,       4,0 ,    3272,9 ,    3287,6 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Angola
    {     91,     7,    39,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,    669,27 ,      37,5 ,      8,10 ,   8106,49 ,   8013,79 ,   8092,14 ,   8106,49 ,   8013,79 ,   8092,14 ,     220,8 ,     209,8 ,    0,5 ,   5,17 ,  22,23 , {67,86,69},      277,1 ,  10487,69 ,      13,5 ,       4,0 ,    3272,9 ,   3293,10 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Cape Verde
    {     91,     7,    62,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,    669,27 ,      37,5 ,      8,10 ,   8106,49 ,   8013,79 ,   8092,14 ,   8106,49 ,   8013,79 ,   8092,14 ,     220,8 ,     209,8 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,  10556,81 ,      13,5 ,       4,0 ,    3272,9 ,   3303,11 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/East Timor
    {     91,     7,    66,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,    669,27 ,      37,5 ,      8,10 ,   8106,49 ,   8013,79 ,   8092,14 ,   8106,49 ,   8013,79 ,   8092,14 ,     220,8 ,     209,8 ,    0,5 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  10637,59 ,      13,5 ,       4,0 ,    3272,9 ,   3314,16 ,     0,     0,     1,     6,     7 }, // Portuguese/Latin/Equatorial Guinea
    {     91,     7,    92,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,    669,27 ,      37,5 ,      8,10 ,   8106,49 ,   8013,79 ,   8092,14 ,   8106,49 ,   8013,79 ,   8092,14 ,     220,8 ,     209,8 ,    0,5 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  10696,62 ,      13,5 ,       4,0 ,    3272,9 ,   3330,12 ,     0,     0,     1,     6,     7 }, // Portuguese/Latin/Guinea Bissau
    {     91,     7,   125,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,    669,27 ,      37,5 ,      8,10 ,   8106,49 ,   8013,79 ,   8092,14 ,   8106,49 ,   8013,79 ,   8092,14 ,     220,8 ,     209,8 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    3272,9 ,   3342,10 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Luxembourg
    {     91,     7,   126,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,    669,27 ,      18,7 ,     25,12 ,   8106,49 ,   8013,79 ,   8092,14 ,   8106,49 ,   8013,79 ,   8092,14 ,     220,8 ,     209,8 ,    0,5 ,   5,17 ,  22,23 , {77,79,80},      137,4 ,  10758,54 ,      13,5 ,       4,0 ,    3272,9 ,   3352,19 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Macau
    {     91,     7,   146,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,    669,27 ,      37,5 ,      8,10 ,   8106,49 ,   8013,79 ,   8092,14 ,   8106,49 ,   8013,79 ,   8092,14 ,     220,8 ,     209,8 ,    0,5 ,   5,17 ,  22,23 , {77,90,78},      278,3 ,  10812,66 ,      13,5 ,       4,0 ,    3272,9 ,   3371,10 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Mozambique
    {     91,     7,   173,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,    669,27 ,      37,5 ,      8,10 ,   8106,49 ,   8013,79 ,   8092,14 ,   8106,49 ,   8013,79 ,   8092,14 ,     220,8 ,     209,8 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,   3381,17 ,    3398,8 ,     2,     1,     7,     6,     7 }, // Portuguese/Latin/Portugal
    {     91,     7,   185,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,    669,27 ,      37,5 ,      8,10 ,   8106,49 ,   8013,79 ,   8092,14 ,   8106,49 ,   8013,79 ,   8092,14 ,     220,8 ,     209,8 ,    0,5 ,   5,17 ,  22,23 , {83,84,78},      281,2 ,  10878,92 ,      13,5 ,       4,0 ,    3272,9 ,   3406,19 ,     2,     1,     1,     6,     7 }, // Portuguese/Latin/Sao Tome And Principe
    {     91,     7,   206,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,    669,27 ,      37,5 ,      8,10 ,   8106,49 ,   8013,79 ,   8092,14 ,   8106,49 ,   8013,79 ,   8092,14 ,     220,8 ,     209,8 ,    0,5 ,   5,17 ,  22,23 , {67,72,70},      224,3 ,  10970,45 ,      13,5 ,       4,0 ,    3272,9 ,    3425,5 ,     2,     0,     1,     6,     7 }, // Portuguese/Latin/Switzerland
    {     92,     4,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     602,9 ,     602,9 ,     269,6 ,     10,17 ,      18,7 ,     25,12 ,   8155,36 ,   8191,57 ,   8248,23 ,   8155,36 ,   8191,57 ,   8248,23 ,     228,6 ,     217,6 ,  774,4 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,  11015,39 ,       4,4 ,       4,0 ,    3430,6 ,    3436,4 ,     2,     1,     7,     7,     7 }, // Punjabi/Gurmukhi/India
    {     92,     1,   163,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,    553,18 ,      18,7 ,     25,12 ,   8271,37 ,   8271,37 ,     85,14 ,   8271,37 ,   8271,37 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {80,75,82},      283,1 ,  11054,13 ,      41,6 ,       4,0 ,    3440,6 ,    3240,7 ,     2,     0,     7,     6,     7 }, // Punjabi/Arabic/Pakistan
    {     93,     7,   169,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    611,11 ,    622,10 ,    119,10 ,    192,18 ,      37,5 ,      8,10 ,   8308,28 ,   8336,53 ,   8389,14 ,   8308,28 ,   8336,53 ,   8389,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {80,69,78},      284,2 ,  11067,29 ,       8,5 ,       4,0 ,    3446,8 ,    3454,4 ,     2,     1,     7,     6,     7 }, // Quechua/Latin/Peru
    {     93,     7,    26,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    611,11 ,    622,10 ,    119,10 ,    192,18 ,      37,5 ,      8,10 ,   8308,28 ,   8336,53 ,   8389,14 ,   8308,28 ,   8336,53 ,   8389,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {66,79,66},      286,2 ,  11096,25 ,       8,5 ,       4,0 ,    3446,8 ,    3458,7 ,     2,     1,     1,     6,     7 }, // Quechua/Latin/Bolivia
    {     93,     7,    63,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    611,11 ,    622,10 ,    119,10 ,    192,18 ,      37,5 ,      8,10 ,   8308,28 ,   8336,53 ,   8389,14 ,   8308,28 ,   8336,53 ,   8389,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,  11121,37 ,       8,5 ,       4,0 ,    3446,8 ,    3465,7 ,     2,     1,     1,     6,     7 }, // Quechua/Latin/Ecuador
    {     94,     7,   206,    46,  8217,    59,    37,    48,  8722,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     339,8 ,   1068,23 ,      37,5 ,      8,10 ,   8403,23 ,   8426,56 ,   8482,14 ,   8403,23 ,   8426,56 ,   8482,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,72,70},      224,3 ,  11158,46 ,      13,5 ,       4,0 ,    3472,9 ,    3481,6 ,     2,     0,     1,     6,     7 }, // Romansh/Latin/Switzerland
    {     95,     7,   177,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8221,     171,     187,       0,6 ,       0,6 ,     632,8 ,     632,8 ,    495,10 ,     10,17 ,      37,5 ,      8,10 ,   8496,34 ,   8530,48 ,   3107,14 ,   8496,34 ,   8530,48 ,   3107,14 ,      64,4 ,      61,4 ,  778,4 ,   5,17 ,  22,23 , {82,79,78},      288,3 ,  11204,57 ,      13,5 ,       4,0 ,    3487,6 ,    3493,7 ,     2,     1,     1,     6,     7 }, // Romanian/Latin/Romania
    {     95,     7,   141,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8221,     171,     187,       0,6 ,       0,6 ,     632,8 ,     632,8 ,    495,10 ,     10,17 ,      37,5 ,      8,10 ,   8578,28 ,   8530,48 ,   8606,16 ,   8578,28 ,   8530,48 ,   8606,16 ,      64,4 ,      61,4 ,  778,4 ,   5,17 ,  22,23 , {77,68,76},      291,1 ,  11261,69 ,      13,5 ,       4,0 ,    3487,6 ,   3500,17 ,     2,     1,     1,     6,     7 }, // Romanian/Latin/Moldova
    {     96,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     111,7 ,     111,7 ,    495,10 ,    317,22 ,      37,5 ,      8,10 ,   8622,21 ,   8643,62 ,   8705,14 ,   8622,21 ,   8643,62 ,   8622,21 ,       0,2 ,       0,2 ,  269,5 , 680,17 ,  22,23 , {82,85,66},      123,1 ,  11330,89 ,      13,5 ,       4,0 ,    3517,7 ,    3524,6 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Russia
    {     96,     2,    20,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     111,7 ,     111,7 ,    495,10 ,    317,22 ,      37,5 ,      8,10 ,   8622,21 ,   8643,62 ,   8705,14 ,   8622,21 ,   8643,62 ,   8622,21 ,       0,2 ,       0,2 ,  269,5 , 680,17 ,  22,23 , {66,89,78},        0,2 ,  11419,94 ,      13,5 ,       4,0 ,    3517,7 ,     510,8 ,     2,     0,     1,     6,     7 }, // Russian/Cyrillic/Belarus
    {     96,     2,   110,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     111,7 ,     111,7 ,    495,10 ,    317,22 ,      37,5 ,      8,10 ,   8622,21 ,   8643,62 ,   8705,14 ,   8622,21 ,   8643,62 ,   8622,21 ,       0,2 ,       0,2 ,  269,5 , 680,17 ,  22,23 , {75,90,84},      244,1 ,  11513,83 ,      13,5 ,       4,0 ,    3517,7 ,    3530,9 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Kazakhstan
    {     96,     2,   116,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     111,7 ,     111,7 ,    495,10 ,    317,22 ,      37,5 ,      8,10 ,   8622,21 ,   8643,62 ,   8705,14 ,   8622,21 ,   8643,62 ,   8622,21 ,       0,2 ,       0,2 ,  269,5 , 680,17 ,  22,23 , {75,71,83},      245,3 ,  11596,82 ,      13,5 ,       4,0 ,    3517,7 ,    3539,8 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Kyrgyzstan
    {     96,     2,   141,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     111,7 ,     111,7 ,    495,10 ,    317,22 ,      37,5 ,      8,10 ,   8622,21 ,   8643,62 ,   8705,14 ,   8622,21 ,   8643,62 ,   8622,21 ,       0,2 ,       0,2 ,  269,5 , 680,17 ,  22,23 , {77,68,76},      291,1 ,  11678,79 ,      13,5 ,       4,0 ,    3517,7 ,    3547,7 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Moldova
    {     96,     2,   222,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     111,7 ,     111,7 ,    495,10 ,    317,22 ,      37,5 ,      8,10 ,   8622,21 ,   8643,62 ,   8705,14 ,   8622,21 ,   8643,62 ,   8622,21 ,       0,2 ,       0,2 ,  269,5 , 680,17 ,  22,23 , {85,65,72},      292,1 ,  11757,92 ,      13,5 ,       4,0 ,    3517,7 ,    3554,7 ,     2,     1,     1,     6,     7 }, // Russian/Cyrillic/Ukraine
    {     98,     7,    41,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,   8719,28 ,   8747,66 ,   8813,14 ,   8719,28 ,   8747,66 ,   8813,14 ,     234,2 ,     223,2 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  11849,25 ,       4,4 ,      36,5 ,    3561,5 ,   3566,22 ,     0,     0,     1,     6,     7 }, // Sango/Latin/Central African Republic
    {     99,    13,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     7,     7 }, // Sanskrit/Devanagari/India
    {    100,     2,   243,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     111,7 ,     111,7 ,    1091,7 ,   1098,20 ,      37,5 ,      8,10 ,   8827,28 ,   8855,52 ,   8907,14 ,   8827,28 ,   8855,52 ,   8907,14 ,     236,9 ,     225,8 ,  782,7 ,   5,17 ,  22,23 , {82,83,68},      293,3 ,  11874,58 ,      13,5 ,       4,0 ,    3588,6 ,    3594,6 ,     0,     0,     1,     6,     7 }, // Serbian/Cyrillic/Serbia
    {    100,     2,    27,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     111,7 ,     111,7 ,    1091,7 ,   1098,20 ,      37,5 ,      8,10 ,   8921,26 ,   8947,55 ,   8907,14 ,   8921,26 ,   8947,55 ,   8907,14 ,    245,11 ,     225,8 ,  782,7 ,   5,17 ,  22,23 , {66,65,77},      296,2 , 11932,174 ,      13,5 ,       4,0 ,    3588,6 ,   3600,19 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/Bosnia And Herzegowina
    {    100,     2,   242,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     111,7 ,     111,7 ,    1091,7 ,   1098,20 ,      37,5 ,      8,10 ,   8827,28 ,   8947,55 ,   8907,14 ,   8827,28 ,   8947,55 ,   8907,14 ,    245,11 ,     225,8 ,  782,7 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  12106,23 ,      13,5 ,       4,0 ,    3588,6 ,    3619,9 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/Montenegro
    {    100,     2,   257,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     111,7 ,     111,7 ,    1091,7 ,   1098,20 ,      37,5 ,      8,10 ,   8827,28 ,   8855,52 ,   8907,14 ,   8827,28 ,   8855,52 ,   8907,14 ,     236,9 ,     225,8 ,  782,7 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  12106,23 ,      13,5 ,       4,0 ,    3588,6 ,    3628,6 ,     2,     1,     1,     6,     7 }, // Serbian/Cyrillic/Kosovo
    {    100,     7,    27,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     158,7 ,     158,7 ,    1091,7 ,   1098,20 ,      37,5 ,      8,10 ,   9002,26 ,   9028,57 ,   2129,14 ,   9002,26 ,   9028,57 ,   2129,14 ,    256,11 ,     233,8 ,  319,7 ,   5,17 ,  22,23 , {66,65,77},      144,2 , 12129,174 ,      13,5 ,       4,0 ,    3634,6 ,    629,19 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/Bosnia And Herzegowina
    {    100,     7,   242,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     158,7 ,     158,7 ,    1091,7 ,   1098,20 ,      37,5 ,      8,10 ,   9085,28 ,   9028,57 ,   2129,14 ,   9085,28 ,   9028,57 ,   2129,14 ,    256,11 ,     233,8 ,  319,7 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  12303,23 ,      13,5 ,       4,0 ,    3634,6 ,    3640,9 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/Montenegro
    {    100,     7,   243,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     158,7 ,     158,7 ,    1091,7 ,   1098,20 ,      37,5 ,      8,10 ,   9085,28 ,   9113,54 ,   2129,14 ,   9085,28 ,   9113,54 ,   2129,14 ,     267,9 ,     233,8 ,  319,7 ,   5,17 ,  22,23 , {82,83,68},      293,3 ,  12326,58 ,      13,5 ,       4,0 ,    3634,6 ,    3649,6 ,     0,     0,     1,     6,     7 }, // Serbian/Latin/Serbia
    {    100,     7,   257,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8216,    8216,       0,6 ,       0,6 ,     158,7 ,     158,7 ,    1091,7 ,   1098,20 ,      37,5 ,      8,10 ,   9085,28 ,   9113,54 ,   2129,14 ,   9085,28 ,   9113,54 ,   2129,14 ,     267,9 ,     233,8 ,  319,7 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  12303,23 ,      13,5 ,       4,0 ,    3634,6 ,    3655,6 ,     2,     1,     1,     6,     7 }, // Serbian/Latin/Kosovo
    {    101,     2,    81,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     640,9 ,     640,9 ,     156,8 ,   1118,23 ,      37,5 ,      8,10 ,   9167,28 ,   9195,61 ,   9256,14 ,   9270,28 ,   9298,61 ,   9256,14 ,    276,15 ,    241,15 ,   45,4 ,   5,17 ,  22,23 , {71,69,76},      231,1 ,  12384,17 ,       8,5 ,       4,0 ,    3661,4 ,   3665,11 ,     2,     1,     1,     6,     7 }, // Ossetic/Cyrillic/Georgia
    {    101,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     640,9 ,     640,9 ,     156,8 ,   1118,23 ,      37,5 ,      8,10 ,   9167,28 ,   9195,61 ,   9256,14 ,   9270,28 ,   9298,61 ,   9256,14 ,    276,15 ,    241,15 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      123,1 ,  12401,17 ,       8,5 ,       4,0 ,    3661,4 ,    3676,6 ,     2,     1,     1,     6,     7 }, // Ossetic/Cyrillic/Russia
    {    102,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Southern Sotho/Latin/South Africa
    {    103,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Tswana/Latin/South Africa
    {    104,     7,   240,    46,    44,    59,    37,    48,    45,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,   9359,28 ,   9387,55 ,   9442,14 ,   9359,28 ,   9387,55 ,   9442,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,  12418,22 ,       4,4 ,       4,0 ,    3682,8 ,    1815,8 ,     2,     1,     7,     6,     7 }, // Shona/Latin/Zimbabwe
    {    105,     1,   163,  1643,  1644,  1563,    37,  1632,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     649,8 ,     657,7 ,     53,10 ,     63,17 ,      18,7 ,     25,12 ,   9456,35 ,   9456,35 ,   9491,31 ,   9456,35 ,   9456,35 ,   9491,31 ,    291,11 ,    256,11 ,  789,6 , 795,61 ,  22,23 , {80,75,82},      176,2 ,  12440,43 ,       8,5 ,       4,0 ,    3690,4 ,    3694,7 ,     2,     0,     7,     6,     7 }, // Sindhi/Arabic/Pakistan
    {    106,    32,   198,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     664,9 ,     673,8 ,     53,10 ,     63,17 ,     205,5 ,    210,10 ,   9522,39 ,   9561,62 ,   9623,19 ,   9522,39 ,   9561,62 ,   9623,19 ,     302,5 ,     267,4 ,  856,5 , 861,42 ,  22,23 , {76,75,82},      298,3 ,  12483,58 ,       4,4 ,       4,0 ,    3701,5 ,   3706,11 ,     2,     1,     1,     6,     7 }, // Sinhala/Sinhala/Sri Lanka
    {    107,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Swati/Latin/South Africa
    {    108,     7,   191,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     180,7 ,     681,7 ,   1141,10 ,    478,17 ,      55,4 ,      59,9 ,   9642,21 ,   9663,52 ,   9715,14 ,   9642,21 ,   9663,52 ,   9715,14 ,       0,2 ,       0,2 ,  326,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  12541,26 ,      13,5 ,       4,0 ,   3717,10 ,    3727,9 ,     2,     1,     1,     6,     7 }, // Slovak/Latin/Slovakia
    {    109,     7,   192,    44,    46,    59,    37,    48,  8722,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     688,8 ,     688,8 ,    1151,9 ,   1160,19 ,      37,5 ,      8,10 ,   9729,35 ,   9764,52 ,   9816,14 ,   9729,35 ,   9764,52 ,   9816,14 ,      60,4 ,     271,4 ,   54,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  12567,28 ,      13,5 ,       4,0 ,   3736,11 ,    3747,9 ,     2,     1,     1,     6,     7 }, // Slovenian/Latin/Slovenia
    {    110,     7,   194,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     696,9 ,     696,9 ,      27,8 ,   1179,19 ,      18,7 ,     25,12 ,   9830,32 ,   9862,47 ,   9909,15 ,   9830,32 ,   9862,47 ,   9909,15 ,     307,2 ,     275,2 ,  903,6 , 909,17 ,  22,23 , {83,79,83},       94,1 ,  12595,27 ,       4,4 ,       4,0 ,    3756,8 ,   3764,10 ,     0,     0,     1,     6,     7 }, // Somali/Latin/Somalia
    {    110,     7,    59,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     696,9 ,     696,9 ,      27,8 ,   1179,19 ,      18,7 ,     25,12 ,   9830,32 ,   9862,47 ,   9909,15 ,   9830,32 ,   9862,47 ,   9909,15 ,     307,2 ,     275,2 ,  903,6 , 909,17 ,  22,23 , {68,74,70},       38,3 ,  12622,50 ,       4,4 ,       4,0 ,    3756,8 ,    3774,7 ,     0,     0,     6,     6,     7 }, // Somali/Latin/Djibouti
    {    110,     7,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     696,9 ,     696,9 ,      27,8 ,   1179,19 ,      18,7 ,     25,12 ,   9830,32 ,   9862,47 ,   9909,15 ,   9830,32 ,   9862,47 ,   9909,15 ,     307,2 ,     275,2 ,  903,6 , 909,17 ,  22,23 , {69,84,66},        0,2 ,  12672,52 ,       4,4 ,       4,0 ,    3756,8 ,    3781,8 ,     2,     1,     7,     6,     7 }, // Somali/Latin/Ethiopia
    {    110,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     696,9 ,     696,9 ,      27,8 ,   1179,19 ,      37,5 ,      8,10 ,   9830,32 ,   9862,47 ,   9909,15 ,   9830,32 ,   9862,47 ,   9909,15 ,     307,2 ,     275,2 ,  903,6 , 909,17 ,  22,23 , {75,69,83},        2,3 ,  12724,52 ,       4,4 ,       4,0 ,    3756,8 ,    1191,5 ,     2,     1,     7,     6,     7 }, // Somali/Latin/Kenya
    {    111,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      55,4 ,    403,11 ,   9924,35 ,   9959,53 ,   8389,14 ,   9924,35 ,   9959,53 ,   8389,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,   3789,17 ,    2427,6 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Spain
    {    111,     7,    10,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   3107,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {65,82,83},        6,1 ,  12776,51 ,       8,5 ,       4,0 ,    3806,7 ,    3813,9 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Argentina
    {    111,     7,    22,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      64,4 ,      61,4 ,    0,5 ,   5,17 ,  22,23 , {66,90,68},        6,1 ,  12827,52 ,       4,4 ,       4,0 ,    3806,7 ,    3822,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Belize
    {    111,     7,    26,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {66,79,66},      286,2 ,  12879,35 ,       4,4 ,       4,0 ,    3806,7 ,    3458,7 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Bolivia
    {    111,     7,    30,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      64,4 ,      61,4 ,    0,5 ,   5,17 ,  22,23 , {66,82,76},      275,2 ,  12914,52 ,       4,4 ,       4,0 ,    3806,7 ,    3281,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Brazil
    {    111,     7,    43,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     339,8 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {67,76,80},        6,1 ,  12966,45 ,       4,4 ,      36,5 ,    3806,7 ,    3828,5 ,     0,     0,     1,     6,     7 }, // Spanish/Latin/Chile
    {    111,     7,    47,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     571,7 ,    669,27 ,      18,7 ,     25,12 ,   9924,35 ,   9959,53 ,   4796,14 ,   9924,35 ,   9959,53 ,   3107,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {67,79,80},        6,1 ,  13011,54 ,       8,5 ,       4,0 ,    3806,7 ,    3833,8 ,     2,     0,     7,     6,     7 }, // Spanish/Latin/Colombia
    {    111,     7,    52,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {67,82,67},      301,1 ,  13065,67 ,       4,4 ,       4,0 ,    3806,7 ,   3841,10 ,     2,     0,     1,     6,     7 }, // Spanish/Latin/Costa Rica
    {    111,     7,    55,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      64,4 ,      61,4 ,    0,5 ,   5,17 ,  22,23 , {67,85,80},        6,1 ,  13132,42 ,       4,4 ,       4,0 ,    3806,7 ,    3851,4 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Cuba
    {    111,     7,    61,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      18,7 ,     25,12 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   3107,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {68,79,80},      302,3 ,  13174,54 ,       4,4 ,      89,6 ,    3806,7 ,   3855,20 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Dominican Republic
    {    111,     7,    63,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,  13228,70 ,       4,4 ,      36,5 ,    3806,7 ,    3465,7 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Ecuador
    {    111,     7,    65,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,  13228,70 ,       4,4 ,       4,0 ,    3806,7 ,   3875,11 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/El Salvador
    {    111,     7,    66,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      55,4 ,    403,11 ,   9924,35 ,   9959,53 ,   8389,14 ,   9924,35 ,   9959,53 ,   8389,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  13298,92 ,       4,4 ,       4,0 ,    3806,7 ,   3886,17 ,     0,     0,     1,     6,     7 }, // Spanish/Latin/Equatorial Guinea
    {    111,     7,    90,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     571,7 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {71,84,81},      305,1 ,  13390,30 ,      18,5 ,       4,0 ,    3806,7 ,    3903,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Guatemala
    {    111,     7,    96,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,   1198,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {72,78,76},      291,1 ,  13420,60 ,       4,4 ,       4,0 ,    3806,7 ,    3912,8 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Honduras
    {    111,     7,   139,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,      27,8 ,    669,27 ,      55,4 ,      59,9 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   3107,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {77,88,78},        6,1 ,  13480,48 ,      47,6 ,       4,0 ,   3920,17 ,    3937,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Mexico
    {    111,     7,   155,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {78,73,79},      306,2 ,  13528,69 ,       4,4 ,       4,0 ,    3806,7 ,    3943,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Nicaragua
    {    111,     7,   166,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,    1225,8 ,    669,27 ,      18,7 ,     25,12 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {80,65,66},      308,3 ,  13597,54 ,       4,4 ,       4,0 ,    3806,7 ,    3952,6 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Panama
    {    111,     7,   168,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {80,89,71},      311,3 ,  13651,61 ,       8,5 ,      23,6 ,    3806,7 ,    3958,8 ,     0,     0,     7,     6,     7 }, // Spanish/Latin/Paraguay
    {    111,     7,   169,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     571,7 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {80,69,78},      284,2 ,  13712,43 ,       8,5 ,       4,0 ,    3806,7 ,    3454,4 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Peru
    {    111,     7,   170,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      18,7 ,     25,12 ,   9924,35 ,   9959,53 ,   8389,14 ,   9924,35 ,   9959,53 ,   8389,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {80,72,80},      179,1 ,  13755,48 ,      13,5 ,       4,0 ,    3806,7 ,    3966,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Philippines
    {    111,     7,   174,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,    1225,8 ,    669,27 ,      18,7 ,     25,12 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,  13228,70 ,       4,4 ,       4,0 ,    3806,7 ,   1446,11 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Puerto Rico
    {    111,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     415,8 ,    669,27 ,      18,7 ,     25,12 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   3107,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,  13228,70 ,      95,7 ,       4,0 ,    3806,7 ,   3975,14 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/United States
    {    111,     7,   227,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {85,89,85},        6,1 ,  13803,48 ,       8,5 ,       4,0 ,    3806,7 ,    3989,7 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Uruguay
    {    111,     7,   231,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      18,7 ,     25,12 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {86,69,83},      314,4 ,  13851,58 ,       4,4 ,      36,5 ,    3806,7 ,    3996,9 ,     2,     1,     7,     6,     7 }, // Spanish/Latin/Venezuela
    {    111,     7,   238,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      55,4 ,    403,11 ,   9924,35 ,   9959,53 ,   8389,14 ,   9924,35 ,   9959,53 ,   8389,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    3806,7 ,    4005,8 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Canary Islands
    {    111,     7,   246,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      37,5 ,      8,10 ,   9924,35 ,   9959,53 ,   3107,14 ,   9924,35 ,   9959,53 ,   4796,14 ,      64,4 ,      61,4 ,    0,5 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,       4,4 ,       4,0 ,   4013,23 ,   4036,13 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Latin America
    {    111,     7,   250,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    669,27 ,      55,4 ,    403,11 ,   9924,35 ,   9959,53 ,   8389,14 ,   9924,35 ,   9959,53 ,   8389,14 ,      53,5 ,      50,5 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    3806,7 ,   4049,15 ,     2,     1,     1,     6,     7 }, // Spanish/Latin/Ceuta And Melilla
    {    112,     7,   101,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,68,82},      238,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     7,     6,     7 }, // Sundanese/Latin/Indonesia
    {    113,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     712,8 ,     712,8 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  10012,60 ,  10012,60 ,     85,14 ,  10012,60 ,  10012,60 ,     85,14 ,       0,2 ,       0,2 ,  627,5 , 926,51 ,  22,23 , {84,90,83},      192,3 ,  13909,67 ,       8,5 ,       4,0 ,    4064,9 ,    1620,8 ,     2,     0,     1,     6,     7 }, // Swahili/Latin/Tanzania
    {    113,     7,    49,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     712,8 ,     712,8 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  10012,60 ,  10012,60 ,     85,14 ,  10012,60 ,  10012,60 ,     85,14 ,       0,2 ,       0,2 ,  627,5 , 926,51 ,  22,23 , {67,68,70},      210,2 ,  13976,55 ,       8,5 ,       4,0 ,    4064,9 ,   4073,32 ,     2,     1,     1,     6,     7 }, // Swahili/Latin/Congo Kinshasa
    {    113,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     712,8 ,     712,8 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  10012,60 ,  10012,60 ,     85,14 ,  10012,60 ,  10012,60 ,     85,14 ,       0,2 ,       0,2 ,  627,5 , 926,51 ,  22,23 , {75,69,83},        2,3 ,  14031,58 ,     102,6 ,     108,6 ,    4064,9 ,    1191,5 ,     2,     1,     7,     6,     7 }, // Swahili/Latin/Kenya
    {    113,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     712,8 ,     712,8 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  10012,60 ,  10012,60 ,     85,14 ,  10012,60 ,  10012,60 ,     85,14 ,       0,2 ,       0,2 ,  627,5 , 926,51 ,  22,23 , {85,71,88},      197,3 ,  14089,61 ,       8,5 ,       4,0 ,    4064,9 ,    1685,6 ,     0,     0,     1,     7,     7 }, // Swahili/Latin/Uganda
    {    114,     7,   205,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     720,9 ,     720,9 ,     53,10 ,     97,16 ,      37,5 ,    414,16 ,  10072,29 ,  10101,50 ,   2320,14 ,  10072,29 ,  10101,50 ,   2320,14 ,     309,2 ,     277,2 ,   45,4 ,   5,17 ,  22,23 , {83,69,75},      190,2 ,  14150,45 ,      13,5 ,       4,0 ,    4105,7 ,    4112,7 ,     2,     0,     1,     6,     7 }, // Swedish/Latin/Sweden
    {    114,     7,    73,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     720,9 ,     720,9 ,     53,10 ,     97,16 ,      37,5 ,    414,16 ,  10072,29 ,  10101,50 ,   2320,14 ,  10072,29 ,  10101,50 ,   2320,14 ,     309,2 ,     277,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   9086,19 ,      13,5 ,       4,0 ,    4105,7 ,    1088,7 ,     2,     1,     1,     6,     7 }, // Swedish/Latin/Finland
    {    114,     7,   248,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     720,9 ,     720,9 ,     53,10 ,     97,16 ,      37,5 ,    414,16 ,  10072,29 ,  10101,50 ,   2320,14 ,  10072,29 ,  10101,50 ,   2320,14 ,     309,2 ,     277,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   9086,19 ,      13,5 ,       4,0 ,    4105,7 ,    4119,5 ,     2,     1,     1,     6,     7 }, // Swedish/Latin/Aland Islands
    {    115,     7,   106,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Sardinian/Latin/Italy
    {    116,     2,   209,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,    553,18 ,      37,5 ,      8,10 ,  10151,28 ,  10179,55 ,  10234,14 ,  10151,28 ,  10179,55 ,  10234,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {84,74,83},      318,4 ,  14195,19 ,      13,5 ,       4,0 ,    4124,6 ,   4130,10 ,     2,     1,     1,     6,     7 }, // Tajik/Cyrillic/Tajikistan
    {    117,    27,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    729,13 ,    729,13 ,     269,6 ,    192,18 ,     359,7 ,    430,12 ,  10248,39 ,  10287,49 ,  10336,20 ,  10248,39 ,  10287,49 ,  10336,20 ,     311,8 ,     279,8 ,  977,7 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,  14214,49 ,       8,5 ,       4,0 ,    4140,5 ,    4145,7 ,     2,     1,     7,     7,     7 }, // Tamil/Tamil/India
    {    117,    27,   130,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    729,13 ,    729,13 ,     269,6 ,    192,18 ,     359,7 ,    430,12 ,  10248,39 ,  10287,49 ,  10336,20 ,  10248,39 ,  10287,49 ,  10336,20 ,     311,8 ,     279,8 ,  977,7 ,   5,17 ,  22,23 , {77,89,82},      174,2 ,  14263,61 ,       8,5 ,       4,0 ,    4140,5 ,    4152,7 ,     2,     1,     1,     6,     7 }, // Tamil/Tamil/Malaysia
    {    117,    27,   190,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    729,13 ,    729,13 ,     269,6 ,    192,18 ,     359,7 ,    430,12 ,  10248,39 ,  10287,49 ,  10336,20 ,  10248,39 ,  10287,49 ,  10336,20 ,     311,8 ,     279,8 ,  977,7 ,   5,17 ,  22,23 , {83,71,68},        6,1 ,  14324,61 ,       8,5 ,       4,0 ,    4140,5 ,   4159,11 ,     2,     1,     7,     6,     7 }, // Tamil/Tamil/Singapore
    {    117,    27,   198,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    729,13 ,    729,13 ,     269,6 ,    192,18 ,      37,5 ,      8,10 ,  10248,39 ,  10287,49 ,  10336,20 ,  10248,39 ,  10287,49 ,  10336,20 ,     311,8 ,     279,8 ,  977,7 ,   5,17 ,  22,23 , {76,75,82},      322,3 ,  14385,49 ,       8,5 ,       4,0 ,    4140,5 ,    4170,6 ,     2,     1,     1,     6,     7 }, // Tamil/Tamil/Sri Lanka
    {    118,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     742,9 ,     742,9 ,    495,10 ,   1233,23 ,      55,4 ,      59,9 ,  10356,36 ,  10392,56 ,  10448,14 ,  10356,36 ,  10392,56 ,  10448,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      123,1 ,  14434,21 ,       0,4 ,       4,0 ,    4176,5 ,    3524,6 ,     2,     1,     1,     6,     7 }, // Tatar/Cyrillic/Russia
    {    119,    28,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    751,11 ,    751,11 ,     339,8 ,   1256,18 ,      18,7 ,     25,12 ,  10462,32 ,  10494,60 ,  10554,18 ,  10462,32 ,  10494,60 ,  10554,18 ,       0,2 ,       0,2 ,  984,7 , 991,29 ,  22,23 , {73,78,82},      121,1 ,  14455,26 ,       4,4 ,       4,0 ,    4181,6 ,    4187,8 ,     2,     1,     7,     7,     7 }, // Telugu/Telugu/India
    {    120,    30,   211,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     118,5 ,     118,5 ,     762,8 ,     770,7 ,     269,6 ,   1274,19 ,      37,5 ,    442,28 ,  10572,23 ,  10595,68 ,  10663,16 ,  10572,23 ,  10595,68 ,  10663,16 ,    319,10 ,    287,10 , 1020,4 ,   5,17 ,  22,23 , {84,72,66},      325,1 ,  14481,16 ,       4,4 ,       4,0 ,    4195,3 ,    4195,3 ,     2,     1,     7,     6,     7 }, // Thai/Thai/Thailand
    {    121,    31,    44,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,   1293,23 ,      18,7 ,     25,12 ,  10679,51 ,  10730,79 ,  10809,27 ,  10679,51 ,  10730,79 ,  10809,27 ,     329,7 ,     297,8 ,   45,4 ,   5,17 ,  22,23 , {67,78,89},      133,1 ,  14497,13 ,       8,5 ,       4,0 ,    4198,8 ,    4206,6 ,     2,     1,     7,     6,     7 }, // Tibetan/Tibetan/China
    {    121,    31,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,   1293,23 ,      18,7 ,     25,12 ,  10679,51 ,  10730,79 ,  10809,27 ,  10679,51 ,  10730,79 ,  10809,27 ,     329,7 ,     297,8 ,   45,4 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,  14510,19 ,       8,5 ,       4,0 ,    4198,8 ,    4212,7 ,     2,     1,     7,     7,     7 }, // Tibetan/Tibetan/India
    {    122,    14,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,   1316,23 ,      18,7 ,     25,12 ,  10836,21 ,  10857,29 ,  10886,14 ,  10836,21 ,  10857,29 ,  10900,14 ,     336,7 ,     305,7 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,2 ,  14529,16 ,       4,4 ,       4,0 ,    4219,4 ,      92,5 ,     2,     1,     7,     6,     7 }, // Tigrinya/Ethiopic/Ethiopia
    {    122,    14,    67,    46,    44,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,   1316,23 ,      18,7 ,     25,12 ,  10836,21 ,  10857,29 ,  10900,14 ,  10836,21 ,  10857,29 ,  10900,14 ,     336,7 ,     305,7 ,   45,4 ,   5,17 ,  22,23 , {69,82,78},       41,3 ,       0,7 ,       4,4 ,       4,0 ,    4219,4 ,    4223,4 ,     2,     1,     1,     6,     7 }, // Tigrinya/Ethiopic/Eritrea
    {    123,     7,   214,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     777,8 ,     777,8 ,     777,8 ,     777,8 ,     269,6 ,     97,16 ,      18,7 ,     25,12 ,  10914,29 ,  10943,60 ,  11003,14 ,  10914,29 ,  10943,60 ,  11003,14 ,    343,10 ,     312,6 , 1024,5 , 1029,59 , 1088,65 , {84,79,80},      195,2 ,  14545,41 ,      13,5 ,       4,0 ,   4227,13 ,    1635,5 ,     2,     1,     1,     6,     7 }, // Tongan/Latin/Tonga
    {    124,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Tsonga/Latin/South Africa
    {    125,     7,   217,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     785,8 ,     785,8 ,    1339,9 ,   1348,16 ,      37,5 ,      8,10 ,  11017,28 ,  11045,54 ,  11099,14 ,  11017,28 ,  11045,54 ,  11099,14 ,     353,2 ,     318,2 ,  199,4 ,   5,17 ,  22,23 , {84,82,89},      252,1 ,  14586,40 ,       4,4 ,       4,0 ,    4240,6 ,    4246,7 ,     2,     1,     1,     6,     7 }, // Turkish/Latin/Turkey
    {    125,     7,    56,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     785,8 ,     785,8 ,    1339,9 ,   1348,16 ,      18,7 ,     25,12 ,  11017,28 ,  11045,54 ,  11099,14 ,  11017,28 ,  11045,54 ,  11099,14 ,     353,2 ,     318,2 ,  199,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8436,19 ,       4,4 ,       4,0 ,    4240,6 ,    4253,6 ,     2,     1,     1,     6,     7 }, // Turkish/Latin/Cyprus
    {    126,     7,   218,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8220,    8221,       0,6 ,       0,6 ,     793,8 ,     793,8 ,    495,10 ,   1348,16 ,      37,5 ,      8,10 ,  11113,28 ,  11141,54 ,  11195,14 ,  11209,28 ,  11237,54 ,  11195,14 ,    355,13 ,    320,14 , 1153,4 ,   5,17 ,  22,23 , {84,77,84},      326,3 ,  14626,49 ,      13,5 ,       4,0 ,   4259,12 ,   4271,12 ,     2,     1,     1,     6,     7 }, // Turkmen/Latin/Turkmenistan
    {    128,     1,    44,    46,    44,    59,    37,    48,    45,    43,   101,     187,     171,    8250,    8249,       0,6 ,       0,6 ,    195,10 ,     205,9 ,     53,10 ,   1364,17 ,      18,7 ,     25,12 ,  11291,21 ,  11312,55 ,  11367,14 ,  11291,21 ,  11312,55 ,  11367,14 ,    368,12 ,    334,12 ,   45,4 ,   5,17 ,  22,23 , {67,78,89},      243,1 ,  14675,40 ,       4,4 ,       4,0 ,    4283,8 ,    4291,5 ,     2,     1,     7,     6,     7 }, // Uighur/Arabic/China
    {    129,     2,   222,    44,   160,    59,    37,    48,    45,    43,  1077,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     133,7 ,     133,7 ,     156,8 ,   1381,22 ,      37,5 ,      8,10 ,   1454,21 ,  11381,56 ,  11437,14 ,   1454,21 ,  11381,56 ,  11437,14 ,     380,2 ,     346,2 , 1157,5 , 680,17 ,  22,23 , {85,65,72},      292,1 ,  14715,49 ,      13,5 ,       4,0 ,   4296,10 ,    4306,7 ,     2,     1,     1,     6,     7 }, // Ukrainian/Cyrillic/Ukraine
    {    130,     1,   163,    46,    44,    59,    37,    48,    45,    43,   101,    8221,    8220,    8217,    8216,     557,6 ,     557,6 ,    801,10 ,     811,9 ,     269,6 ,   1403,18 ,      18,7 ,     25,12 ,  11451,36 ,  11451,36 ,     85,14 ,  11451,36 ,  11451,36 ,     85,14 ,       0,2 ,       0,2 , 1162,4 , 1166,20 ,  22,23 , {80,75,82},      176,2 ,  14764,49 ,       4,4 ,       4,0 ,    4313,4 ,    3240,7 ,     2,     0,     7,     6,     7 }, // Urdu/Arabic/Pakistan
    {    130,     1,   100,  1643,  1644,    59,    37,  1776,    45,    43,   101,    8221,    8220,    8217,    8216,     557,6 ,     557,6 ,     820,6 ,     820,6 ,     269,6 ,   1403,18 ,      18,7 ,     25,12 ,  11451,36 ,  11451,36 ,     85,14 ,  11451,36 ,  11451,36 ,     85,14 ,       0,2 ,       0,2 , 1162,4 , 1166,20 ,  22,23 , {73,78,82},      121,1 ,  14813,42 ,       8,5 ,       4,0 ,    4313,4 ,    4317,5 ,     2,     1,     7,     7,     7 }, // Urdu/Arabic/India
    {    131,     7,   228,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8217,    8216,       0,6 ,       0,6 ,     826,8 ,     826,8 ,      27,8 ,   1421,18 ,      37,5 ,    403,11 ,  11487,32 ,  11519,61 ,  11580,14 ,  11487,32 ,  11519,61 ,  11580,14 ,     382,2 ,     348,2 ,  199,4 ,   5,17 ,  22,23 , {85,90,83},      329,4 ,  14855,58 ,      13,5 ,       4,0 ,    4322,6 ,   4328,11 ,     2,     0,     1,     6,     7 }, // Uzbek/Latin/Uzbekistan
    {    131,     1,     1,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     394,8 ,   1439,33 ,      55,4 ,    403,11 ,  11594,21 ,   7794,49 ,     85,14 ,  11594,21 ,   7794,49 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {65,70,78},      268,1 ,  14913,13 ,      13,5 ,       4,0 ,    4339,6 ,    3231,9 ,     0,     0,     6,     4,     5 }, // Uzbek/Arabic/Afghanistan
    {    131,     2,   228,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,    696,19 ,      37,5 ,     87,12 ,  11615,28 ,  11643,53 ,  11696,14 ,  11615,28 ,  11643,53 ,  11696,14 ,     384,2 ,     350,2 ,   45,4 ,   5,17 ,  22,23 , {85,90,83},      333,3 ,  14926,49 ,      13,5 ,       4,0 ,    4345,7 ,   4352,10 ,     2,     0,     1,     6,     7 }, // Uzbek/Cyrillic/Uzbekistan
    {    132,     7,   232,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     834,8 ,     834,8 ,    119,10 ,    192,18 ,      37,5 ,      8,10 ,  11710,33 ,  11743,55 ,  11798,21 ,  11710,33 ,  11743,55 ,  11798,21 ,     386,2 ,     352,2 ,   45,4 ,   5,17 ,  22,23 , {86,78,68},      336,1 ,  14975,33 ,      13,5 ,       4,0 ,   4362,10 ,    4372,8 ,     0,     0,     1,     6,     7 }, // Vietnamese/Latin/Vietnam
    {    133,     7,   260,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,   1472,23 ,      37,5 ,      8,10 ,  11819,21 ,  11840,43 ,  11883,14 ,  11897,28 ,  11840,43 ,  11883,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,       8,5 ,       4,0 ,    4380,7 ,       0,0 ,     2,     1,     1,     6,     7 }, // Volapuk/Latin/World
    {    134,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    842,11 ,    853,10 ,      27,8 ,     10,17 ,      37,5 ,      8,10 ,  11925,29 ,  11954,77 ,  12031,15 ,  12046,30 ,  11954,77 ,  12031,15 ,     388,2 ,     354,2 , 1186,7 ,   5,17 ,  22,23 , {71,66,80},      119,1 ,  15008,91 ,       4,4 ,       4,0 ,    4387,7 ,   4394,16 ,     2,     1,     1,     6,     7 }, // Welsh/Latin/United Kingdom
    {    135,     7,   187,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    528,10 ,   1495,17 ,      37,5 ,      8,10 ,  12076,28 ,  12104,50 ,  12076,28 ,  12076,28 ,  12104,50 ,  12076,28 ,     390,3 ,     356,3 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  15099,65 ,       8,5 ,       4,0 ,    4410,5 ,    4415,8 ,     0,     0,     1,     6,     7 }, // Wolof/Latin/Senegal
    {    136,     7,   195,    46,   160,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,  12154,28 ,  12182,61 ,     85,14 ,  12154,28 ,  12182,61 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,  15164,79 ,       4,4 ,       4,0 ,    4423,8 ,   4431,15 ,     2,     1,     7,     6,     7 }, // Xhosa/Latin/South Africa
    {    137,    18,   260,    46,    44,    59,    37,    48,    45,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     863,9 ,     863,9 ,      27,8 ,   1512,19 ,      37,5 ,      8,10 ,  12243,54 ,  12243,54 ,     85,14 ,  12243,54 ,  12243,54 ,     85,14 ,    393,11 ,    359,10 ,   45,4 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,      41,6 ,       4,0 ,    4446,6 ,    4452,5 ,     2,     1,     1,     6,     7 }, // Yiddish/Hebrew/World
    {    138,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,   1531,16 ,     470,3 ,      8,10 ,  12297,33 ,  12330,44 ,  12374,14 ,  12297,33 ,  12388,69 ,  12374,14 ,     404,5 ,     369,5 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      178,1 ,  15243,49 ,       4,4 ,       4,0 ,   4457,10 ,   4467,19 ,     2,     1,     1,     6,     7 }, // Yoruba/Latin/Nigeria
    {    138,     7,    23,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,   1531,16 ,     470,3 ,      8,10 ,  12457,33 ,  12490,44 ,  12534,14 ,  12457,33 ,  12548,69 ,  12534,14 ,     409,5 ,     374,5 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  15292,34 ,       4,4 ,       4,0 ,   4457,10 ,   4486,16 ,     0,     0,     1,     6,     7 }, // Yoruba/Latin/Benin
    {    140,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     872,9 ,     881,8 ,     547,6 ,     35,18 ,      37,5 ,      8,10 ,  12617,28 ,  12645,74 ,  12719,14 ,  12617,28 ,  12645,74 ,  12719,14 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,  15326,67 ,       4,4 ,       4,0 ,    4502,7 ,   4509,17 ,     2,     1,     7,     6,     7 }, // Zulu/Latin/South Africa
    {    141,     7,   161,    44,   160,    59,    37,    48,  8722,    43,   101,     171,     187,    8216,    8217,       0,6 ,       0,6 ,     187,8 ,     187,8 ,    495,10 ,    478,17 ,      37,5 ,    414,16 ,  12733,28 ,  12761,51 ,   2320,14 ,  12812,28 ,  12761,51 ,   2320,14 ,     414,9 ,    379,11 ,   45,4 ,   5,17 ,  22,23 , {78,79,75},      190,2 ,  10046,44 ,      13,5 ,       4,0 ,    4526,7 ,    4533,5 ,     2,     0,     1,     6,     7 }, // Norwegian Nynorsk/Latin/Norway
    {    142,     7,    27,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8221,    8216,    8217,       0,6 ,       0,6 ,     158,7 ,     158,7 ,   1547,11 ,    450,19 ,      37,5 ,      8,10 ,   2043,28 ,   2071,58 ,   2129,14 ,   2043,28 ,   2071,58 ,   2143,14 ,    423,10 ,     390,7 ,  319,7 ,   5,17 ,  22,23 , {66,65,77},      144,2 , 15393,170 ,      13,5 ,       4,0 ,    4538,8 ,    629,19 ,     2,     1,     1,     6,     7 }, // Bosnian/Latin/Bosnia And Herzegowina
    {    142,     2,    27,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     111,7 ,     111,7 ,    1091,7 ,   1098,20 ,      37,5 ,      8,10 ,  12840,28 ,  12868,56 ,   8907,14 ,  12840,28 ,  12868,56 ,   8907,14 ,    245,11 ,    397,13 ,   45,4 ,   5,17 ,  22,23 , {66,65,77},      296,2 , 15563,152 ,      13,5 ,       4,0 ,    4546,8 ,   3600,19 ,     2,     1,     1,     6,     7 }, // Bosnian/Cyrillic/Bosnia And Herzegowina
    {    143,    29,   131,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {77,86,82},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     5,     6,     7 }, // Divehi/Thaana/Maldives
    {    144,     7,   251,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,     80,17 ,      37,5 ,      8,10 ,  12924,30 ,  12954,57 ,     85,14 ,  12924,30 ,  12954,57 ,     85,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {71,66,80},      119,1 ,       0,7 ,       4,4 ,       4,0 ,    4554,5 ,   4559,12 ,     2,     1,     1,     6,     7 }, // Manx/Latin/Isle Of Man
    {    145,     7,   224,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     97,16 ,      37,5 ,      8,10 ,  13011,28 ,  13039,61 ,     85,14 ,  13011,28 ,  13039,61 ,     85,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {71,66,80},      119,1 ,       0,7 ,       4,4 ,       4,0 ,    4571,8 ,   4579,14 ,     2,     1,     1,     6,     7 }, // Cornish/Latin/United Kingdom
    {    146,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    1558,8 ,   1566,18 ,      18,7 ,     25,12 ,  13100,28 ,  13128,49 ,  13177,14 ,  13100,28 ,  13128,49 ,  13177,14 ,     433,2 ,     410,2 ,   45,4 ,   5,17 ,  22,23 , {71,72,83},      167,3 ,  15715,17 ,       4,4 ,       4,0 ,    4593,4 ,    4597,5 ,     2,     1,     1,     6,     7 }, // Akan/Latin/Ghana
    {    147,    13,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    1584,6 ,     97,16 ,      18,7 ,     25,12 ,  13191,49 ,  13191,49 ,  13240,20 ,  13191,49 ,  13191,49 ,  13240,20 ,       0,2 ,       0,2 , 1193,4 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,  15732,31 ,       4,4 ,       4,0 ,    4602,6 ,    2662,4 ,     2,     1,     7,     7,     7 }, // Konkani/Devanagari/India
    {    148,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {71,72,83},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Ga/Latin/Ghana
    {    149,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     889,9 ,     712,8 ,     269,6 ,     10,17 ,      37,5 ,      8,10 ,  13260,29 ,  13289,54 ,     85,14 ,  13260,29 ,  13289,54 ,     85,14 ,     435,7 ,     412,7 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      178,1 ,  15763,12 ,       4,4 ,       4,0 ,   4608,10 ,    4618,8 ,     2,     1,     1,     6,     7 }, // Igbo/Latin/Nigeria
    {    150,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  13343,28 ,  13371,74 ,  13445,14 ,  13343,28 ,  13371,74 ,  13445,14 ,     442,9 ,     419,7 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  15775,23 ,       4,4 ,       4,0 ,    4626,7 ,    1191,5 ,     2,     1,     7,     6,     7 }, // Kamba/Latin/Kenya
    {    151,    33,   103,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,81,68},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     6,     5,     6 }, // Syriac/Syriac/Iraq
    {    152,    14,    67,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,82,78},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Blin/Ethiopic/Eritrea
    {    153,    14,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Geez/Ethiopic/Ethiopia
    {    155,     7,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Sidamo/Latin/Ethiopia
    {    156,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      178,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Atsam/Latin/Nigeria
    {    157,    14,    67,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,82,78},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Tigre/Ethiopic/Eritrea
    {    158,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      178,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Jju/Latin/Nigeria
    {    159,     7,   106,    44,    46,    59,    37,    48,    45,    43,   101,    8216,    8217,    8220,    8221,       0,6 ,       0,6 ,     249,7 ,     249,7 ,      27,8 ,   1590,27 ,      37,5 ,      8,10 ,  13459,28 ,  13487,50 ,   3107,14 ,  13459,28 ,  13487,50 ,   3107,14 ,     451,2 ,     426,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,       8,5 ,       4,0 ,    4633,6 ,    4639,6 ,     2,     1,     1,     6,     7 }, // Friulian/Latin/Italy
    {    160,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Venda/Latin/South Africa
    {    161,     7,    83,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    898,11 ,    909,10 ,     547,6 ,   1617,23 ,    473,12 ,    485,17 ,  13537,28 ,  13565,44 ,  13609,14 ,  13537,28 ,  13565,44 ,  13609,14 ,     453,3 ,     428,5 ,   45,4 ,   5,17 ,  22,23 , {71,72,83},      167,3 ,  15798,37 ,       4,4 ,       4,0 ,    4645,6 ,   4651,12 ,     2,     1,     1,     6,     7 }, // Ewe/Latin/Ghana
    {    161,     7,   212,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,    898,11 ,    909,10 ,     547,6 ,   1617,23 ,      37,5 ,      8,10 ,  13537,28 ,  13565,44 ,  13609,14 ,  13537,28 ,  13565,44 ,  13609,14 ,     453,3 ,     428,5 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 , 15835,106 ,       4,4 ,       4,0 ,    4645,6 ,   4663,11 ,     0,     0,     1,     6,     7 }, // Ewe/Latin/Togo
    {    162,    14,    69,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,84,66},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Walamo/Ethiopic/Ethiopia
    {    163,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     269,6 ,     10,17 ,      18,7 ,     25,12 ,  13623,21 ,  13644,57 ,     85,14 ,  13623,21 ,  13644,57 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,       0,7 ,       4,4 ,       4,0 ,   4674,14 ,   4688,19 ,     2,     1,     7,     6,     7 }, // Hawaiian/Latin/United States
    {    164,     7,   157,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      178,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Tyap/Latin/Nigeria
    {    165,     7,   129,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {77,87,75},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Nyanja/Latin/Malawi
    {    166,     7,   170,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     919,9 ,     928,8 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,  13701,28 ,  13729,55 ,  13701,28 ,  13701,28 ,  13729,55 ,  13701,28 ,       0,2 ,       0,2 ,    0,5 ,   5,17 ,  22,23 , {80,72,80},      179,1 ,  15941,58 ,       4,4 ,       4,0 ,    4707,8 ,    4715,9 ,     2,     1,     7,     6,     7 }, // Filipino/Latin/Philippines
    {    167,     7,   206,    46,  8217,    59,    37,    48,  8722,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,     264,9 ,     264,9 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,  13784,28 ,  13812,63 ,   3695,14 ,  13784,28 ,  13812,63 ,   3695,14 ,    456,12 ,    433,11 ,   45,4 ,   5,17 ,  22,23 , {67,72,70},      224,3 ,  15999,55 ,      13,5 ,       4,0 ,   4724,16 ,    4740,7 ,     2,     0,     1,     6,     7 }, // Swiss German/Latin/Switzerland
    {    167,     7,    74,    46,  8217,    59,    37,    48,  8722,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,     264,9 ,     264,9 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,  13784,28 ,  13812,63 ,   3695,14 ,  13784,28 ,  13812,63 ,   3695,14 ,    456,12 ,    433,11 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8436,19 ,      13,5 ,       4,0 ,   4724,16 ,   4747,10 ,     2,     1,     1,     6,     7 }, // Swiss German/Latin/France
    {    167,     7,   123,    46,  8217,    59,    37,    48,  8722,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,     264,9 ,     264,9 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,  13784,28 ,  13812,63 ,   3695,14 ,  13784,28 ,  13812,63 ,   3695,14 ,    456,12 ,    433,11 ,   45,4 ,   5,17 ,  22,23 , {67,72,70},      224,3 ,  15999,55 ,      13,5 ,       4,0 ,   4724,16 ,   4757,13 ,     2,     0,     1,     6,     7 }, // Swiss German/Latin/Liechtenstein
    {    168,    34,    44,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      18,7 ,     25,12 ,  13875,21 ,  13896,28 ,  13924,14 ,  13875,21 ,  13896,28 ,  13924,14 ,     468,2 ,     444,2 ,   45,4 ,   5,17 ,  22,23 , {67,78,89},      133,1 ,       0,7 ,       8,5 ,       4,0 ,    4770,3 ,    4773,2 ,     2,     1,     7,     6,     7 }, // Sichuan Yi/Yi/China
    {    169,     7,   121,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {76,82,68},        6,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Kpelle/Latin/Liberia
    {    170,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     456,8 ,     456,8 ,     365,7 ,   1640,23 ,    502,10 ,    512,19 ,  13938,28 ,  13966,65 ,   3695,14 ,  13938,28 ,  13966,65 ,   3695,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  16054,15 ,      13,5 ,       4,0 ,   4775,14 ,   4789,11 ,     2,     1,     1,     6,     7 }, // Low German/Latin/Germany
    {    170,     7,   151,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     456,8 ,     456,8 ,     365,7 ,   1640,23 ,    502,10 ,    512,19 ,  13938,28 ,  13966,65 ,   3695,14 ,  13938,28 ,  13966,65 ,   3695,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  16054,15 ,      13,5 ,       4,0 ,   4775,14 ,   4800,12 ,     2,     1,     1,     6,     7 }, // Low German/Latin/Netherlands
    {    171,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // South Ndebele/Latin/South Africa
    {    172,     7,   195,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {90,65,82},        5,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Northern Sotho/Latin/South Africa
    {    173,     7,   161,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     223,8 ,     223,8 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,  14031,33 ,  14064,75 ,  14139,14 ,  14031,33 ,  14064,75 ,  14139,14 ,    470,11 ,    446,13 ,   45,4 ,   5,17 ,  22,23 , {78,79,75},      190,2 ,  16069,63 ,      13,5 ,       4,0 ,   4812,15 ,    4827,5 ,     2,     0,     1,     6,     7 }, // Northern Sami/Latin/Norway
    {    173,     7,    73,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     223,8 ,     223,8 ,    495,10 ,     97,16 ,      37,5 ,      8,10 ,  14153,21 ,  14174,70 ,  14244,14 ,  14153,21 ,  14174,70 ,  14244,14 ,     481,2 ,     459,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  16132,23 ,      13,5 ,       4,0 ,   4812,15 ,    4832,6 ,     2,     1,     1,     6,     7 }, // Northern Sami/Latin/Finland
    {    173,     7,   205,    44,   160,    59,    37,    48,  8722,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,     223,8 ,     223,8 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,  14031,33 ,  14064,75 ,  14139,14 ,  14031,33 ,  14064,75 ,  14139,14 ,    470,11 ,    446,13 ,   45,4 ,   5,17 ,  22,23 , {83,69,75},      190,2 ,  16155,63 ,      13,5 ,       4,0 ,   4812,15 ,    4838,6 ,     2,     0,     1,     6,     7 }, // Northern Sami/Latin/Sweden
    {    174,     7,   208,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {84,87,68},      337,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     7,     6,     7 }, // Taroko/Latin/Taiwan
    {    175,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  14258,28 ,  14286,62 ,  14348,14 ,  14258,28 ,  14286,62 ,  14348,14 ,     483,6 ,     461,3 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16218,24 ,       4,4 ,       4,0 ,    4844,8 ,    1191,5 ,     2,     1,     7,     6,     7 }, // Gusii/Latin/Kenya
    {    176,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  14362,28 , 14390,105 ,  14495,14 ,  14362,28 , 14390,105 ,  14495,14 ,    489,10 ,    464,10 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16218,24 ,       4,4 ,       4,0 ,    4852,7 ,    1191,5 ,     2,     1,     7,     6,     7 }, // Taita/Latin/Kenya
    {    177,     7,   187,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  14509,28 ,  14537,59 ,  14596,14 ,  14509,28 ,  14537,59 ,  14596,14 ,     499,6 ,     474,7 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  16242,26 ,      13,5 ,       4,0 ,    4859,6 ,    4415,8 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Senegal
    {    177,     7,    34,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  14509,28 ,  14537,59 ,  14596,14 ,  14509,28 ,  14537,59 ,  14596,14 ,     499,6 ,     474,7 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  16242,26 ,      13,5 ,       4,0 ,    4859,6 ,   4865,14 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Burkina Faso
    {    177,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  14509,28 ,  14537,59 ,  14596,14 ,  14509,28 ,  14537,59 ,  14596,14 ,     499,6 ,     474,7 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  16268,25 ,      13,5 ,       4,0 ,    4859,6 ,    4879,8 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Cameroon
    {    177,     7,    80,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      18,7 ,     25,12 ,  14509,28 ,  14537,59 ,  14596,14 ,  14509,28 ,  14537,59 ,  14596,14 ,     499,6 ,     474,7 ,   45,4 ,   5,17 ,  22,23 , {71,77,68},      166,1 ,  16293,20 ,      13,5 ,       4,0 ,    4859,6 ,    4887,6 ,     2,     1,     1,     6,     7 }, // Fulah/Latin/Gambia
    {    177,     7,    83,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      18,7 ,     25,12 ,  14509,28 ,  14537,59 ,  14596,14 ,  14509,28 ,  14537,59 ,  14596,14 ,     499,6 ,     474,7 ,   45,4 ,   5,17 ,  22,23 , {71,72,83},      167,3 ,       0,7 ,      13,5 ,       4,0 ,    4859,6 ,    4893,5 ,     2,     1,     1,     6,     7 }, // Fulah/Latin/Ghana
    {    177,     7,    91,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  14509,28 ,  14537,59 ,  14596,14 ,  14509,28 ,  14537,59 ,  14596,14 ,     499,6 ,     474,7 ,   45,4 ,   5,17 ,  22,23 , {71,78,70},      216,2 ,       0,7 ,      13,5 ,       4,0 ,    4859,6 ,    4898,4 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Guinea
    {    177,     7,    92,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  14509,28 ,  14537,59 ,  14596,14 ,  14509,28 ,  14537,59 ,  14596,14 ,     499,6 ,     474,7 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  16242,26 ,      13,5 ,       4,0 ,    4859,6 ,   4902,12 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Guinea Bissau
    {    177,     7,   121,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      18,7 ,     25,12 ,  14509,28 ,  14537,59 ,  14596,14 ,  14509,28 ,  14537,59 ,  14596,14 ,     499,6 ,     474,7 ,   45,4 ,   5,17 ,  22,23 , {76,82,68},        6,1 ,  16313,23 ,      13,5 ,       4,0 ,    4859,6 ,    4914,9 ,     2,     1,     1,     6,     7 }, // Fulah/Latin/Liberia
    {    177,     7,   136,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      18,7 ,     25,12 ,  14509,28 ,  14537,59 ,  14596,14 ,  14509,28 ,  14537,59 ,  14596,14 ,     499,6 ,     474,7 ,   45,4 ,   5,17 ,  22,23 , {77,82,85},      219,2 ,  16336,22 ,      13,5 ,       4,0 ,    4859,6 ,    4923,8 ,     2,     1,     1,     6,     7 }, // Fulah/Latin/Mauritania
    {    177,     7,   156,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  14509,28 ,  14537,59 ,  14596,14 ,  14509,28 ,  14537,59 ,  14596,14 ,     499,6 ,     474,7 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  16242,26 ,      13,5 ,       4,0 ,    4859,6 ,    4931,6 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Niger
    {    177,     7,   157,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  14509,28 ,  14537,59 ,  14596,14 ,  14509,28 ,  14537,59 ,  14596,14 ,     499,6 ,     474,7 ,   45,4 ,   5,17 ,  22,23 , {78,71,78},      178,1 ,  16358,23 ,      13,5 ,       4,0 ,    4859,6 ,    4937,9 ,     2,     1,     1,     6,     7 }, // Fulah/Latin/Nigeria
    {    177,     7,   189,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      18,7 ,     25,12 ,  14509,28 ,  14537,59 ,  14596,14 ,  14509,28 ,  14537,59 ,  14596,14 ,     499,6 ,     474,7 ,   45,4 ,   5,17 ,  22,23 , {83,76,76},      187,2 ,  16381,25 ,      13,5 ,       4,0 ,    4859,6 ,   4946,11 ,     0,     0,     1,     6,     7 }, // Fulah/Latin/Sierra Leone
    {    177,   134,    91,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {71,78,70},      216,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Fulah/Adlam/Guinea
    {    178,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  14610,28 ,  14638,63 ,  14701,14 ,  14610,28 ,  14638,63 ,  14701,14 ,     505,6 ,     481,8 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16406,23 ,       4,4 ,       4,0 ,    4957,6 ,    1191,5 ,     2,     1,     7,     6,     7 }, // Kikuyu/Latin/Kenya
    {    179,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  14715,28 , 14743,105 ,  14848,14 ,  14715,28 , 14743,105 ,  14848,14 ,     511,7 ,     489,5 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16429,25 ,       4,4 ,       4,0 ,    4963,8 ,    1191,5 ,     2,     1,     7,     6,     7 }, // Samburu/Latin/Kenya
    {    180,     7,   146,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,    669,27 ,      37,5 ,      8,10 ,  14862,28 ,  14890,55 ,  14945,14 ,  14862,28 ,  14890,55 ,  14945,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {77,90,78},      278,3 ,  16454,28 ,       0,4 ,       4,0 ,    4971,4 ,   3371,10 ,     2,     1,     7,     6,     7 }, // Sena/Latin/Mozambique
    {    181,     7,   240,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  14959,28 ,  14987,50 ,  15037,14 ,  14959,28 ,  14987,50 ,  15037,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,  16482,24 ,       4,4 ,       4,0 ,   4975,10 ,    1815,8 ,     2,     1,     7,     6,     7 }, // North Ndebele/Latin/Zimbabwe
    {    182,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  15051,29 ,  15080,65 ,  15145,14 ,  15051,29 ,  15080,65 ,  15145,14 ,     518,8 ,     494,7 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      192,3 ,  16506,25 ,       4,4 ,       4,0 ,    4985,9 ,    1620,8 ,     2,     0,     1,     6,     7 }, // Rombo/Latin/Tanzania
    {    183,     9,   145,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  15159,30 ,  15189,47 ,     85,14 ,  15159,30 ,  15189,47 ,     85,14 ,     526,6 ,     501,8 ,   45,4 ,   5,17 ,  22,23 , {77,65,68},        0,0 ,  16531,21 ,       0,4 ,       4,0 ,    4994,7 ,    5001,6 ,     2,     1,     1,     6,     7 }, // Tachelhit/Tifinagh/Morocco
    {    183,     7,   145,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  15236,30 ,  15266,48 ,     85,14 ,  15236,30 ,  15266,48 ,     85,14 ,     532,6 ,     509,8 ,   45,4 ,   5,17 ,  22,23 , {77,65,68},        0,0 ,  16552,21 ,       0,4 ,       4,0 ,   5007,10 ,    5017,6 ,     2,     1,     1,     6,     7 }, // Tachelhit/Latin/Morocco
    {    184,     7,     3,    44,   160,    59,    37,    48,    45,    43,   122,     171,     187,    8220,    8221,       0,6 ,       0,6 ,    936,12 ,    948,11 ,     415,8 ,     97,16 ,      18,7 ,     25,12 ,  15314,28 ,  15342,34 ,  15376,14 ,  15390,30 ,  15420,51 ,  15471,14 ,     538,7 ,     517,9 , 1197,7 , 1204,21 ,  22,23 , {68,90,68},      205,2 ,  16573,53 ,       0,4 ,       4,0 ,    5023,9 ,    5032,8 ,     2,     1,     6,     5,     6 }, // Kabyle/Latin/Algeria
    {    185,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  15485,28 ,  15513,74 ,  15587,14 ,  15485,28 ,  15513,74 ,  15587,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,71,88},      197,3 ,  16626,26 ,       4,4 ,       4,0 ,   5040,10 ,    1685,6 ,     0,     0,     1,     7,     7 }, // Nyankole/Latin/Uganda
    {    186,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  15601,28 ,  15629,82 ,  15711,14 ,  15601,28 ,  15629,82 ,  15711,14 ,     545,7 ,     526,7 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      192,3 ,  16652,29 ,       0,4 ,       4,0 ,    5050,6 ,   5056,10 ,     2,     0,     1,     6,     7 }, // Bena/Latin/Tanzania
    {    187,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  15725,28 ,  15753,62 ,  15815,14 ,  15725,28 ,  15753,62 ,  15815,14 ,     552,5 ,     533,9 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      192,3 ,  16681,27 ,       4,4 ,       4,0 ,    5066,8 ,    1620,8 ,     2,     0,     1,     6,     7 }, // Vunjo/Latin/Tanzania
    {    188,     7,   132,    46,    44,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  15829,28 ,  15857,44 ,  15901,14 ,  15829,28 ,  15857,44 ,  15901,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  16708,24 ,       4,4 ,       4,0 ,    5074,9 ,    2184,4 ,     0,     0,     1,     6,     7 }, // Bambara/Latin/Mali
    {    188,    75,   132,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Bambara/Nko/Mali
    {    189,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  15915,28 ,  15943,64 ,  16007,14 ,  15915,28 ,  15943,64 ,  16007,14 ,     557,2 ,     542,2 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16218,24 ,       4,4 ,       4,0 ,    5083,6 ,    1191,5 ,     2,     1,     7,     6,     7 }, // Embu/Latin/Kenya
    {    190,    12,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     959,9 ,     968,8 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,  16021,28 ,  16049,49 ,  16098,14 ,  16021,28 ,  16049,49 ,  16098,14 ,     559,3 ,     544,6 , 1225,6 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,  16732,25 ,       4,4 ,       4,0 ,    5089,3 ,   5092,15 ,     2,     1,     7,     6,     7 }, // Cherokee/Cherokee/United States
    {    191,     7,   137,    46,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  16112,27 ,  16139,48 ,  16187,14 ,  16112,27 ,  16139,48 ,  16187,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {77,85,82},      176,2 ,  16757,21 ,      41,6 ,       4,0 ,   5107,14 ,    5121,5 ,     2,     0,     1,     6,     7 }, // Morisyen/Latin/Mauritius
    {    192,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  16201,28 , 16229,133 ,  15145,14 ,  16201,28 , 16229,133 ,  15145,14 ,     562,4 ,     550,5 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      192,3 ,  16681,27 ,       4,4 ,       4,0 ,   5126,10 ,    1620,8 ,     2,     0,     1,     6,     7 }, // Makonde/Latin/Tanzania
    {    193,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8221,    8221,    8217,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  16362,36 ,  16398,63 ,  16461,14 ,  16362,36 ,  16398,63 ,  16461,14 ,     566,3 ,     555,3 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      192,3 ,  16778,29 ,      41,6 ,       4,0 ,    5136,8 ,    5144,9 ,     2,     0,     1,     6,     7 }, // Langi/Latin/Tanzania
    {    194,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  16475,28 ,  16503,66 ,  16569,14 ,  16475,28 ,  16503,66 ,  16569,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,71,88},      197,3 ,  16807,26 ,       0,4 ,       4,0 ,    5153,7 ,    5160,7 ,     0,     0,     1,     7,     7 }, // Ganda/Latin/Uganda
    {    195,     7,   239,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,  16583,80 ,  16583,80 ,     85,14 ,  16583,80 ,  16583,80 ,     85,14 ,     569,8 ,     558,7 ,   45,4 ,   5,17 ,  22,23 , {90,77,87},      131,1 ,       0,7 ,       4,4 ,       4,0 ,    5167,9 ,    1809,6 ,     2,     1,     1,     6,     7 }, // Bemba/Latin/Zambia
    {    196,     7,    39,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     158,7 ,     158,7 ,    119,10 ,   1663,27 ,      37,5 ,      8,10 ,  16663,28 ,  16691,73 ,  16764,14 ,  16663,28 ,  16778,73 ,  16764,14 ,      68,2 ,      65,2 ,   45,4 ,   5,17 ,  22,23 , {67,86,69},      277,1 ,  16833,43 ,      13,5 ,       4,0 ,   5176,12 ,   5188,10 ,     2,     1,     1,     6,     7 }, // Kabuverdianu/Latin/Cape Verde
    {    197,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  16851,28 ,  16879,51 ,  16930,14 ,  16851,28 ,  16879,51 ,  16930,14 ,     577,2 ,     565,2 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16218,24 ,       4,4 ,       4,0 ,    5198,6 ,    1191,5 ,     2,     1,     7,     6,     7 }, // Meru/Latin/Kenya
    {    198,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  16944,28 ,  16972,53 ,  17025,14 ,  16944,28 ,  16972,53 ,  17025,14 ,     579,6 ,    567,10 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16876,26 ,       4,4 ,       4,0 ,    5204,8 ,   5212,12 ,     2,     1,     7,     6,     7 }, // Kalenjin/Latin/Kenya
    {    199,     7,   148,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,  17039,23 ,  17062,92 ,  17154,14 ,  17039,23 ,  17062,92 ,  17154,14 ,     585,7 ,     577,5 ,   45,4 ,   5,17 ,  22,23 , {78,65,68},        6,1 ,  16902,22 ,       4,4 ,       4,0 ,   5224,13 ,    5237,8 ,     2,     1,     1,     6,     7 }, // Nama/Latin/Namibia
    {    200,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  15725,28 ,  15753,62 ,  15815,14 ,  15725,28 ,  15753,62 ,  15815,14 ,     552,5 ,     533,9 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      192,3 ,  16681,27 ,       4,4 ,       4,0 ,    5245,9 ,    1620,8 ,     2,     0,     1,     6,     7 }, // Machame/Latin/Tanzania
    {    201,     7,    82,    44,   160,    59,    37,    48,  8722,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     456,8 ,     456,8 ,   1141,10 ,   1690,23 ,      37,5 ,      8,10 ,  17168,28 ,  17196,72 ,   3695,14 ,  17168,28 ,  17196,72 ,   3695,14 ,    592,16 ,    582,16 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  16924,11 ,      13,5 ,       4,0 ,    5254,6 ,   5260,11 ,     2,     1,     1,     6,     7 }, // Colognian/Latin/Germany
    {    202,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  15725,28 ,  17268,58 ,  15145,14 ,  15725,28 ,  17268,58 ,  15145,14 ,     608,9 ,     598,6 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16935,25 ,       4,4 ,       4,0 ,    5271,3 ,    1191,5 ,     2,     1,     7,     6,     7 }, // Masai/Latin/Kenya
    {    202,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  15725,28 ,  17268,58 ,  15145,14 ,  15725,28 ,  17268,58 ,  15145,14 ,     608,9 ,     598,6 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      192,3 ,  16960,28 ,       4,4 ,       4,0 ,    5271,3 ,    5274,8 ,     2,     0,     1,     6,     7 }, // Masai/Latin/Tanzania
    {    203,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  17326,35 ,  17361,65 ,  17426,14 ,  17326,35 ,  17361,65 ,  17426,14 ,     617,6 ,     604,6 ,   45,4 ,   5,17 ,  22,23 , {85,71,88},      197,3 ,  16807,26 ,      13,5 ,       4,0 ,    5282,7 ,    5160,7 ,     0,     0,     1,     7,     7 }, // Soga/Latin/Uganda
    {    204,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  17440,21 ,  17461,75 ,     85,14 ,  17440,21 ,  17461,75 ,     85,14 ,      64,4 ,      61,4 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  16988,23 ,       4,4 ,     114,6 ,    5289,7 ,    1191,5 ,     2,     1,     7,     6,     7 }, // Luyia/Latin/Kenya
    {    205,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  17536,28 ,  10012,60 ,  15815,14 ,  17536,28 ,  10012,60 ,  15815,14 ,     623,9 ,     610,8 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      192,3 ,  17011,28 ,      13,5 ,       4,0 ,    5296,6 ,    5302,8 ,     2,     0,     1,     6,     7 }, // Asu/Latin/Tanzania
    {    206,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  17564,28 ,  17592,69 ,  17661,14 ,  17564,28 ,  17592,69 ,  17661,14 ,     632,9 ,     618,6 ,   45,4 ,   5,17 ,  22,23 , {85,71,88},      197,3 ,  17039,28 ,       4,4 ,       4,0 ,    5310,6 ,    1685,6 ,     0,     0,     1,     7,     7 }, // Teso/Latin/Uganda
    {    206,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  17564,28 ,  17592,69 ,  17661,14 ,  17564,28 ,  17592,69 ,  17661,14 ,     632,9 ,     618,6 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  17067,27 ,       4,4 ,       4,0 ,    5310,6 ,    5316,5 ,     2,     1,     7,     6,     7 }, // Teso/Latin/Kenya
    {    207,     7,    67,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,82,78},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Saho/Latin/Eritrea
    {    208,     7,   132,    46,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  17675,28 ,  17703,53 ,  17756,14 ,  17675,28 ,  17703,53 ,  17756,14 ,     641,6 ,     624,6 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  17094,23 ,       0,4 ,       4,0 ,   5321,11 ,    5332,5 ,     0,     0,     1,     6,     7 }, // Koyra Chiini/Latin/Mali
    {    209,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  15725,28 ,  15753,62 ,  15815,14 ,  15725,28 ,  15753,62 ,  15815,14 ,     552,5 ,     533,9 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      192,3 ,  16681,27 ,       0,4 ,       4,0 ,    5337,6 ,    1620,8 ,     2,     0,     1,     6,     7 }, // Rwa/Latin/Tanzania
    {    210,     7,   111,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  17770,28 ,  17798,69 ,  17867,14 ,  17770,28 ,  17798,69 ,  17867,14 ,     647,2 ,     630,2 ,   45,4 ,   5,17 ,  22,23 , {75,69,83},        2,3 ,  17117,23 ,       0,4 ,       4,0 ,    5343,6 ,    1191,5 ,     2,     1,     7,     6,     7 }, // Luo/Latin/Kenya
    {    211,     7,   221,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  15485,28 ,  15513,74 ,  15587,14 ,  15485,28 ,  15513,74 ,  15587,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,71,88},      197,3 ,  16626,26 ,       4,4 ,       4,0 ,    5349,6 ,    1685,6 ,     0,     0,     1,     7,     7 }, // Chiga/Latin/Uganda
    {    212,     7,   145,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  17881,28 ,  17909,48 ,  17957,14 ,  17881,28 ,  17909,48 ,  17957,14 ,     649,9 ,    632,10 ,   45,4 ,   5,17 ,  22,23 , {77,65,68},        0,0 ,  17140,22 ,      13,5 ,       4,0 ,   5355,17 ,    5372,6 ,     2,     1,     1,     6,     7 }, // Central Morocco Tamazight/Latin/Morocco
    {    213,     7,   132,    46,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  17971,28 ,  17999,54 ,  17756,14 ,  17971,28 ,  17999,54 ,  17756,14 ,     641,6 ,     624,6 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  17094,23 ,       0,4 ,       4,0 ,   5378,15 ,    5332,5 ,     0,     0,     1,     6,     7 }, // Koyraboro Senni/Latin/Mali
    {    214,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  18053,28 ,  18081,63 ,  18144,14 ,  18053,28 ,  18081,63 ,  18144,14 ,     658,5 ,     642,8 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      192,3 ,  17162,27 ,       0,4 ,       4,0 ,    5393,9 ,    1620,8 ,     2,     0,     1,     6,     7 }, // Shambala/Latin/Tanzania
    {    215,    13,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,  18158,33 ,  18191,54 ,  18245,19 ,  18158,33 ,  18191,54 ,  18245,19 ,     663,3 ,     650,6 ,   45,4 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,  17189,10 ,       8,5 ,       4,0 ,    5402,4 ,    2662,4 ,     2,     1,     7,     7,     7 }, // Bodo/Devanagari/India
    {    218,     2,   178,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,  18264,25 ,  18289,45 ,  18334,17 ,  18264,25 ,  18289,45 ,  18264,25 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      123,1 ,  17199,43 ,      13,5 ,       4,0 ,    5406,7 ,    5413,5 ,     2,     1,     1,     6,     7 }, // Chechen/Cyrillic/Russia
    {    219,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,     976,8 ,     976,8 ,   1003,10 ,   1713,23 ,      37,5 ,      8,10 ,  18351,37 ,  18388,68 ,  11437,14 ,  18351,37 ,  18388,68 ,  11437,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      123,1 ,  17242,44 ,      13,5 ,       4,0 ,   5418,19 ,    5437,7 ,     2,     1,     1,     6,     7 }, // Church/Cyrillic/Russia
    {    220,     2,   178,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      123,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Chuvash/Cyrillic/Russia
    {    230,     7,    49,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  18456,28 ,  18484,50 ,  18534,14 ,  18456,28 ,  18484,50 ,  18534,14 ,     666,5 ,     656,6 ,   45,4 ,   5,17 ,  22,23 , {67,68,70},      210,2 ,  17286,24 ,       0,4 ,       4,0 ,    5444,8 ,   5452,16 ,     2,     1,     1,     6,     7 }, // Luba Katanga/Latin/Congo Kinshasa
    {    231,     7,   125,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,    984,10 ,    984,10 ,     156,8 ,    622,18 ,      37,5 ,      8,10 ,  18548,28 ,  18576,65 ,   3695,14 ,  18641,35 ,  18576,65 ,   3695,14 ,     671,5 ,     662,8 ,  445,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   8436,19 ,      13,5 ,       4,0 ,   5468,14 ,   5482,10 ,     2,     1,     1,     6,     7 }, // Luxembourgish/Latin/Luxembourg
    {    236,     7,    21,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Walloon/Latin/Belgium
    {    237,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,    8218,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  18676,28 ,  18704,72 ,  18776,14 ,  18676,28 ,  18704,72 ,  18776,14 ,     676,3 ,     670,3 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  17310,21 ,       0,4 ,       4,0 ,    5492,5 ,    5497,7 ,     0,     0,     1,     6,     7 }, // Aghem/Latin/Cameroon
    {    238,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  18790,28 ,  18818,70 ,  18888,14 ,  18790,28 ,  18818,70 ,  18888,14 ,    679,10 ,     673,9 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  17331,22 ,      13,5 ,       4,0 ,    5504,5 ,    5509,8 ,     0,     0,     1,     6,     7 }, // Basaa/Latin/Cameroon
    {    239,     7,   156,    46,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  17971,28 ,  18902,53 ,  18955,14 ,  17971,28 ,  18902,53 ,  18955,14 ,     689,8 ,    682,10 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  17094,23 ,       0,4 ,       4,0 ,   5517,10 ,    5527,5 ,     0,     0,     1,     6,     7 }, // Zarma/Latin/Niger
    {    240,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  18969,28 ,  18997,45 ,  19042,14 ,  18969,28 ,  18997,45 ,  19042,14 ,     697,5 ,     692,6 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,       0,7 ,      13,5 ,       4,0 ,    5532,5 ,    1981,8 ,     0,     0,     1,     6,     7 }, // Duala/Latin/Cameroon
    {    241,     7,   187,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  19056,28 ,  19084,50 ,  19134,14 ,  19056,28 ,  19084,50 ,  19134,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  17353,23 ,      13,5 ,       4,0 ,    5537,5 ,    5542,7 ,     0,     0,     1,     6,     7 }, // Jola Fonyi/Latin/Senegal
    {    242,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  19148,30 ,  19178,85 ,  19263,14 ,  19148,30 ,  19178,85 ,  19263,14 ,     702,7 ,     698,9 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  17376,23 ,      13,5 ,       4,0 ,    5549,6 ,    5555,7 ,     0,     0,     1,     6,     7 }, // Ewondo/Latin/Cameroon
    {    243,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  19277,29 ,  19306,45 ,  19351,14 ,  19277,29 ,  19306,45 ,  19351,14 ,     709,6 ,     707,7 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  17399,11 ,      13,5 ,       4,0 ,    5562,5 ,    5567,7 ,     0,     0,     1,     6,     7 }, // Bafia/Latin/Cameroon
    {    244,     7,   146,    44,    46,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  19365,28 ,  19393,59 ,  19452,14 ,  19365,28 ,  19393,59 ,  19452,14 ,     715,8 ,    714,10 ,   45,4 ,   5,17 ,  22,23 , {77,90,78},      278,3 ,       0,7 ,      41,6 ,       4,0 ,    5574,5 ,   5579,10 ,     2,     1,     7,     6,     7 }, // Makhuwa Meetto/Latin/Mozambique
    {    245,     7,    37,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  19466,28 ,  19494,74 ,  19568,14 ,  19466,28 ,  19494,74 ,  19568,14 ,     723,5 ,     724,5 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  17410,17 ,       4,4 ,       4,0 ,    5589,6 ,    5595,7 ,     0,     0,     1,     6,     7 }, // Mundang/Latin/Cameroon
    {    246,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8221,     171,     187,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  19582,30 ,  19612,89 ,  19701,14 ,  19582,30 ,  19612,89 ,  19701,14 ,     728,4 ,     729,4 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  17427,20 ,      13,5 ,       4,0 ,    5602,6 ,    5608,7 ,     0,     0,     1,     6,     7 }, // Kwasio/Latin/Cameroon
    {    247,     7,   254,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     538,9 ,     97,16 ,      18,7 ,    531,12 ,  19715,38 ,  19753,79 ,  19832,14 ,  19715,38 ,  19753,79 ,  19832,14 ,     732,2 ,     733,2 ,   45,4 ,   5,17 ,  22,23 , {83,83,80},      119,1 ,       0,7 ,       4,4 ,       4,0 ,    5615,9 ,       0,0 ,     2,     1,     1,     6,     7 }, // Nuer/Latin/South Sudan
    {    248,     2,   178,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8220,       0,6 ,       0,6 ,    994,11 ,    994,11 ,     227,6 ,   1736,30 ,      37,5 ,      8,10 ,  19846,21 ,  19867,71 ,  19938,14 ,  19846,21 ,  19867,71 ,  19938,14 ,     734,2 ,     735,2 , 1231,5 , 1236,17 ,  22,23 , {82,85,66},      123,1 ,  17447,47 ,      13,5 ,       4,0 ,    5624,9 ,    5633,9 ,     2,     1,     1,     6,     7 }, // Sakha/Cyrillic/Russia
    {    249,     7,   210,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      37,5 ,      8,10 ,  19952,28 ,  19980,60 ,  20040,14 ,  19952,28 ,  19980,60 ,  20040,14 ,     736,9 ,     737,9 ,   45,4 ,   5,17 ,  22,23 , {84,90,83},      192,3 ,  17494,25 ,       0,4 ,       4,0 ,    5642,9 ,    5651,9 ,     2,     0,     1,     6,     7 }, // Sangu/Latin/Tanzania
    {    251,     7,   156,    46,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  17971,28 ,  17999,54 ,  17756,14 ,  17971,28 ,  17999,54 ,  17756,14 ,     689,8 ,    682,10 ,   45,4 ,   5,17 ,  22,23 , {88,79,70},      207,3 ,  17094,23 ,       0,4 ,       4,0 ,   5660,13 ,    5527,5 ,     0,     0,     1,     6,     7 }, // Tasawaq/Latin/Niger
    {    252,    35,   121,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,  20054,30 ,  20054,30 ,     85,14 ,  20054,30 ,  20054,30 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {76,82,68},        6,1 ,  17519,15 ,       4,4 ,       4,0 ,    5673,2 ,    5675,4 ,     2,     1,     1,     6,     7 }, // Vai/Vai/Liberia
    {    252,     7,   121,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,    119,10 ,     10,17 ,      18,7 ,     25,12 ,  20084,48 ,  20084,48 ,     85,14 ,  20084,48 ,  20084,48 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {76,82,68},        6,1 ,  17534,20 ,       4,4 ,       4,0 ,    5679,3 ,    5682,8 ,     2,     1,     1,     6,     7 }, // Vai/Latin/Liberia
    {    253,     7,   206,    44,  8217,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,     264,9 ,     264,9 ,     53,10 ,    622,18 ,      37,5 ,      8,10 ,  20132,28 ,  20160,53 ,  20213,14 ,  20132,28 ,  20160,53 ,  20213,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,72,70},        0,0 ,       0,7 ,      41,6 ,       4,0 ,    5690,6 ,    5696,6 ,     2,     0,     1,     6,     7 }, // Walser/Latin/Switzerland
    {    254,     7,    37,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,     171,     187,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  20227,21 ,  20248,71 ,  20319,14 ,  20227,21 ,  20248,71 ,  20319,14 ,     745,8 ,     746,8 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,       0,7 ,      13,5 ,       4,0 ,    5702,6 ,    5708,7 ,     0,     0,     1,     6,     7 }, // Yangben/Latin/Cameroon
    {    256,     7,   197,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,     705,7 ,     705,7 ,     269,6 ,    372,22 ,      37,5 ,      8,10 ,  20333,28 ,  20361,54 ,   3391,14 ,  20333,28 ,  20361,54 ,   3391,14 ,    753,12 ,    754,11 ,    0,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,   3102,20 ,      13,5 ,       4,0 ,    5715,9 ,    2427,6 ,     2,     1,     1,     6,     7 }, // Asturian/Latin/Spain
    {    257,     7,    37,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,   1005,11 ,   1005,11 ,   1016,16 ,    1032,9 ,     53,10 ,   1566,18 ,      37,5 ,      8,10 ,  20415,60 ,  20415,60 ,  20475,25 ,  20415,60 ,  20415,60 ,  20475,25 ,     765,8 ,    765,13 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  17554,12 ,       8,5 ,       4,0 ,    5724,5 ,    5729,7 ,     0,     0,     1,     6,     7 }, // Ngomba/Latin/Cameroon
    {    258,     7,    37,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,       0,6 ,       0,6 ,   1766,10 ,     80,17 ,      37,5 ,      8,10 ,  20500,54 ,  20500,54 ,  20554,21 ,  20500,54 ,  20500,54 ,  20554,21 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  17566,16 ,      41,6 ,       4,0 ,    5736,4 ,    5740,7 ,     0,     0,     1,     6,     7 }, // Kako/Latin/Cameroon
    {    259,     7,    37,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,   1566,18 ,      37,5 ,      8,10 ,  20575,49 ,  20575,49 ,  20624,21 ,  20575,49 ,  20575,49 ,  20624,21 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  17582,12 ,       8,5 ,       4,0 ,    5747,5 ,    5752,7 ,     0,     0,     1,     6,     7 }, // Meta/Latin/Cameroon
    {    260,     7,    37,    44,    46,    59,    37,    48,    45,    43,   101,     171,     187,    8220,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,      27,8 ,   1776,32 ,      37,5 ,      8,10 , 20645,111 , 20645,111 ,     85,14 , 20645,111 , 20645,111 ,     85,14 ,     773,9 ,     778,8 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,  17594,16 ,       8,5 ,       4,0 ,   5759,16 ,    5775,7 ,     0,     0,     1,     6,     7 }, // Ngiemboon/Latin/Cameroon
    {    261,     7,   197,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Aragonese/Latin/Spain
    {    290,    11,   100,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,78,82},      121,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     7,     7 }, // Manipuri/Bengali/India
    {    309,   100,   232,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {86,78,68},      336,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Tai Dam/Tai Viet/Vietnam
    {    312,     7,    37,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Akoose/Latin/Cameroon
    {    313,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,  20756,87 ,  20756,87 ,     85,14 ,  20756,87 ,  20756,87 ,  20843,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},        6,1 ,       0,7 ,      41,6 ,       4,0 ,   5782,12 ,   5794,22 ,     2,     1,     7,     6,     7 }, // Lakota/Latin/United States
    {    314,     9,   145,    44,   160,    59,    37,    48,    45,    43,   101,     171,     187,    8222,    8221,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     415,8 ,     97,16 ,      37,5 ,      8,10 ,  15159,30 ,  20857,48 ,     85,14 ,  15159,30 ,  20857,48 ,     85,14 ,     526,6 ,     501,8 ,   45,4 ,   5,17 ,  22,23 , {77,65,68},        0,0 ,  16531,21 ,       0,4 ,       4,0 ,    5816,8 ,    5001,6 ,     2,     1,     1,     6,     7 }, // Standard Moroccan Tamazight/Tifinagh/Morocco
    {    315,     7,    43,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,76,80},        6,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Mapuche/Latin/Chile
    {    316,     1,   103,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      18,7 ,     25,12 ,  20905,58 ,  20905,58 ,  20963,14 ,  20905,58 ,  20905,58 ,  20963,14 ,     782,3 ,     786,3 ,   45,4 ,   5,17 ,  22,23 , {73,81,68},       44,5 ,  17610,20 ,      13,5 ,       4,0 ,   5824,14 ,    5838,5 ,     0,     0,     6,     5,     6 }, // Central Kurdish/Arabic/Iraq
    {    316,     1,   102,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,  20905,58 ,  20905,58 ,  20963,14 ,  20905,58 ,  20905,58 ,  20963,14 ,     782,3 ,     786,3 ,   45,4 ,   5,17 ,  22,23 , {73,82,82},        0,0 ,  17630,19 ,      13,5 ,       4,0 ,   5824,14 ,    5843,5 ,     0,     0,     6,     5,     5 }, // Central Kurdish/Arabic/Iran
    {    317,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     180,7 ,     180,7 ,     113,6 ,    622,18 ,      55,4 ,      59,9 ,  20977,28 ,  21005,53 ,  21058,14 ,  20977,28 ,  21005,53 ,  21058,14 ,     785,9 ,    789,10 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  17649,27 ,      13,5 ,       4,0 ,   5848,14 ,    5862,6 ,     2,     1,     1,     6,     7 }, // Lower Sorbian/Latin/Germany
    {    318,     7,    82,    44,    46,    59,    37,    48,    45,    43,   101,    8222,    8220,    8218,    8216,       0,6 ,       0,6 ,     180,7 ,     180,7 ,     113,6 ,    622,18 ,    543,12 ,      59,9 ,  21072,28 ,  21100,53 ,  21153,14 ,  21072,28 ,  21100,53 ,  21153,14 ,     785,9 ,     799,9 , 1253,5 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  17676,29 ,      13,5 ,       4,0 ,   5868,15 ,    5883,6 ,     2,     1,     1,     6,     7 }, // Upper Sorbian/Latin/Germany
    {    319,     7,    37,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {88,65,70},       32,4 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Kenyang/Latin/Cameroon
    {    320,     7,    38,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {67,65,68},      240,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     7,     6,     7 }, // Mohawk/Latin/Canada
    {    321,    75,    91,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {71,78,70},      216,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     1,     6,     7 }, // Nko/Nko/Guinea
    {    322,     7,   260,    44,   160,    59,    37,    48,    45,    43,   101,    8222,    8220,    8222,    8220,       0,6 ,       0,6 ,    1041,8 ,    1041,8 ,     156,8 ,   1808,27 ,      37,5 ,      8,10 ,  21167,28 ,  21195,69 ,  21264,14 ,  21167,28 ,  21195,69 ,  21264,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,      13,5 ,       4,0 ,    5889,9 ,    5898,6 ,     2,     1,     1,     6,     7 }, // Prussian/Latin/World
    {    323,     7,    90,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {71,84,81},      305,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Kiche/Latin/Guatemala
    {    324,     7,   205,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {83,69,75},      190,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     1,     6,     7 }, // Southern Sami/Latin/Sweden
    {    325,     7,   205,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {83,69,75},      190,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     1,     6,     7 }, // Lule Sami/Latin/Sweden
    {    326,     7,    73,    44,   160,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     640,8 ,   1835,18 ,     220,4 ,     224,9 ,  21278,28 ,  21306,70 ,     85,14 ,  21278,28 ,  21376,73 ,  21449,14 ,     794,3 ,     808,3 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,  17705,11 ,      13,5 ,       4,0 ,   5904,11 ,    5915,5 ,     2,     1,     1,     6,     7 }, // Inari Sami/Latin/Finland
    {    327,     7,    73,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Skolt Sami/Latin/Finland
    {    328,     7,    13,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {65,85,68},      340,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Warlpiri/Latin/Australia
    {    346,     1,   102,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,     171,     187,    8249,    8250,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,  726,4 , 1258,39 ,  22,23 , {73,82,82},      342,3 ,  17716,27 ,       8,5 ,       4,0 ,    5920,7 ,    3252,5 ,     0,     0,     6,     5,     5 }, // Mazanderani/Arabic/Iran
    {    349,     1,   102,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,82,82},        0,0 ,       0,7 ,       8,5 ,       4,0 ,   5927,11 ,       0,0 ,     0,     0,     6,     5,     5 }, // Northern Luri/Arabic/Iran
    {    349,     1,   103,  1643,  1644,  1563,  1642,  1776,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      18,7 ,     25,12 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,81,68},       44,5 ,       0,7 ,       8,5 ,       4,0 ,   5927,11 ,       0,0 ,     0,     0,     6,     5,     6 }, // Northern Luri/Arabic/Iraq
    {    357,     6,    97,    46,    44,    59,    37,    48,    45,    43,   101,   12300,   12301,   12302,   12303,     165,5 ,     165,5 ,    1049,5 ,    1049,5 ,     394,8 ,    423,14 ,     175,6 ,    192,13 ,   1980,28 ,   1980,28 ,   2008,14 ,   1980,28 ,   1980,28 ,   2008,14 ,      58,2 ,      55,2 ,   45,4 ,   5,17 ,  22,23 , {72,75,68},      134,3 ,  17743,11 ,       4,4 ,       4,0 ,    5938,2 ,   5940,14 ,     2,     1,     7,     6,     7 }, // Cantonese/Traditional Han/Hong Kong
    {    357,     5,    44,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,     165,5 ,     165,5 ,    1049,5 ,    1049,5 ,     394,8 ,    402,13 ,     175,6 ,    181,11 ,   1959,21 ,   1980,28 ,   2008,14 ,   1959,21 ,   1980,28 ,   2008,14 ,      58,2 ,      55,2 ,   45,4 ,   5,17 ,  22,23 , {67,78,89},      243,1 ,   3122,13 ,       4,4 ,       4,0 ,    5954,2 ,    5956,7 ,     2,     1,     7,     6,     7 }, // Cantonese/Simplified Han/China
    {    358,   138,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Osage/Osage/United States
    {    360,     7,   260,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Ido/Latin/World
    {    361,     7,   260,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 ,    {0,0,0},        0,0 ,    2586,0 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Lojban/Latin/World
    {    362,     7,   106,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {69,85,82},       14,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Sicilian/Latin/Italy
    {    363,     1,   102,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {73,82,82},        0,0 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     0,     0,     6,     5,     5 }, // Southern Kurdish/Arabic/Iran
    {    364,     1,   163,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {80,75,82},      176,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     0,     7,     6,     7 }, // Western Balochi/Arabic/Pakistan
    {    365,     7,   170,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,     919,9 ,     928,8 ,     547,6 ,     35,18 ,      18,7 ,     25,12 ,  21463,25 ,  21488,56 ,  21544,14 ,  21463,25 ,  21488,56 ,  21544,14 ,       0,2 ,       0,2 , 1297,8 ,   5,17 ,  22,23 , {80,72,80},      179,1 ,  17754,56 ,       4,4 ,       4,0 ,    5963,8 ,    4715,9 ,     2,     1,     7,     6,     7 }, // Cebuano/Latin/Philippines
    {    366,     2,   178,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {82,85,66},      123,1 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Erzya/Cyrillic/Russia
    {    367,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Chickasaw/Latin/United States
    {    368,     7,   225,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {85,83,68},      159,3 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     7,     6,     7 }, // Muscogee/Latin/United States
    {    369,     7,   172,    46,    44,    59,    37,    48,    45,    43,   101,    8220,    8221,    8216,    8217,       0,6 ,       0,6 ,       0,6 ,       0,6 ,     53,10 ,     63,17 ,      37,5 ,      8,10 ,      0,28 ,      0,28 ,     85,14 ,      0,28 ,      0,28 ,     85,14 ,       0,2 ,       0,2 ,   45,4 ,   5,17 ,  22,23 , {80,76,78},      273,2 ,       0,7 ,       8,5 ,       4,0 ,       0,0 ,       0,0 ,     2,     1,     1,     6,     7 }, // Silesian/Latin/Poland
    {      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,       0,       0,       0,       0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,        0,0,     0,0,     0,0,     0,0,    {0,0,0},         0,0,        0,0,        0,0,        0,0,        0,0,        0,0,     0,     0,     0,     0,     0 } // trailing 0s
};

static const ushort list_pattern_part_data[] = {
0x25, 0x31, 0x2c, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x68, 0x65,
0x20, 0x25, 0x32, 0x25, 0x31, 0x1363, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x12a5, 0x1293, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x12a5, 0x1293, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x648, 0x25, 0x32, 0x25, 0x31, 0x20, 0x587, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x986, 0x9f0, 0x9c1, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x76, 0x259, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65,
0x74, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x98f, 0x9ac, 0x982, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xf51, 0xf44, 0xf0b,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x68, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x438, 0x20, 0x25, 0x32, 0x25, 0x31,
0x20, 0x25, 0x32, 0x25, 0x31, 0x1014, 0x103e, 0x1004, 0x1037, 0x103a, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x456, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x1793, 0x17b7, 0x1784, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x1793, 0x17b7, 0x1784, 0x200b, 0x25, 0x32, 0x25, 0x31,
0x20, 0x69, 0x20, 0x25, 0x32, 0x25, 0x31, 0x3001, 0x25, 0x32, 0x25, 0x31, 0x548c, 0x25, 0x32, 0x25, 0x31, 0x53ca, 0x25, 0x32,
0x25, 0x31, 0x20, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6f, 0x67, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x61,
0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6b, 0x61, 0x6a,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6a, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x74, 0x20, 0x25, 0x32, 0x25,
0x31, 0x20, 0x61, 0x67, 0x75, 0x73, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x10d3,
0x10d0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x6e, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x3ba, 0x3b1, 0x3b9, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x61, 0x6d, 0x6d, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xa85, 0xaa8, 0xac7, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x5d5, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20,
0x914, 0x930, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x914, 0x930, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xe9, 0x73, 0x20, 0x25,
0x32, 0x25, 0x31, 0x2c, 0x20, 0x64, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x64, 0x61, 0x6e, 0x20, 0x25, 0x32,
0x25, 0x31, 0x2c, 0x20, 0x61, 0x67, 0x75, 0x73, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6c, 0x61, 0x6e, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x6c, 0x61, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0xcae, 0xca4, 0xccd, 0xca4, 0xcc1, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0xcae, 0xca4, 0xccd, 0xca4, 0xcc1, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x436, 0x4d9, 0x43d, 0x435,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x436, 0x430, 0x43d, 0x430, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xbc0f, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0xfb, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xec1, 0xea5, 0xeb0, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75,
0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6d, 0x70, 0xe9, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x72, 0x20, 0x25,
0x32, 0x25, 0x31, 0x2c, 0x20, 0x25, 0x32, 0x20, 0xd0e, 0xd28, 0xd4d, 0xd28, 0xd3f, 0xd35, 0x25, 0x31, 0x20, 0xd15, 0xd42, 0xd1f,
0xd3e, 0xd24, 0xd46, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x75, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x906, 0x923, 0x93f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x25, 0x32, 0x25, 0x31, 0x20, 0x930, 0x20,
0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0xb13, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xb13, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c,
0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x627, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x627, 0x648, 0x20, 0x25, 0x32,
0x25, 0x31, 0x60c, 0x200f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x648, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x648, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0xa05, 0xa24, 0xa47, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x75, 0x74, 0x61, 0x71, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x75, 0x74, 0x61, 0x71, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x219, 0x69, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x4d5, 0x43c, 0x4d5, 0x20, 0x25, 0x32, 0x25, 0x31, 0x60c, 0x20, 0x6fd, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20,
0x6fd, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0xdc3, 0xdc4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xdc3, 0xdc4, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x61, 0xa0, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69, 0x6e, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x69,
0x79, 0x6f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x79, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6e, 0x61, 0x20, 0x25, 0x32,
0x25, 0x31, 0x20, 0x6f, 0x63, 0x68, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xbae, 0xbb1, 0xbcd, 0xbb1, 0xbc1, 0xbae, 0xbcd, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0x4bb, 0x4d9, 0x43c, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0xc2e, 0xc30, 0xc3f, 0xc2f, 0xc41, 0x20,
0x25, 0x32, 0x25, 0x31, 0x20, 0xe41, 0xe25, 0xe30, 0x25, 0x32, 0x25, 0x31, 0xe41, 0xe25, 0xe30, 0x25, 0x32, 0x25, 0x31, 0x20,
0x6d, 0x6f, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x76, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x77, 0x65, 0x20, 0x25,
0x32, 0x25, 0x31, 0x60c, 0x20, 0x627, 0x648, 0x631, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x627, 0x648, 0x631, 0x20, 0x25, 0x32,
0x25, 0x32, 0x60c, 0x20, 0x25, 0x31, 0x25, 0x31, 0x20, 0x76, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x76, 0xe0, 0x20,
0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x61, 0x28, 0x63, 0x29, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x28, 0x63, 0x29,
0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x5d0, 0x5d5, 0x5df, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6e, 0x65, 0x2d, 0x25,
0x32, 0x25, 0x31, 0x20, 0x6e, 0x65, 0x2d, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x6e, 0x61, 0x20, 0x25, 0x32, 0x25, 0x31,
0x2c, 0x20, 0x6b, 0x70, 0x6c, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x6b, 0x70, 0x6c, 0x65, 0x20, 0x25, 0x32, 0x25,
0x31, 0x2c, 0x20, 0x61, 0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x74, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20,
0x61, 0x6b, 0x6b, 0x65, 0x64, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x6b, 0x6b, 0x65, 0x64, 0x20, 0x25, 0x32, 0x25,
0x31, 0x2c, 0x20, 0x13a0, 0x13b4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x13a0, 0x13b4, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x438,
0x486, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x61, 0x28, 0x6e, 0x29, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x443, 0x43e, 0x43d,
0x43d, 0x430, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20, 0x14b, 0x301, 0x67, 0x25b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x2c, 0x20,
0x1e3f, 0x62, 0x25b, 0x6e, 0x20, 0x14b, 0x301, 0x67, 0x25b, 0x20, 0x25, 0x32, 0x25, 0x31, 0x20, 0x70, 0x254, 0x70, 0x20, 0x25,
0x32, 0x25, 0x31, 0x20, 0x62, 0x65, 0x20, 0x25, 0x32, 0x25, 0x31, 0x540c, 0x25, 0x32
};

static const ushort date_format_data[] = {
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x4d, 0x4d,
0x2d, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64,
0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64,
0x64, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x64,
0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64, 0x200f, 0x2f, 0x4d, 0x200f, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x64, 0x64, 0x60c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2e, 0x4d,
0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x569, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20,
0x64, 0x64, 0x64, 0x64, 0x64, 0x2d, 0x4d, 0x2d, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79,
0x79, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x2f, 0x4d, 0x2f, 0x64, 0x79, 0x79, 0x79, 0x79, 0x28, 0x27, 0x65,
0x27, 0x29, 0x27, 0x6b, 0x6f, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x27, 0x72, 0x65, 0x6e, 0x27, 0x20, 0x64, 0x28, 0x27,
0x61, 0x27, 0x29, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2f, 0x4d, 0x2f, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0xf66, 0xfa4, 0xfb1, 0xf72, 0xf0b, 0xf63, 0xf7c, 0xf0b, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0xf5a,
0xf7a, 0xf66, 0xf0b, 0x64, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x20, 0x27, 0x433, 0x27, 0x2e, 0x64, 0x64, 0x64,
0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x433, 0x27, 0x2e, 0x64,
0x64, 0x2d, 0x4d, 0x4d, 0x2d, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x104a, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x104a,
0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2f, 0x4d,
0x2f, 0x64, 0x79, 0x79, 0x79, 0x79, 0x5e74, 0x4d, 0x6708, 0x64, 0x65e5, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2f, 0x4d, 0x2f, 0x79,
0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x5e74, 0x4d, 0x6708, 0x64, 0x65e5, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2e,
0x20, 0x4d, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2e, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x2e, 0x64, 0x64,
0x64, 0x64, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2e, 0x4d, 0x4d,
0x2e, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x27, 0x64, 0x65, 0x6e, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x2d, 0x4d, 0x4d, 0x2d, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2f,
0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79, 0x4d, 0x2f, 0x64, 0x2f, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64,
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2f, 0x4d, 0x4d, 0x2f, 0x79, 0x79, 0x79, 0x79,
0x79, 0x79, 0x2f, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x79, 0x79, 0x2d, 0x4d, 0x4d, 0x2d, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
0x2c, 0x20, 0x64, 0x2d, 0x27, 0x61, 0x27, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79,
0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79,
0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x27, 0x6d, 0x68, 0x27, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27, 0x64, 0x65,
0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64,
0x2c, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20,
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20,
0x5d1, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x4d, 0x2e, 0x20,
0x64, 0x64, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2e, 0x2c, 0x20, 0x64, 0x64,
0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x20, 0x27, 0x6c, 0x65, 0x27, 0x20, 0x64, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x436, 0x27, 0x2e, 0x20, 0x64, 0x20,
0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x2d, 0x27, 0x436, 0x27, 0x2e, 0x2c,
0x20, 0x64, 0x2d, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x2e, 0x20, 0x4d, 0x2e, 0x20,
0x64, 0x2e, 0x79, 0x79, 0x79, 0x79, 0xb144, 0x20, 0x4d, 0xc6d4, 0x20, 0x64, 0xc77c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
0x64, 0x64, 0x20, 0xe97, 0xeb5, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64,
0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x20, 0x27, 0x67, 0x61, 0x64, 0x61, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x6d, 0x27, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x20,
0x27, 0x64, 0x27, 0x2e, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79,
0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64,
0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27, 0x74, 0x61, 0x27, 0x2019, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79,
0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x4d, 0x4d, 0x2e, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x43e,
0x43d, 0x44b, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x27, 0x44b, 0x43d, 0x27, 0x20, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64,
0x20, 0x27, 0x433, 0x430, 0x440, 0x430, 0x433, 0x27, 0x64, 0x64, 0x64, 0x64, 0x20, 0x62f, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20,
0x62f, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x69, 0x6c, 0x73, 0x27, 0x20,
0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x4d, 0x2e, 0x79, 0x79, 0x2e, 0x64, 0x64,
0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x64, 0x64,
0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x430, 0x437,
0x27, 0x64, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x2e, 0x20, 0x79, 0x79,
0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64,
0x64, 0x64, 0x20, 0x64, 0x64, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x65, 0x27,
0x20, 0x79, 0x79, 0x79, 0x79, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x2f, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c,
0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27, 0x435, 0x43b, 0x27, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x4d,
0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0xe17, 0xe35,
0xe48, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0xf60, 0xf72, 0xf0b, 0xf5a, 0xf7a, 0xf66, 0xf0b, 0x64, 0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
0x1363, 0x20, 0x64, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x1218, 0x12d3, 0x120d, 0x1272, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64,
0x2e, 0x4d, 0x4d, 0x2e, 0x79, 0x79, 0x79, 0x79, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20,
0x64, 0x64, 0x64, 0x64, 0x79, 0x79, 0x79, 0x79, 0x20, 0x64, 0x2d, 0x4d, 0x4d, 0x4d, 0x4d, 0x60c, 0x20, 0x64, 0x64, 0x64,
0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27,
0x440, 0x27, 0x2e, 0x64, 0x64, 0x64, 0x64, 0x60c, 0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x60c, 0x20, 0x79, 0x79, 0x79,
0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x2d, 0x4d, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x79,
0x79, 0x79, 0x79, 0x20, 0x646, 0x686, 0x6cc, 0x20, 0x6cc, 0x6cc, 0x644, 0x20, 0x64, 0x20, 0x646, 0x686, 0x6cc, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x20, 0x64, 0x64, 0x64, 0x64, 0x20, 0x6a9, 0x648, 0x646, 0x6cc, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x27, 0x61, 0x27, 0x20, 0x27, 0x64, 0x27, 0x2e, 0x20, 0x64, 0x27, 0x69, 0x64, 0x27, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x64, 0x20, 0x4d, 0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x5d8,
0x5df, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x4d,
0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x2e, 0x20, 0x4d, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x79, 0x79,
0x2f, 0x4d, 0x4d, 0x2f, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x4d, 0x4d, 0x4d,
0x4d, 0x20, 0x64, 0x64, 0x64, 0x2d, 0x4d, 0x2d, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x20, 0x64, 0x20, 0x27, 0x64, 0x69,
0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x64, 0x61, 0x6c, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64,
0x64, 0x2c, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27, 0x6c, 0x69, 0x61, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79,
0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x64, 0x65, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79,
0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64, 0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d,
0x20, 0x27, 0x64, 0x69, 0x27, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x27, 0x64, 0xe4, 0x27,
0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x64,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x27, 0x43b, 0x27, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79, 0x2e, 0x79, 0x79, 0x79, 0x79,
0x20, 0x27, 0x441, 0x44b, 0x43b, 0x27, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x20, 0x27, 0x43a, 0x4af, 0x43d, 0x44d, 0x27,
0x2c, 0x20, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x2f, 0x4d, 0x4d, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64,
0x20, 0x2c, 0x20, 0x27, 0x6c, 0x79, 0x25b, 0x27, 0x30c, 0x2bc, 0x20, 0x64, 0x20, 0x27, 0x6e, 0x61, 0x27, 0x20, 0x4d, 0x4d,
0x4d, 0x4d, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x64, 0x64, 0x64, 0x64, 0x2c, 0x20, 0x79, 0x79, 0x79, 0x79, 0x20, 0x27,
0x6d, 0x65, 0x74, 0x74, 0x61, 0x73, 0x27, 0x20, 0x64, 0x2e, 0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x64, 0x64, 0x64, 0x64, 0x2c,
0x20, 0x4d, 0x4d, 0x4d, 0x4d, 0x20, 0x64, 0x2e, 0x20, 0x79, 0x79, 0x79, 0x79
};

static const ushort time_format_data[] = {
0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x68, 0x3a,
0x6d, 0x6d, 0x20, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x48, 0x3a,
0x6d, 0x6d, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x2c, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x48,
0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0x2e, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x68, 0x2e,
0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x28, 0x74, 0x29, 0xf46,
0xf74, 0xf0b, 0xf5a, 0xf7c, 0xf51, 0xf0b, 0x20, 0x68, 0x20, 0xf66, 0xf90, 0xf62, 0xf0b, 0xf58, 0xf0b, 0x20, 0x6d, 0x6d, 0x20, 0x41,
0x50, 0xf46, 0xf74, 0xf0b, 0xf5a, 0xf7c, 0xf51, 0xf0b, 0x20, 0x68, 0x20, 0xf66, 0xf90, 0xf62, 0xf0b, 0xf58, 0xf0b, 0x20, 0x6d, 0x6d,
0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x42, 0x20, 0x48, 0x3a, 0x6d, 0x6d, 0x74, 0x20, 0x48, 0x48, 0x3a, 0x6d,
0x6d, 0x3a, 0x73, 0x73, 0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x2c, 0x20, 0x74, 0x41, 0x50, 0x68, 0x3a, 0x6d,
0x6d, 0x74, 0x20, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x41, 0x50, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73,
0x73, 0x20, 0x5b, 0x74, 0x5d, 0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74,
0x48, 0x2e, 0x6d, 0x6d, 0x48, 0x2e, 0x6d, 0x6d, 0x2e, 0x73, 0x73, 0x20, 0x74, 0x48, 0x2d, 0x27, 0x61, 0x27, 0x20, 0x27,
0x68, 0x6f, 0x72, 0x6f, 0x27, 0x20, 0x27, 0x6b, 0x61, 0x6a, 0x27, 0x20, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x48, 0x20,
0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d, 0x20, 0x27, 0x6d, 0x69, 0x6e, 0x27, 0x20, 0x73, 0x73, 0x20, 0x27, 0x73, 0x27, 0x20,
0x74, 0x48, 0x48, 0x20, 0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d, 0x48, 0x48, 0x20, 0x27, 0x68, 0x27, 0x20, 0x6d, 0x6d, 0x20,
0x27, 0x6d, 0x69, 0x6e, 0x27, 0x20, 0x73, 0x73, 0x20, 0x27, 0x73, 0x27, 0x20, 0x74, 0x48, 0x48, 0x2e, 0x6d, 0x6d, 0x3a,
0x73, 0x73, 0x20, 0x27, 0x68, 0x27, 0x20, 0x74, 0x68, 0x68, 0x3a, 0x6d, 0x6d, 0x20, 0x41, 0x50, 0x68, 0x68, 0x3a, 0x6d,
0x6d, 0x3a, 0x73, 0x73, 0x20, 0x41, 0x50, 0x20, 0x74, 0x48, 0x6642, 0x6d, 0x6d, 0x5206, 0x73, 0x73, 0x79d2, 0x20, 0x74, 0x41,
0x50, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x68, 0xc2dc, 0x20, 0x6d, 0xbd84, 0x20, 0x73, 0xcd08, 0x20, 0x74, 0x48,
0x20, 0xec2, 0xea1, 0xe87, 0x20, 0x6d, 0x20, 0xe99, 0xeb2, 0xe97, 0xeb5, 0x20, 0x73, 0x73, 0x20, 0xea7, 0xeb4, 0xe99, 0xeb2, 0xe97,
0xeb5, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x28, 0x74, 0x29, 0x27, 0x6b, 0x6c, 0x27, 0x2e, 0x20,
0x48, 0x48, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x74, 0x41, 0x50, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73,
0x20, 0x74, 0x48, 0x20, 0xe19, 0xe32, 0xe2c, 0xe34, 0xe01, 0xe32, 0x20, 0x6d, 0x6d, 0x20, 0xe19, 0xe32, 0xe17, 0xe35, 0x20, 0x73,
0x73, 0x20, 0xe27, 0xe34, 0xe19, 0xe32, 0xe17, 0xe35, 0x20, 0x74, 0x48, 0x3a, 0x6d, 0x41, 0x50, 0x20, 0x27, 0x67, 0x61, 0x27,
0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x41, 0x50, 0x20, 0x27, 0x67, 0x61, 0x27, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73,
0x20, 0x74, 0x27, 0x4b, 0x6c, 0x27, 0x2e, 0x20, 0x48, 0x2e, 0x6d, 0x6d, 0x27, 0x4b, 0x6c, 0x6f, 0x63, 0x6b, 0x27, 0x20,
0x48, 0x2e, 0x6d, 0x6d, 0x3a, 0x73, 0x73, 0x20, 0x28, 0x74, 0x29, 0x74, 0x20, 0x68, 0x3a, 0x6d, 0x6d, 0x3a, 0x73, 0x73,
0x20, 0x41, 0x50, 0x48, 0x3a, 0x6d, 0x6d, 0x20, 0x27, 0x68, 0x6f, 0x64, 0x17a, 0x27, 0x2e
};

static const ushort days_data[] = {
0x53, 0x75, 0x6e, 0x3b, 0x4d, 0x6f, 0x6e, 0x3b, 0x54, 0x75, 0x65, 0x3b, 0x57, 0x65, 0x64, 0x3b, 0x54, 0x68, 0x75, 0x3b,
0x46, 0x72, 0x69, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x53, 0x75, 0x6e, 0x64, 0x61, 0x79, 0x3b, 0x4d, 0x6f, 0x6e, 0x64, 0x61,
0x79, 0x3b, 0x54, 0x75, 0x65, 0x73, 0x64, 0x61, 0x79, 0x3b, 0x57, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x64, 0x61, 0x79, 0x3b,
0x54, 0x68, 0x75, 0x72, 0x73, 0x64, 0x61, 0x79, 0x3b, 0x46, 0x72, 0x69, 0x64, 0x61, 0x79, 0x3b, 0x53, 0x61, 0x74, 0x75,
0x72, 0x64, 0x61, 0x79, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x57, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x37,
0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x44, 0x69, 0x6c, 0x3b, 0x57, 0x69, 0x78,
0x3b, 0x51, 0x69, 0x62, 0x3b, 0x52, 0x6f, 0x62, 0x3b, 0x4b, 0x61, 0x6d, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x53, 0x61, 0x6e,
0x3b, 0x44, 0x69, 0x6c, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x57, 0x69, 0x69, 0x78, 0x61, 0x74, 0x61, 0x3b, 0x51, 0x69, 0x62,
0x78, 0x61, 0x74, 0x61, 0x3b, 0x52, 0x6f, 0x6f, 0x62, 0x69, 0x69, 0x3b, 0x4b, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b,
0x4a, 0x69, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x3b, 0x53, 0x61, 0x6e, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x44, 0x3b, 0x57, 0x3b,
0x51, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x53, 0x6f, 0x2e, 0x3b, 0x4d, 0x61, 0x2e, 0x3b, 0x44, 0x69,
0x2e, 0x3b, 0x57, 0x6f, 0x2e, 0x3b, 0x44, 0x6f, 0x2e, 0x3b, 0x56, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0x6f,
0x6e, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0x61, 0x61, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x69, 0x6e, 0x73, 0x64, 0x61, 0x67,
0x3b, 0x57, 0x6f, 0x65, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x44, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b,
0x56, 0x72, 0x79, 0x64, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x74, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b,
0x44, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x64, 0x69, 0x65, 0x3b, 0x68, 0xeb, 0x6e, 0x3b, 0x6d, 0x61,
0x72, 0x3b, 0x6d, 0xeb, 0x72, 0x3b, 0x65, 0x6e, 0x6a, 0x3b, 0x70, 0x72, 0x65, 0x3b, 0x73, 0x68, 0x74, 0x3b, 0x65, 0x20,
0x64, 0x69, 0x65, 0x6c, 0x3b, 0x65, 0x20, 0x68, 0xeb, 0x6e, 0xeb, 0x3b, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x74, 0xeb, 0x3b,
0x65, 0x20, 0x6d, 0xeb, 0x72, 0x6b, 0x75, 0x72, 0xeb, 0x3b, 0x65, 0x20, 0x65, 0x6e, 0x6a, 0x74, 0x65, 0x3b, 0x65, 0x20,
0x70, 0x72, 0x65, 0x6d, 0x74, 0x65, 0x3b, 0x65, 0x20, 0x73, 0x68, 0x74, 0x75, 0x6e, 0xeb, 0x3b, 0x64, 0x3b, 0x68, 0x3b,
0x6d, 0x3b, 0x6d, 0x3b, 0x65, 0x3b, 0x70, 0x3b, 0x73, 0x68, 0x3b, 0x44, 0x69, 0x65, 0x3b, 0x48, 0xeb, 0x6e, 0x3b, 0x4d,
0x61, 0x72, 0x3b, 0x4d, 0xeb, 0x72, 0x3b, 0x45, 0x6e, 0x6a, 0x3b, 0x50, 0x72, 0x65, 0x3b, 0x53, 0x68, 0x74, 0x3b, 0x12a5,
0x1211, 0x12f5, 0x3b, 0x1230, 0x129e, 0x3b, 0x121b, 0x12ad, 0x1230, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1210, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d,
0x1265, 0x3b, 0x1245, 0x12f3, 0x121c, 0x3b, 0x12a5, 0x1211, 0x12f5, 0x3b, 0x1230, 0x129e, 0x3b, 0x121b, 0x12ad, 0x1230, 0x129e, 0x3b, 0x1228, 0x1261,
0x12d5, 0x3b, 0x1210, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d, 0x1265, 0x3b, 0x1245, 0x12f3, 0x121c, 0x3b, 0x12a5, 0x3b, 0x1230, 0x3b, 0x121b, 0x3b,
0x1228, 0x3b, 0x1210, 0x3b, 0x12d3, 0x3b, 0x1245, 0x3b, 0x627, 0x644, 0x623, 0x62d, 0x62f, 0x3b, 0x627, 0x644, 0x627, 0x62b, 0x646, 0x64a,
0x646, 0x3b, 0x627, 0x644, 0x62b, 0x644, 0x627, 0x62b, 0x627, 0x621, 0x3b, 0x627, 0x644, 0x623, 0x631, 0x628, 0x639, 0x627, 0x621, 0x3b,
0x627, 0x644, 0x62e, 0x645, 0x64a, 0x633, 0x3b, 0x627, 0x644, 0x62c, 0x645, 0x639, 0x629, 0x3b, 0x627, 0x644, 0x633, 0x628, 0x62a, 0x3b,
0x62d, 0x3b, 0x646, 0x3b, 0x62b, 0x3b, 0x631, 0x3b, 0x62e, 0x3b, 0x62c, 0x3b, 0x633, 0x3b, 0x56f, 0x56b, 0x580, 0x3b, 0x565, 0x580,
0x56f, 0x3b, 0x565, 0x580, 0x584, 0x3b, 0x579, 0x580, 0x584, 0x3b, 0x570, 0x576, 0x563, 0x3b, 0x578, 0x582, 0x580, 0x3b, 0x577, 0x562,
0x569, 0x3b, 0x56f, 0x56b, 0x580, 0x561, 0x56f, 0x56b, 0x3b, 0x565, 0x580, 0x56f, 0x578, 0x582, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b,
0x565, 0x580, 0x565, 0x584, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x579, 0x578, 0x580, 0x565, 0x584, 0x577, 0x561, 0x562, 0x569, 0x56b,
0x3b, 0x570, 0x56b, 0x576, 0x563, 0x577, 0x561, 0x562, 0x569, 0x56b, 0x3b, 0x578, 0x582, 0x580, 0x562, 0x561, 0x569, 0x3b, 0x577, 0x561,
0x562, 0x561, 0x569, 0x3b, 0x53f, 0x3b, 0x535, 0x3b, 0x535, 0x3b, 0x549, 0x3b, 0x540, 0x3b, 0x548, 0x3b, 0x547, 0x3b, 0x9a6, 0x9c7,
0x993, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x3b,
0x9b6, 0x9c1, 0x995, 0x9cd, 0x9f0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x3b, 0x9a6, 0x9c7, 0x993, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b8, 0x9cb, 0x9ae,
0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be, 0x9f0, 0x3b,
0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9f0, 0x9ac, 0x9be, 0x9f0,
0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be, 0x9f0, 0x3b, 0x9a6, 0x3b, 0x9b8, 0x3b, 0x9ae, 0x3b, 0x9ac, 0x3b, 0x9ac, 0x3b, 0x9b6, 0x3b,
0x9b6, 0x3b, 0x42, 0x2e, 0x3b, 0x42, 0x2e, 0x45, 0x2e, 0x3b, 0xc7, 0x2e, 0x41, 0x2e, 0x3b, 0xc7, 0x2e, 0x3b, 0x43, 0x2e,
0x41, 0x2e, 0x3b, 0x43, 0x2e, 0x3b, 0x15e, 0x2e, 0x3b, 0x62, 0x61, 0x7a, 0x61, 0x72, 0x3b, 0x62, 0x61, 0x7a, 0x61, 0x72,
0x20, 0x65, 0x72, 0x74, 0x259, 0x73, 0x69, 0x3b, 0xe7, 0x259, 0x72, 0x15f, 0x259, 0x6e, 0x62, 0x259, 0x20, 0x61, 0x78, 0x15f,
0x61, 0x6d, 0x131, 0x3b, 0xe7, 0x259, 0x72, 0x15f, 0x259, 0x6e, 0x62, 0x259, 0x3b, 0x63, 0xfc, 0x6d, 0x259, 0x20, 0x61, 0x78,
0x15f, 0x61, 0x6d, 0x131, 0x3b, 0x63, 0xfc, 0x6d, 0x259, 0x3b, 0x15f, 0x259, 0x6e, 0x62, 0x259, 0x3b, 0x42, 0x2e, 0x3b, 0x42,
0x2e, 0x65, 0x2e, 0x3b, 0xc7, 0x2e, 0x61, 0x2e, 0x3b, 0xc7, 0x2e, 0x3b, 0x43, 0x2e, 0x61, 0x2e, 0x3b, 0x43, 0x2e, 0x3b,
0x15e, 0x2e, 0x3b, 0x411, 0x2e, 0x3b, 0x411, 0x2e, 0x415, 0x2e, 0x3b, 0x427, 0x2e, 0x410, 0x2e, 0x3b, 0x427, 0x2e, 0x3b, 0x4b8,
0x2e, 0x410, 0x2e, 0x3b, 0x4b8, 0x2e, 0x3b, 0x428, 0x2e, 0x3b, 0x431, 0x430, 0x437, 0x430, 0x440, 0x3b, 0x431, 0x430, 0x437, 0x430,
0x440, 0x20, 0x435, 0x440, 0x442, 0x4d9, 0x441, 0x438, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x20, 0x430, 0x445,
0x448, 0x430, 0x43c, 0x44b, 0x3b, 0x447, 0x4d9, 0x440, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x3b, 0x4b9, 0x4af, 0x43c, 0x4d9, 0x20, 0x430,
0x445, 0x448, 0x430, 0x43c, 0x44b, 0x3b, 0x4b9, 0x4af, 0x43c, 0x4d9, 0x3b, 0x448, 0x4d9, 0x43d, 0x431, 0x4d9, 0x3b, 0x69, 0x67, 0x2e,
0x3b, 0x61, 0x6c, 0x2e, 0x3b, 0x61, 0x72, 0x2e, 0x3b, 0x61, 0x7a, 0x2e, 0x3b, 0x6f, 0x67, 0x2e, 0x3b, 0x6f, 0x72, 0x2e,
0x3b, 0x6c, 0x72, 0x2e, 0x3b, 0x69, 0x67, 0x61, 0x6e, 0x64, 0x65, 0x61, 0x3b, 0x61, 0x73, 0x74, 0x65, 0x6c, 0x65, 0x68,
0x65, 0x6e, 0x61, 0x3b, 0x61, 0x73, 0x74, 0x65, 0x61, 0x72, 0x74, 0x65, 0x61, 0x3b, 0x61, 0x73, 0x74, 0x65, 0x61, 0x7a,
0x6b, 0x65, 0x6e, 0x61, 0x3b, 0x6f, 0x73, 0x74, 0x65, 0x67, 0x75, 0x6e, 0x61, 0x3b, 0x6f, 0x73, 0x74, 0x69, 0x72, 0x61,
0x6c, 0x61, 0x3b, 0x6c, 0x61, 0x72, 0x75, 0x6e, 0x62, 0x61, 0x74, 0x61, 0x3b, 0x49, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41,
0x3b, 0x4f, 0x3b, 0x4f, 0x3b, 0x4c, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x3b, 0x9ae, 0x999, 0x9cd, 0x997, 0x9b2,
0x3b, 0x9ac, 0x9c1, 0x9a7, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa, 0x9a4, 0x9bf, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9b0, 0x3b,
0x9b6, 0x9a8, 0x9bf, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b8, 0x9cb, 0x9ae, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ae, 0x999,
0x9cd, 0x997, 0x9b2, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c1, 0x9a7, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ac, 0x9c3, 0x9b9, 0x9b8, 0x9cd, 0x9aa,
0x9a4, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9c1, 0x995, 0x9cd, 0x9b0, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9b6, 0x9a8, 0x9bf, 0x9ac, 0x9be,
0x9b0, 0x3b, 0x9b0, 0x3b, 0x9b8, 0x9cb, 0x3b, 0x9ae, 0x3b, 0x9ac, 0x9c1, 0x3b, 0x9ac, 0x9c3, 0x3b, 0x9b6, 0x9c1, 0x3b, 0x9b6, 0x3b,
0xf5f, 0xfb3, 0xf0b, 0x3b, 0xf58, 0xf72, 0xf62, 0xf0b, 0x3b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0x3b, 0xf66,
0xf44, 0xf66, 0xf0b, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0x3b, 0xf49, 0xf72, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f, 0xfb3,
0xf0b, 0xf56, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60,
0xf0b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b,
0xf42, 0xf5f, 0xf60, 0xf0b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b,
0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0x3b, 0xf58, 0xf72, 0xf62, 0x3b,
0xf63, 0xfb7, 0xf42, 0x3b, 0xf55, 0xf74, 0xf62, 0x3b, 0xf66, 0xf44, 0xfb6, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0x3b, 0xf49, 0xf72, 0x3b,
0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x65, 0x75, 0x2e, 0x3b, 0x4d, 0x65, 0x72, 0x2e, 0x3b, 0x59, 0x61,
0x6f, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x2e, 0x3b, 0x53, 0x61, 0x64, 0x2e, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e,
0x3b, 0x4d, 0x65, 0x75, 0x72, 0x7a, 0x68, 0x3b, 0x4d, 0x65, 0x72, 0x63, 0x2bc, 0x68, 0x65, 0x72, 0x3b, 0x59, 0x61, 0x6f,
0x75, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x53, 0x61, 0x64, 0x6f, 0x72, 0x6e, 0x3b, 0x53, 0x75, 0x3b, 0x4c,
0x3b, 0x4d, 0x7a, 0x3b, 0x4d, 0x63, 0x3b, 0x59, 0x3b, 0x47, 0x3b, 0x53, 0x61, 0x3b, 0x43d, 0x434, 0x3b, 0x43f, 0x43d, 0x3b,
0x432, 0x442, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x442, 0x3b, 0x43f, 0x442, 0x3b, 0x441, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x43b,
0x44f, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x43d, 0x438, 0x43a, 0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a,
0x3b, 0x441, 0x440, 0x44f, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x44a, 0x440, 0x442, 0x44a, 0x43a, 0x3b, 0x43f, 0x435, 0x442,
0x44a, 0x43a, 0x3b, 0x441, 0x44a, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b, 0x43f, 0x3b, 0x432, 0x3b, 0x441, 0x3b, 0x447, 0x3b,
0x43f, 0x3b, 0x441, 0x3b, 0x1010, 0x1014, 0x1004, 0x103a, 0x1039, 0x1002, 0x1014, 0x103d, 0x1031, 0x3b, 0x1010, 0x1014, 0x1004, 0x103a, 0x1039, 0x101c,
0x102c, 0x3b, 0x1021, 0x1004, 0x103a, 0x1039, 0x1002, 0x102b, 0x3b, 0x1017, 0x102f, 0x1012, 0x1039, 0x1013, 0x101f, 0x1030, 0x1038, 0x3b, 0x1000, 0x103c,
0x102c, 0x101e, 0x1015, 0x1010, 0x1031, 0x1038, 0x3b, 0x101e, 0x1031, 0x102c, 0x1000, 0x103c, 0x102c, 0x3b, 0x1005, 0x1014, 0x1031, 0x3b, 0x1010, 0x3b,
0x1010, 0x3b, 0x1021, 0x3b, 0x1017, 0x3b, 0x1000, 0x3b, 0x101e, 0x3b, 0x1005, 0x3b, 0x43d, 0x434, 0x3b, 0x43f, 0x43d, 0x3b, 0x430, 0x45e,
0x3b, 0x441, 0x440, 0x3b, 0x447, 0x446, 0x3b, 0x43f, 0x442, 0x3b, 0x441, 0x431, 0x3b, 0x43d, 0x44f, 0x434, 0x437, 0x435, 0x43b, 0x44f,
0x3b, 0x43f, 0x430, 0x43d, 0x44f, 0x434, 0x437, 0x435, 0x43b, 0x430, 0x43a, 0x3b, 0x430, 0x45e, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b,
0x441, 0x435, 0x440, 0x430, 0x434, 0x430, 0x3b, 0x447, 0x430, 0x446, 0x432, 0x435, 0x440, 0x3b, 0x43f, 0x44f, 0x442, 0x43d, 0x456, 0x446,
0x430, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b, 0x43f, 0x3b, 0x430, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f,
0x3b, 0x441, 0x3b, 0x17a2, 0x17b6, 0x1791, 0x17b7, 0x178f, 0x17d2, 0x1799, 0x3b, 0x1785, 0x1793, 0x17d2, 0x1791, 0x3b, 0x17a2, 0x1784, 0x17d2, 0x1782,
0x17b6, 0x179a, 0x3b, 0x1796, 0x17bb, 0x1792, 0x3b, 0x1796, 0x17d2, 0x179a, 0x17a0, 0x3b, 0x179f, 0x17bb, 0x1780, 0x17d2, 0x179a, 0x3b, 0x179f, 0x17c5,
0x179a, 0x17cd, 0x3b, 0x17a2, 0x17b6, 0x1791, 0x17b7, 0x178f, 0x17d2, 0x1799, 0x3b, 0x1785, 0x1793, 0x17d2, 0x1791, 0x3b, 0x17a2, 0x1784, 0x17d2, 0x1782,
0x17b6, 0x179a, 0x3b, 0x1796, 0x17bb, 0x1792, 0x3b, 0x1796, 0x17d2, 0x179a, 0x17a0, 0x179f, 0x17d2, 0x1794, 0x178f, 0x17b7, 0x17cd, 0x3b, 0x179f, 0x17bb,
0x1780, 0x17d2, 0x179a, 0x3b, 0x179f, 0x17c5, 0x179a, 0x17cd, 0x3b, 0x17a2, 0x3b, 0x1785, 0x3b, 0x17a2, 0x3b, 0x1796, 0x3b, 0x1796, 0x3b, 0x179f,
0x3b, 0x179f, 0x3b, 0x17a2, 0x17b6, 0x1791, 0x17b7, 0x178f, 0x17d2, 0x1799, 0x3b, 0x1785, 0x17d0, 0x1793, 0x17d2, 0x1791, 0x3b, 0x17a2, 0x1784, 0x17d2,
0x1782, 0x17b6, 0x179a, 0x3b, 0x1796, 0x17bb, 0x1792, 0x3b, 0x1796, 0x17d2, 0x179a, 0x17a0, 0x179f, 0x17d2, 0x1794, 0x178f, 0x17b7, 0x17cd, 0x3b, 0x179f,
0x17bb, 0x1780, 0x17d2, 0x179a, 0x3b, 0x179f, 0x17c5, 0x179a, 0x17cd, 0x3b, 0x64, 0x67, 0x2e, 0x3b, 0x64, 0x6c, 0x2e, 0x3b, 0x64, 0x74,
0x2e, 0x3b, 0x64, 0x63, 0x2e, 0x3b, 0x64, 0x6a, 0x2e, 0x3b, 0x64, 0x76, 0x2e, 0x3b, 0x64, 0x73, 0x2e, 0x3b, 0x64, 0x69,
0x75, 0x6d, 0x65, 0x6e, 0x67, 0x65, 0x3b, 0x64, 0x69, 0x6c, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x72,
0x74, 0x73, 0x3b, 0x64, 0x69, 0x6d, 0x65, 0x63, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x6a, 0x6f, 0x75, 0x73, 0x3b, 0x64,
0x69, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x73, 0x73, 0x61, 0x62, 0x74, 0x65, 0x3b, 0x64, 0x67,
0x3b, 0x64, 0x6c, 0x3b, 0x64, 0x74, 0x3b, 0x64, 0x63, 0x3b, 0x64, 0x6a, 0x3b, 0x64, 0x76, 0x3b, 0x64, 0x73, 0x3b, 0x5468,
0x65e5, 0x3b, 0x5468, 0x4e00, 0x3b, 0x5468, 0x4e8c, 0x3b, 0x5468, 0x4e09, 0x3b, 0x5468, 0x56db, 0x3b, 0x5468, 0x4e94, 0x3b, 0x5468, 0x516d, 0x3b,
0x661f, 0x671f, 0x65e5, 0x3b, 0x661f, 0x671f, 0x4e00, 0x3b, 0x661f, 0x671f, 0x4e8c, 0x3b, 0x661f, 0x671f, 0x4e09, 0x3b, 0x661f, 0x671f, 0x56db, 0x3b,
0x661f, 0x671f, 0x4e94, 0x3b, 0x661f, 0x671f, 0x516d, 0x3b, 0x65e5, 0x3b, 0x4e00, 0x3b, 0x4e8c, 0x3b, 0x4e09, 0x3b, 0x56db, 0x3b, 0x4e94, 0x3b,
0x516d, 0x3b, 0x9031, 0x65e5, 0x3b, 0x9031, 0x4e00, 0x3b, 0x9031, 0x4e8c, 0x3b, 0x9031, 0x4e09, 0x3b, 0x9031, 0x56db, 0x3b, 0x9031, 0x4e94, 0x3b,
0x9031, 0x516d, 0x3b, 0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f, 0x6e, 0x3b, 0x75, 0x74, 0x6f, 0x3b, 0x73, 0x72, 0x69, 0x3b, 0x10d,
0x65, 0x74, 0x3b, 0x70, 0x65, 0x74, 0x3b, 0x73, 0x75, 0x62, 0x3b, 0x6e, 0x65, 0x64, 0x6a, 0x65, 0x6c, 0x6a, 0x61, 0x3b,
0x70, 0x6f, 0x6e, 0x65, 0x64, 0x6a, 0x65, 0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73,
0x72, 0x69, 0x6a, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61,
0x6b, 0x3b, 0x73, 0x75, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x75, 0x3b, 0x73, 0x3b, 0x10d, 0x3b, 0x70,
0x3b, 0x73, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0x55, 0x3b, 0x53, 0x3b, 0x10c, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x6e, 0x65, 0x3b,
0x70, 0x6f, 0x3b, 0xfa, 0x74, 0x3b, 0x73, 0x74, 0x3b, 0x10d, 0x74, 0x3b, 0x70, 0xe1, 0x3b, 0x73, 0x6f, 0x3b, 0x6e, 0x65,
0x64, 0x11b, 0x6c, 0x65, 0x3b, 0x70, 0x6f, 0x6e, 0x64, 0x11b, 0x6c, 0xed, 0x3b, 0xfa, 0x74, 0x65, 0x72, 0xfd, 0x3b, 0x73,
0x74, 0x159, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x74, 0x76, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0xe1, 0x74, 0x65, 0x6b, 0x3b,
0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0xda, 0x3b, 0x53, 0x3b, 0x10c, 0x3b, 0x50, 0x3b, 0x53,
0x3b, 0x73, 0xf8, 0x6e, 0x3b, 0x6d, 0x61, 0x6e, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72,
0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0xf8, 0x72, 0x3b, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0x61, 0x6e, 0x64,
0x61, 0x67, 0x3b, 0x74, 0x69, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f,
0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66, 0x72, 0x65, 0x64, 0x61, 0x67, 0x3b, 0x6c, 0xf8, 0x72, 0x64, 0x61, 0x67, 0x3b,
0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4f, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x73, 0xf8, 0x6e, 0x2e, 0x3b, 0x6d,
0x61, 0x6e, 0x2e, 0x3b, 0x74, 0x69, 0x72, 0x2e, 0x3b, 0x6f, 0x6e, 0x73, 0x2e, 0x3b, 0x74, 0x6f, 0x72, 0x2e, 0x3b, 0x66,
0x72, 0x65, 0x2e, 0x3b, 0x6c, 0xf8, 0x72, 0x2e, 0x3b, 0x7a, 0x6f, 0x3b, 0x6d, 0x61, 0x3b, 0x64, 0x69, 0x3b, 0x77, 0x6f,
0x3b, 0x64, 0x6f, 0x3b, 0x76, 0x72, 0x3b, 0x7a, 0x61, 0x3b, 0x7a, 0x6f, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0x61, 0x61,
0x6e, 0x64, 0x61, 0x67, 0x3b, 0x64, 0x69, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x77, 0x6f, 0x65, 0x6e, 0x73, 0x64, 0x61,
0x67, 0x3b, 0x64, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x76, 0x72, 0x69, 0x6a, 0x64, 0x61, 0x67, 0x3b,
0x7a, 0x61, 0x74, 0x65, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x5a, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x57, 0x3b, 0x44, 0x3b, 0x56,
0x3b, 0x5a, 0x3b, 0x53, 0x75, 0x2e, 0x3b, 0x4d, 0x2e, 0x3b, 0x54, 0x75, 0x2e, 0x3b, 0x57, 0x2e, 0x3b, 0x54, 0x68, 0x2e,
0x3b, 0x46, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0x75, 0x6e, 0x2e, 0x3b, 0x4d, 0x6f, 0x6e, 0x2e, 0x3b, 0x54, 0x75,
0x65, 0x2e, 0x3b, 0x57, 0x65, 0x64, 0x2e, 0x3b, 0x54, 0x68, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x69, 0x2e, 0x3b, 0x53, 0x61,
0x74, 0x2e, 0x3b, 0x64, 0x69, 0x3b, 0x6c, 0x75, 0x3b, 0x6d, 0x61, 0x3b, 0x6d, 0x65, 0x3b, 0x135, 0x61, 0x3b, 0x76, 0x65,
0x3b, 0x73, 0x61, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x6e, 0x109, 0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x6f, 0x3b, 0x6d, 0x61,
0x72, 0x64, 0x6f, 0x3b, 0x6d, 0x65, 0x72, 0x6b, 0x72, 0x65, 0x64, 0x6f, 0x3b, 0x135, 0x61, 0x16d, 0x64, 0x6f, 0x3b, 0x76,
0x65, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x6f, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d,
0x3b, 0x4d, 0x3b, 0x134, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x45, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x52,
0x3b, 0x4c, 0x3b, 0x70, 0xfc, 0x68, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x65, 0x73, 0x6d, 0x61, 0x73, 0x70, 0xe4, 0x65,
0x76, 0x3b, 0x74, 0x65, 0x69, 0x73, 0x69, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x6b, 0x6f, 0x6c, 0x6d, 0x61, 0x70, 0xe4, 0x65,
0x76, 0x3b, 0x6e, 0x65, 0x6c, 0x6a, 0x61, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x72, 0x65, 0x65, 0x64, 0x65, 0x3b, 0x6c, 0x61,
0x75, 0x70, 0xe4, 0x65, 0x76, 0x3b, 0x73, 0x75, 0x6e, 0x3b, 0x6d, 0xe1, 0x6e, 0x3b, 0x74, 0xfd, 0x73, 0x3b, 0x6d, 0x69,
0x6b, 0x3b, 0x68, 0xf3, 0x73, 0x3b, 0x66, 0x72, 0xed, 0x3b, 0x6c, 0x65, 0x79, 0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x64,
0x61, 0x67, 0x75, 0x72, 0x3b, 0x6d, 0xe1, 0x6e, 0x61, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x74, 0xfd, 0x73, 0x64, 0x61,
0x67, 0x75, 0x72, 0x3b, 0x6d, 0x69, 0x6b, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x68, 0xf3, 0x73, 0x64, 0x61, 0x67,
0x75, 0x72, 0x3b, 0x66, 0x72, 0xed, 0x67, 0x67, 0x6a, 0x61, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x6c, 0x65, 0x79, 0x67,
0x61, 0x72, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x46, 0x3b,
0x4c, 0x3b, 0x73, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0xe1, 0x6e, 0x2e, 0x3b, 0x74, 0xfd, 0x73, 0x2e, 0x3b, 0x6d, 0x69, 0x6b,
0x2e, 0x3b, 0x68, 0xf3, 0x73, 0x2e, 0x3b, 0x66, 0x72, 0xed, 0x2e, 0x3b, 0x6c, 0x65, 0x79, 0x2e, 0x3b, 0x73, 0x75, 0x3b,
0x6d, 0x61, 0x3b, 0x74, 0x69, 0x3b, 0x6b, 0x65, 0x3b, 0x74, 0x6f, 0x3b, 0x70, 0x65, 0x3b, 0x6c, 0x61, 0x3b, 0x73, 0x75,
0x6e, 0x6e, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x74, 0x69,
0x69, 0x73, 0x74, 0x61, 0x69, 0x3b, 0x6b, 0x65, 0x73, 0x6b, 0x69, 0x76, 0x69, 0x69, 0x6b, 0x6b, 0x6f, 0x3b, 0x74, 0x6f,
0x72, 0x73, 0x74, 0x61, 0x69, 0x3b, 0x70, 0x65, 0x72, 0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x3b, 0x6c, 0x61, 0x75, 0x61,
0x6e, 0x74, 0x61, 0x69, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x50, 0x3b, 0x4c, 0x3b, 0x73,
0x75, 0x6e, 0x6e, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6d, 0x61, 0x61, 0x6e, 0x61, 0x6e, 0x74, 0x61, 0x69,
0x6e, 0x61, 0x3b, 0x74, 0x69, 0x69, 0x73, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6b, 0x65, 0x73, 0x6b, 0x69, 0x76, 0x69,
0x69, 0x6b, 0x6b, 0x6f, 0x6e, 0x61, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x70, 0x65, 0x72,
0x6a, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b, 0x6c, 0x61, 0x75, 0x61, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x61, 0x3b,
0x64, 0x69, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d, 0x65, 0x72, 0x2e, 0x3b,
0x6a, 0x65, 0x75, 0x2e, 0x3b, 0x76, 0x65, 0x6e, 0x2e, 0x3b, 0x73, 0x61, 0x6d, 0x2e, 0x3b, 0x64, 0x69, 0x6d, 0x61, 0x6e,
0x63, 0x68, 0x65, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x72, 0x63,
0x72, 0x65, 0x64, 0x69, 0x3b, 0x6a, 0x65, 0x75, 0x64, 0x69, 0x3b, 0x76, 0x65, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x69, 0x3b,
0x73, 0x61, 0x6d, 0x65, 0x64, 0x69, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x56, 0x3b, 0x53,
0x3b, 0x73, 0x69, 0x3b, 0x6d, 0x6f, 0x3b, 0x74, 0x69, 0x3b, 0x77, 0x6f, 0x3b, 0x74, 0x6f, 0x3b, 0x66, 0x72, 0x3b, 0x73,
0x6f, 0x3b, 0x73, 0x6e, 0x65, 0x69, 0x6e, 0x3b, 0x6d, 0x6f, 0x61, 0x6e, 0x64, 0x65, 0x69, 0x3b, 0x74, 0x69, 0x69, 0x73,
0x64, 0x65, 0x69, 0x3b, 0x77, 0x6f, 0x61, 0x6e, 0x73, 0x64, 0x65, 0x69, 0x3b, 0x74, 0x6f, 0x6e, 0x67, 0x65, 0x72, 0x73,
0x64, 0x65, 0x69, 0x3b, 0x66, 0x72, 0x65, 0x65, 0x64, 0x3b, 0x73, 0x6e, 0x65, 0x6f, 0x6e, 0x3b, 0x44, 0x69, 0x44, 0x3b,
0x44, 0x69, 0x4c, 0x3b, 0x44, 0x69, 0x4d, 0x3b, 0x44, 0x69, 0x43, 0x3b, 0x44, 0x69, 0x61, 0x3b, 0x44, 0x69, 0x68, 0x3b,
0x44, 0x69, 0x53, 0x3b, 0x44, 0x69, 0x44, 0xf2, 0x6d, 0x68, 0x6e, 0x61, 0x69, 0x63, 0x68, 0x3b, 0x44, 0x69, 0x4c, 0x75,
0x61, 0x69, 0x6e, 0x3b, 0x44, 0x69, 0x4d, 0xe0, 0x69, 0x72, 0x74, 0x3b, 0x44, 0x69, 0x43, 0x69, 0x61, 0x64, 0x61, 0x69,
0x6e, 0x3b, 0x44, 0x69, 0x61, 0x72, 0x44, 0x61, 0x6f, 0x69, 0x6e, 0x3b, 0x44, 0x69, 0x68, 0x41, 0x6f, 0x69, 0x6e, 0x65,
0x3b, 0x44, 0x69, 0x53, 0x61, 0x74, 0x68, 0x61, 0x69, 0x72, 0x6e, 0x65, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x43,
0x3b, 0x41, 0x3b, 0x48, 0x3b, 0x53, 0x3b, 0x44, 0x6f, 0x6d, 0x2e, 0x3b, 0x4c, 0x75, 0x6e, 0x73, 0x3b, 0x4d, 0x61, 0x72,
0x2e, 0x3b, 0x4d, 0xe9, 0x72, 0x2e, 0x3b, 0x58, 0x6f, 0x76, 0x2e, 0x3b, 0x56, 0x65, 0x6e, 0x2e, 0x3b, 0x53, 0xe1, 0x62,
0x2e, 0x3b, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65,
0x73, 0x3b, 0x4d, 0xe9, 0x72, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x3b, 0x58, 0x6f, 0x76, 0x65, 0x73, 0x3b, 0x56, 0x65, 0x6e,
0x72, 0x65, 0x73, 0x3b, 0x53, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x58,
0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b,
0x6d, 0xe9, 0x72, 0x2e, 0x3b, 0x78, 0x6f, 0x76, 0x2e, 0x3b, 0x76, 0x65, 0x6e, 0x2e, 0x3b, 0x73, 0xe1, 0x62, 0x2e, 0x3b,
0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b,
0x6d, 0xe9, 0x72, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x3b, 0x78, 0x6f, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x65, 0x6e, 0x72, 0x65,
0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x64, 0x2e, 0x3b, 0x6c, 0x2e, 0x3b, 0x6d, 0x2e, 0x3b, 0x6d, 0x2e,
0x3b, 0x78, 0x2e, 0x3b, 0x76, 0x2e, 0x3b, 0x73, 0x2e, 0x3b, 0x10d9, 0x10d5, 0x10d8, 0x3b, 0x10dd, 0x10e0, 0x10e8, 0x3b, 0x10e1, 0x10d0,
0x10db, 0x3b, 0x10dd, 0x10d7, 0x10ee, 0x3b, 0x10ee, 0x10e3, 0x10d7, 0x3b, 0x10de, 0x10d0, 0x10e0, 0x3b, 0x10e8, 0x10d0, 0x10d1, 0x3b, 0x10d9, 0x10d5,
0x10d8, 0x10e0, 0x10d0, 0x3b, 0x10dd, 0x10e0, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10e1, 0x10d0, 0x10db, 0x10e8, 0x10d0, 0x10d1, 0x10d0,
0x10d7, 0x10d8, 0x3b, 0x10dd, 0x10d7, 0x10ee, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b, 0x10ee, 0x10e3, 0x10d7, 0x10e8, 0x10d0, 0x10d1, 0x10d0,
0x10d7, 0x10d8, 0x3b, 0x10de, 0x10d0, 0x10e0, 0x10d0, 0x10e1, 0x10d9, 0x10d4, 0x10d5, 0x10d8, 0x3b, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10d7, 0x10d8, 0x3b,
0x10d9, 0x3b, 0x10dd, 0x3b, 0x10e1, 0x3b, 0x10dd, 0x3b, 0x10ee, 0x3b, 0x10de, 0x3b, 0x10e8, 0x3b, 0x53, 0x6f, 0x3b, 0x4d, 0x6f, 0x3b,
0x44, 0x69, 0x3b, 0x4d, 0x69, 0x3b, 0x44, 0x6f, 0x3b, 0x46, 0x72, 0x3b, 0x53, 0x61, 0x3b, 0x53, 0x6f, 0x6e, 0x6e, 0x74,
0x61, 0x67, 0x3b, 0x4d, 0x6f, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x44, 0x69, 0x65, 0x6e, 0x73, 0x74, 0x61, 0x67, 0x3b, 0x4d,
0x69, 0x74, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x6f, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x74, 0x61, 0x67, 0x3b, 0x46,
0x72, 0x65, 0x69, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x44,
0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x53, 0x6f, 0x2e, 0x3b, 0x4d, 0x6f, 0x2e, 0x3b, 0x44, 0x69, 0x2e,
0x3b, 0x4d, 0x69, 0x2e, 0x3b, 0x44, 0x6f, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x39a, 0x3c5, 0x3c1,
0x3b, 0x394, 0x3b5, 0x3c5, 0x3b, 0x3a4, 0x3c1, 0x3af, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3b, 0x3a0, 0x3ad, 0x3bc, 0x3b, 0x3a0, 0x3b1, 0x3c1,
0x3b, 0x3a3, 0x3ac, 0x3b2, 0x3b, 0x39a, 0x3c5, 0x3c1, 0x3b9, 0x3b1, 0x3ba, 0x3ae, 0x3b, 0x394, 0x3b5, 0x3c5, 0x3c4, 0x3ad, 0x3c1, 0x3b1,
0x3b, 0x3a4, 0x3c1, 0x3af, 0x3c4, 0x3b7, 0x3b, 0x3a4, 0x3b5, 0x3c4, 0x3ac, 0x3c1, 0x3c4, 0x3b7, 0x3b, 0x3a0, 0x3ad, 0x3bc, 0x3c0, 0x3c4,
0x3b7, 0x3b, 0x3a0, 0x3b1, 0x3c1, 0x3b1, 0x3c3, 0x3ba, 0x3b5, 0x3c5, 0x3ae, 0x3b, 0x3a3, 0x3ac, 0x3b2, 0x3b2, 0x3b1, 0x3c4, 0x3bf, 0x3b,
0x39a, 0x3b, 0x394, 0x3b, 0x3a4, 0x3b, 0x3a4, 0x3b, 0x3a0, 0x3b, 0x3a0, 0x3b, 0x3a3, 0x3b, 0x73, 0x61, 0x70, 0x3b, 0x61, 0x74,
0x61, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x70, 0x69, 0x6e, 0x3b, 0x73, 0x69, 0x73, 0x3b, 0x74, 0x61, 0x6c, 0x3b, 0x61, 0x72,
0x66, 0x3b, 0x73, 0x61, 0x70, 0x61, 0x61, 0x74, 0x3b, 0x61, 0x74, 0x61, 0x61, 0x73, 0x69, 0x6e, 0x6e, 0x67, 0x6f, 0x72,
0x6e, 0x65, 0x71, 0x3b, 0x6d, 0x61, 0x72, 0x6c, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x70, 0x69,
0x6e, 0x67, 0x61, 0x73, 0x75, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x73, 0x69, 0x73, 0x61, 0x6d, 0x61,
0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b, 0x74, 0x61, 0x6c, 0x6c, 0x69, 0x6d, 0x61, 0x6e, 0x6e, 0x67, 0x6f,
0x72, 0x6e, 0x65, 0x71, 0x3b, 0x61, 0x72, 0x66, 0x69, 0x6e, 0x69, 0x6e, 0x6e, 0x67, 0x6f, 0x72, 0x6e, 0x65, 0x71, 0x3b,
0x53, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0xab0, 0xab5, 0xabf, 0x3b, 0xab8, 0xacb,
0xaae, 0x3b, 0xaae, 0xa82, 0xa97, 0xab3, 0x3b, 0xaac, 0xac1, 0xaa7, 0x3b, 0xa97, 0xac1, 0xab0, 0xac1, 0x3b, 0xab6, 0xac1, 0xa95, 0xacd,
0xab0, 0x3b, 0xab6, 0xaa8, 0xabf, 0x3b, 0xab0, 0xab5, 0xabf, 0xab5, 0xabe, 0xab0, 0x3b, 0xab8, 0xacb, 0xaae, 0xab5, 0xabe, 0xab0, 0x3b,
0xaae, 0xa82, 0xa97, 0xab3, 0xab5, 0xabe, 0xab0, 0x3b, 0xaac, 0xac1, 0xaa7, 0xab5, 0xabe, 0xab0, 0x3b, 0xa97, 0xac1, 0xab0, 0xac1, 0xab5,
0xabe, 0xab0, 0x3b, 0xab6, 0xac1, 0xa95, 0xacd, 0xab0, 0xab5, 0xabe, 0xab0, 0x3b, 0xab6, 0xaa8, 0xabf, 0xab5, 0xabe, 0xab0, 0x3b, 0xab0,
0x3b, 0xab8, 0xacb, 0x3b, 0xaae, 0xa82, 0x3b, 0xaac, 0xac1, 0x3b, 0xa97, 0xac1, 0x3b, 0xab6, 0xac1, 0x3b, 0xab6, 0x3b, 0x4c, 0x61,
0x68, 0x3b, 0x4c, 0x69, 0x74, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x4c, 0x61, 0x72, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x4a, 0x75,
0x6d, 0x3b, 0x41, 0x73, 0x61, 0x3b, 0x4c, 0x61, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x4c, 0x69, 0x74, 0x69, 0x6e, 0x69, 0x6e,
0x3b, 0x54, 0x61, 0x6c, 0x61, 0x74, 0x61, 0x3b, 0x4c, 0x61, 0x72, 0x61, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d,
0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x6d, 0x61, 0x2bc, 0x61, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x61, 0x72, 0x3b, 0x4c, 0x3b,
0x4c, 0x3b, 0x54, 0x3b, 0x4c, 0x3b, 0x41, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d0, 0x5f3, 0x3b, 0x5d9,
0x5d5, 0x5dd, 0x20, 0x5d1, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d2, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d3, 0x5f3, 0x3b,
0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d4, 0x5f3, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5d5, 0x5f3, 0x3b, 0x5e9, 0x5d1, 0x5ea, 0x3b, 0x5d9, 0x5d5,
0x5dd, 0x20, 0x5e8, 0x5d0, 0x5e9, 0x5d5, 0x5df, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5e0, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20,
0x5e9, 0x5dc, 0x5d9, 0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20,
0x5d7, 0x5de, 0x5d9, 0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9, 0x5d9, 0x5e9, 0x5d9, 0x3b, 0x5d9, 0x5d5, 0x5dd, 0x20, 0x5e9,
0x5d1, 0x5ea, 0x3b, 0x5d0, 0x5f3, 0x3b, 0x5d1, 0x5f3, 0x3b, 0x5d2, 0x5f3, 0x3b, 0x5d3, 0x5f3, 0x3b, 0x5d4, 0x5f3, 0x3b, 0x5d5, 0x5f3,
0x3b, 0x5e9, 0x5f3, 0x3b, 0x930, 0x935, 0x93f, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x3b, 0x92c, 0x941, 0x927,
0x3b, 0x917, 0x941, 0x930, 0x941, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x930, 0x935, 0x93f, 0x935,
0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x941,
0x927, 0x935, 0x93e, 0x930, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e,
0x930, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x930, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b,
0x917, 0x941, 0x3b, 0x936, 0x941, 0x3b, 0x936, 0x3b, 0x56, 0x3b, 0x48, 0x3b, 0x4b, 0x3b, 0x53, 0x7a, 0x65, 0x3b, 0x43, 0x73,
0x3b, 0x50, 0x3b, 0x53, 0x7a, 0x6f, 0x3b, 0x76, 0x61, 0x73, 0xe1, 0x72, 0x6e, 0x61, 0x70, 0x3b, 0x68, 0xe9, 0x74, 0x66,
0x151, 0x3b, 0x6b, 0x65, 0x64, 0x64, 0x3b, 0x73, 0x7a, 0x65, 0x72, 0x64, 0x61, 0x3b, 0x63, 0x73, 0xfc, 0x74, 0xf6, 0x72,
0x74, 0xf6, 0x6b, 0x3b, 0x70, 0xe9, 0x6e, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x7a, 0x6f, 0x6d, 0x62, 0x61, 0x74, 0x3b, 0x56,
0x3b, 0x48, 0x3b, 0x4b, 0x3b, 0x53, 0x7a, 0x3b, 0x43, 0x73, 0x3b, 0x50, 0x3b, 0x53, 0x7a, 0x3b, 0x73, 0x75, 0x6e, 0x2e,
0x3b, 0x6d, 0xe1, 0x6e, 0x2e, 0x3b, 0xfe, 0x72, 0x69, 0x2e, 0x3b, 0x6d, 0x69, 0xf0, 0x2e, 0x3b, 0x66, 0x69, 0x6d, 0x2e,
0x3b, 0x66, 0xf6, 0x73, 0x2e, 0x3b, 0x6c, 0x61, 0x75, 0x2e, 0x3b, 0x73, 0x75, 0x6e, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75,
0x72, 0x3b, 0x6d, 0xe1, 0x6e, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0xfe, 0x72, 0x69, 0xf0, 0x6a, 0x75, 0x64, 0x61,
0x67, 0x75, 0x72, 0x3b, 0x6d, 0x69, 0xf0, 0x76, 0x69, 0x6b, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0x69, 0x6d,
0x6d, 0x74, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x66, 0xf6, 0x73, 0x74, 0x75, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b,
0x6c, 0x61, 0x75, 0x67, 0x61, 0x72, 0x64, 0x61, 0x67, 0x75, 0x72, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0xde, 0x3b, 0x4d, 0x3b,
0x46, 0x3b, 0x46, 0x3b, 0x4c, 0x3b, 0x4d, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x3b, 0x52, 0x61,
0x62, 0x3b, 0x4b, 0x61, 0x6d, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4d, 0x69, 0x6e, 0x67, 0x67, 0x75,
0x3b, 0x53, 0x65, 0x6e, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x61, 0x62, 0x75, 0x3b, 0x4b,
0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x75, 0x3b, 0x4d, 0x3b, 0x53,
0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d,
0x61, 0x72, 0x3b, 0x6d, 0x65, 0x72, 0x3b, 0x6a, 0x6f, 0x76, 0x3b, 0x76, 0x65, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64,
0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x3b, 0x6c, 0x75, 0x6e, 0x65, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65,
0x64, 0x69, 0x3b, 0x6d, 0x65, 0x72, 0x63, 0x75, 0x72, 0x69, 0x64, 0x69, 0x3b, 0x6a, 0x6f, 0x76, 0x65, 0x64, 0x69, 0x3b,
0x76, 0x65, 0x6e, 0x65, 0x72, 0x64, 0x69, 0x3b, 0x73, 0x61, 0x62, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x64, 0x3b, 0x6c, 0x3b,
0x6d, 0x3b, 0x6d, 0x3b, 0x6a, 0x3b, 0x76, 0x3b, 0x73, 0x3b, 0x44, 0x6f, 0x6d, 0x68, 0x3b, 0x4c, 0x75, 0x61, 0x6e, 0x3b,
0x4d, 0xe1, 0x69, 0x72, 0x74, 0x3b, 0x43, 0xe9, 0x61, 0x64, 0x3b, 0x44, 0xe9, 0x61, 0x72, 0x3b, 0x41, 0x6f, 0x69, 0x6e,
0x65, 0x3b, 0x53, 0x61, 0x74, 0x68, 0x3b, 0x44, 0xe9, 0x20, 0x44, 0x6f, 0x6d, 0x68, 0x6e, 0x61, 0x69, 0x67, 0x68, 0x3b,
0x44, 0xe9, 0x20, 0x4c, 0x75, 0x61, 0x69, 0x6e, 0x3b, 0x44, 0xe9, 0x20, 0x4d, 0xe1, 0x69, 0x72, 0x74, 0x3b, 0x44, 0xe9,
0x20, 0x43, 0xe9, 0x61, 0x64, 0x61, 0x6f, 0x69, 0x6e, 0x3b, 0x44, 0xe9, 0x61, 0x72, 0x64, 0x61, 0x6f, 0x69, 0x6e, 0x3b,
0x44, 0xe9, 0x20, 0x68, 0x41, 0x6f, 0x69, 0x6e, 0x65, 0x3b, 0x44, 0xe9, 0x20, 0x53, 0x61, 0x74, 0x68, 0x61, 0x69, 0x72,
0x6e, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x44, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x3b,
0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x72, 0x3b, 0x67, 0x69, 0x6f, 0x3b, 0x76, 0x65, 0x6e, 0x3b,
0x73, 0x61, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x65, 0x6e, 0x69, 0x63, 0x61, 0x3b, 0x6c, 0x75, 0x6e, 0x65, 0x64, 0xec, 0x3b,
0x6d, 0x61, 0x72, 0x74, 0x65, 0x64, 0xec, 0x3b, 0x6d, 0x65, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x64, 0xec, 0x3b, 0x67, 0x69,
0x6f, 0x76, 0x65, 0x64, 0xec, 0x3b, 0x76, 0x65, 0x6e, 0x65, 0x72, 0x64, 0xec, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f,
0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x65e5, 0x3b, 0x6708, 0x3b, 0x706b,
0x3b, 0x6c34, 0x3b, 0x6728, 0x3b, 0x91d1, 0x3b, 0x571f, 0x3b, 0x65e5, 0x66dc, 0x65e5, 0x3b, 0x6708, 0x66dc, 0x65e5, 0x3b, 0x706b, 0x66dc, 0x65e5,
0x3b, 0x6c34, 0x66dc, 0x65e5, 0x3b, 0x6728, 0x66dc, 0x65e5, 0x3b, 0x91d1, 0x66dc, 0x65e5, 0x3b, 0x571f, 0x66dc, 0x65e5, 0x3b, 0x41, 0x68, 0x61,
0x64, 0x3b, 0x53, 0x65, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x4b, 0x61, 0x6d, 0x3b, 0x4a, 0x75,
0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x41, 0x68, 0x61, 0x64, 0x3b, 0x53, 0x65, 0x6e, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6c,
0x61, 0x73, 0x61, 0x3b, 0x52, 0x61, 0x62, 0x75, 0x3b, 0x4b, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74,
0x3b, 0x53, 0x61, 0x62, 0x74, 0x75, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53,
0x3b, 0xcad, 0xcbe, 0xca8, 0xcc1, 0x3b, 0xcb8, 0xccb, 0xcae, 0x3b, 0xcae, 0xc82, 0xc97, 0xcb3, 0x3b, 0xcac, 0xcc1, 0xca7, 0x3b, 0xc97,
0xcc1, 0xcb0, 0xcc1, 0x3b, 0xcb6, 0xcc1, 0xc95, 0xccd, 0xcb0, 0x3b, 0xcb6, 0xca8, 0xcbf, 0x3b, 0xcad, 0xcbe, 0xca8, 0xcc1, 0xcb5, 0xcbe,
0xcb0, 0x3b, 0xcb8, 0xccb, 0xcae, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcae, 0xc82, 0xc97, 0xcb3, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcac, 0xcc1, 0xca7,
0xcb5, 0xcbe, 0xcb0, 0x3b, 0xc97, 0xcc1, 0xcb0, 0xcc1, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcb6, 0xcc1, 0xc95, 0xccd, 0xcb0, 0xcb5, 0xcbe, 0xcb0,
0x3b, 0xcb6, 0xca8, 0xcbf, 0xcb5, 0xcbe, 0xcb0, 0x3b, 0xcad, 0xcbe, 0x3b, 0xcb8, 0xccb, 0x3b, 0xcae, 0xc82, 0x3b, 0xcac, 0xcc1, 0x3b,
0xc97, 0xcc1, 0x3b, 0xcb6, 0xcc1, 0x3b, 0xcb6, 0x3b, 0x622, 0x62a, 0x6be, 0x648, 0x627, 0x631, 0x3b, 0x698, 0x654, 0x646, 0x62f, 0x655,
0x631, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x6c6, 0x645, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x648, 0x62f, 0x648, 0x627, 0x631, 0x3b, 0x628,
0x631, 0x620, 0x633, 0x648, 0x627, 0x631, 0x3b, 0x62c, 0x64f, 0x645, 0x6c1, 0x3b, 0x628, 0x679, 0x648, 0x627, 0x631, 0x3b, 0x627, 0x64e,
0x62a, 0x6be, 0x648, 0x627, 0x631, 0x3b, 0x698, 0x654, 0x646, 0x62f, 0x631, 0x655, 0x631, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x6c6, 0x645,
0x648, 0x627, 0x631, 0x3b, 0x628, 0x648, 0x62f, 0x648, 0x627, 0x631, 0x3b, 0x628, 0x631, 0x620, 0x633, 0x648, 0x627, 0x631, 0x3b, 0x62c,
0x64f, 0x645, 0x6c1, 0x3b, 0x628, 0x679, 0x648, 0x627, 0x631, 0x3b, 0x627, 0x3b, 0x698, 0x3b, 0x628, 0x3b, 0x628, 0x3b, 0x628, 0x3b,
0x62c, 0x3b, 0x628, 0x3b, 0x436, 0x441, 0x3b, 0x434, 0x441, 0x3b, 0x441, 0x441, 0x3b, 0x441, 0x440, 0x3b, 0x431, 0x441, 0x3b, 0x436,
0x43c, 0x3b, 0x441, 0x431, 0x3b, 0x436, 0x435, 0x43a, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x434, 0x4af, 0x439, 0x441, 0x435, 0x43d,
0x431, 0x456, 0x3b, 0x441, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x441, 0x4d9, 0x440, 0x441, 0x435, 0x43d, 0x431, 0x456,
0x3b, 0x431, 0x435, 0x439, 0x441, 0x435, 0x43d, 0x431, 0x456, 0x3b, 0x436, 0x4b1, 0x43c, 0x430, 0x3b, 0x441, 0x435, 0x43d, 0x431, 0x456,
0x3b, 0x416, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x421, 0x3b, 0x411, 0x3b, 0x416, 0x3b, 0x421, 0x3b, 0x63, 0x79, 0x75, 0x2e, 0x3b,
0x6d, 0x62, 0x65, 0x2e, 0x3b, 0x6b, 0x61, 0x62, 0x2e, 0x3b, 0x67, 0x74, 0x75, 0x2e, 0x3b, 0x6b, 0x61, 0x6e, 0x2e, 0x3b,
0x67, 0x6e, 0x75, 0x2e, 0x3b, 0x67, 0x6e, 0x64, 0x2e, 0x3b, 0x4b, 0x75, 0x20, 0x63, 0x79, 0x75, 0x6d, 0x77, 0x65, 0x72,
0x75, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x6b, 0x61,
0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4b, 0x75, 0x77,
0x61, 0x20, 0x6b, 0x61, 0x6e, 0x65, 0x3b, 0x4b, 0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4b,
0x75, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x75, 0x3b, 0x436, 0x435, 0x43a, 0x2e, 0x3b, 0x434,
0x4af, 0x439, 0x2e, 0x3b, 0x448, 0x435, 0x439, 0x448, 0x2e, 0x3b, 0x448, 0x430, 0x440, 0x448, 0x2e, 0x3b, 0x431, 0x435, 0x439, 0x448,
0x2e, 0x3b, 0x436, 0x443, 0x43c, 0x430, 0x3b, 0x438, 0x448, 0x43c, 0x2e, 0x3b, 0x436, 0x435, 0x43a, 0x448, 0x435, 0x43c, 0x431, 0x438,
0x3b, 0x434, 0x4af, 0x439, 0x448, 0x4e9, 0x43c, 0x431, 0x4af, 0x3b, 0x448, 0x435, 0x439, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x448,
0x430, 0x440, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x431, 0x435, 0x439, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x436, 0x443, 0x43c,
0x430, 0x3b, 0x438, 0x448, 0x435, 0x43c, 0x431, 0x438, 0x3b, 0x416, 0x3b, 0x414, 0x3b, 0x428, 0x3b, 0x428, 0x3b, 0x411, 0x3b, 0x416,
0x3b, 0x418, 0x3b, 0xc77c, 0x3b, 0xc6d4, 0x3b, 0xd654, 0x3b, 0xc218, 0x3b, 0xbaa9, 0x3b, 0xae08, 0x3b, 0xd1a0, 0x3b, 0xc77c, 0xc694, 0xc77c,
0x3b, 0xc6d4, 0xc694, 0xc77c, 0x3b, 0xd654, 0xc694, 0xc77c, 0x3b, 0xc218, 0xc694, 0xc77c, 0x3b, 0xbaa9, 0xc694, 0xc77c, 0x3b, 0xae08, 0xc694, 0xc77c,
0x3b, 0xd1a0, 0xc694, 0xc77c, 0x3b, 0x79, 0x15f, 0x3b, 0x64, 0x15f, 0x3b, 0x73, 0x15f, 0x3b, 0xe7, 0x15f, 0x3b, 0x70, 0x15f, 0x3b,
0xee, 0x6e, 0x3b, 0x15f, 0x3b, 0x79, 0x65, 0x6b, 0x15f, 0x65, 0x6d, 0x3b, 0x64, 0x75, 0x15f, 0x65, 0x6d, 0x3b, 0x73, 0xea,
0x15f, 0x65, 0x6d, 0x3b, 0xe7, 0x61, 0x72, 0x15f, 0x65, 0x6d, 0x3b, 0x70, 0xea, 0x6e, 0x63, 0x15f, 0x65, 0x6d, 0x3b, 0xee,
0x6e, 0x3b, 0x15f, 0x65, 0x6d, 0xee, 0x3b, 0x59, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0xc7, 0x3b, 0x50, 0x3b, 0xce, 0x3b, 0x15e,
0x3b, 0x63, 0x75, 0x2e, 0x3b, 0x6d, 0x62, 0x65, 0x2e, 0x3b, 0x6b, 0x61, 0x62, 0x2e, 0x3b, 0x67, 0x74, 0x75, 0x2e, 0x3b,
0x6b, 0x61, 0x6e, 0x2e, 0x3b, 0x67, 0x6e, 0x75, 0x2e, 0x3b, 0x67, 0x6e, 0x64, 0x2e, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x2019,
0x69, 0x6e, 0x64, 0x77, 0x69, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6d, 0x62, 0x65, 0x72, 0x65, 0x3b, 0x4b, 0x75,
0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74,
0x61, 0x74, 0x75, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x6b, 0x61, 0x6e, 0x65, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61,
0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x4b, 0x75, 0x20, 0x77, 0x61, 0x20, 0x67, 0x61, 0x74, 0x61, 0x6e, 0x64,
0x61, 0x74, 0x75, 0x3b, 0xead, 0xeb2, 0xe97, 0xeb4, 0xe94, 0x3b, 0xe88, 0xeb1, 0xe99, 0x3b, 0xead, 0xeb1, 0xe87, 0xe84, 0xeb2, 0xe99,
0x3b, 0xe9e, 0xeb8, 0xe94, 0x3b, 0xe9e, 0xeb0, 0xeab, 0xeb1, 0xe94, 0x3b, 0xeaa, 0xeb8, 0xe81, 0x3b, 0xec0, 0xeaa, 0xebb, 0xeb2, 0x3b,
0xea7, 0xeb1, 0xe99, 0xead, 0xeb2, 0xe97, 0xeb4, 0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe88, 0xeb1, 0xe99, 0x3b, 0xea7, 0xeb1, 0xe99, 0xead,
0xeb1, 0xe87, 0xe84, 0xeb2, 0xe99, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe9e, 0xeb8, 0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xe9e, 0xeb0, 0xeab, 0xeb1,
0xe94, 0x3b, 0xea7, 0xeb1, 0xe99, 0xeaa, 0xeb8, 0xe81, 0x3b, 0xea7, 0xeb1, 0xe99, 0xec0, 0xeaa, 0xebb, 0xeb2, 0x3b, 0xead, 0xeb2, 0x3b,
0xe88, 0x3b, 0xead, 0x3b, 0xe9e, 0x3b, 0xe9e, 0xeab, 0x3b, 0xeaa, 0xeb8, 0x3b, 0xeaa, 0x3b, 0x53, 0x76, 0x113, 0x74, 0x64, 0x2e,
0x3b, 0x50, 0x69, 0x72, 0x6d, 0x64, 0x2e, 0x3b, 0x4f, 0x74, 0x72, 0x64, 0x2e, 0x3b, 0x54, 0x72, 0x65, 0x161, 0x64, 0x2e,
0x3b, 0x43, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x2e, 0x3b, 0x50, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x2e, 0x3b, 0x53, 0x65,
0x73, 0x74, 0x64, 0x2e, 0x3b, 0x53, 0x76, 0x113, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x50, 0x69, 0x72, 0x6d, 0x64,
0x69, 0x65, 0x6e, 0x61, 0x3b, 0x4f, 0x74, 0x72, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x54, 0x72, 0x65, 0x161, 0x64, 0x69,
0x65, 0x6e, 0x61, 0x3b, 0x43, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x50, 0x69, 0x65, 0x6b,
0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x53, 0x65, 0x73, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x53, 0x3b, 0x50,
0x3b, 0x4f, 0x3b, 0x54, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x73, 0x76, 0x113, 0x74, 0x64, 0x2e, 0x3b, 0x70, 0x69,
0x72, 0x6d, 0x64, 0x2e, 0x3b, 0x6f, 0x74, 0x72, 0x64, 0x2e, 0x3b, 0x74, 0x72, 0x65, 0x161, 0x64, 0x2e, 0x3b, 0x63, 0x65,
0x74, 0x75, 0x72, 0x74, 0x64, 0x2e, 0x3b, 0x70, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x2e, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x64,
0x2e, 0x3b, 0x73, 0x76, 0x113, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x70, 0x69, 0x72, 0x6d, 0x64, 0x69, 0x65, 0x6e,
0x61, 0x3b, 0x6f, 0x74, 0x72, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x74, 0x72, 0x65, 0x161, 0x64, 0x69, 0x65, 0x6e, 0x61,
0x3b, 0x63, 0x65, 0x74, 0x75, 0x72, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x70, 0x69, 0x65, 0x6b, 0x74, 0x64, 0x69,
0x65, 0x6e, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x64, 0x69, 0x65, 0x6e, 0x61, 0x3b, 0x65, 0x79, 0x65, 0x3b, 0x79, 0x62,
0x6f, 0x3b, 0x6d, 0x62, 0x6c, 0x3b, 0x6d, 0x73, 0x74, 0x3b, 0x6d, 0x69, 0x6e, 0x3b, 0x6d, 0x74, 0x6e, 0x3b, 0x6d, 0x70,
0x73, 0x3b, 0x65, 0x79, 0x65, 0x6e, 0x67, 0x61, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61, 0x20,
0x79, 0x61, 0x6d, 0x62, 0x6f, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61, 0x20, 0x6d, 0xed, 0x62,
0x61, 0x6c, 0xe9, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x6d, 0x77, 0x61, 0x20, 0x6d, 0xed, 0x73, 0xe1, 0x74,
0x6f, 0x3b, 0x6d, 0x6f, 0x6b, 0x254, 0x6c, 0x254, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x6e, 0xe9, 0x69, 0x3b, 0x6d, 0x6f,
0x6b, 0x254, 0x6c, 0x254, 0x20, 0x79, 0x61, 0x20, 0x6d, 0xed, 0x74, 0xe1, 0x6e, 0x6f, 0x3b, 0x6d, 0x70, 0x254, 0x301, 0x73,
0x254, 0x3b, 0x65, 0x3b, 0x79, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x70, 0x3b, 0x73, 0x6b, 0x3b, 0x70,
0x72, 0x3b, 0x61, 0x6e, 0x3b, 0x74, 0x72, 0x3b, 0x6b, 0x74, 0x3b, 0x70, 0x6e, 0x3b, 0x161, 0x74, 0x3b, 0x73, 0x65, 0x6b,
0x6d, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x70, 0x69, 0x72, 0x6d, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73,
0x3b, 0x61, 0x6e, 0x74, 0x72, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x74, 0x72, 0x65, 0x10d, 0x69, 0x61, 0x64,
0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x6b, 0x65, 0x74, 0x76, 0x69, 0x72, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73,
0x3b, 0x70, 0x65, 0x6e, 0x6b, 0x74, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x161, 0x65, 0x161, 0x74, 0x61, 0x64,
0x69, 0x65, 0x6e, 0x69, 0x73, 0x3b, 0x53, 0x3b, 0x50, 0x3b, 0x41, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x160, 0x3b,
0x43d, 0x435, 0x434, 0x2e, 0x3b, 0x43f, 0x43e, 0x43d, 0x2e, 0x3b, 0x432, 0x442, 0x43e, 0x2e, 0x3b, 0x441, 0x440, 0x435, 0x2e, 0x3b,
0x447, 0x435, 0x442, 0x2e, 0x3b, 0x43f, 0x435, 0x442, 0x2e, 0x3b, 0x441, 0x430, 0x431, 0x2e, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x43b,
0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x43b, 0x43d, 0x438, 0x43a, 0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a,
0x3b, 0x441, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x43e, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x43e,
0x43a, 0x3b, 0x441, 0x430, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x435, 0x434, 0x2e, 0x3b, 0x43f, 0x43e, 0x43d, 0x2e, 0x3b, 0x432,
0x442, 0x2e, 0x3b, 0x441, 0x440, 0x435, 0x2e, 0x3b, 0x447, 0x435, 0x442, 0x2e, 0x3b, 0x43f, 0x435, 0x442, 0x2e, 0x3b, 0x441, 0x430,
0x431, 0x2e, 0x3b, 0x41, 0x6c, 0x61, 0x68, 0x3b, 0x41, 0x6c, 0x61, 0x74, 0x73, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41, 0x6c,
0x61, 0x72, 0x3b, 0x41, 0x6c, 0x61, 0x6b, 0x3b, 0x5a, 0x6f, 0x6d, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x3b, 0x41, 0x6c, 0x61,
0x68, 0x61, 0x64, 0x79, 0x3b, 0x41, 0x6c, 0x61, 0x74, 0x73, 0x69, 0x6e, 0x61, 0x69, 0x6e, 0x79, 0x3b, 0x54, 0x61, 0x6c,
0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x6f, 0x62, 0x69, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x6b, 0x61, 0x6d, 0x69,
0x73, 0x79, 0x3b, 0x5a, 0x6f, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x61, 0x62, 0x6f, 0x74, 0x73, 0x79, 0x3b, 0x41, 0x3b, 0x41,
0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x5a, 0x3b, 0x41, 0x3b, 0x41, 0x68, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x3b, 0x53,
0x65, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x3b, 0x4b, 0x68, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x41,
0x68, 0x61, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x69, 0x6e, 0x3b, 0x53, 0x65, 0x6c, 0x61, 0x73, 0x61, 0x3b, 0x52, 0x61, 0x62,
0x75, 0x3b, 0x4b, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x3b, 0x53, 0x61, 0x62, 0x74,
0x75, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x53, 0x3b, 0x52, 0x3b, 0x4b, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0xd1e, 0xd3e, 0xd2f, 0xd7c,
0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd7e, 0x3b, 0xd1a, 0xd4a, 0xd35, 0xd4d, 0xd35, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd7b, 0x3b, 0xd35,
0xd4d, 0xd2f, 0xd3e, 0xd34, 0xd02, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0x3b, 0xd36, 0xd28, 0xd3f, 0x3b, 0xd1e, 0xd3e, 0xd2f,
0xd31, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd33, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1a,
0xd4a, 0xd35, 0xd4d, 0xd35, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd28, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b,
0xd35, 0xd4d, 0xd2f, 0xd3e, 0xd34, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0xd2f, 0xd3e, 0xd34,
0xd4d, 0x200c, 0xd1a, 0x3b, 0xd36, 0xd28, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1e, 0xd3e, 0x3b, 0xd24, 0xd3f, 0x3b,
0xd1a, 0xd4a, 0x3b, 0xd2c, 0xd41, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0x3b, 0xd35, 0xd46, 0x3b, 0xd36, 0x3b, 0xd1e, 0xd3e, 0xd2f, 0xd31,
0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd24, 0xd3f, 0xd19, 0xd4d, 0xd15, 0xd33, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1a, 0xd4a,
0xd35, 0xd4d, 0xd35, 0xd3e, 0xd34, 0xd4d, 0xd1a, 0x3b, 0xd2c, 0xd41, 0xd27, 0xd28, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd4d,
0xd2f, 0xd3e, 0xd34, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd35, 0xd46, 0xd33, 0xd4d, 0xd33, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c,
0xd1a, 0x3b, 0xd36, 0xd28, 0xd3f, 0xd2f, 0xd3e, 0xd34, 0xd4d, 0x200c, 0xd1a, 0x3b, 0xd1e, 0x3b, 0xd24, 0xd3f, 0x3b, 0xd1a, 0xd4a, 0x3b,
0xd2c, 0xd41, 0x3b, 0xd35, 0xd4d, 0xd2f, 0xd3e, 0x3b, 0xd35, 0xd46, 0x3b, 0xd36, 0x3b, 0x126, 0x61, 0x64, 0x3b, 0x54, 0x6e, 0x65,
0x3b, 0x54, 0x6c, 0x69, 0x3b, 0x45, 0x72, 0x62, 0x3b, 0x126, 0x61, 0x6d, 0x3b, 0x120, 0x69, 0x6d, 0x3b, 0x53, 0x69, 0x62,
0x3b, 0x49, 0x6c, 0x2d, 0x126, 0x61, 0x64, 0x64, 0x3b, 0x49, 0x74, 0x2d, 0x54, 0x6e, 0x65, 0x6a, 0x6e, 0x3b, 0x49, 0x74,
0x2d, 0x54, 0x6c, 0x69, 0x65, 0x74, 0x61, 0x3b, 0x4c, 0x2d, 0x45, 0x72, 0x62, 0x67, 0x127, 0x61, 0x3b, 0x49, 0x6c, 0x2d,
0x126, 0x61, 0x6d, 0x69, 0x73, 0x3b, 0x49, 0x6c, 0x2d, 0x120, 0x69, 0x6d, 0x67, 0x127, 0x61, 0x3b, 0x49, 0x73, 0x2d, 0x53,
0x69, 0x62, 0x74, 0x3b, 0x126, 0x64, 0x3b, 0x54, 0x6e, 0x3b, 0x54, 0x6c, 0x3b, 0x45, 0x72, 0x3b, 0x126, 0x6d, 0x3b, 0x120,
0x6d, 0x3b, 0x53, 0x62, 0x3b, 0x126, 0x64, 0x3b, 0x54, 0x3b, 0x54, 0x6c, 0x3b, 0x45, 0x72, 0x3b, 0x126, 0x6d, 0x3b, 0x120,
0x6d, 0x3b, 0x53, 0x62, 0x3b, 0x54, 0x61, 0x70, 0x3b, 0x48, 0x69, 0x6e, 0x3b, 0x54, 0x16b, 0x3b, 0x41, 0x70, 0x61, 0x3b,
0x50, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x72, 0x3b, 0x48, 0x6f, 0x72, 0x3b, 0x52, 0x101, 0x74, 0x61, 0x70, 0x75, 0x3b, 0x52,
0x101, 0x68, 0x69, 0x6e, 0x61, 0x3b, 0x52, 0x101, 0x74, 0x16b, 0x3b, 0x52, 0x101, 0x61, 0x70, 0x61, 0x3b, 0x52, 0x101, 0x70,
0x61, 0x72, 0x65, 0x3b, 0x52, 0x101, 0x6d, 0x65, 0x72, 0x65, 0x3b, 0x52, 0x101, 0x68, 0x6f, 0x72, 0x6f, 0x69, 0x3b, 0x54,
0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x50, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x930, 0x935, 0x93f, 0x3b, 0x938, 0x94b, 0x92e,
0x3b, 0x92e, 0x902, 0x917, 0x933, 0x3b, 0x92c, 0x941, 0x927, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930,
0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x930, 0x935, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x935, 0x93e, 0x930, 0x3b, 0x92e,
0x902, 0x917, 0x933, 0x935, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b, 0x917, 0x941, 0x930, 0x941, 0x935, 0x93e,
0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x935, 0x93e, 0x930, 0x3b, 0x41d, 0x44f,
0x3b, 0x414, 0x430, 0x3b, 0x41c, 0x44f, 0x3b, 0x41b, 0x445, 0x3b, 0x41f, 0x4af, 0x3b, 0x411, 0x430, 0x3b, 0x411, 0x44f, 0x3b, 0x41d,
0x44f, 0x43c, 0x3b, 0x414, 0x430, 0x432, 0x430, 0x430, 0x3b, 0x41c, 0x44f, 0x433, 0x43c, 0x430, 0x440, 0x3b, 0x41b, 0x445, 0x430, 0x433,
0x432, 0x430, 0x3b, 0x41f, 0x4af, 0x440, 0x44d, 0x432, 0x3b, 0x411, 0x430, 0x430, 0x441, 0x430, 0x43d, 0x3b, 0x411, 0x44f, 0x43c, 0x431,
0x430, 0x3b, 0x43d, 0x44f, 0x43c, 0x3b, 0x434, 0x430, 0x432, 0x430, 0x430, 0x3b, 0x43c, 0x44f, 0x433, 0x43c, 0x430, 0x440, 0x3b, 0x43b,
0x445, 0x430, 0x433, 0x432, 0x430, 0x3b, 0x43f, 0x4af, 0x440, 0x44d, 0x432, 0x3b, 0x431, 0x430, 0x430, 0x441, 0x430, 0x43d, 0x3b, 0x431,
0x44f, 0x43c, 0x431, 0x430, 0x3b, 0x906, 0x907, 0x924, 0x3b, 0x938, 0x94b, 0x92e, 0x3b, 0x92e, 0x919, 0x94d, 0x917, 0x932, 0x3b, 0x92c,
0x941, 0x927, 0x3b, 0x92c, 0x93f, 0x939, 0x93f, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x3b, 0x906, 0x907,
0x924, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e, 0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x919, 0x94d, 0x917, 0x932, 0x92c, 0x93e, 0x930,
0x3b, 0x92c, 0x941, 0x927, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x93f, 0x939, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d,
0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x936, 0x928, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x906, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x3b, 0x92c,
0x941, 0x3b, 0x92c, 0x93f, 0x3b, 0x936, 0x941, 0x3b, 0x936, 0x3b, 0xb30, 0xb2c, 0xb3f, 0x3b, 0xb38, 0xb4b, 0xb2e, 0x3b, 0xb2e, 0xb19,
0xb4d, 0xb17, 0xb33, 0x3b, 0xb2c, 0xb41, 0xb27, 0x3b, 0xb17, 0xb41, 0xb30, 0xb41, 0x3b, 0xb36, 0xb41, 0xb15, 0xb4d, 0xb30, 0x3b, 0xb36,
0xb28, 0xb3f, 0x3b, 0xb30, 0xb2c, 0xb3f, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb38, 0xb4b, 0xb2e, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb2e, 0xb19, 0xb4d,
0xb17, 0xb33, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb2c, 0xb41, 0xb27, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb17, 0xb41, 0xb30, 0xb41, 0xb2c, 0xb3e, 0xb30,
0x3b, 0xb36, 0xb41, 0xb15, 0xb4d, 0xb30, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb36, 0xb28, 0xb3f, 0xb2c, 0xb3e, 0xb30, 0x3b, 0xb30, 0x3b, 0xb38,
0xb4b, 0x3b, 0xb2e, 0x3b, 0xb2c, 0xb41, 0x3b, 0xb17, 0xb41, 0x3b, 0xb36, 0xb41, 0x3b, 0xb36, 0x3b, 0x64a, 0x648, 0x646, 0x6cd, 0x3b,
0x62f, 0x648, 0x646, 0x6cd, 0x3b, 0x62f, 0x631, 0x6d0, 0x646, 0x6cd, 0x3b, 0x685, 0x644, 0x631, 0x646, 0x6cd, 0x3b, 0x67e, 0x64a, 0x646,
0x681, 0x646, 0x6cd, 0x3b, 0x62c, 0x645, 0x639, 0x647, 0x3b, 0x627, 0x648, 0x646, 0x6cd, 0x3b, 0x6cc, 0x6a9, 0x634, 0x646, 0x628, 0x647,
0x3b, 0x62f, 0x648, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x633, 0x647, 0x200c, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x686, 0x647, 0x627, 0x631,
0x634, 0x646, 0x628, 0x647, 0x3b, 0x67e, 0x646, 0x62c, 0x634, 0x646, 0x628, 0x647, 0x3b, 0x62c, 0x645, 0x639, 0x647, 0x3b, 0x634, 0x646,
0x628, 0x647, 0x3b, 0x6cc, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x62c, 0x3b, 0x634, 0x3b, 0x6e, 0x69, 0x65,
0x64, 0x7a, 0x2e, 0x3b, 0x70, 0x6f, 0x6e, 0x2e, 0x3b, 0x77, 0x74, 0x2e, 0x3b, 0x15b, 0x72, 0x2e, 0x3b, 0x63, 0x7a, 0x77,
0x2e, 0x3b, 0x70, 0x74, 0x2e, 0x3b, 0x73, 0x6f, 0x62, 0x2e, 0x3b, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x69, 0x65, 0x6c, 0x61,
0x3b, 0x70, 0x6f, 0x6e, 0x69, 0x65, 0x64, 0x7a, 0x69, 0x61, 0x142, 0x65, 0x6b, 0x3b, 0x77, 0x74, 0x6f, 0x72, 0x65, 0x6b,
0x3b, 0x15b, 0x72, 0x6f, 0x64, 0x61, 0x3b, 0x63, 0x7a, 0x77, 0x61, 0x72, 0x74, 0x65, 0x6b, 0x3b, 0x70, 0x69, 0x105, 0x74,
0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0x57, 0x3b, 0x15a, 0x3b, 0x43, 0x3b,
0x50, 0x3b, 0x53, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x77, 0x3b, 0x15b, 0x3b, 0x63, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x64, 0x6f,
0x6d, 0x2e, 0x3b, 0x73, 0x65, 0x67, 0x2e, 0x3b, 0x74, 0x65, 0x72, 0x2e, 0x3b, 0x71, 0x75, 0x61, 0x2e, 0x3b, 0x71, 0x75,
0x69, 0x2e, 0x3b, 0x73, 0x65, 0x78, 0x2e, 0x3b, 0x73, 0xe1, 0x62, 0x2e, 0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f,
0x3b, 0x73, 0x65, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x74, 0x65, 0x72, 0xe7, 0x61,
0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x71, 0x75, 0x61, 0x72, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b,
0x71, 0x75, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x69, 0x72, 0x61, 0x3b, 0x73, 0x65, 0x78, 0x74, 0x61, 0x2d, 0x66,
0x65, 0x69, 0x72, 0x61, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x51, 0x3b,
0x51, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x73, 0x65, 0x67, 0x75, 0x6e, 0x64,
0x61, 0x3b, 0x74, 0x65, 0x72, 0xe7, 0x61, 0x3b, 0x71, 0x75, 0x61, 0x72, 0x74, 0x61, 0x3b, 0x71, 0x75, 0x69, 0x6e, 0x74,
0x61, 0x3b, 0x73, 0x65, 0x78, 0x74, 0x61, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0xa10, 0xa24, 0x3b, 0xa38, 0xa4b,
0xa2e, 0x3b, 0xa2e, 0xa70, 0xa17, 0xa32, 0x3b, 0xa2c, 0xa41, 0xa71, 0xa27, 0x3b, 0xa35, 0xa40, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71,
0xa15, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa28, 0xa3f, 0xa71, 0xa1a, 0xa30, 0x3b, 0xa10, 0xa24, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa4b, 0xa2e,
0xa35, 0xa3e, 0xa30, 0x3b, 0xa2e, 0xa70, 0xa17, 0xa32, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa2c, 0xa41, 0xa71, 0xa27, 0xa35, 0xa3e, 0xa30, 0x3b,
0xa35, 0xa40, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0xa15, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa38, 0xa3c, 0xa28,
0xa3f, 0xa71, 0xa1a, 0xa30, 0xa35, 0xa3e, 0xa30, 0x3b, 0xa10, 0x3b, 0xa38, 0xa4b, 0x3b, 0xa2e, 0xa70, 0x3b, 0xa2c, 0xa41, 0xa71, 0x3b,
0xa35, 0xa40, 0x3b, 0xa38, 0xa3c, 0xa41, 0xa71, 0x3b, 0xa38, 0xa3c, 0x3b, 0x627, 0x62a, 0x648, 0x627, 0x631, 0x3b, 0x67e, 0x6cc, 0x631,
0x3b, 0x645, 0x646, 0x6af, 0x644, 0x3b, 0x628, 0x64f, 0x62f, 0x6be, 0x3b, 0x62c, 0x645, 0x639, 0x631, 0x627, 0x62a, 0x3b, 0x62c, 0x645,
0x639, 0x6c1, 0x3b, 0x6c1, 0x641, 0x62a, 0x6c1, 0x3b, 0x44, 0x6f, 0x6d, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b,
0x4d, 0x69, 0xe9, 0x3b, 0x4a, 0x75, 0x65, 0x3b, 0x56, 0x69, 0x65, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x44, 0x6f, 0x6d, 0x69,
0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0x69, 0xe9,
0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x4a, 0x75, 0x65, 0x76, 0x65, 0x73, 0x3b, 0x56, 0x69, 0x65, 0x72, 0x6e, 0x65,
0x73, 0x3b, 0x53, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x58, 0x3b, 0x4a, 0x3b, 0x56,
0x3b, 0x53, 0x3b, 0x64, 0x75, 0x3b, 0x67, 0x6c, 0x69, 0x3b, 0x6d, 0x61, 0x3b, 0x6d, 0x65, 0x3b, 0x67, 0x69, 0x65, 0x3b,
0x76, 0x65, 0x3b, 0x73, 0x6f, 0x3b, 0x64, 0x75, 0x6d, 0x65, 0x6e, 0x67, 0x69, 0x61, 0x3b, 0x67, 0x6c, 0x69, 0x6e, 0x64,
0x65, 0x73, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65, 0x73, 0x65, 0x6d, 0x6e, 0x61, 0x3b, 0x67,
0x69, 0x65, 0x76, 0x67, 0x69, 0x61, 0x3b, 0x76, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x64, 0x69, 0x3b, 0x73, 0x6f, 0x6e, 0x64,
0x61, 0x3b, 0x44, 0x3b, 0x47, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x56, 0x3b, 0x53, 0x3b, 0x64, 0x75, 0x6d, 0x2e,
0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d, 0x69, 0x65, 0x2e, 0x3b, 0x6a, 0x6f, 0x69, 0x3b,
0x76, 0x69, 0x6e, 0x2e, 0x3b, 0x73, 0xe2, 0x6d, 0x2e, 0x3b, 0x64, 0x75, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x103, 0x3b, 0x6c,
0x75, 0x6e, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x21b, 0x69, 0x3b, 0x6d, 0x69, 0x65, 0x72, 0x63, 0x75, 0x72, 0x69, 0x3b, 0x6a,
0x6f, 0x69, 0x3b, 0x76, 0x69, 0x6e, 0x65, 0x72, 0x69, 0x3b, 0x73, 0xe2, 0x6d, 0x62, 0x103, 0x74, 0x103, 0x3b, 0x44, 0x75,
0x6d, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x69, 0x65, 0x3b, 0x4a, 0x6f, 0x69, 0x3b, 0x56, 0x69,
0x6e, 0x3b, 0x53, 0xe2, 0x6d, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x61, 0x3b, 0x4d, 0x69, 0x3b, 0x4a, 0x3b, 0x56, 0x3b,
0x53, 0x3b, 0x432, 0x441, 0x3b, 0x43f, 0x43d, 0x3b, 0x432, 0x442, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x442, 0x3b, 0x43f, 0x442, 0x3b,
0x441, 0x431, 0x3b, 0x432, 0x43e, 0x441, 0x43a, 0x440, 0x435, 0x441, 0x435, 0x43d, 0x44c, 0x435, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434,
0x435, 0x43b, 0x44c, 0x43d, 0x438, 0x43a, 0x3b, 0x432, 0x442, 0x43e, 0x440, 0x43d, 0x438, 0x43a, 0x3b, 0x441, 0x440, 0x435, 0x434, 0x430,
0x3b, 0x447, 0x435, 0x442, 0x432, 0x435, 0x440, 0x433, 0x3b, 0x43f, 0x44f, 0x442, 0x43d, 0x438, 0x446, 0x430, 0x3b, 0x441, 0x443, 0x431,
0x431, 0x43e, 0x442, 0x430, 0x3b, 0x412, 0x3b, 0x41f, 0x3b, 0x412, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x421, 0x3b, 0x42,
0x6b, 0x31, 0x3b, 0x42, 0x6b, 0x32, 0x3b, 0x42, 0x6b, 0x33, 0x3b, 0x42, 0x6b, 0x34, 0x3b, 0x42, 0x6b, 0x35, 0x3b, 0x4c,
0xe2, 0x70, 0x3b, 0x4c, 0xe2, 0x79, 0x3b, 0x42, 0x69, 0x6b, 0x75, 0x61, 0x2d, 0xf4, 0x6b, 0x6f, 0x3b, 0x42, 0xef, 0x6b,
0x75, 0x61, 0x2d, 0xfb, 0x73, 0x65, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0x70, 0x74, 0xe2, 0x3b, 0x42, 0xef, 0x6b,
0x75, 0x61, 0x2d, 0x75, 0x73, 0xef, 0xf6, 0x3b, 0x42, 0xef, 0x6b, 0x75, 0x61, 0x2d, 0x6f, 0x6b, 0xfc, 0x3b, 0x4c, 0xe2,
0x70, 0xf4, 0x73, 0xf6, 0x3b, 0x4c, 0xe2, 0x79, 0x65, 0x6e, 0x67, 0x61, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x53,
0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x59, 0x3b, 0x43d, 0x435, 0x434, 0x3b, 0x43f, 0x43e, 0x43d, 0x3b, 0x443, 0x442, 0x43e, 0x3b, 0x441,
0x440, 0x435, 0x3b, 0x447, 0x435, 0x442, 0x3b, 0x43f, 0x435, 0x442, 0x3b, 0x441, 0x443, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x435, 0x459,
0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x435, 0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441,
0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b,
0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x43d, 0x3b, 0x43f, 0x3b, 0x443, 0x3b, 0x441, 0x3b, 0x447, 0x3b, 0x43f, 0x3b, 0x441,
0x3b, 0x43d, 0x435, 0x434, 0x3b, 0x43f, 0x43e, 0x43d, 0x3b, 0x443, 0x442, 0x3b, 0x441, 0x440, 0x3b, 0x447, 0x435, 0x442, 0x3b, 0x43f,
0x435, 0x442, 0x3b, 0x441, 0x443, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x458, 0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434,
0x435, 0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x440, 0x438, 0x458, 0x435, 0x434, 0x430, 0x3b,
0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442,
0x430, 0x3b, 0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f, 0x6e, 0x3b, 0x75, 0x74, 0x3b, 0x73, 0x72, 0x3b, 0x10d, 0x65, 0x74, 0x3b,
0x70, 0x65, 0x74, 0x3b, 0x73, 0x75, 0x62, 0x3b, 0x6e, 0x65, 0x64, 0x6a, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e,
0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73, 0x72, 0x69, 0x6a, 0x65,
0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b, 0x73, 0x75,
0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x65, 0x64, 0x3b, 0x70, 0x6f, 0x6e, 0x3b, 0x75, 0x74, 0x6f, 0x3b, 0x73, 0x72, 0x65,
0x3b, 0x10d, 0x65, 0x74, 0x3b, 0x70, 0x65, 0x74, 0x3b, 0x73, 0x75, 0x62, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61,
0x3b, 0x70, 0x6f, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x6b, 0x3b, 0x75, 0x74, 0x6f, 0x72, 0x61, 0x6b, 0x3b, 0x73,
0x72, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x76, 0x72, 0x74, 0x61, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x61, 0x6b, 0x3b,
0x73, 0x75, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x425, 0x446, 0x431, 0x3b, 0x41a, 0x440, 0x441, 0x3b, 0x414, 0x446, 0x433, 0x3b, 0x4d4,
0x440, 0x442, 0x3b, 0x426, 0x43f, 0x440, 0x3b, 0x41c, 0x440, 0x431, 0x3b, 0x421, 0x431, 0x442, 0x3b, 0x425, 0x443, 0x44b, 0x446, 0x430,
0x443, 0x431, 0x43e, 0x43d, 0x3b, 0x41a, 0x44a, 0x443, 0x44b, 0x440, 0x438, 0x441, 0x4d5, 0x440, 0x3b, 0x414, 0x44b, 0x446, 0x446, 0x4d5,
0x433, 0x3b, 0x4d4, 0x440, 0x442, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x426, 0x44b, 0x43f, 0x43f, 0x4d5, 0x440, 0x4d5, 0x43c, 0x3b,
0x41c, 0x430, 0x439, 0x440, 0x4d5, 0x43c, 0x431, 0x43e, 0x43d, 0x3b, 0x421, 0x430, 0x431, 0x430, 0x442, 0x3b, 0x425, 0x3b, 0x41a, 0x3b,
0x414, 0x3b, 0x4d4, 0x3b, 0x426, 0x3b, 0x41c, 0x3b, 0x421, 0x3b, 0x445, 0x446, 0x431, 0x3b, 0x43a, 0x440, 0x441, 0x3b, 0x434, 0x446,
0x433, 0x3b, 0x4d5, 0x440, 0x442, 0x3b, 0x446, 0x43f, 0x440, 0x3b, 0x43c, 0x440, 0x431, 0x3b, 0x441, 0x431, 0x442, 0x3b, 0x445, 0x443,
0x44b, 0x446, 0x430, 0x443, 0x431, 0x43e, 0x43d, 0x3b, 0x43a, 0x44a, 0x443, 0x44b, 0x440, 0x438, 0x441, 0x4d5, 0x440, 0x3b, 0x434, 0x44b,
0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x4d5, 0x440, 0x442, 0x44b, 0x446, 0x446, 0x4d5, 0x433, 0x3b, 0x446, 0x44b, 0x43f, 0x43f, 0x4d5, 0x440,
0x4d5, 0x43c, 0x3b, 0x43c, 0x430, 0x439, 0x440, 0x4d5, 0x43c, 0x431, 0x43e, 0x43d, 0x3b, 0x441, 0x430, 0x431, 0x430, 0x442, 0x3b, 0x53,
0x76, 0x6f, 0x3b, 0x4d, 0x75, 0x76, 0x3b, 0x43, 0x68, 0x70, 0x3b, 0x43, 0x68, 0x74, 0x3b, 0x43, 0x68, 0x6e, 0x3b, 0x43,
0x68, 0x73, 0x3b, 0x4d, 0x75, 0x67, 0x3b, 0x53, 0x76, 0x6f, 0x6e, 0x64, 0x6f, 0x3b, 0x4d, 0x75, 0x76, 0x68, 0x75, 0x72,
0x6f, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x43, 0x68,
0x69, 0x6e, 0x61, 0x3b, 0x43, 0x68, 0x69, 0x73, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x75, 0x67, 0x6f, 0x76, 0x65, 0x72,
0x61, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x4d, 0x3b, 0x622, 0x686, 0x631, 0x3b,
0x633, 0x648, 0x645, 0x631, 0x3b, 0x627, 0x6b1, 0x627, 0x631, 0x648, 0x3b, 0x627, 0x631, 0x628, 0x639, 0x3b, 0x62e, 0x645, 0x64a, 0x633,
0x3b, 0x62c, 0x645, 0x639, 0x648, 0x3b, 0x687, 0x646, 0x687, 0x631, 0x3b, 0x622, 0x686, 0x631, 0x3b, 0x633, 0x648, 0x3b, 0x627, 0x6b1,
0x627, 0x631, 0x648, 0x3b, 0x627, 0x631, 0x628, 0x639, 0x3b, 0x62e, 0x645, 0x3b, 0x62c, 0x645, 0x639, 0x648, 0x3b, 0x687, 0x646, 0x687,
0x631, 0x3b, 0xd89, 0xdbb, 0xdd2, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdb3, 0xdd4, 0xdaf, 0xdcf, 0x3b, 0xd85, 0xd9f, 0xdc4, 0x3b, 0xdb6, 0xdaf,
0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0xdc4, 0xdc3, 0xdca, 0x3b, 0xdc3, 0xdd2, 0xd9a, 0xdd4, 0x3b, 0xdc3, 0xdd9, 0xdb1,
0x3b, 0xd89, 0xdbb, 0xdd2, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdb3, 0xdd4, 0xdaf, 0xdcf, 0x3b, 0xd85, 0xd9f, 0xdc4, 0xdbb, 0xdd4, 0xdc0, 0xdcf,
0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdaf, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0xdc4, 0xdc3, 0xdca, 0xdb4, 0xdad, 0xdd2, 0xdb1,
0xdca, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdd2, 0xd9a, 0xdd4, 0xdbb, 0xdcf, 0xdaf, 0xdcf, 0x3b, 0xdc3, 0xdd9, 0xdb1, 0xdc3, 0xdd4, 0xdbb, 0xdcf,
0xdaf, 0xdcf, 0x3b, 0xd89, 0x3b, 0xdc3, 0x3b, 0xd85, 0x3b, 0xdb6, 0x3b, 0xdb6, 0xdca, 0x200d, 0xdbb, 0x3b, 0xdc3, 0xdd2, 0x3b, 0xdc3,
0xdd9, 0x3b, 0x6e, 0x65, 0x3b, 0x70, 0x6f, 0x3b, 0x75, 0x74, 0x3b, 0x73, 0x74, 0x3b, 0x161, 0x74, 0x3b, 0x70, 0x69, 0x3b,
0x73, 0x6f, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x13e, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x64, 0x65, 0x6c, 0x6f, 0x6b, 0x3b, 0x75,
0x74, 0x6f, 0x72, 0x6f, 0x6b, 0x3b, 0x73, 0x74, 0x72, 0x65, 0x64, 0x61, 0x3b, 0x161, 0x74, 0x76, 0x72, 0x74, 0x6f, 0x6b,
0x3b, 0x70, 0x69, 0x61, 0x74, 0x6f, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x75,
0x3b, 0x73, 0x3b, 0x161, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x6e, 0x65, 0x64, 0x2e, 0x3b, 0x70, 0x6f, 0x6e, 0x2e, 0x3b, 0x74,
0x6f, 0x72, 0x2e, 0x3b, 0x73, 0x72, 0x65, 0x2e, 0x3b, 0x10d, 0x65, 0x74, 0x2e, 0x3b, 0x70, 0x65, 0x74, 0x2e, 0x3b, 0x73,
0x6f, 0x62, 0x2e, 0x3b, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a, 0x61, 0x3b, 0x70, 0x6f, 0x6e, 0x65, 0x64, 0x65, 0x6c, 0x6a,
0x65, 0x6b, 0x3b, 0x74, 0x6f, 0x72, 0x65, 0x6b, 0x3b, 0x73, 0x72, 0x65, 0x64, 0x61, 0x3b, 0x10d, 0x65, 0x74, 0x72, 0x74,
0x65, 0x6b, 0x3b, 0x70, 0x65, 0x74, 0x65, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b,
0x74, 0x3b, 0x73, 0x3b, 0x10d, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x41, 0x78, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x3b, 0x54, 0x6c,
0x64, 0x6f, 0x3b, 0x41, 0x72, 0x62, 0x63, 0x3b, 0x4b, 0x68, 0x6d, 0x73, 0x3b, 0x4a, 0x6d, 0x63, 0x3b, 0x53, 0x62, 0x74,
0x69, 0x3b, 0x41, 0x78, 0x61, 0x64, 0x3b, 0x49, 0x73, 0x6e, 0x69, 0x69, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x61, 0x61, 0x64,
0x6f, 0x3b, 0x41, 0x72, 0x62, 0x61, 0x63, 0x6f, 0x3b, 0x4b, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x3b, 0x4a, 0x69, 0x6d,
0x63, 0x6f, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x69, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x4b, 0x68, 0x3b,
0x4a, 0x3b, 0x53, 0x3b, 0x64, 0x6f, 0x6d, 0x2e, 0x3b, 0x6c, 0x75, 0x6e, 0x2e, 0x3b, 0x6d, 0x61, 0x72, 0x2e, 0x3b, 0x6d,
0x69, 0xe9, 0x2e, 0x3b, 0x6a, 0x75, 0x65, 0x2e, 0x3b, 0x76, 0x69, 0x65, 0x2e, 0x3b, 0x73, 0xe1, 0x62, 0x2e, 0x3b, 0x64,
0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x6c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b,
0x6d, 0x69, 0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x6a, 0x75, 0x65, 0x76, 0x65, 0x73, 0x3b, 0x76, 0x69, 0x65,
0x72, 0x6e, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x69,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d,
0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x73, 0xf6, 0x6e, 0x3b, 0x6d, 0xe5, 0x6e, 0x3b,
0x74, 0x69, 0x73, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0xf6, 0x72,
0x3b, 0x73, 0xf6, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0xe5, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x69, 0x73, 0x64, 0x61,
0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66, 0x72, 0x65,
0x64, 0x61, 0x67, 0x3b, 0x6c, 0xf6, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x42f, 0x448, 0x431, 0x3b, 0x414, 0x448, 0x431, 0x3b, 0x421,
0x448, 0x431, 0x3b, 0x427, 0x448, 0x431, 0x3b, 0x41f, 0x448, 0x431, 0x3b, 0x4b6, 0x43c, 0x44a, 0x3b, 0x428, 0x43d, 0x431, 0x3b, 0x42f,
0x43a, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x414, 0x443, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x421, 0x435, 0x448, 0x430, 0x43d,
0x431, 0x435, 0x3b, 0x427, 0x43e, 0x440, 0x448, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x41f, 0x430, 0x43d, 0x4b7, 0x448, 0x430, 0x43d, 0x431,
0x435, 0x3b, 0x4b6, 0x443, 0x43c, 0x44a, 0x430, 0x3b, 0x428, 0x430, 0x43d, 0x431, 0x435, 0x3b, 0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b,
0x427, 0x3b, 0x41f, 0x3b, 0x4b6, 0x3b, 0x428, 0x3b, 0xb9e, 0xbbe, 0xbaf, 0xbbf, 0x2e, 0x3b, 0xba4, 0xbbf, 0xb99, 0xbcd, 0x2e, 0x3b,
0xb9a, 0xbc6, 0xbb5, 0xbcd, 0x2e, 0x3b, 0xbaa, 0xbc1, 0xba4, 0x2e, 0x3b, 0xbb5, 0xbbf, 0xbaf, 0xbbe, 0x2e, 0x3b, 0xbb5, 0xbc6, 0xbb3,
0xbcd, 0x2e, 0x3b, 0xb9a, 0xba9, 0xbbf, 0x3b, 0xb9e, 0xbbe, 0xbaf, 0xbbf, 0xbb1, 0xbc1, 0x3b, 0xba4, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbb3,
0xbcd, 0x3b, 0xb9a, 0xbc6, 0xbb5, 0xbcd, 0xbb5, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0xbaa, 0xbc1, 0xba4, 0xba9, 0xbcd, 0x3b, 0xbb5, 0xbbf, 0xbaf,
0xbbe, 0xbb4, 0xba9, 0xbcd, 0x3b, 0xbb5, 0xbc6, 0xbb3, 0xbcd, 0xbb3, 0xbbf, 0x3b, 0xb9a, 0xba9, 0xbbf, 0x3b, 0xb9e, 0xbbe, 0x3b, 0xba4,
0xbbf, 0x3b, 0xb9a, 0xbc6, 0x3b, 0xbaa, 0xbc1, 0x3b, 0xbb5, 0xbbf, 0x3b, 0xbb5, 0xbc6, 0x3b, 0xb9a, 0x3b, 0x44f, 0x43a, 0x448, 0x2e,
0x3b, 0x434, 0x4af, 0x448, 0x2e, 0x3b, 0x441, 0x438, 0x448, 0x2e, 0x3b, 0x447, 0x4d9, 0x440, 0x2e, 0x3b, 0x43f, 0x4d9, 0x43d, 0x497,
0x2e, 0x3b, 0x497, 0x43e, 0x43c, 0x2e, 0x3b, 0x448, 0x438, 0x43c, 0x2e, 0x3b, 0x44f, 0x43a, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b,
0x434, 0x4af, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x441, 0x438, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x447, 0x4d9, 0x440, 0x448,
0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x43f, 0x4d9, 0x43d, 0x497, 0x435, 0x448, 0x4d9, 0x43c, 0x431, 0x435, 0x3b, 0x497, 0x43e, 0x43c, 0x433,
0x430, 0x3b, 0x448, 0x438, 0x43c, 0x431, 0x4d9, 0x3b, 0x42f, 0x3b, 0x414, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x496, 0x3b,
0x428, 0x3b, 0xc06, 0xc26, 0xc3f, 0x3b, 0xc38, 0xc4b, 0xc2e, 0x3b, 0xc2e, 0xc02, 0xc17, 0xc33, 0x3b, 0xc2c, 0xc41, 0xc27, 0x3b, 0xc17,
0xc41, 0xc30, 0xc41, 0x3b, 0xc36, 0xc41, 0xc15, 0xc4d, 0xc30, 0x3b, 0xc36, 0xc28, 0xc3f, 0x3b, 0xc06, 0xc26, 0xc3f, 0xc35, 0xc3e, 0xc30,
0xc02, 0x3b, 0xc38, 0xc4b, 0xc2e, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc2e, 0xc02, 0xc17, 0xc33, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc2c,
0xc41, 0xc27, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc17, 0xc41, 0xc30, 0xc41, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc36, 0xc41, 0xc15, 0xc4d,
0xc30, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc36, 0xc28, 0xc3f, 0xc35, 0xc3e, 0xc30, 0xc02, 0x3b, 0xc06, 0x3b, 0xc38, 0xc4b, 0x3b, 0xc2e,
0x3b, 0xc2c, 0xc41, 0x3b, 0xc17, 0xc41, 0x3b, 0xc36, 0xc41, 0x3b, 0xc36, 0x3b, 0xe2d, 0xe32, 0x2e, 0x3b, 0xe08, 0x2e, 0x3b, 0xe2d,
0x2e, 0x3b, 0xe1e, 0x2e, 0x3b, 0xe1e, 0xe24, 0x2e, 0x3b, 0xe28, 0x2e, 0x3b, 0xe2a, 0x2e, 0x3b, 0xe27, 0xe31, 0xe19, 0xe2d, 0xe32,
0xe17, 0xe34, 0xe15, 0xe22, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe08, 0xe31, 0xe19, 0xe17, 0xe23, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe2d,
0xe31, 0xe07, 0xe04, 0xe32, 0xe23, 0x3b, 0xe27, 0xe31, 0xe19, 0xe1e, 0xe38, 0xe18, 0x3b, 0xe27, 0xe31, 0xe19, 0xe1e, 0xe24, 0xe2b, 0xe31,
0xe2a, 0xe1a, 0xe14, 0xe35, 0x3b, 0xe27, 0xe31, 0xe19, 0xe28, 0xe38, 0xe01, 0xe23, 0xe4c, 0x3b, 0xe27, 0xe31, 0xe19, 0xe40, 0xe2a, 0xe32,
0xe23, 0xe4c, 0x3b, 0xe2d, 0xe32, 0x3b, 0xe08, 0x3b, 0xe2d, 0x3b, 0xe1e, 0x3b, 0xe1e, 0xe24, 0x3b, 0xe28, 0x3b, 0xe2a, 0x3b, 0xf49,
0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58, 0xf62, 0xf0b, 0x3b,
0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf55, 0xf74, 0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66,
0xf0b, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf49, 0xf72, 0xf0b, 0xf58, 0xf0b, 0x3b,
0xf42, 0xf5f, 0xf60, 0xf0b, 0xf5f, 0xfb3, 0xf0b, 0xf56, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf58, 0xf72, 0xf42, 0xf0b, 0xf51, 0xf58,
0xf62, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf63, 0xfb7, 0xf42, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf55, 0xf74,
0xf62, 0xf0b, 0xf56, 0xf74, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60, 0xf0b, 0xf54, 0xf0b, 0xf66, 0xf44, 0xf66, 0xf0b, 0x3b, 0xf42, 0xf5f, 0xf60,
0xf0b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0xf0b, 0xf54, 0xf0b, 0x3b, 0xf49, 0xf72, 0x3b, 0xf5f, 0xfb3, 0x3b, 0xf58, 0xf72, 0xf42, 0x3b, 0xf63,
0xfb7, 0xf42, 0x3b, 0xf55, 0xf74, 0xf62, 0x3b, 0xf66, 0xf44, 0xf66, 0x3b, 0xf66, 0xfa4, 0xf7a, 0xf53, 0x3b, 0x1230, 0x1295, 0x3b, 0x1230,
0x1291, 0x3b, 0x1230, 0x1209, 0x3b, 0x1228, 0x1261, 0x3b, 0x1213, 0x1219, 0x3b, 0x12d3, 0x122d, 0x3b, 0x1240, 0x12f3, 0x3b, 0x1230, 0x1295, 0x1260,
0x1275, 0x3b, 0x1230, 0x1291, 0x12ed, 0x3b, 0x1220, 0x1209, 0x1235, 0x3b, 0x1228, 0x1261, 0x12d5, 0x3b, 0x1283, 0x1219, 0x1235, 0x3b, 0x12d3, 0x122d,
0x1262, 0x3b, 0x1240, 0x12f3, 0x121d, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1220, 0x3b, 0x1228, 0x3b, 0x1213, 0x3b, 0x12d3, 0x3b, 0x1240, 0x3b,
0x1230, 0x3b, 0x1230, 0x3b, 0x1230, 0x3b, 0x1228, 0x3b, 0x1213, 0x3b, 0x12d3, 0x3b, 0x1240, 0x3b, 0x53, 0x101, 0x70, 0x3b, 0x4d, 0x14d,
0x6e, 0x3b, 0x54, 0x16b, 0x73, 0x3b, 0x50, 0x75, 0x6c, 0x3b, 0x54, 0x75, 0x2bb, 0x61, 0x3b, 0x46, 0x61, 0x6c, 0x3b, 0x54,
0x6f, 0x6b, 0x3b, 0x53, 0x101, 0x70, 0x61, 0x74, 0x65, 0x3b, 0x4d, 0x14d, 0x6e, 0x69, 0x74, 0x65, 0x3b, 0x54, 0x16b, 0x73,
0x69, 0x74, 0x65, 0x3b, 0x50, 0x75, 0x6c, 0x65, 0x6c, 0x75, 0x6c, 0x75, 0x3b, 0x54, 0x75, 0x2bb, 0x61, 0x70, 0x75, 0x6c,
0x65, 0x6c, 0x75, 0x6c, 0x75, 0x3b, 0x46, 0x61, 0x6c, 0x61, 0x69, 0x74, 0x65, 0x3b, 0x54, 0x6f, 0x6b, 0x6f, 0x6e, 0x61,
0x6b, 0x69, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x50, 0x3b, 0x54, 0x3b, 0x46, 0x3b, 0x54, 0x3b, 0x50, 0x61, 0x7a,
0x3b, 0x50, 0x7a, 0x74, 0x3b, 0x53, 0x61, 0x6c, 0x3b, 0xc7, 0x61, 0x72, 0x3b, 0x50, 0x65, 0x72, 0x3b, 0x43, 0x75, 0x6d,
0x3b, 0x43, 0x6d, 0x74, 0x3b, 0x50, 0x61, 0x7a, 0x61, 0x72, 0x3b, 0x50, 0x61, 0x7a, 0x61, 0x72, 0x74, 0x65, 0x73, 0x69,
0x3b, 0x53, 0x61, 0x6c, 0x131, 0x3b, 0xc7, 0x61, 0x72, 0x15f, 0x61, 0x6d, 0x62, 0x61, 0x3b, 0x50, 0x65, 0x72, 0x15f, 0x65,
0x6d, 0x62, 0x65, 0x3b, 0x43, 0x75, 0x6d, 0x61, 0x3b, 0x43, 0x75, 0x6d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x69, 0x3b, 0x50,
0x3b, 0x50, 0x3b, 0x53, 0x3b, 0xc7, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0xdd, 0x65, 0x6b, 0x3b, 0x44, 0x75, 0x15f,
0x3b, 0x53, 0x69, 0x15f, 0x3b, 0xc7, 0x61, 0x72, 0x3b, 0x50, 0x65, 0x6e, 0x3b, 0x41, 0x6e, 0x6e, 0x3b, 0x15e, 0x65, 0x6e,
0x3b, 0xdd, 0x65, 0x6b, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x44, 0x75, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x53, 0x69,
0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0xc7, 0x61, 0x72, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x50, 0x65, 0x6e, 0x15f, 0x65,
0x6e, 0x62, 0x65, 0x3b, 0x41, 0x6e, 0x6e, 0x61, 0x3b, 0x15e, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0xdd, 0x3b, 0x44, 0x3b, 0x53,
0x3b, 0xc7, 0x3b, 0x50, 0x3b, 0x41, 0x3b, 0x15e, 0x3b, 0xfd, 0x65, 0x6b, 0x3b, 0x64, 0x75, 0x15f, 0x3b, 0x73, 0x69, 0x15f,
0x3b, 0xe7, 0x61, 0x72, 0x3b, 0x70, 0x65, 0x6e, 0x3b, 0x61, 0x6e, 0x6e, 0x3b, 0x15f, 0x65, 0x6e, 0x3b, 0xfd, 0x65, 0x6b,
0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x64, 0x75, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x73, 0x69, 0x15f, 0x65, 0x6e, 0x62,
0x65, 0x3b, 0xe7, 0x61, 0x72, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x70, 0x65, 0x6e, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b,
0x61, 0x6e, 0x6e, 0x61, 0x3b, 0x15f, 0x65, 0x6e, 0x62, 0x65, 0x3b, 0x64a, 0x6d5, 0x3b, 0x62f, 0x6c8, 0x3b, 0x633, 0x6d5, 0x3b,
0x686, 0x627, 0x3b, 0x67e, 0x6d5, 0x3b, 0x62c, 0x6c8, 0x3b, 0x634, 0x6d5, 0x3b, 0x64a, 0x6d5, 0x643, 0x634, 0x6d5, 0x646, 0x628, 0x6d5,
0x3b, 0x62f, 0x6c8, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x633, 0x6d5, 0x64a, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x686, 0x627,
0x631, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x67e, 0x6d5, 0x64a, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x62c, 0x6c8, 0x645, 0x6d5,
0x3b, 0x634, 0x6d5, 0x646, 0x628, 0x6d5, 0x3b, 0x64a, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x62c, 0x3b, 0x634,
0x3b, 0x43d, 0x435, 0x434, 0x456, 0x43b, 0x44f, 0x3b, 0x43f, 0x43e, 0x43d, 0x435, 0x434, 0x456, 0x43b, 0x43e, 0x43a, 0x3b, 0x432, 0x456,
0x432, 0x442, 0x43e, 0x440, 0x43e, 0x43a, 0x3b, 0x441, 0x435, 0x440, 0x435, 0x434, 0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x435, 0x440,
0x3b, 0x43f, 0x2bc, 0x44f, 0x442, 0x43d, 0x438, 0x446, 0x44f, 0x3b, 0x441, 0x443, 0x431, 0x43e, 0x442, 0x430, 0x3b, 0x41d, 0x3b, 0x41f,
0x3b, 0x412, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x421, 0x3b, 0x627, 0x62a, 0x648, 0x627, 0x631, 0x3b, 0x67e, 0x6cc, 0x631,
0x3b, 0x645, 0x646, 0x6af, 0x644, 0x3b, 0x628, 0x62f, 0x6be, 0x3b, 0x62c, 0x645, 0x639, 0x631, 0x627, 0x62a, 0x3b, 0x62c, 0x645, 0x639,
0x6c1, 0x3b, 0x6c1, 0x641, 0x62a, 0x6c1, 0x3b, 0x59, 0x61, 0x6b, 0x3b, 0x44, 0x75, 0x73, 0x68, 0x3b, 0x53, 0x65, 0x73, 0x68,
0x3b, 0x43, 0x68, 0x6f, 0x72, 0x3b, 0x50, 0x61, 0x79, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x53, 0x68, 0x61, 0x6e, 0x3b, 0x79,
0x61, 0x6b, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x64, 0x75, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x73, 0x65,
0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x63, 0x68, 0x6f, 0x72, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x70, 0x61,
0x79, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x73, 0x68, 0x61, 0x6e, 0x62, 0x61, 0x3b,
0x59, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x43, 0x3b, 0x50, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x6cc, 0x2e, 0x3b, 0x62f, 0x2e, 0x3b,
0x633, 0x2e, 0x3b, 0x686, 0x2e, 0x3b, 0x67e, 0x2e, 0x3b, 0x62c, 0x2e, 0x3b, 0x634, 0x2e, 0x3b, 0x44f, 0x43a, 0x448, 0x3b, 0x434,
0x443, 0x448, 0x3b, 0x441, 0x435, 0x448, 0x3b, 0x447, 0x43e, 0x440, 0x3b, 0x43f, 0x430, 0x439, 0x3b, 0x436, 0x443, 0x43c, 0x3b, 0x448,
0x430, 0x43d, 0x3b, 0x44f, 0x43a, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x434, 0x443, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x441,
0x435, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x447, 0x43e, 0x440, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x43f, 0x430, 0x439, 0x448,
0x430, 0x43d, 0x431, 0x430, 0x3b, 0x436, 0x443, 0x43c, 0x430, 0x3b, 0x448, 0x430, 0x43d, 0x431, 0x430, 0x3b, 0x42f, 0x3b, 0x414, 0x3b,
0x421, 0x3b, 0x427, 0x3b, 0x41f, 0x3b, 0x416, 0x3b, 0x428, 0x3b, 0x43, 0x4e, 0x3b, 0x54, 0x68, 0x20, 0x32, 0x3b, 0x54, 0x68,
0x20, 0x33, 0x3b, 0x54, 0x68, 0x20, 0x34, 0x3b, 0x54, 0x68, 0x20, 0x35, 0x3b, 0x54, 0x68, 0x20, 0x36, 0x3b, 0x54, 0x68,
0x20, 0x37, 0x3b, 0x43, 0x68, 0x1ee7, 0x20, 0x4e, 0x68, 0x1ead, 0x74, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x48, 0x61, 0x69, 0x3b,
0x54, 0x68, 0x1ee9, 0x20, 0x42, 0x61, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x54, 0x1b0, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x4e, 0x103,
0x6d, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x53, 0xe1, 0x75, 0x3b, 0x54, 0x68, 0x1ee9, 0x20, 0x42, 0x1ea3, 0x79, 0x3b, 0x43, 0x4e,
0x3b, 0x54, 0x32, 0x3b, 0x54, 0x33, 0x3b, 0x54, 0x34, 0x3b, 0x54, 0x35, 0x3b, 0x54, 0x36, 0x3b, 0x54, 0x37, 0x3b, 0x53,
0x75, 0x3b, 0x4d, 0x75, 0x3b, 0x54, 0x75, 0x3b, 0x56, 0x65, 0x3b, 0x44, 0xf6, 0x3b, 0x46, 0x72, 0x3b, 0x5a, 0xe4, 0x3b,
0x73, 0x75, 0x64, 0x65, 0x6c, 0x3b, 0x6d, 0x75, 0x64, 0x65, 0x6c, 0x3b, 0x74, 0x75, 0x64, 0x65, 0x6c, 0x3b, 0x76, 0x65,
0x64, 0x65, 0x6c, 0x3b, 0x64, 0xf6, 0x64, 0x65, 0x6c, 0x3b, 0x66, 0x72, 0x69, 0x64, 0x65, 0x6c, 0x3b, 0x7a, 0xe4, 0x64,
0x65, 0x6c, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x54, 0x3b, 0x56, 0x3b, 0x44, 0x3b, 0x46, 0x3b, 0x5a, 0x3b, 0x73, 0x75, 0x2e,
0x3b, 0x6d, 0x75, 0x2e, 0x3b, 0x74, 0x75, 0x2e, 0x3b, 0x76, 0x65, 0x2e, 0x3b, 0x64, 0xf6, 0x2e, 0x3b, 0x66, 0x72, 0x2e,
0x3b, 0x7a, 0xe4, 0x2e, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x4d, 0x65,
0x72, 0x3b, 0x49, 0x61, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x53,
0x75, 0x6c, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4d, 0x61,
0x77, 0x72, 0x74, 0x68, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x65, 0x72, 0x3b, 0x44, 0x79,
0x64, 0x64, 0x20, 0x49, 0x61, 0x75, 0x3b, 0x44, 0x79, 0x64, 0x64, 0x20, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x44,
0x79, 0x64, 0x64, 0x20, 0x53, 0x61, 0x64, 0x77, 0x72, 0x6e, 0x3b, 0x53, 0x3b, 0x4c, 0x6c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b,
0x49, 0x3b, 0x47, 0x3b, 0x53, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x6c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x77, 0x3b, 0x4d,
0x65, 0x72, 0x3b, 0x49, 0x61, 0x75, 0x3b, 0x47, 0x77, 0x65, 0x6e, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x44, 0x69, 0x62, 0x3b,
0x41, 0x6c, 0x74, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0xc0, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x78, 0x3b, 0xc0, 0x6a, 0x6a, 0x3b,
0x41, 0x73, 0x65, 0x3b, 0x44, 0x69, 0x62, 0xe9, 0x65, 0x72, 0x3b, 0x41, 0x6c, 0x74, 0x69, 0x6e, 0x65, 0x3b, 0x54, 0x61,
0x6c, 0x61, 0x61, 0x74, 0x61, 0x3b, 0xc0, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x78, 0x61, 0x6d, 0x69, 0x73,
0x3b, 0xc0, 0x6a, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x65, 0x65, 0x72, 0x3b, 0x43, 0x61, 0x77, 0x3b, 0x4d, 0x76,
0x75, 0x3b, 0x42, 0x69, 0x6e, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x48, 0x6c, 0x61, 0x3b, 0x4d, 0x67,
0x71, 0x3b, 0x43, 0x61, 0x77, 0x65, 0x3b, 0x4d, 0x76, 0x75, 0x6c, 0x6f, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x62, 0x69,
0x6e, 0x69, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69,
0x6e, 0x65, 0x3b, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65,
0x6c, 0x6f, 0x3b, 0x5d6, 0x5d5, 0x5e0, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5de, 0x5d0, 0x5b8, 0x5e0, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5d3, 0x5d9,
0x5e0, 0x5e1, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5de, 0x5d9, 0x5d8, 0x5d5, 0x5d5, 0x5d0, 0x5da, 0x3b, 0x5d3, 0x5d0, 0x5e0, 0x5e2, 0x5e8, 0x5e9,
0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5e4, 0x5bf, 0x5e8, 0x5f2, 0x5b7, 0x5d8, 0x5d9, 0x5e7, 0x3b, 0x5e9, 0x5d1, 0x5ea, 0x3b, 0xc0, 0xec, 0x6b,
0x3b, 0x41, 0x6a, 0x3b, 0xcc, 0x73, 0x1eb9, 0x301, 0x67, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301,
0x62, 0x3b, 0x1eb8, 0x74, 0x3b, 0xc0, 0x62, 0xe1, 0x6d, 0x3b, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x41, 0x6a, 0xe9, 0x3b, 0xcc,
0x73, 0x1eb9, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x62, 0x1ecd,
0x3b, 0x1eb8, 0x74, 0xec, 0x3b, 0xc0, 0x62, 0xe1, 0x6d, 0x1eb9, 0x301, 0x74, 0x61, 0x3b, 0xc0, 0x3b, 0x41, 0x3b, 0xcc, 0x3b,
0x1ecc, 0x3b, 0x1ecc, 0x3b, 0x1eb8, 0x3b, 0xc0, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x1ecc, 0x6a,
0x1ecd, 0x301, 0x20, 0x41, 0x6a, 0xe9, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xcc, 0x73, 0x1eb9, 0x301, 0x67, 0x75, 0x6e, 0x3b,
0x1ecc, 0x6a, 0x1ecd, 0x301, 0x72, 0xfa, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x62, 0x1ecd, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0x1eb8,
0x74, 0xec, 0x3b, 0x1ecc, 0x6a, 0x1ecd, 0x301, 0x20, 0xc0, 0x62, 0xe1, 0x6d, 0x1eb9, 0x301, 0x74, 0x61, 0x3b, 0xc0, 0xec, 0x6b,
0x3b, 0x41, 0x6a, 0x3b, 0xcc, 0x73, 0x25b, 0x301, 0x67, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x72, 0x3b, 0x186, 0x6a, 0x254, 0x301,
0x62, 0x3b, 0x190, 0x74, 0x3b, 0xc0, 0x62, 0xe1, 0x6d, 0x3b, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x41, 0x6a, 0xe9, 0x3b, 0xcc,
0x73, 0x25b, 0x301, 0x67, 0x75, 0x6e, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x72, 0xfa, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x62, 0x254,
0x3b, 0x190, 0x74, 0xec, 0x3b, 0xc0, 0x62, 0xe1, 0x6d, 0x25b, 0x301, 0x74, 0x61, 0x3b, 0xc0, 0x3b, 0x41, 0x3b, 0xcc, 0x3b,
0x186, 0x3b, 0x186, 0x3b, 0x190, 0x3b, 0xc0, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0xc0, 0xec, 0x6b, 0xfa, 0x3b, 0x186, 0x6a,
0x254, 0x301, 0x20, 0x41, 0x6a, 0xe9, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0xcc, 0x73, 0x25b, 0x301, 0x67, 0x75, 0x6e, 0x3b,
0x186, 0x6a, 0x254, 0x301, 0x72, 0xfa, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x62, 0x254, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0x190,
0x74, 0xec, 0x3b, 0x186, 0x6a, 0x254, 0x301, 0x20, 0xc0, 0x62, 0xe1, 0x6d, 0x25b, 0x301, 0x74, 0x61, 0x3b, 0x53, 0x6f, 0x6e,
0x3b, 0x4d, 0x73, 0x6f, 0x3b, 0x42, 0x69, 0x6c, 0x3b, 0x54, 0x68, 0x61, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x48, 0x6c, 0x61,
0x3b, 0x4d, 0x67, 0x71, 0x3b, 0x49, 0x53, 0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x55, 0x4d, 0x73, 0x6f, 0x6d, 0x62, 0x75, 0x6c,
0x75, 0x6b, 0x6f, 0x3b, 0x55, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x55, 0x4c, 0x77, 0x65, 0x73,
0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x55, 0x4c, 0x77, 0x65, 0x73, 0x69, 0x6e, 0x65, 0x3b, 0x55, 0x4c, 0x77,
0x65, 0x73, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x55, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x53,
0x3b, 0x4d, 0x3b, 0x42, 0x3b, 0x54, 0x3b, 0x53, 0x3b, 0x48, 0x3b, 0x4d, 0x3b, 0x73, 0xf8, 0x6e, 0x3b, 0x6d, 0xe5, 0x6e,
0x3b, 0x74, 0x79, 0x73, 0x3b, 0x6f, 0x6e, 0x73, 0x3b, 0x74, 0x6f, 0x72, 0x3b, 0x66, 0x72, 0x65, 0x3b, 0x6c, 0x61, 0x75,
0x3b, 0x73, 0xf8, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x6d, 0xe5, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x79, 0x73, 0x64, 0x61,
0x67, 0x3b, 0x6f, 0x6e, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x66, 0x72, 0x65,
0x64, 0x61, 0x67, 0x3b, 0x6c, 0x61, 0x75, 0x72, 0x64, 0x61, 0x67, 0x3b, 0x73, 0xf8, 0x2e, 0x3b, 0x6d, 0xe5, 0x2e, 0x3b,
0x74, 0x79, 0x2e, 0x3b, 0x6f, 0x6e, 0x2e, 0x3b, 0x74, 0x6f, 0x2e, 0x3b, 0x66, 0x72, 0x2e, 0x3b, 0x6c, 0x61, 0x2e, 0x3b,
0x43d, 0x435, 0x434, 0x3b, 0x43f, 0x43e, 0x43d, 0x3b, 0x443, 0x442, 0x43e, 0x3b, 0x441, 0x440, 0x438, 0x3b, 0x447, 0x435, 0x442, 0x3b,
0x43f, 0x435, 0x442, 0x3b, 0x441, 0x443, 0x431, 0x3b, 0x43d, 0x435, 0x434, 0x458, 0x435, 0x459, 0x430, 0x3b, 0x43f, 0x43e, 0x43d, 0x435,
0x434, 0x458, 0x435, 0x459, 0x430, 0x43a, 0x3b, 0x443, 0x442, 0x43e, 0x440, 0x430, 0x43a, 0x3b, 0x441, 0x440, 0x438, 0x458, 0x435, 0x434,
0x430, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x440, 0x442, 0x430, 0x43a, 0x3b, 0x43f, 0x435, 0x442, 0x430, 0x43a, 0x3b, 0x441, 0x443, 0x431,
0x43e, 0x442, 0x430, 0x3b, 0x4a, 0x65, 0x64, 0x3b, 0x4a, 0x65, 0x6c, 0x3b, 0x4a, 0x65, 0x6d, 0x3b, 0x4a, 0x65, 0x72, 0x63,
0x3b, 0x4a, 0x65, 0x72, 0x64, 0x3b, 0x4a, 0x65, 0x68, 0x3b, 0x4a, 0x65, 0x73, 0x3b, 0x4a, 0x65, 0x64, 0x6f, 0x6f, 0x6e,
0x65, 0x65, 0x3b, 0x4a, 0x65, 0x6c, 0x68, 0x65, 0x69, 0x6e, 0x3b, 0x4a, 0x65, 0x6d, 0x61, 0x79, 0x72, 0x74, 0x3b, 0x4a,
0x65, 0x72, 0x63, 0x65, 0x61, 0x6e, 0x3b, 0x4a, 0x65, 0x72, 0x64, 0x65, 0x69, 0x6e, 0x3b, 0x4a, 0x65, 0x68, 0x65, 0x69,
0x6e, 0x65, 0x79, 0x3b, 0x4a, 0x65, 0x73, 0x61, 0x72, 0x6e, 0x3b, 0x53, 0x75, 0x6c, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d,
0x74, 0x68, 0x3b, 0x4d, 0x68, 0x72, 0x3b, 0x59, 0x6f, 0x77, 0x3b, 0x47, 0x77, 0x65, 0x3b, 0x53, 0x61, 0x64, 0x3b, 0x64,
0x79, 0x20, 0x53, 0x75, 0x6c, 0x3b, 0x64, 0x79, 0x20, 0x4c, 0x75, 0x6e, 0x3b, 0x64, 0x79, 0x20, 0x4d, 0x65, 0x75, 0x72,
0x74, 0x68, 0x3b, 0x64, 0x79, 0x20, 0x4d, 0x65, 0x72, 0x68, 0x65, 0x72, 0x3b, 0x64, 0x79, 0x20, 0x59, 0x6f, 0x77, 0x3b,
0x64, 0x79, 0x20, 0x47, 0x77, 0x65, 0x6e, 0x65, 0x72, 0x3b, 0x64, 0x79, 0x20, 0x53, 0x61, 0x64, 0x6f, 0x72, 0x6e, 0x3b,
0x4b, 0x77, 0x65, 0x3b, 0x44, 0x77, 0x6f, 0x3b, 0x42, 0x65, 0x6e, 0x3b, 0x57, 0x75, 0x6b, 0x3b, 0x59, 0x61, 0x77, 0x3b,
0x46, 0x69, 0x61, 0x3b, 0x4d, 0x65, 0x6d, 0x3b, 0x4b, 0x77, 0x65, 0x73, 0x69, 0x64, 0x61, 0x3b, 0x44, 0x77, 0x6f, 0x77,
0x64, 0x61, 0x3b, 0x42, 0x65, 0x6e, 0x61, 0x64, 0x61, 0x3b, 0x57, 0x75, 0x6b, 0x75, 0x64, 0x61, 0x3b, 0x59, 0x61, 0x77,
0x64, 0x61, 0x3b, 0x46, 0x69, 0x64, 0x61, 0x3b, 0x4d, 0x65, 0x6d, 0x65, 0x6e, 0x65, 0x64, 0x61, 0x3b, 0x4b, 0x3b, 0x44,
0x3b, 0x42, 0x3b, 0x57, 0x3b, 0x59, 0x3b, 0x46, 0x3b, 0x4d, 0x3b, 0x906, 0x92f, 0x924, 0x93e, 0x930, 0x3b, 0x938, 0x94b, 0x92e,
0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x933, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x927, 0x935, 0x93e, 0x930, 0x3b, 0x917, 0x941, 0x930,
0x941, 0x935, 0x93e, 0x930, 0x3b, 0x936, 0x941, 0x915, 0x94d, 0x930, 0x93e, 0x930, 0x3b, 0x936, 0x947, 0x928, 0x935, 0x93e, 0x930, 0x3b,
0x906, 0x3b, 0x938, 0x94b, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b, 0x917, 0x941, 0x3b, 0x936, 0x941, 0x3b, 0x936, 0x947, 0x3b,
0x1ee4, 0x6b, 0x61, 0x3b, 0x4d, 0x1ecd, 0x6e, 0x3b, 0x54, 0x69, 0x75, 0x3b, 0x57, 0x65, 0x6e, 0x3b, 0x54, 0x1ecd, 0x1ecd, 0x3b,
0x46, 0x72, 0x61, 0x1ecb, 0x3b, 0x53, 0x61, 0x74, 0x3b, 0x53, 0x1ecd, 0x6e, 0x64, 0x65, 0x65, 0x3b, 0x4d, 0x1ecd, 0x6e, 0x64,
0x65, 0x3b, 0x54, 0x69, 0x75, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x57, 0x65, 0x6e, 0x65, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x54,
0x1ecd, 0x1ecd, 0x7a, 0x64, 0x65, 0x65, 0x3b, 0x46, 0x72, 0x61, 0x1ecb, 0x64, 0x65, 0x65, 0x3b, 0x53, 0x61, 0x74, 0x1ecd, 0x64,
0x65, 0x65, 0x3b, 0x57, 0x6b, 0x79, 0x3b, 0x57, 0x6b, 0x77, 0x3b, 0x57, 0x6b, 0x6c, 0x3b, 0x57, 0x74, 0x169, 0x3b, 0x57,
0x6b, 0x6e, 0x3b, 0x57, 0x74, 0x6e, 0x3b, 0x57, 0x74, 0x68, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x79, 0x75, 0x6d, 0x77, 0x61,
0x3b, 0x57, 0x61, 0x20, 0x6b, 0x77, 0x61, 0x6d, 0x62, 0x129, 0x6c, 0x129, 0x6c, 0x79, 0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b,
0x65, 0x6c, 0x129, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x6e,
0x61, 0x3b, 0x57, 0x61, 0x20, 0x6b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x57, 0x61, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x74,
0x68, 0x61, 0x74, 0x169, 0x3b, 0x59, 0x3b, 0x57, 0x3b, 0x45, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x64,
0x6f, 0x6d, 0x3b, 0x6c, 0x75, 0x6e, 0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x69, 0x65, 0x3b, 0x6a, 0x6f, 0x69, 0x3b, 0x76,
0x69, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x65, 0x6e, 0x69, 0x65, 0x3b, 0x6c, 0x75, 0x6e, 0x69, 0x73,
0x3b, 0x6d, 0x61, 0x72, 0x74, 0x61, 0x72, 0x73, 0x3b, 0x6d, 0x69, 0x65, 0x72, 0x63, 0x75, 0x73, 0x3b, 0x6a, 0x6f, 0x69,
0x62, 0x65, 0x3b, 0x76, 0x69, 0x6e, 0x61, 0x72, 0x73, 0x3b, 0x73, 0x61, 0x62, 0x69, 0x64, 0x65, 0x3b, 0x6b, 0x254, 0x73,
0x3b, 0x64, 0x7a, 0x6f, 0x3b, 0x62, 0x6c, 0x61, 0x3b, 0x6b, 0x75, 0x256, 0x3b, 0x79, 0x61, 0x77, 0x3b, 0x66, 0x69, 0x256,
0x3b, 0x6d, 0x65, 0x6d, 0x3b, 0x6b, 0x254, 0x73, 0x69, 0x256, 0x61, 0x3b, 0x64, 0x7a, 0x6f, 0x256, 0x61, 0x3b, 0x62, 0x6c,
0x61, 0x256, 0x61, 0x3b, 0x6b, 0x75, 0x256, 0x61, 0x3b, 0x79, 0x61, 0x77, 0x6f, 0x256, 0x61, 0x3b, 0x66, 0x69, 0x256, 0x61,
0x3b, 0x6d, 0x65, 0x6d, 0x6c, 0x65, 0x256, 0x61, 0x3b, 0x6b, 0x3b, 0x64, 0x3b, 0x62, 0x3b, 0x6b, 0x3b, 0x79, 0x3b, 0x66,
0x3b, 0x6d, 0x3b, 0x4c, 0x50, 0x3b, 0x50, 0x31, 0x3b, 0x50, 0x32, 0x3b, 0x50, 0x33, 0x3b, 0x50, 0x34, 0x3b, 0x50, 0x35,
0x3b, 0x50, 0x36, 0x3b, 0x4c, 0x101, 0x70, 0x75, 0x6c, 0x65, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6b, 0x61, 0x68, 0x69, 0x3b,
0x50, 0x6f, 0x2bb, 0x61, 0x6c, 0x75, 0x61, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6b, 0x6f, 0x6c, 0x75, 0x3b, 0x50, 0x6f, 0x2bb,
0x61, 0x68, 0x101, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6c, 0x69, 0x6d, 0x61, 0x3b, 0x50, 0x6f, 0x2bb, 0x61, 0x6f, 0x6e, 0x6f,
0x3b, 0x4c, 0x69, 0x6e, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x69, 0x79, 0x3b, 0x48, 0x75, 0x77,
0x3b, 0x42, 0x69, 0x79, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4c, 0x69, 0x6e, 0x67, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x65,
0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0x69, 0x79, 0x65, 0x72, 0x6b, 0x75, 0x6c, 0x65, 0x73, 0x3b,
0x48, 0x75, 0x77, 0x65, 0x62, 0x65, 0x73, 0x3b, 0x42, 0x69, 0x79, 0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x53, 0x61, 0x62,
0x61, 0x64, 0x6f, 0x3b, 0x53, 0x75, 0x2e, 0x3b, 0x4d, 0xe4, 0x2e, 0x3b, 0x5a, 0x69, 0x2e, 0x3b, 0x4d, 0x69, 0x2e, 0x3b,
0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0x75, 0x6e, 0x6e, 0x74, 0x69, 0x67, 0x3b,
0x4d, 0xe4, 0xe4, 0x6e, 0x74, 0x69, 0x67, 0x3b, 0x5a, 0x69, 0x69, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b, 0x4d, 0x69,
0x74, 0x74, 0x77, 0x75, 0x63, 0x68, 0x3b, 0x44, 0x75, 0x6e, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b, 0x46, 0x72, 0x69,
0x69, 0x74, 0x69, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x63, 0x68, 0x74, 0x69, 0x67, 0x3b, 0xa46d, 0xa18f, 0x3b, 0xa18f, 0xa2cd,
0x3b, 0xa18f, 0xa44d, 0x3b, 0xa18f, 0xa315, 0x3b, 0xa18f, 0xa1d6, 0x3b, 0xa18f, 0xa26c, 0x3b, 0xa18f, 0xa0d8, 0x3b, 0xa46d, 0xa18f, 0xa44d, 0x3b,
0xa18f, 0xa282, 0xa2cd, 0x3b, 0xa18f, 0xa282, 0xa44d, 0x3b, 0xa18f, 0xa282, 0xa315, 0x3b, 0xa18f, 0xa282, 0xa1d6, 0x3b, 0xa18f, 0xa282, 0xa26c, 0x3b,
0xa18f, 0xa282, 0xa0d8, 0x3b, 0xa18f, 0x3b, 0xa2cd, 0x3b, 0xa44d, 0x3b, 0xa315, 0x3b, 0xa1d6, 0x3b, 0xa26c, 0x3b, 0xa0d8, 0x3b, 0x53, 0xfc,
0x2e, 0x3b, 0x4d, 0x61, 0x2e, 0x3b, 0x44, 0x69, 0x2e, 0x3b, 0x4d, 0x69, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72,
0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0xfc, 0x6e, 0x6e, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0x61, 0x61, 0x6e, 0x64, 0x61,
0x67, 0x3b, 0x44, 0x69, 0x6e, 0x67, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x4d, 0x69, 0x64, 0x64, 0x65, 0x77, 0x65, 0x6b, 0x65,
0x6e, 0x3b, 0x44, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x64, 0x61, 0x67, 0x3b, 0x46, 0x72, 0x65, 0x65, 0x64, 0x61, 0x67,
0x3b, 0x53, 0xfc, 0x6e, 0x6e, 0x61, 0x76, 0x65, 0x6e, 0x64, 0x3b, 0x73, 0x6f, 0x74, 0x6e, 0x3b, 0x76, 0x75, 0x6f, 0x73,
0x3b, 0x6d, 0x61, 0x14b, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x3b, 0x64, 0x75, 0x6f, 0x72, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x3b,
0x6c, 0xe1, 0x76, 0x3b, 0x73, 0x6f, 0x74, 0x6e, 0x61, 0x62, 0x65, 0x61, 0x69, 0x76, 0x69, 0x3b, 0x76, 0x75, 0x6f, 0x73,
0x73, 0xe1, 0x72, 0x67, 0x61, 0x3b, 0x6d, 0x61, 0x14b, 0x14b, 0x65, 0x62, 0xe1, 0x72, 0x67, 0x61, 0x3b, 0x67, 0x61, 0x73,
0x6b, 0x61, 0x76, 0x61, 0x68, 0x6b, 0x6b, 0x75, 0x3b, 0x64, 0x75, 0x6f, 0x72, 0x61, 0x73, 0x64, 0x61, 0x74, 0x3b, 0x62,
0x65, 0x61, 0x72, 0x6a, 0x61, 0x64, 0x61, 0x74, 0x3b, 0x6c, 0xe1, 0x76, 0x76, 0x61, 0x72, 0x64, 0x61, 0x74, 0x3b, 0x53,
0x3b, 0x56, 0x3b, 0x4d, 0x3b, 0x47, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x73, 0x6f, 0x3b, 0x6d, 0xe1, 0x3b, 0x64,
0x69, 0x3b, 0x67, 0x61, 0x3b, 0x64, 0x75, 0x3b, 0x62, 0x65, 0x3b, 0x6c, 0xe1, 0x3b, 0x73, 0x6f, 0x74, 0x6e, 0x61, 0x62,
0x65, 0x61, 0x69, 0x76, 0x69, 0x3b, 0x6d, 0xe1, 0x6e, 0x6e, 0x6f, 0x64, 0x61, 0x74, 0x3b, 0x64, 0x69, 0x73, 0x64, 0x61,
0x74, 0x3b, 0x67, 0x61, 0x73, 0x6b, 0x61, 0x76, 0x61, 0x68, 0x6b, 0x6b, 0x75, 0x3b, 0x64, 0x75, 0x6f, 0x72, 0x61, 0x73,
0x74, 0x61, 0x74, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x6a, 0x61, 0x64, 0x61, 0x74, 0x3b, 0x6c, 0xe1, 0x76, 0x76, 0x6f, 0x72,
0x64, 0x61, 0x74, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x44, 0x3b, 0x47, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x43, 0x70,
0x72, 0x3b, 0x43, 0x74, 0x74, 0x3b, 0x43, 0x6d, 0x6e, 0x3b, 0x43, 0x6d, 0x74, 0x3b, 0x41, 0x72, 0x73, 0x3b, 0x49, 0x63,
0x6d, 0x3b, 0x45, 0x73, 0x74, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x75, 0x6d,
0x61, 0x74, 0x61, 0x74, 0x6f, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x43, 0x68, 0x75, 0x6d, 0x61,
0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x63, 0x68, 0x75, 0x6d, 0x61, 0x3b,
0x45, 0x73, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x43, 0x3b, 0x41, 0x3b, 0x49, 0x3b,
0x45, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x4a, 0x69, 0x6d, 0x3b, 0x4b, 0x61, 0x77, 0x3b, 0x4b, 0x61, 0x64, 0x3b, 0x4b, 0x61,
0x6e, 0x3b, 0x4b, 0x61, 0x73, 0x3b, 0x4e, 0x67, 0x75, 0x3b, 0x49, 0x74, 0x75, 0x6b, 0x75, 0x20, 0x6a, 0x61, 0x20, 0x6a,
0x75, 0x6d, 0x77, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6a, 0x69, 0x6d, 0x77, 0x65, 0x72,
0x69, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x77, 0x69, 0x3b, 0x4b, 0x75, 0x72, 0x61,
0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x64, 0x61, 0x64, 0x75, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61,
0x20, 0x6b, 0x61, 0x6e, 0x61, 0x3b, 0x4b, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x61, 0x20, 0x6b, 0x61, 0x73, 0x61, 0x6e,
0x75, 0x3b, 0x4b, 0x69, 0x66, 0x75, 0x6c, 0x61, 0x20, 0x6e, 0x67, 0x75, 0x77, 0x6f, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4b,
0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x64, 0x65, 0x77, 0x3b, 0x61, 0x61, 0x253, 0x3b, 0x6d, 0x61, 0x77,
0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x6e, 0x61, 0x61, 0x3b, 0x6d, 0x77, 0x64, 0x3b, 0x68, 0x62, 0x69, 0x3b, 0x64, 0x65, 0x77,
0x6f, 0x3b, 0x61, 0x61, 0x253, 0x6e, 0x64, 0x65, 0x3b, 0x6d, 0x61, 0x77, 0x62, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x6e, 0x6a,
0x65, 0x73, 0x6c, 0x61, 0x61, 0x72, 0x65, 0x3b, 0x6e, 0x61, 0x61, 0x73, 0x61, 0x61, 0x6e, 0x64, 0x65, 0x3b, 0x6d, 0x61,
0x77, 0x6e, 0x64, 0x65, 0x3b, 0x68, 0x6f, 0x6f, 0x72, 0x65, 0x2d, 0x62, 0x69, 0x69, 0x72, 0x3b, 0x64, 0x3b, 0x61, 0x3b,
0x6d, 0x3b, 0x6e, 0x3b, 0x6e, 0x3b, 0x6d, 0x3b, 0x68, 0x3b, 0x4b, 0x4d, 0x41, 0x3b, 0x4e, 0x54, 0x54, 0x3b, 0x4e, 0x4d,
0x4e, 0x3b, 0x4e, 0x4d, 0x54, 0x3b, 0x41, 0x52, 0x54, 0x3b, 0x4e, 0x4d, 0x41, 0x3b, 0x4e, 0x4d, 0x4d, 0x3b, 0x4b, 0x69,
0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x169, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61,
0x69, 0x6e, 0x65, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x61, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x74,
0x68, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x74, 0x68, 0x69,
0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x72, 0x65, 0x3b, 0x4b,
0x75, 0x6e, 0x3b, 0x4f, 0x6e, 0x67, 0x3b, 0x49, 0x6e, 0x65, 0x3b, 0x49, 0x6c, 0x65, 0x3b, 0x53, 0x61, 0x70, 0x3b, 0x4b,
0x77, 0x65, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x61, 0x72, 0x65, 0x3b, 0x4d, 0x64, 0x65,
0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x6b, 0x75, 0x6e, 0x69, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65,
0x65, 0x20, 0x6f, 0x6e, 0x67, 0x2019, 0x77, 0x61, 0x6e, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20,
0x69, 0x6e, 0x65, 0x74, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x69, 0x6c, 0x65, 0x3b, 0x4d,
0x64, 0x65, 0x72, 0x6f, 0x74, 0x20, 0x65, 0x65, 0x20, 0x73, 0x61, 0x70, 0x61, 0x3b, 0x4d, 0x64, 0x65, 0x72, 0x6f, 0x74,
0x20, 0x65, 0x65, 0x20, 0x6b, 0x77, 0x65, 0x3b, 0x41, 0x3b, 0x4b, 0x3b, 0x4f, 0x3b, 0x49, 0x3b, 0x49, 0x3b, 0x53, 0x3b,
0x4b, 0x3b, 0x44, 0x69, 0x6d, 0x3b, 0x50, 0x6f, 0x73, 0x3b, 0x50, 0x69, 0x72, 0x3b, 0x54, 0x61, 0x74, 0x3b, 0x4e, 0x61,
0x69, 0x3b, 0x53, 0x68, 0x61, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x44, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x43, 0x68,
0x69, 0x70, 0x6f, 0x73, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x74, 0x61, 0x74,
0x75, 0x3b, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x69, 0x3b, 0x43, 0x68, 0x69, 0x73, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x53, 0x61,
0x62, 0x75, 0x64, 0x75, 0x3b, 0x44, 0x3b, 0x50, 0x3b, 0x43, 0x3b, 0x54, 0x3b, 0x4e, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53,
0x6f, 0x6e, 0x3b, 0x4d, 0x76, 0x75, 0x3b, 0x53, 0x69, 0x62, 0x3b, 0x53, 0x69, 0x74, 0x3b, 0x53, 0x69, 0x6e, 0x3b, 0x53,
0x69, 0x68, 0x3b, 0x4d, 0x67, 0x71, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x6f, 0x3b, 0x4d, 0x76, 0x75, 0x6c, 0x6f, 0x3b, 0x53,
0x69, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x53, 0x69, 0x74, 0x68, 0x61, 0x74, 0x68, 0x75, 0x3b, 0x53, 0x69, 0x6e, 0x65, 0x3b,
0x53, 0x69, 0x68, 0x6c, 0x61, 0x6e, 0x75, 0x3b, 0x4d, 0x67, 0x71, 0x69, 0x62, 0x65, 0x6c, 0x6f, 0x3b, 0x53, 0x3b, 0x4d,
0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x49, 0x6a, 0x70, 0x3b, 0x49, 0x6a, 0x74, 0x3b, 0x49,
0x6a, 0x6e, 0x3b, 0x49, 0x6a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x49, 0x6a, 0x6d, 0x3b,
0x49, 0x6a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b,
0x49, 0x6a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41,
0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61,
0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x31, 0x3b, 0x2d30,
0x2d59, 0x2d30, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x3b, 0x2d30, 0x2d3d, 0x2d61, 0x3b, 0x2d30,
0x2d59, 0x2d49, 0x2d4e, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x3b, 0x2d30, 0x2d59, 0x2d30, 0x2d4e, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x2d30,
0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d55, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d61, 0x2d30, 0x2d59,
0x3b, 0x2d59, 0x2d49, 0x2d4e, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d39, 0x2d62, 0x2d30, 0x2d59, 0x3b, 0x61, 0x73, 0x61, 0x3b,
0x61, 0x79, 0x6e, 0x3b, 0x61, 0x73, 0x69, 0x3b, 0x61, 0x6b, 0x1e5b, 0x3b, 0x61, 0x6b, 0x77, 0x3b, 0x61, 0x73, 0x69, 0x6d,
0x3b, 0x61, 0x73, 0x69, 0x1e0d, 0x3b, 0x61, 0x73, 0x61, 0x6d, 0x61, 0x73, 0x3b, 0x61, 0x79, 0x6e, 0x61, 0x73, 0x3b, 0x61,
0x73, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x61, 0x6b, 0x1e5b, 0x61, 0x73, 0x3b, 0x61, 0x6b, 0x77, 0x61, 0x73, 0x3b, 0x61, 0x73,
0x69, 0x6d, 0x77, 0x61, 0x73, 0x3b, 0x61, 0x73, 0x69, 0x1e0d, 0x79, 0x61, 0x73, 0x3b, 0x41, 0x63, 0x65, 0x3b, 0x41, 0x72,
0x69, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x41, 0x68, 0x61, 0x3b, 0x41, 0x6d, 0x68, 0x3b, 0x53, 0x65, 0x6d, 0x3b, 0x53, 0x65,
0x64, 0x3b, 0x41, 0x63, 0x65, 0x72, 0x3b, 0x41, 0x72, 0x69, 0x6d, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x3b, 0x41, 0x68, 0x61,
0x64, 0x3b, 0x41, 0x6d, 0x68, 0x61, 0x64, 0x3b, 0x53, 0x65, 0x6d, 0x3b, 0x53, 0x65, 0x64, 0x3b, 0x59, 0x3b, 0x53, 0x3b,
0x4b, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x59, 0x61, 0x6e, 0x3b, 0x53, 0x61, 0x6e, 0x3b, 0x4b, 0x72,
0x61, 0x1e0d, 0x3b, 0x4b, 0x75, 0x1e93, 0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53, 0x1e0d, 0x69, 0x73, 0x3b, 0x53, 0x61, 0x79, 0x3b,
0x59, 0x61, 0x6e, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x6e, 0x61, 0x73, 0x73, 0x3b, 0x4b, 0x72, 0x61, 0x1e0d, 0x61, 0x73,
0x73, 0x3b, 0x4b, 0x75, 0x1e93, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x6d, 0x61, 0x73, 0x73, 0x3b, 0x53, 0x1e0d, 0x69, 0x73,
0x61, 0x73, 0x73, 0x3b, 0x53, 0x61, 0x79, 0x61, 0x73, 0x73, 0x3b, 0x43, 0x3b, 0x52, 0x3b, 0x41, 0x3b, 0x48, 0x3b, 0x4d,
0x3b, 0x53, 0x3b, 0x44, 0x3b, 0x53, 0x41, 0x4e, 0x3b, 0x4f, 0x52, 0x4b, 0x3b, 0x4f, 0x4b, 0x42, 0x3b, 0x4f, 0x4b, 0x53,
0x3b, 0x4f, 0x4b, 0x4e, 0x3b, 0x4f, 0x4b, 0x54, 0x3b, 0x4f, 0x4d, 0x4b, 0x3b, 0x53, 0x61, 0x6e, 0x64, 0x65, 0x3b, 0x4f,
0x72, 0x77, 0x6f, 0x6b, 0x75, 0x62, 0x61, 0x6e, 0x7a, 0x61, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x62, 0x69, 0x72,
0x69, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x73, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61,
0x6e, 0x61, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6b, 0x61, 0x74, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4f, 0x72, 0x77, 0x61, 0x6d,
0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x52, 0x3b, 0x53, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x4d,
0x3b, 0x4d, 0x75, 0x6c, 0x3b, 0x56, 0x69, 0x6c, 0x3b, 0x48, 0x69, 0x76, 0x3b, 0x48, 0x69, 0x64, 0x3b, 0x48, 0x69, 0x74,
0x3b, 0x48, 0x69, 0x68, 0x3b, 0x4c, 0x65, 0x6d, 0x3b, 0x70, 0x61, 0x20, 0x6d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b,
0x70, 0x61, 0x20, 0x73, 0x68, 0x61, 0x68, 0x75, 0x76, 0x69, 0x6c, 0x75, 0x68, 0x61, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69,
0x76, 0x69, 0x6c, 0x69, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x64, 0x61, 0x74, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69,
0x74, 0x61, 0x79, 0x69, 0x3b, 0x70, 0x61, 0x20, 0x68, 0x69, 0x68, 0x61, 0x6e, 0x75, 0x3b, 0x70, 0x61, 0x20, 0x73, 0x68,
0x61, 0x68, 0x75, 0x6c, 0x65, 0x6d, 0x62, 0x65, 0x6c, 0x61, 0x3b, 0x4d, 0x3b, 0x4a, 0x3b, 0x48, 0x3b, 0x48, 0x3b, 0x48,
0x3b, 0x57, 0x3b, 0x4a, 0x3b, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e,
0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x6c,
0x79, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x75, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49,
0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a,
0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x3b, 0x6b, 0x61, 0x72, 0x3b, 0x6e, 0x74, 0x25b, 0x3b, 0x74, 0x61, 0x72,
0x3b, 0x61, 0x72, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x3b, 0x73, 0x69, 0x62, 0x3b, 0x6b, 0x61, 0x72,
0x69, 0x3b, 0x6e, 0x74, 0x25b, 0x6e, 0x25b, 0x3b, 0x74, 0x61, 0x72, 0x61, 0x74, 0x61, 0x3b, 0x61, 0x72, 0x61, 0x62, 0x61,
0x3b, 0x61, 0x6c, 0x61, 0x6d, 0x69, 0x73, 0x61, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x73, 0x69, 0x62, 0x69, 0x72, 0x69,
0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x54, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x4a, 0x3b, 0x53, 0x3b, 0x4b, 0x6d, 0x61, 0x3b, 0x54,
0x61, 0x74, 0x3b, 0x49, 0x6e, 0x65, 0x3b, 0x54, 0x61, 0x6e, 0x3b, 0x41, 0x72, 0x6d, 0x3b, 0x4d, 0x61, 0x61, 0x3b, 0x4e,
0x4d, 0x4d, 0x3b, 0x4b, 0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b,
0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41,
0x72, 0x61, 0x6d, 0x69, 0x74, 0x68, 0x69, 0x3b, 0x4e, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4e, 0x4a, 0x75, 0x6d, 0x61,
0x6d, 0x6f, 0x74, 0x68, 0x69, 0x69, 0x3b, 0x4b, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4e,
0x3b, 0x13c6, 0x13cd, 0x13ac, 0x3b, 0x13c9, 0x13c5, 0x13af, 0x3b, 0x13d4, 0x13b5, 0x13c1, 0x3b, 0x13e6, 0x13a2, 0x13c1, 0x3b, 0x13c5, 0x13a9, 0x13c1,
0x3b, 0x13e7, 0x13be, 0x13a9, 0x3b, 0x13c8, 0x13d5, 0x13be, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3, 0x13c6, 0x13cd, 0x13ac, 0x3b, 0x13a4, 0x13be, 0x13d9,
0x13d3, 0x13c9, 0x13c5, 0x13af, 0x3b, 0x13d4, 0x13b5, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13e6, 0x13a2, 0x13c1, 0x13a2, 0x13a6, 0x3b, 0x13c5, 0x13a9, 0x13c1,
0x13a2, 0x13a6, 0x3b, 0x13e7, 0x13be, 0x13a9, 0x13b6, 0x13cd, 0x13d7, 0x3b, 0x13a4, 0x13be, 0x13d9, 0x13d3, 0x13c8, 0x13d5, 0x13be, 0x3b, 0x13c6, 0x3b,
0x13c9, 0x3b, 0x13d4, 0x3b, 0x13e6, 0x3b, 0x13c5, 0x3b, 0x13e7, 0x3b, 0x13a4, 0x3b, 0x64, 0x69, 0x6d, 0x3b, 0x6c, 0x69, 0x6e, 0x3b,
0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x72, 0x3b, 0x7a, 0x65, 0x3b, 0x76, 0x61, 0x6e, 0x3b, 0x73, 0x61, 0x6d, 0x3b, 0x64,
0x69, 0x6d, 0x61, 0x6e, 0x73, 0x3b, 0x6c, 0x69, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x65,
0x72, 0x6b, 0x72, 0x65, 0x64, 0x69, 0x3b, 0x7a, 0x65, 0x64, 0x69, 0x3b, 0x76, 0x61, 0x6e, 0x64, 0x72, 0x65, 0x64, 0x69,
0x3b, 0x73, 0x61, 0x6d, 0x64, 0x69, 0x3b, 0x64, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x7a, 0x3b, 0x76, 0x3b, 0x73,
0x3b, 0x4c, 0x6c, 0x32, 0x3b, 0x4c, 0x6c, 0x33, 0x3b, 0x4c, 0x6c, 0x34, 0x3b, 0x4c, 0x6c, 0x35, 0x3b, 0x4c, 0x6c, 0x36,
0x3b, 0x4c, 0x6c, 0x37, 0x3b, 0x4c, 0x6c, 0x31, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x70,
0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4c,
0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x63, 0x68, 0x69, 0x3b, 0x4c, 0x69, 0x64,
0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61,
0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20, 0x6c, 0x69, 0x6e, 0x6a, 0x69, 0x3b,
0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x79, 0x61, 0x6e, 0x6e, 0x79, 0x61, 0x6e, 0x6f, 0x20, 0x6e, 0x61, 0x20,
0x6d, 0x61, 0x76, 0x69, 0x6c, 0x69, 0x3b, 0x4c, 0x69, 0x64, 0x75, 0x76, 0x61, 0x20, 0x6c, 0x69, 0x74, 0x61, 0x6e, 0x64,
0x69, 0x3b, 0x50, 0xed, 0x69, 0x6c, 0x69, 0x3b, 0x54, 0xe1, 0x61, 0x74, 0x75, 0x3b, 0xcd, 0x6e, 0x65, 0x3b, 0x54, 0xe1,
0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x6d, 0x3b, 0x4d, 0xf3, 0x6f, 0x73, 0x69, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x70, 0xed, 0x69, 0x72, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d,
0x61, 0xed, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x61, 0x6d, 0xed,
0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0xe1, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0xf3, 0x6f, 0x73, 0x69,
0x3b, 0x50, 0x3b, 0x54, 0x3b, 0x45, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4d, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x42,
0x61, 0x6c, 0x3b, 0x4c, 0x77, 0x32, 0x3b, 0x4c, 0x77, 0x33, 0x3b, 0x4c, 0x77, 0x34, 0x3b, 0x4c, 0x77, 0x35, 0x3b, 0x4c,
0x77, 0x36, 0x3b, 0x53, 0x61, 0x62, 0x62, 0x69, 0x69, 0x74, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61, 0x7a, 0x61, 0x3b, 0x4c,
0x77, 0x61, 0x6b, 0x75, 0x62, 0x69, 0x72, 0x69, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x73, 0x61, 0x74, 0x75, 0x3b, 0x4c,
0x77, 0x61, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x4c, 0x77, 0x61, 0x6b, 0x75, 0x74, 0x61, 0x61, 0x6e, 0x6f, 0x3b, 0x4c, 0x77,
0x61, 0x6d, 0x75, 0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x53, 0x3b, 0x42, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c,
0x3b, 0x4c, 0x3b, 0x50, 0x61, 0x20, 0x4d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68,
0x69, 0x6d, 0x6f, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x62, 0x75, 0x6c, 0x69, 0x3b, 0x50, 0x61, 0x6c, 0x69,
0x63, 0x68, 0x69, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x50, 0x61, 0x6c, 0x69, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x3b, 0x50, 0x61,
0x6c, 0x69, 0x63, 0x68, 0x69, 0x73, 0x61, 0x6e, 0x6f, 0x3b, 0x50, 0x61, 0x63, 0x68, 0x69, 0x62, 0x65, 0x6c, 0x75, 0x73,
0x68, 0x69, 0x3b, 0x64, 0x75, 0x6d, 0x3b, 0x73, 0x69, 0x67, 0x3b, 0x74, 0x65, 0x72, 0x3b, 0x6b, 0x75, 0x61, 0x3b, 0x6b,
0x69, 0x6e, 0x3b, 0x73, 0x65, 0x73, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x64, 0x75, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x73,
0x69, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x74, 0x65, 0x72, 0x73, 0x61, 0x2d, 0x66, 0x65,
0x72, 0x61, 0x3b, 0x6b, 0x75, 0x61, 0x72, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x6b, 0x69, 0x6e, 0x74, 0x61,
0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x73, 0xe1, 0x62,
0x61, 0x64, 0x75, 0x3b, 0x44, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x53, 0x3b, 0x64, 0x75,
0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x73, 0x69, 0x67, 0x75, 0x6e, 0x64, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x74,
0x65, 0x72, 0x73, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x6b, 0x75, 0x61, 0x72, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72,
0x61, 0x3b, 0x6b, 0x69, 0x6e, 0x74, 0x61, 0x2d, 0x66, 0x65, 0x72, 0x61, 0x3b, 0x73, 0x65, 0x73, 0x74, 0x61, 0x2d, 0x66,
0x65, 0x72, 0x61, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x64, 0x75, 0x3b, 0x4b, 0x49, 0x55, 0x3b, 0x4d, 0x52, 0x41, 0x3b, 0x57,
0x41, 0x49, 0x3b, 0x57, 0x45, 0x54, 0x3b, 0x57, 0x45, 0x4e, 0x3b, 0x57, 0x54, 0x4e, 0x3b, 0x4a, 0x55, 0x4d, 0x3b, 0x4b,
0x69, 0x75, 0x6d, 0x69, 0x61, 0x3b, 0x4d, 0x75, 0x72, 0x61, 0x6d, 0x75, 0x6b, 0x6f, 0x3b, 0x57, 0x61, 0x69, 0x72, 0x69,
0x3b, 0x57, 0x65, 0x74, 0x68, 0x61, 0x74, 0x75, 0x3b, 0x57, 0x65, 0x6e, 0x61, 0x3b, 0x57, 0x65, 0x74, 0x61, 0x6e, 0x6f,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b, 0x57, 0x3b, 0x57, 0x3b, 0x57, 0x3b,
0x57, 0x3b, 0x4a, 0x3b, 0x4b, 0x74, 0x73, 0x3b, 0x4b, 0x6f, 0x74, 0x3b, 0x4b, 0x6f, 0x6f, 0x3b, 0x4b, 0x6f, 0x73, 0x3b,
0x4b, 0x6f, 0x61, 0x3b, 0x4b, 0x6f, 0x6d, 0x3b, 0x4b, 0x6f, 0x6c, 0x3b, 0x4b, 0x6f, 0x74, 0x69, 0x73, 0x61, 0x70, 0x3b,
0x4b, 0x6f, 0x74, 0x61, 0x61, 0x69, 0x3b, 0x4b, 0x6f, 0x61, 0x65, 0x6e, 0x67, 0x2019, 0x3b, 0x4b, 0x6f, 0x73, 0x6f, 0x6d,
0x6f, 0x6b, 0x3b, 0x4b, 0x6f, 0x61, 0x6e, 0x67, 0x2019, 0x77, 0x61, 0x6e, 0x3b, 0x4b, 0x6f, 0x6d, 0x75, 0x75, 0x74, 0x3b,
0x4b, 0x6f, 0x6c, 0x6f, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4f, 0x3b, 0x53, 0x3b, 0x41, 0x3b, 0x4d, 0x3b, 0x4c, 0x3b, 0x53,
0x6f, 0x6e, 0x3b, 0x4d, 0x61, 0x3b, 0x44, 0x65, 0x3b, 0x57, 0x75, 0x3b, 0x44, 0x6f, 0x3b, 0x46, 0x72, 0x3b, 0x53, 0x61,
0x74, 0x3b, 0x53, 0x6f, 0x6e, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x6e, 0x74, 0x61, 0x78,
0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x44, 0x65, 0x6e, 0x73, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x57,
0x75, 0x6e, 0x73, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x44, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x74, 0x61,
0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x46, 0x72, 0x61, 0x69, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b,
0x53, 0x61, 0x74, 0x65, 0x72, 0x74, 0x61, 0x78, 0x74, 0x73, 0x65, 0x65, 0x73, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x45, 0x3b,
0x57, 0x3b, 0x44, 0x3b, 0x46, 0x3b, 0x41, 0x3b, 0x53, 0x75, 0x2e, 0x3b, 0x4d, 0x6f, 0x2e, 0x3b, 0x44, 0x69, 0x2e, 0x3b,
0x4d, 0x65, 0x2e, 0x3b, 0x44, 0x75, 0x2e, 0x3b, 0x46, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x2e, 0x3b, 0x53, 0x75, 0x6e, 0x6e,
0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4d, 0x6f, 0x68, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x44, 0x69, 0x6e, 0x6e,
0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4d, 0x65, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x75, 0x6e, 0x6e, 0x65,
0x72, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x46, 0x72, 0x69, 0x69, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x53, 0x61,
0x6d, 0x73, 0x64, 0x61, 0x61, 0x63, 0x68, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0xed, 0x6c, 0xed, 0x3b, 0x4a, 0x75, 0x6d,
0x61, 0x74, 0xe1, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0xe1, 0x6e,
0x254, 0x3b, 0x41, 0x6c, 0x61, 0xe1, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0xe1, 0x61, 0x3b, 0x4a, 0x75, 0x6d,
0x61, 0x6d, 0xf3, 0x73, 0x69, 0x3b, 0x53, 0x61, 0x62, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61, 0x3b, 0x4b, 0x75, 0x62, 0x69,
0x3b, 0x4b, 0x75, 0x73, 0x61, 0x3b, 0x4b, 0x75, 0x6e, 0x61, 0x3b, 0x4b, 0x75, 0x74, 0x61, 0x3b, 0x4d, 0x75, 0x6b, 0x61,
0x3b, 0x53, 0x61, 0x62, 0x69, 0x69, 0x74, 0x69, 0x3b, 0x42, 0x61, 0x6c, 0x61, 0x7a, 0x61, 0x3b, 0x4f, 0x77, 0x6f, 0x6b,
0x75, 0x62, 0x69, 0x6c, 0x69, 0x3b, 0x4f, 0x77, 0x6f, 0x6b, 0x75, 0x73, 0x61, 0x74, 0x75, 0x3b, 0x4f, 0x6c, 0x6f, 0x6b,
0x75, 0x6e, 0x61, 0x3b, 0x4f, 0x6c, 0x6f, 0x6b, 0x75, 0x74, 0x61, 0x61, 0x6e, 0x75, 0x3b, 0x4f, 0x6c, 0x6f, 0x6d, 0x75,
0x6b, 0x61, 0x61, 0x67, 0x61, 0x3b, 0x53, 0x3b, 0x42, 0x3b, 0x42, 0x3b, 0x53, 0x3b, 0x4b, 0x3b, 0x4b, 0x3b, 0x4d, 0x3b,
0x4a, 0x32, 0x3b, 0x4a, 0x33, 0x3b, 0x4a, 0x34, 0x3b, 0x4a, 0x35, 0x3b, 0x41, 0x6c, 0x3b, 0x49, 0x6a, 0x3b, 0x4a, 0x31,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x70, 0x69, 0x72, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4d, 0x75, 0x72, 0x77,
0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4d, 0x75, 0x72, 0x77, 0x61, 0x20, 0x77, 0x61, 0x20,
0x4b, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x4a, 0x70, 0x69, 0x3b,
0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x6d, 0x3b,
0x4a, 0x6d, 0x6f, 0x3b, 0x4a, 0x75, 0x6d, 0x3b, 0x42, 0x61, 0x72, 0x3b, 0x41, 0x61, 0x72, 0x3b, 0x55, 0x6e, 0x69, 0x3b,
0x55, 0x6e, 0x67, 0x3b, 0x4b, 0x61, 0x6e, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x65, 0x6a, 0x75, 0x6d,
0x61, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x65, 0x62, 0x61, 0x72, 0x61, 0x73, 0x61, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x61, 0x72,
0x65, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x75, 0x6e, 0x69, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x75, 0x6e, 0x67, 0x2019, 0x6f, 0x6e,
0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x6b, 0x61, 0x6e, 0x79, 0x3b, 0x4e, 0x61, 0x6b, 0x61, 0x73, 0x61, 0x62, 0x69, 0x74, 0x69,
0x3b, 0x4a, 0x3b, 0x42, 0x3b, 0x41, 0x3b, 0x55, 0x3b, 0x55, 0x3b, 0x4b, 0x3b, 0x53, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x41,
0x74, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x6d, 0x3b, 0x41, 0x6c, 0x6a, 0x3b, 0x41,
0x73, 0x73, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c,
0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61,
0x3b, 0x41, 0x6c, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x73, 0x61, 0x62, 0x64, 0x75, 0x3b, 0x48, 0x3b, 0x54, 0x3b,
0x54, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x4c, 0x3b, 0x53, 0x3b, 0x4a, 0x4d, 0x50, 0x3b, 0x57, 0x55, 0x54, 0x3b, 0x54, 0x41,
0x52, 0x3b, 0x54, 0x41, 0x44, 0x3b, 0x54, 0x41, 0x4e, 0x3b, 0x54, 0x41, 0x42, 0x3b, 0x4e, 0x47, 0x53, 0x3b, 0x4a, 0x75,
0x6d, 0x61, 0x70, 0x69, 0x6c, 0x3b, 0x57, 0x75, 0x6f, 0x6b, 0x20, 0x54, 0x69, 0x63, 0x68, 0x3b, 0x54, 0x69, 0x63, 0x68,
0x20, 0x41, 0x72, 0x69, 0x79, 0x6f, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x64, 0x65, 0x6b, 0x3b, 0x54, 0x69, 0x63,
0x68, 0x20, 0x41, 0x6e, 0x67, 0x2019, 0x77, 0x65, 0x6e, 0x3b, 0x54, 0x69, 0x63, 0x68, 0x20, 0x41, 0x62, 0x69, 0x63, 0x68,
0x3b, 0x4e, 0x67, 0x65, 0x73, 0x6f, 0x3b, 0x4a, 0x3b, 0x57, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x54, 0x3b, 0x4e,
0x3b, 0x41, 0x73, 0x61, 0x3b, 0x41, 0x79, 0x6e, 0x3b, 0x41, 0x73, 0x6e, 0x3b, 0x41, 0x6b, 0x72, 0x3b, 0x41, 0x6b, 0x77,
0x3b, 0x41, 0x73, 0x6d, 0x3b, 0x41, 0x73, 0x1e0d, 0x3b, 0x41, 0x73, 0x61, 0x6d, 0x61, 0x73, 0x3b, 0x41, 0x79, 0x6e, 0x61,
0x73, 0x3b, 0x41, 0x73, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x41, 0x6b, 0x72, 0x61, 0x73, 0x3b, 0x41, 0x6b, 0x77, 0x61, 0x73,
0x3b, 0x41, 0x73, 0x69, 0x6d, 0x77, 0x61, 0x73, 0x3b, 0x41, 0x73, 0x69, 0x1e0d, 0x79, 0x61, 0x73, 0x3b, 0x41, 0x3b, 0x41,
0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x41, 0x74, 0x69, 0x3b, 0x41,
0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x6c, 0x6d, 0x3b, 0x41, 0x6c, 0x7a, 0x3b, 0x41, 0x73, 0x69, 0x3b, 0x41,
0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c, 0x61, 0x61, 0x74,
0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x69, 0x73, 0x61, 0x3b, 0x41,
0x6c, 0x7a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x69, 0x62, 0x74, 0x69, 0x3b, 0x4a, 0x70, 0x69, 0x3b, 0x4a, 0x74, 0x74,
0x3b, 0x4a, 0x6d, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x70, 0x69, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b,
0x4a, 0x75, 0x6d, 0x61, 0x61, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c,
0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x61, 0x6d,
0x6f, 0x73, 0x69, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x31, 0x3b, 0x930, 0x92c,
0x93f, 0x3b, 0x938, 0x92e, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x3b, 0x92c, 0x941, 0x926, 0x3b, 0x92c, 0x93f, 0x938, 0x925, 0x93f, 0x3b,
0x938, 0x941, 0x916, 0x941, 0x930, 0x3b, 0x938, 0x941, 0x928, 0x93f, 0x3b, 0x930, 0x92c, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x92e,
0x92c, 0x93e, 0x930, 0x3b, 0x92e, 0x902, 0x917, 0x932, 0x92c, 0x93e, 0x930, 0x3b, 0x92c, 0x941, 0x926, 0x92c, 0x93e, 0x930, 0x3b, 0x92c,
0x93f, 0x938, 0x925, 0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x941, 0x916, 0x941, 0x930, 0x92c, 0x93e, 0x930, 0x3b, 0x938, 0x941, 0x928,
0x93f, 0x92c, 0x93e, 0x930, 0x3b, 0x930, 0x3b, 0x938, 0x3b, 0x92e, 0x902, 0x3b, 0x92c, 0x941, 0x3b, 0x92c, 0x93f, 0x3b, 0x938, 0x941,
0x3b, 0x938, 0x941, 0x3b, 0x43a, 0x4c0, 0x438, 0x3b, 0x43e, 0x440, 0x3b, 0x448, 0x438, 0x3b, 0x43a, 0x445, 0x430, 0x3b, 0x435, 0x430,
0x3b, 0x43f, 0x4c0, 0x435, 0x3b, 0x448, 0x443, 0x43e, 0x3b, 0x43a, 0x4c0, 0x438, 0x440, 0x430, 0x3b, 0x43e, 0x440, 0x448, 0x43e, 0x442,
0x3b, 0x448, 0x438, 0x43d, 0x430, 0x440, 0x430, 0x3b, 0x43a, 0x445, 0x430, 0x430, 0x440, 0x430, 0x3b, 0x435, 0x430, 0x440, 0x430, 0x3b,
0x43f, 0x4c0, 0x435, 0x440, 0x430, 0x441, 0x43a, 0x430, 0x3b, 0x448, 0x443, 0x43e, 0x442, 0x3b, 0x43a, 0x4c0, 0x3b, 0x43e, 0x3b, 0x448,
0x3b, 0x43a, 0x445, 0x3b, 0x435, 0x3b, 0x43f, 0x4c0, 0x3b, 0x448, 0x3b, 0x43d, 0x434, 0x2de7, 0x487, 0x467, 0x3b, 0x43f, 0x43d, 0x2de3,
0x435, 0x3b, 0x432, 0x442, 0x43e, 0x2dec, 0x487, 0x3b, 0x441, 0x440, 0x2de3, 0x435, 0x3b, 0x447, 0x435, 0x2de6, 0x487, 0x3b, 0x43f, 0x467,
0x2de6, 0x487, 0x3b, 0x441, 0xa64b, 0x2de0, 0x487, 0x3b, 0x43d, 0x435, 0x434, 0x463, 0x301, 0x43b, 0x467, 0x3b, 0x43f, 0x43e, 0x43d, 0x435,
0x434, 0x463, 0x301, 0x43b, 0x44c, 0x43d, 0x438, 0x43a, 0x44a, 0x3b, 0x432, 0x442, 0x43e, 0x301, 0x440, 0x43d, 0x438, 0x43a, 0x44a, 0x3b,
0x441, 0x440, 0x435, 0x434, 0x430, 0x300, 0x3b, 0x447, 0x435, 0x442, 0x432, 0x435, 0x440, 0x442, 0x43e, 0x301, 0x43a, 0x44a, 0x3b, 0x43f,
0x467, 0x442, 0x43e, 0x301, 0x43a, 0x44a, 0x3b, 0x441, 0xa64b, 0x431, 0x431, 0x461, 0x301, 0x442, 0x430, 0x3b, 0x4c, 0x75, 0x6d, 0x3b,
0x4e, 0x6b, 0x6f, 0x3b, 0x4e, 0x64, 0x79, 0x3b, 0x4e, 0x64, 0x67, 0x3b, 0x4e, 0x6a, 0x77, 0x3b, 0x4e, 0x67, 0x76, 0x3b,
0x4c, 0x75, 0x62, 0x3b, 0x4c, 0x75, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x4e, 0x6b, 0x6f, 0x64, 0x79, 0x61, 0x3b, 0x4e,
0x64, 0xe0, 0x61, 0x79, 0xe0, 0x3b, 0x4e, 0x64, 0x61, 0x6e, 0x67, 0xf9, 0x3b, 0x4e, 0x6a, 0xf2, 0x77, 0x61, 0x3b, 0x4e,
0x67, 0xf2, 0x76, 0x79, 0x61, 0x3b, 0x4c, 0x75, 0x62, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x4c, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b,
0x4e, 0x3b, 0x4e, 0x3b, 0x4e, 0x3b, 0x4c, 0x3b, 0x53, 0x6f, 0x6e, 0x3b, 0x4d, 0xe9, 0x69, 0x3b, 0x44, 0xeb, 0x6e, 0x3b,
0x4d, 0xeb, 0x74, 0x3b, 0x44, 0x6f, 0x6e, 0x3b, 0x46, 0x72, 0x65, 0x3b, 0x53, 0x61, 0x6d, 0x3b, 0x53, 0x6f, 0x6e, 0x6e,
0x64, 0x65, 0x67, 0x3b, 0x4d, 0xe9, 0x69, 0x6e, 0x64, 0x65, 0x67, 0x3b, 0x44, 0xeb, 0x6e, 0x73, 0x63, 0x68, 0x64, 0x65,
0x67, 0x3b, 0x4d, 0xeb, 0x74, 0x74, 0x77, 0x6f, 0x63, 0x68, 0x3b, 0x44, 0x6f, 0x6e, 0x6e, 0x65, 0x73, 0x63, 0x68, 0x64,
0x65, 0x67, 0x3b, 0x46, 0x72, 0x65, 0x69, 0x64, 0x65, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x73, 0x63, 0x68, 0x64, 0x65, 0x67,
0x3b, 0x53, 0x6f, 0x6e, 0x2e, 0x3b, 0x4d, 0xe9, 0x69, 0x2e, 0x3b, 0x44, 0xeb, 0x6e, 0x2e, 0x3b, 0x4d, 0xeb, 0x74, 0x2e,
0x3b, 0x44, 0x6f, 0x6e, 0x2e, 0x3b, 0x46, 0x72, 0x65, 0x2e, 0x3b, 0x53, 0x61, 0x6d, 0x2e, 0x3b, 0x6e, 0x74, 0x73, 0x3b,
0x6b, 0x70, 0x61, 0x3b, 0x67, 0x68, 0x254, 0x3b, 0x74, 0x254, 0x6d, 0x3b, 0x75, 0x6d, 0x65, 0x3b, 0x67, 0x68, 0x268, 0x3b,
0x64, 0x7a, 0x6b, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x6e, 0x74, 0x73, 0x268, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x6b, 0x70,
0xe0, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x67, 0x68, 0x254, 0x65, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x74, 0x254, 0x300,
0x6d, 0x6c, 0xf2, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x6d, 0xe8, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x75, 0x67, 0x68, 0x268,
0x302, 0x6d, 0x3b, 0x74, 0x73, 0x75, 0x294, 0x6e, 0x64, 0x7a, 0x268, 0x6b, 0x254, 0x294, 0x254, 0x3b, 0x6e, 0x3b, 0x6b, 0x3b,
0x67, 0x3b, 0x74, 0x3b, 0x75, 0x3b, 0x67, 0x3b, 0x64, 0x3b, 0x6e, 0x254, 0x79, 0x3b, 0x6e, 0x6a, 0x61, 0x3b, 0x75, 0x75,
0x6d, 0x3b, 0x14b, 0x67, 0x65, 0x3b, 0x6d, 0x62, 0x254, 0x3b, 0x6b, 0x254, 0x254, 0x3b, 0x6a, 0x6f, 0x6e, 0x3b, 0x14b, 0x67,
0x77, 0xe0, 0x20, 0x6e, 0x254, 0x302, 0x79, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6e, 0x6a, 0x61, 0x14b, 0x67, 0x75, 0x6d,
0x62, 0x61, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0xfb, 0x6d, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x14b, 0x67, 0xea, 0x3b,
0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6d, 0x62, 0x254, 0x6b, 0x3b, 0x14b, 0x67, 0x77, 0xe0, 0x20, 0x6b, 0x254, 0x254, 0x3b, 0x14b,
0x67, 0x77, 0xe0, 0x20, 0x6a, 0xf4, 0x6e, 0x3b, 0x6e, 0x3b, 0x6e, 0x3b, 0x75, 0x3b, 0x14b, 0x3b, 0x6d, 0x3b, 0x6b, 0x3b,
0x6a, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x41, 0x74, 0x69, 0x6e, 0x6e, 0x69, 0x3b, 0x41, 0x74, 0x61, 0x6c,
0x61, 0x61, 0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x3b, 0x41, 0x6c, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69,
0x3b, 0x41, 0x6c, 0x7a, 0x75, 0x6d, 0x61, 0x3b, 0x41, 0x73, 0x69, 0x62, 0x74, 0x69, 0x3b, 0x48, 0x3b, 0x54, 0x3b, 0x54,
0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x53, 0x3b, 0xe9, 0x74, 0x3b, 0x6d, 0x254, 0x301, 0x73, 0x3b, 0x6b, 0x77, 0x61,
0x3b, 0x6d, 0x75, 0x6b, 0x3b, 0x14b, 0x67, 0x69, 0x3b, 0x257, 0xf3, 0x6e, 0x3b, 0x65, 0x73, 0x61, 0x3b, 0xe9, 0x74, 0x69,
0x3b, 0x6d, 0x254, 0x301, 0x73, 0xfa, 0x3b, 0x6b, 0x77, 0x61, 0x73, 0xfa, 0x3b, 0x6d, 0x75, 0x6b, 0x254, 0x301, 0x73, 0xfa,
0x3b, 0x14b, 0x67, 0x69, 0x73, 0xfa, 0x3b, 0x257, 0xf3, 0x6e, 0x25b, 0x73, 0xfa, 0x3b, 0x65, 0x73, 0x61, 0x253, 0x61, 0x73,
0xfa, 0x3b, 0x65, 0x3b, 0x6d, 0x3b, 0x6b, 0x3b, 0x6d, 0x3b, 0x14b, 0x3b, 0x257, 0x3b, 0x65, 0x3b, 0x44, 0x69, 0x6d, 0x3b,
0x54, 0x65, 0x6e, 0x3b, 0x54, 0x61, 0x6c, 0x3b, 0x41, 0x6c, 0x61, 0x3b, 0x41, 0x72, 0x61, 0x3b, 0x41, 0x72, 0x6a, 0x3b,
0x53, 0x69, 0x62, 0x3b, 0x44, 0x69, 0x6d, 0x61, 0x73, 0x3b, 0x54, 0x65, 0x6e, 0x65, 0x14b, 0x3b, 0x54, 0x61, 0x6c, 0x61,
0x74, 0x61, 0x3b, 0x41, 0x6c, 0x61, 0x72, 0x62, 0x61, 0x79, 0x3b, 0x41, 0x72, 0x61, 0x6d, 0x69, 0x73, 0x61, 0x79, 0x3b,
0x41, 0x72, 0x6a, 0x75, 0x6d, 0x61, 0x3b, 0x53, 0x69, 0x62, 0x69, 0x74, 0x69, 0x3b, 0x44, 0x3b, 0x54, 0x3b, 0x54, 0x3b,
0x41, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x53, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x3b, 0x73, 0x6d,
0x62, 0x3b, 0x73, 0x6d, 0x6c, 0x3b, 0x73, 0x6d, 0x6e, 0x3b, 0x66, 0xfa, 0x6c, 0x3b, 0x73, 0xe9, 0x72, 0x3b, 0x73, 0x254,
0x301, 0x6e, 0x64, 0x254, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d,
0x259, 0x6c, 0xfa, 0x20, 0x6d, 0x259, 0x301, 0x62, 0x25b, 0x30c, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x259,
0x6c, 0xfa, 0x20, 0x6d, 0x259, 0x301, 0x6c, 0x25b, 0x301, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x259, 0x6c,
0xfa, 0x20, 0x6d, 0x259, 0x301, 0x6e, 0x79, 0x69, 0x3b, 0x66, 0xfa, 0x6c, 0x61, 0x64, 0xe9, 0x3b, 0x73, 0xe9, 0x72, 0x61,
0x64, 0xe9, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x66, 0x3b, 0x73, 0x3b, 0x73, 0x254, 0x301,
0x6e, 0x3b, 0x6c, 0x1dd, 0x6e, 0x3b, 0x6d, 0x61, 0x61, 0x3b, 0x6d, 0x25b, 0x6b, 0x3b, 0x6a, 0x1dd, 0x1dd, 0x3b, 0x6a, 0xfa,
0x6d, 0x3b, 0x73, 0x61, 0x6d, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x1dd, 0x3b, 0x6c, 0x1dd, 0x6e, 0x64, 0xed, 0x3b, 0x6d,
0x61, 0x61, 0x64, 0xed, 0x3b, 0x6d, 0x25b, 0x6b, 0x72, 0x25b, 0x64, 0xed, 0x3b, 0x6a, 0x1dd, 0x1dd, 0x64, 0xed, 0x3b, 0x6a,
0xfa, 0x6d, 0x62, 0xe1, 0x3b, 0x73, 0x61, 0x6d, 0x64, 0xed, 0x3b, 0x73, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x6a,
0x3b, 0x6a, 0x3b, 0x73, 0x3b, 0x53, 0x61, 0x62, 0x3b, 0x4a, 0x74, 0x74, 0x3b, 0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e,
0x3b, 0x41, 0x72, 0x61, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b, 0x53, 0x61, 0x62, 0x61, 0x74, 0x6f, 0x3b,
0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d,
0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x72, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d,
0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b, 0x53, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b,
0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x3b, 0x43, 0x79, 0x61, 0x3b, 0x43, 0x6c, 0x61, 0x3b, 0x43, 0x7a, 0x69, 0x3b, 0x43, 0x6b,
0x6f, 0x3b, 0x43, 0x6b, 0x61, 0x3b, 0x43, 0x67, 0x61, 0x3b, 0x43, 0x7a, 0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x2019, 0x79, 0x61,
0x6b, 0x6b, 0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x6c, 0x61, 0x61, 0x257, 0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x7a, 0x79, 0x69,
0x69, 0x257, 0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x6b, 0x6f, 0x6c, 0x6c, 0x65, 0x3b, 0x43, 0x6f, 0x6d, 0x6b, 0x61, 0x6c,
0x64, 0x1dd, 0x253, 0x6c, 0x69, 0x69, 0x3b, 0x43, 0x6f, 0x6d, 0x67, 0x61, 0x69, 0x73, 0x75, 0x75, 0x3b, 0x43, 0x6f, 0x6d,
0x7a, 0x79, 0x65, 0x253, 0x73, 0x75, 0x75, 0x3b, 0x59, 0x3b, 0x4c, 0x3b, 0x5a, 0x3b, 0x4f, 0x3b, 0x41, 0x3b, 0x47, 0x3b,
0x45, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x3b, 0x6d, 0x254, 0x301, 0x6e, 0x3b, 0x73, 0x6d, 0x62, 0x3b, 0x73, 0x6d, 0x6c, 0x3b,
0x73, 0x6d, 0x6e, 0x3b, 0x6d, 0x62, 0x73, 0x3b, 0x73, 0x61, 0x73, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x3b, 0x6d,
0x254, 0x301, 0x6e, 0x64, 0x254, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1,
0x62, 0x61, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x6c, 0x61, 0x6c,
0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x254, 0x20, 0x6d, 0x61, 0x66, 0xfa, 0x20, 0x6d, 0xe1, 0x6e, 0x61, 0x3b, 0x6d, 0x61,
0x62, 0xe1, 0x67, 0xe1, 0x20, 0x6d, 0xe1, 0x20, 0x73, 0x75, 0x6b, 0x75, 0x6c, 0x3b, 0x73, 0xe1, 0x73, 0x61, 0x64, 0x69,
0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x6d, 0x3b, 0x73, 0x3b, 0x43, 0xe4, 0x14b, 0x3b, 0x4a,
0x69, 0x65, 0x63, 0x3b, 0x52, 0x25b, 0x77, 0x3b, 0x44, 0x69, 0x254, 0x331, 0x6b, 0x3b, 0x14a, 0x75, 0x61, 0x61, 0x6e, 0x3b,
0x44, 0x68, 0x69, 0x65, 0x65, 0x63, 0x3b, 0x42, 0xe4, 0x6b, 0x25b, 0x6c, 0x3b, 0x43, 0xe4, 0x14b, 0x20, 0x6b, 0x75, 0x254,
0x74, 0x68, 0x3b, 0x4a, 0x69, 0x65, 0x63, 0x20, 0x6c, 0x61, 0x331, 0x74, 0x3b, 0x52, 0x25b, 0x77, 0x20, 0x6c, 0xe4, 0x74,
0x6e, 0x69, 0x3b, 0x44, 0x69, 0x254, 0x331, 0x6b, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x14a, 0x75, 0x61, 0x61, 0x6e,
0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x44, 0x68, 0x69, 0x65, 0x65, 0x63, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b,
0x42, 0xe4, 0x6b, 0x25b, 0x6c, 0x20, 0x6c, 0xe4, 0x74, 0x6e, 0x69, 0x3b, 0x43, 0x3b, 0x4a, 0x3b, 0x52, 0x3b, 0x44, 0x3b,
0x14a, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x431, 0x441, 0x3b, 0x431, 0x43d, 0x3b, 0x43e, 0x43f, 0x3b, 0x441, 0x44d, 0x3b, 0x447, 0x43f,
0x3b, 0x431, 0x44d, 0x3b, 0x441, 0x431, 0x3b, 0x431, 0x430, 0x441, 0x43a, 0x44b, 0x4bb, 0x44b, 0x430, 0x43d, 0x43d, 0x44c, 0x430, 0x3b,
0x431, 0x44d, 0x43d, 0x438, 0x434, 0x438, 0x44d, 0x43d, 0x43d, 0x44c, 0x438, 0x43a, 0x3b, 0x43e, 0x43f, 0x442, 0x443, 0x43e, 0x440, 0x443,
0x43d, 0x43d, 0x44c, 0x443, 0x43a, 0x3b, 0x441, 0x44d, 0x440, 0x44d, 0x434, 0x44d, 0x3b, 0x447, 0x44d, 0x43f, 0x43f, 0x438, 0x44d, 0x440,
0x3b, 0x411, 0x44d, 0x44d, 0x442, 0x438, 0x4a5, 0x441, 0x44d, 0x3b, 0x441, 0x443, 0x431, 0x443, 0x43e, 0x442, 0x430, 0x3b, 0x411, 0x3b,
0x411, 0x3b, 0x41e, 0x3b, 0x421, 0x3b, 0x427, 0x3b, 0x411, 0x3b, 0x421, 0x3b, 0x4d, 0x75, 0x6c, 0x3b, 0x4a, 0x74, 0x74, 0x3b,
0x4a, 0x6e, 0x6e, 0x3b, 0x4a, 0x74, 0x6e, 0x3b, 0x41, 0x6c, 0x68, 0x3b, 0x49, 0x6a, 0x75, 0x3b, 0x4a, 0x6d, 0x6f, 0x3b,
0x4d, 0x75, 0x6c, 0x75, 0x6e, 0x67, 0x75, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x74, 0x75, 0x3b, 0x4a, 0x75, 0x6d,
0x61, 0x6e, 0x6e, 0x65, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x3b, 0x41, 0x6c, 0x61, 0x68, 0x61, 0x6d,
0x69, 0x73, 0x69, 0x3b, 0x49, 0x6a, 0x75, 0x6d, 0x61, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x6d, 0x6f, 0x73, 0x69, 0x3b,
0x4d, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x4a, 0x3b, 0x41, 0x3b, 0x49, 0x3b, 0x4a, 0x3b, 0xa55e, 0xa54c, 0xa535, 0x3b, 0xa5f3, 0xa5e1,
0xa609, 0x3b, 0xa55a, 0xa55e, 0xa55a, 0x3b, 0xa549, 0xa55e, 0xa552, 0x3b, 0xa549, 0xa524, 0xa546, 0xa562, 0x3b, 0xa549, 0xa524, 0xa540, 0xa56e, 0x3b,
0xa53b, 0xa52c, 0xa533, 0x3b, 0x6c, 0x61, 0x68, 0x61, 0x64, 0x69, 0x3b, 0x74, 0x25b, 0x25b, 0x6e, 0x25b, 0x25b, 0x3b, 0x74, 0x61,
0x6c, 0x61, 0x74, 0x61, 0x3b, 0x61, 0x6c, 0x61, 0x62, 0x61, 0x3b, 0x61, 0x69, 0x6d, 0x69, 0x73, 0x61, 0x3b, 0x61, 0x69,
0x6a, 0x69, 0x6d, 0x61, 0x3b, 0x73, 0x69, 0x253, 0x69, 0x74, 0x69, 0x3b, 0x53, 0x75, 0x6e, 0x3b, 0x4d, 0xe4, 0x6e, 0x3b,
0x5a, 0x69, 0x161, 0x3b, 0x4d, 0x69, 0x74, 0x3b, 0x46, 0x72, 0xf3, 0x3b, 0x46, 0x72, 0x69, 0x3b, 0x53, 0x61, 0x6d, 0x3b,
0x53, 0x75, 0x6e, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x4d, 0xe4, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x5a, 0x69, 0x161, 0x74, 0x61,
0x67, 0x3b, 0x4d, 0x69, 0x74, 0x74, 0x77, 0x75, 0x10d, 0x3b, 0x46, 0x72, 0xf3, 0x6e, 0x74, 0x61, 0x67, 0x3b, 0x46, 0x72,
0x69, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x61, 0x6d, 0x161, 0x74, 0x61, 0x67, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x5a, 0x3b, 0x4d,
0x3b, 0x46, 0x3b, 0x46, 0x3b, 0x53, 0x3b, 0x73, 0x64, 0x3b, 0x6d, 0x64, 0x3b, 0x6d, 0x77, 0x3b, 0x65, 0x74, 0x3b, 0x6b,
0x6c, 0x3b, 0x66, 0x6c, 0x3b, 0x73, 0x73, 0x3b, 0x73, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x25b, 0x3b, 0x6d, 0xf3, 0x6e, 0x64,
0x69, 0x65, 0x3b, 0x6d, 0x75, 0xe1, 0x6e, 0x79, 0xe1, 0x14b, 0x6d, 0xf3, 0x6e, 0x64, 0x69, 0x65, 0x3b, 0x6d, 0x65, 0x74,
0xfa, 0x6b, 0x70, 0xed, 0xe1, 0x70, 0x25b, 0x3b, 0x6b, 0xfa, 0x70, 0xe9, 0x6c, 0x69, 0x6d, 0x65, 0x74, 0xfa, 0x6b, 0x70,
0x69, 0x61, 0x70, 0x25b, 0x3b, 0x66, 0x65, 0x6c, 0xe9, 0x74, 0x65, 0x3b, 0x73, 0xe9, 0x73, 0x65, 0x6c, 0xe9, 0x3b, 0x73,
0x3b, 0x6d, 0x3b, 0x6d, 0x3b, 0x65, 0x3b, 0x6b, 0x3b, 0x66, 0x3b, 0x73, 0x3b, 0x64, 0x6f, 0x6d, 0x3b, 0x6c, 0x6c, 0x75,
0x3b, 0x6d, 0x61, 0x72, 0x3b, 0x6d, 0x69, 0xe9, 0x3b, 0x78, 0x75, 0x65, 0x3b, 0x76, 0x69, 0x65, 0x3b, 0x73, 0xe1, 0x62,
0x3b, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x75, 0x3b, 0x6c, 0x6c, 0x75, 0x6e, 0x65, 0x73, 0x3b, 0x6d, 0x61, 0x72, 0x74,
0x65, 0x73, 0x3b, 0x6d, 0x69, 0xe9, 0x72, 0x63, 0x6f, 0x6c, 0x65, 0x73, 0x3b, 0x78, 0x75, 0x65, 0x76, 0x65, 0x73, 0x3b,
0x76, 0x69, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x3b, 0x73, 0xe1, 0x62, 0x61, 0x64, 0x75, 0x3b, 0x53, 0x254, 0x301, 0x6e, 0x64,
0x69, 0x3b, 0x4d, 0x254, 0x301, 0x6e, 0x64, 0x69, 0x3b, 0xc1, 0x70, 0x74, 0x61, 0x20, 0x4d, 0x254, 0x301, 0x6e, 0x64, 0x69,
0x3b, 0x57, 0x25b, 0x301, 0x6e, 0x25b, 0x73, 0x25b, 0x64, 0x25b, 0x3b, 0x54, 0x254, 0x301, 0x73, 0x25b, 0x64, 0x25b, 0x3b, 0x46,
0x25b, 0x6c, 0xe2, 0x79, 0x25b, 0x64, 0x25b, 0x3b, 0x53, 0xe1, 0x73, 0x69, 0x64, 0x25b, 0x3b, 0x53, 0x254, 0x301, 0x3b, 0x4d,
0x254, 0x301, 0x3b, 0xc1, 0x4d, 0x3b, 0x57, 0x25b, 0x301, 0x3b, 0x54, 0x254, 0x301, 0x3b, 0x46, 0x25b, 0x3b, 0x53, 0xe1, 0x3b,
0x73, 0x254, 0x6e, 0x64, 0x69, 0x3b, 0x6c, 0x75, 0x6e, 0x64, 0x69, 0x3b, 0x6d, 0x61, 0x72, 0x64, 0x69, 0x3b, 0x6d, 0x25b,
0x72, 0x6b, 0x25b, 0x72, 0x25b, 0x64, 0x69, 0x3b, 0x79, 0x65, 0x64, 0x69, 0x3b, 0x76, 0x61, 0x14b, 0x64, 0x25b, 0x72, 0x25b,
0x64, 0x69, 0x3b, 0x6d, 0x254, 0x6e, 0x254, 0x20, 0x73, 0x254, 0x6e, 0x64, 0x69, 0x3b, 0x73, 0x6f, 0x3b, 0x6c, 0x75, 0x3b,
0x6d, 0x61, 0x3b, 0x6d, 0x25b, 0x3b, 0x79, 0x65, 0x3b, 0x76, 0x61, 0x3b, 0x6d, 0x73, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20,
0x31, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x32, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x33, 0x3b, 0x41, 0x6e, 0x65, 0x67,
0x20, 0x34, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x35, 0x3b, 0x41, 0x6e, 0x65, 0x67, 0x20, 0x36, 0x3b, 0x41, 0x6e, 0x65,
0x67, 0x20, 0x37, 0x3b, 0x41, 0x31, 0x3b, 0x41, 0x32, 0x3b, 0x41, 0x33, 0x3b, 0x41, 0x34, 0x3b, 0x41, 0x35, 0x3b, 0x41,
0x36, 0x3b, 0x41, 0x37, 0x3b, 0x6c, 0x79, 0x25b, 0x2bc, 0x25b, 0x301, 0x20, 0x73, 0x1e85, 0xed, 0x14b, 0x74, 0xe8, 0x3b, 0x6d,
0x76, 0x66, 0xf2, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x62, 0x254, 0x301, 0x254, 0x6e, 0x74, 0xe8, 0x20, 0x6d,
0x76, 0x66, 0xf2, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x74, 0x73, 0xe8, 0x74, 0x73, 0x25b, 0x300, 0x25b, 0x20, 0x6c,
0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x62, 0x254, 0x301, 0x254, 0x6e, 0x74, 0xe8, 0x20, 0x74, 0x73, 0x65, 0x74, 0x73, 0x25b,
0x300, 0x25b, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0x76, 0x66, 0xf2, 0x20, 0x6d, 0xe0, 0x67, 0x61, 0x20, 0x6c,
0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x6d, 0xe0, 0x67, 0x61, 0x20, 0x6c, 0x79, 0x25b, 0x30c, 0x2bc, 0x3b, 0x41, 0x14b, 0x70, 0xe9,
0x74, 0x75, 0x77, 0x61, 0x6b, 0x21f, 0x61, 0x14b, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x77, 0x61, 0x14b, 0x17e, 0x69,
0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x6e, 0x75, 0x14b, 0x70, 0x61, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x79,
0x61, 0x6d, 0x6e, 0x69, 0x3b, 0x41, 0x14b, 0x70, 0xe9, 0x74, 0x75, 0x74, 0x6f, 0x70, 0x61, 0x3b, 0x41, 0x14b, 0x70, 0xe9,
0x74, 0x75, 0x7a, 0x61, 0x70, 0x74, 0x61, 0x14b, 0x3b, 0x4f, 0x77, 0xe1, 0x14b, 0x67, 0x79, 0x75, 0x17e, 0x61, 0x17e, 0x61,
0x70, 0x69, 0x3b, 0x41, 0x3b, 0x57, 0x3b, 0x4e, 0x3b, 0x59, 0x3b, 0x54, 0x3b, 0x5a, 0x3b, 0x4f, 0x3b, 0x2d30, 0x2d59, 0x2d30,
0x2d4e, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d62, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4f, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d55,
0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d3d, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49, 0x2d4e, 0x2d61, 0x2d30, 0x2d59, 0x3b, 0x2d30, 0x2d59, 0x2d49,
0x2d39, 0x2d62, 0x2d30, 0x2d59, 0x3b, 0x6cc, 0x6d5, 0x6a9, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x62f, 0x648, 0x648, 0x634, 0x6d5, 0x645,
0x645, 0x6d5, 0x3b, 0x633, 0x6ce, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x686, 0x648, 0x627, 0x631, 0x634, 0x6d5, 0x645, 0x645, 0x6d5,
0x3b, 0x67e, 0x6ce, 0x646, 0x62c, 0x634, 0x6d5, 0x645, 0x645, 0x6d5, 0x3b, 0x6be, 0x6d5, 0x6cc, 0x646, 0x6cc, 0x3b, 0x634, 0x6d5, 0x645,
0x645, 0x6d5, 0x3b, 0x6cc, 0x3b, 0x62f, 0x3b, 0x633, 0x3b, 0x686, 0x3b, 0x67e, 0x3b, 0x6be, 0x3b, 0x634, 0x3b, 0x6e, 0x6a, 0x65,
0x3b, 0x70, 0xf3, 0x6e, 0x3b, 0x77, 0x61, 0x142, 0x3b, 0x73, 0x72, 0x6a, 0x3b, 0x73, 0x74, 0x77, 0x3b, 0x70, 0x11b, 0x74,
0x3b, 0x73, 0x6f, 0x62, 0x3b, 0x6e, 0x6a, 0x65, 0x17a, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0xf3, 0x6e, 0x6a, 0x65, 0x17a, 0x65,
0x6c, 0x65, 0x3b, 0x77, 0x61, 0x142, 0x74, 0x6f, 0x72, 0x61, 0x3b, 0x73, 0x72, 0x6a, 0x6f, 0x64, 0x61, 0x3b, 0x73, 0x74,
0x77, 0xf3, 0x72, 0x74, 0x6b, 0x3b, 0x70, 0x11b, 0x74, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b,
0x70, 0x3b, 0x77, 0x3b, 0x73, 0x3b, 0x73, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x6e, 0x6a, 0x65, 0x3b, 0x70, 0xf3, 0x6e, 0x3b,
0x77, 0x75, 0x74, 0x3b, 0x73, 0x72, 0x6a, 0x3b, 0x161, 0x74, 0x77, 0x3b, 0x70, 0x6a, 0x61, 0x3b, 0x73, 0x6f, 0x62, 0x3b,
0x6e, 0x6a, 0x65, 0x64, 0x17a, 0x65, 0x6c, 0x61, 0x3b, 0x70, 0xf3, 0x6e, 0x64, 0x17a, 0x65, 0x6c, 0x61, 0x3b, 0x77, 0x75,
0x74, 0x6f, 0x72, 0x61, 0x3b, 0x73, 0x72, 0x6a, 0x65, 0x64, 0x61, 0x3b, 0x161, 0x74, 0x77, 0xf3, 0x72, 0x74, 0x6b, 0x3b,
0x70, 0x6a, 0x61, 0x74, 0x6b, 0x3b, 0x73, 0x6f, 0x62, 0x6f, 0x74, 0x61, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x77, 0x3b, 0x73,
0x3b, 0x161, 0x3b, 0x70, 0x3b, 0x73, 0x3b, 0x6e, 0x61, 0x64, 0x3b, 0x70, 0x61, 0x6e, 0x3b, 0x77, 0x69, 0x73, 0x3b, 0x70,
0x75, 0x73, 0x3b, 0x6b, 0x65, 0x74, 0x3b, 0x70, 0x113, 0x6e, 0x3b, 0x73, 0x61, 0x62, 0x3b, 0x6e, 0x61, 0x64, 0x12b, 0x6c,
0x69, 0x3b, 0x70, 0x61, 0x6e, 0x61, 0x64, 0x12b, 0x6c, 0x69, 0x3b, 0x77, 0x69, 0x73, 0x61, 0x73, 0x12b, 0x64, 0x69, 0x73,
0x3b, 0x70, 0x75, 0x73, 0x73, 0x69, 0x73, 0x61, 0x77, 0x61, 0x69, 0x74, 0x69, 0x3b, 0x6b, 0x65, 0x74, 0x77, 0x69, 0x72,
0x74, 0x69, 0x6b, 0x73, 0x3b, 0x70, 0x113, 0x6e, 0x74, 0x6e, 0x69, 0x6b, 0x73, 0x3b, 0x73, 0x61, 0x62, 0x61, 0x74, 0x74,
0x69, 0x6b, 0x61, 0x3b, 0x4e, 0x3b, 0x50, 0x3b, 0x57, 0x3b, 0x50, 0x3b, 0x4b, 0x3b, 0x50, 0x3b, 0x53, 0x3b, 0x70, 0x61,
0x73, 0x3b, 0x76, 0x75, 0x6f, 0x3b, 0x6d, 0x61, 0x6a, 0x3b, 0x6b, 0x6f, 0x73, 0x3b, 0x74, 0x75, 0x6f, 0x3b, 0x76, 0xe1,
0x73, 0x3b, 0x6c, 0xe1, 0x76, 0x3b, 0x70, 0x61, 0x73, 0x65, 0x70, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x76, 0x75, 0x6f, 0x73,
0x73, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6d, 0x61, 0x6a, 0x65, 0x62, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6b, 0x6f, 0x73, 0x6b,
0x6f, 0x6b, 0x6b, 0x6f, 0x3b, 0x74, 0x75, 0x6f, 0x72, 0xe2, 0x73, 0x74, 0xe2, 0x68, 0x3b, 0x76, 0xe1, 0x73, 0x74, 0x75,
0x70, 0x70, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x6c, 0xe1, 0x76, 0x75, 0x72, 0x64, 0xe2, 0x68, 0x3b, 0x70, 0x61, 0x73, 0x65,
0x70, 0x65, 0x65, 0x69, 0x76, 0x69, 0x3b, 0x76, 0x75, 0x6f, 0x73, 0x73, 0x61, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6d, 0x61,
0x6a, 0x65, 0x62, 0x61, 0x61, 0x72, 0x67, 0xe2, 0x3b, 0x6b, 0x6f, 0x73, 0x6b, 0x6f, 0x68, 0x6f, 0x3b, 0x74, 0x75, 0x6f,
0x72, 0xe2, 0x73, 0x74, 0x75, 0x76, 0x3b, 0x76, 0xe1, 0x73, 0x74, 0x75, 0x70, 0x70, 0x65, 0x65, 0x69, 0x76, 0x69, 0x3b,
0x6c, 0xe1, 0x76, 0x75, 0x72, 0x64, 0x75, 0x76, 0x3b, 0x70, 0x3b, 0x56, 0x3b, 0x4d, 0x3b, 0x4b, 0x3b, 0x54, 0x3b, 0x56,
0x3b, 0x4c, 0x3b, 0x44, 0x6f, 0x6d, 0x3b, 0x4c, 0x75, 0x6e, 0x3b, 0x4d, 0x61, 0x72, 0x3b, 0x4d, 0x6b, 0x73, 0x3b, 0x48,
0x75, 0x3b, 0x42, 0x69, 0x3b, 0x53, 0x61, 0x3b, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x6f, 0x3b, 0x4c, 0x75, 0x6e, 0x65,
0x73, 0x3b, 0x4d, 0x61, 0x72, 0x74, 0x65, 0x73, 0x3b, 0x4d, 0x69, 0x79, 0x65, 0x72, 0x6b, 0x75, 0x6c, 0x65, 0x73, 0x3b,
0x48, 0x75, 0x77, 0x65, 0x62, 0x65, 0x73, 0x3b, 0x42, 0x69, 0x79, 0x65, 0x72, 0x6e, 0x65, 0x73, 0x3b, 0x53, 0x61, 0x62,
0x61, 0x64, 0x6f, 0x3b, 0x44, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4d, 0x3b, 0x48, 0x3b, 0x42, 0x3b, 0x53, 0x3b
};

static const ushort byte_unit_data[] = {
0x62, 0x79, 0x74, 0x65, 0x73, 0x6b, 0x42, 0x3b, 0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0x50, 0x42, 0x3b,
0x45, 0x42, 0x4b, 0x69, 0x42, 0x3b, 0x4d, 0x69, 0x42, 0x3b, 0x47, 0x69, 0x42, 0x3b, 0x54, 0x69, 0x42, 0x3b, 0x50, 0x69,
0x42, 0x3b, 0x45, 0x69, 0x42, 0x62, 0x79, 0x74, 0x65, 0x67, 0x72, 0x65, 0x65, 0x70, 0x62, 0x61, 0x6a, 0x74, 0x1263, 0x12ed,
0x1275, 0x12aa, 0x1263, 0x3b, 0x121c, 0x130b, 0x1263, 0x12ed, 0x1275, 0x3b, 0x130a, 0x1263, 0x3b, 0x1274, 0x122b, 0x1263, 0x12ed, 0x1275, 0x3b, 0x1354,
0x1263, 0x3b, 0x45, 0x42, 0x628, 0x627, 0x64a, 0x62a, 0x643, 0x64a, 0x644, 0x648, 0x628, 0x627, 0x64a, 0x62a, 0x3b, 0x645, 0x64a, 0x63a,
0x627, 0x628, 0x627, 0x64a, 0x62a, 0x3b, 0x63a, 0x64a, 0x63a, 0x627, 0x628, 0x627, 0x64a, 0x62a, 0x3b, 0x62a, 0x64a, 0x631, 0x627, 0x628,
0x627, 0x64a, 0x62a, 0x3b, 0x628, 0x64a, 0x62a, 0x627, 0x628, 0x627, 0x64a, 0x62a, 0x3b, 0x45, 0x42, 0x562, 0x561, 0x575, 0x569, 0x565,
0x580, 0x56f, 0x532, 0x3b, 0x544, 0x532, 0x3b, 0x533, 0x532, 0x3b, 0x54f, 0x532, 0x3b, 0x54a, 0x532, 0x3b, 0x45, 0x42, 0x9ac, 0x9be,
0x987, 0x99f, 0x995, 0x9bf, 0x983, 0x20, 0x9ac, 0x9be, 0x983, 0x3b, 0x9ae, 0x9c7, 0x983, 0x20, 0x9ac, 0x9be, 0x983, 0x3b, 0x997, 0x9bf,
0x983, 0x20, 0x9ac, 0x9be, 0x983, 0x3b, 0x99f, 0x9c7, 0x983, 0x20, 0x9ac, 0x9be, 0x983, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x62,
0x61, 0x79, 0x74, 0x62, 0x79, 0x74, 0x65, 0x2d, 0x61, 0x6b, 0x6f, 0x6b, 0x74, 0x65, 0x64, 0x6f, 0xf9, 0x6b, 0x6f, 0x3b,
0x4d, 0x6f, 0x3b, 0x47, 0x6f, 0x3b, 0x54, 0x6f, 0x3b, 0x50, 0x6f, 0x3b, 0x45, 0x6f, 0x4b, 0x69, 0x6f, 0x3b, 0x4d, 0x69,
0x6f, 0x3b, 0x47, 0x69, 0x6f, 0x3b, 0x54, 0x69, 0x6f, 0x3b, 0x50, 0x69, 0x6f, 0x3b, 0x45, 0x69, 0x6f, 0x431, 0x430, 0x439,
0x442, 0x43e, 0x432, 0x435, 0x1018, 0x102d, 0x102f, 0x1000, 0x103a, 0x431, 0x430, 0x439, 0x442, 0x44b, 0x41a, 0x411, 0x3b, 0x41c, 0x411, 0x3b,
0x413, 0x411, 0x3b, 0x422, 0x411, 0x3b, 0x41f, 0x411, 0x3b, 0x45, 0x42, 0x1794, 0x17c3, 0x5b57, 0x8282, 0x5343, 0x5b57, 0x8282, 0x3b, 0x5146,
0x5b57, 0x8282, 0x3b, 0x5409, 0x5b57, 0x8282, 0x3b, 0x592a, 0x5b57, 0x8282, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x4f4d, 0x5143, 0x7d44, 0x62,
0x61, 0x6a, 0x74, 0x6f, 0x76, 0x69, 0x62, 0x61, 0x6a, 0x74, 0x79, 0x62, 0x61, 0x6a, 0x74, 0x6f, 0x6a, 0x62, 0x61, 0x69,
0x64, 0x69, 0x64, 0x62, 0xfd, 0x74, 0x74, 0x61, 0x76, 0x75, 0x74, 0x6b, 0x74, 0x3b, 0x4d, 0x74, 0x3b, 0x47, 0x74, 0x3b,
0x54, 0x74, 0x3b, 0x50, 0x74, 0x3b, 0x45, 0x74, 0x4b, 0x69, 0x74, 0x3b, 0x4d, 0x69, 0x74, 0x3b, 0x47, 0x69, 0x74, 0x3b,
0x54, 0x69, 0x74, 0x3b, 0x50, 0x69, 0x74, 0x3b, 0x45, 0x69, 0x74, 0x6f, 0x63, 0x74, 0x65, 0x74, 0x73, 0x62, 0x61, 0x69,
0x64, 0x68, 0x74, 0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x10d9, 0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x3b, 0x10db, 0x10d1, 0x10d0, 0x10d8, 0x10e2,
0x10d8, 0x3b, 0x10d2, 0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x3b, 0x10e2, 0x10d1, 0x10d0, 0x10d8, 0x10e2, 0x10d8, 0x3b, 0x10de, 0x10d1, 0x10d0, 0x10d8,
0x10e2, 0x10d8, 0x3b, 0x45, 0x42, 0x42, 0x79, 0x74, 0x65, 0x73, 0xaac, 0xabe, 0xa87, 0xa9f, 0x6b, 0x42, 0x3b, 0x4d, 0x42, 0x3b,
0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0xaaa, 0xac0, 0xaac, 0xac0, 0x3b, 0x45, 0x42, 0x5d1, 0x5d9, 0x5d9, 0x5d8, 0x92c, 0x93e, 0x907,
0x91f, 0x62, 0xe1, 0x6a, 0x74, 0x62, 0xe6, 0x74, 0x69, 0x62, 0x65, 0x61, 0x72, 0x74, 0x61, 0x30d0, 0x30a4, 0x30c8, 0x4b, 0x42,
0x3b, 0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x62, 0x69, 0x74, 0x65, 0xcac,
0xcc8, 0xc9f, 0xccd, 0x200c, 0xc97, 0xcb3, 0xcc1, 0xc95, 0xcbf, 0x2e, 0xcac, 0xcc8, 0x2e, 0x3b, 0xcae, 0xcc6, 0x2e, 0xcac, 0xcc8, 0x2e,
0x3b, 0xc97, 0xcbf, 0x2e, 0xcac, 0xcc8, 0x2e, 0x3b, 0xc9f, 0xcc6, 0x2e, 0xcac, 0xcc8, 0x2e, 0x3b, 0xcaa, 0xcc6, 0xcac, 0xcc8, 0x3b,
0x45, 0x42, 0x431, 0x430, 0x439, 0x442, 0x43a, 0x411, 0x3b, 0x4d, 0x411, 0x3b, 0x413, 0x411, 0x3b, 0x54, 0x411, 0x3b, 0x41f, 0x411,
0x3b, 0x45, 0x411, 0x4b, 0x69, 0x411, 0x3b, 0x4d, 0x69, 0x411, 0x3b, 0x47, 0x69, 0x411, 0x3b, 0x54, 0x69, 0x411, 0x3b, 0x50,
0x69, 0x411, 0x3b, 0x45, 0x69, 0x411, 0x43a, 0x411, 0x3b, 0x41c, 0x411, 0x3b, 0x413, 0x411, 0x3b, 0x422, 0x411, 0x3b, 0x41f, 0x442,
0x431, 0x3b, 0x45, 0x42, 0xbc14, 0xc774, 0xd2b8, 0x62, 0x61, 0x69, 0x74, 0x69, 0x62, 0x61, 0x69, 0x74, 0x61, 0x69, 0x431, 0x430,
0x458, 0x442, 0x438, 0x62, 0x61, 0x69, 0x74, 0xd2c, 0xd48, 0xd31, 0xd4d, 0xd31, 0xd4d, 0xd15, 0xd46, 0xd2c, 0xd3f, 0x3b, 0xd0e, 0xd02,
0xd2c, 0xd3f, 0x3b, 0xd1c, 0xd3f, 0xd2c, 0xd3f, 0x3b, 0xd1f, 0xd3f, 0xd2c, 0xd3f, 0x3b, 0xd2a, 0xd3f, 0xd2c, 0xd3f, 0x3b, 0x45, 0x42,
0x43a, 0x411, 0x3b, 0x41c, 0x411, 0x3b, 0x413, 0x411, 0x3b, 0x422, 0x411, 0x3b, 0x41f, 0x411, 0x3b, 0x45, 0x42, 0x6b, 0x42, 0x3b,
0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0x92a, 0x93f, 0x91f, 0x93e, 0x3b, 0x45, 0x42, 0xb2c, 0xb3e, 0xb07, 0xb1f,
0xb4d, 0x628, 0x627, 0x64a, 0x67c, 0x633, 0x628, 0x627, 0x6cc, 0x62a, 0x6a9, 0x6cc, 0x644, 0x648, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x645,
0x6af, 0x627, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x6af, 0x6cc, 0x6af, 0x627, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x62a, 0x631, 0x627, 0x628,
0x627, 0x6cc, 0x62a, 0x3b, 0x67e, 0x62a, 0x627, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x45, 0x42, 0xa2c, 0xa3e, 0xa07, 0xa1f, 0x62, 0x79,
0x21b, 0x69, 0x431, 0x430, 0x458, 0x442, 0x43e, 0x432, 0x438, 0x628, 0x627, 0x626, 0x64a, 0x67d, 0x632, 0x6aa, 0x644, 0x648, 0x20, 0x628,
0x627, 0x626, 0x64a, 0x67d, 0x632, 0x3b, 0x645, 0x64a, 0x6af, 0x627, 0x20, 0x628, 0x627, 0x626, 0x64a, 0x67d, 0x632, 0x3b, 0x6af, 0x64a,
0x6af, 0x627, 0x20, 0x628, 0x627, 0x626, 0x64a, 0x67d, 0x632, 0x3b, 0x67d, 0x64a, 0x631, 0x627, 0x20, 0x628, 0x627, 0x626, 0x64a, 0x67d,
0x632, 0x3b, 0x67e, 0x64a, 0x631, 0x627, 0x20, 0x628, 0x627, 0x626, 0x64a, 0x67d, 0x633, 0x3b, 0x45, 0x42, 0xdb6, 0xdba, 0xdd2, 0xda7,
0xdca, 0xd9a, 0xdd2, 0xdb6, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0xdb8, 0xdd9, 0xdb6, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0xd9c, 0xdd2, 0xdb6,
0x20, 0x7b, 0x30, 0x7d, 0x3b, 0xda7, 0xdd9, 0xdb6, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0xdb4, 0xdd9, 0xdb6, 0x20, 0x7b, 0x30, 0x7d,
0x3b, 0x45, 0x42, 0x62, 0x65, 0x79, 0x74, 0x69, 0x73, 0x6b, 0x42, 0x3b, 0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42,
0x3b, 0x42, 0x42, 0x3b, 0x45, 0x42, 0x6b, 0x69, 0x6c, 0x6f, 0x62, 0x61, 0x69, 0x74, 0x69, 0x20, 0x7b, 0x30, 0x7d, 0x3b,
0x4d, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x47, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x74, 0x65, 0x72, 0x61, 0x62, 0x61,
0x69, 0x74, 0x69, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x50, 0x42, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x45, 0x42, 0xbaa, 0xbc8, 0xb9f,
0xbcd, 0xb95, 0xbb3, 0xbcd, 0xc2c, 0xc48, 0xc1f, 0xc4d, 0x200c, 0xc32, 0xc41, 0xc15, 0xc47, 0xc2c, 0xc40, 0x3b, 0xc0e, 0xc2e, 0xc4d, 0x200c,
0xc2c, 0xc3f, 0x3b, 0xc1c, 0xc40, 0xc2c, 0xc40, 0x3b, 0xc1f, 0xc40, 0xc2c, 0xc40, 0x3b, 0xc2a, 0xc40, 0xc2c, 0xc40, 0x3b, 0x45, 0x42,
0xe44, 0xe1a, 0xe15, 0xe4c, 0x70, 0x61, 0x69, 0x74, 0x69, 0x6b, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x4d,
0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x47, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x54,
0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x50, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x45,
0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x4b, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x4d,
0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x47, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d,
0x3b, 0x54, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x3b, 0x50, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b,
0x30, 0x7d, 0x3b, 0x45, 0x69, 0x42, 0x20, 0x2bb, 0x65, 0x20, 0x7b, 0x30, 0x7d, 0x62, 0x61, 0xfd, 0x74, 0x431, 0x430, 0x439,
0x442, 0x438, 0x628, 0x627, 0x626, 0x679, 0x6b, 0x42, 0x3b, 0x4d, 0x42, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0x67e, 0x6cc,
0x20, 0x628, 0x6cc, 0x3b, 0x45, 0x42, 0x62, 0x65, 0x69, 0x74, 0x69, 0x61, 0x75, 0x92c, 0x93e, 0x92f, 0x91f, 0x61, 0x1e6d, 0x61,
0x6d, 0x1e0d, 0x61, 0x6e, 0x6b, 0x41, 0x1e6c, 0x3b, 0x4d, 0x41, 0x1e6c, 0x3b, 0x47, 0x41, 0x1e6c, 0x3b, 0x54, 0x41, 0x1e6c, 0x3b,
0x50, 0x42, 0x3b, 0x45, 0x42, 0x13d7, 0x13d3, 0x13cd, 0x13a6, 0x13b5, 0x13a9, 0x431, 0x430, 0x430, 0x439, 0x442, 0x43a, 0x411, 0x3b, 0x41c,
0x411, 0x3b, 0x47, 0x42, 0x3b, 0x54, 0x42, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x62, 0x79, 0x74, 0x65, 0x79, 0x6a9, 0x6cc,
0x644, 0x648, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x645, 0x6af, 0x627, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x6af, 0x6cc, 0x6af, 0x627, 0x628,
0x627, 0x6cc, 0x62a, 0x3b, 0x62a, 0x631, 0x627, 0x628, 0x627, 0x6cc, 0x62a, 0x3b, 0x50, 0x42, 0x3b, 0x45, 0x42, 0x6d, 0x67, 0x61,
0x20, 0x62, 0x79, 0x74, 0x65
};

static const ushort am_data[] = {
0x41, 0x4d, 0x57, 0x44, 0x76, 0x6d, 0x2e, 0x65, 0x20, 0x70, 0x61, 0x72, 0x61, 0x64, 0x69, 0x74, 0x65, 0x73, 0x1325, 0x12cb,
0x1275, 0x635, 0x9aa, 0x9c2, 0x9f0, 0x9cd, 0x9ac, 0x9be, 0x9b9, 0x9cd, 0x9a8, 0x410, 0x41c, 0xf66, 0xf94, 0xf0b, 0xf46, 0xf0b, 0x41, 0x2e,
0x4d, 0x2e, 0x43f, 0x440, 0x2e, 0x43e, 0x431, 0x2e, 0x1014, 0x1036, 0x1014, 0x1000, 0x103a, 0x61, 0x2e, 0xa0, 0x6d, 0x2e, 0x4e0a, 0x5348,
0x64, 0x6f, 0x70, 0x2e, 0x61, 0x2e, 0x6d, 0x2e, 0x61, 0x6d, 0x61, 0x74, 0x6d, 0x61, 0x70, 0x2e, 0x6d, 0x61, 0x74, 0x69,
0x6e, 0x6d, 0x3c0, 0x2e, 0x3bc, 0x2e, 0x53, 0x61, 0x66, 0x69, 0x79, 0x61, 0x5dc, 0x5e4, 0x5e0, 0x5d4, 0x5f4, 0x5e6, 0x64, 0x65,
0x2e, 0x66, 0x2e, 0x68, 0x2e, 0x72, 0x2e, 0x6e, 0x2e, 0x5348, 0x524d, 0x49, 0x73, 0x75, 0x6b, 0xcaa, 0xcc2, 0xcb0, 0xccd, 0xcb5,
0xcbe, 0xcb9, 0xccd, 0xca8, 0x442, 0x430, 0x4a3, 0x43a, 0x44b, 0xc624, 0xc804, 0x42, 0x4e, 0x5a, 0x2e, 0x4d, 0x55, 0x2e, 0xe81, 0xec8,
0xead, 0xe99, 0xe97, 0xec8, 0xebd, 0xe87, 0x70, 0x72, 0x69, 0x65, 0x6b, 0x161, 0x70, 0x75, 0x73, 0x64, 0x69, 0x65, 0x6e, 0x101,
0x6e, 0x74, 0x254, 0x301, 0x6e, 0x67, 0x254, 0x301, 0x70, 0x72, 0x69, 0x65, 0x161, 0x70, 0x69, 0x65, 0x74, 0x43f, 0x440, 0x435,
0x442, 0x43f, 0x43b, 0x430, 0x434, 0x43d, 0x435, 0x50, 0x47, 0x92e, 0x2e, 0x92a, 0x942, 0x2e, 0x4af, 0x2e, 0x4e9, 0x2e, 0x92a, 0x942,
0x930, 0x94d, 0x935, 0x93e, 0x939, 0x94d, 0x928, 0x63a, 0x2e, 0x645, 0x2e, 0x642, 0x628, 0x644, 0x200c, 0x627, 0x632, 0x638, 0x647, 0x631,
0x64, 0x61, 0x20, 0x6d, 0x61, 0x6e, 0x68, 0xe3, 0xa2a, 0xa42, 0x2e, 0xa26, 0xa41, 0x2e, 0x4e, 0x44, 0x43f, 0x440, 0x435, 0x20,
0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x43f, 0x440, 0x438, 0x458, 0x435, 0x20, 0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x70, 0x72, 0x69, 0x6a,
0x65, 0x20, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x70, 0x72, 0x65, 0x20, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x4d5, 0x43c, 0x431, 0x438,
0x441, 0x431, 0x43e, 0x43d, 0x44b, 0x20, 0x440, 0x430, 0x437, 0x43c, 0x4d5, 0x635, 0x628, 0x62d, 0x60c, 0x20, 0x645, 0x646, 0x62c, 0x647,
0x646, 0x62f, 0xdb4, 0xdd9, 0x2e, 0xdc0, 0x2e, 0x47, 0x48, 0x66, 0x6d, 0xbae, 0xbc1, 0xbb1, 0xbcd, 0xbaa, 0xb95, 0xbb2, 0xbcd, 0xe01,
0xe48, 0xe2d, 0xe19, 0xe40, 0xe17, 0xe35, 0xe48, 0xe22, 0xe07, 0xf66, 0xf94, 0xf0b, 0xf51, 0xfb2, 0xf7c, 0xf0b, 0x1295, 0x1309, 0x1206, 0x20,
0x1230, 0x12d3, 0x1270, 0x68, 0x65, 0x6e, 0x67, 0x69, 0x68, 0x65, 0x6e, 0x67, 0x69, 0xd6, 0xd6, 0x67, 0xfc, 0x6e, 0x6f, 0x72,
0x74, 0x61, 0x64, 0x61, 0x6e, 0x20, 0xf6, 0x148, 0x686, 0x6c8, 0x634, 0x62a, 0x649, 0x646, 0x20, 0x628, 0x6c7, 0x631, 0x6c7, 0x646,
0x434, 0x43f, 0x54, 0x4f, 0x422, 0x41e, 0x53, 0x41, 0x79, 0x62, 0x53, 0x75, 0x62, 0x5e4, 0x5bf, 0x5d0, 0x5b7, 0x5e8, 0x5de, 0x5d9,
0x5d8, 0x5d0, 0x5b8, 0x5d2, 0xc0, 0xe1, 0x72, 0x1ecd, 0x300, 0xc0, 0xe1, 0x72, 0x254, 0x300, 0x66, 0x6f, 0x72, 0x6d, 0x69, 0x64,
0x64, 0x61, 0x67, 0x70, 0x72, 0x69, 0x6a, 0x65, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x41, 0x4e, 0x4e, 0x2019, 0x1ee5, 0x74, 0x1ee5,
0x74, 0x1ee5, 0x128, 0x79, 0x61, 0x6b, 0x77, 0x61, 0x6b, 0x79, 0x61, 0x61, 0x2e, 0x14b, 0x64, 0x69, 0x61, 0x6d, 0x20, 0x56,
0x6f, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x61, 0x67, 0xa3b8, 0xa111, 0x69, 0x111, 0x69, 0x74, 0x62, 0x65, 0x61, 0x69, 0x76, 0x65,
0x74, 0x69, 0x62, 0x4d, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x4c, 0x75, 0x6d, 0x61, 0x20, 0x6c, 0x77, 0x61, 0x20, 0x4b, 0x73,
0x75, 0x62, 0x61, 0x6b, 0x61, 0x4b, 0x69, 0x72, 0x6f, 0x6b, 0x6f, 0x54, 0x65, 0x73, 0x69, 0x72, 0x61, 0x6e, 0x6b, 0x61,
0x6e, 0x67, 0x2019, 0x61, 0x6d, 0x61, 0x2d5c, 0x2d49, 0x2d3c, 0x2d30, 0x2d61, 0x2d5c, 0x74, 0x69, 0x66, 0x61, 0x77, 0x74, 0x6e, 0x20,
0x74, 0x75, 0x66, 0x61, 0x74, 0x70, 0x61, 0x6d, 0x69, 0x6c, 0x61, 0x75, 0x75, 0x74, 0x75, 0x6b, 0x6f, 0x4b, 0x49, 0x13cc,
0x13be, 0x13b4, 0x4d, 0x75, 0x68, 0x69, 0x54, 0x4f, 0x4f, 0x75, 0x6c, 0x75, 0x63, 0x68, 0x65, 0x6c, 0x6f, 0x52, 0x168, 0x6b,
0x61, 0x72, 0x6f, 0x6f, 0x6e, 0x1c1, 0x67, 0x6f, 0x61, 0x67, 0x61, 0x73, 0x55, 0x68, 0x72, 0x20, 0x76, 0xf6, 0x72, 0x6d,
0x69, 0x64, 0x64, 0x61, 0x61, 0x63, 0x68, 0x73, 0x190, 0x6e, 0x6b, 0x61, 0x6b, 0x25b, 0x6e, 0x79, 0xe1, 0x4d, 0x75, 0x6e,
0x6b, 0x79, 0x6f, 0x69, 0x63, 0x68, 0x65, 0x68, 0x65, 0x61, 0x76, 0x6f, 0x54, 0x61, 0x70, 0x61, 0x72, 0x61, 0x63, 0x68,
0x75, 0x41, 0x64, 0x64, 0x75, 0x68, 0x61, 0x4f, 0x44, 0x5a, 0x64, 0x61, 0x74, 0x20, 0x61, 0x7a, 0x61, 0x6c, 0x6d, 0x61,
0x6b, 0x65, 0x6f, 0x92b, 0x941, 0x902, 0x44, 0x69, 0x6e, 0x64, 0x61, 0x6d, 0x6f, 0x69, 0x65, 0x73, 0x61, 0x2e, 0x67, 0x49,
0x20, 0x62, 0x69, 0x6b, 0x25b, 0x302, 0x67, 0x6c, 0xe0, 0x53, 0x75, 0x62, 0x62, 0x61, 0x61, 0x68, 0x69, 0x69, 0x64, 0x69,
0x253, 0x61, 0x6b, 0xed, 0x6b, 0xed, 0x72, 0xed, 0x67, 0x73, 0xe1, 0x72, 0xfa, 0x77, 0xe1, 0x77, 0x69, 0x63, 0x68, 0x69,
0x73, 0x68, 0x75, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6d, 0x61, 0x6e, 0xe1, 0x52, 0x57, 0x42d, 0x418, 0x4c, 0x77, 0x61, 0x6d,
0x69, 0x6c, 0x61, 0x77, 0x75, 0x6b, 0x69, 0x25b, 0x6d, 0x25b, 0x301, 0x25b, 0x6d, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x20, 0x6d,
0x61, 0xf1, 0x61, 0x6e, 0x61, 0x6d, 0x62, 0x61, 0xa78c, 0x6d, 0x62, 0x61, 0xa78c, 0x6d, 0x62, 0x61, 0x2bc, 0xe1, 0x6d, 0x62,
0x61, 0x2bc, 0x628, 0x2e, 0x646, 0x64, 0x6f, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x61, 0x69, 0x70, 0x2e
};

static const ushort pm_data[] = {
0x50, 0x4d, 0x57, 0x42, 0x6e, 0x6d, 0x2e, 0x65, 0x20, 0x70, 0x61, 0x73, 0x64, 0x69, 0x74, 0x65, 0x73, 0x12a8, 0x1230, 0x12d3,
0x1275, 0x645, 0x985, 0x9aa, 0x9f0, 0x9be, 0x9b9, 0x9cd, 0x9a8, 0x41f, 0x41c, 0xf55, 0xfb1, 0xf72, 0xf0b, 0xf46, 0xf0b, 0x47, 0x2e, 0x4d,
0x2e, 0x441, 0x43b, 0x2e, 0x43e, 0x431, 0x2e, 0x100a, 0x1014, 0x1031, 0x70, 0x2e, 0xa0, 0x6d, 0x2e, 0x4e0b, 0x5348, 0x6f, 0x64, 0x70,
0x2e, 0x70, 0x2e, 0x6d, 0x2e, 0x70, 0x6d, 0x70, 0x74, 0x6d, 0x69, 0x70, 0x2e, 0x73, 0x6f, 0x69, 0x72, 0x66, 0x3bc, 0x2e,
0x3bc, 0x2e, 0x59, 0x61, 0x6d, 0x6d, 0x61, 0x5d0, 0x5d7, 0x5d4, 0x5f4, 0x5e6, 0x64, 0x75, 0x2e, 0x65, 0x2e, 0x68, 0x2e, 0x69,
0x2e, 0x6e, 0x2e, 0x5348, 0x5f8c, 0x57, 0x65, 0x6e, 0x67, 0x69, 0xc85, 0xcaa, 0xcb0, 0xcbe, 0xcb9, 0xccd, 0xca8, 0x442, 0x4af, 0x448,
0x442, 0x4e9, 0x43d, 0x20, 0x43a, 0x438, 0x439, 0x438, 0x43d, 0x43a, 0x438, 0xc624, 0xd6c4, 0x50, 0x4e, 0x5a, 0x2e, 0x4d, 0x57, 0x2e,
0xeab, 0xebc, 0xeb1, 0xe87, 0xe97, 0xec8, 0xebd, 0xe87, 0x70, 0x113, 0x63, 0x70, 0x75, 0x73, 0x64, 0x69, 0x65, 0x6e, 0x101, 0x6d,
0x70, 0xf3, 0x6b, 0x77, 0x61, 0x70, 0x6f, 0x70, 0x69, 0x65, 0x74, 0x43f, 0x43e, 0x43f, 0x43b, 0x430, 0x434, 0x43d, 0x435, 0x50,
0x54, 0x47, 0x92e, 0x2e, 0x909, 0x2e, 0x4af, 0x2e, 0x445, 0x2e, 0x905, 0x92a, 0x930, 0x93e, 0x939, 0x94d, 0x928, 0x63a, 0x2e, 0x648,
0x2e, 0x628, 0x639, 0x62f, 0x627, 0x632, 0x638, 0x647, 0x631, 0x64, 0x61, 0x20, 0x74, 0x61, 0x72, 0x64, 0x65, 0xa2c, 0xa3e, 0x2e,
0xa26, 0xa41, 0x2e, 0x4c, 0x4b, 0x43f, 0x43e, 0x20, 0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x70, 0x6f, 0x20, 0x70, 0x6f, 0x64, 0x6e,
0x65, 0x4d5, 0x43c, 0x431, 0x438, 0x441, 0x431, 0x43e, 0x43d, 0x44b, 0x20, 0x444, 0x4d5, 0x441, 0x442, 0x4d5, 0x645, 0x646, 0x62c, 0x647,
0x646, 0x62f, 0x60c, 0x20, 0x634, 0x627, 0x645, 0xdb4, 0x2e, 0xdc0, 0x2e, 0x70, 0x6f, 0x70, 0x2e, 0x47, 0x44, 0x65, 0x6d, 0xbaa,
0xbbf, 0xbb1, 0xbcd, 0xbaa, 0xb95, 0xbb2, 0xbcd, 0xe2b, 0xe25, 0xe31, 0xe07, 0xe40, 0xe17, 0xe35, 0xe48, 0xe22, 0xe07, 0xf55, 0xfb1, 0xf72,
0xf0b, 0xf51, 0xfb2, 0xf7c, 0xf0b, 0x12f5, 0x1215, 0x122d, 0x20, 0x1230, 0x12d3, 0x1275, 0x65, 0x66, 0x69, 0x61, 0x66, 0x69, 0xd6, 0x53,
0x67, 0xfc, 0x6e, 0x6f, 0x72, 0x74, 0x61, 0x64, 0x61, 0x6e, 0x20, 0x73, 0x6f, 0x148, 0x686, 0x6c8, 0x634, 0x62a, 0x649, 0x646,
0x20, 0x643, 0x6d0, 0x64a, 0x649, 0x646, 0x43f, 0x43f, 0x54, 0x4b, 0x422, 0x41a, 0x43, 0x48, 0x79, 0x68, 0x4e, 0x67, 0x6f, 0x5e0,
0x5d0, 0x5b8, 0x5db, 0x5de, 0x5d9, 0x5d8, 0x5d0, 0x5b8, 0x5d2, 0x1ecc, 0x300, 0x73, 0xe1, 0x6e, 0x186, 0x300, 0x73, 0xe1, 0x6e, 0x65,
0x74, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x64, 0x64, 0x61, 0x67, 0x70, 0x6f, 0x70, 0x6f, 0x64, 0x6e, 0x65, 0x43f, 0x43e, 0x441,
0x43b, 0x438, 0x458, 0x435, 0x20, 0x43f, 0x43e, 0x434, 0x43d, 0x435, 0x45, 0x57, 0x4e, 0x2019, 0x61, 0x62, 0x61, 0x6c, 0x69, 0x128,
0x79, 0x61, 0x77, 0x129, 0x6f, 0x6f, 0x70, 0x2e, 0x263, 0x65, 0x74, 0x72, 0x254, 0x61, 0x6d, 0x20, 0x4e, 0x61, 0x6d, 0x69,
0x74, 0x74, 0x61, 0x67, 0xa06f, 0xa2d2, 0x65, 0x61, 0x68, 0x6b, 0x65, 0x74, 0x62, 0x65, 0x61, 0x69, 0x76, 0x65, 0x74, 0x65,
0x62, 0x4d, 0x6f, 0x67, 0x6c, 0x75, 0x6d, 0x61, 0x20, 0x6c, 0x77, 0x61, 0x20, 0x70, 0x6b, 0x69, 0x6b, 0x69, 0x69, 0x257,
0x65, 0x48, 0x77, 0x61, 0x129, 0x2d, 0x69, 0x6e, 0x129, 0x54, 0x65, 0x69, 0x70, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x6f, 0x74,
0x6f, 0x2d5c, 0x2d30, 0x2d37, 0x2d33, 0x2d33, 0x2d6f, 0x2d30, 0x2d5c, 0x74, 0x61, 0x64, 0x67, 0x67, 0x2b7, 0x61, 0x74, 0x6e, 0x20, 0x74,
0x6d, 0x65, 0x64, 0x64, 0x69, 0x74, 0x70, 0x61, 0x6d, 0x75, 0x6e, 0x79, 0x69, 0x6b, 0x79, 0x69, 0x75, 0x6b, 0x6f, 0x6e,
0x79, 0x69, 0x55, 0x54, 0x13d2, 0x13af, 0x13f1, 0x13a2, 0x13d7, 0x13e2, 0x43, 0x68, 0x69, 0x6c, 0x6f, 0x4d, 0x55, 0x55, 0x61, 0x6b,
0x61, 0x73, 0x75, 0x62, 0x61, 0x168, 0x47, 0x6b, 0x6f, 0x6f, 0x73, 0x6b, 0x6f, 0x6c, 0x69, 0x6e, 0x79, 0x1c3, 0x75, 0x69,
0x61, 0x73, 0x55, 0x68, 0x72, 0x20, 0x6e, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x61, 0x63, 0x68, 0x73, 0x190, 0x6e,
0x64, 0xe1, 0x6d, 0xe2, 0x45, 0x69, 0x67, 0x75, 0x6c, 0x6f, 0x69, 0x63, 0x68, 0x61, 0x6d, 0x74, 0x68, 0x69, 0x45, 0x62,
0x6f, 0x6e, 0x67, 0x69, 0x41, 0x6c, 0x75, 0x75, 0x6c, 0x61, 0x4f, 0x54, 0x1e0c, 0x65, 0x66, 0x66, 0x69, 0x72, 0x20, 0x61,
0x7a, 0x61, 0x6e, 0x79, 0x69, 0x61, 0x67, 0x68, 0x75, 0x6f, 0x92c, 0x947, 0x932, 0x93e, 0x938, 0x947, 0x44, 0x69, 0x6c, 0x6f,
0x6c, 0x6f, 0x6e, 0x6f, 0x6d, 0xeb, 0x74, 0x74, 0x65, 0x73, 0x61, 0x2e, 0x6b, 0x49, 0x20, 0x253, 0x75, 0x67, 0x61, 0x6a,
0x254, 0x70, 0x5a, 0x61, 0x61, 0x72, 0x69, 0x6b, 0x61, 0x79, 0x20, 0x62, 0x65, 0x62, 0x79, 0xe1, 0x6d, 0x75, 0x6e, 0x67,
0x259, 0x67, 0xf3, 0x67, 0x259, 0x6c, 0x65, 0x63, 0x25b, 0x25b, 0x301, 0x6e, 0x6b, 0x6f, 0x6d, 0x63, 0x68, 0x6f, 0x63, 0x68,
0x69, 0x6c, 0x2019, 0x6c, 0x6c, 0x69, 0x6c, 0x6c, 0x69, 0x6b, 0x75, 0x67, 0xfa, 0x54, 0x14a, 0x42d, 0x41a, 0x50, 0x61, 0x73,
0x68, 0x61, 0x6d, 0x69, 0x68, 0x65, 0x6b, 0x69, 0x73, 0x25b, 0x301, 0x6e, 0x64, 0x25b, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x20,
0x74, 0x61, 0x72, 0x64, 0x65, 0x14b, 0x6b, 0x61, 0x20, 0x6d, 0x62, 0x254, 0x301, 0x74, 0x20, 0x6e, 0x6a, 0x69, 0x6e, 0x63,
0x77, 0xf2, 0x6e, 0x7a, 0xe9, 0x6d, 0x62f, 0x2e, 0x646, 0x77, 0xf3, 0x74, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x61, 0x70,
0x6f, 0x70, 0x6f, 0x142, 0x64, 0x6e, 0x6a, 0x75, 0x65, 0x70, 0x2e
};

static const ushort currency_symbol_data[] = {
0x42, 0x72, 0x4b, 0x73, 0x68, 0x52, 0x24, 0x4c, 0x65, 0x6b, 0xeb, 0x64, 0x65, 0x6e, 0x20ac, 0x1265, 0x122d, 0x62c, 0x2e, 0x645,
0x2e, 0x200f, 0x62f, 0x2e, 0x62c, 0x2e, 0x200f, 0x62f, 0x2e, 0x628, 0x2e, 0x200f, 0x46, 0x43, 0x46, 0x41, 0x43, 0x46, 0x46, 0x64,
0x6a, 0x4e, 0x66, 0x6b, 0x62f, 0x2e, 0x639, 0x2e, 0x200f, 0x20aa, 0x62f, 0x2e, 0x623, 0x2e, 0x200f, 0x62f, 0x2e, 0x643, 0x2e, 0x200f,
0x644, 0x2e, 0x644, 0x2e, 0x200f, 0x62f, 0x2e, 0x644, 0x2e, 0x200f, 0x623, 0x2e, 0x645, 0x2e, 0x62f, 0x2e, 0x645, 0x2e, 0x200f, 0x631,
0x2e, 0x639, 0x2e, 0x200f, 0x631, 0x2e, 0x642, 0x2e, 0x200f, 0x631, 0x2e, 0x633, 0x2e, 0x200f, 0x53, 0x62c, 0x2e, 0x633, 0x2e, 0x644,
0x2e, 0x633, 0x2e, 0x200f, 0x62f, 0x2e, 0x62a, 0x2e, 0x200f, 0x62f, 0x2e, 0x625, 0x2e, 0x200f, 0x631, 0x2e, 0x64a, 0x2e, 0x200f, 0xa3,
0x58f, 0x20b9, 0x20bc, 0x20bd, 0x9f3, 0x4e, 0x75, 0x2e, 0x43b, 0x432, 0x2e, 0x4b, 0x17db, 0xa5, 0x48, 0x4b, 0x24, 0x4d, 0x4f, 0x50,
0x24, 0x48, 0x52, 0x4b, 0x4b, 0x4d, 0x4b, 0x10d, 0x6b, 0x72, 0x2e, 0x41, 0x66, 0x6c, 0x2e, 0x4e, 0x41, 0x66, 0x2e, 0x55,
0x53, 0x24, 0x50, 0x46, 0x42, 0x75, 0x44, 0x47, 0x48, 0x20b5, 0x41, 0x72, 0x4d, 0x4b, 0x52, 0x4d, 0x52, 0x73, 0x20a6, 0x20b1,
0x52, 0x46, 0x57, 0x53, 0x24, 0x53, 0x52, 0x4c, 0x65, 0x45, 0x6b, 0x72, 0x54, 0x53, 0x68, 0x54, 0x24, 0x55, 0x53, 0x68,
0x41, 0x45, 0x44, 0x56, 0x54, 0x44, 0x41, 0x43, 0x46, 0x41, 0x46, 0x43, 0x46, 0x43, 0x46, 0x50, 0x46, 0x47, 0x47, 0x55,
0x4d, 0x4d, 0x41, 0x44, 0x43, 0x48, 0x46, 0x4c, 0x53, 0x44, 0x54, 0x20be, 0x20b2, 0x46, 0x74, 0x49, 0x53, 0x4b, 0x52, 0x70,
0x43, 0x41, 0x24, 0xffe5, 0x20b8, 0x441, 0x43e, 0x43c, 0x20a9, 0x4b, 0x50, 0x57, 0x20ba, 0x20ad, 0x4b, 0x7a, 0x434, 0x435, 0x43d, 0x2e,
0x20ae, 0x43, 0x4e, 0xa5, 0x928, 0x947, 0x930, 0x942, 0x60b, 0x631, 0x6cc, 0x627, 0x644, 0x7a, 0x142, 0x52, 0x24, 0x200b, 0x4d, 0x54,
0x6e, 0x44, 0x62, 0x631, 0x53, 0x2f, 0x42, 0x73, 0x52, 0x4f, 0x4e, 0x4c, 0x20b4, 0x52, 0x53, 0x44, 0x41a, 0x41c, 0xdbb, 0xdd4,
0x2e, 0x20a1, 0x52, 0x44, 0x24, 0x51, 0x43, 0x24, 0x42, 0x2f, 0x2e, 0x47, 0x73, 0x2e, 0x42, 0x73, 0x2e, 0x53, 0x441, 0x43e,
0x43c, 0x2e, 0x52, 0x73, 0x2e, 0xe3f, 0x54, 0x4d, 0x54, 0x73, 0x6f, 0x2bb, 0x6d, 0x441, 0x45e, 0x43c, 0x20ab, 0x4e, 0x54, 0x24,
0x41, 0x24, 0x49, 0x52, 0x52
};

static const ushort currency_display_name_data[] = {
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x74, 0x6f, 0x6f, 0x70, 0x68, 0x69, 0x79, 0x61, 0x61, 0x20, 0x42, 0x69,
0x72, 0x72, 0x69, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66, 0x72, 0x69,
0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66,
0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x69,
0x64, 0x2d, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x4e, 0x61,
0x6d, 0x69, 0x62, 0x69, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69,
0x62, 0x69, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69,
0x62, 0x69, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x4c, 0x65, 0x6b, 0x75, 0x20, 0x73, 0x68,
0x71, 0x69, 0x70, 0x74, 0x61, 0x72, 0x3b, 0x3b, 0x6c, 0x65, 0x6b, 0x20, 0x73, 0x68, 0x71, 0x69, 0x70, 0x74, 0x61, 0x72,
0x3b, 0x3b, 0x3b, 0x3b, 0x6c, 0x65, 0x6b, 0xeb, 0x20, 0x73, 0x68, 0x71, 0x69, 0x70, 0x74, 0x61, 0x72, 0x3b, 0x44, 0x65,
0x6e, 0x61, 0x72, 0x69, 0x20, 0x6d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x61, 0x73, 0x3b, 0x3b, 0x64, 0x65, 0x6e, 0x61,
0x72, 0x20, 0x6d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x61, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x65, 0x6e, 0x61, 0x72,
0xeb, 0x20, 0x6d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x61, 0x73, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x6a, 0x61, 0x3b, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20,
0x1265, 0x122d, 0x3b, 0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x3b, 0x3b, 0x3b, 0x12e8, 0x12a2, 0x1275,
0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a,
0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62c, 0x646, 0x64a,
0x647, 0x627, 0x646, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x627, 0x62a, 0x20, 0x645, 0x635,
0x631, 0x64a, 0x629, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x64b, 0x627, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x64b, 0x627, 0x3b, 0x62c, 0x646,
0x64a, 0x647, 0x20, 0x645, 0x635, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627, 0x646, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631,
0x64a, 0x627, 0x646, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627, 0x62a, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x629, 0x3b,
0x62f, 0x64a, 0x646, 0x627, 0x631, 0x64b, 0x627, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x64b, 0x627, 0x3b, 0x62f, 0x64a, 0x646,
0x627, 0x631, 0x20, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a,
0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627,
0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x628, 0x62d, 0x631, 0x64a, 0x646, 0x64a,
0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646,
0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633,
0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641,
0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a,
0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646,
0x643, 0x20, 0x648, 0x633, 0x637, 0x20, 0x623, 0x641, 0x631, 0x64a, 0x642, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632,
0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642,
0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631,
0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632,
0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642,
0x645, 0x631, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x3b, 0x641, 0x631,
0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a,
0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c,
0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631,
0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a, 0x3b, 0x641, 0x631, 0x646, 0x643, 0x20, 0x62c, 0x64a, 0x628, 0x648, 0x62a,
0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627,
0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a,
0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20,
0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b,
0x646, 0x627, 0x643, 0x641, 0x627, 0x20, 0x623, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639,
0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646,
0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639,
0x631, 0x627, 0x642, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x639, 0x631, 0x627, 0x642, 0x64a, 0x3b, 0x634, 0x64a, 0x643,
0x644, 0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644,
0x20, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20,
0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625,
0x633, 0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633,
0x631, 0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631,
0x627, 0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x634, 0x64a, 0x643, 0x644, 0x20, 0x625, 0x633, 0x631, 0x627,
0x626, 0x64a, 0x644, 0x64a, 0x20, 0x62c, 0x62f, 0x64a, 0x62f, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x623, 0x631, 0x62f, 0x646, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20,
0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x643, 0x648, 0x64a, 0x62a, 0x64a, 0x3b, 0x62c, 0x646,
0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646,
0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644,
0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646,
0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x644, 0x628, 0x646, 0x627, 0x646,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644,
0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631,
0x627, 0x646, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x627, 0x646, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627, 0x62a, 0x20, 0x644, 0x64a,
0x628, 0x64a, 0x629, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x64b, 0x627, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x64b, 0x627, 0x3b, 0x62f,
0x64a, 0x646, 0x627, 0x631, 0x20, 0x644, 0x64a, 0x628, 0x64a, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a,
0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a,
0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648,
0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20,
0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a,
0x62a, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x623, 0x648, 0x642, 0x64a, 0x629, 0x20, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a,
0x629, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a,
0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x627,
0x646, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x627, 0x646, 0x3b, 0x62f, 0x631, 0x627, 0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628,
0x64a, 0x629, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x64b, 0x627, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x64b, 0x627, 0x3b, 0x62f, 0x631,
0x647, 0x645, 0x20, 0x645, 0x63a, 0x631, 0x628, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b,
0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646,
0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645,
0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20,
0x639, 0x645, 0x627, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644,
0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644,
0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644,
0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x642, 0x637, 0x631, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644,
0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a,
0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b,
0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f,
0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645,
0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635,
0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646,
0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634, 0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x634,
0x644, 0x646, 0x20, 0x635, 0x648, 0x645, 0x627, 0x644, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646,
0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633,
0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x3b, 0x62c, 0x646,
0x64a, 0x647, 0x627, 0x62a, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x629, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x64b, 0x627, 0x20,
0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a, 0x64b, 0x627, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x64a,
0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631,
0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633,
0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629,
0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x644, 0x64a, 0x631, 0x629, 0x20, 0x633, 0x648, 0x631, 0x64a, 0x629, 0x3b, 0x62f, 0x64a,
0x646, 0x627, 0x631, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62a, 0x648, 0x646, 0x633,
0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627,
0x646, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x627, 0x646, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x627, 0x62a, 0x20, 0x62a, 0x648,
0x646, 0x633, 0x64a, 0x629, 0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x64b, 0x627, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x64b, 0x627,
0x3b, 0x62f, 0x64a, 0x646, 0x627, 0x631, 0x20, 0x62a, 0x648, 0x646, 0x633, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645,
0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f,
0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627,
0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631,
0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x64a, 0x3b, 0x62f, 0x631, 0x647, 0x645, 0x20, 0x625, 0x645, 0x627, 0x631,
0x627, 0x62a, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a,
0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a,
0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a,
0x645, 0x646, 0x64a, 0x3b, 0x631, 0x64a, 0x627, 0x644, 0x20, 0x64a, 0x645, 0x646, 0x64a, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c,
0x646, 0x648, 0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648,
0x628, 0x20, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20,
0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x627, 0x646, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20,
0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x627, 0x62a, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20,
0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x64b, 0x627, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20,
0x627, 0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x62c, 0x646, 0x64a, 0x647, 0x20, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627, 0x644,
0x633, 0x648, 0x62f, 0x627, 0x646, 0x3b, 0x570, 0x561, 0x575, 0x56f, 0x561, 0x56f, 0x561, 0x576, 0x20, 0x564, 0x580, 0x561, 0x574, 0x3b,
0x3b, 0x570, 0x561, 0x575, 0x56f, 0x561, 0x56f, 0x561, 0x576, 0x20, 0x564, 0x580, 0x561, 0x574, 0x3b, 0x3b, 0x3b, 0x3b, 0x570, 0x561,
0x575, 0x56f, 0x561, 0x56f, 0x561, 0x576, 0x20, 0x564, 0x580, 0x561, 0x574, 0x3b, 0x9ad, 0x9be, 0x9f0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20,
0x9f0, 0x9c1, 0x9aa, 0x9c0, 0x3b, 0x3b, 0x9ad, 0x9be, 0x9f0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9f0, 0x9c1, 0x9aa, 0x9c0, 0x3b, 0x3b,
0x3b, 0x3b, 0x9ad, 0x9be, 0x9f0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9f0, 0x9c1, 0x9aa, 0x9c0, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62,
0x61, 0x79, 0x63, 0x61, 0x6e, 0x20, 0x4d, 0x61, 0x6e, 0x61, 0x74, 0x131, 0x3b, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61,
0x79, 0x63, 0x61, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x74, 0x131, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x7a, 0x259, 0x72, 0x62,
0x61, 0x79, 0x63, 0x61, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x74, 0x131, 0x3b, 0x43c, 0x430, 0x43d, 0x430, 0x442, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x61, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be, 0x995, 0x9be, 0x3b,
0x3b, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be, 0x995, 0x9be, 0x3b, 0x3b, 0x3b, 0x3b, 0x9ac,
0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9c0, 0x20, 0x99f, 0x9be, 0x995, 0x9be, 0x3b, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af,
0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa, 0x9bf, 0x3b, 0x3b, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa, 0x9bf,
0x3b, 0x3b, 0x3b, 0x3b, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0x9c0, 0x9af, 0x9bc, 0x20, 0x9b0, 0x9c1, 0x9aa, 0x9bf, 0x3b, 0xf51, 0xf44, 0xf74,
0xf63, 0xf0b, 0xf40, 0xfb2, 0xf58, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75,
0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x61, 0x20, 0x65, 0x75, 0x72, 0x6f, 0x69,
0x6f, 0xf9, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x411, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435,
0x432, 0x3b, 0x3b, 0x431, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x3b, 0x3b, 0x3b, 0x3b,
0x431, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x20, 0x43b, 0x435, 0x432, 0x430, 0x3b, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019,
0x102c, 0x20, 0x1000, 0x103b, 0x1015, 0x103a, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019, 0x102c, 0x20, 0x1000,
0x103b, 0x1015, 0x103a, 0x3b, 0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x20, 0x440, 0x443, 0x431, 0x435, 0x43b, 0x44c,
0x3b, 0x3b, 0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x20, 0x440, 0x443, 0x431, 0x435, 0x43b, 0x44c, 0x3b, 0x3b,
0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x44f, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x456, 0x3b, 0x431, 0x435, 0x43b,
0x430, 0x440, 0x443, 0x441, 0x43a, 0x456, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x451, 0x45e, 0x3b, 0x431, 0x435, 0x43b, 0x430, 0x440,
0x443, 0x441, 0x43a, 0x430, 0x433, 0x430, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x179a, 0x17c0, 0x179b, 0x200b, 0x1780, 0x1798, 0x17d2,
0x1796, 0x17bb, 0x1787, 0x17b6, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x179a, 0x17c0, 0x179b, 0x200b, 0x1780, 0x1798, 0x17d2, 0x1796, 0x17bb, 0x1787,
0x17b6, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x73, 0x3b, 0x4eba, 0x6c11, 0x5e01, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4eba, 0x6c11, 0x5e01, 0x3b, 0x6e2f, 0x5143, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x6e2f, 0x5143, 0x3b, 0x6fb3, 0x95e8, 0x5e01, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6fb3, 0x95e8, 0x5143, 0x3b, 0x65b0,
0x52a0, 0x5761, 0x5143, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65b0, 0x52a0, 0x5761, 0x5143, 0x3b, 0x6fb3, 0x9580, 0x5143, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x6fb3, 0x9580, 0x5143, 0x3b, 0x65b0, 0x53f0, 0x5e63, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65b0, 0x53f0, 0x5e63, 0x3b,
0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x61, 0x20, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x68, 0x72, 0x76, 0x61, 0x74,
0x73, 0x6b, 0x61, 0x20, 0x6b, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x65, 0x20, 0x6b,
0x75, 0x6e, 0x65, 0x3b, 0x3b, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x69, 0x68, 0x20, 0x6b, 0x75, 0x6e, 0x61, 0x3b,
0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b,
0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61,
0x3b, 0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x6b,
0x65, 0x3b, 0x3b, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x69, 0x68, 0x20, 0x6d, 0x61,
0x72, 0x61, 0x6b, 0x61, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe1, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x10d,
0x65, 0x73, 0x6b, 0xe1, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x61, 0x3b, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe9, 0x20, 0x6b,
0x6f, 0x72, 0x75, 0x6e, 0x79, 0x3b, 0x10d, 0x65, 0x73, 0x6b, 0xe9, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x79, 0x3b, 0x10d,
0x65, 0x73, 0x6b, 0xfd, 0x63, 0x68, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x6e, 0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x20, 0x6b,
0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b,
0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b,
0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x41, 0x72, 0x75, 0x62, 0x61, 0x61,
0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x3b, 0x41, 0x72, 0x75, 0x62, 0x61, 0x61, 0x6e, 0x73,
0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x72, 0x75, 0x62, 0x61, 0x61, 0x6e, 0x73,
0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x2d,
0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b,
0x3b, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x2d, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x69, 0x61,
0x61, 0x6e, 0x73, 0x65, 0x20, 0x67, 0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x65, 0x64, 0x65, 0x72,
0x6c, 0x61, 0x6e, 0x64, 0x73, 0x2d, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x67,
0x75, 0x6c, 0x64, 0x65, 0x6e, 0x3b, 0x53, 0x75, 0x72, 0x69, 0x6e, 0x61, 0x61, 0x6d, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c,
0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53, 0x75, 0x72, 0x69, 0x6e, 0x61, 0x61, 0x6d, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x72, 0x69, 0x6e, 0x61, 0x61, 0x6d, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c,
0x6c, 0x61, 0x72, 0x3b, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x55, 0x53, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x64,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b,
0x45, 0x61, 0x73, 0x74, 0x20, 0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x3b, 0x3b, 0x45, 0x61, 0x73, 0x74, 0x20, 0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65, 0x61, 0x6e, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x61, 0x73, 0x74, 0x20, 0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65,
0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61,
0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x6e,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61,
0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x73, 0x3b, 0x42, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x61, 0x6e, 0x20, 0x44,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x42, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x61, 0x68, 0x61, 0x6d, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x73, 0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b,
0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b,
0x3b, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42,
0x65, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x3b, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b,
0x3b, 0x3b, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x42,
0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e, 0x61, 0x6e, 0x20, 0x50, 0x75, 0x6c, 0x61, 0x3b, 0x3b, 0x42, 0x6f, 0x74, 0x73, 0x77,
0x61, 0x6e, 0x61, 0x6e, 0x20, 0x70, 0x75, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e,
0x61, 0x6e, 0x20, 0x70, 0x75, 0x6c, 0x61, 0x73, 0x3b, 0x42, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x46,
0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x42, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x73, 0x3b, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x43, 0x46,
0x41, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x20, 0x41, 0x66, 0x72,
0x69, 0x63, 0x61, 0x6e, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x65,
0x6e, 0x74, 0x72, 0x61, 0x6c, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x73, 0x3b, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72,
0x3b, 0x3b, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b,
0x3b, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x43, 0x61,
0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b,
0x3b, 0x43, 0x61, 0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x61, 0x79, 0x6d, 0x61, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64,
0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e, 0x64,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61,
0x6e, 0x64, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x44, 0x61, 0x6e, 0x69, 0x73, 0x68, 0x20, 0x4b, 0x72,
0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x44, 0x61, 0x6e, 0x69, 0x73, 0x68, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b,
0x3b, 0x44, 0x61, 0x6e, 0x69, 0x73, 0x68, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0x45, 0x72, 0x69, 0x74, 0x72,
0x65, 0x61, 0x6e, 0x20, 0x4e, 0x61, 0x6b, 0x66, 0x61, 0x3b, 0x3b, 0x45, 0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x6e, 0x20,
0x6e, 0x61, 0x6b, 0x66, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x6e, 0x20, 0x6e, 0x61,
0x6b, 0x66, 0x61, 0x73, 0x3b, 0x46, 0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x46, 0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x73,
0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x61, 0x6c, 0x6b, 0x6c,
0x61, 0x6e, 0x64, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x46,
0x69, 0x6a, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x46, 0x69, 0x6a, 0x69, 0x61, 0x6e,
0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x69, 0x6a, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x55, 0x4b, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x55, 0x4b, 0x20, 0x70,
0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x4b, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x47, 0x61,
0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x3b, 0x3b, 0x47, 0x61, 0x6d, 0x62, 0x69, 0x61,
0x6e, 0x20, 0x64, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20,
0x64, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x73, 0x3b, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x69, 0x61, 0x6e, 0x20, 0x43, 0x65, 0x64,
0x69, 0x3b, 0x3b, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x69, 0x61, 0x6e, 0x20, 0x63, 0x65, 0x64, 0x69, 0x3b, 0x3b, 0x3b, 0x3b,
0x47, 0x68, 0x61, 0x6e, 0x61, 0x69, 0x61, 0x6e, 0x20, 0x63, 0x65, 0x64, 0x69, 0x73, 0x3b, 0x47, 0x69, 0x62, 0x72, 0x61,
0x6c, 0x74, 0x61, 0x72, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x47, 0x69, 0x62, 0x72, 0x61, 0x6c, 0x74, 0x61,
0x72, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x69, 0x62, 0x72, 0x61, 0x6c, 0x74, 0x61, 0x72,
0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65, 0x20, 0x44, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x65, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x73, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72,
0x3b, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b,
0x3b, 0x3b, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b,
0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e,
0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70,
0x65, 0x65, 0x73, 0x3b, 0x49, 0x73, 0x72, 0x61, 0x65, 0x6c, 0x69, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x53, 0x68, 0x65, 0x6b,
0x65, 0x6c, 0x3b, 0x3b, 0x49, 0x73, 0x72, 0x61, 0x65, 0x6c, 0x69, 0x20, 0x6e, 0x65, 0x77, 0x20, 0x73, 0x68, 0x65, 0x6b,
0x65, 0x6c, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x73, 0x72, 0x61, 0x65, 0x6c, 0x69, 0x20, 0x6e, 0x65, 0x77, 0x20, 0x73, 0x68,
0x65, 0x6b, 0x65, 0x6c, 0x73, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61,
0x72, 0x3b, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b,
0x3b, 0x3b, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4b,
0x65, 0x6e, 0x79, 0x61, 0x6e, 0x20, 0x53, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x4b, 0x65, 0x6e, 0x79,
0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x4b, 0x65, 0x6e, 0x79, 0x61,
0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66,
0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66,
0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20,
0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x3b, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61,
0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x64,
0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f,
0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4d, 0x61, 0x63, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x50, 0x61, 0x74, 0x61, 0x63,
0x61, 0x3b, 0x3b, 0x4d, 0x61, 0x63, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x61, 0x74, 0x61, 0x63, 0x61, 0x3b, 0x3b,
0x3b, 0x3b, 0x4d, 0x61, 0x63, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x61, 0x74, 0x61, 0x63, 0x61, 0x73, 0x3b, 0x4d,
0x61, 0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x20, 0x41, 0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61,
0x67, 0x61, 0x73, 0x79, 0x20, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x67,
0x61, 0x73, 0x79, 0x20, 0x61, 0x72, 0x69, 0x61, 0x72, 0x69, 0x65, 0x73, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x61,
0x6e, 0x20, 0x4b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x61, 0x6e, 0x20, 0x6b,
0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x61, 0x6e, 0x20, 0x6b, 0x77,
0x61, 0x63, 0x68, 0x61, 0x73, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x69, 0x6e, 0x67,
0x67, 0x69, 0x74, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x69, 0x6e, 0x67, 0x67,
0x69, 0x74, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x69, 0x6e, 0x67,
0x67, 0x69, 0x74, 0x73, 0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65,
0x3b, 0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b,
0x3b, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x4e, 0x61,
0x6d, 0x69, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62,
0x69, 0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69,
0x61, 0x6e, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20,
0x4e, 0x61, 0x69, 0x72, 0x61, 0x3b, 0x3b, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x6e, 0x61, 0x69, 0x72,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x6e, 0x61, 0x69, 0x72, 0x61, 0x73,
0x3b, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x52, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x50, 0x61,
0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x6b,
0x69, 0x73, 0x74, 0x61, 0x6e, 0x69, 0x20, 0x72, 0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x50, 0x61, 0x70, 0x75, 0x61, 0x20,
0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x4b, 0x69, 0x6e, 0x61, 0x3b, 0x3b, 0x50, 0x61,
0x70, 0x75, 0x61, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x6b, 0x69, 0x6e, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x70, 0x75, 0x61, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61,
0x6e, 0x20, 0x6b, 0x69, 0x6e, 0x61, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x50, 0x69,
0x73, 0x6f, 0x3b, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x70, 0x69, 0x73, 0x6f, 0x3b,
0x3b, 0x3b, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x20, 0x70, 0x69, 0x73, 0x6f, 0x73, 0x3b,
0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x52, 0x77, 0x61, 0x6e, 0x64,
0x61, 0x6e, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x3b, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x6e, 0x20, 0x54, 0x61, 0x6c, 0x61, 0x3b, 0x3b,
0x53, 0x61, 0x6d, 0x6f, 0x61, 0x6e, 0x20, 0x74, 0x61, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x61, 0x6d, 0x6f, 0x61,
0x6e, 0x20, 0x74, 0x61, 0x6c, 0x61, 0x3b, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x69, 0x73, 0x20, 0x52,
0x75, 0x70, 0x65, 0x65, 0x3b, 0x3b, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x69, 0x73, 0x20, 0x72, 0x75,
0x70, 0x65, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x69, 0x73, 0x20, 0x72,
0x75, 0x70, 0x65, 0x65, 0x73, 0x3b, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x61, 0x6e,
0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65,
0x61, 0x6e, 0x20, 0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c,
0x65, 0x6f, 0x6e, 0x65, 0x61, 0x6e, 0x20, 0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x73, 0x3b, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70,
0x6f, 0x72, 0x65, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72,
0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x6f, 0x72,
0x65, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x49, 0x73,
0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f,
0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b,
0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x73, 0x3b, 0x53, 0x74, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b,
0x3b, 0x53, 0x74, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b,
0x53, 0x74, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x53, 0x75, 0x64,
0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73,
0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20,
0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x20, 0x4c, 0x69, 0x6c, 0x61, 0x6e, 0x67, 0x65,
0x6e, 0x69, 0x3b, 0x3b, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x20, 0x6c, 0x69, 0x6c, 0x61, 0x6e, 0x67, 0x65, 0x6e, 0x69, 0x3b,
0x3b, 0x3b, 0x3b, 0x53, 0x77, 0x61, 0x7a, 0x69, 0x20, 0x65, 0x6d, 0x61, 0x6c, 0x61, 0x6e, 0x67, 0x65, 0x6e, 0x69, 0x3b,
0x53, 0x77, 0x65, 0x64, 0x69, 0x73, 0x68, 0x20, 0x4b, 0x72, 0x6f, 0x6e, 0x61, 0x3b, 0x3b, 0x53, 0x77, 0x65, 0x64, 0x69,
0x73, 0x68, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x77, 0x65, 0x64, 0x69, 0x73, 0x68, 0x20,
0x6b, 0x72, 0x6f, 0x6e, 0x6f, 0x72, 0x3b, 0x53, 0x77, 0x69, 0x73, 0x73, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b,
0x53, 0x77, 0x69, 0x73, 0x73, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x77, 0x69, 0x73, 0x73,
0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x3b, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x6e, 0x20, 0x53, 0x68,
0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x6e, 0x20, 0x73, 0x68,
0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x6e, 0x20,
0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20, 0x50, 0x61, 0x2bb,
0x61, 0x6e, 0x67, 0x61, 0x3b, 0x3b, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20, 0x70, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0x6f, 0x6e, 0x67, 0x61, 0x6e, 0x20, 0x70, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x3b, 0x54,
0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20, 0x44, 0x6f, 0x6c,
0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61,
0x67, 0x6f, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61,
0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x20, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x3b, 0x55,
0x67, 0x61, 0x6e, 0x64, 0x61, 0x6e, 0x20, 0x53, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x55, 0x67, 0x61,
0x6e, 0x64, 0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x67, 0x61,
0x6e, 0x64, 0x61, 0x6e, 0x20, 0x73, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x3b, 0x55, 0x6e, 0x69, 0x74, 0x65,
0x64, 0x20, 0x41, 0x72, 0x61, 0x62, 0x20, 0x45, 0x6d, 0x69, 0x72, 0x61, 0x74, 0x65, 0x73, 0x20, 0x44, 0x69, 0x72, 0x68,
0x61, 0x6d, 0x3b, 0x3b, 0x55, 0x41, 0x45, 0x20, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x41,
0x45, 0x20, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x73, 0x3b, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x50, 0x6f,
0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b,
0x3b, 0x3b, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x56, 0x61, 0x6e,
0x75, 0x61, 0x74, 0x75, 0x20, 0x56, 0x61, 0x74, 0x75, 0x3b, 0x3b, 0x56, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x20, 0x76,
0x61, 0x74, 0x75, 0x3b, 0x3b, 0x3b, 0x3b, 0x56, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x74, 0x75, 0x73,
0x3b, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x6e, 0x20, 0x4b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x5a, 0x61, 0x6d,
0x62, 0x69, 0x61, 0x6e, 0x20, 0x6b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x5a, 0x61, 0x6d, 0x62, 0x69,
0x61, 0x6e, 0x20, 0x6b, 0x77, 0x61, 0x63, 0x68, 0x61, 0x73, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53, 0x75, 0x64,
0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x50, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53,
0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6f, 0x75,
0x74, 0x68, 0x20, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x20, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x3b, 0x4e,
0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x6e,
0x20, 0x47, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x3b, 0x3b, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x20, 0x41, 0x6e, 0x74, 0x69, 0x6c, 0x6c, 0x65, 0x61, 0x6e, 0x20, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x3b,
0x3b, 0x3b, 0x3b, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x41, 0x6e, 0x74, 0x69, 0x6c,
0x6c, 0x65, 0x61, 0x6e, 0x20, 0x67, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x74, 0x3b, 0x64, 0x6f, 0x6e, 0x73, 0x6b, 0x20,
0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0x64, 0x6f, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b,
0x3b, 0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x61, 0x72, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x75, 0x72, 0x3b, 0x65, 0x75, 0x72,
0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x61, 0x3b, 0x64, 0x69, 0x6e,
0x61, 0x72, 0x20, 0x61, 0x6c, 0x67, 0xe9, 0x72, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x61,
0x6c, 0x67, 0xe9, 0x72, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x73, 0x20, 0x61, 0x6c,
0x67, 0xe9, 0x72, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42,
0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43,
0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28,
0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x61,
0x69, 0x73, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b,
0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x64, 0x6f, 0x6c, 0x6c,
0x61, 0x72, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x20,
0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x73, 0x20,
0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6d, 0x6f,
0x72, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x6e,
0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x73,
0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x69, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20,
0x64, 0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x64, 0x6a,
0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x64,
0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x50,
0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x50, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63,
0x73, 0x20, 0x43, 0x46, 0x50, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e, 0x3b,
0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x73, 0x20, 0x67, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x6e, 0x73, 0x3b, 0x67, 0x6f, 0x75, 0x72, 0x64, 0x65,
0x20, 0x68, 0x61, 0xef, 0x74, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x67, 0x6f, 0x75, 0x72, 0x64, 0x65, 0x20, 0x68,
0x61, 0xef, 0x74, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x67, 0x6f, 0x75, 0x72, 0x64, 0x65, 0x73, 0x20,
0x68, 0x61, 0xef, 0x74, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x73, 0x3b, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x20, 0x6d, 0x61,
0x6c, 0x67, 0x61, 0x63, 0x68, 0x65, 0x3b, 0x3b, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61,
0x63, 0x68, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x61, 0x72, 0x69, 0x61, 0x72, 0x79, 0x73, 0x20, 0x6d, 0x61, 0x6c, 0x67, 0x61,
0x63, 0x68, 0x65, 0x73, 0x3b, 0x6f, 0x75, 0x67, 0x75, 0x69, 0x79, 0x61, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x74, 0x61,
0x6e, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x6f, 0x75, 0x67, 0x75, 0x69, 0x79, 0x61, 0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x74,
0x61, 0x6e, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x6f, 0x75, 0x67, 0x75, 0x69, 0x79, 0x61, 0x73, 0x20, 0x6d, 0x61,
0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x20, 0x6d, 0x61,
0x75, 0x72, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x20, 0x6d, 0x61,
0x75, 0x72, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x73,
0x20, 0x6d, 0x61, 0x75, 0x72, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d,
0x20, 0x6d, 0x61, 0x72, 0x6f, 0x63, 0x61, 0x69, 0x6e, 0x3b, 0x3b, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x20, 0x6d, 0x61,
0x72, 0x6f, 0x63, 0x61, 0x69, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x69, 0x72, 0x68, 0x61, 0x6d, 0x73, 0x20, 0x6d, 0x61,
0x72, 0x6f, 0x63, 0x61, 0x69, 0x6e, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61,
0x69, 0x73, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x3b,
0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x69, 0x73, 0x3b, 0x72, 0x6f,
0x75, 0x70, 0x69, 0x65, 0x20, 0x64, 0x65, 0x73, 0x20, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x65, 0x73, 0x3b,
0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x20, 0x64, 0x65, 0x73, 0x20, 0x53, 0x65, 0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c,
0x65, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x65, 0x73, 0x20, 0x64, 0x65, 0x73, 0x20, 0x53, 0x65,
0x79, 0x63, 0x68, 0x65, 0x6c, 0x6c, 0x65, 0x73, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73,
0x65, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x66,
0x72, 0x61, 0x6e, 0x63, 0x73, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x73, 0x3b, 0x6c, 0x69, 0x76, 0x72, 0x65, 0x20,
0x73, 0x79, 0x72, 0x69, 0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x6c, 0x69, 0x76, 0x72, 0x65, 0x20, 0x73, 0x79, 0x72, 0x69,
0x65, 0x6e, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x6c, 0x69, 0x76, 0x72, 0x65, 0x73, 0x20, 0x73, 0x79, 0x72, 0x69, 0x65,
0x6e, 0x6e, 0x65, 0x73, 0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x74, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x3b,
0x3b, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x74, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x64,
0x69, 0x6e, 0x61, 0x72, 0x73, 0x20, 0x74, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x73, 0x3b, 0x76, 0x61, 0x74, 0x75,
0x20, 0x76, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x61, 0x6e, 0x3b, 0x3b, 0x76, 0x61, 0x74, 0x75, 0x20, 0x76, 0x61, 0x6e,
0x75, 0x61, 0x74, 0x75, 0x61, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x76, 0x61, 0x74, 0x75, 0x73, 0x20, 0x76, 0x61, 0x6e, 0x75,
0x61, 0x74, 0x75, 0x61, 0x6e, 0x73, 0x3b, 0x50, 0x75, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61,
0x63, 0x68, 0x3b, 0x3b, 0x70, 0x68, 0x75, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68,
0x3b, 0x70, 0x68, 0x75, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x70, 0x75,
0x69, 0x6e, 0x6e, 0x64, 0x20, 0x53, 0x68, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x3b, 0x70, 0x75, 0x6e,
0x6e, 0x64, 0x20, 0x53, 0x61, 0x73, 0x61, 0x6e, 0x6e, 0x61, 0x63, 0x68, 0x3b, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8,
0x20, 0x10da, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x3b, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x20, 0x10da, 0x10d0, 0x10e0, 0x10d8, 0x3b,
0x3b, 0x3b, 0x3b, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8, 0x20, 0x10da, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x45, 0x75, 0x72, 0x6f,
0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x65,
0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x65, 0x69,
0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x63, 0x68, 0x77, 0x65,
0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x6e, 0x3b, 0x395, 0x3c5, 0x3c1, 0x3ce, 0x3b, 0x3b, 0x3b5,
0x3c5, 0x3c1, 0x3ce, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b5, 0x3c5, 0x3c1, 0x3ce, 0x3b, 0x64, 0x61, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x69,
0x6d, 0x75, 0x74, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x3b, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x69, 0x6e,
0x75, 0x74, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0x61, 0x6e, 0x6d, 0x61, 0x72,
0x6b, 0x69, 0x6d, 0x75, 0x74, 0x20, 0x6b, 0x6f, 0x72, 0x75, 0x75, 0x6e, 0x69, 0x3b, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0, 0xaaf,
0x20, 0xab0, 0xac2, 0xaaa, 0xabf, 0xaaf, 0xabe, 0x3b, 0x3b, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0, 0xaaf, 0x20, 0xab0, 0xac2, 0xaaa, 0xabf,
0xaaf, 0xabe, 0x3b, 0x3b, 0x3b, 0x3b, 0xaad, 0xabe, 0xab0, 0xaa4, 0xac0, 0xaaf, 0x20, 0xab0, 0xac2, 0xaaa, 0xabf, 0xaaf, 0xabe, 0x3b,
0x4e, 0x61, 0x69, 0x72, 0x61, 0x72, 0x20, 0x4e, 0x61, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x3b, 0x3b, 0x4e, 0x61, 0x69,
0x72, 0x61, 0x72, 0x20, 0x4e, 0x61, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61, 0x69, 0x72,
0x6f, 0x72, 0x69, 0x6e, 0x20, 0x4e, 0x61, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x3b, 0x4b, 0x75, 0x257, 0x69, 0x6e, 0x20,
0x53, 0x65, 0x66, 0x61, 0x20, 0x6e, 0x61, 0x20, 0x41, 0x66, 0x69, 0x72, 0x6b, 0x61, 0x20, 0x54, 0x61, 0x20, 0x59, 0x61,
0x6d, 0x6d, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x3b, 0x3b, 0x5e9,
0x5e7, 0x5dc, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b, 0x3b,
0x5e9, 0x5e7, 0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7, 0x5d3, 0x5e9, 0x5d9, 0x5dd, 0x3b, 0x5e9, 0x5e7, 0x5dc, 0x5d9, 0x5dd, 0x20, 0x5d7, 0x5d3,
0x5e9, 0x5d9, 0x5dd, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e,
0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f,
0x20, 0x930, 0x941, 0x92a, 0x90f, 0x3b, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x69, 0x6e, 0x74, 0x3b,
0x3b, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x69, 0x6e, 0x74, 0x3b, 0x3b, 0x3b, 0x3b, 0x6d, 0x61,
0x67, 0x79, 0x61, 0x72, 0x20, 0x66, 0x6f, 0x72, 0x69, 0x6e, 0x74, 0x3b, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x20,
0x6b, 0x72, 0xf3, 0x6e, 0x61, 0x3b, 0x3b, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x61, 0x72, 0x20, 0x6b, 0x72, 0xf3, 0x6e, 0x75, 0x72,
0x3b, 0x52, 0x75, 0x70, 0x69, 0x61, 0x68, 0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x52, 0x75, 0x70, 0x69, 0x61, 0x68, 0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x3b,
0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x50, 0x75, 0x6e, 0x74, 0x20, 0x53, 0x74, 0x65, 0x69,
0x72, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x3b, 0x70, 0x68, 0x75, 0x6e, 0x74, 0x20, 0x73, 0x74, 0x65, 0x69, 0x72, 0x6c, 0x69,
0x6e, 0x67, 0x3b, 0x70, 0x68, 0x75, 0x6e, 0x74, 0x20, 0x73, 0x74, 0x65, 0x69, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x70,
0x68, 0x75, 0x6e, 0x74, 0x20, 0x73, 0x74, 0x65, 0x69, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x62, 0x70, 0x75, 0x6e, 0x74,
0x20, 0x73, 0x74, 0x65, 0x69, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x70, 0x75, 0x6e, 0x74, 0x20, 0x73, 0x74, 0x65, 0x69,
0x72, 0x6c, 0x69, 0x6e, 0x67, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x6f,
0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x6f, 0x3b, 0x3b, 0x3b,
0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x69, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x69, 0x3b, 0x65e5, 0x672c,
0x5186, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x5186, 0x3b, 0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0, 0xcc2, 0xcaa, 0xcbe,
0xcaf, 0xcbf, 0x3b, 0x3b, 0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0, 0xcc2, 0xcaa, 0xcbe, 0xcaf, 0xcbf, 0x3b, 0x3b, 0x3b,
0x3b, 0xcad, 0xcbe, 0xcb0, 0xca4, 0xcc0, 0xcaf, 0x20, 0xcb0, 0xcc2, 0xcaa, 0xcbe, 0xcaf, 0xcbf, 0xc97, 0xcb3, 0xcc1, 0x3b, 0x6c1, 0x650,
0x646, 0x62f, 0x64f, 0x633, 0x62a, 0x672, 0x646, 0x6cd, 0x20, 0x631, 0x6c4, 0x67e, 0x64e, 0x6d2, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x49a, 0x430, 0x437, 0x430, 0x49b, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x3b,
0x49a, 0x430, 0x437, 0x430, 0x49b, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x3b, 0x3b,
0x3b, 0x49a, 0x430, 0x437, 0x430, 0x49b, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x442, 0x435, 0x4a3, 0x433, 0x435, 0x441, 0x456, 0x3b, 0x41a,
0x44b, 0x440, 0x433, 0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x441, 0x43e, 0x43c, 0x443, 0x3b, 0x3b, 0x41a, 0x44b, 0x440, 0x433,
0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x441, 0x43e, 0x43c, 0x443, 0x3b, 0x3b, 0x3b, 0x3b, 0x41a, 0x44b, 0x440, 0x433, 0x44b,
0x437, 0x441, 0x442, 0x430, 0x43d, 0x20, 0x441, 0x43e, 0x43c, 0x443, 0x3b, 0xb300, 0xd55c, 0xbbfc, 0xad6d, 0x20, 0xc6d0, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0xb300, 0xd55c, 0xbbfc, 0xad6d, 0x20, 0xc6d0, 0x3b, 0xc870, 0xc120, 0x20, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0x20, 0xc778, 0xbbfc,
0x20, 0xacf5, 0xd654, 0xad6d, 0x20, 0xc6d0, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xc870, 0xc120, 0x20, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0x20,
0xc778, 0xbbfc, 0x20, 0xacf5, 0xd654, 0xad6d, 0x20, 0xc6d0, 0x3b, 0x49, 0x66, 0x61, 0x72, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x72, 0x79,
0x2019, 0x55, 0x62, 0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xea5, 0xeb2, 0xea7, 0x20,
0xe81, 0xeb5, 0xe9a, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xea5, 0xeb2, 0xea7, 0x20, 0xe81, 0xeb5, 0xe9a, 0x3b, 0x65, 0x69, 0x72,
0x6f, 0x3b, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x69, 0x72, 0x6f, 0x3b,
0x46, 0x61, 0x6c, 0xe1, 0x6e, 0x67, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0xf3, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x4b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x20, 0x79, 0x61, 0x20, 0x41, 0x6e, 0x67, 0xf3, 0x6c, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x61, 0x6c, 0xe1, 0x6e, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45,
0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x61, 0x73, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x61,
0x73, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x61, 0x69, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x173, 0x3b, 0x41c,
0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x435, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x41c, 0x430, 0x43a,
0x435, 0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x435, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x3b, 0x3b, 0x41c, 0x430, 0x43a,
0x435, 0x434, 0x43e, 0x43d, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x435, 0x43d, 0x430, 0x440, 0x438, 0x3b, 0x41, 0x72, 0x69, 0x61, 0x72,
0x79, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x69, 0x6e, 0x67, 0x67, 0x69, 0x74, 0x20, 0x4d, 0x61, 0x6c, 0x61,
0x79, 0x73, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x69, 0x6e, 0x67, 0x67, 0x69, 0x74, 0x20, 0x4d, 0x61,
0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x72, 0x20, 0x42, 0x72, 0x75, 0x6e, 0x65, 0x69, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x72, 0x20, 0x42, 0x72, 0x75, 0x6e, 0x65, 0x69, 0x3b, 0x44, 0x6f,
0x6c, 0x61, 0x72, 0x20, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x75, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44,
0x6f, 0x6c, 0x61, 0x72, 0x20, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x75, 0x72, 0x61, 0x3b, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d,
0xd2f, 0xd7b, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b, 0x3b, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0xd7b, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b,
0x3b, 0x3b, 0x3b, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0xd7b, 0x20, 0xd30, 0xd42, 0xd2a, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b,
0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x65, 0x77, 0x72, 0x6f, 0x3b, 0x65, 0x77, 0x72,
0x6f, 0x3b, 0x54, 0x101, 0x72, 0x61, 0x20, 0x6f, 0x20, 0x41, 0x6f, 0x74, 0x65, 0x61, 0x72, 0x6f, 0x61, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x74, 0x101, 0x72, 0x61, 0x20, 0x6f, 0x20, 0x41, 0x6f, 0x74, 0x65, 0x61, 0x72, 0x6f, 0x61, 0x3b, 0x92d,
0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20,
0x930, 0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a, 0x92f,
0x947, 0x3b, 0x41c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b, 0x20, 0x442, 0x4e9, 0x433, 0x440, 0x4e9, 0x433, 0x3b, 0x3b, 0x41c, 0x43e, 0x43d,
0x433, 0x43e, 0x43b, 0x20, 0x442, 0x4e9, 0x433, 0x440, 0x4e9, 0x433, 0x3b, 0x3b, 0x3b, 0x3b, 0x41c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b,
0x20, 0x442, 0x4e9, 0x433, 0x440, 0x4e9, 0x433, 0x3b, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x20, 0x930, 0x942, 0x92a, 0x948, 0x92f,
0x93e, 0x901, 0x3b, 0x3b, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x20, 0x930, 0x942, 0x92a, 0x948, 0x92f, 0x93e, 0x901, 0x3b, 0x3b,
0x3b, 0x3b, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x20, 0x930, 0x942, 0x92a, 0x948, 0x92f, 0x93e, 0x901, 0x3b, 0x92d, 0x93e, 0x930,
0x924, 0x940, 0x92f, 0x20, 0x930, 0x942, 0x92a, 0x93f, 0x901, 0x92f, 0x93e, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20,
0x930, 0x942, 0x92a, 0x93f, 0x901, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x942,
0x92a, 0x93f, 0x901, 0x92f, 0x93e, 0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b,
0x3b, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x73,
0x6b, 0x65, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x65, 0x72, 0x3b, 0xb2d, 0xb3e, 0xb30, 0xb24, 0xb40, 0xb5f, 0x20, 0xb1f, 0xb19, 0xb4d,
0xb15, 0xb3e, 0x3b, 0x3b, 0xb2d, 0xb3e, 0xb30, 0xb24, 0xb40, 0xb5f, 0x20, 0xb1f, 0xb19, 0xb4d, 0xb15, 0xb3e, 0x3b, 0x3b, 0x3b, 0x3b,
0xb2d, 0xb3e, 0xb30, 0xb24, 0xb40, 0xb5f, 0x20, 0xb1f, 0xb19, 0xb4d, 0xb15, 0xb3e, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cd, 0x3b,
0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cd, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cd, 0x3b, 0x67e, 0x627,
0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cd, 0x20, 0x6a9, 0x644, 0x62f, 0x627, 0x631, 0x647, 0x3b, 0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a,
0x627, 0x646, 0x6cd, 0x20, 0x6a9, 0x644, 0x62f, 0x627, 0x631, 0x647, 0x3b, 0x3b, 0x3b, 0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627,
0x646, 0x6cd, 0x20, 0x6a9, 0x644, 0x62f, 0x627, 0x631, 0x6d2, 0x3b, 0x631, 0x6cc, 0x627, 0x644, 0x20, 0x627, 0x6cc, 0x631, 0x627, 0x646,
0x3b, 0x3b, 0x631, 0x6cc, 0x627, 0x644, 0x20, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x3b, 0x3b, 0x3b, 0x3b, 0x631, 0x6cc, 0x627, 0x644,
0x20, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633,
0x62a, 0x627, 0x646, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627,
0x646, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x20, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627,
0x646, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x79, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x3b, 0x3b, 0x7a, 0x142, 0x6f, 0x74,
0x79, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x3b, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x65, 0x20, 0x70, 0x6f, 0x6c, 0x73,
0x6b, 0x69, 0x65, 0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x79, 0x63, 0x68, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x63, 0x68,
0x3b, 0x7a, 0x142, 0x6f, 0x74, 0x65, 0x67, 0x6f, 0x20, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x65, 0x67, 0x6f, 0x3b, 0x52,
0x65, 0x61, 0x6c, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x3b, 0x52, 0x65, 0x61, 0x6c,
0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x52, 0x65, 0x61, 0x69, 0x73,
0x20, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0x69, 0x72, 0x6f, 0x73, 0x3b, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x20,
0x61, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x20, 0x61, 0x6e, 0x67,
0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x6b, 0x77, 0x61, 0x6e, 0x7a, 0x61, 0x73, 0x20, 0x61, 0x6e, 0x67,
0x6f, 0x6c, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x65, 0x73, 0x63, 0x75, 0x64, 0x6f, 0x20, 0x63, 0x61, 0x62, 0x6f, 0x2d, 0x76,
0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x65, 0x73, 0x63, 0x75, 0x64, 0x6f, 0x20, 0x63, 0x61, 0x62, 0x6f,
0x2d, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x73, 0x63, 0x75, 0x64, 0x6f, 0x73,
0x20, 0x63, 0x61, 0x62, 0x6f, 0x2d, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x64, 0xf3, 0x6c, 0x61,
0x72, 0x20, 0x64, 0x6f, 0x73, 0x20, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73,
0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x64, 0x6f, 0x73, 0x20, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x20,
0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x20, 0x64, 0x6f,
0x73, 0x20, 0x45, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x3b, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x6f, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e,
0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x70, 0x61,
0x74, 0x61, 0x63, 0x61, 0x20, 0x6d, 0x61, 0x63, 0x61, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x70, 0x61, 0x74, 0x61, 0x63,
0x61, 0x20, 0x6d, 0x61, 0x63, 0x61, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x61, 0x74, 0x61, 0x63, 0x61,
0x73, 0x20, 0x6d, 0x61, 0x63, 0x61, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x3b, 0x6d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20,
0x6d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x6d, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c,
0x20, 0x6d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x6d, 0x65, 0x74, 0x69,
0x63, 0x61, 0x69, 0x73, 0x20, 0x6d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x64, 0x6f,
0x62, 0x72, 0x61, 0x20, 0x64, 0x65, 0x20, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50, 0x72,
0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0x3b, 0x3b, 0x64, 0x6f, 0x62, 0x72, 0x61, 0x20, 0x64, 0x65, 0x20, 0x53, 0xe3, 0x6f,
0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0x3b, 0x3b, 0x3b, 0x3b,
0x64, 0x6f, 0x62, 0x72, 0x61, 0x73, 0x20, 0x64, 0x65, 0x20, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65,
0x20, 0x50, 0x72, 0xed, 0x6e, 0x63, 0x69, 0x70, 0x65, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x73, 0x75, 0xed,
0xe7, 0x6f, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x73, 0x75, 0xed, 0xe7, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x73, 0x75, 0xed, 0xe7, 0x6f, 0x73, 0x3b, 0xa2d, 0xa3e, 0xa30, 0xa24, 0xa40,
0x20, 0xa30, 0xa41, 0xa2a, 0xa07, 0xa06, 0x3b, 0x3b, 0xa2d, 0xa3e, 0xa30, 0xa24, 0xa40, 0x20, 0xa30, 0xa41, 0xa2a, 0xa07, 0xa06, 0x3b,
0x3b, 0x3b, 0x3b, 0xa2d, 0xa3e, 0xa30, 0xa24, 0xa40, 0x20, 0xa30, 0xa41, 0xa2a, 0xa0f, 0x3b, 0x631, 0x648, 0x67e, 0x626, 0x6cc, 0x6c1,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6f, 0x6c, 0x20, 0x50, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6f, 0x6c, 0x20, 0x70, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x3b, 0x42, 0x6f, 0x6c, 0x69,
0x76, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f,
0x3b, 0x44, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x44, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x61, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x20, 0x73, 0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73,
0x76, 0x69, 0x7a, 0x7a, 0x65, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x73, 0x76, 0x69, 0x7a,
0x7a, 0x65, 0x72, 0x3b, 0x6c, 0x65, 0x75, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65,
0x75, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x72, 0x6f, 0x6d, 0xe2,
0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x65, 0x219, 0x74, 0x69,
0x3b, 0x6c, 0x65, 0x75, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65,
0x75, 0x20, 0x6d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x63, 0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x6d,
0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x3b, 0x6c, 0x65, 0x69, 0x20, 0x6d, 0x6f, 0x6c,
0x64, 0x6f, 0x76, 0x65, 0x6e, 0x65, 0x219, 0x74, 0x69, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x438, 0x439,
0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440,
0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431,
0x43b, 0x44f, 0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x435, 0x439,
0x3b, 0x440, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x431,
0x435, 0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x431, 0x435,
0x43b, 0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44c, 0x3b, 0x3b, 0x431, 0x435, 0x43b,
0x43e, 0x440, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440,
0x443, 0x441, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x435, 0x439, 0x3b, 0x431, 0x435, 0x43b, 0x43e, 0x440, 0x443,
0x441, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20, 0x440, 0x443, 0x431, 0x43b, 0x44f, 0x3b, 0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a,
0x438, 0x439, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x3b, 0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x438, 0x439, 0x20,
0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x3b, 0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x442, 0x435, 0x43d,
0x433, 0x435, 0x3b, 0x43a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x43a,
0x430, 0x437, 0x430, 0x445, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20, 0x442, 0x435, 0x43d, 0x433, 0x435, 0x3b, 0x43a, 0x438, 0x440, 0x433,
0x438, 0x437, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a,
0x438, 0x439, 0x20, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x441,
0x43e, 0x43c, 0x430, 0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x441, 0x43e, 0x43c, 0x43e, 0x432,
0x3b, 0x43a, 0x438, 0x440, 0x433, 0x438, 0x437, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20, 0x441, 0x43e, 0x43c, 0x430, 0x3b, 0x43c, 0x43e,
0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x439, 0x20, 0x43b, 0x435, 0x439, 0x3b, 0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432,
0x441, 0x43a, 0x438, 0x439, 0x20, 0x43b, 0x435, 0x439, 0x3b, 0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x445,
0x20, 0x43b, 0x435, 0x44f, 0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x438, 0x445, 0x20, 0x43b, 0x435, 0x435, 0x432,
0x3b, 0x43c, 0x43e, 0x43b, 0x434, 0x430, 0x432, 0x441, 0x43a, 0x43e, 0x433, 0x43e, 0x20, 0x43b, 0x435, 0x44f, 0x3b, 0x443, 0x43a, 0x440,
0x430, 0x438, 0x43d, 0x441, 0x43a, 0x430, 0x44f, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x430, 0x3b, 0x3b, 0x443, 0x43a, 0x440, 0x430,
0x438, 0x43d, 0x441, 0x43a, 0x430, 0x44f, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x430, 0x3b, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x438,
0x43d, 0x441, 0x43a, 0x438, 0x435, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44b, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441,
0x43a, 0x438, 0x445, 0x20, 0x433, 0x440, 0x438, 0x432, 0x435, 0x43d, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x438, 0x43d, 0x441, 0x43a, 0x43e,
0x439, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44b, 0x3b, 0x66, 0x61, 0x72, 0xe2, 0x6e, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41,
0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x421, 0x440, 0x43f, 0x441, 0x43a, 0x438,
0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x3b, 0x3b, 0x441, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440,
0x3b, 0x3b, 0x441, 0x440, 0x43f, 0x441, 0x43a, 0x430, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x430, 0x3b, 0x3b, 0x441, 0x440, 0x43f,
0x441, 0x43a, 0x438, 0x445, 0x20, 0x434, 0x438, 0x43d, 0x430, 0x440, 0x430, 0x3b, 0x411, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e,
0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x430, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440,
0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d,
0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x430, 0x20, 0x43a, 0x43e, 0x43d,
0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x430, 0x3b, 0x3b, 0x431, 0x43e,
0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x435, 0x20,
0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x435, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x65, 0x3b,
0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447,
0x43a, 0x438, 0x445, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x438, 0x445, 0x20, 0x43c,
0x430, 0x440, 0x430, 0x43a, 0x430, 0x3b, 0x415, 0x432, 0x440, 0x43e, 0x3b, 0x3b, 0x435, 0x432, 0x440, 0x43e, 0x3b, 0x3b, 0x435, 0x432,
0x440, 0x430, 0x3b, 0x3b, 0x435, 0x432, 0x440, 0x430, 0x3b, 0x42, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65,
0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62,
0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f,
0x2d, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72,
0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e,
0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x65, 0x20, 0x6b, 0x6f, 0x6e,
0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x3b, 0x3b, 0x62, 0x6f,
0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x2d, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x69, 0x68,
0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x69, 0x68, 0x20, 0x6d, 0x61, 0x72, 0x61,
0x6b, 0x61, 0x3b, 0x45, 0x76, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x76, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x76, 0x72, 0x61, 0x3b,
0x3b, 0x65, 0x76, 0x72, 0x61, 0x3b, 0x53, 0x72, 0x70, 0x73, 0x6b, 0x69, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x3b, 0x3b,
0x73, 0x72, 0x70, 0x73, 0x6b, 0x69, 0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x3b, 0x3b, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x61,
0x20, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x61, 0x3b, 0x3b, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x69, 0x68, 0x20, 0x64, 0x69, 0x6e,
0x61, 0x72, 0x61, 0x3b, 0x41b, 0x430, 0x440, 0x3b, 0x3b, 0x43b, 0x430, 0x440, 0x3b, 0x3b, 0x3b, 0x3b, 0x43b, 0x430, 0x440, 0x44b,
0x3b, 0x421, 0x43e, 0x43c, 0x3b, 0x3b, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x3b, 0x3b, 0x441, 0x43e, 0x43c, 0x44b, 0x3b, 0x44, 0x6f,
0x72, 0x61, 0x20, 0x72, 0x65, 0x20, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x6b, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x67e, 0x627, 0x6aa, 0x633, 0x62a, 0x627, 0x646, 0x64a, 0x20, 0x631, 0x67e, 0x64a, 0x3b, 0x3b, 0x67e, 0x627, 0x6aa, 0x633, 0x62a, 0x627,
0x646, 0x64a, 0x20, 0x631, 0x67e, 0x64a, 0x3b, 0x3b, 0x3b, 0x3b, 0x67e, 0x627, 0x6aa, 0x633, 0x62a, 0x627, 0x646, 0x64a, 0x20, 0x631,
0x67e, 0x64a, 0x3b, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0x20, 0xdbb, 0xdd4, 0xdb4, 0xdd2, 0xdba, 0xdbd,
0x3b, 0x3b, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0x20, 0xdbb, 0xdd4, 0xdb4, 0xdd2, 0xdba, 0xdbd, 0x3b,
0x3b, 0x3b, 0x3b, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0x20, 0xdbb, 0xdd4, 0xdb4, 0xdd2, 0xdba, 0xdbd,
0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0xe1, 0x3b, 0x65, 0x75,
0x72, 0x61, 0x3b, 0x65, 0x75, 0x72, 0x3b, 0x65, 0x76, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x76, 0x72, 0x6f, 0x3b, 0x65, 0x76,
0x72, 0x61, 0x3b, 0x65, 0x76, 0x72, 0x69, 0x3b, 0x3b, 0x65, 0x76, 0x72, 0x6f, 0x76, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69,
0x6e, 0x67, 0x6b, 0x61, 0x20, 0x53, 0x6f, 0x6f, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x46, 0x61, 0x72, 0x61, 0x6e, 0x20, 0x4a, 0x61, 0x62, 0x75, 0x75, 0x74, 0x69, 0x3b, 0x3b, 0x66, 0x61, 0x72,
0x61, 0x6e, 0x6b, 0x61, 0x20, 0x4a, 0x61, 0x62, 0x75, 0x75, 0x74, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x61, 0x72, 0x61,
0x6e, 0x6b, 0x61, 0x20, 0x4a, 0x61, 0x62, 0x75, 0x75, 0x74, 0x69, 0x3b, 0x42, 0x69, 0x72, 0x74, 0x61, 0x20, 0x49, 0x74,
0x6f, 0x6f, 0x62, 0x62, 0x69, 0x79, 0x61, 0x3b, 0x3b, 0x62, 0x69, 0x72, 0x74, 0x61, 0x20, 0x49, 0x74, 0x6f, 0x6f, 0x62,
0x62, 0x69, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x62, 0x69, 0x72, 0x74, 0x61, 0x20, 0x49, 0x74, 0x6f, 0x6f, 0x62, 0x62,
0x69, 0x79, 0x61, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x6b, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b,
0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x6b, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b,
0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x6b, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x70, 0x65, 0x73, 0x6f,
0x20, 0x61, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x61, 0x72, 0x67,
0x65, 0x6e, 0x74, 0x69, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x61, 0x72, 0x67, 0x65,
0x6e, 0x74, 0x69, 0x6e, 0x6f, 0x73, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x63, 0x65, 0xf1,
0x6f, 0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x63, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x3b,
0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x63, 0x65, 0xf1, 0x6f, 0x73, 0x3b, 0x62,
0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x62, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x3b,
0x3b, 0x3b, 0x3b, 0x62, 0x6f, 0x6c, 0x69, 0x76, 0x69, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x72, 0x65, 0x61, 0x6c, 0x20, 0x62,
0x72, 0x61, 0x73, 0x69, 0x6c, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x72, 0x65, 0x61, 0x6c, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69,
0x6c, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x72, 0x65, 0x61, 0x6c, 0x65, 0x73, 0x20, 0x62, 0x72, 0x61, 0x73, 0x69,
0x6c, 0x65, 0xf1, 0x6f, 0x73, 0x3b, 0x50, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x65, 0x6e, 0x6f, 0x3b, 0x3b,
0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x65, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f,
0x73, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x65, 0x6e, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x6f, 0x6c, 0x6f,
0x6d, 0x62, 0x69, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69,
0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69,
0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x63, 0x6f, 0x6c, 0xf3, 0x6e, 0x20, 0x63, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x72, 0x69, 0x63,
0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x63, 0x6f, 0x6c, 0xf3, 0x6e, 0x20, 0x63, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x72, 0x69,
0x63, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x63, 0x6f, 0x6c, 0x6f, 0x6e, 0x65, 0x73, 0x20, 0x63, 0x6f, 0x73,
0x74, 0x61, 0x72, 0x72, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x75, 0x62,
0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x63, 0x75, 0x62, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x63, 0x75, 0x62, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x64,
0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x64, 0x6f, 0x6d, 0x69,
0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x64, 0x6f, 0x6d, 0x69,
0x6e, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f,
0x75, 0x6e, 0x69, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x20, 0x65, 0x73, 0x74, 0x61,
0x64, 0x6f, 0x75, 0x6e, 0x69, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x64, 0xf3, 0x6c, 0x61, 0x72, 0x65,
0x73, 0x20, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x75, 0x6e, 0x69, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x3b, 0x66, 0x72,
0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x64, 0x65, 0x20, 0xc1, 0x66, 0x72, 0x69, 0x63, 0x61, 0x20, 0x43,
0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x3b, 0x3b, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x20, 0x43, 0x46, 0x41, 0x20, 0x64,
0x65, 0x20, 0xc1, 0x66, 0x72, 0x69, 0x63, 0x61, 0x20, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x3b, 0x3b, 0x3b, 0x3b,
0x66, 0x72, 0x61, 0x6e, 0x63, 0x6f, 0x73, 0x20, 0x43, 0x46, 0x41, 0x20, 0x64, 0x65, 0x20, 0xc1, 0x66, 0x72, 0x69, 0x63,
0x61, 0x20, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x3b, 0x71, 0x75, 0x65, 0x74, 0x7a, 0x61, 0x6c, 0x3b, 0x3b, 0x71,
0x75, 0x65, 0x74, 0x7a, 0x61, 0x6c, 0x3b, 0x3b, 0x3b, 0x3b, 0x71, 0x75, 0x65, 0x74, 0x7a, 0x61, 0x6c, 0x65, 0x73, 0x3b,
0x6c, 0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x20, 0x68, 0x6f, 0x6e, 0x64, 0x75, 0x72, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x6c,
0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x20, 0x68, 0x6f, 0x6e, 0x64, 0x75, 0x72, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x6c, 0x65, 0x6d, 0x70, 0x69, 0x72, 0x61, 0x73, 0x20, 0x68, 0x6f, 0x6e, 0x64, 0x75, 0x72, 0x65, 0xf1, 0x6f, 0x73, 0x3b,
0x70, 0x65, 0x73, 0x6f, 0x20, 0x6d, 0x65, 0x78, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20,
0x6d, 0x65, 0x78, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x6d, 0x65,
0x78, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x63, 0xf3, 0x72, 0x64, 0x6f, 0x62, 0x61, 0x20, 0x6e, 0x69, 0x63, 0x61,
0x72, 0x61, 0x67, 0xfc, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x63, 0xf3, 0x72, 0x64, 0x6f, 0x62, 0x61, 0x20, 0x6e, 0x69,
0x63, 0x61, 0x72, 0x61, 0x67, 0xfc, 0x65, 0x6e, 0x73, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x63, 0xf3, 0x72, 0x64, 0x6f, 0x62,
0x61, 0x73, 0x20, 0x6e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0xfc, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x3b, 0x62, 0x61, 0x6c,
0x62, 0x6f, 0x61, 0x20, 0x70, 0x61, 0x6e, 0x61, 0x6d, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x62, 0x61, 0x6c, 0x62, 0x6f, 0x61,
0x20, 0x70, 0x61, 0x6e, 0x61, 0x6d, 0x65, 0xf1, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x62, 0x61, 0x6c, 0x62, 0x6f, 0x61, 0x73,
0x20, 0x70, 0x61, 0x6e, 0x61, 0x6d, 0x65, 0xf1, 0x6f, 0x73, 0x3b, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0xed, 0x20, 0x70,
0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b, 0x3b, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0xed, 0x20, 0x70, 0x61,
0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0xed, 0x65, 0x73,
0x20, 0x70, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x73, 0x3b, 0x73, 0x6f, 0x6c, 0x20, 0x70, 0x65, 0x72, 0x75,
0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x73, 0x6f, 0x6c, 0x20, 0x70, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b,
0x73, 0x6f, 0x6c, 0x65, 0x73, 0x20, 0x70, 0x65, 0x72, 0x75, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20,
0x66, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x66, 0x69, 0x6c, 0x69, 0x70,
0x69, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x20, 0x66, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e,
0x6f, 0x73, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x20, 0x75, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b, 0x3b, 0x70, 0x65,
0x73, 0x6f, 0x20, 0x75, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x70, 0x65, 0x73, 0x6f, 0x73,
0x20, 0x75, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x6f, 0x73, 0x3b, 0x62, 0x6f, 0x6c, 0xed, 0x76, 0x61, 0x72, 0x20, 0x73,
0x6f, 0x62, 0x65, 0x72, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x62, 0x6f, 0x6c, 0xed, 0x76, 0x61, 0x72, 0x20, 0x73, 0x6f, 0x62,
0x65, 0x72, 0x61, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x62, 0x6f, 0x6c, 0xed, 0x76, 0x61, 0x72, 0x65, 0x73, 0x20, 0x73,
0x6f, 0x62, 0x65, 0x72, 0x61, 0x6e, 0x6f, 0x73, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61,
0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20,
0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69,
0x6e, 0x67, 0x69, 0x20, 0x7a, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x46, 0x61, 0x72, 0x61,
0x6e, 0x67, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x3b, 0x3b, 0x66, 0x61, 0x72, 0x61, 0x6e, 0x67,
0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x61, 0x72, 0x61, 0x6e, 0x67,
0x61, 0x20, 0x7a, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20,
0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79,
0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20,
0x7a, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61,
0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61,
0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20,
0x7a, 0x61, 0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f,
0x6e, 0x61, 0x3b, 0x3b, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x61, 0x3b, 0x3b, 0x3b, 0x3b,
0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x61, 0x20, 0x6b, 0x72, 0x6f, 0x6e, 0x6f, 0x72, 0x3b, 0x421, 0x43e, 0x43c, 0x43e, 0x43d,
0x4e3, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x421, 0x43e, 0x43c, 0x43e, 0x43d, 0x4e3, 0x3b, 0xb87, 0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf,
0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0x3b, 0xb87, 0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe,
0xbaf, 0xbcd, 0x3b, 0x3b, 0x3b, 0x3b, 0xb87, 0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0xb95,
0xbb3, 0xbcd, 0x3b, 0xbae, 0xbb2, 0xbc7, 0xbb7, 0xbbf, 0xbaf, 0xba9, 0xbcd, 0x20, 0xbb0, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbbf, 0xb9f, 0xbcd,
0x3b, 0x3b, 0xbae, 0xbb2, 0xbc7, 0xbb7, 0xbbf, 0xbaf, 0xba9, 0xbcd, 0x20, 0xbb0, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbbf, 0xb9f, 0xbcd, 0x3b,
0x3b, 0x3b, 0x3b, 0xbae, 0xbb2, 0xbc7, 0xbb7, 0xbbf, 0xbaf, 0xba9, 0xbcd, 0x20, 0xbb0, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbbf, 0xb9f, 0xbcd,
0xb95, 0xbb3, 0xbcd, 0x3b, 0xb9a, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0x20, 0xb9f, 0xbbe, 0xbb2, 0xbb0,
0xbcd, 0x3b, 0x3b, 0xb9a, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0x20, 0xb9f, 0xbbe, 0xbb2, 0xbb0, 0xbcd,
0x3b, 0x3b, 0x3b, 0x3b, 0xb9a, 0xbbf, 0xb99, 0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0x20, 0xb9f, 0xbbe, 0xbb2, 0xbb0,
0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b, 0xb87, 0xbb2, 0xb99, 0xbcd, 0xb95, 0xbc8, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0x3b,
0xb87, 0xbb2, 0xb99, 0xbcd, 0xb95, 0xbc8, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0x3b, 0x3b, 0x3b, 0x3b, 0xb87, 0xbb2, 0xb99,
0xbcd, 0xb95, 0xbc8, 0x20, 0xbb0, 0xbc2, 0xbaa, 0xbbe, 0xbaf, 0xbcd, 0xb95, 0xbb3, 0xbcd, 0x3b, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x44f,
0x20, 0x441, 0x443, 0x43c, 0x44b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x441, 0x443, 0x43c, 0x3b, 0xc30, 0xc42, 0xc2a, 0xc3e, 0xc2f,
0xc3f, 0x3b, 0x3b, 0xc30, 0xc42, 0xc2a, 0xc3e, 0xc2f, 0xc3f, 0x3b, 0x3b, 0x3b, 0x3b, 0xc30, 0xc42, 0xc2a, 0xc3e, 0xc2f, 0xc32, 0xc41,
0x3b, 0xe1a, 0xe32, 0xe17, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xe1a, 0xe32, 0xe17, 0xe44, 0xe17, 0xe22, 0x3b, 0xf61, 0xf74, 0xf0b,
0xf68, 0xf53, 0xf0b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xf62, 0xf92, 0xfb1, 0xf0b, 0xf42, 0xf62, 0xf0b, 0xf66, 0xf92, 0xf7c,
0xf62, 0xf0b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x12e8, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x20, 0x1265, 0x122d, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x66, 0x61, 0x6b, 0x61, 0x74, 0x6f, 0x6e,
0x67, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x50, 0x61, 0x2bb, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x66, 0x61, 0x6b, 0x61,
0x74, 0x6f, 0x6e, 0x67, 0x61, 0x3b, 0x54, 0xfc, 0x72, 0x6b, 0x20, 0x4c, 0x69, 0x72, 0x61, 0x73, 0x131, 0x3b, 0x3b, 0x54,
0xfc, 0x72, 0x6b, 0x20, 0x6c, 0x69, 0x72, 0x61, 0x73, 0x131, 0x3b, 0x3b, 0x3b, 0x3b, 0x54, 0xfc, 0x72, 0x6b, 0x20, 0x6c,
0x69, 0x72, 0x61, 0x73, 0x131, 0x3b, 0x54, 0xfc, 0x72, 0x6b, 0x6d, 0x65, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x64, 0x79,
0x3b, 0x3b, 0x74, 0xfc, 0x72, 0x6b, 0x6d, 0x65, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x64, 0x79, 0x3b, 0x3b, 0x3b, 0x3b,
0x74, 0xfc, 0x72, 0x6b, 0x6d, 0x65, 0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x64, 0x79, 0x3b, 0x62c, 0x6c7, 0x6ad, 0x6af, 0x648,
0x20, 0x64a, 0x6c8, 0x6d5, 0x646, 0x649, 0x3b, 0x3b, 0x62c, 0x6c7, 0x6ad, 0x6af, 0x648, 0x20, 0x64a, 0x6c8, 0x6d5, 0x646, 0x649, 0x3b,
0x3b, 0x3b, 0x3b, 0x62c, 0x6c7, 0x6ad, 0x6af, 0x648, 0x20, 0x64a, 0x6c8, 0x6d5, 0x646, 0x649, 0x3b, 0x443, 0x43a, 0x440, 0x430, 0x457,
0x43d, 0x441, 0x44c, 0x43a, 0x430, 0x20, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44f, 0x3b, 0x3b, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x44f,
0x3b, 0x3b, 0x433, 0x440, 0x438, 0x432, 0x43d, 0x456, 0x3b, 0x433, 0x440, 0x438, 0x432, 0x435, 0x43d, 0x44c, 0x3b, 0x433, 0x440, 0x438,
0x432, 0x43d, 0x456, 0x3b, 0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b, 0x3b,
0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b, 0x3b, 0x3b, 0x3b, 0x67e, 0x627,
0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b, 0x628, 0x6be, 0x627, 0x631, 0x62a, 0x6cc, 0x20,
0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b, 0x3b, 0x628, 0x6be, 0x627, 0x631, 0x62a, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6cc, 0x6c1, 0x3b,
0x3b, 0x3b, 0x3b, 0x628, 0x6be, 0x627, 0x631, 0x62a, 0x6cc, 0x20, 0x631, 0x648, 0x67e, 0x6d2, 0x3b, 0x4f, 0x2018, 0x7a, 0x62, 0x65,
0x6b, 0x69, 0x73, 0x74, 0x6f, 0x6e, 0x20, 0x73, 0x6f, 0x2018, 0x6d, 0x69, 0x3b, 0x3b, 0x4f, 0x2018, 0x7a, 0x62, 0x65, 0x6b,
0x69, 0x73, 0x74, 0x6f, 0x6e, 0x20, 0x73, 0x6f, 0x2018, 0x6d, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x4f, 0x2018, 0x7a, 0x62, 0x65,
0x6b, 0x69, 0x73, 0x74, 0x6f, 0x6e, 0x20, 0x73, 0x6f, 0x2018, 0x6d, 0x69, 0x3b, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x6cc, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0x20, 0x441, 0x45e, 0x43c,
0x3b, 0x3b, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0x20, 0x441, 0x45e, 0x43c, 0x3b, 0x3b, 0x3b, 0x3b,
0x40e, 0x437, 0x431, 0x435, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d, 0x20, 0x441, 0x45e, 0x43c, 0x3b, 0x110, 0x1ed3, 0x6e, 0x67, 0x20,
0x56, 0x69, 0x1ec7, 0x74, 0x20, 0x4e, 0x61, 0x6d, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x110, 0x1ed3, 0x6e, 0x67, 0x20, 0x56,
0x69, 0x1ec7, 0x74, 0x20, 0x4e, 0x61, 0x6d, 0x3b, 0x50, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e,
0x3b, 0x70, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x62, 0x75, 0x6e, 0x74, 0x20, 0x50,
0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x62, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b,
0x70, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x70, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72,
0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x70, 0x75, 0x6e, 0x74, 0x20, 0x50, 0x72, 0x79, 0x64, 0x61, 0x69, 0x6e, 0x3b, 0x46,
0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x20, 0x62, 0x75, 0x20, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x20, 0x53, 0x6f,
0x77, 0x77, 0x75, 0x2d, 0x6a, 0x61, 0x6e, 0x74, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x20,
0x43, 0x46, 0x41, 0x20, 0x79, 0x75, 0x20, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x20, 0x53, 0x6f, 0x77, 0x77, 0x75, 0x2d, 0x6a,
0x61, 0x6e, 0x74, 0x3b, 0x69, 0x52, 0x61, 0x6e, 0x64, 0x69, 0x20, 0x79, 0x61, 0x73, 0x65, 0x4d, 0x7a, 0x61, 0x6e, 0x7a,
0x69, 0x20, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x3b, 0x3b, 0x69, 0x52, 0x61, 0x6e, 0x64, 0x69, 0x20, 0x59, 0x61, 0x73,
0x65, 0x4d, 0x7a, 0x61, 0x6e, 0x7a, 0x69, 0x20, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x69, 0x52,
0x61, 0x6e, 0x64, 0x69, 0x20, 0x79, 0x61, 0x73, 0x65, 0x4d, 0x7a, 0x61, 0x6e, 0x7a, 0x69, 0x20, 0x41, 0x66, 0x72, 0x69,
0x6b, 0x61, 0x3b, 0x4e, 0xe1, 0xec, 0x72, 0xe0, 0x20, 0x74, 0x69, 0x20, 0x4f, 0x72, 0xed, 0x6c, 0x1eb9, 0x300, 0x2d, 0xe8,
0x64, 0xe8, 0x20, 0x4e, 0xe0, 0xec, 0x6a, 0xed, 0x72, 0xed, 0xe0, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0xe1, 0xed,
0x72, 0xe0, 0x20, 0x4e, 0xe0, 0xec, 0x6a, 0xed, 0x72, 0xed, 0xe0, 0x3b, 0x46, 0x61, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x20,
0x74, 0x69, 0x20, 0x4f, 0x72, 0xed, 0x6c, 0x25b, 0x301, 0xe8, 0x64, 0x65, 0x20, 0x42, 0x49, 0x4b, 0x45, 0x41, 0x4f, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x69, 0x2d, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61,
0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x69, 0x2d, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69,
0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x3b, 0x3b, 0x3b, 0x69, 0x2d, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20,
0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x61, 0x6e, 0x64, 0x3b, 0x42, 0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b,
0x6f, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72,
0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x62, 0x6f, 0x73, 0x61, 0x6e,
0x73, 0x6b, 0x6f, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x61, 0x20, 0x6b, 0x6f, 0x6e, 0x76,
0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x61, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x3b, 0x3b, 0x62, 0x6f, 0x73,
0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x65, 0x20, 0x6b, 0x6f,
0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x3b, 0x3b, 0x62,
0x6f, 0x73, 0x61, 0x6e, 0x73, 0x6b, 0x6f, 0x68, 0x65, 0x72, 0x63, 0x65, 0x67, 0x6f, 0x76, 0x61, 0x10d, 0x6b, 0x69, 0x68,
0x20, 0x6b, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x6e, 0x69, 0x68, 0x20, 0x6d, 0x61, 0x72, 0x61,
0x6b, 0x61, 0x3b, 0x41a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20, 0x43c, 0x430, 0x440,
0x43a, 0x430, 0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e,
0x432, 0x430, 0x447, 0x43a, 0x430, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b, 0x43d, 0x430, 0x20,
0x43c, 0x430, 0x440, 0x43a, 0x430, 0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445, 0x435, 0x440, 0x446,
0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x435, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442, 0x438, 0x431, 0x438, 0x43b,
0x43d, 0x435, 0x20, 0x43c, 0x430, 0x440, 0x43a, 0x435, 0x3b, 0x3b, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x43e, 0x2d, 0x445,
0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x430, 0x447, 0x43a, 0x438, 0x445, 0x20, 0x43a, 0x43e, 0x43d, 0x432, 0x435, 0x440, 0x442,
0x438, 0x431, 0x438, 0x43b, 0x43d, 0x438, 0x445, 0x20, 0x43c, 0x430, 0x440, 0x430, 0x43a, 0x430, 0x3b, 0x47, 0x68, 0x61, 0x6e, 0x61,
0x20, 0x53, 0x69, 0x64, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930,
0x941, 0x92a, 0x92f, 0x93e, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x92d, 0x93e, 0x930, 0x924, 0x940, 0x92f, 0x20, 0x930, 0x941, 0x92a,
0x92f, 0x93e, 0x3b, 0x4e, 0x61, 0x1ecb, 0x72, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e,
0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x67, 0x68,
0x61, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x256, 0x69, 0x3b, 0x3b, 0x67, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x256, 0x69,
0x3b, 0x3b, 0x3b, 0x3b, 0x67, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x256, 0x69, 0x3b, 0x263, 0x65, 0x74, 0x6f, 0x256,
0x6f, 0x66, 0x65, 0x20, 0x61, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61,
0x6e, 0x63, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x263, 0x65, 0x74, 0x6f, 0x256, 0x6f, 0x66, 0x65, 0x20, 0x61,
0x66, 0x72, 0x69, 0x6b, 0x61, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x42, 0x43,
0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x263, 0x65, 0x74, 0x6f, 0x256, 0x6f, 0x66, 0x65, 0x20, 0x61, 0x66, 0x72, 0x69,
0x6b, 0x61, 0x67, 0x61, 0x20, 0x43, 0x46, 0x41, 0x20, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f,
0x3b, 0x50, 0x69, 0x73, 0x6f, 0x20, 0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x3b,
0x70, 0x69, 0x73, 0x6f, 0x20, 0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x3b, 0x3b,
0x3b, 0x70, 0x69, 0x73, 0x6f, 0x20, 0x6e, 0x67, 0x20, 0x50, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x3b, 0x53,
0x63, 0x68, 0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x3b, 0x3b, 0x53, 0x63, 0x68,
0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x63, 0x68,
0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76,
0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b,
0x6e, 0x6f, 0x72, 0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x3b, 0x6e, 0x6f, 0x72,
0x67, 0x67, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75,
0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x72, 0x75, 0x6f, 0x167, 0x167,
0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x3b, 0x72, 0x75, 0x6f, 0x167, 0x167, 0x61, 0x20, 0x6b, 0x72,
0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x72, 0x75, 0x6f, 0x167, 0x167, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f,
0x3b, 0x3b, 0x3b, 0x72, 0x75, 0x6f, 0x167, 0x167, 0x61, 0x20, 0x6b, 0x72, 0x75, 0x76, 0x64, 0x6e, 0x6f, 0x3b, 0x53, 0x68,
0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x4d, 0x62, 0x75, 0x75, 0x257, 0x75, 0x20, 0x53, 0x65, 0x65, 0x66, 0x61, 0x61, 0x20, 0x42, 0x43, 0x45, 0x41,
0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x62, 0x75, 0x75, 0x257, 0x69, 0x20, 0x53, 0x65, 0x65, 0x66, 0x61,
0x61, 0x20, 0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x61, 0x6c, 0x61, 0x73, 0x69, 0x20,
0x47, 0x61, 0x6d, 0x6d, 0x62, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x61, 0x72, 0x20,
0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x79, 0x61, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x67, 0x69, 0x79,
0x79, 0x61, 0x20, 0x4d, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x61,
0x79, 0x72, 0x61, 0x61, 0x20, 0x4e, 0x69, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x4c, 0x65, 0x77, 0x6f, 0x6f, 0x6e, 0x20, 0x53, 0x65, 0x72, 0x61, 0x61, 0x20, 0x4c, 0x69, 0x79, 0x6f, 0x6e, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e,
0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4e, 0x6a, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x65, 0x65,
0x6c, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x65, 0x74, 0x69, 0x63, 0x61,
0x6c, 0x20, 0x64, 0x65, 0x20, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71, 0x75, 0x65, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x44, 0x6f, 0x6c, 0x61, 0x20, 0x79, 0x61, 0x73, 0x65, 0x20, 0x41, 0x6d, 0x65, 0x6c, 0x69, 0x6b, 0x61, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x68, 0x65, 0x6c, 0x65, 0x72, 0x69, 0x20, 0x73, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a,
0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x2d30, 0x2d37, 0x2d54, 0x2d49, 0x2d4e, 0x20, 0x2d4f, 0x20, 0x2d4d,
0x2d4e, 0x2d56, 0x2d54, 0x2d49, 0x2d31, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x61, 0x64, 0x72, 0x69, 0x6d, 0x20, 0x6e, 0x20,
0x6c, 0x6d, 0x263, 0x72, 0x69, 0x62, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20,
0x41, 0x7a, 0x7a, 0x61, 0x79, 0x72, 0x69, 0x3b, 0x3b, 0x41, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x20, 0x6e, 0x20, 0x5a, 0x7a,
0x61, 0x79, 0x65, 0x72, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x64, 0x69, 0x6e, 0x61, 0x72, 0x65, 0x6e, 0x20, 0x6e, 0x20, 0x5a,
0x7a, 0x61, 0x79, 0x65, 0x72, 0x3b, 0x45, 0x73, 0x68, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x55,
0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69,
0x20, 0x79, 0x61, 0x20, 0x48, 0x75, 0x74, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x53, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x65, 0x66, 0x61, 0x20, 0x46, 0x72, 0x61, 0x14b, 0x20, 0x28, 0x42,
0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x13a0, 0x13d5, 0x13b3, 0x3b, 0x3b,
0x55, 0x53, 0x20, 0x13a0, 0x13d5, 0x13b3, 0x3b, 0x3b, 0x3b, 0x3b, 0x55, 0x53, 0x20, 0x13a0, 0x13d5, 0x13b3, 0x3b, 0x72, 0x6f, 0x75,
0x70, 0x69, 0x20, 0x6d, 0x6f, 0x72, 0x69, 0x73, 0x69, 0x65, 0x6e, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x68,
0x69, 0x6c, 0xed, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0xed, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x65, 0x79, 0x61, 0x20, 0x59,
0x75, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6b, 0x75, 0x64, 0x75, 0x20, 0x4b,
0x61, 0x62, 0x75, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x75, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x6b, 0x75,
0x64, 0x75, 0x20, 0x4b, 0x61, 0x62, 0x75, 0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x75, 0x3b, 0x53, 0x69, 0x6c, 0x69,
0x6e, 0x67, 0x69, 0x74, 0x61, 0x62, 0x20, 0x79, 0x61, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x20, 0x44, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x69, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x49, 0x72, 0x6f, 0x70, 0x69,
0x79, 0x69, 0x61, 0x6e, 0xed, 0x20, 0x65, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x49, 0x72, 0x6f, 0x70, 0x69, 0x79, 0x69, 0x61, 0x6e, 0xed, 0x20, 0x65, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69,
0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x72, 0x69, 0x6e, 0x6a, 0x69, 0x20, 0x79, 0x61, 0x20, 0x4b,
0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20,
0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x64, 0x68, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41,
0x6e, 0x67, 0x6f, 0x2019, 0x6f, 0x74, 0x6f, 0x6c, 0x20, 0x6c, 0x6f, 0x6b, 0x2019, 0x20, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x41, 0x6e, 0x67, 0x6f, 0x2019, 0x6f, 0x74, 0x6f, 0x6c, 0x20, 0x6c, 0x6f, 0x6b,
0x2019, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x46, 0x41, 0x20, 0x46, 0x72,
0x61, 0x14b, 0x20, 0x28, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x53, 0x69, 0x6c,
0x69, 0x6e, 0x67, 0x20, 0x6d, 0x61, 0x72, 0x20, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x44, 0x65, 0x72, 0x68, 0x65, 0x6d, 0x20, 0x55, 0x6d, 0x65, 0x1e5b, 0x1e5b, 0x75, 0x6b, 0x69, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x73, 0x68, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x20, 0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e,
0x69, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x930, 0x93e, 0x902, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x420,
0x43e, 0x441, 0x441, 0x438, 0x439, 0x43d, 0x20, 0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x43d, 0x20,
0x441, 0x43e, 0x43c, 0x3b, 0x3b, 0x3b, 0x3b, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x439, 0x43d, 0x20, 0x441, 0x43e, 0x44c, 0x43c, 0x430,
0x448, 0x3b, 0x440, 0x461, 0x441, 0x441, 0x456, 0x301, 0x439, 0x441, 0x43a, 0x457, 0x439, 0x20, 0x440, 0xa64b, 0x301, 0x431, 0x43b, 0x44c,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x440, 0x461, 0x441, 0x441, 0x456, 0x301, 0x439, 0x441, 0x43a, 0x430, 0x433, 0x461, 0x20, 0x440,
0xa64b, 0x431, 0x43b, 0x467, 0x300, 0x3b, 0x4e, 0x66, 0x61, 0x6c, 0x61, 0x6e, 0x67, 0x61, 0x20, 0x77, 0x61, 0x20, 0x4b, 0x6f,
0x6e, 0x67, 0x75, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x43, 0x46, 0x41, 0x20, 0x46, 0xe0, 0x6c, 0xe2, 0x14b, 0x20,
0x42, 0x45, 0x41, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72, 0x1ce, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x20,
0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x65, 0x65, 0x66, 0x61, 0x20, 0x79,
0x61, 0x74, 0x69, 0x20, 0x42, 0x43, 0x45, 0x41, 0x4f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x259, 0x6c, 0xe1,
0x14b, 0x20, 0x43, 0x46, 0x41, 0x20, 0x28, 0x42, 0x45, 0x41, 0x43, 0x29, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x66,
0x72, 0xe1, 0x14b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x73, 0x6f, 0x6c, 0x61, 0x69, 0x20, 0x42, 0x45, 0x41, 0x43,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72, 0x61, 0x14b, 0x20, 0x43, 0x46, 0x41, 0x20, 0x42, 0x45, 0x41, 0x43,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x410, 0x440, 0x430, 0x441, 0x441, 0x44b, 0x44b, 0x439, 0x430, 0x20, 0x441, 0x43e, 0x43b,
0x43a, 0x443, 0x43e, 0x431, 0x430, 0x439, 0x430, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x410, 0x440, 0x430, 0x441, 0x441, 0x44b, 0x44b,
0x439, 0x430, 0x20, 0x441, 0x43e, 0x43b, 0x43a, 0x443, 0x43e, 0x431, 0x430, 0x439, 0x430, 0x3b, 0x49, 0x68, 0x65, 0x6c, 0x61, 0x20,
0x79, 0x61, 0x20, 0x54, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0x69, 0x79, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0xa55e,
0xa524, 0xa52b, 0xa569, 0x20, 0xa55c, 0xa55e, 0xa54c, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x4c, 0x61, 0x69, 0x62, 0x68, 0x69,
0x79, 0x61, 0x20, 0x44, 0x61, 0x6c, 0x61, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x25b, 0x6c, 0xe2, 0x14b, 0x3b,
0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x20, 0x43, 0x46, 0x41, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
0x3b, 0x3b, 0x73, 0x68, 0x69, 0x72, 0xe8, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x66, 0x65, 0x6c, 0xe1, 0x14b, 0x20,
0x43, 0x46, 0x41, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x62f, 0x6cc, 0x646, 0x627, 0x631, 0x6cc, 0x20, 0x639, 0x6ce, 0x631,
0x627, 0x642, 0x6cc, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x695, 0x6cc, 0x627, 0x6b5, 0x6cc, 0x20, 0x626, 0x6ce, 0x631, 0x627,
0x646, 0x6cc, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b,
0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x6f,
0x3b, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x65, 0x75, 0x72, 0x61, 0x6a, 0x3b, 0x65, 0x75, 0x72, 0x61, 0x3b, 0x3b, 0x65,
0x75, 0x72, 0x6f, 0x77, 0x3b, 0x65, 0x75, 0x72, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x6cc, 0x631, 0x627,
0x646, 0x20, 0x631, 0x6cc, 0x627, 0x644, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x20, 0x631, 0x6cc,
0x627, 0x644, 0x3b, 0x6e2f, 0x5e63, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x6e2f, 0x5e63, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70,
0x70, 0x69, 0x6e, 0x65, 0x20, 0x50, 0x69, 0x73, 0x6f, 0x3b, 0x3b, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e,
0x65, 0x20, 0x70, 0x69, 0x73, 0x6f, 0x3b, 0x3b, 0x3b, 0x3b, 0x4d, 0x67, 0x61, 0x20, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70,
0x70, 0x69, 0x6e, 0x65, 0x20, 0x70, 0x69, 0x73, 0x6f, 0x3b
};

static const ushort currency_format_data[] = {
0x25, 0x31, 0x25, 0x32, 0x25, 0x32, 0x25, 0x31, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x25, 0x31, 0xa0, 0x25, 0x32, 0x25, 0x32,
0x25, 0x31, 0x4b, 0x25, 0x32, 0xa0, 0x2d, 0x25, 0x31, 0x28, 0x25, 0x31, 0xa0, 0x25, 0x32, 0x29, 0x25, 0x32, 0x2d, 0x25,
0x31, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x4b, 0x25, 0x31, 0xa0, 0x6b, 0x25, 0x32, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x2d, 0x25,
0x32, 0x2212, 0x25, 0x31, 0x25, 0x32, 0xa0, 0x25, 0x31, 0x44, 0x200f, 0x25, 0x31, 0xa0, 0x25, 0x32, 0x200f, 0x200e, 0x2d, 0x25,
0x31, 0xa0, 0x25, 0x32, 0x200e, 0x25, 0x32, 0x25, 0x31, 0x28, 0x25, 0x32, 0x25, 0x31, 0x29, 0x25, 0x31, 0xa0, 0x4b, 0xa0,
0x25, 0x32, 0x25, 0x32, 0xa0, 0x4d, 0x25, 0x31, 0x25, 0x32, 0x2d, 0x4d, 0x25, 0x31, 0x25, 0x32, 0x2d, 0xa0, 0x25, 0x31
};

static const ushort endonyms_data[] = {
0x4f, 0x72, 0x6f, 0x6d, 0x6f, 0x6f, 0x49, 0x74, 0x6f, 0x6f, 0x70, 0x68, 0x69, 0x79, 0x61, 0x61, 0x4b, 0x65, 0x65, 0x6e,
0x69, 0x79, 0x61, 0x61, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x61, 0x6e, 0x73, 0x53, 0x75, 0x69, 0x64, 0x2d, 0x41, 0x66,
0x72, 0x69, 0x6b, 0x61, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0xeb, 0x73, 0x68, 0x71, 0x69, 0x70, 0x53, 0x68, 0x71, 0x69,
0x70, 0xeb, 0x72, 0x69, 0x4d, 0x61, 0x71, 0x65, 0x64, 0x6f, 0x6e, 0x69, 0x61, 0x20, 0x65, 0x20, 0x56, 0x65, 0x72, 0x69,
0x75, 0x74, 0x4b, 0x6f, 0x73, 0x6f, 0x76, 0xeb, 0x12a0, 0x121b, 0x122d, 0x129b, 0x12a2, 0x1275, 0x12ee, 0x1335, 0x12eb, 0x627, 0x644, 0x639,
0x631, 0x628, 0x64a, 0x629, 0x645, 0x635, 0x631, 0x627, 0x644, 0x62c, 0x632, 0x627, 0x626, 0x631, 0x627, 0x644, 0x628, 0x62d, 0x631, 0x64a,
0x646, 0x62a, 0x634, 0x627, 0x62f, 0x62c, 0x632, 0x631, 0x20, 0x627, 0x644, 0x642, 0x645, 0x631, 0x62c, 0x64a, 0x628, 0x648, 0x62a, 0x64a,
0x625, 0x631, 0x64a, 0x62a, 0x631, 0x64a, 0x627, 0x627, 0x644, 0x639, 0x631, 0x627, 0x642, 0x625, 0x633, 0x631, 0x627, 0x626, 0x64a, 0x644,
0x627, 0x644, 0x623, 0x631, 0x62f, 0x646, 0x627, 0x644, 0x643, 0x648, 0x64a, 0x62a, 0x644, 0x628, 0x646, 0x627, 0x646, 0x644, 0x64a, 0x628,
0x64a, 0x627, 0x645, 0x648, 0x631, 0x64a, 0x62a, 0x627, 0x646, 0x64a, 0x627, 0x627, 0x644, 0x645, 0x63a, 0x631, 0x628, 0x639, 0x64f, 0x645,
0x627, 0x646, 0x627, 0x644, 0x623, 0x631, 0x627, 0x636, 0x64a, 0x20, 0x627, 0x644, 0x641, 0x644, 0x633, 0x637, 0x64a, 0x646, 0x64a, 0x629,
0x642, 0x637, 0x631, 0x627, 0x644, 0x645, 0x645, 0x644, 0x643, 0x629, 0x20, 0x627, 0x644, 0x639, 0x631, 0x628, 0x64a, 0x629, 0x20, 0x627,
0x644, 0x633, 0x639, 0x648, 0x62f, 0x64a, 0x629, 0x627, 0x644, 0x635, 0x648, 0x645, 0x627, 0x644, 0x627, 0x644, 0x633, 0x648, 0x62f, 0x627,
0x646, 0x633, 0x648, 0x631, 0x64a, 0x627, 0x62a, 0x648, 0x646, 0x633, 0x627, 0x644, 0x625, 0x645, 0x627, 0x631, 0x627, 0x62a, 0x20, 0x627,
0x644, 0x639, 0x631, 0x628, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x645, 0x62a, 0x62d, 0x62f, 0x629, 0x627, 0x644, 0x635, 0x62d, 0x631, 0x627,
0x621, 0x20, 0x627, 0x644, 0x63a, 0x631, 0x628, 0x64a, 0x629, 0x627, 0x644, 0x64a, 0x645, 0x646, 0x62c, 0x646, 0x648, 0x628, 0x20, 0x627,
0x644, 0x633, 0x648, 0x62f, 0x627, 0x646, 0x627, 0x644, 0x639, 0x631, 0x628, 0x64a, 0x629, 0x20, 0x627, 0x644, 0x641, 0x635, 0x62d, 0x649,
0x20, 0x627, 0x644, 0x62d, 0x62f, 0x64a, 0x62b, 0x629, 0x627, 0x644, 0x639, 0x627, 0x644, 0x645, 0x570, 0x561, 0x575, 0x565, 0x580, 0x565,
0x576, 0x540, 0x561, 0x575, 0x561, 0x57d, 0x57f, 0x561, 0x576, 0x985, 0x9b8, 0x9ae, 0x9c0, 0x9af, 0x9bc, 0x9be, 0x9ad, 0x9be, 0x9f0, 0x9a4,
0x61, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e, 0x41, 0x7a, 0x259, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6e,
0x430, 0x437, 0x4d9, 0x440, 0x431, 0x430, 0x458, 0x4b9, 0x430, 0x43d, 0x410, 0x437, 0x4d9, 0x440, 0x431, 0x430, 0x458, 0x4b9, 0x430, 0x43d,
0x65, 0x75, 0x73, 0x6b, 0x61, 0x72, 0x61, 0x45, 0x73, 0x70, 0x61, 0x69, 0x6e, 0x69, 0x61, 0x9ac, 0x9be, 0x982, 0x9b2, 0x9be,
0x9ac, 0x9be, 0x982, 0x9b2, 0x9be, 0x9a6, 0x9c7, 0x9b6, 0x9ad, 0x9be, 0x9b0, 0x9a4, 0xf62, 0xfab, 0xf7c, 0xf44, 0xf0b, 0xf41, 0xf60, 0xf56,
0xfb2, 0xf74, 0xf42, 0x62, 0x72, 0x65, 0x7a, 0x68, 0x6f, 0x6e, 0x65, 0x67, 0x46, 0x72, 0x61, 0xf1, 0x73, 0x431, 0x44a, 0x43b,
0x433, 0x430, 0x440, 0x441, 0x43a, 0x438, 0x411, 0x44a, 0x43b, 0x433, 0x430, 0x440, 0x438, 0x44f, 0x1019, 0x103c, 0x1014, 0x103a, 0x1019, 0x102c,
0x431, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x43a, 0x430, 0x44f, 0x411, 0x435, 0x43b, 0x430, 0x440, 0x443, 0x441, 0x44c, 0x1781, 0x17d2,
0x1798, 0x17c2, 0x179a, 0x1780, 0x1798, 0x17d2, 0x1796, 0x17bb, 0x1787, 0x17b6, 0x63, 0x61, 0x74, 0x61, 0x6c, 0xe0, 0x45, 0x73, 0x70, 0x61,
0x6e, 0x79, 0x61, 0x41, 0x6e, 0x64, 0x6f, 0x72, 0x72, 0x61, 0x46, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x49, 0x74, 0xe0, 0x6c,
0x69, 0x61, 0x7b80, 0x4f53, 0x4e2d, 0x6587, 0x4e2d, 0x56fd, 0x4e2d, 0x56fd, 0x9999, 0x6e2f, 0x7279, 0x522b, 0x884c, 0x653f, 0x533a, 0x4e2d, 0x56fd, 0x6fb3,
0x95e8, 0x7279, 0x522b, 0x884c, 0x653f, 0x533a, 0x65b0, 0x52a0, 0x5761, 0x7e41, 0x9ad4, 0x4e2d, 0x6587, 0x4e2d, 0x570b, 0x9999, 0x6e2f, 0x7279, 0x5225, 0x884c,
0x653f, 0x5340, 0x4e2d, 0x570b, 0x6fb3, 0x9580, 0x7279, 0x5225, 0x884c, 0x653f, 0x5340, 0x53f0, 0x7063, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b,
0x69, 0x48, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x61, 0x42, 0x6f, 0x73, 0x6e, 0x61, 0x20, 0x69, 0x20, 0x48, 0x65, 0x72,
0x63, 0x65, 0x67, 0x6f, 0x76, 0x69, 0x6e, 0x61, 0x10d, 0x65, 0x161, 0x74, 0x69, 0x6e, 0x61, 0x10c, 0x65, 0x73, 0x6b, 0x6f,
0x64, 0x61, 0x6e, 0x73, 0x6b, 0x44, 0x61, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x47, 0x72, 0xf8, 0x6e, 0x6c, 0x61, 0x6e, 0x64,
0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x41,
0x72, 0x75, 0x62, 0x61, 0x42, 0x65, 0x6c, 0x67, 0x69, 0xeb, 0x43, 0x75, 0x72, 0x61, 0xe7, 0x61, 0x6f, 0x53, 0x75, 0x72,
0x69, 0x6e, 0x61, 0x6d, 0x65, 0x43, 0x61, 0x72, 0x69, 0x62, 0x69, 0x73, 0x63, 0x68, 0x20, 0x4e, 0x65, 0x64, 0x65, 0x72,
0x6c, 0x61, 0x6e, 0x64, 0x53, 0x69, 0x6e, 0x74, 0x2d, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x65, 0x6e, 0x41, 0x6d, 0x65, 0x72,
0x69, 0x63, 0x61, 0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x53,
0x74, 0x61, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e,
0x20, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x41, 0x6e, 0x67, 0x75, 0x69, 0x6c, 0x6c, 0x61, 0x41, 0x6e, 0x74, 0x69, 0x67, 0x75,
0x61, 0x20, 0x26, 0x20, 0x42, 0x61, 0x72, 0x62, 0x75, 0x64, 0x61, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61,
0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69, 0x61, 0x41, 0x75,
0x73, 0x74, 0x72, 0x69, 0x61, 0x42, 0x61, 0x68, 0x61, 0x6d, 0x61, 0x73, 0x42, 0x61, 0x72, 0x62, 0x61, 0x64, 0x6f, 0x73,
0x42, 0x65, 0x6c, 0x67, 0x69, 0x75, 0x6d, 0x42, 0x65, 0x6c, 0x69, 0x7a, 0x65, 0x42, 0x65, 0x72, 0x6d, 0x75, 0x64, 0x61,
0x42, 0x6f, 0x74, 0x73, 0x77, 0x61, 0x6e, 0x61, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x49, 0x6e, 0x64, 0x69,
0x61, 0x6e, 0x20, 0x4f, 0x63, 0x65, 0x61, 0x6e, 0x20, 0x54, 0x65, 0x72, 0x72, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x75,
0x72, 0x75, 0x6e, 0x64, 0x69, 0x43, 0x61, 0x6d, 0x65, 0x72, 0x6f, 0x6f, 0x6e, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61,
0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x61, 0x43, 0x61, 0x79, 0x6d, 0x61,
0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x6d, 0x61, 0x73, 0x20, 0x49,
0x73, 0x6c, 0x61, 0x6e, 0x64, 0x43, 0x6f, 0x63, 0x6f, 0x73, 0x20, 0x28, 0x4b, 0x65, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x29,
0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x43, 0x6f, 0x6f, 0x6b, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73,
0x43, 0x79, 0x70, 0x72, 0x75, 0x73, 0x44, 0x65, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63,
0x61, 0x45, 0x72, 0x69, 0x74, 0x72, 0x65, 0x61, 0x46, 0x61, 0x6c, 0x6b, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x73, 0x6c,
0x61, 0x6e, 0x64, 0x73, 0x46, 0x69, 0x6a, 0x69, 0x46, 0x69, 0x6e, 0x6c, 0x61, 0x6e, 0x64, 0x47, 0x75, 0x65, 0x72, 0x6e,
0x73, 0x65, 0x79, 0x47, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x79, 0x47, 0x68, 0x61, 0x6e,
0x61, 0x47, 0x69, 0x62, 0x72, 0x61, 0x6c, 0x74, 0x61, 0x72, 0x47, 0x72, 0x65, 0x6e, 0x61, 0x64, 0x61, 0x47, 0x75, 0x61,
0x6d, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x61, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x53, 0x41, 0x52,
0x20, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x49, 0x72, 0x65, 0x6c, 0x61, 0x6e, 0x64, 0x49, 0x73,
0x72, 0x61, 0x65, 0x6c, 0x4a, 0x61, 0x6d, 0x61, 0x69, 0x63, 0x61, 0x4b, 0x65, 0x6e, 0x79, 0x61, 0x4b, 0x69, 0x72, 0x69,
0x62, 0x61, 0x74, 0x69, 0x4c, 0x65, 0x73, 0x6f, 0x74, 0x68, 0x6f, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69, 0x61, 0x4d, 0x61,
0x63, 0x61, 0x6f, 0x20, 0x53, 0x41, 0x52, 0x20, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x4d, 0x61, 0x64, 0x61, 0x67, 0x61, 0x73,
0x63, 0x61, 0x72, 0x4d, 0x61, 0x6c, 0x61, 0x77, 0x69, 0x4d, 0x61, 0x6c, 0x61, 0x79, 0x73, 0x69, 0x61, 0x4d, 0x61, 0x6c,
0x74, 0x61, 0x4d, 0x61, 0x72, 0x73, 0x68, 0x61, 0x6c, 0x6c, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x4d, 0x61,
0x75, 0x72, 0x69, 0x74, 0x69, 0x75, 0x73, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x4d, 0x6f, 0x6e,
0x74, 0x73, 0x65, 0x72, 0x72, 0x61, 0x74, 0x4e, 0x61, 0x6d, 0x69, 0x62, 0x69, 0x61, 0x4e, 0x61, 0x75, 0x72, 0x75, 0x4e,
0x65, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c, 0x61, 0x6e,
0x64, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x69, 0x61, 0x4e, 0x69, 0x75, 0x65, 0x4e, 0x6f, 0x72, 0x66, 0x6f, 0x6c, 0x6b, 0x20,
0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x4e, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x20, 0x4d, 0x61, 0x72, 0x69, 0x61,
0x6e, 0x61, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x50, 0x61, 0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x50, 0x61,
0x6c, 0x61, 0x75, 0x50, 0x61, 0x70, 0x75, 0x61, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x50,
0x68, 0x69, 0x6c, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x65, 0x73, 0x50, 0x69, 0x74, 0x63, 0x61, 0x69, 0x72, 0x6e, 0x20, 0x49,
0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x50, 0x75, 0x65, 0x72, 0x74, 0x6f, 0x20, 0x52, 0x69, 0x63, 0x6f, 0x52, 0x77, 0x61,
0x6e, 0x64, 0x61, 0x53, 0x74, 0x20, 0x4b, 0x69, 0x74, 0x74, 0x73, 0x20, 0x26, 0x20, 0x4e, 0x65, 0x76, 0x69, 0x73, 0x53,
0x74, 0x20, 0x4c, 0x75, 0x63, 0x69, 0x61, 0x53, 0x74, 0x20, 0x56, 0x69, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x20, 0x26, 0x20,
0x47, 0x72, 0x65, 0x6e, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x53, 0x61, 0x6d, 0x6f, 0x61, 0x53, 0x65, 0x79, 0x63, 0x68,
0x65, 0x6c, 0x6c, 0x65, 0x73, 0x53, 0x69, 0x65, 0x72, 0x72, 0x61, 0x20, 0x4c, 0x65, 0x6f, 0x6e, 0x65, 0x53, 0x69, 0x6e,
0x67, 0x61, 0x70, 0x6f, 0x72, 0x65, 0x53, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x69, 0x61, 0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f,
0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63,
0x61, 0x53, 0x74, 0x20, 0x48, 0x65, 0x6c, 0x65, 0x6e, 0x61, 0x53, 0x75, 0x64, 0x61, 0x6e, 0x45, 0x73, 0x77, 0x61, 0x74,
0x69, 0x6e, 0x69, 0x53, 0x77, 0x65, 0x64, 0x65, 0x6e, 0x53, 0x77, 0x69, 0x74, 0x7a, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64,
0x54, 0x61, 0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x54, 0x6f, 0x6b, 0x65, 0x6c, 0x61, 0x75, 0x54, 0x6f, 0x6e, 0x67, 0x61,
0x54, 0x72, 0x69, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x20, 0x26, 0x20, 0x54, 0x6f, 0x62, 0x61, 0x67, 0x6f, 0x54, 0x75, 0x72,
0x6b, 0x73, 0x20, 0x26, 0x20, 0x43, 0x61, 0x69, 0x63, 0x6f, 0x73, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x54,
0x75, 0x76, 0x61, 0x6c, 0x75, 0x55, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x41, 0x72,
0x61, 0x62, 0x20, 0x45, 0x6d, 0x69, 0x72, 0x61, 0x74, 0x65, 0x73, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x45,
0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x4b, 0x69, 0x6e, 0x67, 0x64, 0x6f, 0x6d,
0x55, 0x2e, 0x53, 0x2e, 0x20, 0x4f, 0x75, 0x74, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64,
0x73, 0x56, 0x61, 0x6e, 0x75, 0x61, 0x74, 0x75, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x20, 0x56, 0x69, 0x72, 0x67,
0x69, 0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x55, 0x2e, 0x53, 0x2e, 0x20, 0x56, 0x69, 0x72, 0x67, 0x69,
0x6e, 0x20, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x5a, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x5a, 0x69, 0x6d, 0x62, 0x61,
0x62, 0x77, 0x65, 0x44, 0x69, 0x65, 0x67, 0x6f, 0x20, 0x47, 0x61, 0x72, 0x63, 0x69, 0x61, 0x49, 0x73, 0x6c, 0x65, 0x20,
0x6f, 0x66, 0x20, 0x4d, 0x61, 0x6e, 0x4a, 0x65, 0x72, 0x73, 0x65, 0x79, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x53, 0x75,
0x64, 0x61, 0x6e, 0x53, 0x69, 0x6e, 0x74, 0x20, 0x4d, 0x61, 0x61, 0x72, 0x74, 0x65, 0x6e, 0x57, 0x6f, 0x72, 0x6c, 0x64,
0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x65, 0x73, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x74, 0x6f, 0x4d, 0x6f, 0x6e, 0x64, 0x6f,
0x65, 0x65, 0x73, 0x74, 0x69, 0x45, 0x65, 0x73, 0x74, 0x69, 0x66, 0xf8, 0x72, 0x6f, 0x79, 0x73, 0x6b, 0x74, 0x46, 0xf8,
0x72, 0x6f, 0x79, 0x61, 0x72, 0x73, 0x75, 0x6f, 0x6d, 0x69, 0x53, 0x75, 0x6f, 0x6d, 0x69, 0x66, 0x72, 0x61, 0x6e, 0xe7,
0x61, 0x69, 0x73, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x6c, 0x67, 0xe9, 0x72, 0x69, 0x65, 0x42, 0x65, 0x6c, 0x67,
0x69, 0x71, 0x75, 0x65, 0x42, 0xe9, 0x6e, 0x69, 0x6e, 0x42, 0x75, 0x72, 0x6b, 0x69, 0x6e, 0x61, 0x20, 0x46, 0x61, 0x73,
0x6f, 0x43, 0x61, 0x6d, 0x65, 0x72, 0x6f, 0x75, 0x6e, 0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x20, 0x63, 0x61,
0x6e, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x52, 0xe9, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x71, 0x75, 0x65, 0x20, 0x63, 0x65, 0x6e,
0x74, 0x72, 0x61, 0x66, 0x72, 0x69, 0x63, 0x61, 0x69, 0x6e, 0x65, 0x54, 0x63, 0x68, 0x61, 0x64, 0x43, 0x6f, 0x6d, 0x6f,
0x72, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x67, 0x6f, 0x2d, 0x4b, 0x69, 0x6e, 0x73, 0x68, 0x61, 0x73, 0x61, 0x43, 0x6f, 0x6e,
0x67, 0x6f, 0x2d, 0x42, 0x72, 0x61, 0x7a, 0x7a, 0x61, 0x76, 0x69, 0x6c, 0x6c, 0x65, 0x43, 0xf4, 0x74, 0x65, 0x20, 0x64,
0x2019, 0x49, 0x76, 0x6f, 0x69, 0x72, 0x65, 0x44, 0x6a, 0x69, 0x62, 0x6f, 0x75, 0x74, 0x69, 0x47, 0x75, 0x69, 0x6e, 0xe9,
0x65, 0x20, 0xe9, 0x71, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x65, 0x47, 0x75, 0x79, 0x61, 0x6e, 0x65, 0x20,
0x66, 0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x65, 0x50, 0x6f, 0x6c, 0x79, 0x6e, 0xe9, 0x73, 0x69, 0x65, 0x20, 0x66,
0x72, 0x61, 0x6e, 0xe7, 0x61, 0x69, 0x73, 0x65, 0x47, 0x61, 0x62, 0x6f, 0x6e, 0x47, 0x75, 0x61, 0x64, 0x65, 0x6c, 0x6f,
0x75, 0x70, 0x65, 0x47, 0x75, 0x69, 0x6e, 0xe9, 0x65, 0x48, 0x61, 0xef, 0x74, 0x69, 0x4c, 0x75, 0x78, 0x65, 0x6d, 0x62,
0x6f, 0x75, 0x72, 0x67, 0x4d, 0x61, 0x6c, 0x69, 0x4d, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x4d, 0x61,
0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x65, 0x4d, 0x61, 0x75, 0x72, 0x69, 0x63, 0x65, 0x4d, 0x61, 0x79, 0x6f, 0x74,
0x74, 0x65, 0x4d, 0x6f, 0x6e, 0x61, 0x63, 0x6f, 0x4d, 0x61, 0x72, 0x6f, 0x63, 0x4e, 0x6f, 0x75, 0x76, 0x65, 0x6c, 0x6c,
0x65, 0x2d, 0x43, 0x61, 0x6c, 0xe9, 0x64, 0x6f, 0x6e, 0x69, 0x65, 0x4e, 0x69, 0x67, 0x65, 0x72, 0x4c, 0x61, 0x20, 0x52,
0xe9, 0x75, 0x6e, 0x69, 0x6f, 0x6e, 0x53, 0xe9, 0x6e, 0xe9, 0x67, 0x61, 0x6c, 0x53, 0x61, 0x69, 0x6e, 0x74, 0x2d, 0x50,
0x69, 0x65, 0x72, 0x72, 0x65, 0x2d, 0x65, 0x74, 0x2d, 0x4d, 0x69, 0x71, 0x75, 0x65, 0x6c, 0x6f, 0x6e, 0x66, 0x72, 0x61,
0x6e, 0xe7, 0x61, 0x69, 0x73, 0x20, 0x73, 0x75, 0x69, 0x73, 0x73, 0x65, 0x53, 0x75, 0x69, 0x73, 0x73, 0x65, 0x53, 0x79,
0x72, 0x69, 0x65, 0x54, 0x6f, 0x67, 0x6f, 0x54, 0x75, 0x6e, 0x69, 0x73, 0x69, 0x65, 0x57, 0x61, 0x6c, 0x6c, 0x69, 0x73,
0x2d, 0x65, 0x74, 0x2d, 0x46, 0x75, 0x74, 0x75, 0x6e, 0x61, 0x53, 0x61, 0x69, 0x6e, 0x74, 0x2d, 0x42, 0x61, 0x72, 0x74,
0x68, 0xe9, 0x6c, 0x65, 0x6d, 0x79, 0x53, 0x61, 0x69, 0x6e, 0x74, 0x2d, 0x4d, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x46, 0x72,
0x79, 0x73, 0x6b, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0xe2, 0x6e, 0x47, 0xe0, 0x69, 0x64, 0x68, 0x6c, 0x69, 0x67, 0x41,
0x6e, 0x20, 0x52, 0xec, 0x6f, 0x67, 0x68, 0x61, 0x63, 0x68, 0x64, 0x20, 0x41, 0x6f, 0x6e, 0x61, 0x69, 0x63, 0x68, 0x74,
0x65, 0x67, 0x61, 0x6c, 0x65, 0x67, 0x6f, 0x45, 0x73, 0x70, 0x61, 0xf1, 0x61, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10e3, 0x10da, 0x10d8,
0x10e1, 0x10d0, 0x10e5, 0x10d0, 0x10e0, 0x10d7, 0x10d5, 0x10d4, 0x10da, 0x10dd, 0x44, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x44, 0x65, 0x75,
0x74, 0x73, 0x63, 0x68, 0x6c, 0x61, 0x6e, 0x64, 0xd6, 0x73, 0x74, 0x65, 0x72, 0x72, 0x65, 0x69, 0x63, 0x68, 0x69, 0x73,
0x63, 0x68, 0x65, 0x73, 0x20, 0x44, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0xd6, 0x73, 0x74, 0x65, 0x72, 0x72, 0x65, 0x69,
0x63, 0x68, 0x42, 0x65, 0x6c, 0x67, 0x69, 0x65, 0x6e, 0x49, 0x74, 0x61, 0x6c, 0x69, 0x65, 0x6e, 0x4c, 0x69, 0x65, 0x63,
0x68, 0x74, 0x65, 0x6e, 0x73, 0x74, 0x65, 0x69, 0x6e, 0x4c, 0x75, 0x78, 0x65, 0x6d, 0x62, 0x75, 0x72, 0x67, 0x53, 0x63,
0x68, 0x77, 0x65, 0x69, 0x7a, 0x65, 0x72, 0x20, 0x48, 0x6f, 0x63, 0x68, 0x64, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x53,
0x63, 0x68, 0x77, 0x65, 0x69, 0x7a, 0x395, 0x3bb, 0x3bb, 0x3b7, 0x3bd, 0x3b9, 0x3ba, 0x3ac, 0x395, 0x3bb, 0x3bb, 0x3ac, 0x3b4, 0x3b1,
0x39a, 0x3cd, 0x3c0, 0x3c1, 0x3bf, 0x3c2, 0x6b, 0x61, 0x6c, 0x61, 0x61, 0x6c, 0x6c, 0x69, 0x73, 0x75, 0x74, 0x4b, 0x61, 0x6c,
0x61, 0x61, 0x6c, 0x6c, 0x69, 0x74, 0x20, 0x4e, 0x75, 0x6e, 0x61, 0x61, 0x74, 0xa97, 0xac1, 0xa9c, 0xab0, 0xabe, 0xaa4, 0xac0,
0xaad, 0xabe, 0xab0, 0xaa4, 0x48, 0x61, 0x75, 0x73, 0x61, 0x4e, 0x61, 0x6a, 0x65, 0x72, 0x69, 0x79, 0x61, 0x47, 0x61, 0x6e,
0x61, 0x4e, 0x69, 0x6a, 0x61, 0x72, 0x5e2, 0x5d1, 0x5e8, 0x5d9, 0x5ea, 0x5d9, 0x5e9, 0x5e8, 0x5d0, 0x5dc, 0x939, 0x93f, 0x928, 0x94d,
0x926, 0x940, 0x92d, 0x93e, 0x930, 0x924, 0x6d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x4d, 0x61, 0x67, 0x79, 0x61, 0x72, 0x6f, 0x72,
0x73, 0x7a, 0xe1, 0x67, 0xed, 0x73, 0x6c, 0x65, 0x6e, 0x73, 0x6b, 0x61, 0xcd, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x49, 0x6e,
0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6c, 0x69, 0x6e, 0x67, 0x75, 0x61, 0x4d, 0x75,
0x6e, 0x64, 0x6f, 0x47, 0x61, 0x65, 0x69, 0x6c, 0x67, 0x65, 0xc9, 0x69, 0x72, 0x65, 0x61, 0x6e, 0x20, 0x52, 0xed, 0x6f,
0x63, 0x68, 0x74, 0x20, 0x41, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x74, 0x68, 0x65, 0x69, 0x74, 0x61, 0x6c, 0x69, 0x61, 0x6e,
0x6f, 0x49, 0x74, 0x61, 0x6c, 0x69, 0x61, 0x53, 0x61, 0x6e, 0x20, 0x4d, 0x61, 0x72, 0x69, 0x6e, 0x6f, 0x53, 0x76, 0x69,
0x7a, 0x7a, 0x65, 0x72, 0x61, 0x43, 0x69, 0x74, 0x74, 0xe0, 0x20, 0x64, 0x65, 0x6c, 0x20, 0x56, 0x61, 0x74, 0x69, 0x63,
0x61, 0x6e, 0x6f, 0x65e5, 0x672c, 0x8a9e, 0x65e5, 0x672c, 0x4a, 0x61, 0x77, 0x61, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0xe9, 0x73, 0x69,
0x61, 0xc95, 0xca8, 0xccd, 0xca8, 0xca1, 0xcad, 0xcbe, 0xcb0, 0xca4, 0x6a9, 0x672, 0x634, 0x64f, 0x631, 0x6c1, 0x650, 0x646, 0x62f, 0x648,
0x633, 0x62a, 0x627, 0x646, 0x49b, 0x430, 0x437, 0x430, 0x49b, 0x20, 0x442, 0x456, 0x43b, 0x456, 0x49a, 0x430, 0x437, 0x430, 0x49b, 0x441,
0x442, 0x430, 0x43d, 0x4b, 0x69, 0x6e, 0x79, 0x61, 0x72, 0x77, 0x61, 0x6e, 0x64, 0x61, 0x55, 0x20, 0x52, 0x77, 0x61, 0x6e,
0x64, 0x61, 0x43a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x447, 0x430, 0x41a, 0x44b, 0x440, 0x433, 0x44b, 0x437, 0x441, 0x442, 0x430, 0x43d,
0xd55c, 0xad6d, 0xc5b4, 0xb300, 0xd55c, 0xbbfc, 0xad6d, 0xc870, 0xc120, 0xbbfc, 0xc8fc, 0xc8fc, 0xc758, 0xc778, 0xbbfc, 0xacf5, 0xd654, 0xad6d, 0x6b, 0x75,
0x72, 0x64, 0xee, 0x54, 0x69, 0x72, 0x6b, 0x69, 0x79, 0x65, 0x49, 0x6b, 0x69, 0x72, 0x75, 0x6e, 0x64, 0x69, 0x55, 0x62,
0x75, 0x72, 0x75, 0x6e, 0x64, 0x69, 0xea5, 0xeb2, 0xea7, 0x6c, 0x61, 0x74, 0x76, 0x69, 0x65, 0x161, 0x75, 0x4c, 0x61, 0x74,
0x76, 0x69, 0x6a, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0xe1, 0x6c, 0x61, 0x52, 0x65, 0x70, 0x75, 0x62, 0x6c, 0xed, 0x6b, 0x69,
0x20, 0x79, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0xf3, 0x20, 0x44, 0x65, 0x6d, 0x6f, 0x6b, 0x72, 0x61, 0x74, 0xed, 0x6b,
0x69, 0x41, 0x6e, 0x67, 0xf3, 0x6c, 0x61, 0x52, 0x65, 0x70, 0x69, 0x62, 0x69, 0x6b, 0x69, 0x20, 0x79, 0x61, 0x20, 0x41,
0x66, 0x72, 0xed, 0x6b, 0x61, 0x20, 0x79, 0x61, 0x20, 0x4b, 0xe1, 0x74, 0x69, 0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x6c, 0x69,
0x65, 0x74, 0x75, 0x76, 0x69, 0x173, 0x4c, 0x69, 0x65, 0x74, 0x75, 0x76, 0x61, 0x43c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d,
0x441, 0x43a, 0x438, 0x421, 0x435, 0x432, 0x435, 0x440, 0x43d, 0x430, 0x20, 0x41c, 0x430, 0x43a, 0x435, 0x434, 0x43e, 0x43d, 0x438, 0x458,
0x430, 0x4d, 0x61, 0x6c, 0x61, 0x67, 0x61, 0x73, 0x79, 0x4d, 0x61, 0x64, 0x61, 0x67, 0x61, 0x73, 0x69, 0x6b, 0x61, 0x72,
0x61, 0x4d, 0x65, 0x6c, 0x61, 0x79, 0x75, 0x42, 0x72, 0x75, 0x6e, 0x65, 0x69, 0x53, 0x69, 0x6e, 0x67, 0x61, 0x70, 0x75,
0x72, 0x61, 0xd2e, 0xd32, 0xd2f, 0xd3e, 0xd33, 0xd02, 0xd07, 0xd28, 0xd4d, 0xd24, 0xd4d, 0xd2f, 0x4d, 0x61, 0x6c, 0x74, 0x69, 0x4d,
0x101, 0x6f, 0x72, 0x69, 0x41, 0x6f, 0x74, 0x65, 0x61, 0x72, 0x6f, 0x61, 0x92e, 0x930, 0x93e, 0x920, 0x940, 0x43c, 0x43e, 0x43d,
0x433, 0x43e, 0x43b, 0x41c, 0x43e, 0x43d, 0x433, 0x43e, 0x43b, 0x928, 0x947, 0x92a, 0x93e, 0x932, 0x940, 0x928, 0x947, 0x92a, 0x93e, 0x932,
0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x62, 0x6f, 0x6b, 0x6d, 0xe5, 0x6c, 0x4e, 0x6f, 0x72, 0x67, 0x65, 0x53, 0x76, 0x61,
0x6c, 0x62, 0x61, 0x72, 0x64, 0x20, 0x6f, 0x67, 0x20, 0x4a, 0x61, 0x6e, 0x20, 0x4d, 0x61, 0x79, 0x65, 0x6e, 0xb13, 0xb21,
0xb3c, 0xb3f, 0xb06, 0xb2d, 0xb3e, 0xb30, 0xb24, 0x67e, 0x69a, 0x62a, 0x648, 0x627, 0x641, 0x63a, 0x627, 0x646, 0x633, 0x62a, 0x627, 0x646,
0x67e, 0x627, 0x6a9, 0x633, 0x62a, 0x627, 0x646, 0x641, 0x627, 0x631, 0x633, 0x6cc, 0x627, 0x6cc, 0x631, 0x627, 0x646, 0x62f, 0x631, 0x6cc,
0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x50, 0x6f, 0x6c, 0x73, 0x6b, 0x61, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xea,
0x73, 0x42, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x41, 0x6e, 0x67, 0x6f, 0x6c, 0x61, 0x43, 0x61, 0x62, 0x6f, 0x20, 0x56, 0x65,
0x72, 0x64, 0x65, 0x54, 0x69, 0x6d, 0x6f, 0x72, 0x2d, 0x4c, 0x65, 0x73, 0x74, 0x65, 0x47, 0x75, 0x69, 0x6e, 0xe9, 0x20,
0x45, 0x71, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x47, 0x75, 0x69, 0x6e, 0xe9, 0x2d, 0x42, 0x69, 0x73, 0x73,
0x61, 0x75, 0x4c, 0x75, 0x78, 0x65, 0x6d, 0x62, 0x75, 0x72, 0x67, 0x6f, 0x4d, 0x61, 0x63, 0x61, 0x75, 0x2c, 0x20, 0x52,
0x41, 0x45, 0x20, 0x64, 0x61, 0x20, 0x43, 0x68, 0x69, 0x6e, 0x61, 0x4d, 0x6f, 0xe7, 0x61, 0x6d, 0x62, 0x69, 0x71, 0x75,
0x65, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xea, 0x73, 0x20, 0x65, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x75, 0x50, 0x6f,
0x72, 0x74, 0x75, 0x67, 0x61, 0x6c, 0x53, 0xe3, 0x6f, 0x20, 0x54, 0x6f, 0x6d, 0xe9, 0x20, 0x65, 0x20, 0x50, 0x72, 0xed,
0x6e, 0x63, 0x69, 0x70, 0x65, 0x53, 0x75, 0xed, 0xe7, 0x61, 0xa2a, 0xa70, 0xa1c, 0xa3e, 0xa2c, 0xa40, 0xa2d, 0xa3e, 0xa30, 0xa24,
0x67e, 0x646, 0x62c, 0x627, 0x628, 0x6cc, 0x52, 0x75, 0x6e, 0x61, 0x73, 0x69, 0x6d, 0x69, 0x50, 0x65, 0x72, 0xfa, 0x42, 0x6f,
0x6c, 0x69, 0x76, 0x69, 0x61, 0x45, 0x63, 0x75, 0x61, 0x64, 0x6f, 0x72, 0x72, 0x75, 0x6d, 0x61, 0x6e, 0x74, 0x73, 0x63,
0x68, 0x53, 0x76, 0x69, 0x7a, 0x72, 0x61, 0x72, 0x6f, 0x6d, 0xe2, 0x6e, 0x103, 0x52, 0x6f, 0x6d, 0xe2, 0x6e, 0x69, 0x61,
0x52, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x20, 0x4d, 0x6f, 0x6c, 0x64, 0x6f, 0x76, 0x61, 0x440, 0x443, 0x441,
0x441, 0x43a, 0x438, 0x439, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x44f, 0x41a, 0x430, 0x437, 0x430, 0x445, 0x441, 0x442, 0x430, 0x43d, 0x41a,
0x438, 0x440, 0x433, 0x438, 0x437, 0x438, 0x44f, 0x41c, 0x43e, 0x43b, 0x434, 0x43e, 0x432, 0x430, 0x423, 0x43a, 0x440, 0x430, 0x438, 0x43d,
0x430, 0x53, 0xe4, 0x6e, 0x67, 0xf6, 0x4b, 0xf6, 0x64, 0xf6, 0x72, 0xf6, 0x73, 0xea, 0x73, 0x65, 0x20, 0x74, 0xee, 0x20,
0x42, 0xea, 0x61, 0x66, 0x72, 0xee, 0x6b, 0x61, 0x441, 0x440, 0x43f, 0x441, 0x43a, 0x438, 0x421, 0x440, 0x431, 0x438, 0x458, 0x430,
0x411, 0x43e, 0x441, 0x43d, 0x430, 0x20, 0x438, 0x20, 0x425, 0x435, 0x440, 0x446, 0x435, 0x433, 0x43e, 0x432, 0x438, 0x43d, 0x430, 0x426,
0x440, 0x43d, 0x430, 0x20, 0x413, 0x43e, 0x440, 0x430, 0x41a, 0x43e, 0x441, 0x43e, 0x432, 0x43e, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x69,
0x43, 0x72, 0x6e, 0x61, 0x20, 0x47, 0x6f, 0x72, 0x61, 0x53, 0x72, 0x62, 0x69, 0x6a, 0x61, 0x4b, 0x6f, 0x73, 0x6f, 0x76,
0x6f, 0x438, 0x440, 0x43e, 0x43d, 0x413, 0x443, 0x44b, 0x440, 0x434, 0x437, 0x44b, 0x441, 0x442, 0x43e, 0x43d, 0x423, 0x4d5, 0x440, 0x4d5,
0x441, 0x435, 0x63, 0x68, 0x69, 0x53, 0x68, 0x6f, 0x6e, 0x61, 0x633, 0x646, 0x68c, 0x64a, 0x67e, 0x627, 0x6aa, 0x633, 0x62a, 0x627,
0x646, 0xdc3, 0xdd2, 0xd82, 0xdc4, 0xdbd, 0xdc1, 0xdca, 0x200d, 0xdbb, 0xdd3, 0x20, 0xdbd, 0xd82, 0xd9a, 0xdcf, 0xdc0, 0x73, 0x6c, 0x6f,
0x76, 0x65, 0x6e, 0x10d, 0x69, 0x6e, 0x61, 0x53, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x6f, 0x73, 0x6c, 0x6f, 0x76,
0x65, 0x6e, 0x161, 0x10d, 0x69, 0x6e, 0x61, 0x53, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0x69, 0x6a, 0x61, 0x53, 0x6f, 0x6f, 0x6d,
0x61, 0x61, 0x6c, 0x69, 0x53, 0x6f, 0x6f, 0x6d, 0x61, 0x61, 0x6c, 0x69, 0x79, 0x61, 0x4a, 0x61, 0x62, 0x75, 0x75, 0x74,
0x69, 0x49, 0x74, 0x6f, 0x6f, 0x62, 0x69, 0x79, 0x61, 0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x20, 0x64, 0x65, 0x20,
0x45, 0x73, 0x70, 0x61, 0xf1, 0x61, 0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x41, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69,
0x6e, 0x61, 0x42, 0x65, 0x6c, 0x69, 0x63, 0x65, 0x43, 0x68, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69,
0x61, 0x43, 0x6f, 0x73, 0x74, 0x61, 0x20, 0x52, 0x69, 0x63, 0x61, 0x43, 0x75, 0x62, 0x61, 0x52, 0x65, 0x70, 0xfa, 0x62,
0x6c, 0x69, 0x63, 0x61, 0x20, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x61, 0x45, 0x6c, 0x20, 0x53, 0x61,
0x6c, 0x76, 0x61, 0x64, 0x6f, 0x72, 0x47, 0x75, 0x69, 0x6e, 0x65, 0x61, 0x20, 0x45, 0x63, 0x75, 0x61, 0x74, 0x6f, 0x72,
0x69, 0x61, 0x6c, 0x47, 0x75, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6c, 0x61, 0x48, 0x6f, 0x6e, 0x64, 0x75, 0x72, 0x61, 0x73,
0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c, 0x20, 0x64, 0x65, 0x20, 0x4d, 0xe9, 0x78, 0x69, 0x63, 0x6f, 0x4d, 0xe9, 0x78,
0x69, 0x63, 0x6f, 0x4e, 0x69, 0x63, 0x61, 0x72, 0x61, 0x67, 0x75, 0x61, 0x50, 0x61, 0x6e, 0x61, 0x6d, 0xe1, 0x50, 0x61,
0x72, 0x61, 0x67, 0x75, 0x61, 0x79, 0x46, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x61, 0x73, 0x45, 0x73, 0x74, 0x61, 0x64,
0x6f, 0x73, 0x20, 0x55, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x55, 0x72, 0x75, 0x67, 0x75, 0x61, 0x79, 0x56, 0x65, 0x6e, 0x65,
0x7a, 0x75, 0x65, 0x6c, 0x61, 0x43, 0x61, 0x6e, 0x61, 0x72, 0x69, 0x61, 0x73, 0x65, 0x73, 0x70, 0x61, 0xf1, 0x6f, 0x6c,
0x20, 0x6c, 0x61, 0x74, 0x69, 0x6e, 0x6f, 0x61, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x6f, 0x4c, 0x61, 0x74, 0x69,
0x6e, 0x6f, 0x61, 0x6d, 0xe9, 0x72, 0x69, 0x63, 0x61, 0x43, 0x65, 0x75, 0x74, 0x61, 0x20, 0x79, 0x20, 0x4d, 0x65, 0x6c,
0x69, 0x6c, 0x6c, 0x61, 0x4b, 0x69, 0x73, 0x77, 0x61, 0x68, 0x69, 0x6c, 0x69, 0x4a, 0x61, 0x6d, 0x68, 0x75, 0x72, 0x69,
0x20, 0x79, 0x61, 0x20, 0x4b, 0x69, 0x64, 0x65, 0x6d, 0x6f, 0x6b, 0x72, 0x61, 0x73, 0x69, 0x61, 0x20, 0x79, 0x61, 0x20,
0x4b, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b, 0x61, 0x53, 0x76, 0x65, 0x72, 0x69, 0x67, 0x65, 0xc5,
0x6c, 0x61, 0x6e, 0x64, 0x442, 0x43e, 0x4b7, 0x438, 0x43a, 0x4e3, 0x422, 0x43e, 0x4b7, 0x438, 0x43a, 0x438, 0x441, 0x442, 0x43e, 0x43d,
0xba4, 0xbae, 0xbbf, 0xbb4, 0xbcd, 0xb87, 0xba8, 0xbcd, 0xba4, 0xbbf, 0xbaf, 0xbbe, 0xbae, 0xbb2, 0xbc7, 0xb9a, 0xbbf, 0xbaf, 0xbbe, 0xb9a,
0xbbf, 0xb99, 0xbcd, 0xb95, 0xbaa, 0xbcd, 0xbaa, 0xbc2, 0xbb0, 0xbcd, 0xb87, 0xbb2, 0xb99, 0xbcd, 0xb95, 0xbc8, 0x442, 0x430, 0x442, 0x430,
0x440, 0xc24, 0xc46, 0xc32, 0xc41, 0xc17, 0xc41, 0xc2d, 0xc3e, 0xc30, 0xc24, 0xc26, 0xc47, 0xc36, 0xc02, 0xe44, 0xe17, 0xe22, 0xf56, 0xf7c,
0xf51, 0xf0b, 0xf66, 0xf90, 0xf51, 0xf0b, 0xf62, 0xf92, 0xfb1, 0xf0b, 0xf53, 0xf42, 0xf62, 0xf92, 0xfb1, 0xf0b, 0xf42, 0xf62, 0xf0b, 0x1275,
0x130d, 0x122d, 0x129b, 0x12a4, 0x122d, 0x1275, 0x122b, 0x6c, 0x65, 0x61, 0x20, 0x66, 0x61, 0x6b, 0x61, 0x74, 0x6f, 0x6e, 0x67, 0x61,
0x54, 0xfc, 0x72, 0x6b, 0xe7, 0x65, 0x54, 0xfc, 0x72, 0x6b, 0x69, 0x79, 0x65, 0x4b, 0x131, 0x62, 0x72, 0x131, 0x73, 0x74,
0xfc, 0x72, 0x6b, 0x6d, 0x65, 0x6e, 0x20, 0x64, 0x69, 0x6c, 0x69, 0x54, 0xfc, 0x72, 0x6b, 0x6d, 0x65, 0x6e, 0x69, 0x73,
0x74, 0x61, 0x6e, 0x626, 0x6c7, 0x64a, 0x63a, 0x6c7, 0x631, 0x686, 0x6d5, 0x62c, 0x6c7, 0x6ad, 0x6af, 0x648, 0x443, 0x43a, 0x440, 0x430,
0x457, 0x43d, 0x441, 0x44c, 0x43a, 0x430, 0x423, 0x43a, 0x440, 0x430, 0x457, 0x43d, 0x430, 0x627, 0x631, 0x62f, 0x648, 0x628, 0x6be, 0x627,
0x631, 0x62a, 0x6f, 0x2018, 0x7a, 0x62, 0x65, 0x6b, 0x4f, 0x2bb, 0x7a, 0x62, 0x65, 0x6b, 0x69, 0x73, 0x74, 0x6f, 0x6e, 0x627,
0x648, 0x632, 0x628, 0x6cc, 0x6a9, 0x45e, 0x437, 0x431, 0x435, 0x43a, 0x447, 0x430, 0x40e, 0x437, 0x431, 0x435, 0x43a, 0x438, 0x441, 0x442,
0x43e, 0x43d, 0x54, 0x69, 0x1ebf, 0x6e, 0x67, 0x20, 0x56, 0x69, 0x1ec7, 0x74, 0x56, 0x69, 0x1ec7, 0x74, 0x20, 0x4e, 0x61, 0x6d,
0x56, 0x6f, 0x6c, 0x61, 0x70, 0xfc, 0x6b, 0x43, 0x79, 0x6d, 0x72, 0x61, 0x65, 0x67, 0x59, 0x20, 0x44, 0x65, 0x79, 0x72,
0x6e, 0x61, 0x73, 0x20, 0x55, 0x6e, 0x65, 0x64, 0x69, 0x67, 0x57, 0x6f, 0x6c, 0x6f, 0x66, 0x53, 0x65, 0x6e, 0x65, 0x67,
0x61, 0x61, 0x6c, 0x69, 0x73, 0x69, 0x58, 0x68, 0x6f, 0x73, 0x61, 0x65, 0x4d, 0x7a, 0x61, 0x6e, 0x74, 0x73, 0x69, 0x20,
0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x5d9, 0x5d9, 0x5b4, 0x5d3, 0x5d9, 0x5e9, 0x5d5, 0x5d5, 0x5e2, 0x5dc, 0x5d8, 0xc8, 0x64, 0xe8,
0x20, 0x59, 0x6f, 0x72, 0xf9, 0x62, 0xe1, 0x4f, 0x72, 0x69, 0x6c, 0x1eb9, 0x300, 0x2d, 0xe8, 0x64, 0xe8, 0x20, 0x4e, 0xe0,
0xec, 0x6a, 0xed, 0x72, 0xed, 0xe0, 0x4f, 0x72, 0xed, 0x6c, 0x25b, 0x301, 0xe8, 0x64, 0x65, 0x20, 0x42, 0x25b, 0x300, 0x6e,
0x25b, 0x300, 0x69, 0x73, 0x69, 0x5a, 0x75, 0x6c, 0x75, 0x69, 0x4e, 0x69, 0x6e, 0x67, 0x69, 0x7a, 0x69, 0x6d, 0x75, 0x20,
0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x6e, 0x79, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x4e, 0x6f, 0x72, 0x65, 0x67, 0x62, 0x6f,
0x73, 0x61, 0x6e, 0x73, 0x6b, 0x69, 0x431, 0x43e, 0x441, 0x430, 0x43d, 0x441, 0x43a, 0x438, 0x47, 0x61, 0x65, 0x6c, 0x67, 0x45,
0x6c, 0x6c, 0x61, 0x6e, 0x20, 0x56, 0x61, 0x6e, 0x6e, 0x69, 0x6e, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x77, 0x65, 0x6b, 0x52,
0x79, 0x77, 0x76, 0x61, 0x6e, 0x65, 0x74, 0x68, 0x20, 0x55, 0x6e, 0x79, 0x73, 0x41, 0x6b, 0x61, 0x6e, 0x47, 0x61, 0x61,
0x6e, 0x61, 0x915, 0x94b, 0x902, 0x915, 0x923, 0x940, 0x41, 0x73, 0x1ee5, 0x73, 0x1ee5, 0x20, 0x49, 0x67, 0x62, 0x6f, 0x4e, 0x61,
0x1ecb, 0x6a, 0x1ecb, 0x72, 0x1ecb, 0x61, 0x4b, 0x69, 0x6b, 0x61, 0x6d, 0x62, 0x61, 0x66, 0x75, 0x72, 0x6c, 0x61, 0x6e, 0x49,
0x74, 0x61, 0x6c, 0x69, 0x65, 0x45, 0x28b, 0x65, 0x67, 0x62, 0x65, 0x47, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x6e, 0x75, 0x74,
0x6f, 0x6d, 0x65, 0x54, 0x6f, 0x67, 0x6f, 0x20, 0x6e, 0x75, 0x74, 0x6f, 0x6d, 0x65, 0x2bb, 0x14c, 0x6c, 0x65, 0x6c, 0x6f,
0x20, 0x48, 0x61, 0x77, 0x61, 0x69, 0x2bb, 0x69, 0x2bb, 0x41, 0x6d, 0x65, 0x6c, 0x69, 0x6b, 0x61, 0x20, 0x48, 0x75, 0x69,
0x20, 0x50, 0x16b, 0x20, 0x2bb, 0x49, 0x61, 0x46, 0x69, 0x6c, 0x69, 0x70, 0x69, 0x6e, 0x6f, 0x50, 0x69, 0x6c, 0x69, 0x70,
0x69, 0x6e, 0x61, 0x73, 0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a, 0x65, 0x72, 0x74, 0xfc, 0xfc, 0x74, 0x73, 0x63, 0x68,
0x53, 0x63, 0x68, 0x77, 0x69, 0x69, 0x7a, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x72, 0x69, 0x69, 0x63, 0x68, 0x4c, 0x69, 0xe4,
0x63, 0x68, 0x74, 0x65, 0x73, 0x63, 0x68, 0x74, 0xe4, 0x69, 0xa188, 0xa320, 0xa259, 0xa34f, 0xa1e9, 0x4e, 0x65, 0x64, 0x64, 0x65,
0x72, 0x73, 0x61, 0x73, 0x73, 0x2019, 0x73, 0x63, 0x68, 0x44, 0xfc, 0xfc, 0x74, 0x73, 0x63, 0x68, 0x6c, 0x61, 0x6e, 0x64,
0x4e, 0x65, 0x64, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x6e, 0x64, 0x61, 0x76, 0x76, 0x69, 0x73, 0xe1, 0x6d,
0x65, 0x67, 0x69, 0x65, 0x6c, 0x6c, 0x61, 0x4e, 0x6f, 0x72, 0x67, 0x61, 0x53, 0x75, 0x6f, 0x70, 0x6d, 0x61, 0x52, 0x75,
0x6f, 0x167, 0x167, 0x61, 0x45, 0x6b, 0x65, 0x67, 0x75, 0x73, 0x69, 0x69, 0x4b, 0x69, 0x74, 0x61, 0x69, 0x74, 0x61, 0x50,
0x75, 0x6c, 0x61, 0x61, 0x72, 0x42, 0x75, 0x72, 0x6b, 0x69, 0x62, 0x61, 0x61, 0x20, 0x46, 0x61, 0x61, 0x73, 0x6f, 0x4b,
0x61, 0x6d, 0x65, 0x72, 0x75, 0x75, 0x6e, 0x47, 0x61, 0x6d, 0x6d, 0x62, 0x69, 0x47, 0x61, 0x6e, 0x61, 0x61, 0x47, 0x69,
0x6e, 0x65, 0x47, 0x69, 0x6e, 0x65, 0x2d, 0x42, 0x69, 0x73, 0x61, 0x61, 0x77, 0x6f, 0x4c, 0x69, 0x62, 0x65, 0x72, 0x69,
0x79, 0x61, 0x61, 0x4d, 0x75, 0x72, 0x69, 0x74, 0x61, 0x6e, 0x69, 0x4e, 0x69, 0x6a, 0x65, 0x65, 0x72, 0x4e, 0x69, 0x6a,
0x65, 0x72, 0x69, 0x79, 0x61, 0x61, 0x53, 0x65, 0x72, 0x61, 0x61, 0x20, 0x6c, 0x69, 0x79, 0x6f, 0x6e, 0x47, 0x69, 0x6b,
0x75, 0x79, 0x75, 0x4b, 0x69, 0x73, 0x61, 0x6d, 0x70, 0x75, 0x72, 0x73, 0x65, 0x6e, 0x61, 0x69, 0x73, 0x69, 0x4e, 0x64,
0x65, 0x62, 0x65, 0x6c, 0x65, 0x4b, 0x69, 0x68, 0x6f, 0x72, 0x6f, 0x6d, 0x62, 0x6f, 0x2d5c, 0x2d30, 0x2d5b, 0x2d4d, 0x2d43, 0x2d49,
0x2d5c, 0x2d4d, 0x2d4e, 0x2d56, 0x2d54, 0x2d49, 0x2d31, 0x54, 0x61, 0x73, 0x68, 0x65, 0x6c, 0x1e25, 0x69, 0x79, 0x74, 0x6c, 0x6d, 0x263,
0x72, 0x69, 0x62, 0x54, 0x61, 0x71, 0x62, 0x61, 0x79, 0x6c, 0x69, 0x74, 0x4c, 0x65, 0x7a, 0x7a, 0x61, 0x79, 0x65, 0x72,
0x52, 0x75, 0x6e, 0x79, 0x61, 0x6e, 0x6b, 0x6f, 0x72, 0x65, 0x48, 0x69, 0x62, 0x65, 0x6e, 0x61, 0x48, 0x75, 0x74, 0x61,
0x6e, 0x7a, 0x61, 0x6e, 0x69, 0x61, 0x4b, 0x79, 0x69, 0x76, 0x75, 0x6e, 0x6a, 0x6f, 0x62, 0x61, 0x6d, 0x61, 0x6e, 0x61,
0x6b, 0x61, 0x6e, 0x4b, 0x129, 0x65, 0x6d, 0x62, 0x75, 0x13e3, 0x13b3, 0x13a9, 0x13cc, 0x13ca, 0x20, 0x13a2, 0x13f3, 0x13be, 0x13b5, 0x13cd,
0x13d4, 0x13c5, 0x20, 0x13cd, 0x13a6, 0x13da, 0x13a9, 0x6b, 0x72, 0x65, 0x6f, 0x6c, 0x20, 0x6d, 0x6f, 0x72, 0x69, 0x73, 0x69, 0x65,
0x6e, 0x4d, 0x6f, 0x72, 0x69, 0x73, 0x43, 0x68, 0x69, 0x6d, 0x61, 0x6b, 0x6f, 0x6e, 0x64, 0x65, 0x4b, 0x268, 0x6c, 0x61,
0x61, 0x6e, 0x67, 0x69, 0x54, 0x61, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0xed, 0x61, 0x4c, 0x75, 0x67, 0x61, 0x6e, 0x64, 0x61,
0x59, 0x75, 0x67, 0x61, 0x6e, 0x64, 0x61, 0x49, 0x63, 0x68, 0x69, 0x62, 0x65, 0x6d, 0x62, 0x61, 0x6b, 0x61, 0x62, 0x75,
0x76, 0x65, 0x72, 0x64, 0x69, 0x61, 0x6e, 0x75, 0x4b, 0x61, 0x62, 0x75, 0x20, 0x56, 0x65, 0x72, 0x64, 0x69, 0x4b, 0x129,
0x6d, 0x129, 0x72, 0x169, 0x4b, 0x61, 0x6c, 0x65, 0x6e, 0x6a, 0x69, 0x6e, 0x45, 0x6d, 0x65, 0x74, 0x61, 0x62, 0x20, 0x4b,
0x65, 0x6e, 0x79, 0x61, 0x4b, 0x68, 0x6f, 0x65, 0x6b, 0x68, 0x6f, 0x65, 0x67, 0x6f, 0x77, 0x61, 0x62, 0x4e, 0x61, 0x6d,
0x69, 0x62, 0x69, 0x61, 0x62, 0x4b, 0x69, 0x6d, 0x61, 0x63, 0x68, 0x61, 0x6d, 0x65, 0x4b, 0xf6, 0x6c, 0x73, 0x63, 0x68,
0x44, 0x6f, 0xfc, 0x74, 0x73, 0x63, 0x68, 0x6c, 0x61, 0x6e, 0x64, 0x4d, 0x61, 0x61, 0x54, 0x61, 0x6e, 0x73, 0x61, 0x6e,
0x69, 0x61, 0x4f, 0x6c, 0x75, 0x73, 0x6f, 0x67, 0x61, 0x4c, 0x75, 0x6c, 0x75, 0x68, 0x69, 0x61, 0x4b, 0x69, 0x70, 0x61,
0x72, 0x65, 0x54, 0x61, 0x64, 0x68, 0x61, 0x6e, 0x69, 0x61, 0x4b, 0x69, 0x74, 0x65, 0x73, 0x6f, 0x4b, 0x65, 0x6e, 0x69,
0x61, 0x4b, 0x6f, 0x79, 0x72, 0x61, 0x20, 0x63, 0x69, 0x69, 0x6e, 0x69, 0x4d, 0x61, 0x61, 0x6c, 0x69, 0x4b, 0x69, 0x72,
0x75, 0x77, 0x61, 0x44, 0x68, 0x6f, 0x6c, 0x75, 0x6f, 0x52, 0x75, 0x6b, 0x69, 0x67, 0x61, 0x54, 0x61, 0x6d, 0x61, 0x7a,
0x69, 0x263, 0x74, 0x20, 0x6e, 0x20, 0x6c, 0x61, 0x1e6d, 0x6c, 0x61, 0x1e63, 0x4d, 0x65, 0x1e5b, 0x1e5b, 0x75, 0x6b, 0x4b, 0x6f,
0x79, 0x72, 0x61, 0x62, 0x6f, 0x72, 0x6f, 0x20, 0x73, 0x65, 0x6e, 0x6e, 0x69, 0x4b, 0x69, 0x73, 0x68, 0x61, 0x6d, 0x62,
0x61, 0x61, 0x92c, 0x921, 0x93c, 0x94b, 0x43d, 0x43e, 0x445, 0x447, 0x438, 0x439, 0x43d, 0x420, 0x43e, 0x441, 0x441, 0x438, 0x446, 0x435,
0x440, 0x43a, 0x43e, 0x432, 0x43d, 0x43e, 0x441, 0x43b, 0x43e, 0x432, 0x435, 0x301, 0x43d, 0x441, 0x43a, 0x457, 0x439, 0x440, 0x461, 0x441,
0x441, 0x456, 0x301, 0x430, 0x54, 0x73, 0x68, 0x69, 0x6c, 0x75, 0x62, 0x61, 0x44, 0x69, 0x74, 0x75, 0x6e, 0x67, 0x61, 0x20,
0x77, 0x61, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x75, 0x4c, 0xeb, 0x74, 0x7a, 0x65, 0x62, 0x75, 0x65, 0x72, 0x67, 0x65, 0x73,
0x63, 0x68, 0x4c, 0xeb, 0x74, 0x7a, 0x65, 0x62, 0x75, 0x65, 0x72, 0x67, 0x41, 0x67, 0x68, 0x65, 0x6d, 0x4b, 0xe0, 0x6d,
0xe0, 0x6c, 0xfb, 0x14b, 0x181, 0xe0, 0x73, 0xe0, 0x61, 0x4b, 0xe0, 0x6d, 0x25b, 0x300, 0x72, 0xfb, 0x6e, 0x5a, 0x61, 0x72,
0x6d, 0x61, 0x63, 0x69, 0x69, 0x6e, 0x65, 0x4e, 0x69, 0x17e, 0x65, 0x72, 0x64, 0x75, 0xe1, 0x6c, 0xe1, 0x6a, 0x6f, 0x6f,
0x6c, 0x61, 0x53, 0x65, 0x6e, 0x65, 0x67, 0x61, 0x6c, 0x65, 0x77, 0x6f, 0x6e, 0x64, 0x6f, 0x4b, 0x61, 0x6d, 0x259, 0x72,
0xfa, 0x6e, 0x72, 0x69, 0x6b, 0x70, 0x61, 0x6b, 0x61, 0x6d, 0x25b, 0x72, 0xfa, 0x6e, 0x4d, 0x61, 0x6b, 0x75, 0x61, 0x55,
0x6d, 0x6f, 0x7a, 0x61, 0x6d, 0x62, 0x69, 0x6b, 0x69, 0x4d, 0x55, 0x4e, 0x44, 0x41, 0x14a, 0x6b, 0x61, 0x6d, 0x65, 0x72,
0x75, 0x14b, 0x4b, 0x77, 0x61, 0x73, 0x69, 0x6f, 0x4b, 0x61, 0x6d, 0x65, 0x72, 0x75, 0x6e, 0x54, 0x68, 0x6f, 0x6b, 0x20,
0x4e, 0x61, 0x74, 0x68, 0x441, 0x430, 0x445, 0x430, 0x20, 0x442, 0x44b, 0x43b, 0x430, 0x410, 0x440, 0x430, 0x441, 0x441, 0x44b, 0x44b,
0x439, 0x430, 0x49, 0x73, 0x68, 0x69, 0x73, 0x61, 0x6e, 0x67, 0x75, 0x54, 0x61, 0x6e, 0x73, 0x61, 0x6e, 0x69, 0x79, 0x61,
0x54, 0x61, 0x73, 0x61, 0x77, 0x61, 0x71, 0x20, 0x73, 0x65, 0x6e, 0x6e, 0x69, 0xa559, 0xa524, 0xa55e, 0xa524, 0xa52b, 0xa569, 0x56,
0x61, 0x69, 0x4c, 0x61, 0x69, 0x62, 0x68, 0x69, 0x79, 0x61, 0x57, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x53, 0x63, 0x68, 0x77,
0x69, 0x7a, 0x6e, 0x75, 0x61, 0x73, 0x75, 0x65, 0x4b, 0x65, 0x6d, 0x65, 0x6c, 0xfa, 0x6e, 0x61, 0x73, 0x74, 0x75, 0x72,
0x69, 0x61, 0x6e, 0x75, 0x4e, 0x64, 0x61, 0xa78c, 0x61, 0x4b, 0x61, 0x6d, 0x25b, 0x6c, 0xfb, 0x6e, 0x6b, 0x61, 0x6b, 0x254,
0x4b, 0x61, 0x6d, 0x25b, 0x72, 0x75, 0x6e, 0x6d, 0x65, 0x74, 0x61, 0x2bc, 0x4b, 0x61, 0x6d, 0x61, 0x6c, 0x75, 0x6e, 0x53,
0x68, 0x77, 0xf3, 0x14b, 0xf2, 0x20, 0x6e, 0x67, 0x69, 0x65, 0x6d, 0x62, 0x254, 0x254, 0x6e, 0x4b, 0xe0, 0x6d, 0x61, 0x6c,
0xfb, 0x6d, 0x4c, 0x61, 0x6b, 0x21f, 0xf3, 0x6c, 0x2bc, 0x69, 0x79, 0x61, 0x70, 0x69, 0x4d, 0xed, 0x6c, 0x61, 0x68, 0x61,
0x14b, 0x73, 0x6b, 0x61, 0x20, 0x54, 0x21f, 0x61, 0x6d, 0xe1, 0x6b, 0x21f, 0x6f, 0x10d, 0x68, 0x65, 0x2d5c, 0x2d30, 0x2d4e, 0x2d30,
0x2d63, 0x2d49, 0x2d56, 0x2d5c, 0x6a9, 0x648, 0x631, 0x62f, 0x6cc, 0x6cc, 0x20, 0x646, 0x627, 0x648, 0x6d5, 0x646, 0x62f, 0x6cc, 0x639, 0x6ce,
0x631, 0x627, 0x642, 0x626, 0x6ce, 0x631, 0x627, 0x646, 0x64, 0x6f, 0x6c, 0x6e, 0x6f, 0x73, 0x65, 0x72, 0x62, 0x161, 0x107, 0x69,
0x6e, 0x61, 0x4e, 0x69, 0x6d, 0x73, 0x6b, 0x61, 0x68, 0x6f, 0x72, 0x6e, 0x6a, 0x6f, 0x73, 0x65, 0x72, 0x62, 0x161, 0x107,
0x69, 0x6e, 0x61, 0x4e, 0x11b, 0x6d, 0x73, 0x6b, 0x61, 0x70, 0x72, 0x16b, 0x73, 0x69, 0x73, 0x6b, 0x61, 0x6e, 0x73, 0x77,
0x12b, 0x74, 0x61, 0x69, 0x61, 0x6e, 0x61, 0x72, 0xe2, 0x161, 0x6b, 0x69, 0x65, 0x6c, 0xe2, 0x53, 0x75, 0x6f, 0x6d, 0xe2,
0x645, 0x627, 0x632, 0x631, 0x648, 0x646, 0x6cc, 0x644, 0x6ca, 0x631, 0x6cc, 0x20, 0x634, 0x648, 0x645, 0x627, 0x644, 0x6cc, 0x7cb5, 0x8a9e,
0x4e2d, 0x83ef, 0x4eba, 0x6c11, 0x5171, 0x548c, 0x570b, 0x9999, 0x6e2f, 0x7279, 0x5225, 0x884c, 0x653f, 0x5340, 0x7ca4, 0x8bed, 0x4e2d, 0x534e, 0x4eba, 0x6c11,
0x5171, 0x548c, 0x56fd, 0x42, 0x69, 0x6e, 0x69, 0x73, 0x61, 0x79, 0x61
};

static const char language_name_list[] =
"Default\0"
"C\0"
"Abkhazian\0"
"Oromo\0"
"Afar\0"
"Afrikaans\0"
"Albanian\0"
"Amharic\0"
"Arabic\0"
"Armenian\0"
"Assamese\0"
"Aymara\0"
"Azerbaijani\0"
"Bashkir\0"
"Basque\0"
"Bengali\0"
"Dzongkha\0"
"Bihari\0"
"Bislama\0"
"Breton\0"
"Bulgarian\0"
"Burmese\0"
"Belarusian\0"
"Khmer\0"
"Catalan\0"
"Chinese\0"
"Corsican\0"
"Croatian\0"
"Czech\0"
"Danish\0"
"Dutch\0"
"English\0"
"Esperanto\0"
"Estonian\0"
"Faroese\0"
"Fijian\0"
"Finnish\0"
"French\0"
"Western Frisian\0"
"Gaelic\0"
"Galician\0"
"Georgian\0"
"German\0"
"Greek\0"
"Greenlandic\0"
"Guarani\0"
"Gujarati\0"
"Hausa\0"
"Hebrew\0"
"Hindi\0"
"Hungarian\0"
"Icelandic\0"
"Indonesian\0"
"Interlingua\0"
"Interlingue\0"
"Inuktitut\0"
"Inupiak\0"
"Irish\0"
"Italian\0"
"Japanese\0"
"Javanese\0"
"Kannada\0"
"Kashmiri\0"
"Kazakh\0"
"Kinyarwanda\0"
"Kirghiz\0"
"Korean\0"
"Kurdish\0"
"Rundi\0"
"Lao\0"
"Latin\0"
"Latvian\0"
"Lingala\0"
"Lithuanian\0"
"Macedonian\0"
"Malagasy\0"
"Malay\0"
"Malayalam\0"
"Maltese\0"
"Maori\0"
"Marathi\0"
"Marshallese\0"
"Mongolian\0"
"Nauru\0"
"Nepali\0"
"Norwegian Bokmal\0"
"Occitan\0"
"Oriya\0"
"Pashto\0"
"Persian\0"
"Polish\0"
"Portuguese\0"
"Punjabi\0"
"Quechua\0"
"Romansh\0"
"Romanian\0"
"Russian\0"
"Samoan\0"
"Sango\0"
"Sanskrit\0"
"Serbian\0"
"Ossetic\0"
"Southern Sotho\0"
"Tswana\0"
"Shona\0"
"Sindhi\0"
"Sinhala\0"
"Swati\0"
"Slovak\0"
"Slovenian\0"
"Somali\0"
"Spanish\0"
"Sundanese\0"
"Swahili\0"
"Swedish\0"
"Sardinian\0"
"Tajik\0"
"Tamil\0"
"Tatar\0"
"Telugu\0"
"Thai\0"
"Tibetan\0"
"Tigrinya\0"
"Tongan\0"
"Tsonga\0"
"Turkish\0"
"Turkmen\0"
"Tahitian\0"
"Uighur\0"
"Ukrainian\0"
"Urdu\0"
"Uzbek\0"
"Vietnamese\0"
"Volapuk\0"
"Welsh\0"
"Wolof\0"
"Xhosa\0"
"Yiddish\0"
"Yoruba\0"
"Zhuang\0"
"Zulu\0"
"Norwegian Nynorsk\0"
"Bosnian\0"
"Divehi\0"
"Manx\0"
"Cornish\0"
"Akan\0"
"Konkani\0"
"Ga\0"
"Igbo\0"
"Kamba\0"
"Syriac\0"
"Blin\0"
"Geez\0"
"Koro\0"
"Sidamo\0"
"Atsam\0"
"Tigre\0"
"Jju\0"
"Friulian\0"
"Venda\0"
"Ewe\0"
"Walamo\0"
"Hawaiian\0"
"Tyap\0"
"Nyanja\0"
"Filipino\0"
"Swiss German\0"
"Sichuan Yi\0"
"Kpelle\0"
"Low German\0"
"South Ndebele\0"
"Northern Sotho\0"
"Northern Sami\0"
"Taroko\0"
"Gusii\0"
"Taita\0"
"Fulah\0"
"Kikuyu\0"
"Samburu\0"
"Sena\0"
"North Ndebele\0"
"Rombo\0"
"Tachelhit\0"
"Kabyle\0"
"Nyankole\0"
"Bena\0"
"Vunjo\0"
"Bambara\0"
"Embu\0"
"Cherokee\0"
"Morisyen\0"
"Makonde\0"
"Langi\0"
"Ganda\0"
"Bemba\0"
"Kabuverdianu\0"
"Meru\0"
"Kalenjin\0"
"Nama\0"
"Machame\0"
"Colognian\0"
"Masai\0"
"Soga\0"
"Luyia\0"
"Asu\0"
"Teso\0"
"Saho\0"
"Koyra Chiini\0"
"Rwa\0"
"Luo\0"
"Chiga\0"
"Central Morocco Tamazight\0"
"Koyraboro Senni\0"
"Shambala\0"
"Bodo\0"
"Avaric\0"
"Chamorro\0"
"Chechen\0"
"Church\0"
"Chuvash\0"
"Cree\0"
"Haitian\0"
"Herero\0"
"Hiri Motu\0"
"Kanuri\0"
"Komi\0"
"Kongo\0"
"Kwanyama\0"
"Limburgish\0"
"Luba Katanga\0"
"Luxembourgish\0"
"Navaho\0"
"Ndonga\0"
"Ojibwa\0"
"Pali\0"
"Walloon\0"
"Aghem\0"
"Basaa\0"
"Zarma\0"
"Duala\0"
"Jola Fonyi\0"
"Ewondo\0"
"Bafia\0"
"Makhuwa Meetto\0"
"Mundang\0"
"Kwasio\0"
"Nuer\0"
"Sakha\0"
"Sangu\0"
"Congo Swahili\0"
"Tasawaq\0"
"Vai\0"
"Walser\0"
"Yangben\0"
"Avestan\0"
"Asturian\0"
"Ngomba\0"
"Kako\0"
"Meta\0"
"Ngiemboon\0"
"Aragonese\0"
"Akkadian\0"
"Ancient Egyptian\0"
"Ancient Greek\0"
"Aramaic\0"
"Balinese\0"
"Bamun\0"
"Batak Toba\0"
"Buginese\0"
"Buhid\0"
"Carian\0"
"Chakma\0"
"Classical Mandaic\0"
"Coptic\0"
"Dogri\0"
"Eastern Cham\0"
"Eastern Kayah\0"
"Etruscan\0"
"Gothic\0"
"Hanunoo\0"
"Ingush\0"
"Large Flowery Miao\0"
"Lepcha\0"
"Limbu\0"
"Lisu\0"
"Lu\0"
"Lycian\0"
"Lydian\0"
"Mandingo\0"
"Manipuri\0"
"Meroitic\0"
"Northern Thai\0"
"Old Irish\0"
"Old Norse\0"
"Old Persian\0"
"Old Turkish\0"
"Pahlavi\0"
"Parthian\0"
"Phoenician\0"
"Prakrit Language\0"
"Rejang\0"
"Sabaean\0"
"Samaritan\0"
"Santali\0"
"Saurashtra\0"
"Sora\0"
"Sylheti\0"
"Tagbanwa\0"
"Tai Dam\0"
"Tai Nua\0"
"Ugaritic\0"
"Akoose\0"
"Lakota\0"
"Standard Moroccan Tamazight\0"
"Mapuche\0"
"Central Kurdish\0"
"Lower Sorbian\0"
"Upper Sorbian\0"
"Kenyang\0"
"Mohawk\0"
"Nko\0"
"Prussian\0"
"Kiche\0"
"Southern Sami\0"
"Lule Sami\0"
"Inari Sami\0"
"Skolt Sami\0"
"Warlpiri\0"
"Manichaean Middle Persian\0"
"Mende\0"
"Ancient North Arabian\0"
"Linear A\0"
"Hmong Njua\0"
"Ho\0"
"Lezghian\0"
"Bassa\0"
"Mono\0"
"Tedim Chin\0"
"Maithili\0"
"Ahom\0"
"American Sign Language\0"
"Ardhamagadhi Prakrit\0"
"Bhojpuri\0"
"Hieroglyphic Luwian\0"
"Literary Chinese\0"
"Mazanderani\0"
"Mru\0"
"Newari\0"
"Northern Luri\0"
"Palauan\0"
"Papiamento\0"
"Saraiki\0"
"Tokelau\0"
"Tok Pisin\0"
"Tuvalu\0"
"Uncoded Languages\0"
"Cantonese\0"
"Osage\0"
"Tangut\0"
"Ido\0"
"Lojban\0"
"Sicilian\0"
"Southern Kurdish\0"
"Western Balochi\0"
"Cebuano\0"
"Erzya\0"
"Chickasaw\0"
"Muscogee\0"
"Silesian\0"
;

static const quint16 language_name_index[] = {
     0, // AnyLanguage
     8, // C
    10, // Abkhazian
    20, // Oromo
    26, // Afar
    31, // Afrikaans
    41, // Albanian
    50, // Amharic
    58, // Arabic
    65, // Armenian
    74, // Assamese
    83, // Aymara
    90, // Azerbaijani
   102, // Bashkir
   110, // Basque
   117, // Bengali
   125, // Dzongkha
   134, // Bihari
   141, // Bislama
   149, // Breton
   156, // Bulgarian
   166, // Burmese
   174, // Belarusian
   185, // Khmer
   191, // Catalan
   199, // Chinese
   207, // Corsican
   216, // Croatian
   225, // Czech
   231, // Danish
   238, // Dutch
   244, // English
   252, // Esperanto
   262, // Estonian
   271, // Faroese
   279, // Fijian
   286, // Finnish
   294, // French
   301, // Western Frisian
   317, // Gaelic
   324, // Galician
   333, // Georgian
   342, // German
   349, // Greek
   355, // Greenlandic
   367, // Guarani
   375, // Gujarati
   384, // Hausa
   390, // Hebrew
   397, // Hindi
   403, // Hungarian
   413, // Icelandic
   423, // Indonesian
   434, // Interlingua
   446, // Interlingue
   458, // Inuktitut
   468, // Inupiak
   476, // Irish
   482, // Italian
   490, // Japanese
   499, // Javanese
   508, // Kannada
   516, // Kashmiri
   525, // Kazakh
   532, // Kinyarwanda
   544, // Kirghiz
   552, // Korean
   559, // Kurdish
   567, // Rundi
   573, // Lao
   577, // Latin
   583, // Latvian
   591, // Lingala
   599, // Lithuanian
   610, // Macedonian
   621, // Malagasy
   630, // Malay
   636, // Malayalam
   646, // Maltese
   654, // Maori
   660, // Marathi
   668, // Marshallese
   680, // Mongolian
   690, // Nauru
   696, // Nepali
   703, // Norwegian Bokmal
   720, // Occitan
   728, // Oriya
   734, // Pashto
   741, // Persian
   749, // Polish
   756, // Portuguese
   767, // Punjabi
   775, // Quechua
   783, // Romansh
   791, // Romanian
   800, // Russian
   808, // Samoan
   815, // Sango
   821, // Sanskrit
   830, // Serbian
   838, // Ossetic
   846, // Southern Sotho
   861, // Tswana
   868, // Shona
   874, // Sindhi
   881, // Sinhala
   889, // Swati
   895, // Slovak
   902, // Slovenian
   912, // Somali
   919, // Spanish
   927, // Sundanese
   937, // Swahili
   945, // Swedish
   953, // Sardinian
   963, // Tajik
   969, // Tamil
   975, // Tatar
   981, // Telugu
   988, // Thai
   993, // Tibetan
  1001, // Tigrinya
  1010, // Tongan
  1017, // Tsonga
  1024, // Turkish
  1032, // Turkmen
  1040, // Tahitian
  1049, // Uighur
  1056, // Ukrainian
  1066, // Urdu
  1071, // Uzbek
  1077, // Vietnamese
  1088, // Volapuk
  1096, // Welsh
  1102, // Wolof
  1108, // Xhosa
  1114, // Yiddish
  1122, // Yoruba
  1129, // Zhuang
  1136, // Zulu
  1141, // Norwegian Nynorsk
  1159, // Bosnian
  1167, // Divehi
  1174, // Manx
  1179, // Cornish
  1187, // Akan
  1192, // Konkani
  1200, // Ga
  1203, // Igbo
  1208, // Kamba
  1214, // Syriac
  1221, // Blin
  1226, // Geez
  1231, // Koro
  1236, // Sidamo
  1243, // Atsam
  1249, // Tigre
  1255, // Jju
  1259, // Friulian
  1268, // Venda
  1274, // Ewe
  1278, // Walamo
  1285, // Hawaiian
  1294, // Tyap
  1299, // Nyanja
  1306, // Filipino
  1315, // Swiss German
  1328, // Sichuan Yi
  1339, // Kpelle
  1346, // Low German
  1357, // South Ndebele
  1371, // Northern Sotho
  1386, // Northern Sami
  1400, // Taroko
  1407, // Gusii
  1413, // Taita
  1419, // Fulah
  1425, // Kikuyu
  1432, // Samburu
  1440, // Sena
  1445, // North Ndebele
  1459, // Rombo
  1465, // Tachelhit
  1475, // Kabyle
  1482, // Nyankole
  1491, // Bena
  1496, // Vunjo
  1502, // Bambara
  1510, // Embu
  1515, // Cherokee
  1524, // Morisyen
  1533, // Makonde
  1541, // Langi
  1547, // Ganda
  1553, // Bemba
  1559, // Kabuverdianu
  1572, // Meru
  1577, // Kalenjin
  1586, // Nama
  1591, // Machame
  1599, // Colognian
  1609, // Masai
  1615, // Soga
  1620, // Luyia
  1626, // Asu
  1630, // Teso
  1635, // Saho
  1640, // Koyra Chiini
  1653, // Rwa
  1657, // Luo
  1661, // Chiga
  1667, // Central Morocco Tamazight
  1693, // Koyraboro Senni
  1709, // Shambala
  1718, // Bodo
  1723, // Avaric
  1730, // Chamorro
  1739, // Chechen
  1747, // Church
  1754, // Chuvash
  1762, // Cree
  1767, // Haitian
  1775, // Herero
  1782, // Hiri Motu
  1792, // Kanuri
  1799, // Komi
  1804, // Kongo
  1810, // Kwanyama
  1819, // Limburgish
  1830, // Luba Katanga
  1843, // Luxembourgish
  1857, // Navaho
  1864, // Ndonga
  1871, // Ojibwa
  1878, // Pali
  1883, // Walloon
  1891, // Aghem
  1897, // Basaa
  1903, // Zarma
  1909, // Duala
  1915, // Jola Fonyi
  1926, // Ewondo
  1933, // Bafia
  1939, // Makhuwa Meetto
  1954, // Mundang
  1962, // Kwasio
  1969, // Nuer
  1974, // Sakha
  1980, // Sangu
  1986, // Congo Swahili
  2000, // Tasawaq
  2008, // Vai
  2012, // Walser
  2019, // Yangben
  2027, // Avestan
  2035, // Asturian
  2044, // Ngomba
  2051, // Kako
  2056, // Meta
  2061, // Ngiemboon
  2071, // Aragonese
  2081, // Akkadian
  2090, // Ancient Egyptian
  2107, // Ancient Greek
  2121, // Aramaic
  2129, // Balinese
  2138, // Bamun
  2144, // Batak Toba
  2155, // Buginese
  2164, // Buhid
  2170, // Carian
  2177, // Chakma
  2184, // Classical Mandaic
  2202, // Coptic
  2209, // Dogri
  2215, // Eastern Cham
  2228, // Eastern Kayah
  2242, // Etruscan
  2251, // Gothic
  2258, // Hanunoo
  2266, // Ingush
  2273, // Large Flowery Miao
  2292, // Lepcha
  2299, // Limbu
  2305, // Lisu
  2310, // Lu
  2313, // Lycian
  2320, // Lydian
  2327, // Mandingo
  2336, // Manipuri
  2345, // Meroitic
  2354, // Northern Thai
  2368, // Old Irish
  2378, // Old Norse
  2388, // Old Persian
  2400, // Old Turkish
  2412, // Pahlavi
  2420, // Parthian
  2429, // Phoenician
  2440, // Prakrit Language
  2457, // Rejang
  2464, // Sabaean
  2472, // Samaritan
  2482, // Santali
  2490, // Saurashtra
  2501, // Sora
  2506, // Sylheti
  2514, // Tagbanwa
  2523, // Tai Dam
  2531, // Tai Nua
  2539, // Ugaritic
  2548, // Akoose
  2555, // Lakota
  2562, // Standard Moroccan Tamazight
  2590, // Mapuche
  2598, // Central Kurdish
  2614, // Lower Sorbian
  2628, // Upper Sorbian
  2642, // Kenyang
  2650, // Mohawk
  2657, // Nko
  2661, // Prussian
  2670, // Kiche
  2676, // Southern Sami
  2690, // Lule Sami
  2700, // Inari Sami
  2711, // Skolt Sami
  2722, // Warlpiri
  2731, // Manichaean Middle Persian
  2757, // Mende
  2763, // Ancient North Arabian
  2785, // Linear A
  2794, // Hmong Njua
  2805, // Ho
  2808, // Lezghian
  2817, // Bassa
  2823, // Mono
  2828, // Tedim Chin
  2839, // Maithili
  2848, // Ahom
  2853, // American Sign Language
  2876, // Ardhamagadhi Prakrit
  2897, // Bhojpuri
  2906, // Hieroglyphic Luwian
  2926, // Literary Chinese
  2943, // Mazanderani
  2955, // Mru
  2959, // Newari
  2966, // Northern Luri
  2980, // Palauan
  2988, // Papiamento
  2999, // Saraiki
  3007, // Tokelau
  3015, // Tok Pisin
  3025, // Tuvalu
  3032, // Uncoded Languages
  3050, // Cantonese
  3060, // Osage
  3066, // Tangut
  3073, // Ido
  3077, // Lojban
  3084, // Sicilian
  3093, // Southern Kurdish
  3110, // Western Balochi
  3126, // Cebuano
  3134, // Erzya
  3140, // Chickasaw
  3150, // Muscogee
  3159, // Silesian
};

static const char script_name_list[] =
"Default\0"
"Arabic\0"
"Cyrillic\0"
"Deseret\0"
"Gurmukhi\0"
"Simplified Han\0"
"Traditional Han\0"
"Latin\0"
"Mongolian\0"
"Tifinagh\0"
"Armenian\0"
"Bengali\0"
"Cherokee\0"
"Devanagari\0"
"Ethiopic\0"
"Georgian\0"
"Greek\0"
"Gujarati\0"
"Hebrew\0"
"Japanese\0"
"Khmer\0"
"Kannada\0"
"Korean\0"
"Lao\0"
"Malayalam\0"
"Myanmar\0"
"Oriya\0"
"Tamil\0"
"Telugu\0"
"Thaana\0"
"Thai\0"
"Tibetan\0"
"Sinhala\0"
"Syriac\0"
"Yi\0"
"Vai\0"
"Avestan\0"
"Balinese\0"
"Bamum\0"
"Batak\0"
"Bopomofo\0"
"Brahmi\0"
"Buginese\0"
"Buhid\0"
"Canadian Aboriginal\0"
"Carian\0"
"Chakma\0"
"Cham\0"
"Coptic\0"
"Cypriot\0"
"Egyptian Hieroglyphs\0"
"Fraser\0"
"Glagolitic\0"
"Gothic\0"
"Han\0"
"Hangul\0"
"Hanunoo\0"
"Imperial Aramaic\0"
"Inscriptional Pahlavi\0"
"Inscriptional Parthian\0"
"Javanese\0"
"Kaithi\0"
"Katakana\0"
"Kayah Li\0"
"Kharoshthi\0"
"Lanna\0"
"Lepcha\0"
"Limbu\0"
"Linear B\0"
"Lycian\0"
"Lydian\0"
"Mandaean\0"
"Meitei Mayek\0"
"Meroitic\0"
"Meroitic Cursive\0"
"Nko\0"
"New Tai Lue\0"
"Ogham\0"
"Ol Chiki\0"
"Old Italic\0"
"Old Persian\0"
"Old South Arabian\0"
"Orkhon\0"
"Osmanya\0"
"Phags Pa\0"
"Phoenician\0"
"Pollard Phonetic\0"
"Rejang\0"
"Runic\0"
"Samaritan\0"
"Saurashtra\0"
"Sharada\0"
"Shavian\0"
"Sora Sompeng\0"
"Cuneiform\0"
"Sundanese\0"
"Syloti Nagri\0"
"Tagalog\0"
"Tagbanwa\0"
"Tai Le\0"
"Tai Viet\0"
"Takri\0"
"Ugaritic\0"
"Braille\0"
"Hiragana\0"
"Caucasian Albanian\0"
"Bassa Vah\0"
"Duployan\0"
"Elbasan\0"
"Grantha\0"
"Pahawh Hmong\0"
"Khojki\0"
"Linear A\0"
"Mahajani\0"
"Manichaean\0"
"Mende Kikakui\0"
"Modi\0"
"Mro\0"
"Old North Arabian\0"
"Nabataean\0"
"Palmyrene\0"
"Pau Cin Hau\0"
"Old Permic\0"
"Psalter Pahlavi\0"
"Siddham\0"
"Khudawadi\0"
"Tirhuta\0"
"Varang Kshiti\0"
"Ahom\0"
"Anatolian Hieroglyphs\0"
"Hatran\0"
"Multani\0"
"Old Hungarian\0"
"Sign Writing\0"
"Adlam\0"
"Bhaiksuki\0"
"Marchen\0"
"Newa\0"
"Osage\0"
"Tangut\0"
"Han with Bopomofo\0"
"Jamo\0"
;

static const quint16 script_name_index[] = {
     0, // AnyScript
     8, // Arabic
    15, // Cyrillic
    24, // Deseret
    32, // Gurmukhi
    41, // Simplified Han
    56, // Traditional Han
    72, // Latin
    78, // Mongolian
    88, // Tifinagh
    97, // Armenian
   106, // Bengali
   114, // Cherokee
   123, // Devanagari
   134, // Ethiopic
   143, // Georgian
   152, // Greek
   158, // Gujarati
   167, // Hebrew
   174, // Japanese
   183, // Khmer
   189, // Kannada
   197, // Korean
   204, // Lao
   208, // Malayalam
   218, // Myanmar
   226, // Oriya
   232, // Tamil
   238, // Telugu
   245, // Thaana
   252, // Thai
   257, // Tibetan
   265, // Sinhala
   273, // Syriac
   280, // Yi
   283, // Vai
   287, // Avestan
   295, // Balinese
   304, // Bamum
   310, // Batak
   316, // Bopomofo
   325, // Brahmi
   332, // Buginese
   341, // Buhid
   347, // Canadian Aboriginal
   367, // Carian
   374, // Chakma
   381, // Cham
   386, // Coptic
   393, // Cypriot
   401, // Egyptian Hieroglyphs
   422, // Fraser
   429, // Glagolitic
   440, // Gothic
   447, // Han
   451, // Hangul
   458, // Hanunoo
   466, // Imperial Aramaic
   483, // Inscriptional Pahlavi
   505, // Inscriptional Parthian
   528, // Javanese
   537, // Kaithi
   544, // Katakana
   553, // Kayah Li
   562, // Kharoshthi
   573, // Lanna
   579, // Lepcha
   586, // Limbu
   592, // Linear B
   601, // Lycian
   608, // Lydian
   615, // Mandaean
   624, // Meitei Mayek
   637, // Meroitic
   646, // Meroitic Cursive
   663, // Nko
   667, // New Tai Lue
   679, // Ogham
   685, // Ol Chiki
   694, // Old Italic
   705, // Old Persian
   717, // Old South Arabian
   735, // Orkhon
   742, // Osmanya
   750, // Phags Pa
   759, // Phoenician
   770, // Pollard Phonetic
   787, // Rejang
   794, // Runic
   800, // Samaritan
   810, // Saurashtra
   821, // Sharada
   829, // Shavian
   837, // Sora Sompeng
   850, // Cuneiform
   860, // Sundanese
   870, // Syloti Nagri
   883, // Tagalog
   891, // Tagbanwa
   900, // Tai Le
   907, // Tai Viet
   916, // Takri
   922, // Ugaritic
   931, // Braille
   939, // Hiragana
   948, // Caucasian Albanian
   967, // Bassa Vah
   977, // Duployan
   986, // Elbasan
   994, // Grantha
  1002, // Pahawh Hmong
  1015, // Khojki
  1022, // Linear A
  1031, // Mahajani
  1040, // Manichaean
  1051, // Mende Kikakui
  1065, // Modi
  1070, // Mro
  1074, // Old North Arabian
  1092, // Nabataean
  1102, // Palmyrene
  1112, // Pau Cin Hau
  1124, // Old Permic
  1135, // Psalter Pahlavi
  1151, // Siddham
  1159, // Khudawadi
  1169, // Tirhuta
  1177, // Varang Kshiti
  1191, // Ahom
  1196, // Anatolian Hieroglyphs
  1218, // Hatran
  1225, // Multani
  1233, // Old Hungarian
  1247, // Sign Writing
  1260, // Adlam
  1266, // Bhaiksuki
  1276, // Marchen
  1284, // Newa
  1289, // Osage
  1295, // Tangut
  1302, // Han with Bopomofo
  1320, // Jamo
};

static const char country_name_list[] =
"Default\0"
"Afghanistan\0"
"Albania\0"
"Algeria\0"
"American Samoa\0"
"Andorra\0"
"Angola\0"
"Anguilla\0"
"Antarctica\0"
"Antigua And Barbuda\0"
"Argentina\0"
"Armenia\0"
"Aruba\0"
"Australia\0"
"Austria\0"
"Azerbaijan\0"
"Bahamas\0"
"Bahrain\0"
"Bangladesh\0"
"Barbados\0"
"Belarus\0"
"Belgium\0"
"Belize\0"
"Benin\0"
"Bermuda\0"
"Bhutan\0"
"Bolivia\0"
"Bosnia And Herzegowina\0"
"Botswana\0"
"Bouvet Island\0"
"Brazil\0"
"British Indian Ocean Territory\0"
"Brunei\0"
"Bulgaria\0"
"Burkina Faso\0"
"Burundi\0"
"Cambodia\0"
"Cameroon\0"
"Canada\0"
"Cape Verde\0"
"Cayman Islands\0"
"Central African Republic\0"
"Chad\0"
"Chile\0"
"China\0"
"Christmas Island\0"
"Cocos Islands\0"
"Colombia\0"
"Comoros\0"
"Congo Kinshasa\0"
"Congo Brazzaville\0"
"Cook Islands\0"
"Costa Rica\0"
"Ivory Coast\0"
"Croatia\0"
"Cuba\0"
"Cyprus\0"
"Czech Republic\0"
"Denmark\0"
"Djibouti\0"
"Dominica\0"
"Dominican Republic\0"
"East Timor\0"
"Ecuador\0"
"Egypt\0"
"El Salvador\0"
"Equatorial Guinea\0"
"Eritrea\0"
"Estonia\0"
"Ethiopia\0"
"Falkland Islands\0"
"Faroe Islands\0"
"Fiji\0"
"Finland\0"
"France\0"
"Guernsey\0"
"French Guiana\0"
"French Polynesia\0"
"French Southern Territories\0"
"Gabon\0"
"Gambia\0"
"Georgia\0"
"Germany\0"
"Ghana\0"
"Gibraltar\0"
"Greece\0"
"Greenland\0"
"Grenada\0"
"Guadeloupe\0"
"Guam\0"
"Guatemala\0"
"Guinea\0"
"Guinea Bissau\0"
"Guyana\0"
"Haiti\0"
"Heard And McDonald Islands\0"
"Honduras\0"
"Hong Kong\0"
"Hungary\0"
"Iceland\0"
"India\0"
"Indonesia\0"
"Iran\0"
"Iraq\0"
"Ireland\0"
"Israel\0"
"Italy\0"
"Jamaica\0"
"Japan\0"
"Jordan\0"
"Kazakhstan\0"
"Kenya\0"
"Kiribati\0"
"North Korea\0"
"South Korea\0"
"Kuwait\0"
"Kyrgyzstan\0"
"Laos\0"
"Latvia\0"
"Lebanon\0"
"Lesotho\0"
"Liberia\0"
"Libya\0"
"Liechtenstein\0"
"Lithuania\0"
"Luxembourg\0"
"Macau\0"
"Macedonia\0"
"Madagascar\0"
"Malawi\0"
"Malaysia\0"
"Maldives\0"
"Mali\0"
"Malta\0"
"Marshall Islands\0"
"Martinique\0"
"Mauritania\0"
"Mauritius\0"
"Mayotte\0"
"Mexico\0"
"Micronesia\0"
"Moldova\0"
"Monaco\0"
"Mongolia\0"
"Montserrat\0"
"Morocco\0"
"Mozambique\0"
"Myanmar\0"
"Namibia\0"
"Nauru\0"
"Nepal\0"
"Netherlands\0"
"Cura Sao\0"
"New Caledonia\0"
"New Zealand\0"
"Nicaragua\0"
"Niger\0"
"Nigeria\0"
"Niue\0"
"Norfolk Island\0"
"Northern Mariana Islands\0"
"Norway\0"
"Oman\0"
"Pakistan\0"
"Palau\0"
"Palestinian Territories\0"
"Panama\0"
"Papua New Guinea\0"
"Paraguay\0"
"Peru\0"
"Philippines\0"
"Pitcairn\0"
"Poland\0"
"Portugal\0"
"Puerto Rico\0"
"Qatar\0"
"Reunion\0"
"Romania\0"
"Russia\0"
"Rwanda\0"
"Saint Kitts And Nevis\0"
"Saint Lucia\0"
"Saint Vincent And The Grenadines\0"
"Samoa\0"
"San Marino\0"
"Sao Tome And Principe\0"
"Saudi Arabia\0"
"Senegal\0"
"Seychelles\0"
"Sierra Leone\0"
"Singapore\0"
"Slovakia\0"
"Slovenia\0"
"Solomon Islands\0"
"Somalia\0"
"South Africa\0"
"South Georgia And The South Sandwich Islands\0"
"Spain\0"
"Sri Lanka\0"
"Saint Helena\0"
"Saint Pierre And Miquelon\0"
"Sudan\0"
"Suriname\0"
"Svalbard And Jan Mayen Islands\0"
"Swaziland\0"
"Sweden\0"
"Switzerland\0"
"Syria\0"
"Taiwan\0"
"Tajikistan\0"
"Tanzania\0"
"Thailand\0"
"Togo\0"
"Tokelau\0"
"Tonga\0"
"Trinidad And Tobago\0"
"Tunisia\0"
"Turkey\0"
"Turkmenistan\0"
"Turks And Caicos Islands\0"
"Tuvalu\0"
"Uganda\0"
"Ukraine\0"
"United Arab Emirates\0"
"United Kingdom\0"
"United States\0"
"United States Minor Outlying Islands\0"
"Uruguay\0"
"Uzbekistan\0"
"Vanuatu\0"
"Vatican City State\0"
"Venezuela\0"
"Vietnam\0"
"British Virgin Islands\0"
"United States Virgin Islands\0"
"Wallis And Futuna Islands\0"
"Western Sahara\0"
"Yemen\0"
"Canary Islands\0"
"Zambia\0"
"Zimbabwe\0"
"Clipperton Island\0"
"Montenegro\0"
"Serbia\0"
"Saint Barthelemy\0"
"Saint Martin\0"
"Latin America\0"
"Ascension Island\0"
"Aland Islands\0"
"Diego Garcia\0"
"Ceuta And Melilla\0"
"Isle Of Man\0"
"Jersey\0"
"Tristan Da Cunha\0"
"South Sudan\0"
"Bonaire\0"
"Sint Maarten\0"
"Kosovo\0"
"European Union\0"
"Outlying Oceania\0"
"World\0"
"Europe\0"
;

static const quint16 country_name_index[] = {
     0, // AnyCountry
     8, // Afghanistan
    20, // Albania
    28, // Algeria
    36, // American Samoa
    51, // Andorra
    59, // Angola
    66, // Anguilla
    75, // Antarctica
    86, // Antigua And Barbuda
   106, // Argentina
   116, // Armenia
   124, // Aruba
   130, // Australia
   140, // Austria
   148, // Azerbaijan
   159, // Bahamas
   167, // Bahrain
   175, // Bangladesh
   186, // Barbados
   195, // Belarus
   203, // Belgium
   211, // Belize
   218, // Benin
   224, // Bermuda
   232, // Bhutan
   239, // Bolivia
   247, // Bosnia And Herzegowina
   270, // Botswana
   279, // Bouvet Island
   293, // Brazil
   300, // British Indian Ocean Territory
   331, // Brunei
   338, // Bulgaria
   347, // Burkina Faso
   360, // Burundi
   368, // Cambodia
   377, // Cameroon
   386, // Canada
   393, // Cape Verde
   404, // Cayman Islands
   419, // Central African Republic
   444, // Chad
   449, // Chile
   455, // China
   461, // Christmas Island
   478, // Cocos Islands
   492, // Colombia
   501, // Comoros
   509, // Congo Kinshasa
   524, // Congo Brazzaville
   542, // Cook Islands
   555, // Costa Rica
   566, // Ivory Coast
   578, // Croatia
   586, // Cuba
   591, // Cyprus
   598, // Czech Republic
   613, // Denmark
   621, // Djibouti
   630, // Dominica
   639, // Dominican Republic
   658, // East Timor
   669, // Ecuador
   677, // Egypt
   683, // El Salvador
   695, // Equatorial Guinea
   713, // Eritrea
   721, // Estonia
   729, // Ethiopia
   738, // Falkland Islands
   755, // Faroe Islands
   769, // Fiji
   774, // Finland
   782, // France
   789, // Guernsey
   798, // French Guiana
   812, // French Polynesia
   829, // French Southern Territories
   857, // Gabon
   863, // Gambia
   870, // Georgia
   878, // Germany
   886, // Ghana
   892, // Gibraltar
   902, // Greece
   909, // Greenland
   919, // Grenada
   927, // Guadeloupe
   938, // Guam
   943, // Guatemala
   953, // Guinea
   960, // Guinea Bissau
   974, // Guyana
   981, // Haiti
   987, // Heard And McDonald Islands
  1014, // Honduras
  1023, // Hong Kong
  1033, // Hungary
  1041, // Iceland
  1049, // India
  1055, // Indonesia
  1065, // Iran
  1070, // Iraq
  1075, // Ireland
  1083, // Israel
  1090, // Italy
  1096, // Jamaica
  1104, // Japan
  1110, // Jordan
  1117, // Kazakhstan
  1128, // Kenya
  1134, // Kiribati
  1143, // North Korea
  1155, // South Korea
  1167, // Kuwait
  1174, // Kyrgyzstan
  1185, // Laos
  1190, // Latvia
  1197, // Lebanon
  1205, // Lesotho
  1213, // Liberia
  1221, // Libya
  1227, // Liechtenstein
  1241, // Lithuania
  1251, // Luxembourg
  1262, // Macau
  1268, // Macedonia
  1278, // Madagascar
  1289, // Malawi
  1296, // Malaysia
  1305, // Maldives
  1314, // Mali
  1319, // Malta
  1325, // Marshall Islands
  1342, // Martinique
  1353, // Mauritania
  1364, // Mauritius
  1374, // Mayotte
  1382, // Mexico
  1389, // Micronesia
  1400, // Moldova
  1408, // Monaco
  1415, // Mongolia
  1424, // Montserrat
  1435, // Morocco
  1443, // Mozambique
  1454, // Myanmar
  1462, // Namibia
  1470, // Nauru
  1476, // Nepal
  1482, // Netherlands
  1494, // Cura Sao
  1503, // New Caledonia
  1517, // New Zealand
  1529, // Nicaragua
  1539, // Niger
  1545, // Nigeria
  1553, // Niue
  1558, // Norfolk Island
  1573, // Northern Mariana Islands
  1598, // Norway
  1605, // Oman
  1610, // Pakistan
  1619, // Palau
  1625, // Palestinian Territories
  1649, // Panama
  1656, // Papua New Guinea
  1673, // Paraguay
  1682, // Peru
  1687, // Philippines
  1699, // Pitcairn
  1708, // Poland
  1715, // Portugal
  1724, // Puerto Rico
  1736, // Qatar
  1742, // Reunion
  1750, // Romania
  1758, // Russia
  1765, // Rwanda
  1772, // Saint Kitts And Nevis
  1794, // Saint Lucia
  1806, // Saint Vincent And The Grenadines
  1839, // Samoa
  1845, // San Marino
  1856, // Sao Tome And Principe
  1878, // Saudi Arabia
  1891, // Senegal
  1899, // Seychelles
  1910, // Sierra Leone
  1923, // Singapore
  1933, // Slovakia
  1942, // Slovenia
  1951, // Solomon Islands
  1967, // Somalia
  1975, // South Africa
  1988, // South Georgia And The South Sandwich Islands
  2033, // Spain
  2039, // Sri Lanka
  2049, // Saint Helena
  2062, // Saint Pierre And Miquelon
  2088, // Sudan
  2094, // Suriname
  2103, // Svalbard And Jan Mayen Islands
  2134, // Swaziland
  2144, // Sweden
  2151, // Switzerland
  2163, // Syria
  2169, // Taiwan
  2176, // Tajikistan
  2187, // Tanzania
  2196, // Thailand
  2205, // Togo
  2210, // Tokelau
  2218, // Tonga
  2224, // Trinidad And Tobago
  2244, // Tunisia
  2252, // Turkey
  2259, // Turkmenistan
  2272, // Turks And Caicos Islands
  2297, // Tuvalu
  2304, // Uganda
  2311, // Ukraine
  2319, // United Arab Emirates
  2340, // United Kingdom
  2355, // United States
  2369, // United States Minor Outlying Islands
  2406, // Uruguay
  2414, // Uzbekistan
  2425, // Vanuatu
  2433, // Vatican City State
  2452, // Venezuela
  2462, // Vietnam
  2470, // British Virgin Islands
  2493, // United States Virgin Islands
  2522, // Wallis And Futuna Islands
  2548, // Western Sahara
  2563, // Yemen
  2569, // Canary Islands
  2584, // Zambia
  2591, // Zimbabwe
  2600, // Clipperton Island
  2618, // Montenegro
  2629, // Serbia
  2636, // Saint Barthelemy
  2653, // Saint Martin
  2666, // Latin America
  2680, // Ascension Island
  2697, // Aland Islands
  2711, // Diego Garcia
  2724, // Ceuta And Melilla
  2742, // Isle Of Man
  2754, // Jersey
  2761, // Tristan Da Cunha
  2778, // South Sudan
  2790, // Bonaire
  2798, // Sint Maarten
  2811, // Kosovo
  2818, // European Union
  2833, // Outlying Oceania
  2850, // World
  2856, // Europe
};

static const unsigned char language_code_list[] =
"  \0" // AnyLanguage
"  \0" // C
"ab\0" // Abkhazian
"om\0" // Oromo
"aa\0" // Afar
"af\0" // Afrikaans
"sq\0" // Albanian
"am\0" // Amharic
"ar\0" // Arabic
"hy\0" // Armenian
"as\0" // Assamese
"ay\0" // Aymara
"az\0" // Azerbaijani
"ba\0" // Bashkir
"eu\0" // Basque
"bn\0" // Bengali
"dz\0" // Dzongkha
"bh\0" // Bihari
"bi\0" // Bislama
"br\0" // Breton
"bg\0" // Bulgarian
"my\0" // Burmese
"be\0" // Belarusian
"km\0" // Khmer
"ca\0" // Catalan
"zh\0" // Chinese
"co\0" // Corsican
"hr\0" // Croatian
"cs\0" // Czech
"da\0" // Danish
"nl\0" // Dutch
"en\0" // English
"eo\0" // Esperanto
"et\0" // Estonian
"fo\0" // Faroese
"fj\0" // Fijian
"fi\0" // Finnish
"fr\0" // French
"fy\0" // Western Frisian
"gd\0" // Gaelic
"gl\0" // Galician
"ka\0" // Georgian
"de\0" // German
"el\0" // Greek
"kl\0" // Greenlandic
"gn\0" // Guarani
"gu\0" // Gujarati
"ha\0" // Hausa
"he\0" // Hebrew
"hi\0" // Hindi
"hu\0" // Hungarian
"is\0" // Icelandic
"id\0" // Indonesian
"ia\0" // Interlingua
"ie\0" // Interlingue
"iu\0" // Inuktitut
"ik\0" // Inupiak
"ga\0" // Irish
"it\0" // Italian
"ja\0" // Japanese
"jv\0" // Javanese
"kn\0" // Kannada
"ks\0" // Kashmiri
"kk\0" // Kazakh
"rw\0" // Kinyarwanda
"ky\0" // Kirghiz
"ko\0" // Korean
"ku\0" // Kurdish
"rn\0" // Rundi
"lo\0" // Lao
"la\0" // Latin
"lv\0" // Latvian
"ln\0" // Lingala
"lt\0" // Lithuanian
"mk\0" // Macedonian
"mg\0" // Malagasy
"ms\0" // Malay
"ml\0" // Malayalam
"mt\0" // Maltese
"mi\0" // Maori
"mr\0" // Marathi
"mh\0" // Marshallese
"mn\0" // Mongolian
"na\0" // Nauru
"ne\0" // Nepali
"nb\0" // Norwegian Bokmal
"oc\0" // Occitan
"or\0" // Oriya
"ps\0" // Pashto
"fa\0" // Persian
"pl\0" // Polish
"pt\0" // Portuguese
"pa\0" // Punjabi
"qu\0" // Quechua
"rm\0" // Romansh
"ro\0" // Romanian
"ru\0" // Russian
"sm\0" // Samoan
"sg\0" // Sango
"sa\0" // Sanskrit
"sr\0" // Serbian
"os\0" // Ossetic
"st\0" // Southern Sotho
"tn\0" // Tswana
"sn\0" // Shona
"sd\0" // Sindhi
"si\0" // Sinhala
"ss\0" // Swati
"sk\0" // Slovak
"sl\0" // Slovenian
"so\0" // Somali
"es\0" // Spanish
"su\0" // Sundanese
"sw\0" // Swahili
"sv\0" // Swedish
"sc\0" // Sardinian
"tg\0" // Tajik
"ta\0" // Tamil
"tt\0" // Tatar
"te\0" // Telugu
"th\0" // Thai
"bo\0" // Tibetan
"ti\0" // Tigrinya
"to\0" // Tongan
"ts\0" // Tsonga
"tr\0" // Turkish
"tk\0" // Turkmen
"ty\0" // Tahitian
"ug\0" // Uighur
"uk\0" // Ukrainian
"ur\0" // Urdu
"uz\0" // Uzbek
"vi\0" // Vietnamese
"vo\0" // Volapuk
"cy\0" // Welsh
"wo\0" // Wolof
"xh\0" // Xhosa
"yi\0" // Yiddish
"yo\0" // Yoruba
"za\0" // Zhuang
"zu\0" // Zulu
"nn\0" // Norwegian Nynorsk
"bs\0" // Bosnian
"dv\0" // Divehi
"gv\0" // Manx
"kw\0" // Cornish
"ak\0" // Akan
"kok" // Konkani
"gaa" // Ga
"ig\0" // Igbo
"kam" // Kamba
"syr" // Syriac
"byn" // Blin
"gez" // Geez
"kfo" // Koro
"sid" // Sidamo
"cch" // Atsam
"tig" // Tigre
"kaj" // Jju
"fur" // Friulian
"ve\0" // Venda
"ee\0" // Ewe
"wal" // Walamo
"haw" // Hawaiian
"kcg" // Tyap
"ny\0" // Nyanja
"fil" // Filipino
"gsw" // Swiss German
"ii\0" // Sichuan Yi
"kpe" // Kpelle
"nds" // Low German
"nr\0" // South Ndebele
"nso" // Northern Sotho
"se\0" // Northern Sami
"trv" // Taroko
"guz" // Gusii
"dav" // Taita
"ff\0" // Fulah
"ki\0" // Kikuyu
"saq" // Samburu
"seh" // Sena
"nd\0" // North Ndebele
"rof" // Rombo
"shi" // Tachelhit
"kab" // Kabyle
"nyn" // Nyankole
"bez" // Bena
"vun" // Vunjo
"bm\0" // Bambara
"ebu" // Embu
"chr" // Cherokee
"mfe" // Morisyen
"kde" // Makonde
"lag" // Langi
"lg\0" // Ganda
"bem" // Bemba
"kea" // Kabuverdianu
"mer" // Meru
"kln" // Kalenjin
"naq" // Nama
"jmc" // Machame
"ksh" // Colognian
"mas" // Masai
"xog" // Soga
"luy" // Luyia
"asa" // Asu
"teo" // Teso
"ssy" // Saho
"khq" // Koyra Chiini
"rwk" // Rwa
"luo" // Luo
"cgg" // Chiga
"tzm" // Central Morocco Tamazight
"ses" // Koyraboro Senni
"ksb" // Shambala
"brx" // Bodo
"av\0" // Avaric
"ch\0" // Chamorro
"ce\0" // Chechen
"cu\0" // Church
"cv\0" // Chuvash
"cr\0" // Cree
"ht\0" // Haitian
"hz\0" // Herero
"ho\0" // Hiri Motu
"kr\0" // Kanuri
"kv\0" // Komi
"kg\0" // Kongo
"kj\0" // Kwanyama
"li\0" // Limburgish
"lu\0" // Luba Katanga
"lb\0" // Luxembourgish
"nv\0" // Navaho
"ng\0" // Ndonga
"oj\0" // Ojibwa
"pi\0" // Pali
"wa\0" // Walloon
"agq" // Aghem
"bas" // Basaa
"dje" // Zarma
"dua" // Duala
"dyo" // Jola Fonyi
"ewo" // Ewondo
"ksf" // Bafia
"mgh" // Makhuwa Meetto
"mua" // Mundang
"nmg" // Kwasio
"nus" // Nuer
"sah" // Sakha
"sbp" // Sangu
"swc" // Congo Swahili
"twq" // Tasawaq
"vai" // Vai
"wae" // Walser
"yav" // Yangben
"ae\0" // Avestan
"ast" // Asturian
"jgo" // Ngomba
"kkj" // Kako
"mgo" // Meta
"nnh" // Ngiemboon
"an\0" // Aragonese
"akk" // Akkadian
"egy" // Ancient Egyptian
"grc" // Ancient Greek
"arc" // Aramaic
"ban" // Balinese
"bax" // Bamun
"bbc" // Batak Toba
"bug" // Buginese
"bku" // Buhid
"xcr" // Carian
"ccp" // Chakma
"myz" // Classical Mandaic
"cop" // Coptic
"doi" // Dogri
"cjm" // Eastern Cham
"eky" // Eastern Kayah
"ett" // Etruscan
"got" // Gothic
"hnn" // Hanunoo
"inh" // Ingush
"hmd" // Large Flowery Miao
"lep" // Lepcha
"lif" // Limbu
"lis" // Lisu
"khb" // Lu
"xlc" // Lycian
"xld" // Lydian
"man" // Mandingo
"mni" // Manipuri
"xmr" // Meroitic
"nod" // Northern Thai
"sga" // Old Irish
"non" // Old Norse
"peo" // Old Persian
"otk" // Old Turkish
"pal" // Pahlavi
"xpr" // Parthian
"phn" // Phoenician
"pra" // Prakrit Language
"rej" // Rejang
"xsa" // Sabaean
"smp" // Samaritan
"sat" // Santali
"saz" // Saurashtra
"srb" // Sora
"syl" // Sylheti
"tbw" // Tagbanwa
"blt" // Tai Dam
"tdd" // Tai Nua
"uga" // Ugaritic
"bss" // Akoose
"lkt" // Lakota
"zgh" // Standard Moroccan Tamazight
"arn" // Mapuche
"ckb" // Central Kurdish
"dsb" // Lower Sorbian
"hsb" // Upper Sorbian
"ken" // Kenyang
"moh" // Mohawk
"nqo" // Nko
"prg" // Prussian
"quc" // Kiche
"sma" // Southern Sami
"smj" // Lule Sami
"smn" // Inari Sami
"sms" // Skolt Sami
"wbp" // Warlpiri
"xmn" // Manichaean Middle Persian
"men" // Mende
"xna" // Ancient North Arabian
"lab" // Linear A
"hnj" // Hmong Njua
"hoc" // Ho
"lez" // Lezghian
"bsq" // Bassa
"mru" // Mono
"ctd" // Tedim Chin
"mai" // Maithili
"aho" // Ahom
"ase" // American Sign Language
"pka" // Ardhamagadhi Prakrit
"bho" // Bhojpuri
"hlu" // Hieroglyphic Luwian
"lzh" // Literary Chinese
"mzn" // Mazanderani
"mro" // Mru
"new" // Newari
"lrc" // Northern Luri
"pau" // Palauan
"pap" // Papiamento
"skr" // Saraiki
"tkl" // Tokelau
"tpi" // Tok Pisin
"tvl" // Tuvalu
"mis" // Uncoded Languages
"yue" // Cantonese
"osa" // Osage
"txg" // Tangut
"io\0" // Ido
"jbo" // Lojban
"scn" // Sicilian
"sdh" // Southern Kurdish
"bgn" // Western Balochi
"ceb" // Cebuano
"myv" // Erzya
"cic" // Chickasaw
"mus" // Muscogee
"szl" // Silesian
;

static const unsigned char script_code_list[] =
"Zzzz" // AnyScript
"Arab" // Arabic
"Cyrl" // Cyrillic
"Dsrt" // Deseret
"Guru" // Gurmukhi
"Hans" // Simplified Han
"Hant" // Traditional Han
"Latn" // Latin
"Mong" // Mongolian
"Tfng" // Tifinagh
"Armn" // Armenian
"Beng" // Bengali
"Cher" // Cherokee
"Deva" // Devanagari
"Ethi" // Ethiopic
"Geor" // Georgian
"Grek" // Greek
"Gujr" // Gujarati
"Hebr" // Hebrew
"Jpan" // Japanese
"Khmr" // Khmer
"Knda" // Kannada
"Kore" // Korean
"Laoo" // Lao
"Mlym" // Malayalam
"Mymr" // Myanmar
"Orya" // Oriya
"Taml" // Tamil
"Telu" // Telugu
"Thaa" // Thaana
"Thai" // Thai
"Tibt" // Tibetan
"Sinh" // Sinhala
"Syrc" // Syriac
"Yiii" // Yi
"Vaii" // Vai
"Avst" // Avestan
"Bali" // Balinese
"Bamu" // Bamum
"Batk" // Batak
"Bopo" // Bopomofo
"Brah" // Brahmi
"Bugi" // Buginese
"Buhd" // Buhid
"Cans" // Canadian Aboriginal
"Cari" // Carian
"Cakm" // Chakma
"Cham" // Cham
"Copt" // Coptic
"Cprt" // Cypriot
"Egyp" // Egyptian Hieroglyphs
"Lisu" // Fraser
"Glag" // Glagolitic
"Goth" // Gothic
"Hani" // Han
"Hang" // Hangul
"Hano" // Hanunoo
"Armi" // Imperial Aramaic
"Phli" // Inscriptional Pahlavi
"Prti" // Inscriptional Parthian
"Java" // Javanese
"Kthi" // Kaithi
"Kana" // Katakana
"Kali" // Kayah Li
"Khar" // Kharoshthi
"Lana" // Lanna
"Lepc" // Lepcha
"Limb" // Limbu
"Linb" // Linear B
"Lyci" // Lycian
"Lydi" // Lydian
"Mand" // Mandaean
"Mtei" // Meitei Mayek
"Mero" // Meroitic
"Merc" // Meroitic Cursive
"Nkoo" // Nko
"Talu" // New Tai Lue
"Ogam" // Ogham
"Olck" // Ol Chiki
"Ital" // Old Italic
"Xpeo" // Old Persian
"Sarb" // Old South Arabian
"Orkh" // Orkhon
"Osma" // Osmanya
"Phag" // Phags Pa
"Phnx" // Phoenician
"Plrd" // Pollard Phonetic
"Rjng" // Rejang
"Runr" // Runic
"Samr" // Samaritan
"Saur" // Saurashtra
"Shrd" // Sharada
"Shaw" // Shavian
"Sora" // Sora Sompeng
"Xsux" // Cuneiform
"Sund" // Sundanese
"Sylo" // Syloti Nagri
"Tglg" // Tagalog
"Tagb" // Tagbanwa
"Tale" // Tai Le
"Tavt" // Tai Viet
"Takr" // Takri
"Ugar" // Ugaritic
"Brai" // Braille
"Hira" // Hiragana
"Aghb" // Caucasian Albanian
"Bass" // Bassa Vah
"Dupl" // Duployan
"Elba" // Elbasan
"Gran" // Grantha
"Hmng" // Pahawh Hmong
"Khoj" // Khojki
"Lina" // Linear A
"Mahj" // Mahajani
"Mani" // Manichaean
"Mend" // Mende Kikakui
"Modi" // Modi
"Mroo" // Mro
"Narb" // Old North Arabian
"Nbat" // Nabataean
"Palm" // Palmyrene
"Pauc" // Pau Cin Hau
"Perm" // Old Permic
"Phlp" // Psalter Pahlavi
"Sidd" // Siddham
"Sind" // Khudawadi
"Tirh" // Tirhuta
"Wara" // Varang Kshiti
"Ahom" // Ahom
"Hluw" // Anatolian Hieroglyphs
"Hatr" // Hatran
"Mult" // Multani
"Hung" // Old Hungarian
"Sgnw" // Sign Writing
"Adlm" // Adlam
"Bhks" // Bhaiksuki
"Marc" // Marchen
"Newa" // Newa
"Osge" // Osage
"Tang" // Tangut
"Hanb" // Han with Bopomofo
"Jamo" // Jamo
;
static const unsigned char country_code_list[] =
"ZZ\0" // AnyCountry
"AF\0" // Afghanistan
"AL\0" // Albania
"DZ\0" // Algeria
"AS\0" // American Samoa
"AD\0" // Andorra
"AO\0" // Angola
"AI\0" // Anguilla
"AQ\0" // Antarctica
"AG\0" // Antigua And Barbuda
"AR\0" // Argentina
"AM\0" // Armenia
"AW\0" // Aruba
"AU\0" // Australia
"AT\0" // Austria
"AZ\0" // Azerbaijan
"BS\0" // Bahamas
"BH\0" // Bahrain
"BD\0" // Bangladesh
"BB\0" // Barbados
"BY\0" // Belarus
"BE\0" // Belgium
"BZ\0" // Belize
"BJ\0" // Benin
"BM\0" // Bermuda
"BT\0" // Bhutan
"BO\0" // Bolivia
"BA\0" // Bosnia And Herzegowina
"BW\0" // Botswana
"BV\0" // Bouvet Island
"BR\0" // Brazil
"IO\0" // British Indian Ocean Territory
"BN\0" // Brunei
"BG\0" // Bulgaria
"BF\0" // Burkina Faso
"BI\0" // Burundi
"KH\0" // Cambodia
"CM\0" // Cameroon
"CA\0" // Canada
"CV\0" // Cape Verde
"KY\0" // Cayman Islands
"CF\0" // Central African Republic
"TD\0" // Chad
"CL\0" // Chile
"CN\0" // China
"CX\0" // Christmas Island
"CC\0" // Cocos Islands
"CO\0" // Colombia
"KM\0" // Comoros
"CD\0" // Congo Kinshasa
"CG\0" // Congo Brazzaville
"CK\0" // Cook Islands
"CR\0" // Costa Rica
"CI\0" // Ivory Coast
"HR\0" // Croatia
"CU\0" // Cuba
"CY\0" // Cyprus
"CZ\0" // Czech Republic
"DK\0" // Denmark
"DJ\0" // Djibouti
"DM\0" // Dominica
"DO\0" // Dominican Republic
"TL\0" // East Timor
"EC\0" // Ecuador
"EG\0" // Egypt
"SV\0" // El Salvador
"GQ\0" // Equatorial Guinea
"ER\0" // Eritrea
"EE\0" // Estonia
"ET\0" // Ethiopia
"FK\0" // Falkland Islands
"FO\0" // Faroe Islands
"FJ\0" // Fiji
"FI\0" // Finland
"FR\0" // France
"GG\0" // Guernsey
"GF\0" // French Guiana
"PF\0" // French Polynesia
"TF\0" // French Southern Territories
"GA\0" // Gabon
"GM\0" // Gambia
"GE\0" // Georgia
"DE\0" // Germany
"GH\0" // Ghana
"GI\0" // Gibraltar
"GR\0" // Greece
"GL\0" // Greenland
"GD\0" // Grenada
"GP\0" // Guadeloupe
"GU\0" // Guam
"GT\0" // Guatemala
"GN\0" // Guinea
"GW\0" // Guinea Bissau
"GY\0" // Guyana
"HT\0" // Haiti
"HM\0" // Heard And McDonald Islands
"HN\0" // Honduras
"HK\0" // Hong Kong
"HU\0" // Hungary
"IS\0" // Iceland
"IN\0" // India
"ID\0" // Indonesia
"IR\0" // Iran
"IQ\0" // Iraq
"IE\0" // Ireland
"IL\0" // Israel
"IT\0" // Italy
"JM\0" // Jamaica
"JP\0" // Japan
"JO\0" // Jordan
"KZ\0" // Kazakhstan
"KE\0" // Kenya
"KI\0" // Kiribati
"KP\0" // North Korea
"KR\0" // South Korea
"KW\0" // Kuwait
"KG\0" // Kyrgyzstan
"LA\0" // Laos
"LV\0" // Latvia
"LB\0" // Lebanon
"LS\0" // Lesotho
"LR\0" // Liberia
"LY\0" // Libya
"LI\0" // Liechtenstein
"LT\0" // Lithuania
"LU\0" // Luxembourg
"MO\0" // Macau
"MK\0" // Macedonia
"MG\0" // Madagascar
"MW\0" // Malawi
"MY\0" // Malaysia
"MV\0" // Maldives
"ML\0" // Mali
"MT\0" // Malta
"MH\0" // Marshall Islands
"MQ\0" // Martinique
"MR\0" // Mauritania
"MU\0" // Mauritius
"YT\0" // Mayotte
"MX\0" // Mexico
"FM\0" // Micronesia
"MD\0" // Moldova
"MC\0" // Monaco
"MN\0" // Mongolia
"MS\0" // Montserrat
"MA\0" // Morocco
"MZ\0" // Mozambique
"MM\0" // Myanmar
"NA\0" // Namibia
"NR\0" // Nauru
"NP\0" // Nepal
"NL\0" // Netherlands
"CW\0" // Cura Sao
"NC\0" // New Caledonia
"NZ\0" // New Zealand
"NI\0" // Nicaragua
"NE\0" // Niger
"NG\0" // Nigeria
"NU\0" // Niue
"NF\0" // Norfolk Island
"MP\0" // Northern Mariana Islands
"NO\0" // Norway
"OM\0" // Oman
"PK\0" // Pakistan
"PW\0" // Palau
"PS\0" // Palestinian Territories
"PA\0" // Panama
"PG\0" // Papua New Guinea
"PY\0" // Paraguay
"PE\0" // Peru
"PH\0" // Philippines
"PN\0" // Pitcairn
"PL\0" // Poland
"PT\0" // Portugal
"PR\0" // Puerto Rico
"QA\0" // Qatar
"RE\0" // Reunion
"RO\0" // Romania
"RU\0" // Russia
"RW\0" // Rwanda
"KN\0" // Saint Kitts And Nevis
"LC\0" // Saint Lucia
"VC\0" // Saint Vincent And The Grenadines
"WS\0" // Samoa
"SM\0" // San Marino
"ST\0" // Sao Tome And Principe
"SA\0" // Saudi Arabia
"SN\0" // Senegal
"SC\0" // Seychelles
"SL\0" // Sierra Leone
"SG\0" // Singapore
"SK\0" // Slovakia
"SI\0" // Slovenia
"SB\0" // Solomon Islands
"SO\0" // Somalia
"ZA\0" // South Africa
"GS\0" // South Georgia And The South Sandwich Islands
"ES\0" // Spain
"LK\0" // Sri Lanka
"SH\0" // Saint Helena
"PM\0" // Saint Pierre And Miquelon
"SD\0" // Sudan
"SR\0" // Suriname
"SJ\0" // Svalbard And Jan Mayen Islands
"SZ\0" // Swaziland
"SE\0" // Sweden
"CH\0" // Switzerland
"SY\0" // Syria
"TW\0" // Taiwan
"TJ\0" // Tajikistan
"TZ\0" // Tanzania
"TH\0" // Thailand
"TG\0" // Togo
"TK\0" // Tokelau
"TO\0" // Tonga
"TT\0" // Trinidad And Tobago
"TN\0" // Tunisia
"TR\0" // Turkey
"TM\0" // Turkmenistan
"TC\0" // Turks And Caicos Islands
"TV\0" // Tuvalu
"UG\0" // Uganda
"UA\0" // Ukraine
"AE\0" // United Arab Emirates
"GB\0" // United Kingdom
"US\0" // United States
"UM\0" // United States Minor Outlying Islands
"UY\0" // Uruguay
"UZ\0" // Uzbekistan
"VU\0" // Vanuatu
"VA\0" // Vatican City State
"VE\0" // Venezuela
"VN\0" // Vietnam
"VG\0" // British Virgin Islands
"VI\0" // United States Virgin Islands
"WF\0" // Wallis And Futuna Islands
"EH\0" // Western Sahara
"YE\0" // Yemen
"IC\0" // Canary Islands
"ZM\0" // Zambia
"ZW\0" // Zimbabwe
"CP\0" // Clipperton Island
"ME\0" // Montenegro
"RS\0" // Serbia
"BL\0" // Saint Barthelemy
"MF\0" // Saint Martin
"419" // Latin America
"AC\0" // Ascension Island
"AX\0" // Aland Islands
"DG\0" // Diego Garcia
"EA\0" // Ceuta And Melilla
"IM\0" // Isle Of Man
"JE\0" // Jersey
"TA\0" // Tristan Da Cunha
"SS\0" // South Sudan
"BQ\0" // Bonaire
"SX\0" // Sint Maarten
"XK\0" // Kosovo
"EU\0" // European Union
"QO\0" // Outlying Oceania
"001" // World
"150" // Europe
;

// GENERATED PART ENDS HERE

QT_END_NAMESPACE

#endif
