/* Copyright (C) 2004 Nikos Chantziaras.
 *
 * This file is part of the QTads program.  This program is free
 * software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef QTADSAPPCTX_H
#define QTADSAPPCTX_H

#include "config.h"

/* Tads 2 provides to the host application (in this case QTads itself) a
 * so-called "application container context" (appctx).  Details can be
 * found in tads2/appctx.h.  This file provides some functions that are
 * used in the appctx.  For example, file I/O safety is managed by these
 * functions through the appctx.
 *
 * Note that these functions are not required to be 'extern "C"', since
 * they are called by C code only through pointers.
 */

namespace QTadsAppctx {

	/* Reports the current file I/O safety level.
	 */
	int
	getIoSafetyLevel( void* );

}

#endif // QTADSAPPCTX_H
