#include "rxwidget.h"
#include "txwidget.h"
#include "qsstvglobal.h"
#include "utils/supportfunctions.h"
#include "ui_rxwidget.h"
#include "sstv/sstvparam.h"
#include "dsp/filterparam.h"
#include "sound/soundio.h"
#include "configparams.h"
#include "dispatcher.h"
#include "mainwindow.h"


rxWidget *rxWidgetPtr;

spectrumWidget *rxWidget::fftDisplayPtr()
{
  return ui->spectrumFrame;
}

vuMeter *rxWidget::vMeterPtr()
{
   return ui->vuWidget;
}

vuMeter *rxWidget::sMeterPtr()
{
   return ui->syncWidget;
}

rxWidget::rxWidget(QWidget *parent) :
  QWidget(parent),
  ui(new Ui::rxWidget)
{
  int i;
  ui->setupUi(this);
  rxFunctionsPtr=new rxFunctions();
  ui->syncWidget->setHorizontal(false);
  ui->syncWidget->setColors(Qt::red,QColor(255,165,0),Qt::green);
  ui->syncWidget->setMaximum(10.);
  ui->syncWidget->setValue(0.);
  ui->syncWidget->setLabelText("S");

  ui->vuWidget->setHorizontal(true);
  ui->vuWidget->setLabelText("V");
  ui->vuWidget->setColors(QColor(255,50,0),Qt::green,Qt::red);
  ui->vuWidget->setMaximum(10.);
  ui->vuWidget->setValue(0.);
  imageViewerPtr=ui->imageFrame;
  imageViewerPtr->createImage(QSize(320,256),QColor(0,0,128));
  imageViewerPtr->setType(imageViewer::RXIMG);

  ui->sstvModeComboBox->addItem("Auto");
  for(i=0;i<NUMSSTVMODES-1;i++)
    {
      ui->sstvModeComboBox->addItem(getSSTVModeNameLong((esstvMode)i));
    }
  for(i=0;i<NUMRXFILTERS;i++)
    {
      ui->filterComboBox->addItem(filterStruct[i].filterName);
    }

  connect(ui->startToolButton, SIGNAL(clicked()),SLOT(slotStart()));
  connect(ui->stopToolButton, SIGNAL(clicked()),SLOT(slotStop()));
  connect(ui->autoSlantAdjustCheckBox,SIGNAL(clicked()),SLOT(slotGetParams()));
  connect(ui->squelchSpinBox,SIGNAL(valueChanged(int)),SLOT(slotGetParams()));
  connect(ui->settingsTableWidget,SIGNAL(currentChanged(int)),this, SLOT(slotTransmissionMode(int)));
}

rxWidget::~rxWidget()
{
  rxFunctionsPtr->stopAndWait();
  delete ui;
}

void rxWidget::init()
{
  splashStr+=QString( "Setting up RX" ).rightJustified(25,' ')+"\n";
  splashPtr->showMessage ( splashStr ,Qt::AlignLeft,Qt::white);
  qApp->processEvents();
  readSettings();
  rxFunctionsPtr->start();
}


void rxWidget::slotStart()
{
  getParams();
  dispatcherPtr->startRX(true);
}

void rxWidget::slotStop()
{
  dispatcherPtr->startRX(false);
}

void rxWidget::start(bool st)
{
  if(st)
    {
      rxFunctionsPtr->stopAndWait();
      soundIOPtr->startCapture();
      rxFunctionsPtr->startRX();
      addToLog("starting rxfunction run",LOGRXMAIN);
    }
  else
    {
      soundIOPtr->idle();
      writeSettings();
      ui->spectrumFrame->writeSettings();
      rxFunctionsPtr->stopAndWait();
    }
}


void rxWidget::readSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("RX");
  useVIS=qSettings.value("useVIS",false).toBool();
  autoSlantAdjust=qSettings.value("autoSlantAdjust",false).toBool();
  autoSave=qSettings.value("autoSave",true).toBool();
  squelch=qSettings.value("squelch",1).toInt();
  filterIndex=(qSettings.value("filterIndex",0)).toInt();
  setParams();
  qSettings.endGroup();
}

void rxWidget::writeSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("RX");
  getParams();
  qSettings.setValue( "useVIS",useVIS);
  qSettings.setValue( "autoSlantAdjust",autoSlantAdjust);
  qSettings.setValue( "autoSave",autoSave);
  qSettings.setValue( "squelch",squelch);
  qSettings.setValue( "filterIndex", filterIndex);
  qSettings.endGroup();
}

void rxWidget::getParams()
{
  getValue(useVIS,ui->useVISCheckBox);
  getValue(autoSlantAdjust,ui->autoSlantAdjustCheckBox);
  getValue(autoSave,ui->autoSaveCheckBox);
  getValue(squelch,ui->squelchSpinBox);
  getIndex(filterIndex,ui->filterComboBox);
  if(filterIndex<0) filterIndex=0;
}

void rxWidget::setParams()
{
  setValue(useVIS,ui->useVISCheckBox);
  setValue(autoSlantAdjust,ui->autoSlantAdjustCheckBox);
  setValue(autoSave,ui->autoSaveCheckBox);
  setValue(squelch,ui->squelchSpinBox);
  setIndex(filterIndex,ui->filterComboBox);
}

void rxWidget::setSSTVStatusText(QString txt)
{
  ui->sstvStatusLineEdit->setText(txt);
}

void rxWidget::setDRMStatusText(QString txt)
{
  ui->drmStatusLineEdit->setText(txt);
}


void  rxWidget::setFilterIndex(int index)
{

  ui->filterComboBox->setCurrentIndex(index);

}

int rxWidget::getFilterIndex()
{
  return ui->filterComboBox->currentIndex();
}

void  rxWidget::slotGetParams()
{
  getParams();
}

void rxWidget::setSettingsTab()
{

  int i;
  if((transmissionModeIndex>=0)&&(transmissionModeIndex<NOMODE))
    {
      for(i=0;i<NOMODE;i++)
        {
          if(i!=transmissionModeIndex) ui->settingsTableWidget->widget(i)->setEnabled(false);
        }
      ui->settingsTableWidget->widget(transmissionModeIndex)->setEnabled(true);
      ui->settingsTableWidget->setCurrentIndex(transmissionModeIndex);
    }
  if(transmissionModeIndex==DRM)
    {
      ui->syncWidget->setColors(QColor(0,90,0),QColor(0,190,0),Qt::green);
      ui->syncWidget->setMaximum(25.);
      ui->syncWidget->setMinimum(5.);
      ui->syncWidget->setValue(0.);
      ui->vuWidget->setColors(QColor(255,50,0),Qt::green,Qt::red);
      ui->vuWidget->setMaximum(40.);
      ui->vuWidget->setMinimum(18.);
      ui->vuWidget->setValue(0.);
      ui->spectrumFrame->displaySettings(true,true);
    }
  else
    {
      ui->syncWidget->setColors(Qt::red,QColor(255,165,0),Qt::green);
      ui->syncWidget->setMaximum(10.);
      ui->syncWidget->setMinimum(0.);
      ui->syncWidget->setValue(0.);
      ui->vuWidget->setColors(QColor(255,50,0),Qt::green,Qt::red);
      ui->vuWidget->setMaximum(10.);
      ui->vuWidget->setMinimum(0.);
      ui->vuWidget->setValue(0.);
      ui->spectrumFrame->displaySettings(false,false);
    }
}

void rxWidget::slotTransmissionMode(int rxtxMode)
{
  transmissionModeIndex=(etransmissionMode)rxtxMode;
  start(false);
  setSettingsTab();
  txWidgetPtr->setSettingsTab();
  if(transmissionModeIndex==DRM)
    {
      mainWindowPtr->setBSRPushButton(true);
    }
  else
    {
      mainWindowPtr->setBSRPushButton(true);
    }
   start(true);
}
