#include "syncdisplay.h" 
#include <qpainter.h>
#include <math.h>
#include "qsstvglobal.h"
#include "dspfunc.h"

#define FMIN 1000
#define FMAX 2600

void syncroDisplay::paintEvent(QPaintEvent *p)
{
  draw();
  QFrame::paintEvent(p);
}



void syncroDisplay::setData(unsigned short int irp)
{
	rp=irp;

}


void syncroDisplay::draw()
{
  int i,t;
  unsigned short int j;
	float temp;
	QPainter p;
  // the offset should be in the middle
	for (i=0,j=(rp-SYNCBUFFERSIZE/2);i<SYNCBUFFERSIZE;i++)
    {
     temp=dsp->getFilteredData(j);
     temp-=(float)FMIN;
     temp=(temp<0 ? 0 : temp);
     dataBuffer[i]=(uint)(temp);
     j++;
    }
  QPointArray syncArray(SYNCBUFFERSIZE);
  int h=contentsRect().height();
  int w=contentsRect().width();
  int bw=lineWidth();
  p.begin(this);
  p.eraseRect(contentsRect());
  p.setPen(red);
  // We start at 1000 Hz
  // draw 1200 Line

  t=bw+h-h*(1200-FMIN)/(FMAX-FMIN);
  p.drawLine(bw,t,w,t);

  t=bw+h-h*(1500-FMIN)/(FMAX-FMIN);
  p.drawLine(bw,t,w,t);

  t=bw+h-h*(2300-FMIN)/(FMAX-FMIN);
  p.drawLine(bw,t,w,t);  
  p.setPen(green);
  t=bw+w/2;
  p.drawLine(t,bw,t,h+bw);
  for (i=0;i<SYNCBUFFERSIZE;i++)
    {
      t=bw+h-h*dataBuffer[i]/(FMAX-FMIN);
      t=(t>=h ? h : t);
      t=(t<bw ? bw : t);
      syncArray.setPoint(i,bw+i*w/SYNCBUFFERSIZE,t);
    } 
  p.setPen(green);
  p.drawPolyline(syncArray);
  p.end();
}
