#ifndef rxwindow_included
#define rxwindow_included
#include <qmainwindow.h>
#include <qprinter.h>
#include <qpopupmenu.h>
#include <qlayout.h>
#include <qfile.h>
#include <qtimer.h>
#include <qlabel.h>
//#include "spectrumdisplay.h"
#include "fft.h"
#include "syncdisplay.h"
#include "vumeter.h"
#include "repeater.h"
#include "dspfunc.h"

class ledBar;
class QCheckBox;
class QComboBox;
class QSpinBox;
class QToolButton;
class QToolBar;
class imageFrame;

class rxWindow : public QMainWindow
{
    Q_OBJECT
public:
    rxWindow(QWidget *p=0 ,const char *n=0, WFlags f=0);
    ~rxWindow();
   
protected  slots:
    void slotSave();
    void slotPrint();
    virtual void slotStart()=0;
    virtual void slotStop()=0;
    virtual void slotTop()=0;
    virtual void slotDump()=0;
    virtual void slotPlot()=0;
    virtual void slotRecord()=0;
    virtual void slotResync()=0;
    virtual void slotVisButton(bool b)=0;
    virtual void slotFilterChange(int fil)=0;
		virtual void slotPostFilterChange(int fil)=0;

    void slotErase();
    void slotZoom();
    void slotConfig();
    void slotAdjustSlant();
    void slotAutosaveButton(bool b);
    // void postfilterButton(bool b);
    void slotDXButton(bool b);
    void slotSensitivity(int s);
    void slotAutoEraseButton(bool b);
    void slotBrowserx();
    void slotAboutQSSTV();
    void slotAboutQt();
    void slotUserGuide();
    virtual void slotSSTVFAX(int i);
public slots:
		void slotFaxTypeChanged(int);

 protected:
 		QToolBar *faxTools;
 		QToolBar *filterTools;
 		QToolBar *mainTools;
 		QToolBar *displayTools;
 		QComboBox *sstvfax;
    void setCanvasSize(int x, int y);
    int canvasX,canvasY;
    imageFrame  *canvas;
//    spectrumDisplay * specDisplay;
    fft *fftDisplay;
    syncroDisplay   * syncDisplay;
    VUMeter *vu;
		QToolButton * resyncrx;
 		QCheckBox *VISButton;
  	QCheckBox *autosaveBtn;
  	QCheckBox *dxBtn;
  	QComboBox *sensitivityCBox;
  	QCheckBox *repeaterBtn;
  	QCheckBox *eraseBtn;
  	QComboBox *filterMode;
  	QComboBox *postFilterMode;
  	QSpinBox *lpmSpinBox;
    QSpinBox *iocSpinBox;
    QComboBox *faxTypeComboBox;
    QComboBox *selectBox;
    QComboBox *colorComboBox;
    QSpinBox *linesSpinBox;
    QCheckBox *invPolCheckBox;
    QFile ftemp;
    QLabel *permText;
    ledBar *leds;
    void buildLayoutSSTV();
		void buildLayoutFAX(int width,int height);






private:
    QPrinter *printer;
    QPopupMenu *options;
    void saveConfig();


};
#endif















