#include "qsstvglobal.h"
#include <stdarg.h>
#include "sstvrx.h"
#include "sstvtx.h"
#include "repeater.h"
#include "thumbwindow.h"
#include "configfile.h"
#include "configtable.h"
#include "./config.h"
#include <qmessagebox.h>



// Global definitions

unsigned int isamplingrate;
float fRXsamplingrate;
float fTXsamplingrate;
float foffsetRX;
float foffsetTX;
const char * imageFormat;
const char * FTPimageFormat;
bool buseVIS;
bool bautoSave;
bool bDX;
bool bautoErase;
bool btimestamp;
int ibannerNumber;
bool bftp;
bool bCW;
bool bVOX;
bool buseBanner;
bool bUTC;
int iCWHz;
int iCWWPM;
int irepImInterval;
int iftpPort;
int syncDetectSensitivity;
int modeSSTVFAXRX;
int modeSSTVFAXTX;
int faxType;
int faxlpm1;
int faxioc1;
int faxColors1;
int faxLines1;
bool faxInvp1;
int faxlpm2;
int faxioc2;
int faxColors2;
int faxLines2;
bool faxInvp2;
int faxlpm3;
int faxioc3;
int faxColors3;
int faxLines3;
bool faxInvp3;
int faxlpm4;
int faxioc4;
int faxColors4;
int faxLines4;
bool faxInvp4;
int borderColor;
QColor bColor; // used in imageframe position
bool posKeepAR;
bool pLeft;
bool pCenter;
bool pRight;
bool pTop;
bool pMiddle;
bool pBottom;
bool pScaled;
int zoomScale;
int zoomWidth;
int zoomHeight;

configurationFile configFile;
sstvRX *rx;
sstvTX *tx;
repeater *rep;
thumbWindow *tw;

const char *imageFormatStr[NUMBEROFIMAGEFORMATS]=
{ "png", "bmp", "xbm", "xpm", "jpeg" };



void Initialize()
{
	QString s= QString(PACKAGE) +QString(".conf");
   configFile.initOptions(configTable,s,0);
   if ( fTXsamplingrate < 9000)
    {
      isamplingrate=8000;
    }
  else
    {
      isamplingrate=11000;
    }
}

void addWT(QWidget *qwptr, const char *s)
{
    QWhatsThis::add( qwptr, s);
}


void fileLoadError (const char *title,const char *fn)
{
  char strtemp[500];
  sprintf(strtemp,"Could not load requested file\n %s\n"
	  "Check the configuration file, and be sure to have read access",fn);

  QMessageBox::information( 0, title,strtemp,QMessageBox::Ok + QMessageBox::Default );
}


#ifdef  DEBUGQSSTV
void qsstvDebug(const char *fmt, ...)
{
  va_list args;
  char str[1000];  
  va_start(args, fmt);
  vsnprintf(str, 999, fmt, args);
  va_end(args);
  debug("%s",str);
}
#else
void qsstvDebug(...)
{
}



#endif

























