/***************************************************************************
                          ledbar.cpp  -  QSSTV
                             -------------------
    begin                : Thu May 24 2001
    copyright            : (C) 2001 by Johan Maes
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ledbar.h"
#include <qlabel.h>
#include <qlayout.h>
#include "icons/redled_off.xpm"
#include "icons/yellowled_off.xpm"
#include "icons/greenled_off.xpm"
#include "icons/redled_on.xpm"
#include "icons/yellowled_on.xpm"
#include "icons/greenled_on.xpm"
#include "qpixmap.h"


ledBar::ledBar(QWidget *parent, const char *name, WFlags f) :QWidget(parent,name,f)
{
			QHBoxLayout *hl=new QHBoxLayout(this);
			r=new QLabel(this);
			g=new QLabel(this);
			y=new QLabel(this);
			r->setPixmap(redled_off);
			y->setPixmap(yellowled_off);
			g->setPixmap(greenled_off);
			hl->addWidget(r);
			hl->addWidget(y);
			hl->addWidget(g);
	  	redLedOn=FALSE;
  		yellowLedOn=FALSE;
  		greenLedOn=FALSE;
			exclusive=TRUE;
}

ledBar::~ledBar()
{
}




void ledBar::setRedLed(bool b)
{
	if (redLedOn==b) return;
	redLedOn=b;
	if (redLedOn)
		{
			r->setPixmap(redled_on);
		}
	else
		{
			r->setPixmap(redled_off);
		}			
	if (exclusive&&b)
		{
			setYellowLed(FALSE);
			setGreenLed(FALSE);
		}
}


void ledBar::setYellowLed(bool b)
{
	if (yellowLedOn==b) return;
	yellowLedOn=b;
	if (yellowLedOn)
		{
			y->setPixmap(yellowled_on);
		}
	else
		{
			y->setPixmap(yellowled_off);
		}			
	if (exclusive&&b)
		{
			setRedLed(FALSE);
			setGreenLed(FALSE);
		}
}

void ledBar::setGreenLed(bool b)
{
	if (greenLedOn==b) return;
	greenLedOn=b;
	if (greenLedOn)
		{
			g->setPixmap(greenled_on);
		}
	else
		{
			g->setPixmap(greenled_off);
		}			
	if (exclusive&&b)
		{
			setRedLed(FALSE);
			setYellowLed(FALSE);
		}
}


void ledBar::toggleRedLed()
{
	setRedLed(!redLedOn);
}

void ledBar::toggleYellowLed()
{
	setYellowLed(!yellowLedOn);
}

void ledBar::toggleGreenLed()
{
	setGreenLed(!greenLedOn);
}



