/***************************************************************************
                          configfile.cpp  - QSSTV
                             -------------------
    begin                : Mon Sep 3 2001
    copyright            : (C) 2001 by johan maes
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "configfile.h"
#include "config.h"
#include <stdlib.h>
#include <fstream.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

configurationFile::configurationFile()
{
	optionList.setAutoDelete( TRUE );     // delete items when they are removed
	changed=FALSE;
}


int  configurationFile::processLine( QString &s,QString &OptN, QString &OptV)
{
  int pos,result;
  QString temp;
  temp=s.copy();  // uses deep copy while we will change s
  s=s.stripWhiteSpace(); // eliminate whitespaces at the beginning and the end
  if ((pos=s.find('#'))!=-1)
    {
		  s.truncate(pos);
			temp=temp.right(temp.length()-pos);  // temp contains comment
    }
  else
    {
      temp="";
    }
  if ((pos=s.find('='))!=-1)
    {
      OptN=s.left(pos);
      OptN=OptN.stripWhiteSpace(); // eliminate whitespaces at the beginning and the end
      OptV=s.right(s.length()-pos-1);
      OptV=OptV.stripWhiteSpace(); // eliminate whitespaces at the beginning and the end
      result=1;
      //	  cout <<" detected " << OptN << "..  "<< OptV <<std::endl;   // for debug
    }
  else
    {
      OptN="";
      OptV="";
      result=0;
    }
  s=temp;  // on return s contains comment
  return result;
}
/**
		
*/
configOption *configurationFile::optionCheck(QString OptN, QString OptV, bool toUpdate)
{
  configOption *co;
  for ( co=optionList.first(); co!= 0; co=optionList.next() )
    {
			if (OptN==co->name())
				{
					if (toUpdate==TRUE)
	   				{
	     				co->setvalstr(OptV);
	   				}
	 				co->setstored(TRUE);
	 				return co;
       }
    }
  return NULL;
} 

bool configurationFile::readFile (const char * name, const char *path,bool create)
{
#define BUFLEN 255
  char buff[BUFLEN+1];
  char ch;
  QFileInfo t;
  QDir ConfigDir;
  QString home;
  QString OptN;
  QString OptV;
  QString s;
  configOption *co;
  configFileName.setFile(name);

  if(path==NULL)
    {
      // try to find it in the local directory
      ConfigDir.setPath(getenv("PWD"));
      configFileName.setFile(ConfigDir,name);
      if (!configFileName.exists())
				{
	 			 //try to find it in the HOME directory
				  ConfigDir.setPath(getenv("HOME"));
	 				configFileName.setFile(ConfigDir,name);
				}
    }
  else
    {
      ConfigDir.setPath(path);
      configFileName.setFile(ConfigDir,name); 
    }
  if (!configFileName.exists())
    {
      //      debug("fn=%s",(const char *)configFileName.filePath());
      changed=TRUE;     
      ofstream inf(configFileName.filePath());
      inf.close(); //make one
      return TRUE;
    }
  ifstream inf(configFileName.filePath());
  do
    {
      // only accept registered values
      inf.get(buff,BUFLEN,'\n');
      inf.get(ch);     //get rid of the delimiter in the stream
      s=buff;
      if(processLine(s,OptN,OptV)==1) // 1 if valid option layout
				{
				  if(optionCheck (OptN,OptV,TRUE)==NULL)
						{
							if(create)
								{
									registerOption(OptN, OptV);   //register the option
								}
						}
				}      	
    }
  while(!inf.eof());

  for ( co=optionList.first(); co!= 0; co=optionList.next() )
    {
      if (co->IsStored()==FALSE)
				{
	  			changed=TRUE; // we have registered options that are not in the configfile
				}
    }
  inf.close();
  return TRUE;  
}


bool configurationFile::readOption(const char * s,int &i)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      i=co->getvali();
      return TRUE;
    }
  debug("%s - illegal read option",s);
  return FALSE;
}

bool configurationFile::readOption(const char * s,float &i)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      i=co->getvalf();
      return TRUE;
    }
  debug("%s - illegal read option",s);
  return FALSE;
}


bool configurationFile::readOption(const char * s,bool &b)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      b=(bool)co->getvalf();
      return TRUE;
    }
  debug("%s - illegal read option",s);
  return FALSE;
}

const char * configurationFile::readOption(const char * s)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      return (co->getvalstr());      
    }
  debug("%s - illegal read option",s);
  return NULL;
}

bool  configurationFile::saveFile()
{
 
#define BUFLEN 255  
  char buff[BUFLEN+1];
	int fd;
  char ch;
  char tn[]=PACKAGE "XXXXXX";

  QFileInfo tempname;
  QString OptN;
  QString OptV;
  QString s;
  configOption *co;
  fd=mkstemp(tn);
  tempname.setFile(tn);
	for ( co=optionList.first(); co!= 0; co=optionList.next() )
    {
    	co->setstored(FALSE);
    }
	ofstream of(tn);                            //use temp file as output
  if (of.fail())
  	{
  		return FALSE;
  	}
  ifstream inf(configFileName.filePath());    // use original configfile as input if exists
  if (!inf.fail())
    {

 			 do
    		{
      		inf.get(buff,BUFLEN,'\n');
      		inf.get(ch);     //get rid of the delimiter in the stream
      		s=buff;
      		if (inf.eof())
						{
	  					break;
						}
      		if (processLine(s,OptN,OptV)==0)
						{
	  					of<< s <<std::endl;   // simply store the comment
						}
      		else
						{
	  					if((co=optionCheck(OptN,OptV,FALSE))!=NULL)
	    					{
	      					of<< OptN << '=' << co->getvalstr() << ' ' << s <<std::endl;   // store valid option and comment
	   				 		}
	  					else
	    					{
	      					// invalid option
	      					of<< "#  *** invalid option *** " << OptN << '=' << OptV <<' '<<  s <<std::endl;
	    					}
						}
     		}
 		while(1);
		inf.close();
	}
	 // we will add option not stored yet
  for ( co=optionList.first(); co!= 0; co=optionList.next() )
    {
     if (!co->IsStored())
       {
				 of << co->name() <<"="<<co->getvalstr()<<std::endl;
       }
    }
  of.close();

  ifstream infa(tempname.filePath());
  if (infa.fail())
    {
      return FALSE;
    }
  ofstream ofa(configFileName.filePath());
  if (ofa.fail())
    {
			unlink(tn);
      infa.close();
      return FALSE;
    }
  do
    {
      infa.get(buff,BUFLEN,'\n');
      infa.get(ch);
      if (infa.eof())
				{
	  			break;
				}
       ofa<< buff << std::endl;   // simply copy
    }
  while (1);

  infa.close();
  ofa.close();
  unlink(tn);
  return TRUE;
}


void configurationFile::registerOption(const char *name, const char *def)
{
  optionList.append(new configOption(name,def));
}




void configurationFile::setOption(const char *s,const char *t)
{
 QString OptN;
 QString OptV;
 OptN=s;
 OptV=t;
 if(optionCheck (OptN,OptV,TRUE))
   {
     changed=TRUE;
   }
else
  {
  debug("%s - illegal set option",s);
  }     	 
}



void configurationFile::setOption(const char *s,int t)
{
 QString OptN;
 QString OptV;
 OptN=s; 
 OptV.setNum(t);
 if(optionCheck (OptN,OptV,TRUE))
   {
     changed=TRUE;
   }
 else
   {
     debug("%s - illegal set option",s);
   }     	       	 
}

void configurationFile::setOption(const char *s,bool b)
{
	if(b)
		{
			setOption(s,1);
		}
	else
		{
			setOption(s,0);
		}
}



void configurationFile::setOption(const char *s,float t)
{
 QString OptN;
 QString OptV;
 OptN=s; 
 OptV.setNum(t);
if(optionCheck (OptN,OptV,TRUE))
   {
     changed=TRUE;
   }
 else
   {
     debug("%s - illegal set option",s);
   }     	 
}


void configurationFile::initOptions(sConfigEntry *table,const char *name,const char *path)
{
  int i=0;
  while (table[i].name!=0)
    {
      registerOption(table[i].name,table[i].initialValue);
      i++;
    }
	if(name!=0)
		{
			readFile(name,path);
		}
   // readback config
  i=0;
  while (table[i].name!=0)
    {
      switch(table[i].type)
				{
				case FLOAT:
				   readOption(table[i].name,*(float *)table[i].variable);
				break;
				case BOOL:
				  readOption(table[i].name,*(bool *)table[i].variable);
				  break;
				case INT:
				  readOption(table[i].name,*(int *)table[i].variable);
				  break;
				default:
				break;
		 		}
   		i++;
    }
}

void configurationFile::saveActiveOptions(sConfigEntry *table)
{
	int i=0;
  while (table[i].name!=0)
    {
      switch(table[i].type)
				{
				case FLOAT:
				   setOption(table[i].name,*(float *)table[i].variable);
				break;
				case BOOL:
				   setOption(table[i].name,*(bool *)table[i].variable);
				  break;
				case INT:
				   setOption(table[i].name,*(int *)table[i].variable);
				  break;
				default:
				break;
		 		}
   		i++;
    }
   saveFile();
}


