/**********************************************************************************************
    Copyright (C) 2008 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CGARMINSTRTBL6_H
#define CGARMINSTRTBL6_H

#include "IGarminStrTbl.h"

class CGarminStrTbl6 : public IGarminStrTbl
{
    public:
        CGarminStrTbl6(const quint16 codepage, const quint8 mask, QObject * parent);
        virtual ~CGarminStrTbl6();

        void get(QFile& file, quint32 offset, type_e t, QStringList& info);

    private:
        static const char str6tbl1[];
        static const char str6tbl2[];
        static const char str6tbl3[];

        void fill();
        /// temp shift reg buffer
        quint32 reg;
        /// bits in buffer
        quint32 bits;
        /// pointer to current data;
        const quint8 * p;

};
#endif                           //CGARMINSTRTBL6_H
