/***************************************************************************
 *   Copyright (C) 2007 by Κωνσταντίνος Σμάνης   *
 *   kon.smanis@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation                                              *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301 USA                                             *
 ***************************************************************************/

#include <QApplication>
#include <QFile>
#include <QDir>
#include <QTextStream>
#include <QString>
#include <QMessageBox>
#include <QProcess>
#include <QStringList>

#include "qgrubeditor.h"
#include "lib/filetransactions.h"
#include "config.h"

int main( int argc, char **argv )
{
	QFile lockFile( QDir::tempPath() + "/qgrubeditor.lock" );
	if ( lockFile.open( QIODevice::ReadOnly ) )
	{
		QTextStream lockStream( &lockFile );
		if ( QDir( "/proc/" + lockStream.readLine() ).exists() )
		{
			qWarning( "QGRUBEditor: Already running" );
			return 0;
		}
		lockFile.close();
	}
	if ( lockFile.open( QIODevice::WriteOnly | QIODevice::Truncate ) )
	{
		QTextStream lockStream( &lockFile );
		lockStream << getpid() << endl;
		lockFile.close();
	}

	QApplication app( argc, argv );
	QCoreApplication::setOrganizationName( "QGRUBEditor" );
	QCoreApplication::setOrganizationDomain( "qgrubeditor.sourceforge.net" );
	QCoreApplication::setApplicationName( "QGRUBEditor" );

	Config *config = new Config();
	if ( FileTransactions::definePermissions( config->settings.menulst, config->settings.devicemap, config->settings.mtab ) )
	{
		if ( config->settings.firstrun )
		{
			QMessageBox::information( 0, "Tip", "Every time QGRUBEditor accesses a file, it automatically creates a backup, so as to prevent data loss. The backup file will always be named just like the original with a '_original' suffix. To restore the original file use the built-in feature of QGRUBEditor of Restoring from a Backup.", QMessageBox::Ok );
			config->settings.firstrun = false;
			config->writeValue( "other/firstrun", config->settings.firstrun );
		}
		QGRUBEditor *main_window = new QGRUBEditor();
		main_window->show();
		app.connect( &(app), SIGNAL( lastWindowClosed() ), &(app), SLOT( quit() ) );
		return app.exec();
	}
	else
	{
		QMessageBox::warning( 0, "Warning!", QString( "QGRUBEditor was unable to have read/write access to one of the following files:\n\n%1\n%2\n%3\n\nThis happened either because you haven't granted QGRUBEditor root permissions or because these files don't exist (maybe you accidentally deleted them?) QGRUBEditor will now try to automatically start the application with root permissions but it is not guaranteed that it will be successful. If it fails, you should try to manually run it with root permission using one of the following commands:\n\nkdesu " + QCoreApplication::applicationFilePath() + " (if you use KDE)\ngksu " + QCoreApplication::applicationFilePath() + " (if you use GNOME)\nsudo " + QCoreApplication::applicationFilePath() + " (if you use any other Desktop Enviroment).").arg( config->settings.menulst ).arg( config->settings.devicemap ).arg( config->settings.mtab ), QMessageBox::Ok );
		if ( QFile::exists( "/usr/bin/kdesu" ) )
		{
			QProcess process;
			process.startDetached( "kdesu", QStringList() << QCoreApplication::applicationFilePath() );
			process.waitForStarted();
		}
		else
		{
			QProcess process;
			process.start( "gksu", QStringList() << QCoreApplication::applicationFilePath() );
			process.waitForStarted();
		}
	}
	delete config;
}
