/***************************************************************************
 *   Copyright (C) 2007 by Κωνσταντίνος Σμάνης   *
 *   kon.smanis@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation                                              *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301 USA                                             *
 ***************************************************************************/

#include "encrypt.h"

Encrypt::Encrypt( QWidget* parent ) : QDialog( parent )
{
	setupUi( this );

	connect( lineEdit_password, SIGNAL( cursorPositionChanged ( int, int ) ), this, SLOT( check() ) );
	connect( lineEdit_password_2, SIGNAL( cursorPositionChanged ( int, int ) ), this, SLOT( check() ) );

	connect( pushButton_OK, SIGNAL( pressed() ), this, SLOT( accept() ) );
	connect( pushButton_cancel, SIGNAL( pressed() ), this, SLOT( reject() ) );
	connect( this, SIGNAL( accepted() ), this, SLOT( OK() ) );
	connect( this, SIGNAL( rejected() ), this, SLOT( cancel() ) );

	check();
}

void Encrypt::check()
{
	if ( lineEdit_password->text().length() >= 3 )
	{
		if ( lineEdit_password->text() == lineEdit_password_2->text() )
		{
			label_status->setText( tr( "Passwords match." ) );
			pushButton_OK->setEnabled( true );
		}
		else
		{
			label_status->setText( tr( "Passwords do not match." ) );
			pushButton_OK->setEnabled( false );
		}
	}
	else
	{
		label_status->setText( tr( "Password must be at least 3 characters long." ) );
		pushButton_OK->setEnabled( false );
	}
}
void Encrypt::OK()
{
	QByteArray password;
	password.append( lineEdit_password->text() + QString( "\n" ) );

	QProcess md5;
	md5.start( "grub-md5-crypt" );
	md5.waitForStarted();
	md5.write( password );
	md5.write( password );
	md5.closeWriteChannel();
	md5.waitForFinished();

	QString result = md5.readAll();
	result = result.section( "\n", 2 ).trimmed();

	QClipboard *clipboard = QApplication::clipboard();
	clipboard->setText( result, QClipboard::Selection );

	QMessageBox::information( this, tr( "Result" ), QString( tr( "Encrypted password is: %1\n\n(Password was automatically copied to clipboard)" ) ).arg( result )  );
}
void Encrypt::cancel()
{
	QClipboard *clipboard = QApplication::clipboard();
	clipboard->setText( QString(), QClipboard::Selection );
}
