/****************************************************************************
 * ** $Id: qt/structureparser.h   3.3.3   edited May 27 2003 $
 * **
 * ** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
 * **
 * ** This file is part of an example program for Qt.  This example
 * ** program may be used, distributed and modified without limitation.
 * **
 * *****************************************************************************/

/*	Carles Pina i Estany <carles@pinux.info> 2005, 2006
	GPL Licensed
*/

#ifndef STRUCTUREPARSER_H
#define STRUCTUREPARSER_H

#include <qxml.h>
#include <qptrqueue.h> 
#include "worddata.h"
    

class QString;

class StructureParser : public QXmlDefaultHandler
{
public:
    bool startDocument();
    bool startElement( const QString&, const QString&, const QString& ,
                       const QXmlAttributes& attributes);
    bool endElement( const QString&, const QString&, const QString& );
    bool characters ( const QString & ch );
    void setParaula(const QString &s);
    void setPdebug(int i);
    WordData getWordData();
    int ensenyarLlistat();
    QPtrQueue<QString> getWordQueue();
    bool esBuida();
    QString seguent();

private:
    bool entrada,translation,catexamp,engexamp,tipus,example;
    bool trobat;
    QString paraula,definicio,qcatexamp,qengexamp;
    QString qtipus,qgender,qgender_,qtipus_;
    WordData wd;
    int pdebug;
    //QString *temp;

    QPtrQueue<QString> wordqueue;
    int after_word;
};

#endif
