   #include "StructureParser.h"

   #include <stdio.h>
   #include <qstring.h>  

/*	Carles Pina i Estany <carles@pinux.info> 2005, 2006
	GPL Licensed
*/
    int pdebug_;

    bool StructureParser::startDocument()
    {
	wd.setPdebug(pdebug_);
   //     WordDataQueue queuelist(10);
   	wordqueue.setAutoDelete(TRUE); 
	after_word = 0;
	return TRUE;
    }

    bool StructureParser::startElement( const QString&, const QString&,
                                        const QString& qName,
                                        const QXmlAttributes& attributes)
    {
        //printf( "%s%s\n", (const char*)indent, (const char*)qName );
	//	gender=attributes.value("gender");
	//To avoid else blocks, we initialize everything to FALSE

	catexamp=FALSE; engexamp=FALSE;
	entrada=FALSE; translation=FALSE;
	example=FALSE;
	
	if (qName=="catexamp") {
		catexamp=TRUE;
	}

	if (qName=="engexamp") {
		engexamp=TRUE;
	}

	if (qName=="example") {
		example=TRUE;
	}
		
	//printf("Atribut 0 nom: %s\n", (const char*)attributes.qName(0));
	//printf("Atribut 0 valor: %s\n", (const char*)attributes.value(0));
	//printf("Atribut 0 valor: %s\n", (const char*)attributes.value(""));

	qgender_=attributes.value("gender");	

	if (qName == "Entry") {
		entrada = TRUE;
	}

	if (qName == "translation") {
		translation = TRUE;
	}
	if (qName == "adjectives") {qtipus_="adj";}
	if (qName == "adverbs") {qtipus_="adv";}
	if (qName == "exclamations") {qtipus_="excl";}
	if (qName == "nouns") {qtipus_="n";}
	if (qName == "prepositions") {qtipus_="prep";}
	if (qName == "pronouns") {qtipus_="pron";}
	if (qName == "verbs") {qtipus_="v";}


        return TRUE;
    }

    bool StructureParser::endElement( const QString&, const QString&, const QString& qName)
    {
	//printf("END ELEMENT: %s\n",(const char*)qName);
     	if (trobat && qName=="translation") {
		wd.incNum();
		if (pdebug_) printf("Apujo incNum\n");
	}	
	if (trobat && qName=="Entry") {	//ja sortim de la paraula
		trobat=FALSE;
	}
	return TRUE;
    }

bool StructureParser::characters ( const QString & ch ) {
	if (entrada) {
		//printf("Ara he mirat: _%s_\n",(const char*)ch);
		//QString *temp = new QString(ch);
		//QString *hola = &ch;
		
		if (after_word <= 10) {
			//Llista wordqueue.append(new QString(ch));
			wordqueue.enqueue(new QString(ch));
		}

		if (wordqueue.count()>20) {
			wordqueue.remove();
		}

		if (ch.localeAwareCompare(paraula)>0) {
			after_word++;
		}
	}

	if (entrada && ch==paraula) {
		trobat=TRUE;
		//definicio=ch;
	}
	
	if (entrada && ch!=paraula) {
		trobat=FALSE;
	}

	if (trobat && catexamp) {
		wd.putCatexamp(ch);	//potser s'hauria d'afegir!
		//qcatexamp=qcatexamp+ch;
		//printf("Qcatexamp: %s\n",(const char*)ch);
	}

	if (trobat && engexamp) {
		wd.putEngexamp(ch);
		//qengexamp=qengexamp+ch;
		//printf("Qengexamp: %s\n",(const char*)ch);
	}

	if (trobat && example) {
		wd.putExample(ch);
	}

	
	if (trobat && translation) {	//Error: why ch!="" ???
		if (pdebug_) printf("Def _%s_\n",(const char*)ch);
		//definicio=ch;
		wd.putDefinition(ch);
   	
		wd.putGender(qgender_);
		wd.putTipus(qtipus_);

		//printf("Gender: %s\n",(const char*)qgender_);	
		//trobat=FALSE;
	
		}

	    return TRUE;

    }

   void StructureParser::setParaula(const QString &s) {
		paraula=s;
   }

   WordData StructureParser::getWordData() {
 		return wd;
   }

   void StructureParser::setPdebug(int i) {
		pdebug_=i;
   }

   int StructureParser::ensenyarLlistat() {
		/*Llista:
		QPtrListIterator<QString> it(wordqueue);

		for (it.toLast();it.current();--it) {
			QString *t = it.current();
			printf("Llista: %s\n",(const char*)*t);
		}
		return 0;
		*/
	        //Cua:
		while (!wordqueue.isEmpty()) {
			printf("Llista: %s\n",(const char*)*wordqueue.head());
			wordqueue.remove();
		}
		return 0;
   }

   QPtrQueue<QString> StructureParser::getWordQueue() {
	return wordqueue;
   }

   bool StructureParser::esBuida() {
	   return wordqueue.isEmpty();
   }

   QString StructureParser::seguent() {
	   QString ret = *wordqueue.head();
	   wordqueue.remove();
	   return ret;
   }
