/***************************************************************************
                          joystickenv.cpp  -  description
                             -------------------
    begin                : Sun Nov  7 16:54:22 CET 2007
    copyright            : (C) 2007 by Harald Krippel
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 #include "joystickenv.hpp"
 
 JoystickEnv * JoystickEnv::theInstancePtr = 0;
// constructor
JoystickEnv::JoystickEnv (QObject *parent): QObject(parent)
{

}

// destructor
JoystickEnv::~JoystickEnv ()
{

}

JoystickEnv * JoystickEnv::theInstance(QObject *parent) {
    if (theInstancePtr == 0) {
        theInstancePtr = new JoystickEnv(parent);
	theInstancePtr->Init();
    }
    return theInstancePtr;
}
// init
void JoystickEnv::Init ()
{
   
  joystick[0] = new jsJoystick ( 0 ) ;
  joystick[1] = new jsJoystick ( 1 ) ;
  if ( joystick[0] -> notWorking () || joystick[0] -> getNumAxes () < 2 ){
    qWarning("No Joystick 1 found");
  }else{
    qWarning("Joystick 1 OK");
  }
  if ( joystick[1] -> notWorking () || joystick[1] -> getNumAxes () < 2 ){
    qWarning("No Joystick 2 found");
  }else{
    qWarning("Joystick 2 OK");
  }
}
void JoystickEnv::update()
{
  if ( !joystick[0] -> notWorking ())
  {
    joystick[0] -> read ( &buttons[0], axis[0] ) ;
  }
  if ( !joystick[1] -> notWorking () )
  {
    joystick[1] -> read ( &buttons[1], axis[1] ) ;
  }  
}

float JoystickEnv::getAxis(int j,int x)
{
   if(j >= 0 && j < 2 && x >= 0 && x < 8)
    return(axis[j][x]);
   else
    return(0);
}

 int   JoystickEnv::getButtons(int j)
{
   if(j >= 0 && j < 2)
    return(buttons[j]);
   else
    return(0);
}
