//
// C++ Implementation: qtscriptPrg
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "qtscript_prg.hpp"

#include <main.h>
#include "scripting.hpp"
#include "scriptprg.hpp"
#include "messages.hpp"


qtscriptPrg::qtscriptPrg(const QString & program)
 : scriptPrg()
{
     prgname = program;
     ScriptApi=QcakeScriptApi::theInstance();
     QScriptValue objectValue = engine.newQObject(ScriptApi);
     engine.globalObject().setProperty("QCakeApi", objectValue);
//     engine.setProcessEventsInterval ( 100 );  // dont work for me ??
}


qtscriptPrg::~qtscriptPrg()
{
}

int qtscriptPrg::compile(void)
{
  return run();
}

int qtscriptPrg::run(void)
{
 if(on==1){
    // load the standard js qcake library
    if(runFile(g_prjpath + "/data/js_stdlib.js")){
        return 1;
    }
    if(runFile(prgname)){
        return 1;
    }
  }
  return 0;
}

int qtscriptPrg::runFile(const QString &prgfile)
{
  QFile scriptFile(prgfile);
  scriptFile.open(QIODevice::ReadOnly);
  QScriptValue result = engine.evaluate(scriptFile.readAll());
  if (engine.hasUncaughtException()) {
     int line = engine.uncaughtExceptionLineNumber();
     qDebug() << prgfile << ":uncaught exception at line " << line << ":" << result.toString();
     QString msg;
     QTextStream(&msg) << prgfile << ":uncaught exception at line " << line << ":" << result.toString() << "\n";
     ErrorMsg errormsg(msg);
     scriptFile.close();
     return 1;
  }
  scriptFile.close();
  return 0;
}

void qtscriptPrg::update(void)
{
 if(on==1){
   QScriptValue result = engine.evaluate("update()");
   if (engine.hasUncaughtException()) {
      int line = engine.uncaughtExceptionLineNumber();
      qDebug() << prgname << ":uncaught exception at line " << line << ":" << result.toString();
      QString msg;
      QTextStream(&msg) << prgname << ":uncaught exception at line " << line << ":" << result.toString() << ".  Script stopped.\n";
      ErrorMsg errormsg(msg);
      TurnOff();
   }
 }
}
