/***************************************************************************
  view.h
  -------------------
  View class for QBrew
  -------------------
  begin         12/16/2001
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999-2002, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  3. Neither name of the copyright holders nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef VIEW_H
#define VIEW_H

#include <qwidget.h>

class QBoxLayout;
class QCheckBox;
class QComboBox;
class QFrame;
class QGridLayout;
class QGroupBox;
class QLabel;
class QLineEdit;
class QTabWidget;

class FixedSpinBox;
class GrainPage;
class HopsPage;
class MiscPage;
class NotePage;

class Controller;
class Model;

class View : public QWidget {
    Q_OBJECT
 public:
    // constructor
    View(Controller *controller=0, Model *model=0);
    // destructor
    ~View();
    
    // Document has changed
    void viewModified();
    
    // set a combo box to the text
    static void setComboItem(QComboBox *combo, const QString &txt);

 public slots:
    // set the recipe title
    void setTitle(const QString &title);
    // set the recipe style
    void setStyle(const QString &style);
    // set the brewer name
    void setBrewer(const QString &brewer);
    // set the recipe size
    void setSize(double size);
    // set mashed / unmashed
    void setMash(bool mash);

 private:
    // initialize layouts
    void initLayouts();
    // initialize widgets
    void initWidgets();

    // update the style box
    void updateStyle();

private:
    Controller *controller_;
    Model *model_;

    QBoxLayout* mainlayout_;
    QGridLayout* recipelayout_;
    QGridLayout* stylelayout_;

    QLabel* titlelabel_;
    QLineEdit* titleedit_;
    QLabel* stylelabel_;
    QComboBox* stylecombo_;
    QLabel* brewerlabel_;
    QLineEdit* breweredit_;
    QCheckBox* mashcheck_;
    QLabel* sizelabel_;
    FixedSpinBox* sizespin_;
    
    QGroupBox* stylebox_;
    QLabel* ogminimum_;
    QLabel* ogmaximum_;
    QLabel* ogrecipe_;
    QLabel* ibuminimum_;
    QLabel* ibumaximum_;
    QLabel* iburecipe_;
    QLabel* srmminimum_;
    QLabel* srmmaximum_;
    QLabel* srmrecipe_;
    QFrame* vertseparator_;
    QLabel* finalgravity_;
    QLabel* alcoholbyvol_;
    QLabel* alcoholbywgt_;

    QTabWidget* ingredienttab_;
    GrainPage* grainpage_;
    HopsPage* hoppage_;
    MiscPage* miscpage_;
    NotePage* notepage_;
};

#endif // VIEW_H

