/***************************************************************************
  main.cpp
  -------------------
  A brewing recipe calculator for Unix/X11
  -------------------
  Copyright 1999-2002, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  3. Neither the name of the author nor the names of the contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
****************************************************************************/

#include <cstdlib>
#include <iostream>

#include <qapplication.h>
#include <qdir.h>
#include <qstring.h>

#include "calc.h"
#include "controller.h"
#include "model.h"
#include "preferences.h"
#include "resource.h"

using namespace std;
using namespace AppResource;
using namespace CalcResource;

// TODO: put in Qt options in dohelp()
// TODO: implement session management
// TODO: splash screen ?

//////////////////////////////////////////////////////////////////////////////
// doversion()
// -----------
// Print out copyright and version info to stdout

void doversion()
{
    cout << PACKAGE << ' ' << VERSION << '\n';
    cout << ID_DESCRIPTION << '\n';
    cout << ID_COPYRIGHT << ' ' << ID_AUTHOR << " <" << ID_AUTHOR_EMAIL << ">\n";
}

//////////////////////////////////////////////////////////////////////////////
// dohelp()
// --------
// Print out help info to stdout

void dohelp()
{
    cout << "Usage: " << PACKAGE << " [options] [file]\n";

    // general options
    cout << "\nGeneral Options\n\n";
    cout << "file\n";
    cout << "    Open the specified file in QBrew\n";
    cout << "-help\n";
    cout << "    Print the command line options.\n";
    cout << "-version\n";
    cout << "    Print the version number of QBrew.\n";
    cout << endl;

    // misc options
    cout << "Miscellaneous Options\n\n";
    cout << "    These are options for the Qt library and the X Windows System.\n";
    cout << "-style=style\n";
    cout << "    Sets the application GUI style. Possible values are cde, motif,\n";
    cout << "    motifplus, platinum, sgi and windows. Note that this option has\n";
    cout << "    no effect if a style other than 'default' was selected in the\n";
    cout << "    options menu\n";
    cout << "-display display\n";
    cout << "    Sets the X display (default is $DISPLAY).\n";
    cout << "-geometry geometry\n";
    cout << "    Sets the client geometry of the main widget.\n";
    cout << "-fn or -font font\n";
    cout << "    Defines the application font.\n";
    cout << "-bg or -background color\n";
    cout << "    Sets the default background color and an application palette\n";
    cout << "    (light and dark shades are calculated).\n";
    cout << "-fg or -foreground color\n";
    cout << "    Sets the default foreground color.\n";
    cout << "-btn or -button color\n";
    cout << "    Sets the default button color.\n";
    cout << "-visual TrueColor\n";
    cout << "    Forces the application to use a TrueColor visual on an 8-bit\n";
    cout << "    display.\n";
    cout << "-cmap\n";
    cout << "    Causes the application to install a private color map on an 8-bit\n";
    cout << "    display.\n";
    cout << "-name name\n";
    cout << "    Sets the application name.\n";
    cout << endl;

    // bug reports
    cout << "Report bugs to <" << PACKAGE_BUGREPORT << ">" << endl;

}

//////////////////////////////////////////////////////////////////////////////
// doargs()
// --------
// Process command line arguments that QApplication doesn't take care of

QString doargs(int argc, char **argv)
{
    for (int n=1; n<argc; n++) {
        QString arg = argv[n];
        // detect all common forms of help requests
        if ((arg.lower() == "-h") || (arg == "-help") ||
            (arg == "--help") || (arg == "-?")) {
            dohelp();
            exit(0);
        } else if ((arg.lower() == "-v") || (arg == "-version") ||
                   (arg == "--version")) {
            doversion();
            exit(0);
        } else if (arg[0] == '-') {
            // no other valid options
            cout << "Invalid parameter \"" << arg << "\"\n";
            dohelp();
            exit(1);
        } else {
            // must be a filename
            return arg;
        }
    }
    return (AppResource::ID_DEFAULT_FILE);
}

//////////////////////////////////////////////////////////////////////////////
// main()
// ------
// Entry point of application

// TODO: figure out executable path under win32
// From the command line I will have full path in argv[0], but launched
// from the GUI I am relying on currentDirPath(), which is not good...
// need something like [QFileInfo( qtapp->argv()[0] ).absFilePath()]

int main(int argc, char ** argv)
{
    QApplication app(argc, argv);

    // check for additional command line options before we go further
    QString filename = doargs(app.argc(), app.argv());

    Controller* controller = Controller::instance();
    controller->initialize(filename);
    app.setMainWidget(controller);
    controller->setCaption(AppResource::ID_TITLE + " " +  VERSION);

    controller->show();
    QObject::connect(qApp, SIGNAL(lastWindowClosed()), qApp, SLOT(quit()));
    return app.exec();
}
