/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "ruleeditor.h"
#include "transfinder.h"
#include "app.h"

#include <qbanking/qbanking.h>

#include <qpushbutton.h>
#include <qlistview.h>
#include <qmessagebox.h>



RuleEditor::RuleEditor(QWidget* parent,
                       const char* name,
                       WFlags fl)
:RuleEditorUi(parent, name, fl)
,_app(0), _dbRules(0), _tfFlags(0) {

}



RuleEditor::~RuleEditor() {
  GWEN_DB_Group_free(_dbRules);
}



void RuleEditor::init(KBanking *kb, GWEN_DB_NODE *dbRules,
                      bool readOnly,
                      uint32_t tfFlags) {
  assert(kb);
  assert(dbRules);

  _app=kb;
  _dbRules=GWEN_DB_Group_dup(dbRules);
  _tfFlags=tfFlags;

  matchList->setEnabled(!readOnly);
  delRuleButton->setEnabled(!readOnly);
  addRuleButton->setEnabled(!readOnly);
  editRuleButton->setEnabled(!readOnly);

  QObject::connect(addRuleButton, SIGNAL(clicked()),
                   this, SLOT(slotAddRule()));
  QObject::connect(delRuleButton, SIGNAL(clicked()),
                   this, SLOT(slotDelRule()));
  QObject::connect(editRuleButton, SIGNAL(clicked()),
                   this, SLOT(slotEditRule()));

  _updateRules();
}



GWEN_DB_NODE *RuleEditor::getRules() const {
  return _dbRules;
}



void RuleEditor::setRules(GWEN_DB_NODE *dbRules) {
  assert(dbRules);
  GWEN_DB_Group_free(_dbRules);
  _dbRules=GWEN_DB_Group_dup(dbRules);
  _updateRules();
}



void RuleEditor::slotDelRule() {
  int idx=0;
  QListViewItemIterator it(matchList);
  GWEN_DB_NODE *dbT;

  assert(_app);

  for (;it.current();++it) {
    if (it.current()->isSelected()) {
      idx=it.current()->text(0).toInt();
      break;
    }
  } // for
  if (!idx) {
    QMessageBox::warning(this,
                         tr("No Selection"),
                         tr("Please select a rule first."),
                         tr("Dismiss"), QString::null);
    return;
  }

  dbT=GWEN_DB_FindFirstGroup(_dbRules, "rule");
  while(dbT && --idx)
    dbT=GWEN_DB_FindNextGroup(dbT, "rule");

  assert(dbT);
  if (QMessageBox::warning(this,
			   tr("Delete Rule"),
			   tr("Do you really want to remove this rule?"),
			   QMessageBox::Yes, QMessageBox::No)
      !=QMessageBox::Yes) {
    return;
  }

  GWEN_DB_UnlinkGroup(dbT);
  GWEN_DB_Group_free(dbT);
  _updateRules();
}



void RuleEditor::slotAddRule() {
  GWEN_DB_NODE *dbRule;

  assert(_app);

  dbRule=GWEN_DB_Group_new("rule");
  GWEN_DB_SetIntValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "data/account/allAccounts", 1);

  if (TransactionFinder::editRule(_app,
                                  dbRule,
                                  tr("Create Payee Matching Rule"),
                                  _tfFlags,
                                  this)) {
    GWEN_DB_AddGroup(_dbRules, dbRule);
    _updateRules();
  }
  else {
    GWEN_DB_Group_free(dbRule);
  }
}



void RuleEditor::slotEditRule() {
  GWEN_DB_NODE *dbT;
  int idx=0;
  QListViewItemIterator it(matchList);

  assert(_app);

  for (;it.current();++it) {
    if (it.current()->isSelected()) {
      idx=it.current()->text(0).toInt();
      break;
    }
  } // for
  if (!idx) {
    QMessageBox::warning(this,
                         tr("No Selection"),
                         tr("Please select a rule first."),
                         tr("Dismiss"), QString::null);
    return;
  }

  dbT=GWEN_DB_FindFirstGroup(_dbRules, "rule");
  while(dbT && --idx)
    dbT=GWEN_DB_FindNextGroup(dbT, "rule");

  assert(dbT);

  if (TransactionFinder::editRule(_app,
                                  dbT,
                                  tr("Edit Payee Matching Rule"),
                                  _tfFlags,
                                  this)) {
    DBG_DEBUG(0, "EditRule: Accepted");
    //GWEN_DB_Dump(dbT, stderr, 2);
    _updateRules();
  }
  else {
    DBG_DEBUG(0, "EditRule: Rejected");
  }

}



QString RuleEditor::_ruleToShort(GWEN_DB_NODE *dbRule) {
  const char *op;
  const char *arg;
  QString rs;

  op=GWEN_DB_GetCharValue(dbRule, "data/payee/compare/operation", 0, 0);
  arg=GWEN_DB_GetCharValue(dbRule, "data/payee/compare/argument", 0, 0);
  if (op && arg) {
    TEXTMATCHER_OPERATION numop;

    rs+=tr("Payee: ");
    numop=App::string2TextMatcherOperation(op);
    switch(numop) {
    case TextMatcherOperation_Equals:
      rs+=tr("equals");
      break;
    case TextMatcherOperation_EqualsNot:
      rs+=tr("does not equal");
      break;
    case TextMatcherOperation_Contains:
      rs+=tr("contains");
      break;
    case TextMatcherOperation_ContainsNot:
      rs+=tr("does not contain");
      break;
    case TextMatcherOperation_MatchesRegExp:
      rs+=tr("matches regular expression");
      break;
    case TextMatcherOperation_MatchesRegExpNot:
      rs+=tr("does not match regular expression");
      break;
    default:
      rs+="??";
    }
    rs+=" ";
    rs+=QString::fromUtf8(arg);
  }

  op=GWEN_DB_GetCharValue(dbRule, "data/text/compare/operation", 0, 0);
  arg=GWEN_DB_GetCharValue(dbRule, "data/text/compare/argument", 0, 0);
  if (op && arg) {
    TEXTMATCHER_OPERATION numop;

    if (!rs.isEmpty())
      rs+=" ";
    rs+=tr("Text: ");
    numop=App::string2TextMatcherOperation(op);
    switch(numop) {
    case TextMatcherOperation_Equals:
      rs+=tr("equals");
      break;
    case TextMatcherOperation_EqualsNot:
      rs+=tr("does not equal");
      break;
    case TextMatcherOperation_Contains:
      rs+=tr("contains");
      break;
    case TextMatcherOperation_ContainsNot:
      rs+=tr("does not contain");
      break;
    case TextMatcherOperation_MatchesRegExp:
      rs+=tr("matches regular expression");
      break;
    case TextMatcherOperation_MatchesRegExpNot:
      rs+=tr("does not match regular expression");
      break;
    default:
      rs+="??";
    }
    rs+=" ";
    rs+=QString::fromUtf8(arg);
  }

  return rs;
}



void RuleEditor::_updateRules() {
  GWEN_DB_NODE *dbT;
  int i;

  i=0;
  matchList->clear();
  dbT=GWEN_DB_FindFirstGroup(_dbRules, "rule");
  while(dbT) {
    QListViewItem *lvi;

    lvi=new QListViewItem(matchList, QString::number(++i), _ruleToShort(dbT));
    dbT=GWEN_DB_FindNextGroup(dbT, "rule");
  }
}






