/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: selectpayee.h 406 2007-04-30 18:13:29Z martin $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_SELECTPAYEE_H
#define AQBANKING_KDE_SELECTPAYEE_H

class KBanking;
class Payee;
class Transaction;
class QListViewItem;


#include "selectpayee.ui.h"

#include <string>



class SelectPayee : public SelectPayeeUi {
  Q_OBJECT
public:
  SelectPayee(KBanking *kb,
              Transaction *t,
              QWidget* parent=0,
              const char* name=0,
              bool modal=FALSE,
              WFlags fl=0);
  ~SelectPayee();

  void init();
  void fini();

  Payee *selectedPayee();

  static Payee *selectPayee(KBanking *kb,
                            const QString &title,
                            const QString &text,
                            QWidget* parent=0);

  static Payee *assignPayee(KBanking *kb,
                            Transaction *t,
                            bool &aborted,
                            bool &askNoMore,
                            QWidget* parent=0);
  static Payee *assignSinglePayee(KBanking *kb,
                                  Transaction *t,
                                  bool &aborted,
                                  QWidget* parent);

public slots:
  void slotAssignSelected();
  void slotNew();
  void slotAbort();
  void slotEdit();
  void slotDoubleClicked(QListViewItem *lvi,
			 const QPoint &, int);


private:
  KBanking *_app;
  Payee *_payee;
  Transaction *_transaction;
  bool _aborted;
};





#endif
