/***************************************************************************
 $RCSfile: transfinder.h,v $
                             -------------------
    cvs         : $Id: transfinder.h,v 1.11 2006/01/27 08:33:20 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_TRANSFINDER_H
#define AQBANKING_KDE_TRANSFINDER_H

class KBanking;
class CategoryListViewItem;


#define TRANSFINDER_FLAGS_USE_CATEGORY 0x00000001
#define TRANSFINDER_FLAGS_EXT_PAYEES   0x00000002


#include "transfinder.ui.h"
#include "accountlist.h"
#include "categorylist.h"
#include "transactionlist.h"
#include "payeelist.h"

#include <gwenhywfar/db.h>
#include <gwenhywfar/types.h>


class TransactionFinder: public TransactionFinderUI {
  Q_OBJECT
private:
  KBanking *_app;
  GWEN_DB_NODE *_dbRules;
  GWEN_DB_NODE *_dbRule;
  const char *_ruleName;
  bool _activeRule;
  bool _modifying;
  CategoryListViewItem *_currentCategoryItem;
  GWEN_TYPE_UINT32 _flags;
  QString _helpContext;

  bool _fromDb(GWEN_DB_NODE *db);
  bool _toDb(GWEN_DB_NODE *db, bool showErrors);
  void _resetRule();
  bool _saveRule(bool showErrors=true);
  void _addRule(GWEN_DB_NODE *db);

  void _catSelectBranch(QListViewItem *p, bool on);

public:
  TransactionFinder(KBanking *kb,
                    GWEN_DB_NODE *dbRules,
                    const char *ruleName,
                    GWEN_TYPE_UINT32 flags,
		    QWidget* parent=0,
		    const char* name=0,
		    bool modal=FALSE,
		    WFlags fl=0);
  virtual ~TransactionFinder();

  static bool editRule(KBanking *kb,
                       GWEN_DB_NODE *dbRule,
                       const QString &title,
                       GWEN_TYPE_UINT32 flags,
                       QWidget* parent,
                       WFlags fl=0);

  static bool selectTransactions(KBanking *kb,
                                 std::list<RefPointer<Transaction> >*tl,
                                 const QString &title,
                                 GWEN_TYPE_UINT32 flags,
                                 QWidget* parent,
                                 WFlags fl=0);

  bool init();
  bool fini();

  void accept();
  void reject();

  std::list<RefPointer<Transaction> > getMatchingTransactions();
  GWEN_DB_NODE *getRules();
  GWEN_DB_NODE *getRule();

public slots:
  void slotRuleActivated(int idx);
  void slotRefreshClicked();
  void slotResetClicked();
  void slotNewRuleClicked();
  void slotDeleteRuleClicked();
  void slotSaveRuleClicked();

  void slotAccountSelectionChanged();
  void slotAllAccountCheckToggled(bool on);

  void slotDateRangeActivated(int idx);

  void slotAnyAmountRadioToggled(bool on);
  void slotThisAmountRadioToggled(bool on);
  void slotRangeAmountRadioToggled(bool on);
  void slotLessAmountRadioToggled(bool on);
  void slotMoreAmountRadioToggled(bool on);

  void slotPayeeSelectionChanged();
  void slotAllPayeeCheckToggled(bool on);

  void slotAllCategoryCheckToggled(bool on);
  void slotCategoryContextMenuRequested(QListViewItem *lvi,
                                        const QPoint &coord,
                                        int column);
  void slotCategorySelectionChanged();

  void slotCatContextSelectEntry();
  void slotCatContextSelectBranch();
  void slotCatContextSelectAll();

  void slotHelp();
};






#endif
