# common.py --- Python interface to libxmms -- common module.
# Copyright (c) 2002, 2003 Florent Rougon
#
# This file is part of PyXMMS.
#
# PyXMMS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# PyXMMS is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING. If not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
# MA 02111-1307, USA.

"""Python interface to XMMS --- common module.

This module is part of PyXMMS and contains objects to share between
other modules in the xmms package, most interestingly the 'error'
generic exception.

It also provides 'PyXMMSGenericException' as an alias for 'error' to
preserve backward-compatibility, but its use is deprecated.

"""

class error(Exception):
    """Base class for exceptions in the xmms package."""
    def __init__(self, message=None):
        self.message = message
    def __str__(self):
        return "<%s: %s>" % (self.__class__.__name__, self.message)
    def complete_message(self):
        if self.message:
            return "%s: %s" % (self.ExceptionShortDescription, self.message)
        else:
            return "%s" % self.ExceptionShortDescription
    ExceptionShortDescription = "PyXMMS generic exception"

# For backward-compatibility
PyXMMSGenericException = error
